/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.cli;

import htsjdk.samtools.ValidationStringency;
import java.time.Instant;
import org.apache.parquet.filter2.dsl.Dsl;
import org.apache.parquet.filter2.dsl.Dsl$;
import org.apache.spark.SparkContext;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.rdd.RDD;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import org.bdgenomics.adam.algorithms.consensus.ConsensusGenerator;
import org.bdgenomics.adam.algorithms.consensus.ConsensusGenerator$;
import org.bdgenomics.adam.cli.About;
import org.bdgenomics.adam.cli.TransformAlignments$;
import org.bdgenomics.adam.cli.TransformAlignmentsArgs;
import org.bdgenomics.adam.instrumentation.Timers$;
import org.bdgenomics.adam.models.RecordGroupDictionary;
import org.bdgenomics.adam.models.ReferenceRegion$;
import org.bdgenomics.adam.models.SequenceDictionary;
import org.bdgenomics.adam.models.SnpTable;
import org.bdgenomics.adam.models.SnpTable$;
import org.bdgenomics.adam.projections.AlignmentRecordField$;
import org.bdgenomics.adam.projections.FieldValue;
import org.bdgenomics.adam.projections.Filter$;
import org.bdgenomics.adam.rdd.ADAMContext;
import org.bdgenomics.adam.rdd.ADAMContext$;
import org.bdgenomics.adam.rdd.ADAMSaveAnyArgs;
import org.bdgenomics.adam.rdd.read.AlignmentRecordRDD;
import org.bdgenomics.adam.rdd.read.AlignmentRecordRDD$;
import org.bdgenomics.adam.rdd.read.QualityScoreBin$;
import org.bdgenomics.adam.util.ReferenceFile;
import org.bdgenomics.formats.avro.AlignmentRecord;
import org.bdgenomics.formats.avro.ProcessingStep;
import org.bdgenomics.utils.cli.BDGSparkCommand;
import org.bdgenomics.utils.instrumentation.MetricsListener;
import org.bdgenomics.utils.misc.Logging;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple4;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005mu!B\u0001\u0003\u0011\u0003Y\u0011a\u0005+sC:\u001chm\u001c:n\u00032LwM\\7f]R\u001c(BA\u0002\u0005\u0003\r\u0019G.\u001b\u0006\u0003\u000b\u0019\tA!\u00193b[*\u0011q\u0001C\u0001\u000bE\u0012<WM\\8nS\u000e\u001c(\"A\u0005\u0002\u0007=\u0014xm\u0001\u0001\u0011\u00051iQ\"\u0001\u0002\u0007\u000b9\u0011\u0001\u0012A\b\u0003'Q\u0013\u0018M\\:g_Jl\u0017\t\\5h]6,g\u000e^:\u0014\u00075\u0001b\u0003\u0005\u0002\u0012)5\t!CC\u0001\u0014\u0003\u0015\u00198-\u00197b\u0013\t)\"C\u0001\u0004B]f\u0014VM\u001a\t\u0003/mi\u0011\u0001\u0007\u0006\u0003\u0007eQ!A\u0007\u0004\u0002\u000bU$\u0018\u000e\\:\n\u0005qA\"a\u0005\"E\u000f\u000e{W.\\1oI\u000e{W\u000e]1oS>t\u0007\"\u0002\u0010\u000e\t\u0003y\u0012A\u0002\u001fj]&$h\bF\u0001\f\u0011\u001d\tSB1A\u0005\u0002\t\n1bY8n[\u0006tGMT1nKV\t1\u0005\u0005\u0002%S5\tQE\u0003\u0002'O\u0005!A.\u00198h\u0015\u0005A\u0013\u0001\u00026bm\u0006L!AK\u0013\u0003\rM#(/\u001b8h\u0011\u0019aS\u0002)A\u0005G\u0005a1m\\7nC:$g*Y7fA!9a&\u0004b\u0001\n\u0003\u0011\u0013AE2p[6\fg\u000e\u001a#fg\u000e\u0014\u0018\u000e\u001d;j_:Da\u0001M\u0007!\u0002\u0013\u0019\u0013aE2p[6\fg\u000e\u001a#fg\u000e\u0014\u0018\u000e\u001d;j_:\u0004\u0003\"\u0002\u001a\u000e\t\u0003\u0019\u0014!B1qa2LHc\u0001\u001b\u0002\u0012B\u0011A\"\u000e\u0004\u0005\u001d\t\u0001ag\u0005\u00036oi\u0002\u0005C\u0001\u00139\u0013\tITE\u0001\u0004PE*,7\r\u001e\t\u0004/mj\u0014B\u0001\u001f\u0019\u0005=\u0011EiR*qCJ\\7i\\7nC:$\u0007C\u0001\u0007?\u0013\ty$AA\fUe\u0006t7OZ8s[\u0006c\u0017n\u001a8nK:$8/\u0011:hgB\u0011\u0011\tR\u0007\u0002\u0005*\u00111)G\u0001\u0005[&\u001c8-\u0003\u0002F\u0005\n9Aj\\4hS:<\u0007\u0002C$6\u0005\u000b\u0007I\u0011\u0003%\u0002\t\u0005\u0014xm]\u000b\u0002{!A!*\u000eB\u0001B\u0003%Q(A\u0003be\u001e\u001c\b\u0005C\u0003\u001fk\u0011\u0005A\n\u0006\u00025\u001b\")qi\u0013a\u0001{!9q*\u000eb\u0001\n\u0003\u0001\u0016!C2p[B\fg.[8o+\u0005\tfB\u0001\u0007\u0001\u0011\u0019\u0019V\u0007)A\u0005#\u0006Q1m\\7qC:LwN\u001c\u0011\t\u000fU+$\u0019!C\u0001-\u0006Q1\u000f\u001e:j]\u001e,gnY=\u0016\u0003]\u0003\"\u0001W/\u000e\u0003eS!AW.\u0002\u0011M\fW\u000e^8pYNT\u0011\u0001X\u0001\u0007QR\u001c(\u000eZ6\n\u0005yK&\u0001\u0006,bY&$\u0017\r^5p]N#(/\u001b8hK:\u001c\u0017\u0010\u0003\u0004ak\u0001\u0006IaV\u0001\fgR\u0014\u0018N\\4f]\u000eL\b\u0005C\u0003ck\u0011%1-\u0001\u0005nCf\u0014WMQ5o)\t!G\u000e\u0005\u0002fU6\taM\u0003\u0002hQ\u0006!!/Z1e\u0015\tIG!A\u0002sI\u0012L!a\u001b4\u0003%\u0005c\u0017n\u001a8nK:$(+Z2pe\u0012\u0014F\t\u0012\u0005\u0006S\u0006\u0004\r\u0001\u001a\u0005\u0006]V\"Ia\\\u0001\u0011[\u0006L(-\u001a*fa\u0006\u0014H/\u001b;j_:$\"\u0001\u001a9\t\u000b%l\u0007\u0019\u00013\t\u000bI,D\u0011B:\u0002\u00175\f\u0017PY3EK\u0012,\b/\u001a\u000b\u0003IRDQ![9A\u0002\u0011DQA^\u001b\u0005\n]\fA\"\\1zE\u0016\u0014V-\u00197jO:$b\u0001\u001a=\u0002\u0006\u0005\u001d\u0001\"B=v\u0001\u0004Q\u0018AA:d!\rY\u0018\u0011A\u0007\u0002y*\u0011QP`\u0001\u0006gB\f'o\u001b\u0006\u0003\u007f\"\ta!\u00199bG\",\u0017bAA\u0002y\na1\u000b]1sW\u000e{g\u000e^3yi\")\u0011.\u001ea\u0001I\"9\u0011\u0011B;A\u0002\u0005-\u0011AA:m!\u0011\ti!a\u0005\u000e\u0005\u0005=!bAA\ty\u000691\u000f^8sC\u001e,\u0017\u0002BA\u000b\u0003\u001f\u0011Ab\u0015;pe\u0006<W\rT3wK2Dq!!\u00076\t\u0013\tY\"\u0001\tnCf\u0014WMU3dC2L'M]1uKR)A-!\b\u0002 !1\u0011.a\u0006A\u0002\u0011D\u0001\"!\u0003\u0002\u0018\u0001\u0007\u00111\u0002\u0005\b\u0003G)D\u0011BA\u0013\u00035i\u0017-\u001f2f\u0007>\fG.Z:dKR\u0019A-a\n\t\r%\f\t\u00031\u0001e\u0011\u001d\tY#\u000eC\u0005\u0003[\t\u0011\"\\1zE\u0016\u001cvN\u001d;\u0015\u000b\u0011\fy#!\r\t\r%\fI\u00031\u0001e\u0011!\tI!!\u000bA\u0002\u0005-\u0001bBA\u001bk\u0011\u0005\u0011qG\u0001\u000b[\u0006L(-Z'e)\u0006<Gc\u00023\u0002:\u0005m\u0012Q\b\u0005\u0007s\u0006M\u0002\u0019\u0001>\t\r%\f\u0019\u00041\u0001e\u0011!\ty$a\rA\u0002\u0005\u0005\u0013!D:ue&tw-\u001a8ds>\u0003H\u000f\u0005\u0003\u0012\u0003\u0007:\u0016bAA#%\t1q\n\u001d;j_:DaAM\u001b\u0005\u0002\u0005%Cc\u00013\u0002L!1\u0011.a\u0012A\u0002\u0011Dq!a\u00146\t\u0003\t\t&A\bg_J\u001cWMT8o!\u0006\u0014\u0018/^3u)\t\t\u0019\u0006E\u0002\u0012\u0003+J1!a\u0016\u0013\u0005\u001d\u0011un\u001c7fC:Dq!a\u00176\t\u0003\ti&\u0001\u0007jg:{g\u000eU1scV,G\u000f\u0006\u0003\u0002T\u0005}\u0003\u0002CA1\u00033\u0002\r!a\u0019\u0002\u0013%t\u0007/\u001e;QCRD\u0007\u0003BA3\u0003Wr1!EA4\u0013\r\tIGE\u0001\u0007!J,G-\u001a4\n\u0007)\niGC\u0002\u0002jIAq!!\u001d6\t\u0003\t\u0019(A\u0002sk:$B!!\u001e\u0002|A\u0019\u0011#a\u001e\n\u0007\u0005e$C\u0001\u0003V]&$\bBB=\u0002p\u0001\u0007!\u0010C\u0004\u0002\u0000U\"I!!!\u0002)\r\u0014X-\u0019;f\u0017:|wO\\*oaN$\u0016M\u00197f)\u0011\t\u0019)a$\u0011\t\u0005\u0015\u00151R\u0007\u0003\u0003\u000fS1!!#\u0005\u0003\u0019iw\u000eZ3mg&!\u0011QRAD\u0005!\u0019f\u000e\u001d+bE2,\u0007BB=\u0002~\u0001\u0007!\u0010C\u0004\u0002\u0014F\u0002\r!!&\u0002\u000f\rlG\rT5oKB)\u0011#a&\u0002d%\u0019\u0011\u0011\u0014\n\u0003\u000b\u0005\u0013(/Y=")
public class TransformAlignments
implements BDGSparkCommand<TransformAlignmentsArgs> {
    private final TransformAlignmentsArgs args;
    private final TransformAlignments$ companion;
    private final ValidationStringency stringency;
    private transient Logger org$bdgenomics$utils$misc$Logging$$log_;

    public static void main(String[] stringArray) {
        TransformAlignments$.MODULE$.main(stringArray);
    }

    public static String commandDescription() {
        return TransformAlignments$.MODULE$.commandDescription();
    }

    public static String commandName() {
        return TransformAlignments$.MODULE$.commandName();
    }

    public void run() {
        BDGSparkCommand.class.run((BDGSparkCommand)this);
    }

    public Option<MetricsListener> initializeMetrics(SparkContext sc) {
        return BDGSparkCommand.class.initializeMetrics((BDGSparkCommand)this, (SparkContext)sc);
    }

    public void printMetrics(long totalTime, Option<MetricsListener> metricsListener) {
        BDGSparkCommand.class.printMetrics((BDGSparkCommand)this, (long)totalTime, metricsListener);
    }

    public Logger org$bdgenomics$utils$misc$Logging$$log_() {
        return this.org$bdgenomics$utils$misc$Logging$$log_;
    }

    public void org$bdgenomics$utils$misc$Logging$$log__$eq(Logger x$1) {
        this.org$bdgenomics$utils$misc$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public TransformAlignmentsArgs args() {
        return this.args;
    }

    public TransformAlignments$ companion() {
        return this.companion;
    }

    public ValidationStringency stringency() {
        return this.stringency;
    }

    private AlignmentRecordRDD maybeBin(AlignmentRecordRDD rdd) {
        return (AlignmentRecordRDD)Option$.MODULE$.apply((Object)this.args().binQualityScores()).fold((Function0)new Serializable(this, rdd){
            public static final long serialVersionUID = 0L;
            private final AlignmentRecordRDD rdd$1;

            public final AlignmentRecordRDD apply() {
                return this.rdd$1;
            }
            {
                this.rdd$1 = rdd$1;
            }
        }, (Function1)new Serializable(this, rdd){
            public static final long serialVersionUID = 0L;
            private final AlignmentRecordRDD rdd$1;

            public final AlignmentRecordRDD apply(String binDescription) {
                Seq bins = QualityScoreBin$.MODULE$.apply(binDescription);
                return this.rdd$1.binQualityScores(bins);
            }
            {
                this.rdd$1 = rdd$1;
            }
        });
    }

    private AlignmentRecordRDD maybeRepartition(AlignmentRecordRDD rdd) {
        AlignmentRecordRDD alignmentRecordRDD;
        if (this.args().repartition() != -1) {
            this.log().info(new StringOps(Predef$.MODULE$.augmentString("Repartitioning reads to to '%d' partitions")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.args().repartition())})));
            alignmentRecordRDD = (AlignmentRecordRDD)rdd.transform((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ TransformAlignments $outer;

                public final RDD<AlignmentRecord> apply(RDD<AlignmentRecord> x$1) {
                    int x$6 = this.$outer.args().repartition();
                    Ordering x$7 = x$1.repartition$default$2(x$6);
                    return x$1.repartition(x$6, x$7);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        } else {
            alignmentRecordRDD = rdd;
        }
        return alignmentRecordRDD;
    }

    private AlignmentRecordRDD maybeDedupe(AlignmentRecordRDD rdd) {
        AlignmentRecordRDD alignmentRecordRDD;
        if (this.args().markDuplicates()) {
            this.log().info("Marking duplicates");
            alignmentRecordRDD = rdd.markDuplicates();
        } else {
            alignmentRecordRDD = rdd;
        }
        return alignmentRecordRDD;
    }

    private AlignmentRecordRDD maybeRealign(SparkContext sc, AlignmentRecordRDD rdd, StorageLevel sl) {
        AlignmentRecordRDD alignmentRecordRDD;
        if (this.args().locallyRealign()) {
            this.log().info("Locally realigning indels.");
            Object object = this.args().cache() ? rdd.rdd().persist(sl) : BoxedUnit.UNIT;
            ConsensusGenerator consensusGenerator = (ConsensusGenerator)Option$.MODULE$.apply((Object)this.args().knownIndelsFile()).fold((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final ConsensusGenerator apply() {
                    return ConsensusGenerator$.MODULE$.fromReads();
                }
            }, (Function1)new Serializable(this, rdd){
                public static final long serialVersionUID = 0L;
                private final AlignmentRecordRDD rdd$2;

                public final ConsensusGenerator apply(String file) {
                    ADAMContext qual$1 = ADAMContext$.MODULE$.sparkContextToADAMContext(this.rdd$2.rdd().context());
                    String x$8 = file;
                    Option x$9 = qual$1.loadVariants$default$2();
                    Option x$10 = qual$1.loadVariants$default$3();
                    ValidationStringency x$11 = qual$1.loadVariants$default$4();
                    return ConsensusGenerator$.MODULE$.fromKnownIndels(qual$1.loadVariants(x$8, x$9, x$10, x$11), ConsensusGenerator$.MODULE$.fromKnownIndels$default$2());
                }
                {
                    this.rdd$2 = rdd$2;
                }
            });
            Option optReferenceFile = Option$.MODULE$.apply((Object)this.args().reference()).map((Function1)new Serializable(this, sc){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ TransformAlignments $outer;
                private final SparkContext sc$1;

                public final ReferenceFile apply(String f) {
                    return ADAMContext$.MODULE$.sparkContextToADAMContext(this.sc$1).loadReferenceFile(f, this.$outer.args().mdTagsFragmentSize());
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.sc$1 = sc$1;
                }
            });
            AlignmentRecordRDD realignmentRdd = rdd.realignIndels(consensusGenerator, false, this.args().maxIndelSize(), this.args().maxConsensusNumber(), this.args().lodThreshold(), this.args().maxTargetSize(), this.args().maxReadsPerTarget(), optReferenceFile, this.args().unclipReads());
            Object object2 = this.args().cache() ? rdd.rdd().unpersist(rdd.rdd().unpersist$default$1()) : BoxedUnit.UNIT;
            alignmentRecordRDD = realignmentRdd;
        } else {
            alignmentRecordRDD = rdd;
        }
        return alignmentRecordRDD;
    }

    private AlignmentRecordRDD maybeRecalibrate(AlignmentRecordRDD rdd, StorageLevel sl) {
        AlignmentRecordRDD alignmentRecordRDD;
        if (this.args().recalibrateBaseQualities()) {
            AlignmentRecordRDD bqsredRdd;
            this.log().info("Recalibrating base qualities");
            None$ optSl = this.args().cache() ? new Some((Object)sl) : None$.MODULE$;
            SnpTable knownSnps = this.createKnownSnpsTable(rdd.rdd().context());
            Broadcast broadcastedSnps = (Broadcast)Timers$.MODULE$.BroadcastingKnownSnps().time((Function0)new Serializable(this, rdd, knownSnps){
                public static final long serialVersionUID = 0L;
                private final AlignmentRecordRDD rdd$3;
                private final SnpTable knownSnps$1;

                public final Broadcast<SnpTable> apply() {
                    return this.rdd$3.rdd().context().broadcast((Object)this.knownSnps$1, ClassTag$.MODULE$.apply(SnpTable.class));
                }
                {
                    this.rdd$3 = rdd$3;
                    this.knownSnps$1 = knownSnps$1;
                }
            });
            alignmentRecordRDD = bqsredRdd = rdd.recalibrateBaseQualities(broadcastedSnps, this.args().minAcceptableQuality(), (Option)optSl);
        } else {
            alignmentRecordRDD = rdd;
        }
        return alignmentRecordRDD;
    }

    private AlignmentRecordRDD maybeCoalesce(AlignmentRecordRDD rdd) {
        AlignmentRecordRDD alignmentRecordRDD;
        if (this.args().coalesce() != -1) {
            this.log().info(new StringOps(Predef$.MODULE$.augmentString("Coalescing the number of partitions to '%d'")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.args().coalesce())})));
            alignmentRecordRDD = this.args().coalesce() > rdd.rdd().partitions().length || this.args().forceShuffle() ? (AlignmentRecordRDD)rdd.transform((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ TransformAlignments $outer;

                public final RDD<AlignmentRecord> apply(RDD<AlignmentRecord> x$2) {
                    int x$12 = this.$outer.args().coalesce();
                    boolean x$13 = true;
                    Ordering x$14 = x$2.coalesce$default$3(x$12, x$13);
                    return x$2.coalesce(x$12, x$13, x$14);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }) : (AlignmentRecordRDD)rdd.transform((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ TransformAlignments $outer;

                public final RDD<AlignmentRecord> apply(RDD<AlignmentRecord> x$3) {
                    int x$15 = this.$outer.args().coalesce();
                    boolean x$16 = false;
                    Ordering x$17 = x$3.coalesce$default$3(x$15, x$16);
                    return x$3.coalesce(x$15, x$16, x$17);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        } else {
            alignmentRecordRDD = rdd;
        }
        return alignmentRecordRDD;
    }

    /*
     * WARNING - void declaration
     */
    private AlignmentRecordRDD maybeSort(AlignmentRecordRDD rdd, StorageLevel sl) {
        AlignmentRecordRDD alignmentRecordRDD;
        if (this.args().sortReads()) {
            void var3_3;
            Object object = this.args().cache() ? rdd.rdd().persist(sl) : BoxedUnit.UNIT;
            this.log().info("Sorting reads");
            AlignmentRecordRDD sortedRdd = this.args().sortLexicographically() ? rdd.sortReadsByReferencePosition() : rdd.sortReadsByReferencePositionAndIndex();
            Object object2 = this.args().cache() ? rdd.rdd().unpersist(rdd.rdd().unpersist$default$1()) : BoxedUnit.UNIT;
            alignmentRecordRDD = var3_3;
        } else {
            alignmentRecordRDD = rdd;
        }
        return alignmentRecordRDD;
    }

    public AlignmentRecordRDD maybeMdTag(SparkContext sc, AlignmentRecordRDD rdd, Option<ValidationStringency> stringencyOpt) {
        AlignmentRecordRDD alignmentRecordRDD;
        if (this.args().mdTagsReferenceFile() == null) {
            alignmentRecordRDD = rdd;
        } else {
            this.log().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Adding MDTags to reads based on reference file ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.args().mdTagsReferenceFile()})));
            ReferenceFile referenceFile = ADAMContext$.MODULE$.sparkContextToADAMContext(sc).loadReferenceFile(this.args().mdTagsReferenceFile(), this.args().mdTagsFragmentSize());
            alignmentRecordRDD = rdd.computeMismatchingPositions(referenceFile, this.args().mdTagsOverwrite(), (ValidationStringency)stringencyOpt.getOrElse((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final ValidationStringency apply() {
                    return ValidationStringency.STRICT;
                }
            }));
        }
        return alignmentRecordRDD;
    }

    public AlignmentRecordRDD apply(AlignmentRecordRDD rdd) {
        SparkContext sc = rdd.rdd().context();
        StorageLevel sl = StorageLevel$.MODULE$.fromString(this.args().storageLevel());
        Option stringencyOpt = Option$.MODULE$.apply((Object)this.args().stringency()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final ValidationStringency apply(String x$4) {
                return ValidationStringency.valueOf((String)x$4);
            }
        });
        AlignmentRecordRDD initialRdd = this.maybeRepartition(rdd);
        AlignmentRecordRDD binnedRdd = this.maybeBin(rdd);
        AlignmentRecordRDD maybeDedupedRdd = this.maybeDedupe(binnedRdd);
        AlignmentRecordRDD maybeRealignedRdd = this.maybeRealign(sc, maybeDedupedRdd, sl);
        AlignmentRecordRDD maybeRecalibratedRdd = this.maybeRecalibrate(maybeRealignedRdd, sl);
        AlignmentRecordRDD finalPreprocessedRdd = this.maybeCoalesce(maybeRecalibratedRdd);
        AlignmentRecordRDD maybeSortedRdd = this.maybeSort(finalPreprocessedRdd, sl);
        return this.maybeMdTag(sc, maybeSortedRdd, (Option<ValidationStringency>)stringencyOpt);
    }

    public boolean forceNonParquet() {
        return this.args().forceLoadBam() || this.args().forceLoadFastq() || this.args().forceLoadIFastq();
    }

    public boolean isNonParquet(String inputPath) {
        return inputPath.endsWith(".sam") || inputPath.endsWith(".bam") || inputPath.endsWith(".ifq") || inputPath.endsWith(".fq") || inputPath.endsWith(".fastq") || inputPath.endsWith(".fa") || inputPath.endsWith(".fasta");
    }

    public void run(SparkContext sc) {
        AlignmentRecordRDD alignmentRecordRDD;
        AlignmentRecordRDD loadedRdd;
        AlignmentRecordRDD alignmentRecordRDD2;
        if (this.args().useAlignedReadPredicate() && this.forceNonParquet()) {
            throw new IllegalArgumentException("-aligned_read_predicate only applies to Parquet files, but a non-Parquet force load flag was passed.");
        }
        if (this.args().limitProjection() && this.forceNonParquet()) {
            throw new IllegalArgumentException("-limit_projection only applies to Parquet files, but a non-Parquet force load flag was passed.");
        }
        if (this.args().useAlignedReadPredicate() && this.isNonParquet(this.args().inputPath())) {
            throw new IllegalArgumentException("-aligned_read_predicate only applies to Parquet files, but a non-Parquet input path was specified.");
        }
        if (this.args().limitProjection() && this.isNonParquet(this.args().inputPath())) {
            throw new IllegalArgumentException("-limit_projection only applies to Parquet files, but a non-Parquet input path was specified.");
        }
        if (this.args().useAlignedReadPredicate() && this.args().regionPredicate() != null) {
            throw new IllegalArgumentException("-aligned_read_predicate and -region_predicate are mutually exclusive");
        }
        if (this.args().forceLoadBam()) {
            if (this.args().regionPredicate() == null) {
                ADAMContext qual$3 = ADAMContext$.MODULE$.sparkContextToADAMContext(sc);
                String x$21 = this.args().inputPath();
                ValidationStringency x$22 = qual$3.loadBam$default$2();
                alignmentRecordRDD2 = qual$3.loadBam(x$21, x$22);
            } else {
                Iterable loci = ReferenceRegion$.MODULE$.fromString(this.args().regionPredicate());
                ADAMContext qual$2 = ADAMContext$.MODULE$.sparkContextToADAMContext(sc);
                String x$18 = this.args().inputPath();
                Iterable x$19 = loci;
                ValidationStringency x$20 = qual$2.loadIndexedBam$default$3();
                alignmentRecordRDD2 = qual$2.loadIndexedBam(x$18, x$19, x$20, Predef.DummyImplicit$.MODULE$.dummyImplicit());
            }
        } else if (this.args().forceLoadFastq()) {
            alignmentRecordRDD2 = ADAMContext$.MODULE$.sparkContextToADAMContext(sc).loadFastq(this.args().inputPath(), Option$.MODULE$.apply((Object)this.args().pairedFastqFile()), Option$.MODULE$.apply((Object)this.args().fastqRecordGroup()), this.stringency());
        } else if (this.args().forceLoadIFastq()) {
            alignmentRecordRDD2 = ADAMContext$.MODULE$.sparkContextToADAMContext(sc).loadInterleavedFastq(this.args().inputPath());
        } else if (this.args().forceLoadParquet() || this.args().useAlignedReadPredicate() || this.args().limitProjection()) {
            Some pred = this.args().useAlignedReadPredicate() ? new Some((Object)Dsl$.MODULE$.enrichEqNotEq((Dsl.Column)new Dsl.BooleanColumn("readMapped")).$eq$eq$eq((Comparable)Predef$.MODULE$.boolean2Boolean(true))) : (this.args().regionPredicate() == null ? None$.MODULE$ : new Some((Object)ReferenceRegion$.MODULE$.createPredicate(ReferenceRegion$.MODULE$.fromString(this.args().regionPredicate()).toSeq())));
            None$ proj = this.args().limitProjection() ? new Some((Object)Filter$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FieldValue[]{AlignmentRecordField$.MODULE$.attributes(), AlignmentRecordField$.MODULE$.origQual()}))) : None$.MODULE$;
            alignmentRecordRDD2 = ADAMContext$.MODULE$.sparkContextToADAMContext(sc).loadParquetAlignments(this.args().inputPath(), (Option)pred, (Option)proj);
        } else {
            ADAMContext qual$4 = ADAMContext$.MODULE$.sparkContextToADAMContext(sc);
            String x$23 = this.args().inputPath();
            Option x$24 = Option$.MODULE$.apply((Object)this.args().pairedFastqFile());
            Option x$25 = Option$.MODULE$.apply((Object)this.args().fastqRecordGroup());
            ValidationStringency x$26 = this.stringency();
            Option x$27 = qual$4.loadAlignments$default$4();
            Option x$28 = qual$4.loadAlignments$default$5();
            AlignmentRecordRDD loadedReads = qual$4.loadAlignments(x$23, x$24, x$25, x$27, x$28, x$26);
            if (this.args().regionPredicate() == null) {
                alignmentRecordRDD2 = loadedReads;
            } else {
                Iterable loci = ReferenceRegion$.MODULE$.fromString(this.args().regionPredicate());
                alignmentRecordRDD2 = loadedRdd = (AlignmentRecordRDD)loadedReads.filterByOverlappingRegions(loci);
            }
        }
        if (this.args().disableProcessingStep()) {
            alignmentRecordRDD = loadedRdd;
        } else {
            About about = new About();
            String version = about.isSnapshot() ? new StringOps(Predef$.MODULE$.augmentString("%s--%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{about.version(), about.commit()})) : about.version();
            long epoch = Instant.now().getEpochSecond();
            ProcessingStep processingStep = ProcessingStep.newBuilder().setId(new StringOps(Predef$.MODULE$.augmentString("ADAM_%d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)epoch)}))).setProgramName("org.bdgenomics.adam.cli.TransformAlignments").setVersion(version).setCommandLine(this.args().command()).build();
            alignmentRecordRDD = (AlignmentRecordRDD)loadedRdd.addProcessingStep(processingStep);
        }
        AlignmentRecordRDD aRdd = alignmentRecordRDD;
        RDD rdd = aRdd.rdd();
        SequenceDictionary sd = aRdd.sequences();
        RecordGroupDictionary rgd = aRdd.recordGroups();
        Seq pgs = aRdd.processingSteps();
        Option concatOpt = Option$.MODULE$.apply((Object)this.args().concatFilename()).map((Function1)new Serializable(this, sc){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransformAlignments $outer;
            private final SparkContext sc$3;

            public final AlignmentRecordRDD apply(String concatFilename) {
                AlignmentRecordRDD alignmentRecordRDD;
                if (this.$outer.args().forceLoadBam()) {
                    ADAMContext qual$5 = ADAMContext$.MODULE$.sparkContextToADAMContext(this.sc$3);
                    String x$29 = concatFilename;
                    ValidationStringency x$30 = qual$5.loadBam$default$2();
                    alignmentRecordRDD = qual$5.loadBam(x$29, x$30);
                } else if (this.$outer.args().forceLoadIFastq()) {
                    alignmentRecordRDD = ADAMContext$.MODULE$.sparkContextToADAMContext(this.sc$3).loadInterleavedFastq(concatFilename);
                } else if (this.$outer.args().forceLoadParquet()) {
                    ADAMContext qual$6 = ADAMContext$.MODULE$.sparkContextToADAMContext(this.sc$3);
                    String x$31 = concatFilename;
                    Option x$32 = qual$6.loadParquetAlignments$default$2();
                    Option x$33 = qual$6.loadParquetAlignments$default$3();
                    alignmentRecordRDD = qual$6.loadParquetAlignments(x$31, x$32, x$33);
                } else {
                    ADAMContext qual$7 = ADAMContext$.MODULE$.sparkContextToADAMContext(this.sc$3);
                    String x$34 = concatFilename;
                    Option x$35 = Option$.MODULE$.apply((Object)this.$outer.args().fastqRecordGroup());
                    Option x$36 = qual$7.loadAlignments$default$2();
                    Option x$37 = qual$7.loadAlignments$default$4();
                    Option x$38 = qual$7.loadAlignments$default$5();
                    ValidationStringency x$39 = qual$7.loadAlignments$default$6();
                    alignmentRecordRDD = qual$7.loadAlignments(x$34, x$36, x$35, x$37, x$38, x$39);
                }
                return alignmentRecordRDD;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.sc$3 = sc$3;
            }
        });
        Tuple4 tuple4 = (Tuple4)concatOpt.fold((Function0)new Serializable(this, rdd, sd, rgd, pgs){
            public static final long serialVersionUID = 0L;
            private final RDD rdd$4;
            private final SequenceDictionary sd$1;
            private final RecordGroupDictionary rgd$1;
            private final Seq pgs$1;

            public final Tuple4<RDD<AlignmentRecord>, SequenceDictionary, RecordGroupDictionary, Seq<ProcessingStep>> apply() {
                return new Tuple4((Object)this.rdd$4, (Object)this.sd$1, (Object)this.rgd$1, (Object)this.pgs$1);
            }
            {
                this.rdd$4 = rdd$4;
                this.sd$1 = sd$1;
                this.rgd$1 = rgd$1;
                this.pgs$1 = pgs$1;
            }
        }, (Function1)new Serializable(this, rdd, sd, rgd, pgs){
            public static final long serialVersionUID = 0L;
            private final RDD rdd$4;
            private final SequenceDictionary sd$1;
            private final RecordGroupDictionary rgd$1;
            private final Seq pgs$1;

            public final Tuple4<RDD<AlignmentRecord>, SequenceDictionary, RecordGroupDictionary, Seq<ProcessingStep>> apply(AlignmentRecordRDD t) {
                return new Tuple4((Object)this.rdd$4.$plus$plus(t.rdd()), (Object)this.sd$1.$plus$plus(t.sequences()), (Object)this.rgd$1.$plus$plus(t.recordGroups()), this.pgs$1.$plus$plus((GenTraversableOnce)t.processingSteps(), Seq$.MODULE$.canBuildFrom()));
            }
            {
                this.rdd$4 = rdd$4;
                this.sd$1 = sd$1;
                this.rgd$1 = rgd$1;
                this.pgs$1 = pgs$1;
            }
        });
        if (tuple4 != null) {
            Tuple4 tuple42;
            RDD mergedRdd = (RDD)tuple4._1();
            SequenceDictionary mergedSd = (SequenceDictionary)tuple4._2();
            RecordGroupDictionary mergedRgd = (RecordGroupDictionary)tuple4._3();
            Seq mergedPgs = (Seq)tuple4._4();
            Tuple4 tuple43 = tuple42 = new Tuple4((Object)mergedRdd, (Object)mergedSd, (Object)mergedRgd, (Object)mergedPgs);
            RDD mergedRdd2 = (RDD)tuple43._1();
            SequenceDictionary mergedSd2 = (SequenceDictionary)tuple43._2();
            RecordGroupDictionary mergedRgd2 = (RecordGroupDictionary)tuple43._3();
            Seq mergedPgs2 = (Seq)tuple43._4();
            AlignmentRecordRDD newRdd = AlignmentRecordRDD$.MODULE$.apply(mergedRdd2, mergedSd2, mergedRgd2, mergedPgs2);
            AlignmentRecordRDD outputRdd = this.apply(newRdd);
            SequenceDictionary sdFinal = this.args().sortReads() ? (this.args().sortLexicographically() ? mergedSd2.stripIndices().sorted() : mergedSd2) : mergedSd2;
            outputRdd.save((ADAMSaveAnyArgs)this.args(), this.args().sortReads() || this.args().sortLexicographically());
            return;
        }
        throw new MatchError((Object)tuple4);
    }

    private SnpTable createKnownSnpsTable(SparkContext sc) {
        return (SnpTable)Option$.MODULE$.apply((Object)this.args().knownSnpsFile()).fold((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final SnpTable apply() {
                return SnpTable$.MODULE$.apply();
            }
        }, (Function1)new Serializable(this, sc){
            public static final long serialVersionUID = 0L;
            private final SparkContext sc$2;

            public final SnpTable apply(String f) {
                ADAMContext qual$8 = ADAMContext$.MODULE$.sparkContextToADAMContext(this.sc$2);
                String x$40 = f;
                Option x$41 = qual$8.loadVariants$default$2();
                Option x$42 = qual$8.loadVariants$default$3();
                ValidationStringency x$43 = qual$8.loadVariants$default$4();
                return SnpTable$.MODULE$.apply(qual$8.loadVariants(x$40, x$41, x$42, x$43));
            }
            {
                this.sc$2 = sc$2;
            }
        });
    }

    public TransformAlignments(TransformAlignmentsArgs args) {
        this.args = args;
        Logging.class.$init$((Logging)this);
        BDGSparkCommand.class.$init$((BDGSparkCommand)this);
        this.companion = TransformAlignments$.MODULE$;
        this.stringency = ValidationStringency.valueOf((String)args.stringency());
    }
}

