/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.converters;

import java.util.Collection;
import java.util.List;
import org.bdgenomics.adam.avro.ADAMContig;
import org.bdgenomics.adam.avro.ADAMGenotype;
import org.bdgenomics.adam.avro.ADAMGenotypeAllele;
import org.bdgenomics.adam.avro.ADAMVariant;
import org.bdgenomics.adam.converters.VariantContextConverter;
import org.bdgenomics.adam.converters.VariantContextConverterSuite$;
import org.bdgenomics.adam.models.ADAMVariantContext;
import org.bdgenomics.adam.models.ADAMVariantContext$;
import org.bdgenomics.adam.models.SequenceDictionary;
import org.bdgenomics.adam.models.SequenceDictionary$;
import org.bdgenomics.adam.models.SequenceRecord;
import org.bdgenomics.adam.models.SequenceRecord$;
import org.bdgenomics.adam.rich.RichADAMVariant;
import org.bdgenomics.adam.rich.RichADAMVariant$;
import org.broadinstitute.variant.variantcontext.Allele;
import org.broadinstitute.variant.variantcontext.Genotype;
import org.broadinstitute.variant.variantcontext.GenotypeBuilder;
import org.broadinstitute.variant.variantcontext.GenotypeType;
import org.broadinstitute.variant.variantcontext.VariantContext;
import org.broadinstitute.variant.variantcontext.VariantContextBuilder;
import org.scalatest.FunSuite;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.JavaConversions$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.List$;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001y2A!\u0001\u0002\u0001\u0017\tab+\u0019:jC:$8i\u001c8uKb$8i\u001c8wKJ$XM]*vSR,'BA\u0002\u0005\u0003)\u0019wN\u001c<feR,'o\u001d\u0006\u0003\u000b\u0019\tA!\u00193b[*\u0011q\u0001C\u0001\u000bE\u0012<WM\\8nS\u000e\u001c(\"A\u0005\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001a\u0001CA\u0007\u0011\u001b\u0005q!BA\b\t\u0003%\u00198-\u00197bi\u0016\u001cH/\u0003\u0002\u0012\u001d\tAa)\u001e8Tk&$X\rC\u0003\u0014\u0001\u0011\u0005A#\u0001\u0004=S:LGO\u0010\u000b\u0002+A\u0011a\u0003A\u0007\u0002\u0005!9\u0001\u0004\u0001b\u0001\n\u0003I\u0012A\u00033jGRLwN\\1ssV\t!\u0004\u0005\u0002\u001c=5\tAD\u0003\u0002\u001e\t\u00051Qn\u001c3fYNL!a\b\u000f\u0003%M+\u0017/^3oG\u0016$\u0015n\u0019;j_:\f'/\u001f\u0005\u0007C\u0001\u0001\u000b\u0011\u0002\u000e\u0002\u0017\u0011L7\r^5p]\u0006\u0014\u0018\u0010\t\u0005\u0006G\u0001!\t\u0001J\u0001\u000fO\u0006$8n\u0015(W\u0005VLG\u000eZ3s+\u0005)\u0003C\u0001\u0014.\u001b\u00059#B\u0001\u0015*\u000391\u0018M]5b]R\u001cwN\u001c;fqRT!AK\u0016\u0002\u000fY\f'/[1oi*\u0011A\u0006C\u0001\u000fEJ|\u0017\rZ5ogRLG/\u001e;f\u0013\tqsEA\u000bWCJL\u0017M\u001c;D_:$X\r\u001f;Ck&dG-\u001a:\t\u000bA\u0002A\u0011\u0001\u0013\u00025\u001d\fGo['vYRL\u0017\t\u001c7fY&\u001c7K\u0014,Ck&dG-\u001a:\t\u000bI\u0002A\u0011A\u001a\u0002\u001d\u0005$\u0017-\\*O-\n+\u0018\u000e\u001c3feV\tA\u0007\u0005\u00026w9\u0011a'O\u0007\u0002o)\u0011\u0001\bB\u0001\u0005CZ\u0014x.\u0003\u0002;o\u0005Y\u0011\tR!N-\u0006\u0014\u0018.\u00198u\u0013\taTHA\u0004Ck&dG-\u001a:\u000b\u0005i:\u0004")
public class VariantContextConverterSuite
extends FunSuite {
    private final SequenceDictionary dictionary = SequenceDictionary$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SequenceRecord[]{SequenceRecord$.MODULE$.apply((CharSequence)"chr1", 249250621L, (CharSequence)"file://ucsc.hg19.fasta", (CharSequence)"1b22b98cdeb4a9304cb5d48026a85128")}));

    public SequenceDictionary dictionary() {
        return this.dictionary;
    }

    public VariantContextBuilder gatkSNVBuilder() {
        return new VariantContextBuilder().alleles((Collection)JavaConversions$.MODULE$.seqAsJavaList((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Allele[]{Allele.create((String)"A", (boolean)true), Allele.create((String)"T")})))).start(1L).stop(1L).chr("chr1");
    }

    public VariantContextBuilder gatkMultiAllelicSNVBuilder() {
        return new VariantContextBuilder().alleles((Collection)JavaConversions$.MODULE$.seqAsJavaList((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Allele[]{Allele.create((String)"A", (boolean)true), Allele.create((String)"T"), Allele.create((String)"G")})))).start(1L).stop(1L).chr("chr1");
    }

    public ADAMVariant.Builder adamSNVBuilder() {
        return ADAMVariant.newBuilder().setContig(ADAMContig.newBuilder().setContigName((CharSequence)"chr1").build()).setPosition(Predef$.MODULE$.long2Long(0L)).setReferenceAllele((CharSequence)"A").setVariantAllele((CharSequence)"T");
    }

    public VariantContextConverterSuite() {
        this.test("Convert GATK site-only SNV to ADAM", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ VariantContextConverterSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                VariantContextConverter converter = new VariantContextConverter((Option)new Some((Object)this.$outer.dictionary()));
                Seq adamVCs = converter.convert(this.$outer.gatkSNVBuilder().make(), converter.convert$default$2());
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)adamVCs.length())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1)));
                ADAMVariantContext adamVC = (ADAMVariantContext)adamVCs.head();
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)adamVC.genotypes().length())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)0)));
                RichADAMVariant variant = adamVC.variant();
                ADAMContig contig = RichADAMVariant$.MODULE$.richVariantToVariant(variant).getContig();
                this.$outer.assert(this.$outer.convertToEqualizer(contig.getContigName()).$eq$eq$eq((Object)"chr1"));
                this.$outer.assert(this.$outer.convertToEqualizer(contig.getContigLength()).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)249250621)));
                this.$outer.assert(this.$outer.convertToEqualizer(contig.getReferenceURL()).$eq$eq$eq((Object)"file://ucsc.hg19.fasta"));
                this.$outer.assert(this.$outer.convertToEqualizer(contig.getContigMD5()).$eq$eq$eq((Object)"1b22b98cdeb4a9304cb5d48026a85128"));
                this.$outer.assert(this.$outer.convertToEqualizer(RichADAMVariant$.MODULE$.richVariantToVariant(variant).getReferenceAllele()).$eq$eq$eq((Object)"A"));
                this.$outer.assert(this.$outer.convertToEqualizer(RichADAMVariant$.MODULE$.richVariantToVariant(variant).getPosition()).$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)0L)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Convert GATK SNV w/ genotypes w/ phase information to ADAM", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ VariantContextConverterSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                VariantContextBuilder vcb = this.$outer.gatkSNVBuilder();
                Tuple2[] tuple2Array = new Tuple2[2];
                Predef$ predef$ = Predef$.MODULE$;
                Integer n = new Integer(50);
                Predef.ArrowAssoc$ arrowAssoc$ = Predef.ArrowAssoc$.MODULE$;
                tuple2Array[0] = new Tuple2((Object)"PQ", (Object)n);
                Predef$ predef$2 = Predef$.MODULE$;
                Integer n2 = new Integer(1);
                Predef.ArrowAssoc$ arrowAssoc$2 = Predef.ArrowAssoc$.MODULE$;
                tuple2Array[1] = new Tuple2((Object)"PS", (Object)n2);
                scala.collection.immutable.Map genotypeAttributes = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array));
                VariantContext vc = vcb.genotypes(new Genotype[]{GenotypeBuilder.create((String)"NA12878", (List)vcb.getAlleles(), (java.util.Map)JavaConversions$.MODULE$.mapAsJavaMap((Map)genotypeAttributes))}).make();
                VariantContextConverter converter = new VariantContextConverter((Option)new Some((Object)this.$outer.dictionary()));
                Seq adamVCs = converter.convert(vc, converter.convert$default$2());
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)adamVCs.length())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1)));
                Seq adamGTs = (Seq)adamVCs.flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Seq<ADAMGenotype> apply(ADAMVariantContext x$1) {
                        return x$1.genotypes();
                    }
                }, Seq$.MODULE$.canBuildFrom());
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)adamGTs.length())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1)));
                ADAMGenotype adamGT = (ADAMGenotype)adamGTs.head();
                this.$outer.assert(JavaConversions$.MODULE$.asScalaBuffer(adamGT.getAlleles()).sameElements((GenIterable)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ADAMGenotypeAllele[]{ADAMGenotypeAllele.Ref, ADAMGenotypeAllele.Alt}))));
                this.$outer.assert(this.$outer.convertToEqualizer(adamGT.getPhaseSetId()).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1)));
                this.$outer.assert(this.$outer.convertToEqualizer(adamGT.getPhaseQuality()).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)50)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Convert GATK SNV with different filters to ADAM", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ VariantContextConverterSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                VariantContextBuilder vcb = this.$outer.gatkSNVBuilder();
                vcb.genotypes(new Genotype[]{GenotypeBuilder.create((String)"NA12878", (List)vcb.getAlleles())});
                VariantContextConverter converter = new VariantContextConverter((Option)new Some((Object)this.$outer.dictionary()));
                Seq adamVCs = converter.convert(vcb.make(), converter.convert$default$2());
                ADAMGenotype adamGT = (ADAMGenotype)((IterableLike)adamVCs.flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Seq<ADAMGenotype> apply(ADAMVariantContext x$2) {
                        return x$2.genotypes();
                    }
                }, Seq$.MODULE$.canBuildFrom())).head();
                this.$outer.assert(this.$outer.convertToEqualizer(adamGT.getVariantCallingAnnotations().getVariantIsPassing()).$eq$eq$eq(null));
                vcb.unfiltered().passFilters();
                Seq adamVCs2 = converter.convert(vcb.make(), converter.convert$default$2());
                ADAMGenotype adamGT2 = (ADAMGenotype)((IterableLike)adamVCs2.flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Seq<ADAMGenotype> apply(ADAMVariantContext x$3) {
                        return x$3.genotypes();
                    }
                }, Seq$.MODULE$.canBuildFrom())).head();
                this.$outer.assert(Predef$.MODULE$.Boolean2boolean(adamGT2.getVariantCallingAnnotations().getVariantIsPassing()));
                vcb.unfiltered().filter("LowMQ");
                Seq adamVCs3 = converter.convert(vcb.make(), converter.convert$default$2());
                ADAMGenotype adamGT3 = (ADAMGenotype)((IterableLike)adamVCs3.flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Seq<ADAMGenotype> apply(ADAMVariantContext x$4) {
                        return x$4.genotypes();
                    }
                }, Seq$.MODULE$.canBuildFrom())).head();
                this.$outer.assert(this.$outer.convertToEqualizer(adamGT3.getVariantCallingAnnotations().getVariantIsPassing()).$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)false)));
                this.$outer.assert(JavaConversions$.MODULE$.asScalaBuffer(adamGT3.getVariantCallingAnnotations().getVariantFilters()).sameElements((GenIterable)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LowMQ"}))));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Convert ADAM site-only SNV to GATK", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ VariantContextConverterSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ADAMVariantContext vc = ADAMVariantContext$.MODULE$.apply(this.$outer.adamSNVBuilder().build());
                VariantContextConverter converter = new VariantContextConverter((Option)new Some((Object)this.$outer.dictionary()));
                VariantContext gatkVC = converter.convert(vc);
                this.$outer.assert(this.$outer.convertToEqualizer(gatkVC.getChr()).$eq$eq$eq((Object)"chr1"));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)gatkVC.getStart())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)gatkVC.getEnd())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1)));
                this.$outer.assert(this.$outer.convertToEqualizer(gatkVC.getReference()).$eq$eq$eq((Object)Allele.create((String)"A", (boolean)true)));
                this.$outer.assert(JavaConversions$.MODULE$.asScalaBuffer(gatkVC.getAlternateAlleles()).sameElements((GenIterable)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Allele[]{Allele.create((String)"T")}))));
                this.$outer.assert(!gatkVC.hasLog10PError());
                this.$outer.assert(!gatkVC.hasID());
                this.$outer.assert(!gatkVC.filtersWereApplied());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Convert ADAM SNV w/ genotypes to GATK", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ VariantContextConverterSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ADAMVariant variant = this.$outer.adamSNVBuilder().build();
                ADAMGenotype genotype = ADAMGenotype.newBuilder().setVariant(variant).setSampleId((CharSequence)"NA12878").setAlleles(JavaConversions$.MODULE$.seqAsJavaList((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ADAMGenotypeAllele[]{ADAMGenotypeAllele.Ref, ADAMGenotypeAllele.Alt})))).build();
                VariantContextConverter converter = new VariantContextConverter((Option)new Some((Object)this.$outer.dictionary()));
                VariantContext gatkVC = converter.convert(ADAMVariantContext$.MODULE$.apply(variant, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ADAMGenotype[]{genotype})), ADAMVariantContext$.MODULE$.apply$default$3()));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)gatkVC.getNSamples())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1)));
                this.$outer.assert(gatkVC.hasGenotype("NA12878"));
                Genotype gatkGT = gatkVC.getGenotype("NA12878");
                this.$outer.assert(this.$outer.convertToEqualizer(gatkGT.getType()).$eq$eq$eq((Object)GenotypeType.HET));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Convert GATK multi-allelic sites-only SNVs to ADAM", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            public final /* synthetic */ VariantContextConverterSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                VariantContext vc = this.$outer.gatkMultiAllelicSNVBuilder().make();
                VariantContextConverter converter = new VariantContextConverter((Option)new Some((Object)this.$outer.dictionary()));
                Seq adamVCs = converter.convert(vc, converter.convert$default$2());
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)adamVCs.length())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)2)));
                ((TraversableLike)JavaConversions$.MODULE$.asScalaBuffer(vc.getAlternateAlleles()).zipWithIndex(Buffer$.MODULE$.canBuildFrom())).withFilter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Tuple2<Allele, Object> check$ifrefutable$1) {
                        boolean bl = check$ifrefutable$1 != null;
                        return bl;
                    }
                }).foreach((Function1)new Serializable(this, vc, adamVCs){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$6 $outer;
                    private final VariantContext vc$1;
                    private final Seq adamVCs$1;

                    public final void apply(Tuple2<Allele, Object> x$5) {
                        if (x$5 != null) {
                            ADAMVariantContext adamVC = (ADAMVariantContext)this.adamVCs$1.apply(x$5._2$mcI$sp());
                            this.$outer.$outer.assert(this.$outer.$outer.convertToEqualizer(RichADAMVariant$.MODULE$.richVariantToVariant(adamVC.variant()).getReferenceAllele()).$eq$eq$eq((Object)this.vc$1.getReference().getBaseString()));
                            this.$outer.$outer.assert(this.$outer.org$bdgenomics$adam$converters$VariantContextConverterSuite$$anonfun$$$outer().convertToEqualizer(RichADAMVariant$.MODULE$.richVariantToVariant(adamVC.variant()).getVariantAllele()).$eq$eq$eq((Object)((Allele)x$5._1()).getBaseString()));
                            return;
                        }
                        throw new MatchError(x$5);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.vc$1 = vc$1;
                        this.adamVCs$1 = adamVCs$1;
                    }
                });
            }

            public /* synthetic */ VariantContextConverterSuite org$bdgenomics$adam$converters$VariantContextConverterSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Convert GATK multi-allelic SNVs to ADAM", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            public final /* synthetic */ VariantContextConverterSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                GenotypeBuilder gb = new GenotypeBuilder("NA12878", JavaConversions$.MODULE$.seqAsJavaList((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Allele[]{Allele.create((String)"T"), Allele.create((String)"G")}))));
                gb.AD(new int[]{4, 2, 3}).PL(new int[]{59, 0, 181, 1, 66, 102});
                VariantContextBuilder vcb = this.$outer.gatkMultiAllelicSNVBuilder();
                vcb.genotypes(new Genotype[]{gb.make()});
                VariantContextConverter converter = new VariantContextConverter((Option)new Some((Object)this.$outer.dictionary()));
                Seq adamVCs = converter.convert(vcb.make(), converter.convert$default$2());
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)adamVCs.length())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)2)));
                adamVCs.foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$7 $outer;

                    public final void apply(ADAMVariantContext adamVC) {
                        this.$outer.$outer.assert(this.$outer.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)adamVC.genotypes().length())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1)));
                        ADAMGenotype adamGT = (ADAMGenotype)adamVC.genotypes().head();
                        this.$outer.$outer.assert(Predef$.MODULE$.Boolean2boolean(adamGT.getSplitFromMultiAllelic()));
                        this.$outer.org$bdgenomics$adam$converters$VariantContextConverterSuite$$anonfun$$$outer().assert(this.$outer.org$bdgenomics$adam$converters$VariantContextConverterSuite$$anonfun$$$outer().convertToEqualizer(adamGT.getReferenceReadDepth()).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)4)));
                        this.$outer.org$bdgenomics$adam$converters$VariantContextConverterSuite$$anonfun$$$outer().assert(Predef$.MODULE$.Boolean2boolean(adamGT.getIsPhased()));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                ADAMGenotype adamGT1 = (ADAMGenotype)((ADAMVariantContext)adamVCs.apply(0)).genotypes().head();
                ADAMGenotype adamGT2 = (ADAMGenotype)((ADAMVariantContext)adamVCs.apply(1)).genotypes().head();
                this.$outer.assert(JavaConversions$.MODULE$.asScalaBuffer(adamGT1.getAlleles()).sameElements((GenIterable)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ADAMGenotypeAllele[]{ADAMGenotypeAllele.Alt, ADAMGenotypeAllele.OtherAlt}))));
                this.$outer.assert(this.$outer.convertToEqualizer(adamGT1.getAlternateReadDepth()).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)2)));
                this.$outer.assert(JavaConversions$.MODULE$.asScalaBuffer(adamGT1.getGenotypeLikelihoods()).sameElements((GenIterable)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{59, 0, 181}))));
                this.$outer.assert(JavaConversions$.MODULE$.asScalaBuffer(adamGT2.getAlleles()).sameElements((GenIterable)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ADAMGenotypeAllele[]{ADAMGenotypeAllele.OtherAlt, ADAMGenotypeAllele.Alt}))));
                this.$outer.assert(this.$outer.convertToEqualizer(adamGT2.getAlternateReadDepth()).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)3)));
                this.$outer.assert(JavaConversions$.MODULE$.asScalaBuffer(adamGT2.getGenotypeLikelihoods()).sameElements((GenIterable)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{58, 0, 101}))));
            }

            public /* synthetic */ VariantContextConverterSuite org$bdgenomics$adam$converters$VariantContextConverterSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

