/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.models;

import net.sf.samtools.SAMSequenceDictionary;
import net.sf.samtools.SAMSequenceRecord;
import org.apache.avro.specific.SpecificRecord;
import org.bdgenomics.adam.avro.ADAMContig;
import org.bdgenomics.adam.avro.ADAMVariant;
import org.bdgenomics.adam.models.SequenceDictionary;
import org.bdgenomics.adam.models.SequenceDictionary$;
import org.bdgenomics.adam.models.SequenceRecord;
import org.bdgenomics.adam.models.SequenceRecord$;
import org.bdgenomics.adam.rdd.ADAMContext$;
import org.scalatest.FunSuite;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Iterable;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00053A!\u0001\u0002\u0001\u0017\t92+Z9vK:\u001cW\rR5di&|g.\u0019:z'VLG/\u001a\u0006\u0003\u0007\u0011\ta!\\8eK2\u001c(BA\u0003\u0007\u0003\u0011\tG-Y7\u000b\u0005\u001dA\u0011A\u00032eO\u0016tw.\\5dg*\t\u0011\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001\u0019A\u0011Q\u0002E\u0007\u0002\u001d)\u0011q\u0002C\u0001\ng\u000e\fG.\u0019;fgRL!!\u0005\b\u0003\u0011\u0019+hnU;ji\u0016DQa\u0005\u0001\u0005\u0002Q\ta\u0001P5oSRtD#A\u000b\u0011\u0005Y\u0001Q\"\u0001\u0002\t\u000ba\u0001A\u0011A\r\u0002\rI,7m\u001c:e)\u0011QR$\u000b\u0018\u0011\u0005YY\u0012B\u0001\u000f\u0003\u00059\u0019V-];f]\u000e,'+Z2pe\u0012DQAH\fA\u0002}\tAA\\1nKB\u0011\u0001E\n\b\u0003C\u0011j\u0011A\t\u0006\u0002G\u0005)1oY1mC&\u0011QEI\u0001\u0007!J,G-\u001a4\n\u0005\u001dB#AB*ue&twM\u0003\u0002&E!9!f\u0006I\u0001\u0002\u0004Y\u0013A\u00027f]\u001e$\b\u000e\u0005\u0002\"Y%\u0011QF\t\u0002\u0004\u0013:$\bbB\u0018\u0018!\u0003\u0005\raH\u0001\u0004kJd\u0007bB\u0019\u0001#\u0003%\tAM\u0001\u0011e\u0016\u001cwN\u001d3%I\u00164\u0017-\u001e7uII*\u0012a\r\u0016\u0003WQZ\u0013!\u000e\t\u0003mmj\u0011a\u000e\u0006\u0003qe\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0005i\u0012\u0013AC1o]>$\u0018\r^5p]&\u0011Ah\u000e\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007b\u0002 \u0001#\u0003%\taP\u0001\u0011e\u0016\u001cwN\u001d3%I\u00164\u0017-\u001e7uIM*\u0012\u0001\u0011\u0016\u0003?Q\u0002")
public class SequenceDictionarySuite
extends FunSuite {
    public SequenceRecord record(String name, int length, String url) {
        return SequenceRecord$.MODULE$.apply((CharSequence)name, (long)length, (CharSequence)url, SequenceRecord$.MODULE$.apply$default$4());
    }

    public int record$default$2() {
        return 1000;
    }

    public String record$default$3() {
        return null;
    }

    public SequenceDictionarySuite() {
        this.test("containsRefName works as expected 1", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SequenceDictionarySuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SequenceRecord rec1 = this.$outer.record("foo", this.$outer.record$default$2(), this.$outer.record$default$3());
                SequenceRecord rec2 = this.$outer.record("bar", this.$outer.record$default$2(), this.$outer.record$default$3());
                this.$outer.assert(SequenceDictionary$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SequenceRecord[]{rec1, rec2})).containsRefName((CharSequence)"foo"));
                this.$outer.assert(SequenceDictionary$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SequenceRecord[]{rec1, rec2})).containsRefName((CharSequence)"bar"));
                this.$outer.assert(!SequenceDictionary$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SequenceRecord[]{rec1, rec2})).containsRefName((CharSequence)"foo "));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("containsRefName works as expected 2", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SequenceDictionarySuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SequenceRecord rec1 = this.$outer.record("foo", this.$outer.record$default$2(), this.$outer.record$default$3());
                SequenceRecord rec2 = this.$outer.record("bar", this.$outer.record$default$2(), this.$outer.record$default$3());
                SequenceDictionary sd = SequenceDictionary$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SequenceRecord[]{rec1, rec2}));
                Iterable names = sd.getReferenceNames();
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)((LinearSeqOptimized)names.toList().filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(String x$1) {
                        String string = x$1;
                        return !(string != null ? !string.equals("foo") : "foo" != null);
                    }
                })).length())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)((LinearSeqOptimized)names.toList().filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(String x$2) {
                        String string = x$2;
                        return !(string != null ? !string.equals("bar") : "bar" != null);
                    }
                })).length())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Can retrieve sequence by Name", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SequenceDictionarySuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SequenceRecord rec1 = this.$outer.record("foo", this.$outer.record$default$2(), this.$outer.record$default$3());
                SequenceRecord rec2 = this.$outer.record("bar", this.$outer.record$default$2(), this.$outer.record$default$3());
                this.$outer.assert(this.$outer.convertToEqualizer(SequenceDictionary$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SequenceRecord[]{rec1, rec2})).apply(rec1.name())).$eq$eq$eq((Object)rec1));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("SequenceDictionaries with same single element are equal", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SequenceDictionarySuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assert(this.$outer.convertToEqualizer(SequenceDictionary$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SequenceRecord[]{this.$outer.record("foo", this.$outer.record$default$2(), this.$outer.record$default$3())}))).$eq$eq$eq((Object)SequenceDictionary$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SequenceRecord[]{this.$outer.record("foo", this.$outer.record$default$2(), this.$outer.record$default$3())}))));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("SequenceDictionaries with same two elements are equals", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SequenceDictionarySuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assert(this.$outer.convertToEqualizer(SequenceDictionary$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SequenceRecord[]{this.$outer.record("foo", this.$outer.record$default$2(), this.$outer.record$default$3()), this.$outer.record("bar", this.$outer.record$default$2(), this.$outer.record$default$3())}))).$eq$eq$eq((Object)SequenceDictionary$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SequenceRecord[]{this.$outer.record("foo", this.$outer.record$default$2(), this.$outer.record$default$3()), this.$outer.record("bar", this.$outer.record$default$2(), this.$outer.record$default$3())}))));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("SequenceDictionaries with different elements are unequal", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SequenceDictionarySuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SequenceDictionary sequenceDictionary = SequenceDictionary$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SequenceRecord[]{this.$outer.record("foo", this.$outer.record$default$2(), this.$outer.record$default$3()), this.$outer.record("bar", this.$outer.record$default$2(), this.$outer.record$default$3())}));
                SequenceDictionary sequenceDictionary2 = SequenceDictionary$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SequenceRecord[]{this.$outer.record("foo", this.$outer.record$default$2(), this.$outer.record$default$3()), this.$outer.record("quux", this.$outer.record$default$2(), this.$outer.record$default$3())}));
                this.$outer.assert(sequenceDictionary != null ? !sequenceDictionary.equals(sequenceDictionary2) : sequenceDictionary2 != null);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("SequenceDictionaries with same elements in different order are equal", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SequenceDictionarySuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assert(this.$outer.convertToEqualizer(SequenceDictionary$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SequenceRecord[]{this.$outer.record("foo", this.$outer.record$default$2(), this.$outer.record$default$3()), this.$outer.record("bar", this.$outer.record$default$2(), this.$outer.record$default$3())}))).$eq$eq$eq((Object)SequenceDictionary$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SequenceRecord[]{this.$outer.record("bar", this.$outer.record$default$2(), this.$outer.record$default$3()), this.$outer.record("foo", this.$outer.record$default$2(), this.$outer.record$default$3())}))));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("isCompatible tests equality on overlap", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SequenceDictionarySuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SequenceDictionary s1 = SequenceDictionary$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SequenceRecord[]{this.$outer.record("foo", this.$outer.record$default$2(), this.$outer.record$default$3()), this.$outer.record("bar", this.$outer.record$default$2(), this.$outer.record$default$3())}));
                SequenceDictionary s2 = SequenceDictionary$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SequenceRecord[]{this.$outer.record("bar", this.$outer.record$default$2(), this.$outer.record$default$3()), this.$outer.record("quux", this.$outer.record$default$2(), this.$outer.record$default$3())}));
                SequenceDictionary s3 = SequenceDictionary$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SequenceRecord[]{this.$outer.record("foo", this.$outer.record$default$2(), this.$outer.record$default$3()), this.$outer.record("bar", this.$outer.record$default$2(), this.$outer.record$default$3())}));
                SequenceDictionary s4 = SequenceDictionary$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SequenceRecord[]{this.$outer.record("foo", 1001, this.$outer.record$default$3())}));
                this.$outer.assert(s1.isCompatibleWith(s2));
                this.$outer.assert(s1.isCompatibleWith(s3));
                this.$outer.assert(!s3.isCompatibleWith(s4));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("the addition + works correctly", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SequenceDictionarySuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SequenceDictionary s1 = SequenceDictionary$.MODULE$.apply((Seq)Nil$.MODULE$);
                SequenceDictionary s2 = SequenceDictionary$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SequenceRecord[]{this.$outer.record("foo", this.$outer.record$default$2(), this.$outer.record$default$3())}));
                SequenceDictionary s3 = SequenceDictionary$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SequenceRecord[]{this.$outer.record("foo", this.$outer.record$default$2(), this.$outer.record$default$3()), this.$outer.record("bar", this.$outer.record$default$2(), this.$outer.record$default$3())}));
                this.$outer.assert(this.$outer.convertToEqualizer(s1.$plus(this.$outer.record("foo", this.$outer.record$default$2(), this.$outer.record$default$3()))).$eq$eq$eq((Object)s2));
                this.$outer.assert(this.$outer.convertToEqualizer(s2.$plus(this.$outer.record("foo", this.$outer.record$default$2(), this.$outer.record$default$3()))).$eq$eq$eq((Object)s2));
                this.$outer.assert(this.$outer.convertToEqualizer(s2.$plus(this.$outer.record("bar", this.$outer.record$default$2(), this.$outer.record$default$3()))).$eq$eq$eq((Object)s3));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("the append operation ++ works correctly", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SequenceDictionarySuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SequenceDictionary s1 = SequenceDictionary$.MODULE$.apply((Seq)Nil$.MODULE$);
                SequenceDictionary s2a = SequenceDictionary$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SequenceRecord[]{this.$outer.record("foo", this.$outer.record$default$2(), this.$outer.record$default$3())}));
                SequenceDictionary s2b = SequenceDictionary$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SequenceRecord[]{this.$outer.record("bar", this.$outer.record$default$2(), this.$outer.record$default$3())}));
                SequenceDictionary s3 = SequenceDictionary$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SequenceRecord[]{this.$outer.record("foo", this.$outer.record$default$2(), this.$outer.record$default$3()), this.$outer.record("bar", this.$outer.record$default$2(), this.$outer.record$default$3())}));
                this.$outer.assert(this.$outer.convertToEqualizer(s1.$plus$plus(s1)).$eq$eq$eq((Object)s1));
                this.$outer.assert(this.$outer.convertToEqualizer(s1.$plus$plus(s2a)).$eq$eq$eq((Object)s2a));
                this.$outer.assert(this.$outer.convertToEqualizer(s1.$plus$plus(s2b)).$eq$eq$eq((Object)s2b));
                this.$outer.assert(this.$outer.convertToEqualizer(s2a.$plus$plus(s2b)).$eq$eq$eq((Object)s3));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("containsRefName works correctly", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SequenceDictionarySuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SequenceDictionary dict = SequenceDictionary$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SequenceRecord[]{this.$outer.record("chr0", this.$outer.record$default$2(), this.$outer.record$default$3()), this.$outer.record("chr1", this.$outer.record$default$2(), this.$outer.record$default$3()), this.$outer.record("chr2", this.$outer.record$default$2(), this.$outer.record$default$3()), this.$outer.record("chr3", this.$outer.record$default$2(), this.$outer.record$default$3())}));
                this.$outer.assert(dict.containsRefName((CharSequence)"chr0"));
                this.$outer.assert(dict.containsRefName((CharSequence)"chr1"));
                this.$outer.assert(dict.containsRefName((CharSequence)"chr2"));
                this.$outer.assert(dict.containsRefName((CharSequence)"chr3"));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("apply on name works correctly", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SequenceDictionarySuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SequenceDictionary dict = SequenceDictionary$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SequenceRecord[]{this.$outer.record("chr0", this.$outer.record$default$2(), this.$outer.record$default$3()), this.$outer.record("chr1", this.$outer.record$default$2(), this.$outer.record$default$3()), this.$outer.record("chr2", this.$outer.record$default$2(), this.$outer.record$default$3()), this.$outer.record("chr3", this.$outer.record$default$2(), this.$outer.record$default$3())}));
                this.$outer.assert(this.$outer.convertToEqualizer(dict.apply((CharSequence)"chr0").name()).$eq$eq$eq((Object)"chr0"));
                this.$outer.assert(this.$outer.convertToEqualizer(dict.apply((CharSequence)"chr1").name()).$eq$eq$eq((Object)"chr1"));
                this.$outer.assert(this.$outer.convertToEqualizer(dict.apply((CharSequence)"chr2").name()).$eq$eq$eq((Object)"chr2"));
                this.$outer.assert(this.$outer.convertToEqualizer(dict.apply((CharSequence)"chr3").name()).$eq$eq$eq((Object)"chr3"));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("get record from variant using specific record", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SequenceDictionarySuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ADAMContig contig = ADAMContig.newBuilder().setContigName((CharSequence)"chr0").setContigLength(Predef$.MODULE$.long2Long(1000L)).setReferenceURL((CharSequence)"http://bigdatagenomics.github.io/chr0").build();
                ADAMVariant variant = ADAMVariant.newBuilder().setContig(contig).setReferenceAllele((CharSequence)"A").setVariantAllele((CharSequence)"T").build();
                SequenceRecord rec = SequenceRecord$.MODULE$.fromSpecificRecord((SpecificRecord)variant);
                this.$outer.assert(this.$outer.convertToEqualizer(rec.name()).$eq$eq$eq((Object)"chr0"));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)rec.length())).$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)1000L)));
                this.$outer.assert(this.$outer.convertToEqualizer(rec.url()).$eq$eq$eq((Object)"http://bigdatagenomics.github.io/chr0"));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("convert from sam sequence record and back", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SequenceDictionarySuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SAMSequenceRecord sr = new SAMSequenceRecord("chr0", 1000);
                sr.setAssembly("http://bigdatagenomics.github.io/chr0");
                SequenceRecord conv = SequenceRecord$.MODULE$.fromSamSequenceRecord(sr);
                this.$outer.assert(this.$outer.convertToEqualizer(conv.name()).$eq$eq$eq((Object)"chr0"));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)conv.length())).$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)1000L)));
                this.$outer.assert(this.$outer.convertToEqualizer(conv.url()).$eq$eq$eq((Object)"http://bigdatagenomics.github.io/chr0"));
                SAMSequenceRecord convSr = conv.toSAMSequenceRecord();
                this.$outer.assert(convSr.isSameSequence(sr));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("convert from sam sequence dictionary", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SequenceDictionarySuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SAMSequenceRecord sr0 = new SAMSequenceRecord("chr0", 1000);
                Predef$.MODULE$.println((Object)BoxesRunTime.boxToInteger((int)sr0.getSequenceIndex()));
                List srs = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SAMSequenceRecord[]{sr0}));
                SAMSequenceDictionary ssd = new SAMSequenceDictionary(ADAMContext$.MODULE$.listToJavaList(srs));
                SequenceDictionary asd = SequenceDictionary$.MODULE$.fromSAMSequenceDictionary(ssd);
                this.$outer.assert(this.$outer.convertToEqualizer(asd.apply((CharSequence)"chr0").name()).$eq$eq$eq((Object)"chr0"));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

