/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.models;

import org.bdgenomics.adam.avro.ADAMNucleotideContigFragment;
import org.bdgenomics.adam.avro.ADAMRecord;
import org.bdgenomics.adam.models.ReferencePosition;
import org.bdgenomics.adam.models.ReferenceRegion$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordered;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0001\u0005uw!B\u0001\u0003\u0011\u0003Y\u0011a\u0004*fM\u0016\u0014XM\\2f%\u0016<\u0017n\u001c8\u000b\u0005\r!\u0011AB7pI\u0016d7O\u0003\u0002\u0006\r\u0005!\u0011\rZ1n\u0015\t9\u0001\"\u0001\u0006cI\u001e,gn\\7jGNT\u0011!C\u0001\u0004_J<7\u0001\u0001\t\u0003\u00195i\u0011A\u0001\u0004\u0006\u001d\tA\ta\u0004\u0002\u0010%\u00164WM]3oG\u0016\u0014VmZ5p]N\u0019Q\u0002\u0005\f\u0011\u0005E!R\"\u0001\n\u000b\u0003M\tQa]2bY\u0006L!!\u0006\n\u0003\r\u0005s\u0017PU3g!\t\tr#\u0003\u0002\u0019%\ta1+\u001a:jC2L'0\u00192mK\")!$\u0004C\u00017\u00051A(\u001b8jiz\"\u0012a\u0003\u0005\u0006;5!\tAH\u0001\u0006CB\u0004H.\u001f\u000b\u0004?\u0005=\u0005cA\t!E%\u0011\u0011E\u0005\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u00051\u0019c\u0001\u0002\b\u0003\u0001\u0012\u001aRa\t\t&cY\u00012A\n\u0018#\u001d\t9CF\u0004\u0002)W5\t\u0011F\u0003\u0002+\u0015\u00051AH]8pizJ\u0011aE\u0005\u0003[I\tq\u0001]1dW\u0006<W-\u0003\u00020a\t9qJ\u001d3fe\u0016$'BA\u0017\u0013!\t\t\"'\u0003\u00024%\t9\u0001K]8ek\u000e$\b\u0002C\u001b$\u0005+\u0007I\u0011\u0001\u001c\u0002\u001bI,g-\u001a:f]\u000e,g*Y7f+\u00059\u0004C\u0001\u001d<\u001d\t\t\u0012(\u0003\u0002;%\u00051\u0001K]3eK\u001aL!\u0001P\u001f\u0003\rM#(/\u001b8h\u0015\tQ$\u0003\u0003\u0005@G\tE\t\u0015!\u00038\u00039\u0011XMZ3sK:\u001cWMT1nK\u0002B\u0001\"Q\u0012\u0003\u0016\u0004%\tAQ\u0001\u0006gR\f'\u000f^\u000b\u0002\u0007B\u0011\u0011\u0003R\u0005\u0003\u000bJ\u0011A\u0001T8oO\"Aqi\tB\tB\u0003%1)\u0001\u0004ti\u0006\u0014H\u000f\t\u0005\t\u0013\u000e\u0012)\u001a!C\u0001\u0005\u0006\u0019QM\u001c3\t\u0011-\u001b#\u0011#Q\u0001\n\r\u000bA!\u001a8eA!)!d\tC\u0001\u001bR!!ET(Q\u0011\u0015)D\n1\u00018\u0011\u0015\tE\n1\u0001D\u0011\u0015IE\n1\u0001D\u0011\u0015\u00116\u0005\"\u0001C\u0003\u00159\u0018\u000e\u001a;i\u0011\u0015!6\u0005\"\u0001V\u0003\u0015iWM]4f)\t\u0011c\u000bC\u0003X'\u0002\u0007!%\u0001\u0004sK\u001eLwN\u001c\u0005\u00063\u000e\"\tAW\u0001\u0005QVdG\u000e\u0006\u0002#7\")q\u000b\u0017a\u0001E!)Ql\tC\u0001=\u0006Q\u0011n]!eU\u0006\u001cWM\u001c;\u0015\u0005}\u0013\u0007CA\ta\u0013\t\t'CA\u0004C_>dW-\u00198\t\u000b]c\u0006\u0019\u0001\u0012\t\u000b\u0011\u001cC\u0011A3\u0002\u0011\u0011L7\u000f^1oG\u0016$\"AZ4\u0011\u0007E\u00013\tC\u0003iG\u0002\u0007\u0011.A\u0003pi\",'\u000f\u0005\u0002\rU&\u00111N\u0001\u0002\u0012%\u00164WM]3oG\u0016\u0004vn]5uS>t\u0007\"\u00023$\t\u0003iGC\u00014o\u0011\u0015AG\u000e1\u0001#\u0011\u0015\u00018\u0005\"\u0001r\u0003!\u0019wN\u001c;bS:\u001cHCA0s\u0011\u0015Aw\u000e1\u0001j\u0011\u0015\u00018\u0005\"\u0001u)\tyV\u000fC\u0003ig\u0002\u0007!\u0005C\u0003xG\u0011\u0005\u00010\u0001\u0005pm\u0016\u0014H.\u00199t)\ty\u0016\u0010C\u0003im\u0002\u0007!\u0005C\u0003|G\u0011\u0005A0A\u0004d_6\u0004\u0018M]3\u0015\u0007u\f\t\u0001\u0005\u0002\u0012}&\u0011qP\u0005\u0002\u0004\u0013:$\bBBA\u0002u\u0002\u0007!%\u0001\u0003uQ\u0006$\b\"CA\u0004G\u0005\u0005I\u0011AA\u0005\u0003\u0011\u0019w\u000e]=\u0015\u000f\t\nY!!\u0004\u0002\u0010!AQ'!\u0002\u0011\u0002\u0003\u0007q\u0007\u0003\u0005B\u0003\u000b\u0001\n\u00111\u0001D\u0011!I\u0015Q\u0001I\u0001\u0002\u0004\u0019\u0005\"CA\nGE\u0005I\u0011AA\u000b\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!a\u0006+\u0007]\nIb\u000b\u0002\u0002\u001cA!\u0011QDA\u0014\u001b\t\tyB\u0003\u0003\u0002\"\u0005\r\u0012!C;oG\",7m[3e\u0015\r\t)CE\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\u0015\u0003?\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011%\ticII\u0001\n\u0003\ty#\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005E\"fA\"\u0002\u001a!I\u0011QG\u0012\u0012\u0002\u0013\u0005\u0011qF\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134\u0011%\tIdIA\u0001\n\u0003\nY$A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003{\u0001B!a\u0010\u0002J5\u0011\u0011\u0011\t\u0006\u0005\u0003\u0007\n)%\u0001\u0003mC:<'BAA$\u0003\u0011Q\u0017M^1\n\u0007q\n\t\u0005C\u0005\u0002N\r\n\t\u0011\"\u0001\u0002P\u0005a\u0001O]8ek\u000e$\u0018I]5usV\tQ\u0010C\u0005\u0002T\r\n\t\u0011\"\u0001\u0002V\u0005q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BA,\u0003;\u00022!EA-\u0013\r\tYF\u0005\u0002\u0004\u0003:L\b\"CA0\u0003#\n\t\u00111\u0001~\u0003\rAH%\r\u0005\n\u0003G\u001a\u0013\u0011!C!\u0003K\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003O\u0002b!!\u001b\u0002p\u0005]SBAA6\u0015\r\tiGE\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA9\u0003W\u0012\u0001\"\u0013;fe\u0006$xN\u001d\u0005\n\u0003k\u001a\u0013\u0011!C\u0001\u0003o\n\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0004?\u0006e\u0004BCA0\u0003g\n\t\u00111\u0001\u0002X!I\u0011QP\u0012\u0002\u0002\u0013\u0005\u0013qP\u0001\tQ\u0006\u001c\bnQ8eKR\tQ\u0010C\u0005\u0002\u0004\u000e\n\t\u0011\"\u0011\u0002\u0006\u0006AAo\\*ue&tw\r\u0006\u0002\u0002>!I\u0011\u0011R\u0012\u0002\u0002\u0013\u0005\u00131R\u0001\u0007KF,\u0018\r\\:\u0015\u0007}\u000bi\t\u0003\u0006\u0002`\u0005\u001d\u0015\u0011!a\u0001\u0003/Bq!!%\u001d\u0001\u0004\t\u0019*\u0001\u0004sK\u000e|'\u000f\u001a\t\u0005\u0003+\u000bY*\u0004\u0002\u0002\u0018*\u0019\u0011\u0011\u0014\u0003\u0002\t\u00054(o\\\u0005\u0005\u0003;\u000b9J\u0001\u0006B\t\u0006k%+Z2pe\u0012Da!H\u0007\u0005\u0002\u0005\u0005Fc\u0001\u0012\u0002$\"9\u0011QUAP\u0001\u0004I\u0017a\u00019pg\"1Q$\u0004C\u0001\u0003S#2aHAV\u0011!\ti+a*A\u0002\u0005=\u0016\u0001\u00034sC\u001elWM\u001c;\u0011\t\u0005U\u0015\u0011W\u0005\u0005\u0003g\u000b9J\u0001\u000fB\t\u0006ke*^2mK>$\u0018\u000eZ3D_:$\u0018n\u001a$sC\u001elWM\u001c;\t\u0011ui\u0011\u0011!CA\u0003o#rAIA]\u0003w\u000bi\f\u0003\u00046\u0003k\u0003\ra\u000e\u0005\u0007\u0003\u0006U\u0006\u0019A\"\t\r%\u000b)\f1\u0001D\u0011%\t\t-DA\u0001\n\u0003\u000b\u0019-A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005\u0015\u0017Q\u001a\t\u0005#\u0001\n9\r\u0005\u0004\u0012\u0003\u0013<4iQ\u0005\u0004\u0003\u0017\u0014\"A\u0002+va2,7\u0007C\u0005\u0002P\u0006}\u0016\u0011!a\u0001E\u0005\u0019\u0001\u0010\n\u0019\t\u0013\u0005MW\"!A\u0005\n\u0005U\u0017a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!a6\u0011\t\u0005}\u0012\u0011\\\u0005\u0005\u00037\f\tE\u0001\u0004PE*,7\r\u001e")
public class ReferenceRegion
implements Ordered<ReferenceRegion>,
Product,
Serializable {
    private final String referenceName;
    private final long start;
    private final long end;

    public static Option<ReferenceRegion> apply(ADAMNucleotideContigFragment aDAMNucleotideContigFragment) {
        return ReferenceRegion$.MODULE$.apply(aDAMNucleotideContigFragment);
    }

    public static ReferenceRegion apply(ReferencePosition referencePosition) {
        return ReferenceRegion$.MODULE$.apply(referencePosition);
    }

    public static Option<ReferenceRegion> apply(ADAMRecord aDAMRecord) {
        return ReferenceRegion$.MODULE$.apply(aDAMRecord);
    }

    public boolean $less(Object that) {
        return Ordered.class.$less((Ordered)this, (Object)that);
    }

    public boolean $greater(Object that) {
        return Ordered.class.$greater((Ordered)this, (Object)that);
    }

    public boolean $less$eq(Object that) {
        return Ordered.class.$less$eq((Ordered)this, (Object)that);
    }

    public boolean $greater$eq(Object that) {
        return Ordered.class.$greater$eq((Ordered)this, (Object)that);
    }

    public int compareTo(Object that) {
        return Ordered.class.compareTo((Ordered)this, (Object)that);
    }

    public String referenceName() {
        return this.referenceName;
    }

    public long start() {
        return this.start;
    }

    public long end() {
        return this.end;
    }

    public long width() {
        return this.end() - this.start();
    }

    public ReferenceRegion merge(ReferenceRegion region) {
        boolean bl = this.overlaps(region) || this.isAdjacent(region);
        Predef$ predef$ = Predef$.MODULE$;
        if (!bl) {
            throw new AssertionError((Object)new StringBuilder().append((Object)"assertion failed: ").append((Object)"Cannot merge two regions that do not overlap or are not adjacent").toString());
        }
        return this.hull(region);
    }

    public ReferenceRegion hull(ReferenceRegion region) {
        String string = this.referenceName();
        String string2 = region.referenceName();
        boolean bl = !(string != null ? !string.equals(string2) : string2 != null);
        Predef$ predef$ = Predef$.MODULE$;
        if (!bl) {
            throw new AssertionError((Object)new StringBuilder().append((Object)"assertion failed: ").append((Object)"Cannot compute convex hull of regions on different references.").toString());
        }
        return new ReferenceRegion(this.referenceName(), package$.MODULE$.min(this.start(), region.start()), package$.MODULE$.max(this.end(), region.end()));
    }

    public boolean isAdjacent(ReferenceRegion region) {
        Option<Object> option;
        block4: {
            boolean bl;
            block3: {
                block2: {
                    option = this.distance(region);
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    bl = BoxesRunTime.unboxToLong((Object)some.x()) == 1L;
                    break block3;
                }
                None$ none$ = None$.MODULE$;
                if (none$ != null ? !none$.equals(option) : option != null) break block4;
                bl = false;
            }
            return bl;
        }
        throw new MatchError(option);
    }

    public Option<Object> distance(ReferencePosition other) {
        String string = this.referenceName();
        String string2 = other.referenceName();
        return !(string != null ? !string.equals(string2) : string2 != null) ? (other.pos() < this.start() ? new Some((Object)BoxesRunTime.boxToLong((long)(this.start() - other.pos()))) : (other.pos() >= this.end() ? new Some((Object)BoxesRunTime.boxToLong((long)(other.pos() - this.end() + 1L))) : new Some((Object)BoxesRunTime.boxToLong((long)0L)))) : None$.MODULE$;
    }

    public Option<Object> distance(ReferenceRegion other) {
        String string = this.referenceName();
        String string2 = other.referenceName();
        return !(string != null ? !string.equals(string2) : string2 != null) ? (this.overlaps(other) ? new Some((Object)BoxesRunTime.boxToLong((long)0L)) : (other.start() >= this.end() ? new Some((Object)BoxesRunTime.boxToLong((long)(other.start() - this.end() + 1L))) : new Some((Object)BoxesRunTime.boxToLong((long)(this.start() - other.end() + 1L))))) : None$.MODULE$;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean contains(ReferencePosition other) {
        String string = this.referenceName();
        String string2 = other.referenceName();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (this.start() > other.pos()) return false;
        if (this.end() <= other.pos()) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean contains(ReferenceRegion other) {
        String string = this.referenceName();
        String string2 = other.referenceName();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (this.start() > other.start()) return false;
        if (this.end() < other.end()) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean overlaps(ReferenceRegion other) {
        String string = this.referenceName();
        String string2 = other.referenceName();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (this.end() <= other.start()) return false;
        if (this.start() >= other.end()) return false;
        return true;
    }

    public int compare(ReferenceRegion that) {
        String string = this.referenceName();
        String string2 = that.referenceName();
        return !(string != null ? !string.equals(string2) : string2 != null) ? (this.start() != that.start() ? Predef$.MODULE$.long2Long(this.start()).compareTo(Predef$.MODULE$.long2Long(that.start())) : Predef$.MODULE$.long2Long(this.end()).compareTo(Predef$.MODULE$.long2Long(that.end()))) : this.referenceName().compareTo(that.referenceName());
    }

    public ReferenceRegion copy(String referenceName, long start2, long end2) {
        return new ReferenceRegion(referenceName, start2, end2);
    }

    public String copy$default$1() {
        return this.referenceName();
    }

    public long copy$default$2() {
        return this.start();
    }

    public long copy$default$3() {
        return this.end();
    }

    public String productPrefix() {
        return "ReferenceRegion";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        switch (x$1) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 2: {
                object = BoxesRunTime.boxToLong((long)this.end());
                break;
            }
            case 1: {
                object = BoxesRunTime.boxToLong((long)this.start());
                break;
            }
            case 0: {
                object = this.referenceName();
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ReferenceRegion;
    }

    public int hashCode() {
        return Statics.finalizeHash((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)-889275714, (int)Statics.anyHash((Object)this.referenceName())), (int)Statics.longHash((long)this.start())), (int)Statics.longHash((long)this.end())), (int)3);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        if (!(x$1 instanceof ReferenceRegion)) return false;
        boolean bl = true;
        if (!bl) return false;
        ReferenceRegion referenceRegion = (ReferenceRegion)x$1;
        String string = this.referenceName();
        String string2 = referenceRegion.referenceName();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (this.start() != referenceRegion.start()) return false;
        if (this.end() != referenceRegion.end()) return false;
        if (!referenceRegion.canEqual(this)) return false;
        return true;
    }

    public ReferenceRegion(String referenceName, long start2, long end2) {
        this.referenceName = referenceName;
        this.start = start2;
        this.end = end2;
        Ordered.class.$init$((Ordered)this);
        Product.class.$init$((Product)this);
        Predef$.MODULE$.assert(start2 >= 0L);
        Predef$.MODULE$.assert(end2 >= start2);
    }
}

