/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.rdd;

import fi.tkk.ics.hadoop.bam.AnySAMInputFormat;
import fi.tkk.ics.hadoop.bam.SAMRecordWritable;
import fi.tkk.ics.hadoop.bam.util.SAMHeaderReader;
import java.util.Collection;
import java.util.regex.Pattern;
import net.sf.samtools.SAMFileHeader;
import org.apache.avro.Schema;
import org.apache.avro.specific.SpecificRecord;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.lib.input.TextInputFormat;
import org.apache.spark.Logging;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.bdgenomics.adam.avro.ADAMNucleotideContigFragment;
import org.bdgenomics.adam.avro.ADAMPileup;
import org.bdgenomics.adam.avro.ADAMRecord;
import org.bdgenomics.adam.converters.FastaConverter$;
import org.bdgenomics.adam.converters.SAMRecordConverter;
import org.bdgenomics.adam.models.ADAMRod;
import org.bdgenomics.adam.models.RecordGroupDictionary;
import org.bdgenomics.adam.models.RecordGroupDictionary$;
import org.bdgenomics.adam.models.SequenceDictionary;
import org.bdgenomics.adam.models.SequenceDictionary$;
import org.bdgenomics.adam.models.SequenceRecord;
import org.bdgenomics.adam.models.SequenceRecord$;
import org.bdgenomics.adam.predicates.ADAMPredicate;
import org.bdgenomics.adam.projections.ADAMNucleotideContigFragmentField$;
import org.bdgenomics.adam.projections.ADAMRecordField$;
import org.bdgenomics.adam.projections.FieldValue;
import org.bdgenomics.adam.projections.Projection$;
import org.bdgenomics.adam.rdd.ADAMContext$;
import org.bdgenomics.adam.rdd.ADAMNucleotideContigFragmentRDDFunctions;
import org.bdgenomics.adam.rdd.ADAMPileupRDDFunctions;
import org.bdgenomics.adam.rdd.ADAMRDDFunctions;
import org.bdgenomics.adam.rdd.ADAMRecordRDDFunctions;
import org.bdgenomics.adam.rdd.ADAMRodRDDFunctions;
import org.bdgenomics.adam.rich.RichADAMRecord;
import org.bdgenomics.adam.util.HadoopUtil$;
import org.slf4j.Logger;
import parquet.avro.AvroParquetInputFormat;
import parquet.avro.AvroReadSupport;
import parquet.filter.UnboundRecordFilter;
import parquet.hadoop.ParquetInputFormat;
import parquet.hadoop.util.ContextUtil;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0011Er!B\u0001\u0003\u0011\u0003Y\u0011aC!E\u00036\u001buN\u001c;fqRT!a\u0001\u0003\u0002\u0007I$GM\u0003\u0002\u0006\r\u0005!\u0011\rZ1n\u0015\t9\u0001\"\u0001\u0006cI\u001e,gn\\7jGNT\u0011!C\u0001\u0004_J<7\u0001\u0001\t\u0003\u00195i\u0011A\u0001\u0004\u0006\u001d\tA\ta\u0004\u0002\f\u0003\u0012\u000bUjQ8oi\u0016DHoE\u0002\u000e!Y\u0001\"!\u0005\u000b\u000e\u0003IQ\u0011aE\u0001\u0006g\u000e\fG.Y\u0005\u0003+I\u0011a!\u00118z%\u00164\u0007CA\t\u0018\u0013\tA\"C\u0001\u0007TKJL\u0017\r\\5{C\ndW\rC\u0003\u001b\u001b\u0011\u00051$\u0001\u0004=S:LGO\u0010\u000b\u0002\u0017!)Q$\u0004C\u0002=\u0005I2\u000f]1sW\u000e{g\u000e^3yiR{\u0017\tR!N\u0007>tG/\u001a=u)\ry\"q\n\t\u0003\u0019\u00012AA\u0004\u0002\u0001CM!\u0001\u0005\u0005\f#!\t\u0019\u0003&D\u0001%\u0015\t)c%A\u0003ta\u0006\u00148N\u0003\u0002(\u0011\u00051\u0011\r]1dQ\u0016L!!\u000b\u0013\u0003\u000f1{wmZ5oO\"A1\u0006\tB\u0001B\u0003%A&\u0001\u0002tGB\u00111%L\u0005\u0003]\u0011\u0012Ab\u00159be.\u001cuN\u001c;fqRDQA\u0007\u0011\u0005\u0002A\"\"aH\u0019\t\u000b-z\u0003\u0019\u0001\u0017\t\u000bM\u0002C\u0011\u0002\u001b\u0002+\u0005$\u0017-\u001c\"b[\u0012K7\r^5p]\u0006\u0014\u0018\u0010T8bIR\u0011Qg\u000f\t\u0003mej\u0011a\u000e\u0006\u0003q\u0011\ta!\\8eK2\u001c\u0018B\u0001\u001e8\u0005I\u0019V-];f]\u000e,G)[2uS>t\u0017M]=\t\u000bq\u0012\u0004\u0019A\u001f\u0002\u0011\u0019LG.\u001a)bi\"\u0004\"AP!\u000f\u0005Ey\u0014B\u0001!\u0013\u0003\u0019\u0001&/\u001a3fM&\u0011!i\u0011\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u0001\u0013\u0002\"B\u001a!\t\u0013)ECA\u001bG\u0011\u00159E\t1\u0001I\u0003%\u0019\u0018-\u001c%fC\u0012,'\u000f\u0005\u0002J!6\t!J\u0003\u0002L\u0019\u0006A1/Y7u_>d7O\u0003\u0002N\u001d\u0006\u00111O\u001a\u0006\u0002\u001f\u0006\u0019a.\u001a;\n\u0005ES%!D*B\u001b\u001aKG.\u001a%fC\u0012,'\u000fC\u0003TA\u0011%A+A\u000bbI\u0006l')Y7M_\u0006$'+Z1e\u000fJ|W\u000f]:\u0015\u0005UC\u0006C\u0001\u001cW\u0013\t9vGA\u000bSK\u000e|'\u000fZ$s_V\u0004H)[2uS>t\u0017M]=\t\u000b\u001d\u0013\u0006\u0019\u0001%\t\u000bi\u0003C\u0011B.\u0002\u0017\u0005$\u0017-\u001c\"b[2{\u0017\r\u001a\u000b\u00039\u001e\u00042!X0b\u001b\u0005q&BA\u0002%\u0013\t\u0001gLA\u0002S\t\u0012\u0003\"AY3\u000e\u0003\rT!\u0001\u001a\u0003\u0002\t\u00054(o\\\u0005\u0003M\u000e\u0014!\"\u0011#B\u001bJ+7m\u001c:e\u0011\u0015a\u0014\f1\u0001>\u0011\u0015I\u0007\u0005\"\u0003k\u0003=\tG-Y7QCJ\fX/\u001a;M_\u0006$W\u0003B6q\u0003S!r\u0001\\A\u000b\u0003/\ty\u0004\u0006\u0003ns\u0006-\u0001cA/`]B\u0011q\u000e\u001d\u0007\u0001\t\u0015\t\bN1\u0001s\u0005\u0005!\u0016CA:w!\t\tB/\u0003\u0002v%\t9aj\u001c;iS:<\u0007CA\tx\u0013\tA(CA\u0002B]fDqA\u001f5\u0002\u0002\u0003\u000f10\u0001\u0006fm&$WM\\2fIM\u0002B!\u0005?o}&\u0011QP\u0005\u0002\n\rVt7\r^5p]F\u00022a`A\u0004\u001b\t\t\tA\u0003\u0003\u0002\u0004\u0005\u0015\u0011\u0001C:qK\u000eLg-[2\u000b\u0005\u00114\u0013\u0002BA\u0005\u0003\u0003\u0011ab\u00159fG&4\u0017n\u0019*fG>\u0014H\rC\u0005\u0002\u000e!\f\t\u0011q\u0001\u0002\u0010\u0005QQM^5eK:\u001cW\r\n\u001b\u0011\ty\n\tB\\\u0005\u0004\u0003'\u0019%\u0001C'b]&4Wm\u001d;\t\u000bqB\u0007\u0019A\u001f\t\u0013\u0005e\u0001\u000e%AA\u0002\u0005m\u0011!\u00039sK\u0012L7-\u0019;f!\u0015\t\u0012QDA\u0011\u0013\r\tyB\u0005\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u000by\n\u0019#a\n\n\u0007\u0005\u00152IA\u0003DY\u0006\u001c8\u000fE\u0002p\u0003S!q!a\u000bi\u0005\u0004\tiCA\u0001V#\r\u0019\u0018q\u0006\t\u0005\u0003c\tY$\u0004\u0002\u00024)!\u0011QGA\u001c\u0003\u00191\u0017\u000e\u001c;fe*\u0011\u0011\u0011H\u0001\ba\u0006\u0014\u0018/^3u\u0013\u0011\ti$a\r\u0003'Us'm\\;oIJ+7m\u001c:e\r&dG/\u001a:\t\u0013\u0005\u0005\u0003\u000e%AA\u0002\u0005\r\u0013A\u00039s_*,7\r^5p]B)\u0011#!\b\u0002FA!\u0011qIA%\u001b\t\t)!\u0003\u0003\u0002L\u0005\u0015!AB*dQ\u0016l\u0017\rC\u0004\u0002P\u0001\"\t!!\u0015\u0002%\u0005$\u0017-\u001c#jGRLwN\\1ss2{\u0017\rZ\u000b\u0005\u0003'\ny\u0006\u0006\u0003\u0002V\u0005\u001dD#B\u001b\u0002X\u0005\u0005\u0004BCA-\u0003\u001b\n\t\u0011q\u0001\u0002\\\u0005QQM^5eK:\u001cW\rJ\u001b\u0011\u000bEa\u0018Q\f@\u0011\u0007=\fy\u0006\u0002\u0004r\u0003\u001b\u0012\rA\u001d\u0005\u000b\u0003G\ni%!AA\u0004\u0005\u0015\u0014AC3wS\u0012,gnY3%mA)a(!\u0005\u0002^!1A(!\u0014A\u0002uBq!a\u001b!\t\u0003\ti'\u0001\u0005bI\u0006lGj\\1e+\u0019\ty'a\u001e\u0002\u0010RA\u0011\u0011OAC\u0003\u000f\u000by\n\u0006\u0004\u0002t\u0005e\u0014q\u0010\t\u0005;~\u000b)\bE\u0002p\u0003o\"a!]A5\u0005\u0004\u0011\bBCA>\u0003S\n\t\u0011q\u0001\u0002~\u0005QQM^5eK:\u001cW\rJ\u001c\u0011\u000bEa\u0018Q\u000f@\t\u0015\u0005\u0005\u0015\u0011NA\u0001\u0002\b\t\u0019)\u0001\u0006fm&$WM\\2fIa\u0002RAPA\t\u0003kBa\u0001PA5\u0001\u0004i\u0004BCA\r\u0003S\u0002\n\u00111\u0001\u0002\nB)\u0011#!\b\u0002\fB)a(a\t\u0002\u000eB\u0019q.a$\u0005\u0011\u0005-\u0012\u0011\u000eb\u0001\u0003#\u000b2a]AJ!\u0019\t)*a'\u0002v5\u0011\u0011q\u0013\u0006\u0004\u00033#\u0011A\u00039sK\u0012L7-\u0019;fg&!\u0011QTAL\u00055\tE)Q'Qe\u0016$\u0017nY1uK\"Q\u0011\u0011IA5!\u0003\u0005\r!a\u0011\t\u000f\u0005\r\u0006\u0005\"\u0001\u0002&\u0006\u0001\u0012\rZ1n'\u0016\fX/\u001a8dK2{\u0017\r\u001a\u000b\u0007\u0003O\u000by+!-\u0011\tu{\u0016\u0011\u0016\t\u0004E\u0006-\u0016bAAWG\na\u0012\tR!N\u001dV\u001cG.Z8uS\u0012,7i\u001c8uS\u001e4%/Y4nK:$\bB\u0002\u001f\u0002\"\u0002\u0007Q\b\u0003\u0005\u00024\u0006\u0005\u0006\u0019AA[\u000391'/Y4nK:$H*\u001a8hi\"\u00042!EA\\\u0013\r\tIL\u0005\u0002\u0005\u0019>tw\rC\u0004\u0002>\u0002\"\t!a0\u0002\u0013\u0019Lg\u000e\u001a$jY\u0016\u001cHCBAa\u0003S\fi\u000f\u0005\u0004\u0002D\u0006M\u0017\u0011\u001c\b\u0005\u0003\u000b\fyM\u0004\u0003\u0002H\u00065WBAAe\u0015\r\tYMC\u0001\u0007yI|w\u000e\u001e \n\u0003MI1!!5\u0013\u0003\u001d\u0001\u0018mY6bO\u0016LA!!6\u0002X\n\u00191+Z9\u000b\u0007\u0005E'\u0003\u0005\u0003\u0002\\\u0006\u0015XBAAo\u0015\u0011\ty.!9\u0002\u0005\u0019\u001c(bAArM\u00051\u0001.\u00193p_BLA!a:\u0002^\n!\u0001+\u0019;i\u0011!\tY/a/A\u0002\u0005e\u0017\u0001\u00029bi\"Dq!a<\u0002<\u0002\u0007Q(A\u0003sK\u001e,\u0007\u0010C\u0004\u0002t\u0002\"\t!!>\u0002#1|\u0017\rZ!E\u000363%o\\7QCRD7\u000fF\u0002]\u0003oD\u0001\"!?\u0002r\u0002\u0007\u0011\u0011Y\u0001\u0006a\u0006$\bn\u001d\u0005\n\u0003{\u0004\u0013\u0013!C\u0005\u0003\u007f\f\u0011$\u00193b[B\u000b'/];fi2{\u0017\r\u001a\u0013eK\u001a\fW\u000f\u001c;%eU1!\u0011\u0001B\u000f\u0005?)\"Aa\u0001+\t\t\u0015!1\u0002\b\u0004#\t\u001d\u0011b\u0001B\u0005%\u0005!aj\u001c8fW\t\u0011i\u0001\u0005\u0003\u0003\u0010\teQB\u0001B\t\u0015\u0011\u0011\u0019B!\u0006\u0002\u0013Ut7\r[3dW\u0016$'b\u0001B\f%\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\tm!\u0011\u0003\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,GAB9\u0002|\n\u0007!\u000f\u0002\u0005\u0002,\u0005m(\u0019AA\u0017\u0011%\u0011\u0019\u0003II\u0001\n\u0013\u0011)#A\rbI\u0006l\u0007+\u0019:rk\u0016$Hj\\1eI\u0011,g-Y;mi\u0012\u001aTC\u0002B\u0014\u0005W\u0011i#\u0006\u0002\u0003*)\"\u00111\tB\u0006\t\u0019\t(\u0011\u0005b\u0001e\u0012A\u00111\u0006B\u0011\u0005\u0004\ti\u0003C\u0005\u00032\u0001\n\n\u0011\"\u0001\u00034\u0005\u0011\u0012\rZ1n\u0019>\fG\r\n3fM\u0006,H\u000e\u001e\u00133+\u0019\u0011\tA!\u000e\u00038\u00111\u0011Oa\fC\u0002I$\u0001\"a\u000b\u00030\t\u0007!\u0011H\t\u0004g\nm\u0002CBAK\u00037\u0013i\u0004E\u0002p\u0005kA\u0011B!\u0011!#\u0003%\tAa\u0011\u0002%\u0005$\u0017-\u001c'pC\u0012$C-\u001a4bk2$HeM\u000b\u0007\u0005O\u0011)Ea\u0012\u0005\rE\u0014yD1\u0001s\t!\tYCa\u0010C\u0002\t%\u0013cA:\u0003LA1\u0011QSAN\u0005\u001b\u00022a\u001cB#\u0011\u0015YC\u00041\u0001-\u0011\u001d\u0011\u0019&\u0004C\u0002\u0005+\n!C\u001d3e)>\fE)Q'SK\u000e|'\u000f\u001a*E\tR!!q\u000bB/!\ra!\u0011L\u0005\u0004\u00057\u0012!AF!E\u00036\u0013VmY8sIJ#EIR;oGRLwN\\:\t\r\r\u0011\t\u00061\u0001]\u0011\u001d\u0011\t'\u0004C\u0002\u0005G\n!C\u001d3e)>\fE)Q'QS2,W\u000f\u001d*E\tR!!Q\rB6!\ra!qM\u0005\u0004\u0005S\u0012!AF!E\u00036\u0003\u0016\u000e\\3vaJ#EIR;oGRLwN\\:\t\u000f\r\u0011y\u00061\u0001\u0003nA!Ql\u0018B8!\r\u0011'\u0011O\u0005\u0004\u0005g\u001a'AC!E\u00036\u0003\u0016\u000e\\3va\"9!qO\u0007\u0005\u0004\te\u0014a\u0004:eIR{\u0017\tR!N%>$'\u000b\u0012#\u0015\t\tm$\u0011\u0011\t\u0004\u0019\tu\u0014b\u0001B@\u0005\t\u0019\u0012\tR!N%>$'\u000b\u0012#Gk:\u001cG/[8og\"91A!\u001eA\u0002\t\r\u0005\u0003B/`\u0005\u000b\u00032A\u000eBD\u0013\r\u0011Ii\u000e\u0002\b\u0003\u0012\u000bUJU8e\u0011\u001d\u0011i)\u0004C\u0002\u0005\u001f\u000bAB\u001d3e)>\fE)Q'S\t\u0012+BA!%\u0003\u001eR!!1\u0013BV)\u0019\u0011)Ja(\u0003&B)ABa&\u0003\u001c&\u0019!\u0011\u0014\u0002\u0003!\u0005#\u0015)\u0014*E\t\u001a+hn\u0019;j_:\u001c\bcA8\u0003\u001e\u00121\u0011Oa#C\u0002ID!B!)\u0003\f\u0006\u0005\t9\u0001BR\u0003))g/\u001b3f]\u000e,G%\r\t\u0006#q\u0014YJ \u0005\u000b\u0005O\u0013Y)!AA\u0004\t%\u0016AC3wS\u0012,gnY3%eA)a(!\u0005\u0003\u001c\"91Aa#A\u0002\t5\u0006\u0003B/`\u00057CqA!$\u000e\t\u0007\u0011\t\f\u0006\u0003\u00034\ne\u0006c\u0001\u0007\u00036&\u0019!q\u0017\u0002\u0003Q\u0005#\u0015)\u0014(vG2,w\u000e^5eK\u000e{g\u000e^5h\rJ\fw-\\3oiJ#EIR;oGRLwN\\:\t\u000f\r\u0011y\u000b1\u0001\u0002(\"9!QX\u0007\u0005\u0004\t}\u0016A\u0005:fG>\u0014H\rV8SS\u000eD'+Z2pe\u0012$BA!1\u0003NB!!1\u0019Be\u001b\t\u0011)MC\u0002\u0003H\u0012\tAA]5dQ&!!1\u001aBc\u00059\u0011\u0016n\u00195B\t\u0006k%+Z2pe\u0012DqAa4\u0003<\u0002\u0007\u0011-\u0001\u0004sK\u000e|'\u000f\u001a\u0005\b\u0005'lA1\u0001Bk\u00039a\u0017n\u001d;U_*\u000bg/\u0019'jgR,BAa6\u0003lR!!\u0011\u001cBx!\u0019\u0011YN!:\u0003j6\u0011!Q\u001c\u0006\u0005\u0005?\u0014\t/\u0001\u0003vi&d'B\u0001Br\u0003\u0011Q\u0017M^1\n\t\t\u001d(Q\u001c\u0002\u0005\u0019&\u001cH\u000fE\u0002p\u0005W$qA!<\u0003R\n\u0007!OA\u0001B\u0011!\u0011\tP!5A\u0002\tM\u0018\u0001\u00027jgR\u0004b!a1\u0003v\n%\u0018\u0002\u0002Bt\u0003/DqA!?\u000e\t\u0007\u0011Y0\u0001\bkCZ\fG*[:u)>d\u0015n\u001d;\u0016\t\tu81\u0001\u000b\u0005\u0005\u007f\u001c)\u0001\u0005\u0004\u0002D\nU8\u0011\u0001\t\u0004_\u000e\rAa\u0002Bw\u0005o\u0014\rA\u001d\u0005\t\u0005c\u00149\u00101\u0001\u0004\bA1!1\u001cBs\u0007\u0003Aqaa\u0003\u000e\t\u0007\u0019i!\u0001\u0007kCZ\f7+\u001a;U_N+G/\u0006\u0003\u0004\u0010\reA\u0003BB\t\u00077\u0001RAPB\n\u0007/I1a!\u0006D\u0005\r\u0019V\r\u001e\t\u0004_\u000eeAa\u0002Bw\u0007\u0013\u0011\rA\u001d\u0005\t\u0007;\u0019I\u00011\u0001\u0004 \u0005\u00191/\u001a;\u0011\r\tm7\u0011EB\f\u0013\u0011\u0019)B!8\t\u000f\r\u0015R\u0002b\u0001\u0004(\u0005A\u0012N\u001c;MSN$Hk\u001c&bm\u0006Le\u000e^3hKJd\u0015n\u001d;\u0015\t\r%2q\u0007\t\u0007\u00057\u0014)oa\u000b\u0011\t\r521G\u0007\u0003\u0007_QAa!\r\u0003b\u0006!A.\u00198h\u0013\u0011\u0019)da\f\u0003\u000f%sG/Z4fe\"A!\u0011_B\u0012\u0001\u0004\u0019I\u0004\u0005\u0004\u0002D\nU81\b\t\u0004#\ru\u0012bAB %\t\u0019\u0011J\u001c;\t\u000f\r\rS\u0002b\u0001\u0004F\u0005!2\r[1s'\u0016\fX/\u001a8dKR{7\u000b\u001e:j]\u001e$2!PB$\u0011!\u0019Ie!\u0011A\u0002\r-\u0013AA2t!\u0011\u0019ic!\u0014\n\t\r=3q\u0006\u0002\r\u0007\"\f'oU3rk\u0016t7-\u001a\u0005\b\u0007'jA1AB+\u0003I\u0019\u0007.\u0019:TKF,XM\\2f)>d\u0015n\u001d;\u0015\t\r]3q\f\t\u0007\u0003\u0007\u0014)p!\u0017\u0011\u0007E\u0019Y&C\u0002\u0004^I\u0011Aa\u00115be\"A1\u0011JB)\u0001\u0004\u0019Y\u0005C\u0004\u0004d5!\u0019a!\u001a\u0002\u00195\f\u0007\u000fV8KCZ\fW*\u00199\u0016\r\r\u001d4\u0011OB;)\u0011\u0019Ig!\u001f\u0011\u0011\tm71NB8\u0007gJAa!\u001c\u0003^\n\u0019Q*\u00199\u0011\u0007=\u001c\t\bB\u0004\u0003n\u000e\u0005$\u0019\u0001:\u0011\u0007=\u001c)\bB\u0004\u0004x\r\u0005$\u0019\u0001:\u0003\u0003\tC\u0001ba\u001f\u0004b\u0001\u00071QP\u0001\u0004[\u0006\u0004\b\u0003CB@\u0007\u000b\u001byga\u001d\u000e\u0005\r\u0005%bABB%\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\r54\u0011\u0011\u0005\b\u0007\u0013kA1ABF\u0003aIG/\u001a:bE2,Gk\u001c&bm\u0006\u001cu\u000e\u001c7fGRLwN\\\u000b\u0005\u0007\u001b\u001b9\n\u0006\u0003\u0004\u0010\u000ee\u0005C\u0002Bn\u0007#\u001b)*\u0003\u0003\u0004\u0014\nu'AC\"pY2,7\r^5p]B\u0019qna&\u0005\u000f\t58q\u0011b\u0001e\"A11TBD\u0001\u0004\u0019i*A\u0001j!\u0019\t\u0019ma(\u0004\u0016&!1\u0011UAl\u0005!IE/\u001a:bE2,\u0007bBBS\u001b\u0011\r1qU\u0001\rg\u0016$Hk\u001c&bm\u0006\u001cV\r^\u000b\u0005\u0007S\u001by\u000b\u0006\u0003\u0004,\u000eE\u0006C\u0002Bn\u0007C\u0019i\u000bE\u0002p\u0007_#qA!<\u0004$\n\u0007!\u000f\u0003\u0005\u0004\u001e\r\r\u0006\u0019ABZ!\u0015q41CBW\u0011\u001d\u00199,\u0004C\u0001\u0007s\u000b!c\u0019:fCR,7\u000b]1sW\u000e{g\u000e^3yiR\u0019Bfa/\u0004@\u000e\r7qYBg\u00073\u001c\u0019oa:\u0004l\"91QXB[\u0001\u0004i\u0014\u0001\u00028b[\u0016Dqa!1\u00046\u0002\u0007Q(\u0001\u0004nCN$XM\u001d\u0005\n\u0007\u000b\u001c)\f%AA\u0002u\n\u0011b\u001d9be.Du.\\3\t\u0015\r%7Q\u0017I\u0001\u0002\u0004\u0019Y-A\u0005ta\u0006\u00148NS1sgB)\u00111YAj{!Q1qZB[!\u0003\u0005\ra!5\u0002\u0019M\u0004\u0018M]6F]Z4\u0016M]:\u0011\r\u0005\r\u00171[Bj!\u0015\t2Q[\u001f>\u0013\r\u00199N\u0005\u0002\u0007)V\u0004H.\u001a\u001a\t\u0015\rm7Q\u0017I\u0001\u0002\u0004\u0019i.A\u000bta\u0006\u00148.\u00113e'R\fGo\u001d'jgR,g.\u001a:\u0011\u0007E\u0019y.C\u0002\u0004bJ\u0011qAQ8pY\u0016\fg\u000e\u0003\u0006\u0004f\u000eU\u0006\u0013!a\u0001\u0007w\t1c\u001d9be.\\%/_8Ck\u001a4WM]*ju\u0016D!b!;\u00046B\u0005\t\u0019ABo\u0003Aaw.\u00193TsN$X-\u001c,bYV,7\u000f\u0003\u0006\u0004n\u000eU\u0006\u0013!a\u0001\u0007_\fqb\u001d9be.$%/\u001b<feB{'\u000f\u001e\t\u0006#\u0005u11\b\u0005\n\u0007gl\u0011\u0013!C\u0001\u0007k\fAd\u0019:fCR,7\u000b]1sW\u000e{g\u000e^3yi\u0012\"WMZ1vYR$3'\u0006\u0002\u0004x*\u001aQHa\u0003\t\u0013\rmX\"%A\u0005\u0002\ru\u0018\u0001H2sK\u0006$Xm\u00159be.\u001cuN\u001c;fqR$C-\u001a4bk2$H\u0005N\u000b\u0003\u0007\u007fTCaa3\u0003\f!IA1A\u0007\u0012\u0002\u0013\u0005AQA\u0001\u001dGJ,\u0017\r^3Ta\u0006\u00148nQ8oi\u0016DH\u000f\n3fM\u0006,H\u000e\u001e\u00136+\t!9A\u000b\u0003\u0004R\n-\u0001\"\u0003C\u0006\u001bE\u0005I\u0011\u0001C\u0007\u0003q\u0019'/Z1uKN\u0003\u0018M]6D_:$X\r\u001f;%I\u00164\u0017-\u001e7uIY*\"\u0001b\u0004+\t\ru'1\u0002\u0005\n\t'i\u0011\u0013!C\u0001\t+\tAd\u0019:fCR,7\u000b]1sW\u000e{g\u000e^3yi\u0012\"WMZ1vYR$s'\u0006\u0002\u0005\u0018)\"11\bB\u0006\u0011%!Y\"DI\u0001\n\u0003!i!\u0001\u000fde\u0016\fG/Z*qCJ\\7i\u001c8uKb$H\u0005Z3gCVdG\u000f\n\u001d\t\u0013\u0011}Q\"%A\u0005\u0002\u0011\u0005\u0012\u0001H2sK\u0006$Xm\u00159be.\u001cuN\u001c;fqR$C-\u001a4bk2$H%O\u000b\u0003\tGQCaa<\u0003\f!IAqE\u0007\u0002\u0002\u0013%A\u0011F\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0005,A!1Q\u0006C\u0017\u0013\u0011!yca\f\u0003\r=\u0013'.Z2u\u0001")
public class ADAMContext
implements Serializable,
Logging {
    private final SparkContext sc;
    private transient Logger org$apache$spark$Logging$$log_;

    public static Option<Object> createSparkContext$default$9() {
        return ADAMContext$.MODULE$.createSparkContext$default$9();
    }

    public static boolean createSparkContext$default$8() {
        return ADAMContext$.MODULE$.createSparkContext$default$8();
    }

    public static int createSparkContext$default$7() {
        return ADAMContext$.MODULE$.createSparkContext$default$7();
    }

    public static boolean createSparkContext$default$6() {
        return ADAMContext$.MODULE$.createSparkContext$default$6();
    }

    public static Seq<Tuple2<String, String>> createSparkContext$default$5() {
        return ADAMContext$.MODULE$.createSparkContext$default$5();
    }

    public static Seq<String> createSparkContext$default$4() {
        return ADAMContext$.MODULE$.createSparkContext$default$4();
    }

    public static String createSparkContext$default$3() {
        return ADAMContext$.MODULE$.createSparkContext$default$3();
    }

    public static SparkContext createSparkContext(String string, String string2, String string3, Seq<String> seq, Seq<Tuple2<String, String>> seq2, boolean bl, int n, boolean bl2, Option<Object> option) {
        return ADAMContext$.MODULE$.createSparkContext(string, string2, string3, seq, seq2, bl, n, bl2, option);
    }

    public static <A> java.util.Set<A> setToJavaSet(scala.collection.immutable.Set<A> set) {
        return ADAMContext$.MODULE$.setToJavaSet(set);
    }

    public static <A> Collection<A> iterableToJavaCollection(Iterable<A> iterable) {
        return ADAMContext$.MODULE$.iterableToJavaCollection(iterable);
    }

    public static <A, B> java.util.Map<A, B> mapToJavaMap(Map<A, B> map) {
        return ADAMContext$.MODULE$.mapToJavaMap(map);
    }

    public static List<Object> charSequenceToList(CharSequence charSequence) {
        return ADAMContext$.MODULE$.charSequenceToList(charSequence);
    }

    public static String charSequenceToString(CharSequence charSequence) {
        return ADAMContext$.MODULE$.charSequenceToString(charSequence);
    }

    public static java.util.List<Integer> intListToJavaIntegerList(List<Object> list) {
        return ADAMContext$.MODULE$.intListToJavaIntegerList(list);
    }

    public static <A> scala.collection.immutable.Set<A> javaSetToSet(java.util.Set<A> set) {
        return ADAMContext$.MODULE$.javaSetToSet(set);
    }

    public static <A> List<A> javaListToList(java.util.List<A> list) {
        return ADAMContext$.MODULE$.javaListToList(list);
    }

    public static <A> java.util.List<A> listToJavaList(List<A> list) {
        return ADAMContext$.MODULE$.listToJavaList(list);
    }

    public static RichADAMRecord recordToRichRecord(ADAMRecord aDAMRecord) {
        return ADAMContext$.MODULE$.recordToRichRecord(aDAMRecord);
    }

    public static ADAMNucleotideContigFragmentRDDFunctions rddToADAMRDD(RDD<ADAMNucleotideContigFragment> rDD) {
        return ADAMContext$.MODULE$.rddToADAMRDD(rDD);
    }

    public static <T> ADAMRDDFunctions<T> rddToADAMRDD(RDD<T> rDD, Function1<T, SpecificRecord> function1, Manifest<T> manifest) {
        return ADAMContext$.MODULE$.rddToADAMRDD(rDD, function1, manifest);
    }

    public static ADAMRodRDDFunctions rddToADAMRodRDD(RDD<ADAMRod> rDD) {
        return ADAMContext$.MODULE$.rddToADAMRodRDD(rDD);
    }

    public static ADAMPileupRDDFunctions rddToADAMPileupRDD(RDD<ADAMPileup> rDD) {
        return ADAMContext$.MODULE$.rddToADAMPileupRDD(rDD);
    }

    public static ADAMRecordRDDFunctions rddToADAMRecordRDD(RDD<ADAMRecord> rDD) {
        return ADAMContext$.MODULE$.rddToADAMRecordRDD(rDD);
    }

    public static ADAMContext sparkContextToADAMContext(SparkContext sparkContext) {
        return ADAMContext$.MODULE$.sparkContextToADAMContext(sparkContext);
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    private SequenceDictionary adamBamDictionaryLoad(String filePath) {
        SAMFileHeader samHeader = SAMHeaderReader.readSAMHeaderFrom((Path)new Path(filePath), (Configuration)this.sc.hadoopConfiguration());
        return this.adamBamDictionaryLoad(samHeader);
    }

    private SequenceDictionary adamBamDictionaryLoad(SAMFileHeader samHeader) {
        return SequenceDictionary$.MODULE$.fromSAMHeader(samHeader);
    }

    private RecordGroupDictionary adamBamLoadReadGroups(SAMFileHeader samHeader) {
        return RecordGroupDictionary$.MODULE$.fromSAMHeader(samHeader);
    }

    private RDD<ADAMRecord> adamBamLoad(String filePath) {
        Predef$ predef$ = Predef$.MODULE$;
        this.log().info(new StringOps("Reading legacy BAM file format %s to create RDD").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{filePath})));
        SAMFileHeader samHeader = SAMHeaderReader.readSAMHeaderFrom((Path)new Path(filePath), (Configuration)this.sc.hadoopConfiguration());
        SequenceDictionary seqDict = this.adamBamDictionaryLoad(samHeader);
        RecordGroupDictionary readGroups = this.adamBamLoadReadGroups(samHeader);
        Job job = HadoopUtil$.MODULE$.newJob(this.sc);
        RDD records = this.sc.newAPIHadoopFile(filePath, AnySAMInputFormat.class, LongWritable.class, SAMRecordWritable.class, ContextUtil.getConfiguration((JobContext)job));
        SAMRecordConverter samRecordConverter = new SAMRecordConverter();
        return records.map((Function1)new Serializable(this, seqDict, readGroups, samRecordConverter){
            public static final long serialVersionUID = 0L;
            private final SequenceDictionary seqDict$1;
            private final RecordGroupDictionary readGroups$1;
            private final SAMRecordConverter samRecordConverter$1;

            public final ADAMRecord apply(Tuple2<LongWritable, SAMRecordWritable> p) {
                return this.samRecordConverter$1.convert(((SAMRecordWritable)p._2()).get(), this.seqDict$1, this.readGroups$1);
            }
            {
                this.seqDict$1 = seqDict$1;
                this.readGroups$1 = readGroups$1;
                this.samRecordConverter$1 = samRecordConverter$1;
            }
        }, ClassTag$.MODULE$.apply(ADAMRecord.class));
    }

    private <T, U extends UnboundRecordFilter> RDD<T> adamParquetLoad(String filePath, Option<Class<U>> predicate, Option<Schema> projection, Function1<T, SpecificRecord> evidence$3, Manifest<T> evidence$4) {
        Predef$ predef$ = Predef$.MODULE$;
        this.log().info(new StringOps("Reading the ADAM file at %s to create RDD").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{filePath})));
        Job job = HadoopUtil$.MODULE$.newJob(this.sc);
        ParquetInputFormat.setReadSupportClass((Job)job, AvroReadSupport.class);
        if (predicate.isDefined()) {
            this.log().info("Using the specified push-down predicate");
            ParquetInputFormat.setUnboundRecordFilter((Job)job, (Class)((Class)predicate.get()));
        }
        if (projection.isDefined()) {
            this.log().info("Using the specified projection schema");
            AvroParquetInputFormat.setRequestedProjection((Job)job, (Schema)((Schema)projection.get()));
        }
        RDD records = this.sc.newAPIHadoopFile(filePath, ParquetInputFormat.class, Void.class, Predef$.MODULE$.manifest(evidence$4).runtimeClass(), ContextUtil.getConfiguration((JobContext)job)).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final T apply(Tuple2<Void, T> p) {
                return (T)p._2();
            }
        }, evidence$4);
        return predicate.isDefined() ? records.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(T p) {
                return p != null;
            }
        }) : records;
    }

    private <T, U extends UnboundRecordFilter> None$ adamParquetLoad$default$2() {
        return None$.MODULE$;
    }

    private <T, U extends UnboundRecordFilter> Option<Schema> adamParquetLoad$default$3() {
        return None$.MODULE$;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <T> SequenceDictionary adamDictionaryLoad(String filePath, Function1<T, SpecificRecord> evidence$5, Manifest<T> evidence$6) {
        SequenceDictionary sequenceDictionary;
        Schema projection;
        boolean isADAMRecord = ADAMRecord.class.isAssignableFrom(Predef$.MODULE$.manifest(evidence$6).runtimeClass());
        boolean isADAMContig = ADAMNucleotideContigFragment.class.isAssignableFrom(Predef$.MODULE$.manifest(evidence$6).runtimeClass());
        Schema schema = isADAMRecord ? Projection$.MODULE$.apply((Seq<FieldValue>)Predef$.MODULE$.wrapRefArray((Object[])new FieldValue[]{ADAMRecordField$.MODULE$.contig(), ADAMRecordField$.MODULE$.mateContig(), ADAMRecordField$.MODULE$.readPaired(), ADAMRecordField$.MODULE$.firstOfPair(), ADAMRecordField$.MODULE$.readMapped(), ADAMRecordField$.MODULE$.mateMapped()})) : (projection = isADAMContig ? Projection$.MODULE$.apply((Seq<FieldValue>)Predef$.MODULE$.wrapRefArray((Object[])new FieldValue[]{ADAMNucleotideContigFragmentField$.MODULE$.contig()})) : Projection$.MODULE$.apply((Seq<FieldValue>)Predef$.MODULE$.wrapRefArray((Object[])new FieldValue[]{ADAMRecordField$.MODULE$.contig()})));
        if (filePath.endsWith(".bam") || filePath.endsWith(".sam")) {
            if (!isADAMRecord) throw new IllegalArgumentException("If you're reading a BAM/SAM file, the record type must be ADAMRecord");
            sequenceDictionary = this.adamBamDictionaryLoad(filePath);
            return sequenceDictionary;
        } else {
            SequenceDictionary dict;
            RDD<T> projected = this.adamParquetLoad(filePath, (Option)None$.MODULE$, (Option<Schema>)new Some((Object)projection), evidence$5, evidence$6);
            RDD recs = isADAMRecord ? projected.distinct().flatMap((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Set<SequenceRecord> apply(ADAMRecord rec) {
                    return SequenceRecord$.MODULE$.fromADAMRecord(rec);
                }
            }, ClassTag$.MODULE$.apply(SequenceRecord.class)) : (isADAMContig ? projected.distinct().map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final SequenceRecord apply(ADAMNucleotideContigFragment ctg) {
                    return SequenceRecord$.MODULE$.fromADAMContigFragment(ctg);
                }
            }, ClassTag$.MODULE$.apply(SequenceRecord.class)) : projected.distinct().map((Function1)new Serializable(this, evidence$5){
                public static final long serialVersionUID = 0L;
                private final Function1 evidence$5$1;

                public final SequenceRecord apply(T x$1) {
                    return SequenceRecord$.MODULE$.fromSpecificRecord((SpecificRecord)this.evidence$5$1.apply(x$1));
                }
                {
                    this.evidence$5$1 = evidence$5$1;
                }
            }, ClassTag$.MODULE$.apply(SequenceRecord.class)));
            sequenceDictionary = dict = (SequenceDictionary)recs.aggregate((Object)SequenceDictionary$.MODULE$.apply((Seq<SequenceRecord>)Nil$.MODULE$), (Function2)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final SequenceDictionary apply(SequenceDictionary dict, SequenceRecord rec) {
                    return dict.$plus(rec);
                }
            }, (Function2)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final SequenceDictionary apply(SequenceDictionary dict1, SequenceDictionary dict2) {
                    return dict1.$plus$plus(dict2);
                }
            }, ClassTag$.MODULE$.apply(SequenceDictionary.class));
        }
        return sequenceDictionary;
    }

    public <T, U extends ADAMPredicate<T>> RDD<T> adamLoad(String filePath, Option<Class<U>> predicate, Option<Schema> projection, Function1<T, SpecificRecord> evidence$7, Manifest<T> evidence$8) {
        Object object;
        if (filePath.endsWith(".bam") || filePath.endsWith(".sam") && ADAMRecord.class.isAssignableFrom(Predef$.MODULE$.manifest(evidence$8).runtimeClass())) {
            if (projection.isDefined()) {
                this.log().warn("Projection is ignored when loading a BAM file");
            }
            RDD<ADAMRecord> reads = this.adamBamLoad(filePath);
            if (predicate.isDefined()) {
                Class predicateClass = (Class)predicate.get();
                ADAMPredicate filter = (ADAMPredicate)predicateClass.newInstance();
                object = filter.apply(reads);
            } else {
                object = reads;
            }
        } else {
            object = this.adamParquetLoad(filePath, predicate, projection, evidence$7, evidence$8);
        }
        return object;
    }

    public <T, U extends ADAMPredicate<T>> None$ adamLoad$default$2() {
        return None$.MODULE$;
    }

    public <T, U extends ADAMPredicate<T>> Option<Schema> adamLoad$default$3() {
        return None$.MODULE$;
    }

    public RDD<ADAMNucleotideContigFragment> adamSequenceLoad(String filePath, long fragmentLength) {
        Object object;
        if (filePath.endsWith(".fasta") || filePath.endsWith(".fa")) {
            RDD fastaData = this.sc.newAPIHadoopFile(filePath, TextInputFormat.class, LongWritable.class, Text.class, this.sc.newAPIHadoopFile$default$5());
            RDD remapData = fastaData.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Tuple2<Object, String> apply(Tuple2<LongWritable, Text> kv) {
                    return new Tuple2((Object)BoxesRunTime.boxToLong((long)((LongWritable)kv._1()).get()), (Object)((Text)kv._2()).toString());
                }
            }, ClassTag$.MODULE$.apply(Tuple2.class));
            this.log().info("Converting FASTA to ADAM.");
            object = FastaConverter$.MODULE$.apply((RDD<Tuple2<Object, String>>)remapData, fragmentLength);
        } else {
            object = this.adamParquetLoad(filePath, (Option)this.adamParquetLoad$default$2(), this.adamParquetLoad$default$3(), (Function1)Predef$.MODULE$.conforms(), (Manifest)ManifestFactory$.MODULE$.classType(ADAMNucleotideContigFragment.class));
        }
        return object;
    }

    public Seq<Path> findFiles(Path path, String regex) {
        Tuple2 tuple2;
        block4: {
            Seq seq;
            block3: {
                block2: {
                    if (regex != null) break block2;
                    seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Path[]{path}));
                    break block3;
                }
                FileStatus[] statuses = FileSystem.get((Configuration)this.sc.hadoopConfiguration()).listStatus(path);
                Pattern r = Pattern.compile(regex);
                tuple2 = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])statuses).filter((Function1)new $anonfun$8(this))).map((Function1)new $anonfun$9(this), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Path.class)))).partition((Function1)new $anonfun$10(this, r));
                if (tuple2 == null) break block4;
                Tuple2 tuple22 = new Tuple2(tuple2._1(), tuple2._2());
                Path[] matches = (Path[])tuple22._1();
                Path[] recurse = (Path[])tuple22._2();
                seq = (Seq)Predef$.MODULE$.refArrayOps((Object[])matches).toSeq().$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])recurse).flatMap((Function1)new Serializable(this, regex){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ADAMContext $outer;
                    private final String regex$1;

                    public final Seq<Path> apply(Path p) {
                        return this.$outer.findFiles(p, this.regex$1);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.regex$1 = regex$1;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Path.class)))), Seq$.MODULE$.canBuildFrom());
            }
            return seq;
        }
        throw new MatchError((Object)tuple2);
    }

    public RDD<ADAMRecord> loadADAMFromPaths(Seq<Path> paths) {
        return this.sc.union((Seq)((TraversableLike)paths.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ADAMContext $outer;

            public final Tuple2<SequenceDictionary, RDD<ADAMRecord>> apply(Path path) {
                return this.$outer.org$bdgenomics$adam$rdd$ADAMContext$$loadADAMs$1(path);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final RDD<ADAMRecord> apply(Tuple2<SequenceDictionary, RDD<ADAMRecord>> v) {
                return (RDD)v._2();
            }
        }, Seq$.MODULE$.canBuildFrom()), ClassTag$.MODULE$.apply(ADAMRecord.class));
    }

    public final Tuple2 org$bdgenomics$adam$rdd$ADAMContext$$loadADAMs$1(Path path) {
        SequenceDictionary dict = this.adamDictionaryLoad(path.toString(), (Function1)Predef$.MODULE$.conforms(), (Manifest)ManifestFactory$.MODULE$.classType(ADAMRecord.class));
        RDD rdd = this.adamLoad(path.toString(), (Option)this.adamLoad$default$2(), this.adamLoad$default$3(), (Function1)Predef$.MODULE$.conforms(), (Manifest)ManifestFactory$.MODULE$.classType(ADAMRecord.class));
        return new Tuple2((Object)dict, rdd);
    }

    public ADAMContext(SparkContext sc) {
        this.sc = sc;
        Logging.class.$init$((Logging)this);
    }
}

