/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.converters;

import java.io.File;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.log4j.Level;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.bdgenomics.adam.avro.ADAMNucleotideContigFragment;
import org.bdgenomics.adam.converters.FastaConverter;
import org.bdgenomics.adam.converters.FastaConverter$;
import org.bdgenomics.adam.rdd.ADAMContext$;
import org.bdgenomics.adam.util.SparkFunSuite;
import org.bdgenomics.adam.util.SparkFunSuite$class;
import org.scalatest.BeforeAndAfter;
import org.scalatest.Distributor;
import org.scalatest.Filter;
import org.scalatest.FunSuite;
import org.scalatest.FunSuiteLike;
import org.scalatest.Reporter;
import org.scalatest.Stopper;
import org.scalatest.Tag;
import org.scalatest.Tracker;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.io.Codec$;
import scala.io.Source$;
import scala.math.Ordering$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001I2A!\u0001\u0002\u0001\u0017\t\u0019b)Y:uC\u000e{gN^3si\u0016\u00148+^5uK*\u00111\u0001B\u0001\u000bG>tg/\u001a:uKJ\u001c(BA\u0003\u0007\u0003\u0011\tG-Y7\u000b\u0005\u001dA\u0011A\u00032eO\u0016tw.\\5dg*\t\u0011\"A\u0002pe\u001e\u001c\u0001aE\u0002\u0001\u0019I\u0001\"!\u0004\t\u000e\u00039Q!a\u0004\u0005\u0002\u0013M\u001c\u0017\r\\1uKN$\u0018BA\t\u000f\u0005!1UO\\*vSR,\u0007CA\n\u0017\u001b\u0005!\"BA\u000b\u0005\u0003\u0011)H/\u001b7\n\u0005]!\"!D*qCJ\\g)\u001e8Tk&$X\rC\u0003\u001a\u0001\u0011\u0005!$\u0001\u0004=S:LGO\u0010\u000b\u00027A\u0011A\u0004A\u0007\u0002\u0005!9a\u0004\u0001b\u0001\n\u0003y\u0012!C2p]Z,'\u000f^3s+\u0005\u0001\u0003C\u0001\u000f\"\u0013\t\u0011#A\u0001\bGCN$\u0018mQ8om\u0016\u0014H/\u001a:\t\r\u0011\u0002\u0001\u0015!\u0003!\u0003)\u0019wN\u001c<feR,'\u000f\t\u0005\bM\u0001\u0011\r\u0011\"\u0001(\u0003!\u0019\u0007N]\u0019GS2,W#\u0001\u0015\u0011\u0005%rS\"\u0001\u0016\u000b\u0005-b\u0013\u0001\u00027b]\u001eT\u0011!L\u0001\u0005U\u00064\u0018-\u0003\u00020U\t11\u000b\u001e:j]\u001eDa!\r\u0001!\u0002\u0013A\u0013!C2ieF2\u0015\u000e\\3!\u0001")
public class FastaConverterSuite
extends FunSuite
implements SparkFunSuite {
    private final FastaConverter converter;
    private final String chr1File;
    private SparkContext sc;
    private Option<Map<String, Level>> maybeLevels;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    private volatile boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked;

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public Option<Map<String, Level>> maybeLevels() {
        return this.maybeLevels;
    }

    @Override
    public void maybeLevels_$eq(Option<Map<String, Level>> x$1) {
        this.maybeLevels = x$1;
    }

    @Override
    public void setupSparkContext(String sparkName, boolean silenceSpark) {
        SparkFunSuite$class.setupSparkContext(this, sparkName, silenceSpark);
    }

    @Override
    public void teardownSparkContext() {
        SparkFunSuite$class.teardownSparkContext(this);
    }

    @Override
    public void sparkBefore(String beforeName, boolean silenceSpark, Function0<BoxedUnit> body) {
        SparkFunSuite$class.sparkBefore(this, beforeName, silenceSpark, body);
    }

    @Override
    public void sparkAfter(String beforeName, boolean silenceSpark, Function0<BoxedUnit> body) {
        SparkFunSuite$class.sparkAfter(this, beforeName, silenceSpark, body);
    }

    @Override
    public void sparkTest(String name, boolean silenceSpark, Function0<BoxedUnit> body) {
        SparkFunSuite$class.sparkTest(this, name, silenceSpark, body);
    }

    @Override
    public boolean sparkTest$default$2() {
        return SparkFunSuite$class.sparkTest$default$2(this);
    }

    @Override
    public boolean sparkBefore$default$2() {
        return SparkFunSuite$class.sparkBefore$default$2(this);
    }

    @Override
    public boolean setupSparkContext$default$2() {
        return SparkFunSuite$class.setupSparkContext$default$2(this);
    }

    @Override
    public boolean sparkAfter$default$2() {
        return SparkFunSuite$class.sparkAfter$default$2(this);
    }

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    }

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    }

    public boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked() {
        return this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked;
    }

    public void org$scalatest$BeforeAndAfter$$runHasBeenInvoked_$eq(boolean x$1) {
        this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked = x$1;
    }

    public void org$scalatest$BeforeAndAfter$$super$runTest(String testName, Reporter reporter, Stopper stopper, Map configMap, Tracker tracker) {
        FunSuiteLike.class.runTest((FunSuiteLike)this, (String)testName, (Reporter)reporter, (Stopper)stopper, (Map)configMap, (Tracker)tracker);
    }

    public void org$scalatest$BeforeAndAfter$$super$run(Option testName, Reporter reporter, Stopper stopper, Filter filter, Map configMap, Option distributor, Tracker tracker) {
        FunSuiteLike.class.run((FunSuiteLike)this, (Option)testName, (Reporter)reporter, (Stopper)stopper, (Filter)filter, (Map)configMap, (Option)distributor, (Tracker)tracker);
    }

    public void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$beforeFunctionAtomic_$eq(AtomicReference x$1) {
        this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic = x$1;
    }

    public void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$afterFunctionAtomic_$eq(AtomicReference x$1) {
        this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic = x$1;
    }

    public void before(Function0<Object> fun) {
        BeforeAndAfter.class.before((BeforeAndAfter)this, fun);
    }

    public void after(Function0<Object> fun) {
        BeforeAndAfter.class.after((BeforeAndAfter)this, fun);
    }

    public void runTest(String testName, Reporter reporter, Stopper stopper, Map<String, Object> configMap, Tracker tracker) {
        BeforeAndAfter.class.runTest((BeforeAndAfter)this, (String)testName, (Reporter)reporter, (Stopper)stopper, configMap, (Tracker)tracker);
    }

    public void run(Option<String> testName, Reporter reporter, Stopper stopper, Filter filter, Map<String, Object> configMap, Option<Distributor> distributor, Tracker tracker) {
        BeforeAndAfter.class.run((BeforeAndAfter)this, testName, (Reporter)reporter, (Stopper)stopper, (Filter)filter, configMap, distributor, (Tracker)tracker);
    }

    public FastaConverter converter() {
        return this.converter;
    }

    public String chr1File() {
        return this.chr1File;
    }

    public FastaConverterSuite() {
        BeforeAndAfter.class.$init$((BeforeAndAfter)this);
        SparkFunSuite$class.$init$(this);
        this.converter = new FastaConverter(1000L);
        this.sparkTest("find contig index", this.sparkTest$default$2(), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FastaConverterSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SparkContext qual$1 = this.$outer.sc();
                Seq x$43 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToLong((long)0L), (Object)">1 dna:chromosome chromosome:GRCh37:1:1:249250621:1"), new Tuple2((Object)BoxesRunTime.boxToLong((long)252366306L), (Object)">2 dna:chromosome chromosome:GRCh37:2:1:243199373:1"), new Tuple2((Object)BoxesRunTime.boxToLong((long)699103487L), (Object)">4 dna:chromosome chromosome:GRCh37:4:1:191154276:1"), new Tuple2((Object)BoxesRunTime.boxToLong((long)892647244L), (Object)">5 dna:chromosome chromosome:GRCh37:5:1:180915260:1"), new Tuple2((Object)BoxesRunTime.boxToLong((long)498605724L), (Object)">3 dna:chromosome chromosome:GRCh37:3:1:198022430:1")}));
                int x$44 = qual$1.parallelize$default$2();
                RDD headerLines = qual$1.parallelize(x$43, x$44, ClassTag$.MODULE$.apply(Tuple2.class));
                Map descLines = FastaConverter$.MODULE$.getDescriptionLines(headerLines);
                List headerIndices = descLines.keys().toList();
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)0)).$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)FastaConverter$.MODULE$.findContigIndex(252366300L, headerIndices))));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)892647244L)).$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)FastaConverter$.MODULE$.findContigIndex(892647249L, headerIndices))));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)252366306L)).$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)FastaConverter$.MODULE$.findContigIndex(498605720L, headerIndices))));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("convert a single record without naming information", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FastaConverterSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq contig = this.$outer.converter().convert((Option)None$.MODULE$, 0, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"AAATTTGCGC"})), (Option)None$.MODULE$);
                this.$outer.assert(this.$outer.convertToEqualizer(((TraversableOnce)ADAMContext$.MODULE$.charSequenceToList(((ADAMNucleotideContigFragment)contig.head()).getFragmentSequence()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(char x$1) {
                        return ((Object)BoxesRunTime.boxToCharacter((char)x$1)).toString();
                    }
                }, List$.MODULE$.canBuildFrom())).reduce((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(String x$2, String x$3) {
                        return new StringBuilder().append((Object)x$2).append((Object)x$3).toString();
                    }
                })).$eq$eq$eq((Object)"AAATTTGCGC"));
                this.$outer.assert(this.$outer.convertToEqualizer(((ADAMNucleotideContigFragment)contig.head()).getContig().getContigLength()).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)10)));
                this.$outer.assert(this.$outer.convertToEqualizer(((ADAMNucleotideContigFragment)contig.head()).getContig().getContigName()).$eq$eq$eq(null));
                this.$outer.assert(this.$outer.convertToEqualizer(((ADAMNucleotideContigFragment)contig.head()).getDescription()).$eq$eq$eq(null));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("convert a single record with naming information", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FastaConverterSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq contig = this.$outer.converter().convert((Option)new Some((Object)"chr2"), 1, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"NNNN"})), (Option)new Some((Object)"hg19"));
                this.$outer.assert(this.$outer.convertToEqualizer(((TraversableOnce)ADAMContext$.MODULE$.charSequenceToList(((ADAMNucleotideContigFragment)contig.head()).getFragmentSequence()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(char x$4) {
                        return ((Object)BoxesRunTime.boxToCharacter((char)x$4)).toString();
                    }
                }, List$.MODULE$.canBuildFrom())).reduce((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(String x$5, String x$6) {
                        return new StringBuilder().append((Object)x$5).append((Object)x$6).toString();
                    }
                })).$eq$eq$eq((Object)"NNNN"));
                this.$outer.assert(this.$outer.convertToEqualizer(((ADAMNucleotideContigFragment)contig.head()).getContig().getContigLength()).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)4)));
                this.$outer.assert(this.$outer.convertToEqualizer(((ADAMNucleotideContigFragment)contig.head()).getContig().getContigName()).$eq$eq$eq((Object)"chr2"));
                this.$outer.assert(this.$outer.convertToEqualizer(((ADAMNucleotideContigFragment)contig.head()).getDescription()).$eq$eq$eq((Object)"hg19"));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.sparkTest("convert single fasta sequence", this.sparkTest$default$2(), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FastaConverterSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                List fasta = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToLong((long)0L), (Object)"AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAGGGGGGGGGGAAAAAAAAAAGGGGGGGGGGAAAAAA"), new Tuple2((Object)BoxesRunTime.boxToLong((long)1L), (Object)"AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"), new Tuple2((Object)BoxesRunTime.boxToLong((long)2L), (Object)"AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"), new Tuple2((Object)BoxesRunTime.boxToLong((long)3L), (Object)"AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"), new Tuple2((Object)BoxesRunTime.boxToLong((long)4L), (Object)"AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"), new Tuple2((Object)BoxesRunTime.boxToLong((long)5L), (Object)"AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"), new Tuple2((Object)BoxesRunTime.boxToLong((long)6L), (Object)"AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"), new Tuple2((Object)BoxesRunTime.boxToLong((long)7L), (Object)"AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"), new Tuple2((Object)BoxesRunTime.boxToLong((long)8L), (Object)"AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"), new Tuple2((Object)BoxesRunTime.boxToLong((long)9L), (Object)"AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"), new Tuple2((Object)BoxesRunTime.boxToLong((long)10L), (Object)"AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"), new Tuple2((Object)BoxesRunTime.boxToLong((long)11L), (Object)"AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"), new Tuple2((Object)BoxesRunTime.boxToLong((long)12L), (Object)"AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"), new Tuple2((Object)BoxesRunTime.boxToLong((long)13L), (Object)"AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"), new Tuple2((Object)BoxesRunTime.boxToLong((long)14L), (Object)"AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"), new Tuple2((Object)BoxesRunTime.boxToLong((long)15L), (Object)"AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA")}));
                SparkContext qual$2 = this.$outer.sc();
                scala.collection.immutable.Seq x$45 = fasta.toSeq();
                int x$46 = qual$2.parallelize$default$2();
                RDD rdd = qual$2.parallelize((Seq)x$45, x$46, ClassTag$.MODULE$.apply(Tuple2.class));
                RDD adamFasta = FastaConverter$.MODULE$.apply(rdd, FastaConverter$.MODULE$.apply$default$2());
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)adamFasta.count())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1)));
                ADAMNucleotideContigFragment fastaElement = (ADAMNucleotideContigFragment)adamFasta.first();
                String fastaFragmentSequence = (String)((TraversableOnce)fasta.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Tuple2<Object, String> x$7) {
                        return (String)x$7._2();
                    }
                }, List$.MODULE$.canBuildFrom())).reduce((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(String x$8, String x$9) {
                        return new StringBuilder().append((Object)x$8).append((Object)x$9).toString();
                    }
                });
                String convertedFragmentSequence = (String)((TraversableOnce)ADAMContext$.MODULE$.charSequenceToList(fastaElement.getFragmentSequence()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(char x$10) {
                        return ((Object)BoxesRunTime.boxToCharacter((char)x$10)).toString();
                    }
                }, List$.MODULE$.canBuildFrom())).reduce((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(String x$11, String x$12) {
                        return new StringBuilder().append((Object)x$11).append((Object)x$12).toString();
                    }
                });
                this.$outer.assert(this.$outer.convertToEqualizer(convertedFragmentSequence).$eq$eq$eq((Object)fastaFragmentSequence));
                Integer n = BoxesRunTime.boxToInteger((int)fastaFragmentSequence.length());
                Long l = fastaElement.getContig().getContigLength();
                this.$outer.assert(l != n ? (l != null ? (!(l instanceof Number) ? (!(l instanceof Character) ? ((Object)l).equals(n) : BoxesRunTime.equalsCharObject((Character)((Character)((Object)l)), (Object)n)) : BoxesRunTime.equalsNumObject((Number)l, (Object)n)) : false) : true);
                this.$outer.assert(this.$outer.convertToEqualizer(fastaElement.getContig().getContigName()).$eq$eq$eq(null));
                this.$outer.assert(this.$outer.convertToEqualizer(fastaElement.getDescription()).$eq$eq$eq(null));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.sparkTest("convert fasta with multiple sequences", this.sparkTest$default$2(), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FastaConverterSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                List fasta1 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToLong((long)0L), (Object)">chr1"), new Tuple2((Object)BoxesRunTime.boxToLong((long)1L), (Object)"AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAGGGGGGGGGGAAAAAAAAAAGGGGGGGGGGAAAAAA"), new Tuple2((Object)BoxesRunTime.boxToLong((long)2L), (Object)"AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"), new Tuple2((Object)BoxesRunTime.boxToLong((long)3L), (Object)"AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"), new Tuple2((Object)BoxesRunTime.boxToLong((long)4L), (Object)"AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"), new Tuple2((Object)BoxesRunTime.boxToLong((long)5L), (Object)"AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"), new Tuple2((Object)BoxesRunTime.boxToLong((long)6L), (Object)"AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"), new Tuple2((Object)BoxesRunTime.boxToLong((long)7L), (Object)"AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"), new Tuple2((Object)BoxesRunTime.boxToLong((long)8L), (Object)"AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"), new Tuple2((Object)BoxesRunTime.boxToLong((long)9L), (Object)"AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"), new Tuple2((Object)BoxesRunTime.boxToLong((long)10L), (Object)"AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"), new Tuple2((Object)BoxesRunTime.boxToLong((long)11L), (Object)"AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"), new Tuple2((Object)BoxesRunTime.boxToLong((long)12L), (Object)"AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"), new Tuple2((Object)BoxesRunTime.boxToLong((long)13L), (Object)"AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"), new Tuple2((Object)BoxesRunTime.boxToLong((long)14L), (Object)"AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"), new Tuple2((Object)BoxesRunTime.boxToLong((long)15L), (Object)"AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"), new Tuple2((Object)BoxesRunTime.boxToLong((long)16L), (Object)"AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA")}));
                List fasta2 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToLong((long)17L), (Object)">chr2"), new Tuple2((Object)BoxesRunTime.boxToLong((long)18L), (Object)"CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCTTTTTTTTTTCCCCCCCCCCTTTTTTTTTTCCCCCC"), new Tuple2((Object)BoxesRunTime.boxToLong((long)19L), (Object)"CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC"), new Tuple2((Object)BoxesRunTime.boxToLong((long)20L), (Object)"CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC"), new Tuple2((Object)BoxesRunTime.boxToLong((long)21L), (Object)"CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC"), new Tuple2((Object)BoxesRunTime.boxToLong((long)22L), (Object)"CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC"), new Tuple2((Object)BoxesRunTime.boxToLong((long)23L), (Object)"CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC"), new Tuple2((Object)BoxesRunTime.boxToLong((long)24L), (Object)"CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC"), new Tuple2((Object)BoxesRunTime.boxToLong((long)25L), (Object)"CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC"), new Tuple2((Object)BoxesRunTime.boxToLong((long)26L), (Object)"CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC"), new Tuple2((Object)BoxesRunTime.boxToLong((long)27L), (Object)"CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC"), new Tuple2((Object)BoxesRunTime.boxToLong((long)28L), (Object)"CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC"), new Tuple2((Object)BoxesRunTime.boxToLong((long)29L), (Object)"CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC"), new Tuple2((Object)BoxesRunTime.boxToLong((long)30L), (Object)"CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC"), new Tuple2((Object)BoxesRunTime.boxToLong((long)31L), (Object)"CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC"), new Tuple2((Object)BoxesRunTime.boxToLong((long)32L), (Object)"CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC"), new Tuple2((Object)BoxesRunTime.boxToLong((long)33L), (Object)"CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC")}));
                List fasta = fasta2.$colon$colon$colon(fasta1);
                SparkContext qual$3 = this.$outer.sc();
                scala.collection.immutable.Seq x$47 = fasta.toSeq();
                int x$48 = qual$3.parallelize$default$2();
                RDD rdd = qual$3.parallelize((Seq)x$47, x$48, ClassTag$.MODULE$.apply(Tuple2.class));
                RDD adamFasta = FastaConverter$.MODULE$.apply(rdd, FastaConverter$.MODULE$.apply$default$2());
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)adamFasta.count())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)2)));
                ADAMNucleotideContigFragment fastaElement1 = (ADAMNucleotideContigFragment)adamFasta.filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(ADAMNucleotideContigFragment x$14) {
                        CharSequence charSequence = x$14.getContig().getContigName();
                        return !(charSequence != null ? !charSequence.equals("chr1") : "chr1" != null);
                    }
                }).first();
                String fastaFragmentSequence1 = (String)((TraversableOnce)fasta1.drop(1).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Tuple2<Object, String> x$15) {
                        return (String)x$15._2();
                    }
                }, List$.MODULE$.canBuildFrom())).reduce((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(String x$16, String x$17) {
                        return new StringBuilder().append((Object)x$16).append((Object)x$17).toString();
                    }
                });
                String convertedFragmentSequence1 = (String)((TraversableOnce)ADAMContext$.MODULE$.charSequenceToList(fastaElement1.getFragmentSequence()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(char x$18) {
                        return ((Object)BoxesRunTime.boxToCharacter((char)x$18)).toString();
                    }
                }, List$.MODULE$.canBuildFrom())).reduce((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(String x$19, String x$20) {
                        return new StringBuilder().append((Object)x$19).append((Object)x$20).toString();
                    }
                });
                this.$outer.assert(this.$outer.convertToEqualizer(convertedFragmentSequence1).$eq$eq$eq((Object)fastaFragmentSequence1));
                Integer n = BoxesRunTime.boxToInteger((int)fastaFragmentSequence1.length());
                Long l = fastaElement1.getContig().getContigLength();
                this.$outer.assert(l != n ? (l != null ? (!(l instanceof Number) ? (!(l instanceof Character) ? ((Object)l).equals(n) : BoxesRunTime.equalsCharObject((Character)((Character)((Object)l)), (Object)n)) : BoxesRunTime.equalsNumObject((Number)l, (Object)n)) : false) : true);
                this.$outer.assert(this.$outer.convertToEqualizer(((Object)fastaElement1.getContig().getContigName()).toString()).$eq$eq$eq((Object)"chr1"));
                this.$outer.assert(this.$outer.convertToEqualizer(fastaElement1.getDescription()).$eq$eq$eq(null));
                ADAMNucleotideContigFragment fastaElement2 = (ADAMNucleotideContigFragment)adamFasta.filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(ADAMNucleotideContigFragment x$21) {
                        CharSequence charSequence = x$21.getContig().getContigName();
                        return !(charSequence != null ? !charSequence.equals("chr2") : "chr2" != null);
                    }
                }).first();
                String fastaFragmentSequence2 = (String)((TraversableOnce)fasta2.drop(1).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Tuple2<Object, String> x$22) {
                        return (String)x$22._2();
                    }
                }, List$.MODULE$.canBuildFrom())).reduce((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(String x$23, String x$24) {
                        return new StringBuilder().append((Object)x$23).append((Object)x$24).toString();
                    }
                });
                String convertedFragmentSequence2 = (String)((TraversableOnce)ADAMContext$.MODULE$.charSequenceToList(fastaElement2.getFragmentSequence()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(char x$25) {
                        return ((Object)BoxesRunTime.boxToCharacter((char)x$25)).toString();
                    }
                }, List$.MODULE$.canBuildFrom())).reduce((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(String x$26, String x$27) {
                        return new StringBuilder().append((Object)x$26).append((Object)x$27).toString();
                    }
                });
                this.$outer.assert(this.$outer.convertToEqualizer(convertedFragmentSequence2).$eq$eq$eq((Object)fastaFragmentSequence2));
                Integer n2 = BoxesRunTime.boxToInteger((int)fastaFragmentSequence2.length());
                Long l2 = fastaElement2.getContig().getContigLength();
                this.$outer.assert(l2 != n2 ? (l2 != null ? (!(l2 instanceof Number) ? (!(l2 instanceof Character) ? ((Object)l2).equals(n2) : BoxesRunTime.equalsCharObject((Character)((Character)((Object)l2)), (Object)n2)) : BoxesRunTime.equalsNumObject((Number)l2, (Object)n2)) : false) : true);
                this.$outer.assert(this.$outer.convertToEqualizer(((Object)fastaElement2.getContig().getContigName()).toString()).$eq$eq$eq((Object)"chr2"));
                this.$outer.assert(this.$outer.convertToEqualizer(fastaElement2.getDescription()).$eq$eq$eq(null));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.sparkTest("convert fasta with multiple sequences; short fragment", this.sparkTest$default$2(), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FastaConverterSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                List fasta1 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToLong((long)0L), (Object)">chr1"), new Tuple2((Object)BoxesRunTime.boxToLong((long)1L), (Object)"AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAGGGGGGGGGGAAAAAAAAAAGGGGGGGGGGAAAAAA"), new Tuple2((Object)BoxesRunTime.boxToLong((long)2L), (Object)"AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"), new Tuple2((Object)BoxesRunTime.boxToLong((long)3L), (Object)"AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"), new Tuple2((Object)BoxesRunTime.boxToLong((long)4L), (Object)"AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"), new Tuple2((Object)BoxesRunTime.boxToLong((long)5L), (Object)"AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"), new Tuple2((Object)BoxesRunTime.boxToLong((long)6L), (Object)"AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"), new Tuple2((Object)BoxesRunTime.boxToLong((long)7L), (Object)"AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"), new Tuple2((Object)BoxesRunTime.boxToLong((long)8L), (Object)"AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"), new Tuple2((Object)BoxesRunTime.boxToLong((long)9L), (Object)"AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"), new Tuple2((Object)BoxesRunTime.boxToLong((long)10L), (Object)"AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"), new Tuple2((Object)BoxesRunTime.boxToLong((long)11L), (Object)"AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"), new Tuple2((Object)BoxesRunTime.boxToLong((long)12L), (Object)"AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"), new Tuple2((Object)BoxesRunTime.boxToLong((long)13L), (Object)"AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"), new Tuple2((Object)BoxesRunTime.boxToLong((long)14L), (Object)"AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"), new Tuple2((Object)BoxesRunTime.boxToLong((long)15L), (Object)"AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"), new Tuple2((Object)BoxesRunTime.boxToLong((long)16L), (Object)"AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA")}));
                List fasta2 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToLong((long)17L), (Object)">chr2"), new Tuple2((Object)BoxesRunTime.boxToLong((long)18L), (Object)"CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCTTTTTTTTTTCCCCCCCCCCTTTTTTTTTTCCCCCC"), new Tuple2((Object)BoxesRunTime.boxToLong((long)19L), (Object)"CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC"), new Tuple2((Object)BoxesRunTime.boxToLong((long)20L), (Object)"CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC"), new Tuple2((Object)BoxesRunTime.boxToLong((long)21L), (Object)"CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC"), new Tuple2((Object)BoxesRunTime.boxToLong((long)22L), (Object)"CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC"), new Tuple2((Object)BoxesRunTime.boxToLong((long)23L), (Object)"CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC"), new Tuple2((Object)BoxesRunTime.boxToLong((long)24L), (Object)"CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC"), new Tuple2((Object)BoxesRunTime.boxToLong((long)25L), (Object)"CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC"), new Tuple2((Object)BoxesRunTime.boxToLong((long)26L), (Object)"CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC"), new Tuple2((Object)BoxesRunTime.boxToLong((long)27L), (Object)"CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC"), new Tuple2((Object)BoxesRunTime.boxToLong((long)28L), (Object)"CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC"), new Tuple2((Object)BoxesRunTime.boxToLong((long)29L), (Object)"CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC"), new Tuple2((Object)BoxesRunTime.boxToLong((long)30L), (Object)"CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC"), new Tuple2((Object)BoxesRunTime.boxToLong((long)31L), (Object)"CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC"), new Tuple2((Object)BoxesRunTime.boxToLong((long)32L), (Object)"CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC"), new Tuple2((Object)BoxesRunTime.boxToLong((long)33L), (Object)"CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC")}));
                List fasta = fasta2.$colon$colon$colon(fasta1);
                SparkContext qual$4 = this.$outer.sc();
                scala.collection.immutable.Seq x$49 = fasta.toSeq();
                int x$50 = qual$4.parallelize$default$2();
                RDD rdd = qual$4.parallelize((Seq)x$49, x$50, ClassTag$.MODULE$.apply(Tuple2.class));
                RDD adamFasta = FastaConverter$.MODULE$.apply(rdd, 35L);
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)adamFasta.count())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)64)));
                ADAMNucleotideContigFragment[] fastaElement1 = (ADAMNucleotideContigFragment[])adamFasta.filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(ADAMNucleotideContigFragment x$29) {
                        CharSequence charSequence = x$29.getContig().getContigName();
                        return !(charSequence != null ? !charSequence.equals("chr1") : "chr1" != null);
                    }
                }).collect();
                String fastaFragmentSequence1 = ((TraversableOnce)fasta1.drop(1).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Tuple2<Object, String> x$30) {
                        return (String)x$30._2();
                    }
                }, List$.MODULE$.canBuildFrom())).mkString();
                ADAMNucleotideContigFragment[] seqs = (ADAMNucleotideContigFragment[])Predef$.MODULE$.refArrayOps((Object[])fastaElement1).sortBy((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Integer apply(ADAMNucleotideContigFragment x$31) {
                        return x$31.getFragmentNumber();
                    }
                }, Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.conforms()));
                String convertedFragmentSequence1 = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])fastaElement1).sortBy((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Integer apply(ADAMNucleotideContigFragment x$32) {
                        return x$32.getFragmentNumber();
                    }
                }, Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.conforms()))).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(ADAMNucleotideContigFragment x$33) {
                        return ((Object)x$33.getFragmentSequence()).toString();
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).mkString();
                this.$outer.assert(seqs != null);
                this.$outer.assert(this.$outer.convertToEqualizer(convertedFragmentSequence1).$eq$eq$eq((Object)fastaFragmentSequence1));
                ADAMNucleotideContigFragment[] fastaElement2 = (ADAMNucleotideContigFragment[])adamFasta.filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(ADAMNucleotideContigFragment x$34) {
                        CharSequence charSequence = x$34.getContig().getContigName();
                        return !(charSequence != null ? !charSequence.equals("chr2") : "chr2" != null);
                    }
                }).collect();
                String fastaFragmentSequence2 = ((TraversableOnce)fasta2.drop(1).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Tuple2<Object, String> x$35) {
                        return (String)x$35._2();
                    }
                }, List$.MODULE$.canBuildFrom())).mkString();
                String convertedFragmentSequence2 = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])fastaElement2).sortBy((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Integer apply(ADAMNucleotideContigFragment x$36) {
                        return x$36.getFragmentNumber();
                    }
                }, Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.conforms()))).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(ADAMNucleotideContigFragment x$37) {
                        return ((Object)x$37.getFragmentSequence()).toString();
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).mkString();
                this.$outer.assert(this.$outer.convertToEqualizer(convertedFragmentSequence2).$eq$eq$eq((Object)fastaFragmentSequence2));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.chr1File = ClassLoader.getSystemClassLoader().getResource("human_g1k_v37_chr1_59kb.fasta").getFile();
        this.sparkTest("convert reference fasta file", this.sparkTest$default$2(), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FastaConverterSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ADAMNucleotideContigFragment[] referenceSequences = (ADAMNucleotideContigFragment[])ADAMContext$.MODULE$.sparkContextToADAMContext(this.$outer.sc()).adamSequenceLoad(this.$outer.chr1File(), 10L).collect();
                this.$outer.assert(Predef$.MODULE$.refArrayOps((Object[])referenceSequences).forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(ADAMNucleotideContigFragment x$38) {
                        String string = ((Object)x$38.getContig().getContigName()).toString();
                        return !(string != null ? !string.equals("1") : "1" != null);
                    }
                }));
                this.$outer.assert(Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])referenceSequences).slice(0, referenceSequences.length - 2)).forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(ADAMNucleotideContigFragment x$39) {
                        return x$39.getFragmentSequence().length() == 10;
                    }
                }));
                String reassembledSequence = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])referenceSequences).sortBy((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Integer apply(ADAMNucleotideContigFragment x$40) {
                        return x$40.getFragmentNumber();
                    }
                }, Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.conforms()))).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final CharSequence apply(ADAMNucleotideContigFragment x$41) {
                        return x$41.getFragmentSequence();
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(CharSequence.class)))).mkString();
                String originalSequence = Source$.MODULE$.fromFile(new File(this.$outer.chr1File()), Codec$.MODULE$.fallbackSystemCodec()).getLines().filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(String x$42) {
                        return !x$42.startsWith(">");
                    }
                }).mkString();
                this.$outer.assert(this.$outer.convertToEqualizer(reassembledSequence).$eq$eq$eq((Object)originalSequence));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

