/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.converters;

import org.bdgenomics.adam.converters.GenotypesToVariantsConverter;
import org.bdgenomics.adam.converters.GenotypesToVariantsConverter$;
import org.scalatest.FunSuite;
import org.scalatest.Tag;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.List$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001]1A!\u0001\u0002\u0001\u0017\t\ts)\u001a8pif\u0004Xm\u001d+p-\u0006\u0014\u0018.\u00198ug\u000e{gN^3si\u0016\u00148+^5uK*\u00111\u0001B\u0001\u000bG>tg/\u001a:uKJ\u001c(BA\u0003\u0007\u0003\u0011\tG-Y7\u000b\u0005\u001dA\u0011A\u00032eO\u0016tw.\\5dg*\t\u0011\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001\u0019A\u0011Q\u0002E\u0007\u0002\u001d)\u0011q\u0002C\u0001\ng\u000e\fG.\u0019;fgRL!!\u0005\b\u0003\u0011\u0019+hnU;ji\u0016DQa\u0005\u0001\u0005\u0002Q\ta\u0001P5oSRtD#A\u000b\u0011\u0005Y\u0001Q\"\u0001\u0002")
public class GenotypesToVariantsConverterSuite
extends FunSuite {
    public GenotypesToVariantsConverterSuite() {
        this.test("Simple test of integer RMS", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GenotypesToVariantsConverterSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                GenotypesToVariantsConverter v = new GenotypesToVariantsConverter(GenotypesToVariantsConverter$.MODULE$.$lessinit$greater$default$1(), GenotypesToVariantsConverter$.MODULE$.$lessinit$greater$default$2());
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)v.rms((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 1}))))).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Simple test of floating point RMS", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GenotypesToVariantsConverterSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                GenotypesToVariantsConverter v = new GenotypesToVariantsConverter(GenotypesToVariantsConverter$.MODULE$.$lessinit$greater$default$1(), GenotypesToVariantsConverter$.MODULE$.$lessinit$greater$default$2());
                double rmsVal = v.rms((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{39.0, -40.0, 41.0})));
                this.$outer.assert(rmsVal > 40.0 && rmsVal < 40.01);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Max genotype quality should lead to max variant quality", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GenotypesToVariantsConverterSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                GenotypesToVariantsConverter v = new GenotypesToVariantsConverter(GenotypesToVariantsConverter$.MODULE$.$lessinit$greater$default$1(), GenotypesToVariantsConverter$.MODULE$.$lessinit$greater$default$2());
                double vq = v.variantQualityFromGenotypes((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0, 0.0})));
                this.$outer.assert(vq > 0.999 && vq < 1.001);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Genotype quality = 0.5 for two samples should lead to variant quality of 0.75", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GenotypesToVariantsConverterSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                GenotypesToVariantsConverter v = new GenotypesToVariantsConverter(GenotypesToVariantsConverter$.MODULE$.$lessinit$greater$default$1(), GenotypesToVariantsConverter$.MODULE$.$lessinit$greater$default$2());
                double vq = v.variantQualityFromGenotypes((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.5, 0.5})));
                this.$outer.assert(vq > 0.745 && vq < 0.755);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

