/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.rdd;

import java.util.logging.Level;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericContainer;
import org.apache.avro.specific.SpecificRecord;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.spark.SparkContext$;
import org.apache.spark.rdd.RDD;
import org.bdgenomics.adam.util.HadoopUtil$;
import org.bdgenomics.adam.util.ParquetLogger$;
import parquet.avro.AvroParquetOutputFormat;
import parquet.avro.AvroWriteSupport;
import parquet.hadoop.ParquetOutputFormat;
import parquet.hadoop.metadata.CompressionCodecName;
import parquet.hadoop.util.ContextUtil;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.reflect.ClassTag$;
import scala.reflect.Manifest;
import scala.reflect.ScalaSignature;
import scala.runtime.Null$;

@ScalaSignature(bytes="\u0006\u0001\u0005\ra\u0001B\u0001\u0003\u0001-\u0011\u0001#\u0011#B\u001bJ#EIR;oGRLwN\\:\u000b\u0005\r!\u0011a\u0001:eI*\u0011QAB\u0001\u0005C\u0012\fWN\u0003\u0002\b\u0011\u0005Q!\rZ4f]>l\u0017nY:\u000b\u0003%\t1a\u001c:h\u0007\u0001)\"\u0001\u0004\u0012\u0014\u0007\u0001i1\u0003\u0005\u0002\u000f#5\tqBC\u0001\u0011\u0003\u0015\u00198-\u00197b\u0013\t\u0011rB\u0001\u0004B]f\u0014VM\u001a\t\u0003\u001dQI!!F\b\u0003\u0019M+'/[1mSj\f'\r\\3\t\u0011\r\u0001!\u0011!Q\u0001\n]\u00012\u0001\u0007\u0010!\u001b\u0005I\"BA\u0002\u001b\u0015\tYB$A\u0003ta\u0006\u00148N\u0003\u0002\u001e\u0011\u00051\u0011\r]1dQ\u0016L!aH\r\u0003\u0007I#E\t\u0005\u0002\"E1\u0001A!B\u0012\u0001\u0005\u0004!#!\u0001+\u0012\u0005\u0015B\u0003C\u0001\b'\u0013\t9sBA\u0004O_RD\u0017N\\4\u0011\u00059I\u0013B\u0001\u0016\u0010\u0005\r\te.\u001f\u0005\tY\u0001\u0011\u0019\u0011)A\u0006[\u0005QQM^5eK:\u001cW\rJ\u0019\u0011\t9q\u0003\u0005M\u0005\u0003_=\u0011\u0011BR;oGRLwN\\\u0019\u0011\u0005E2T\"\u0001\u001a\u000b\u0005M\"\u0014\u0001C:qK\u000eLg-[2\u000b\u0005Ub\u0012\u0001B1we>L!a\u000e\u001a\u0003\u001dM\u0003XmY5gS\u000e\u0014VmY8sI\"A\u0011\b\u0001B\u0002B\u0003-!(\u0001\u0006fm&$WM\\2fII\u00022a\u000f !\u001d\tqA(\u0003\u0002>\u001f\u00051\u0001K]3eK\u001aL!a\u0010!\u0003\u00115\u000bg.\u001b4fgRT!!P\b\t\u000b\t\u0003A\u0011A\"\u0002\rqJg.\u001b;?)\t!\u0015\nF\u0002F\u000f\"\u00032A\u0012\u0001!\u001b\u0005\u0011\u0001\"\u0002\u0017B\u0001\bi\u0003\"B\u001dB\u0001\bQ\u0004\"B\u0002B\u0001\u00049\u0002\"B&\u0001\t\u0003a\u0015\u0001C1eC6\u001c\u0016M^3\u0015\r]i%kV-f\u0011\u0015q%\n1\u0001P\u0003!1\u0017\u000e\\3QCRD\u0007CA\u001eQ\u0013\t\t\u0006I\u0001\u0004TiJLgn\u001a\u0005\b'*\u0003\n\u00111\u0001U\u0003%\u0011Gn\\2l'&TX\r\u0005\u0002\u000f+&\u0011ak\u0004\u0002\u0004\u0013:$\bb\u0002-K!\u0003\u0005\r\u0001V\u0001\ta\u0006<WmU5{K\"9!L\u0013I\u0001\u0002\u0004Y\u0016!D2p[B\u0014Xm]:D_\u0012,7\r\u0005\u0002]G6\tQL\u0003\u0002_?\u0006AQ.\u001a;bI\u0006$\u0018M\u0003\u0002aC\u00061\u0001.\u00193p_BT\u0011AY\u0001\ba\u0006\u0014\u0018/^3u\u0013\t!WL\u0001\u000bD_6\u0004(/Z:tS>t7i\u001c3fG:\u000bW.\u001a\u0005\bM*\u0003\n\u00111\u0001h\u0003e!\u0017n]1cY\u0016$\u0015n\u0019;j_:\f'/_#oG>$\u0017N\\4\u0011\u00059A\u0017BA5\u0010\u0005\u001d\u0011un\u001c7fC:Dqa\u001b\u0001\u0012\u0002\u0013\u0005A.\u0001\nbI\u0006l7+\u0019<fI\u0011,g-Y;mi\u0012\u0012T#A7+\u0005Qs7&A8\u0011\u0005A,X\"A9\u000b\u0005I\u001c\u0018!C;oG\",7m[3e\u0015\t!x\"\u0001\u0006b]:|G/\u0019;j_:L!A^9\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rC\u0004y\u0001E\u0005I\u0011\u00017\u0002%\u0005$\u0017-\\*bm\u0016$C-\u001a4bk2$He\r\u0005\bu\u0002\t\n\u0011\"\u0001|\u0003I\tG-Y7TCZ,G\u0005Z3gCVdG\u000f\n\u001b\u0016\u0003qT#a\u00178\t\u000fy\u0004\u0011\u0013!C\u0001\u007f\u0006\u0011\u0012\rZ1n'\u00064X\r\n3fM\u0006,H\u000e\u001e\u00136+\t\t\tA\u000b\u0002h]\u0002")
public class ADAMRDDFunctions<T>
implements Serializable {
    private final RDD<T> rdd;
    private final Function1<T, SpecificRecord> evidence$1;
    private final Manifest<T> evidence$2;

    public RDD<T> adamSave(String filePath, int blockSize, int pageSize, CompressionCodecName compressCodec, boolean disableDictionaryEncoding) {
        Job job = HadoopUtil$.MODULE$.newJob(this.rdd.context());
        ParquetLogger$.MODULE$.hadoopLoggerLevel().apply((Object)Level.SEVERE);
        ParquetOutputFormat.setWriteSupportClass((Job)job, AvroWriteSupport.class);
        ParquetOutputFormat.setCompression((Job)job, (CompressionCodecName)compressCodec);
        ParquetOutputFormat.setEnableDictionary((Job)job, (!disableDictionaryEncoding ? 1 : 0) != 0);
        ParquetOutputFormat.setBlockSize((Job)job, (int)blockSize);
        ParquetOutputFormat.setPageSize((Job)job, (int)pageSize);
        AvroParquetOutputFormat.setSchema((Job)job, (Schema)((GenericContainer)this.evidence$1.apply(Predef$.MODULE$.manifest(this.evidence$2).runtimeClass().newInstance())).getSchema());
        RDD recordToSave = this.rdd.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Null$, T> apply(T p) {
                return new Tuple2(null, p);
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        SparkContext$.MODULE$.rddToPairRDDFunctions(recordToSave, ClassTag$.MODULE$.Null(), this.evidence$2).saveAsNewAPIHadoopFile(filePath, Void.class, Predef$.MODULE$.manifest(this.evidence$2).runtimeClass(), ParquetOutputFormat.class, ContextUtil.getConfiguration((JobContext)job));
        return this.rdd;
    }

    public int adamSave$default$2() {
        return 0x8000000;
    }

    public int adamSave$default$3() {
        return 0x100000;
    }

    public CompressionCodecName adamSave$default$4() {
        return CompressionCodecName.GZIP;
    }

    public boolean adamSave$default$5() {
        return false;
    }

    public ADAMRDDFunctions(RDD<T> rdd, Function1<T, SpecificRecord> evidence$1, Manifest<T> evidence$2) {
        this.rdd = rdd;
        this.evidence$1 = evidence$1;
        this.evidence$2 = evidence$2;
    }
}

