/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.rdd;

import fi.tkk.ics.hadoop.bam.SAMRecordWritable;
import net.sf.samtools.SAMFileHeader;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.spark.SparkContext$;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.rdd.OrderedRDDFunctions;
import org.apache.spark.rdd.RDD;
import org.bdgenomics.adam.avro.ADAMPileup;
import org.bdgenomics.adam.avro.ADAMRecord;
import org.bdgenomics.adam.converters.ADAMRecordConverter;
import org.bdgenomics.adam.models.ADAMRod;
import org.bdgenomics.adam.models.Attribute;
import org.bdgenomics.adam.models.RecordGroupDictionary;
import org.bdgenomics.adam.models.ReferencePosition;
import org.bdgenomics.adam.models.ReferencePosition$;
import org.bdgenomics.adam.models.SAMFileHeaderWritable;
import org.bdgenomics.adam.models.SequenceDictionary;
import org.bdgenomics.adam.models.SequenceRecord;
import org.bdgenomics.adam.models.SequenceRecord$;
import org.bdgenomics.adam.models.SingleReadBucket;
import org.bdgenomics.adam.models.SingleReadBucket$;
import org.bdgenomics.adam.models.SnpTable;
import org.bdgenomics.adam.rdd.ADAMContext$;
import org.bdgenomics.adam.rdd.ADAMRecordRDDFunctions$;
import org.bdgenomics.adam.rdd.ADAMSequenceDictionaryRDDAggregator;
import org.bdgenomics.adam.rdd.FlagStat$;
import org.bdgenomics.adam.rdd.FlagStatMetrics;
import org.bdgenomics.adam.rdd.MarkDuplicates$;
import org.bdgenomics.adam.rdd.Reads2PileupProcessor;
import org.bdgenomics.adam.rdd.RealignIndels$;
import org.bdgenomics.adam.rdd.correction.TrimReads$;
import org.bdgenomics.adam.rdd.recalibration.BaseQualityRecalibration$;
import org.bdgenomics.adam.rich.RichADAMRecord$;
import org.bdgenomics.adam.util.ADAMBAMOutputFormat;
import org.bdgenomics.adam.util.ADAMBAMOutputFormat$;
import org.bdgenomics.adam.util.ADAMSAMOutputFormat;
import org.bdgenomics.adam.util.ADAMSAMOutputFormat$;
import org.bdgenomics.adam.util.MapTools$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.Traversable;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Stream;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001\u0005Ug\u0001B\u0001\u0003\u0001-\u0011a#\u0011#B\u001bJ+7m\u001c:e%\u0012#e)\u001e8di&|gn\u001d\u0006\u0003\u0007\u0011\t1A\u001d3e\u0015\t)a!\u0001\u0003bI\u0006l'BA\u0004\t\u0003)\u0011GmZ3o_6L7m\u001d\u0006\u0002\u0013\u0005\u0019qN]4\u0004\u0001M\u0011\u0001\u0001\u0004\t\u0004\u001b9\u0001R\"\u0001\u0002\n\u0005=\u0011!aI!E\u00036\u001bV-];f]\u000e,G)[2uS>t\u0017M]=S\t\u0012\u000bum\u001a:fO\u0006$xN\u001d\t\u0003#Qi\u0011A\u0005\u0006\u0003'\u0011\tA!\u0019<s_&\u0011QC\u0005\u0002\u000b\u0003\u0012\u000bUJU3d_J$\u0007\u0002C\u0002\u0001\u0005\u0003\u0005\u000b\u0011B\f\u0011\u0007aq\u0002#D\u0001\u001a\u0015\t\u0019!D\u0003\u0002\u001c9\u0005)1\u000f]1sW*\u0011Q\u0004C\u0001\u0007CB\f7\r[3\n\u0005}I\"a\u0001*E\t\")\u0011\u0005\u0001C\u0001E\u00051A(\u001b8jiz\"\"a\t\u0013\u0011\u00055\u0001\u0001\"B\u0002!\u0001\u00049\u0002\"\u0002\u0014\u0001\t\u00039\u0013aC1eC6\u001c\u0016)T*bm\u0016$2\u0001\u000b\u00188!\tIC&D\u0001+\u0015\u0005Y\u0013!B:dC2\f\u0017BA\u0017+\u0005\u0011)f.\u001b;\t\u000b=*\u0003\u0019\u0001\u0019\u0002\u0011\u0019LG.\u001a)bi\"\u0004\"!\r\u001b\u000f\u0005%\u0012\u0014BA\u001a+\u0003\u0019\u0001&/\u001a3fM&\u0011QG\u000e\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005MR\u0003b\u0002\u001d&!\u0003\u0005\r!O\u0001\u0006CN\u001c\u0016-\u001c\t\u0003SiJ!a\u000f\u0016\u0003\u000f\t{w\u000e\\3b]\")Q\b\u0001C\u0001}\u0005ir-\u001a;TKF,XM\\2f%\u0016\u001cwN\u001d3t\rJ|W.\u00127f[\u0016tG\u000f\u0006\u0002@\u0017B\u0019\u0001iQ#\u000e\u0003\u0005S!A\u0011\u0016\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002E\u0003\n\u00191+\u001a;\u0011\u0005\u0019KU\"A$\u000b\u0005!#\u0011AB7pI\u0016d7/\u0003\u0002K\u000f\nq1+Z9vK:\u001cWMU3d_J$\u0007\"\u0002'=\u0001\u0004\u0001\u0012\u0001B3mK6DQA\u0014\u0001\u0005\u0002=\u000b!$\u00193b[\u001e+GOU3bI\u001e\u0013x.\u001e9ES\u000e$\u0018n\u001c8bef$\u0012\u0001\u0015\t\u0003\rFK!AU$\u0003+I+7m\u001c:e\u000fJ|W\u000f\u001d#jGRLwN\\1ss\")A\u000b\u0001C\u0001+\u0006\u0001\u0012\rZ1n\u0007>tg/\u001a:u)>\u001c\u0016)\u0014\u000b\u0002-B!\u0011fV-i\u0013\tA&F\u0001\u0004UkBdWM\r\t\u00041yQ\u0006CA.g\u001b\u0005a&BA/_\u0003\r\u0011\u0017-\u001c\u0006\u0003?\u0002\fa\u0001[1e_>\u0004(BA1c\u0003\rI7m\u001d\u0006\u0003G\u0012\f1\u0001^6l\u0015\u0005)\u0017A\u00014j\u0013\t9GLA\tT\u00036\u0013VmY8sI^\u0013\u0018\u000e^1cY\u0016\u0004\"!\u001b9\u000e\u0003)T!a\u001b7\u0002\u0011M\fW\u000e^8pYNT!!\u001c8\u0002\u0005M4'\"A8\u0002\u00079,G/\u0003\u0002rU\ni1+Q'GS2,\u0007*Z1eKJDQa\u001d\u0001\u0005\u0002Q\f\u0001%\u00193b[N{'\u000f\u001e*fC\u0012\u001c()\u001f*fM\u0016\u0014XM\\2f!>\u001c\u0018\u000e^5p]R\tq\u0003C\u0003w\u0001\u0011\u0005A/\u0001\nbI\u0006lW*\u0019:l\tV\u0004H.[2bi\u0016\u001c\b\"\u0002=\u0001\t\u0003I\u0018\u0001C1eC6\u0014\u0015k\u0015*\u0015\u0005]Q\b\"B>x\u0001\u0004a\u0018!C6o_^t7K\u001c9t!\u0015i\u0018\u0011AA\u0003\u001b\u0005q(BA@\u001b\u0003%\u0011'o\\1eG\u0006\u001cH/C\u0002\u0002\u0004y\u0014\u0011B\u0011:pC\u0012\u001c\u0017m\u001d;\u0011\u0007\u0019\u000b9!C\u0002\u0002\n\u001d\u0013\u0001b\u00158q)\u0006\u0014G.\u001a\u0005\u0007\u0003\u001b\u0001A\u0011\u0001;\u0002#\u0005$\u0017-\u001c*fC2LwM\\%oI\u0016d7\u000fC\u0004\u0002\u0012\u0001!\t!a\u0005\u0002\u0019\u0005$\u0017-\u001c$mC\u001e\u001cF/\u0019;\u0015\u0005\u0005U\u0001CB\u0015X\u0003/\t9\u0002E\u0002\u000e\u00033I1!a\u0007\u0003\u0005=1E.Y4Ti\u0006$X*\u001a;sS\u000e\u001c\bbBA\u0010\u0001\u0011\u0005\u0011\u0011E\u0001\u0016C\u0012\fWnU5oO2,'+Z1e\u0005V\u001c7.\u001a;t)\t\t\u0019\u0003\u0005\u0003\u0019=\u0005\u0015\u0002c\u0001$\u0002(%\u0019\u0011\u0011F$\u0003!MKgn\u001a7f%\u0016\fGMQ;dW\u0016$\bbBA\u0017\u0001\u0011\u0005\u0011qF\u0001\u0013C\u0012\fWNU3d_J$7O\r)jY\u0016,\b\u000f\u0006\u0003\u00022\u0005e\u0002\u0003\u0002\r\u001f\u0003g\u00012!EA\u001b\u0013\r\t9D\u0005\u0002\u000b\u0003\u0012\u000bU\nU5mKV\u0004\b\"CA\u001e\u0003W\u0001\n\u00111\u0001:\u0003M\u0019XmY8oI\u0006\u0014\u00180\u00117jO:lWM\u001c;t\u0011\u001d\ty\u0004\u0001C\u0001\u0003\u0003\n\u0001#\u00193b[J+7m\u001c:egJ\u0012v\u000eZ:\u0015\r\u0005\r\u00131JA+!\u0011Ab$!\u0012\u0011\u0007\u0019\u000b9%C\u0002\u0002J\u001d\u0013q!\u0011#B\u001bJ{G\r\u0003\u0006\u0002N\u0005u\u0002\u0013!a\u0001\u0003\u001f\n!BY;dW\u0016$8+\u001b>f!\rI\u0013\u0011K\u0005\u0004\u0003'R#aA%oi\"I\u00111HA\u001f!\u0003\u0005\r!\u000f\u0005\b\u00033\u0002A\u0011AA.\u0003Q\tG-Y7DQ\u0006\u0014\u0018m\u0019;fe&TX\rV1hgR\u0011\u0011Q\f\t\u00051y\ty\u0006E\u0003*/B\n\t\u0007E\u0002*\u0003GJ1!!\u001a+\u0005\u0011auN\\4\t\u000f\u0005%\u0004\u0001\"\u0001\u0002l\u0005I\u0012\rZ1n\u0007\"\f'/Y2uKJL'0\u001a+bOZ\u000bG.^3t)\u0011\ti'!\u001f\u0011\u000fE\ny'a\u001d\u0002b%\u0019\u0011\u0011\u000f\u001c\u0003\u00075\u000b\u0007\u000fE\u0002*\u0003kJ1!a\u001e+\u0005\r\te.\u001f\u0005\b\u0003w\n9\u00071\u00011\u0003\r!\u0018m\u001a\u0005\b\u0003\u007f\u0002A\u0011AAA\u0003a\tG-Y7GS2$XM\u001d*fG>\u0014Hm],ji\"$\u0016m\u001a\u000b\u0004/\u0005\r\u0005bBAC\u0003{\u0002\r\u0001M\u0001\bi\u0006<g*Y7f\u0011\u001d\tI\t\u0001C\u0001\u0003\u0017\u000bQ\"\u00193b[R\u0013\u0018.\u001c*fC\u0012\u001cHcB\f\u0002\u000e\u0006E\u0015Q\u0013\u0005\t\u0003\u001f\u000b9\t1\u0001\u0002P\u0005IAO]5n'R\f'\u000f\u001e\u0005\t\u0003'\u000b9\t1\u0001\u0002P\u00059AO]5n\u000b:$\u0007BCAL\u0003\u000f\u0003\n\u00111\u0001\u0002P\u0005I!/Z1e\u000fJ|W\u000f\u001d\u0005\b\u00037\u0003A\u0011AAO\u0003q\tG-Y7Ue&lGj\\<Rk\u0006d\u0017\u000e^=SK\u0006$wI]8vaN$2aFAP\u0011)\t\t+!'\u0011\u0002\u0003\u0007\u0011qJ\u0001\u000fa\"\u0014X\r\u001a+ie\u0016\u001c\bn\u001c7e\u0011%\t)\u000bAI\u0001\n\u0003\t9+\u0001\u000fbI\u0006l'+Z2pe\u0012\u001c(\u0007U5mKV\u0004H\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005%&fA\u001d\u0002,.\u0012\u0011Q\u0016\t\u0005\u0003_\u000bI,\u0004\u0002\u00022*!\u00111WA[\u0003%)hn\u00195fG.,GMC\u0002\u00028*\n!\"\u00198o_R\fG/[8o\u0013\u0011\tY,!-\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rC\u0005\u0002@\u0002\t\n\u0011\"\u0001\u0002(\u0006)\u0012\rZ1n'\u0006k5+\u0019<fI\u0011,g-Y;mi\u0012\u0012\u0004\"CAb\u0001E\u0005I\u0011AAc\u0003i\tG-Y7SK\u000e|'\u000fZ:3%>$7\u000f\n3fM\u0006,H\u000e\u001e\u00132+\t\t9M\u000b\u0003\u0002P\u0005-\u0006\"CAf\u0001E\u0005I\u0011AAT\u0003i\tG-Y7SK\u000e|'\u000fZ:3%>$7\u000f\n3fM\u0006,H\u000e\u001e\u00133\u0011%\ty\rAI\u0001\n\u0003\t)-A\fbI\u0006lGK]5n%\u0016\fGm\u001d\u0013eK\u001a\fW\u000f\u001c;%g!I\u00111\u001b\u0001\u0012\u0002\u0013\u0005\u0011QY\u0001'C\u0012\fW\u000e\u0016:j[2{w/U;bY&$\u0018PU3bI\u001e\u0013x.\u001e9tI\u0011,g-Y;mi\u0012\n\u0004")
public class ADAMRecordRDDFunctions
extends ADAMSequenceDictionaryRDDAggregator<ADAMRecord> {
    private final RDD<ADAMRecord> rdd;

    public void adamSAMSave(String filePath, boolean asSam) {
        Tuple2<RDD<SAMRecordWritable>, SAMFileHeader> tuple2;
        block2: {
            block5: {
                block8: {
                    block7: {
                        Configuration conf;
                        RDD withKey;
                        block6: {
                            block4: {
                                RDD convertRecords;
                                block3: {
                                    tuple2 = ADAMContext$.MODULE$.rddToADAMRecordRDD(this.rdd).adamConvertToSAM();
                                    if (tuple2 == null || tuple2._1() == null) break block2;
                                    RDD rDD = (RDD)tuple2._1();
                                    if (tuple2._2() == null) break block2;
                                    SAMFileHeader sAMFileHeader = (SAMFileHeader)tuple2._2();
                                    Tuple2 tuple22 = new Tuple2((Object)rDD, (Object)sAMFileHeader);
                                    convertRecords = (RDD)tuple22._1();
                                    tuple22._2();
                                    withKey = convertRecords.keyBy((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final LongWritable apply(SAMRecordWritable v) {
                                            return new LongWritable((long)v.get().getAlignmentStart());
                                        }
                                    });
                                    if (!asSam) break block3;
                                    ADAMSAMOutputFormat$.MODULE$.addHeader(((SAMRecordWritable)convertRecords.first()).get().getHeader());
                                    break block4;
                                }
                                if (asSam) break block5;
                                ADAMBAMOutputFormat$.MODULE$.addHeader(((SAMRecordWritable)convertRecords.first()).get().getHeader());
                            }
                            conf = this.rdd.context().hadoopConfiguration();
                            if (!asSam) break block6;
                            SparkContext$.MODULE$.rddToPairRDDFunctions(withKey, ClassTag$.MODULE$.apply(LongWritable.class), ClassTag$.MODULE$.apply(SAMRecordWritable.class)).saveAsNewAPIHadoopFile(filePath, LongWritable.class, SAMRecordWritable.class, ADAMSAMOutputFormat.class, conf);
                            break block7;
                        }
                        if (asSam) break block8;
                        SparkContext$.MODULE$.rddToPairRDDFunctions(withKey, ClassTag$.MODULE$.apply(LongWritable.class), ClassTag$.MODULE$.apply(SAMRecordWritable.class)).saveAsNewAPIHadoopFile(filePath, LongWritable.class, SAMRecordWritable.class, ADAMBAMOutputFormat.class, conf);
                    }
                    return;
                }
                throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)asSam));
            }
            throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)asSam));
        }
        throw new MatchError(tuple2);
    }

    public boolean adamSAMSave$default$2() {
        return true;
    }

    @Override
    public Set<SequenceRecord> getSequenceRecordsFromElement(ADAMRecord elem) {
        return SequenceRecord$.MODULE$.fromADAMRecord(elem);
    }

    public RecordGroupDictionary adamGetReadGroupDictionary() {
        Seq rgNames = Predef$.MODULE$.refArrayOps((Object[])this.rdd.flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Iterable<CharSequence> apply(ADAMRecord r) {
                return Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)r.getRecordGroupName()));
            }
        }, ClassTag$.MODULE$.apply(CharSequence.class)).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(CharSequence x$5) {
                return ((Object)x$5).toString();
            }
        }, ClassTag$.MODULE$.apply(String.class)).distinct().collect()).toSeq();
        return new RecordGroupDictionary((Seq<String>)rgNames);
    }

    public Tuple2<RDD<SAMRecordWritable>, SAMFileHeader> adamConvertToSAM() {
        SequenceDictionary sd = ADAMContext$.MODULE$.rddToADAMRecordRDD(this.rdd).adamGetSequenceDictionary();
        RecordGroupDictionary rgd = ADAMContext$.MODULE$.rddToADAMRecordRDD(this.rdd).adamGetReadGroupDictionary();
        ADAMRecordConverter adamRecordConverter = new ADAMRecordConverter();
        SAMFileHeader header = adamRecordConverter.createSAMHeader(sd, rgd);
        Broadcast hdrBcast = this.rdd.context().broadcast((Object)new SAMFileHeaderWritable(header));
        RDD convertedRDD = this.rdd.map((Function1)new Serializable(this, adamRecordConverter, hdrBcast){
            public static final long serialVersionUID = 0L;
            private final ADAMRecordConverter adamRecordConverter$1;
            private final Broadcast hdrBcast$1;

            /*
             * WARNING - void declaration
             */
            public final SAMRecordWritable apply(ADAMRecord r) {
                void var2_2;
                SAMRecordWritable srw = new SAMRecordWritable();
                srw.set(this.adamRecordConverter$1.convert(r, (SAMFileHeaderWritable)this.hdrBcast$1.value()));
                return var2_2;
            }
            {
                this.adamRecordConverter$1 = adamRecordConverter$1;
                this.hdrBcast$1 = hdrBcast$1;
            }
        }, ClassTag$.MODULE$.apply(SAMRecordWritable.class));
        return new Tuple2((Object)convertedRDD, (Object)header);
    }

    public RDD<ADAMRecord> adamSortReadsByReferencePosition() {
        this.log().info("Sorting reads by reference position");
        Iterator<String> unmappedReferenceNames = new Iterator<String>(this){
            private int currentOffsetFromEnd;

            public Iterator<String> seq() {
                return Iterator.class.seq((Iterator)this);
            }

            public boolean isEmpty() {
                return Iterator.class.isEmpty((Iterator)this);
            }

            public boolean isTraversableAgain() {
                return Iterator.class.isTraversableAgain((Iterator)this);
            }

            public boolean hasDefiniteSize() {
                return Iterator.class.hasDefiniteSize((Iterator)this);
            }

            public Iterator<String> take(int n) {
                return Iterator.class.take((Iterator)this, (int)n);
            }

            public Iterator<String> drop(int n) {
                return Iterator.class.drop((Iterator)this, (int)n);
            }

            public Iterator<String> slice(int from, int until) {
                return Iterator.class.slice((Iterator)this, (int)from, (int)until);
            }

            public <B> Iterator<B> map(Function1<String, B> f) {
                return Iterator.class.map((Iterator)this, f);
            }

            public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
                return Iterator.class.$plus$plus((Iterator)this, that);
            }

            public <B> Iterator<B> flatMap(Function1<String, GenTraversableOnce<B>> f) {
                return Iterator.class.flatMap((Iterator)this, f);
            }

            public Iterator<String> filter(Function1<String, Object> p) {
                return Iterator.class.filter((Iterator)this, p);
            }

            public <B> boolean corresponds(GenTraversableOnce<B> that, Function2<String, B, Object> p) {
                return Iterator.class.corresponds((Iterator)this, that, p);
            }

            public Iterator<String> withFilter(Function1<String, Object> p) {
                return Iterator.class.withFilter((Iterator)this, p);
            }

            public Iterator<String> filterNot(Function1<String, Object> p) {
                return Iterator.class.filterNot((Iterator)this, p);
            }

            public <B> Iterator<B> collect(PartialFunction<String, B> pf) {
                return Iterator.class.collect((Iterator)this, pf);
            }

            public <B> Iterator<B> scanLeft(B z, Function2<B, String, B> op) {
                return Iterator.class.scanLeft((Iterator)this, z, op);
            }

            public <B> Iterator<B> scanRight(B z, Function2<String, B, B> op) {
                return Iterator.class.scanRight((Iterator)this, z, op);
            }

            public Iterator<String> takeWhile(Function1<String, Object> p) {
                return Iterator.class.takeWhile((Iterator)this, p);
            }

            public Tuple2<Iterator<String>, Iterator<String>> partition(Function1<String, Object> p) {
                return Iterator.class.partition((Iterator)this, p);
            }

            public Tuple2<Iterator<String>, Iterator<String>> span(Function1<String, Object> p) {
                return Iterator.class.span((Iterator)this, p);
            }

            public Iterator<String> dropWhile(Function1<String, Object> p) {
                return Iterator.class.dropWhile((Iterator)this, p);
            }

            public <B> Iterator<Tuple2<String, B>> zip(Iterator<B> that) {
                return Iterator.class.zip((Iterator)this, that);
            }

            public <A1> Iterator<A1> padTo(int len, A1 elem) {
                return Iterator.class.padTo((Iterator)this, (int)len, elem);
            }

            public Iterator<Tuple2<String, Object>> zipWithIndex() {
                return Iterator.class.zipWithIndex((Iterator)this);
            }

            public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
                return Iterator.class.zipAll((Iterator)this, that, thisElem, thatElem);
            }

            public <U> void foreach(Function1<String, U> f) {
                Iterator.class.foreach((Iterator)this, f);
            }

            public boolean forall(Function1<String, Object> p) {
                return Iterator.class.forall((Iterator)this, p);
            }

            public boolean exists(Function1<String, Object> p) {
                return Iterator.class.exists((Iterator)this, p);
            }

            public boolean contains(Object elem) {
                return Iterator.class.contains((Iterator)this, (Object)elem);
            }

            public Option<String> find(Function1<String, Object> p) {
                return Iterator.class.find((Iterator)this, p);
            }

            public int indexWhere(Function1<String, Object> p) {
                return Iterator.class.indexWhere((Iterator)this, p);
            }

            public <B> int indexOf(B elem) {
                return Iterator.class.indexOf((Iterator)this, elem);
            }

            public BufferedIterator<String> buffered() {
                return Iterator.class.buffered((Iterator)this);
            }

            public <B> Iterator.GroupedIterator<B> grouped(int size) {
                return Iterator.class.grouped((Iterator)this, (int)size);
            }

            public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
                return Iterator.class.sliding((Iterator)this, (int)size, (int)step);
            }

            public int length() {
                return Iterator.class.length((Iterator)this);
            }

            public Tuple2<Iterator<String>, Iterator<String>> duplicate() {
                return Iterator.class.duplicate((Iterator)this);
            }

            public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                return Iterator.class.patch((Iterator)this, (int)from, patchElems, (int)replaced);
            }

            public <B> void copyToArray(Object xs, int start2, int len) {
                Iterator.class.copyToArray((Iterator)this, (Object)xs, (int)start2, (int)len);
            }

            public boolean sameElements(Iterator<?> that) {
                return Iterator.class.sameElements((Iterator)this, that);
            }

            public Traversable<String> toTraversable() {
                return Iterator.class.toTraversable((Iterator)this);
            }

            public Iterator<String> toIterator() {
                return Iterator.class.toIterator((Iterator)this);
            }

            public Stream<String> toStream() {
                return Iterator.class.toStream((Iterator)this);
            }

            public String toString() {
                return Iterator.class.toString((Iterator)this);
            }

            public <B> int sliding$default$2() {
                return Iterator.class.sliding$default$2((Iterator)this);
            }

            public List<String> reversed() {
                return TraversableOnce.class.reversed((TraversableOnce)this);
            }

            public int size() {
                return TraversableOnce.class.size((TraversableOnce)this);
            }

            public boolean nonEmpty() {
                return TraversableOnce.class.nonEmpty((TraversableOnce)this);
            }

            public int count(Function1<String, Object> p) {
                return TraversableOnce.class.count((TraversableOnce)this, p);
            }

            public <B> Option<B> collectFirst(PartialFunction<String, B> pf) {
                return TraversableOnce.class.collectFirst((TraversableOnce)this, pf);
            }

            public <B> B $div$colon(B z, Function2<B, String, B> op) {
                return (B)TraversableOnce.class.$div$colon((TraversableOnce)this, z, op);
            }

            public <B> B $colon$bslash(B z, Function2<String, B, B> op) {
                return (B)TraversableOnce.class.$colon$bslash((TraversableOnce)this, z, op);
            }

            public <B> B foldLeft(B z, Function2<B, String, B> op) {
                return (B)TraversableOnce.class.foldLeft((TraversableOnce)this, z, op);
            }

            public <B> B foldRight(B z, Function2<String, B, B> op) {
                return (B)TraversableOnce.class.foldRight((TraversableOnce)this, z, op);
            }

            public <B> B reduceLeft(Function2<B, String, B> op) {
                return (B)TraversableOnce.class.reduceLeft((TraversableOnce)this, op);
            }

            public <B> B reduceRight(Function2<String, B, B> op) {
                return (B)TraversableOnce.class.reduceRight((TraversableOnce)this, op);
            }

            public <B> Option<B> reduceLeftOption(Function2<B, String, B> op) {
                return TraversableOnce.class.reduceLeftOption((TraversableOnce)this, op);
            }

            public <B> Option<B> reduceRightOption(Function2<String, B, B> op) {
                return TraversableOnce.class.reduceRightOption((TraversableOnce)this, op);
            }

            public <A1> A1 reduce(Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.class.reduce((TraversableOnce)this, op);
            }

            public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
                return TraversableOnce.class.reduceOption((TraversableOnce)this, op);
            }

            public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.class.fold((TraversableOnce)this, z, op);
            }

            public <B> B aggregate(B z, Function2<B, String, B> seqop, Function2<B, B, B> combop) {
                return (B)TraversableOnce.class.aggregate((TraversableOnce)this, z, seqop, combop);
            }

            public <B> B sum(Numeric<B> num) {
                return (B)TraversableOnce.class.sum((TraversableOnce)this, num);
            }

            public <B> B product(Numeric<B> num) {
                return (B)TraversableOnce.class.product((TraversableOnce)this, num);
            }

            public <B> String min(Ordering<B> cmp) {
                return TraversableOnce.class.min((TraversableOnce)this, cmp);
            }

            public <B> String max(Ordering<B> cmp) {
                return TraversableOnce.class.max((TraversableOnce)this, cmp);
            }

            public <B> String maxBy(Function1<String, B> f, Ordering<B> cmp) {
                return TraversableOnce.class.maxBy((TraversableOnce)this, f, cmp);
            }

            public <B> String minBy(Function1<String, B> f, Ordering<B> cmp) {
                return TraversableOnce.class.minBy((TraversableOnce)this, f, cmp);
            }

            public <B> void copyToBuffer(Buffer<B> dest) {
                TraversableOnce.class.copyToBuffer((TraversableOnce)this, dest);
            }

            public <B> void copyToArray(Object xs, int start2) {
                TraversableOnce.class.copyToArray((TraversableOnce)this, (Object)xs, (int)start2);
            }

            public <B> void copyToArray(Object xs) {
                TraversableOnce.class.copyToArray((TraversableOnce)this, (Object)xs);
            }

            public <B> Object toArray(ClassTag<B> evidence$1) {
                return TraversableOnce.class.toArray((TraversableOnce)this, evidence$1);
            }

            public List<String> toList() {
                return TraversableOnce.class.toList((TraversableOnce)this);
            }

            public Iterable<String> toIterable() {
                return TraversableOnce.class.toIterable((TraversableOnce)this);
            }

            public Seq<String> toSeq() {
                return TraversableOnce.class.toSeq((TraversableOnce)this);
            }

            public IndexedSeq<String> toIndexedSeq() {
                return TraversableOnce.class.toIndexedSeq((TraversableOnce)this);
            }

            public <B> Buffer<B> toBuffer() {
                return TraversableOnce.class.toBuffer((TraversableOnce)this);
            }

            public <B> scala.collection.immutable.Set<B> toSet() {
                return TraversableOnce.class.toSet((TraversableOnce)this);
            }

            public Vector<String> toVector() {
                return TraversableOnce.class.toVector((TraversableOnce)this);
            }

            public <Col> Col to(CanBuildFrom<Nothing$, String, Col> cbf) {
                return (Col)TraversableOnce.class.to((TraversableOnce)this, cbf);
            }

            public <T, U> Map<T, U> toMap(Predef.$less$colon$less<String, Tuple2<T, U>> ev) {
                return TraversableOnce.class.toMap((TraversableOnce)this, ev);
            }

            public String mkString(String start2, String sep, String end2) {
                return TraversableOnce.class.mkString((TraversableOnce)this, (String)start2, (String)sep, (String)end2);
            }

            public String mkString(String sep) {
                return TraversableOnce.class.mkString((TraversableOnce)this, (String)sep);
            }

            public String mkString() {
                return TraversableOnce.class.mkString((TraversableOnce)this);
            }

            public StringBuilder addString(StringBuilder b, String start2, String sep, String end2) {
                return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b, (String)start2, (String)sep, (String)end2);
            }

            public StringBuilder addString(StringBuilder b, String sep) {
                return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b, (String)sep);
            }

            public StringBuilder addString(StringBuilder b) {
                return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b);
            }

            public <A1> A1 $div$colon$bslash(A1 z, Function2<A1, A1, A1> op) {
                return (A1)GenTraversableOnce.class.$div$colon$bslash((GenTraversableOnce)this, z, op);
            }

            public int currentOffsetFromEnd() {
                return this.currentOffsetFromEnd;
            }

            public void currentOffsetFromEnd_$eq(int x$1) {
                this.currentOffsetFromEnd = x$1;
            }

            public boolean hasNext() {
                return true;
            }

            public String next() {
                this.currentOffsetFromEnd_$eq(this.currentOffsetFromEnd() + 1);
                if (this.currentOffsetFromEnd() > 10000) {
                    this.currentOffsetFromEnd_$eq(0);
                }
                return new StringBuilder().append((Object)"unmapped").append((Object)((Object)BoxesRunTime.boxToInteger((int)(Integer.MAX_VALUE - this.currentOffsetFromEnd()))).toString()).toString();
            }
            {
                GenTraversableOnce.class.$init$((GenTraversableOnce)this);
                TraversableOnce.class.$init$((TraversableOnce)this);
                Iterator.class.$init$((Iterator)this);
                this.currentOffsetFromEnd = 0;
            }
        };
        OrderedRDDFunctions qual$1 = SparkContext$.MODULE$.rddToOrderedRDDFunctions(this.rdd.map((Function1)new Serializable(this, (Iterator)unmappedReferenceNames){
            public static final long serialVersionUID = 0L;
            private final Iterator unmappedReferenceNames$1;

            public final Tuple2<ReferencePosition, ADAMRecord> apply(ADAMRecord p) {
                Option<ReferencePosition> option;
                block4: {
                    ReferencePosition referencePosition2;
                    block3: {
                        block2: {
                            option = ReferencePosition$.MODULE$.apply(p);
                            None$ none$ = None$.MODULE$;
                            if (none$ != null ? !none$.equals(option) : option != null) break block2;
                            referencePosition2 = new ReferencePosition((String)this.unmappedReferenceNames$1.next(), Long.MAX_VALUE);
                            break block3;
                        }
                        if (!(option instanceof Some)) break block4;
                        Some some = (Some)option;
                        referencePosition2 = (ReferencePosition)some.x();
                    }
                    return new Tuple2((Object)referencePosition2, (Object)p);
                }
                throw new MatchError(option);
            }
            {
                this.unmappedReferenceNames$1 = unmappedReferenceNames$1;
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)), (Function1)Predef$.MODULE$.conforms(), ClassTag$.MODULE$.apply(ReferencePosition.class), ClassTag$.MODULE$.apply(ADAMRecord.class));
        boolean x$22 = qual$1.sortByKey$default$1();
        int x$23 = qual$1.sortByKey$default$2();
        return qual$1.sortByKey(x$22, x$23).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final ADAMRecord apply(Tuple2<ReferencePosition, ADAMRecord> p) {
                return (ADAMRecord)p._2();
            }
        }, ClassTag$.MODULE$.apply(ADAMRecord.class));
    }

    public RDD<ADAMRecord> adamMarkDuplicates() {
        return MarkDuplicates$.MODULE$.apply(this.rdd);
    }

    public RDD<ADAMRecord> adamBQSR(Broadcast<SnpTable> knownSnps) {
        return BaseQualityRecalibration$.MODULE$.apply(this.rdd, knownSnps);
    }

    public RDD<ADAMRecord> adamRealignIndels() {
        return RealignIndels$.MODULE$.apply(this.rdd);
    }

    public Tuple2<FlagStatMetrics, FlagStatMetrics> adamFlagStat() {
        return FlagStat$.MODULE$.apply(this.rdd);
    }

    public RDD<SingleReadBucket> adamSingleReadBuckets() {
        return SingleReadBucket$.MODULE$.apply(this.rdd);
    }

    public RDD<ADAMPileup> adamRecords2Pileup(boolean secondaryAlignments) {
        Reads2PileupProcessor helper = new Reads2PileupProcessor(secondaryAlignments);
        return helper.process(this.rdd);
    }

    public boolean adamRecords2Pileup$default$1() {
        return false;
    }

    public RDD<ADAMRod> adamRecords2Rods(int bucketSize, boolean secondaryAlignments) {
        Predef$.MODULE$.println((Object)"Putting reads in buckets.");
        RDD bucketedReads = SparkContext$.MODULE$.rddToPairRDDFunctions(this.rdd.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(ADAMRecord x$6) {
                return x$6.getStart() != null;
            }
        }).flatMap((Function1)new Serializable(this, bucketSize){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ADAMRecordRDDFunctions $outer;
            private final int bucketSize$1;

            public final List<Tuple2<ReferencePosition, ADAMRecord>> apply(ADAMRecord r) {
                return this.$outer.org$bdgenomics$adam$rdd$ADAMRecordRDDFunctions$$mapToBucket$1(r, this.bucketSize$1);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.bucketSize$1 = bucketSize$1;
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(ReferencePosition.class), ClassTag$.MODULE$.apply(ADAMRecord.class)).groupByKey();
        Predef$.MODULE$.println((Object)"Have reads in buckets.");
        Reads2PileupProcessor pp = new Reads2PileupProcessor(secondaryAlignments);
        return bucketedReads.flatMap((Function1)new Serializable(this, pp){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ADAMRecordRDDFunctions $outer;
            private final Reads2PileupProcessor pp$1;

            public final Seq<ADAMRod> apply(Tuple2<ReferencePosition, Seq<ADAMRecord>> bucket) {
                return this.$outer.org$bdgenomics$adam$rdd$ADAMRecordRDDFunctions$$bucketedReadsToRods$1(bucket, this.pp$1);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.pp$1 = pp$1;
            }
        }, ClassTag$.MODULE$.apply(ADAMRod.class));
    }

    public int adamRecords2Rods$default$1() {
        return 1000;
    }

    public boolean adamRecords2Rods$default$2() {
        return false;
    }

    public RDD<Tuple2<String, Object>> adamCharacterizeTags() {
        return SparkContext$.MODULE$.rddToPairRDDFunctions(this.rdd.flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<Tuple2<String, Object>> apply(ADAMRecord x$9) {
                return (Seq)RichADAMRecord$.MODULE$.apply(x$9).tags().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<String, Object> apply(Attribute attr) {
                        return new Tuple2((Object)attr.tag(), (Object)BoxesRunTime.boxToLong((long)1L));
                    }
                }, Seq$.MODULE$.canBuildFrom());
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.Long()).reduceByKey((Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(long x$10, long x$11) {
                return x$10 + x$11;
            }

            public long apply$mcJJJ$sp(long x$10, long x$11) {
                return x$10 + x$11;
            }
        });
    }

    public Map<Object, Object> adamCharacterizeTagValues(String tag) {
        return (Map)this.adamFilterRecordsWithTag(tag).flatMap((Function1)new Serializable(this, tag){
            public static final long serialVersionUID = 0L;
            public final String tag$1;

            public final Iterable<Attribute> apply(ADAMRecord x$12) {
                return Option$.MODULE$.option2Iterable(RichADAMRecord$.MODULE$.apply(x$12).tags().find((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$adamCharacterizeTagValues$1 $outer;

                    public final boolean apply(Attribute x$13) {
                        String string = x$13.tag();
                        String string2 = this.$outer.tag$1;
                        return !(string != null ? !string.equals(string2) : string2 != null);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }));
            }
            {
                this.tag$1 = tag$1;
            }
        }, ClassTag$.MODULE$.apply(Attribute.class)).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Map<Object, Object> apply(Attribute attr) {
                Tuple2[] tuple2Array = new Tuple2[1];
                Object object = attr.value();
                Predef$ predef$ = Predef$.MODULE$;
                Long l = BoxesRunTime.boxToLong((long)1L);
                Predef.ArrowAssoc$ arrowAssoc$ = Predef.ArrowAssoc$.MODULE$;
                tuple2Array[0] = new Tuple2(object, (Object)l);
                return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array));
            }
        }, ClassTag$.MODULE$.apply(Map.class)).reduce((Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Map<Object, Object> apply(Map<Object, Object> map1, Map<Object, Object> map2) {
                return MapTools$.MODULE$.add(map1, map2, Numeric.LongIsIntegral$.MODULE$);
            }
        });
    }

    public RDD<ADAMRecord> adamFilterRecordsWithTag(String tagName) {
        boolean bl = tagName.length() == 2;
        Predef$ predef$ = Predef$.MODULE$;
        if (!bl) {
            Predef$ predef$2 = Predef$.MODULE$;
            throw new AssertionError((Object)new StringBuilder().append((Object)"assertion failed: ").append((Object)new StringOps("withAttribute takes a tagName argument of length 2; tagName=\"%s\"").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tagName}))).toString());
        }
        return this.rdd.filter((Function1)new Serializable(this, tagName){
            public static final long serialVersionUID = 0L;
            public final String tagName$1;

            public final boolean apply(ADAMRecord x$14) {
                return RichADAMRecord$.MODULE$.apply(x$14).tags().exists((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$adamFilterRecordsWithTag$2 $outer;

                    public final boolean apply(Attribute x$15) {
                        String string = x$15.tag();
                        String string2 = this.$outer.tagName$1;
                        return !(string != null ? !string.equals(string2) : string2 != null);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.tagName$1 = tagName$1;
            }
        });
    }

    public RDD<ADAMRecord> adamTrimReads(int trimStart, int trimEnd, int readGroup) {
        return TrimReads$.MODULE$.apply(this.rdd, trimStart, trimEnd, readGroup);
    }

    public int adamTrimReads$default$3() {
        return -1;
    }

    public RDD<ADAMRecord> adamTrimLowQualityReadGroups(int phredThreshold) {
        return TrimReads$.MODULE$.apply(this.rdd, phredThreshold);
    }

    public int adamTrimLowQualityReadGroups$default$1() {
        return 20;
    }

    public final List org$bdgenomics$adam$rdd$ADAMRecordRDDFunctions$$mapToBucket$1(ADAMRecord r, int bucketSize$1) {
        long s = Predef$.MODULE$.Long2long(r.getStart()) / (long)bucketSize$1;
        long e = BoxesRunTime.unboxToLong((Object)RichADAMRecord$.MODULE$.apply(r).end().get()) / (long)bucketSize$1;
        CharSequence name2 = r.getContig().getContigName();
        return s == e ? List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)new ReferencePosition(ADAMContext$.MODULE$.charSequenceToString(name2), s), (Object)r)})) : List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)new ReferencePosition(ADAMContext$.MODULE$.charSequenceToString(name2), s), (Object)r), new Tuple2((Object)new ReferencePosition(ADAMContext$.MODULE$.charSequenceToString(name2), e), (Object)r)}));
    }

    public final Seq org$bdgenomics$adam$rdd$ADAMRecordRDDFunctions$$bucketedReadsToRods$1(Tuple2 bucket, Reads2PileupProcessor pp$1) {
        if (bucket != null) {
            Tuple2 tuple2 = new Tuple2(bucket._1(), bucket._2());
            tuple2._1();
            Seq bucketReads = (Seq)tuple2._2();
            return ((scala.collection.immutable.Seq)((TraversableLike)bucketReads.flatMap((Function1)new Serializable(this, pp$1){
                public static final long serialVersionUID = 0L;
                private final Reads2PileupProcessor pp$1;

                public final List<ADAMPileup> apply(ADAMRecord record) {
                    return this.pp$1.readToPileups(record);
                }
                {
                    this.pp$1 = pp$1;
                }
            }, Seq$.MODULE$.canBuildFrom())).groupBy((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final ReferencePosition apply(ADAMPileup x$8) {
                    return ReferencePosition$.MODULE$.apply(x$8);
                }
            }).toList().map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final ADAMRod apply(Tuple2<ReferencePosition, Seq<ADAMPileup>> g) {
                    return new ADAMRod((ReferencePosition)g._1(), (List<ADAMPileup>)((TraversableOnce)g._2()).toList());
                }
            }, List$.MODULE$.canBuildFrom())).toSeq();
        }
        throw new MatchError((Object)bucket);
    }

    public ADAMRecordRDDFunctions(RDD<ADAMRecord> rdd) {
        this.rdd = rdd;
        super(rdd);
    }
}

