/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.rdd;

import org.apache.spark.Partitioner;
import org.bdgenomics.adam.models.ReferencePosition;
import org.bdgenomics.adam.models.ReferencePosition$;
import org.bdgenomics.adam.models.SequenceDictionary;
import org.bdgenomics.adam.rdd.GenomicRegionPartitioner$;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005-c\u0001B\u0001\u0003\u0001-\u0011\u0001dR3o_6L7MU3hS>t\u0007+\u0019:uSRLwN\\3s\u0015\t\u0019A!A\u0002sI\u0012T!!\u0002\u0004\u0002\t\u0005$\u0017-\u001c\u0006\u0003\u000f!\t!B\u00193hK:|W.[2t\u0015\u0005I\u0011aA8sO\u000e\u00011C\u0001\u0001\r!\ti!#D\u0001\u000f\u0015\ty\u0001#A\u0003ta\u0006\u00148N\u0003\u0002\u0012\u0011\u00051\u0011\r]1dQ\u0016L!a\u0005\b\u0003\u0017A\u000b'\u000f^5uS>tWM\u001d\u0005\t+\u0001\u0011)\u0019!C\u0001-\u0005Aa.^7QCJ$8/F\u0001\u0018!\tA2$D\u0001\u001a\u0015\u0005Q\u0012!B:dC2\f\u0017B\u0001\u000f\u001a\u0005\rIe\u000e\u001e\u0005\t=\u0001\u0011\t\u0011)A\u0005/\u0005Ia.^7QCJ$8\u000f\t\u0005\tA\u0001\u0011)\u0019!C\u0001C\u0005Q1/Z9MK:<G\u000f[:\u0016\u0003\t\u0002Ba\t\u0014*Y9\u0011\u0001\u0004J\u0005\u0003Ke\ta\u0001\u0015:fI\u00164\u0017BA\u0014)\u0005\ri\u0015\r\u001d\u0006\u0003Ke\u0001\"a\t\u0016\n\u0005-B#AB*ue&tw\r\u0005\u0002\u0019[%\u0011a&\u0007\u0002\u0005\u0019>tw\r\u0003\u00051\u0001\t\u0005\t\u0015!\u0003#\u0003-\u0019X-\u001d'f]\u001e$\bn\u001d\u0011\t\u000bI\u0002A\u0011A\u001a\u0002\rqJg.\u001b;?)\r!dg\u000e\t\u0003k\u0001i\u0011A\u0001\u0005\u0006+E\u0002\ra\u0006\u0005\u0006AE\u0002\rA\t\u0005\u0006e\u0001!\t!\u000f\u000b\u0004iiZ\u0004\"B\u000b9\u0001\u00049\u0002\"\u0002\u001f9\u0001\u0004i\u0014aB:fc\u0012K7\r\u001e\t\u0003}\u0005k\u0011a\u0010\u0006\u0003\u0001\u0012\ta!\\8eK2\u001c\u0018B\u0001\"@\u0005I\u0019V-];f]\u000e,G)[2uS>t\u0017M]=\t\u000f\u0011\u0003!\u0019!C\u0001\u000b\u0006)a.Y7fgV\ta\tE\u0002H\u001f&r!\u0001S'\u000f\u0005%cU\"\u0001&\u000b\u0005-S\u0011A\u0002\u001fs_>$h(C\u0001\u001b\u0013\tq\u0015$A\u0004qC\u000e\\\u0017mZ3\n\u0005A\u000b&aA*fc*\u0011a*\u0007\u0005\u0007'\u0002\u0001\u000b\u0011\u0002$\u0002\r9\fW.Z:!\u0011\u001d)\u0006A1A\u0005\u0002Y\u000bq\u0001\\3oORD7/F\u0001X!\r9u\n\f\u0005\u00073\u0002\u0001\u000b\u0011B,\u0002\u00111,gn\u001a;ig\u0002Bqa\u0017\u0001C\u0002\u0013%a+\u0001\u0004dk6,Hn\u001d\u0005\u0007;\u0002\u0001\u000b\u0011B,\u0002\u000f\r,X.\u001e7tA!9q\f\u0001b\u0001\n\u0003\u0001\u0017a\u0003;pi\u0006dG*\u001a8hi\",\u0012\u0001\f\u0005\u0007E\u0002\u0001\u000b\u0011\u0002\u0017\u0002\u0019Q|G/\u00197MK:<G\u000f\u001b\u0011\t\u000f\u0011\u0004!\u0019!C\u0001C\u0005\t2-^7vY\u0006$\u0018N^3MK:<G\u000f[:\t\r\u0019\u0004\u0001\u0015!\u0003#\u0003I\u0019W/\\;mCRLg/\u001a'f]\u001e$\bn\u001d\u0011\t\u000f!\u0004!\u0019!C\u0005-\u0005)\u0001/\u0019:ug\"1!\u000e\u0001Q\u0001\n]\ta\u0001]1siN\u0004\u0003\"\u00027\u0001\t\u00032\u0012!\u00048v[B\u000b'\u000f^5uS>t7\u000fC\u0003o\u0001\u0011\u0005s.\u0001\u0007hKR\u0004\u0016M\u001d;ji&|g\u000e\u0006\u0002\u0018a\")\u0011/\u001ca\u0001e\u0006\u00191.Z=\u0011\u0005a\u0019\u0018B\u0001;\u001a\u0005\r\te.\u001f\u0005\u0006m\u0002!\te^\u0001\u0007KF,\u0018\r\\:\u0015\u0005a\\\bC\u0001\rz\u0013\tQ\u0018DA\u0004C_>dW-\u00198\t\u000bq,\b\u0019\u0001:\u0002\u0003aDQA \u0001\u0005B}\f\u0001\u0002^8TiJLgn\u001a\u000b\u0002S!9\u00111\u0001\u0001\u0005B\u0005\u0015\u0011\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0003]9q!!\u0003\u0003\u0011\u0003\tY!\u0001\rHK:|W.[2SK\u001eLwN\u001c)beRLG/[8oKJ\u00042!NA\u0007\r\u0019\t!\u0001#\u0001\u0002\u0010M1\u0011QBA\t\u0003/\u00012\u0001GA\n\u0013\r\t)\"\u0007\u0002\u0007\u0003:L(+\u001a4\u0011\u0007a\tI\"C\u0002\u0002\u001ce\u0011AbU3sS\u0006d\u0017N_1cY\u0016DqAMA\u0007\t\u0003\ty\u0002\u0006\u0002\u0002\f!A\u00111EA\u0007\t\u0003\t)#A\u0003baBd\u0017\u0010F\u00035\u0003O\tY\u0003C\u0004\u0002*\u0005\u0005\u0002\u0019A\f\u0002\u00039Ca!VA\u0011\u0001\u0004\u0011\u0003\u0002CA\u0018\u0003\u001b!\t!!\r\u0002!\u0015DHO]1di2+gn\u001a;i\u001b\u0006\u0004Hc\u0001\u0012\u00024!1A(!\fA\u0002uB!\"a\u000e\u0002\u000e\u0005\u0005I\u0011BA\u001d\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005m\u0002\u0003BA\u001f\u0003\u000fj!!a\u0010\u000b\t\u0005\u0005\u00131I\u0001\u0005Y\u0006twM\u0003\u0002\u0002F\u0005!!.\u0019<b\u0013\u0011\tI%a\u0010\u0003\r=\u0013'.Z2u\u0001")
public class GenomicRegionPartitioner
extends Partitioner {
    private final int numParts;
    private final Map<String, Object> seqLengths;
    private final Seq<String> names;
    private final Seq<Object> lengths;
    private final Seq<Object> cumuls;
    private final long totalLength;
    private final Map<String, Object> cumulativeLengths;
    private final int parts;

    public static Map<String, Object> extractLengthMap(SequenceDictionary sequenceDictionary) {
        return GenomicRegionPartitioner$.MODULE$.extractLengthMap(sequenceDictionary);
    }

    public static GenomicRegionPartitioner apply(int n, Map<String, Object> map) {
        return GenomicRegionPartitioner$.MODULE$.apply(n, map);
    }

    public int numParts() {
        return this.numParts;
    }

    public Map<String, Object> seqLengths() {
        return this.seqLengths;
    }

    public Seq<String> names() {
        return this.names;
    }

    public Seq<Object> lengths() {
        return this.lengths;
    }

    private Seq<Object> cumuls() {
        return this.cumuls;
    }

    public long totalLength() {
        return this.totalLength;
    }

    public Map<String, Object> cumulativeLengths() {
        return this.cumulativeLengths;
    }

    private int parts() {
        return this.parts;
    }

    public int numPartitions() {
        return this.parts() + 1;
    }

    public int getPartition(Object key) {
        block4: {
            int n;
            block3: {
                block2: {
                    ReferencePosition referencePosition2 = ReferencePosition$.MODULE$.UNMAPPED();
                    if (referencePosition2 != null ? !((Object)referencePosition2).equals(key) : key != null) break block2;
                    n = this.parts();
                    break block3;
                }
                if (!(key instanceof ReferencePosition)) break block4;
                ReferencePosition referencePosition3 = (ReferencePosition)key;
                n = this.getPart$1(referencePosition3.referenceName(), referencePosition3.pos());
            }
            return n;
        }
        throw new IllegalArgumentException("Only ReferencePosition values can be partitioned by GenomicRegionPartitioner");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x) {
        if (!(x instanceof GenomicRegionPartitioner)) return false;
        GenomicRegionPartitioner genomicRegionPartitioner = (GenomicRegionPartitioner)((Object)x);
        if (genomicRegionPartitioner.numPartitions() != this.numPartitions()) return false;
        Seq<String> seq = this.names();
        Seq<String> seq2 = genomicRegionPartitioner.names();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        Seq<Object> seq3 = this.lengths();
        Seq<Object> seq4 = genomicRegionPartitioner.lengths();
        if (seq3 == null) {
            if (seq4 == null) return true;
            return false;
        } else {
            if (!seq3.equals(seq4)) return false;
            return true;
        }
    }

    public String toString() {
        Predef$ predef$ = Predef$.MODULE$;
        return new StringOps("%d parts, %d partitions, %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.parts()), BoxesRunTime.boxToInteger((int)this.numPartitions()), this.cumulativeLengths().toString()}));
    }

    public int hashCode() {
        return 37 * (37 * this.parts() + this.names().hashCode()) + this.lengths().hashCode();
    }

    private final int getPart$1(String referenceName, long pos) {
        long totalOffset = BoxesRunTime.unboxToLong((Object)this.cumulativeLengths().apply((Object)referenceName)) + pos;
        double totalFraction = (double)totalOffset / (double)this.totalLength();
        return package$.MODULE$.min((int)package$.MODULE$.floor(totalFraction * (double)this.parts()), this.numPartitions());
    }

    public GenomicRegionPartitioner(int numParts, Map<String, Object> seqLengths) {
        this.numParts = numParts;
        this.seqLengths = seqLengths;
        this.names = (Seq)seqLengths.keys().toSeq().sortWith((Function2)new $anonfun$3(this));
        this.lengths = (Seq)this.names().map((Function1)new $anonfun$4(this), Seq$.MODULE$.canBuildFrom());
        this.cumuls = (Seq)this.lengths().scan((Object)BoxesRunTime.boxToLong((long)0L), (Function2)new $anonfun$1(this), Seq$.MODULE$.canBuildFrom());
        this.totalLength = BoxesRunTime.unboxToLong((Object)this.lengths().reduce((Function2)new $anonfun$2(this)));
        this.cumulativeLengths = (Map)Predef$.MODULE$.Map().apply((Seq)this.names().zip(this.cumuls(), Seq$.MODULE$.canBuildFrom()));
        this.parts = (int)package$.MODULE$.min((long)numParts, this.totalLength());
    }

    public GenomicRegionPartitioner(int numParts, SequenceDictionary seqDict) {
        this(numParts, GenomicRegionPartitioner$.MODULE$.extractLengthMap(seqDict));
    }
}

