/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.converters;

import net.sf.samtools.SAMRecord;
import org.bdgenomics.adam.avro.ADAMContig;
import org.bdgenomics.adam.avro.ADAMRecord;
import org.bdgenomics.adam.converters.ADAMRecordConverter;
import org.bdgenomics.adam.models.RecordGroupDictionary;
import org.bdgenomics.adam.models.SAMFileHeaderWritable;
import org.bdgenomics.adam.models.SequenceDictionary;
import org.bdgenomics.adam.models.SequenceDictionary$;
import org.bdgenomics.adam.models.SequenceRecord;
import org.bdgenomics.adam.models.SequenceRecord$;
import org.scalatest.FunSuite;
import org.scalatest.Tag;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u001d3A!\u0001\u0002\u0001\u0017\tA\u0012\tR!N%\u0016\u001cwN\u001d3D_:4XM\u001d;feN+\u0018\u000e^3\u000b\u0005\r!\u0011AC2p]Z,'\u000f^3sg*\u0011QAB\u0001\u0005C\u0012\fWN\u0003\u0002\b\u0011\u0005Q!\rZ4f]>l\u0017nY:\u000b\u0003%\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\u0007\u0011\u00055\u0001R\"\u0001\b\u000b\u0005=A\u0011!C:dC2\fG/Z:u\u0013\t\tbB\u0001\u0005Gk:\u001cV/\u001b;f\u0011\u0015\u0019\u0002\u0001\"\u0001\u0015\u0003\u0019a\u0014N\\5u}Q\tQ\u0003\u0005\u0002\u0017\u00015\t!\u0001C\u0003\u0019\u0001\u0011\u0005\u0011$A\u0005nC.,wL]3bIR1!\u0004\t\u00152ga\u0002\"a\u0007\u0010\u000e\u0003qQ!!\b\u0003\u0002\t\u00054(o\\\u0005\u0003?q\u0011!\"\u0011#B\u001bJ+7m\u001c:e\u0011\u0015\ts\u00031\u0001#\u0003\u0015\u0019H/\u0019:u!\t\u0019c%D\u0001%\u0015\u0005)\u0013!B:dC2\f\u0017BA\u0014%\u0005\u0011auN\\4\t\u000b%:\u0002\u0019\u0001\u0016\u0002\u000b\rLw-\u0019:\u0011\u0005-rcBA\u0012-\u0013\tiC%\u0001\u0004Qe\u0016$WMZ\u0005\u0003_A\u0012aa\u0015;sS:<'BA\u0017%\u0011\u0015\u0011t\u00031\u0001+\u0003\u0015iG\r^1h\u0011\u0015!t\u00031\u00016\u0003\u0019aWM\\4uQB\u00111EN\u0005\u0003o\u0011\u00121!\u00138u\u0011\u001dIt\u0003%AA\u0002U\n!!\u001b3\t\u000fm\u0002\u0011\u0013!C\u0001y\u0005\u0019R.Y6f?J,\u0017\r\u001a\u0013eK\u001a\fW\u000f\u001c;%kU\tQH\u000b\u00026}-\nq\b\u0005\u0002A\u000b6\t\u0011I\u0003\u0002C\u0007\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0003\t\u0012\n!\"\u00198o_R\fG/[8o\u0013\t1\u0015IA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\u0004")
public class ADAMRecordConverterSuite
extends FunSuite {
    public ADAMRecord make_read(long start, String cigar, String mdtag, int length, int id) {
        Predef$ predef$ = Predef$.MODULE$;
        String sequence = new StringOps("A").$times(length);
        return ADAMRecord.newBuilder().setReadName((CharSequence)new StringBuilder().append((Object)"read").append((Object)((Object)BoxesRunTime.boxToInteger((int)id)).toString()).toString()).setStart(Predef$.MODULE$.long2Long(start)).setReadMapped(Predef$.MODULE$.boolean2Boolean(true)).setCigar((CharSequence)cigar).setSequence((CharSequence)sequence).setReadNegativeStrand(Predef$.MODULE$.boolean2Boolean(false)).setMapq(Predef$.MODULE$.int2Integer(60)).setQual((CharSequence)sequence).setMismatchingPositions((CharSequence)mdtag).build();
    }

    public int make_read$default$5() {
        return 0;
    }

    public ADAMRecordConverterSuite() {
        this.test("testing the fields in a converted ADAM Read", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ADAMRecordConverterSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ADAMRecord adamRead = this.$outer.make_read(3L, "2M3D2M", "2^AAA2", 4, this.$outer.make_read$default$5());
                adamRead.setRecordGroupName((CharSequence)"testname");
                adamRead.setContig(ADAMContig.newBuilder().setContigName((CharSequence)"referencetest").build());
                adamRead.setMateReference((CharSequence)"matereferencetest");
                adamRead.setMateContig(ADAMContig.newBuilder().setContigName((CharSequence)"matereferencetest").setContigLength(Predef$.MODULE$.long2Long(6L)).setReferenceURL((CharSequence)"test://chrom1").build());
                adamRead.setMateAlignmentStart(Predef$.MODULE$.long2Long(6L));
                SequenceRecord seqRecForDict = SequenceRecord$.MODULE$.apply("referencetest", 5L, (CharSequence)"test://chrom1", SequenceRecord$.MODULE$.apply$default$4(), SequenceRecord$.MODULE$.apply$default$5(), SequenceRecord$.MODULE$.apply$default$6(), SequenceRecord$.MODULE$.apply$default$7(), SequenceRecord$.MODULE$.apply$default$8());
                SequenceDictionary dict = SequenceDictionary$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SequenceRecord[]{seqRecForDict}));
                RecordGroupDictionary readGroups = new RecordGroupDictionary((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"testing"})));
                ADAMRecordConverter adamRecordConverter = new ADAMRecordConverter();
                SAMRecord toSAM = adamRecordConverter.convert(adamRead, new SAMFileHeaderWritable(adamRecordConverter.createSAMHeader(dict, readGroups)));
                Predef$ predef$ = Predef$.MODULE$;
                String sequence = new StringOps("A").$times(4);
                this.$outer.assert(this.$outer.convertToEqualizer(toSAM.getReadName()).$eq$eq$eq((Object)new StringBuilder().append((Object)"read").append((Object)((Object)BoxesRunTime.boxToInteger((int)0)).toString()).toString()));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)toSAM.getAlignmentStart())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)4)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)toSAM.getReadUnmappedFlag())).$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)false)));
                this.$outer.assert(this.$outer.convertToEqualizer(toSAM.getCigarString()).$eq$eq$eq((Object)"2M3D2M"));
                this.$outer.assert(this.$outer.convertToEqualizer(toSAM.getReadString()).$eq$eq$eq((Object)sequence));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)toSAM.getReadNegativeStrandFlag())).$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)false)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)toSAM.getMappingQuality())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)60)));
                this.$outer.assert(this.$outer.convertToEqualizer(toSAM.getBaseQualityString()).$eq$eq$eq((Object)sequence));
                this.$outer.assert(this.$outer.convertToEqualizer(toSAM.getAttribute("MD")).$eq$eq$eq((Object)"2^AAA2"));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

