/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.converters;

import java.io.InputStream;
import org.bdgenomics.adam.avro.ADAMFlatGenotype;
import org.bdgenomics.adam.converters.VCFLine;
import org.bdgenomics.adam.converters.VCFLineConverter$;
import org.bdgenomics.adam.converters.VCFLineParser;
import org.bdgenomics.adam.converters.VCFLineParser$;
import org.bdgenomics.adam.converters.VCFLineParserSuite$;
import org.scalatest.FunSuite;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001]1A!\u0001\u0002\u0001\u0017\t\u0011bk\u0011$MS:,\u0007+\u0019:tKJ\u001cV/\u001b;f\u0015\t\u0019A!\u0001\u0006d_:4XM\u001d;feNT!!\u0002\u0004\u0002\t\u0005$\u0017-\u001c\u0006\u0003\u000f!\t!B\u00193hK:|W.[2t\u0015\u0005I\u0011aA8sO\u000e\u00011C\u0001\u0001\r!\ti\u0001#D\u0001\u000f\u0015\ty\u0001\"A\u0005tG\u0006d\u0017\r^3ti&\u0011\u0011C\u0004\u0002\t\rVt7+^5uK\")1\u0003\u0001C\u0001)\u00051A(\u001b8jiz\"\u0012!\u0006\t\u0003-\u0001i\u0011A\u0001")
public class VCFLineParserSuite
extends FunSuite {
    public VCFLineParserSuite() {
        this.test("can parse a simple VCF", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ VCFLineParserSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream("small.vcf");
                VCFLineParser parser = new VCFLineParser(is, VCFLineParser$.MODULE$.$lessinit$greater$default$2());
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)parser.size())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)5)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("passing in the optional sampleSet parameter results in fewer columns being parsed", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            public final /* synthetic */ VCFLineParserSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream("small.vcf");
                VCFLineParser parser = new VCFLineParser(is, (Option)new Some((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"NA12878"}))));
                parser.foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$2 $outer;

                    public final void apply(VCFLine x0$1) {
                        if (x0$1 != null) {
                            this.$outer.$outer.assert(this.$outer.$outer.convertToEqualizer(x0$1.samples()).$eq$eq$eq((Object)new String[]{"NA12878"}));
                            return;
                        }
                        throw new MatchError((Object)x0$1);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ VCFLineParserSuite org$bdgenomics$adam$converters$VCFLineParserSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("can convert into ADMAFlatGenotype records", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ VCFLineParserSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream("small.vcf");
                VCFLineParser parser = new VCFLineParser(is, VCFLineParser$.MODULE$.$lessinit$greater$default$2());
                Iterator gts = parser.flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Seq<ADAMFlatGenotype> apply(VCFLine line) {
                        return VCFLineConverter$.MODULE$.convert(line);
                    }
                });
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)gts.size())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)15)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("passing in a sample subsets results in fewer ADAMFlatGenotype records being produced", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            public final /* synthetic */ VCFLineParserSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream("small_missing.vcf");
                VCFLineParser parser = new VCFLineParser(is, (Option)new Some((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"NA12878"}))));
                Seq gts = parser.flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Seq<ADAMFlatGenotype> apply(VCFLine line) {
                        return VCFLineConverter$.MODULE$.convert(line);
                    }
                }).toSeq();
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)gts.length())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)4)));
                gts.foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$4 $outer;

                    public final void apply(ADAMFlatGenotype x0$2) {
                        if (x0$2 != null) {
                            this.$outer.$outer.assert(this.$outer.$outer.convertToEqualizer(x0$2.getReferenceName()).$eq$eq$eq((Object)"1"));
                            this.$outer.$outer.assert(this.$outer.org$bdgenomics$adam$converters$VCFLineParserSuite$$anonfun$$$outer().convertToEqualizer(x0$2.getSampleId()).$eq$eq$eq((Object)"NA12878"));
                            return;
                        }
                        throw new MatchError((Object)x0$2);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ VCFLineParserSuite org$bdgenomics$adam$converters$VCFLineParserSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

