/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.models;

import java.io.File;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMSequenceDictionary;
import net.sf.samtools.SAMSequenceRecord;
import org.bdgenomics.adam.models.SequenceDictionary;
import org.bdgenomics.adam.models.SequenceDictionary$;
import org.bdgenomics.adam.models.SequenceRecord;
import org.bdgenomics.adam.models.SequenceRecord$;
import org.bdgenomics.adam.rdd.ADAMContext$;
import org.scalatest.FunSuite;
import org.scalatest.Tag;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001!3A!\u0001\u0002\u0001\u0017\t92+Z9vK:\u001cW\rR5di&|g.\u0019:z'VLG/\u001a\u0006\u0003\u0007\u0011\ta!\\8eK2\u001c(BA\u0003\u0007\u0003\u0011\tG-Y7\u000b\u0005\u001dA\u0011A\u00032eO\u0016tw.\\5dg*\t\u0011\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001\u0019A\u0011Q\u0002E\u0007\u0002\u001d)\u0011q\u0002C\u0001\ng\u000e\fG.\u0019;fgRL!!\u0005\b\u0003\u0011\u0019+hnU;ji\u0016DQa\u0005\u0001\u0005\u0002Q\ta\u0001P5oSRtD#A\u000b\u0011\u0005Y\u0001Q\"\u0001\u0002\t\u000ba\u0001A\u0011A\r\u0002\rI,7m\u001c:e)\u0015QR$\u000b\u00184!\t12$\u0003\u0002\u001d\u0005\tq1+Z9vK:\u001cWMU3d_J$\u0007\"\u0002\u0010\u0018\u0001\u0004y\u0012\u0001\u00028b[\u0016\u0004\"\u0001\t\u0014\u000f\u0005\u0005\"S\"\u0001\u0012\u000b\u0003\r\nQa]2bY\u0006L!!\n\u0012\u0002\rA\u0013X\rZ3g\u0013\t9\u0003F\u0001\u0004TiJLgn\u001a\u0006\u0003K\tBqAK\f\u0011\u0002\u0003\u00071&\u0001\u0004mK:<G\u000f\u001b\t\u0003C1J!!\f\u0012\u0003\t1{gn\u001a\u0005\b_]\u0001\n\u00111\u00011\u0003\r)(\u000f\u001c\t\u0004CEz\u0012B\u0001\u001a#\u0005\u0019y\u0005\u000f^5p]\"9Ag\u0006I\u0001\u0002\u0004\u0001\u0014aA7ek!9a\u0007AI\u0001\n\u00039\u0014\u0001\u0005:fG>\u0014H\r\n3fM\u0006,H\u000e\u001e\u00133+\u0005A$FA\u0016:W\u0005Q\u0004CA\u001eA\u001b\u0005a$BA\u001f?\u0003%)hn\u00195fG.,GM\u0003\u0002@E\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005\u0005c$!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"91\tAI\u0001\n\u0003!\u0015\u0001\u0005:fG>\u0014H\r\n3fM\u0006,H\u000e\u001e\u00134+\u0005)%F\u0001\u0019:\u0011\u001d9\u0005!%A\u0005\u0002\u0011\u000b\u0001C]3d_J$G\u0005Z3gCVdG\u000f\n\u001b")
public class SequenceDictionarySuite
extends FunSuite {
    public SequenceRecord record(String name, long length, Option<String> url, Option<String> md5) {
        return new SequenceRecord(name, length, url, md5, SequenceRecord$.MODULE$.$lessinit$greater$default$5(), SequenceRecord$.MODULE$.$lessinit$greater$default$6(), SequenceRecord$.MODULE$.$lessinit$greater$default$7(), SequenceRecord$.MODULE$.$lessinit$greater$default$8());
    }

    public long record$default$2() {
        return 1000L;
    }

    public Option<String> record$default$3() {
        return None$.MODULE$;
    }

    public Option<String> record$default$4() {
        return None$.MODULE$;
    }

    public SequenceDictionarySuite() {
        this.test("Convert from sam sequence record and back", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SequenceDictionarySuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SAMSequenceRecord sr = new SAMSequenceRecord("1", 1000);
                sr.setAttribute("UR", "http://bigdatagenomics.github.io/1");
                SequenceRecord asASR = SequenceRecord$.MODULE$.fromSAMSequenceRecord(sr);
                this.$outer.assert(this.$outer.convertToEqualizer(asASR.name()).$eq$eq$eq((Object)"1"));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)asASR.length())).$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)1000L)));
                this.$outer.assert(this.$outer.convertToEqualizer(asASR.url()).$eq$eq$eq((Object)new Some((Object)"http://bigdatagenomics.github.io/1")));
                SAMSequenceRecord asPSR = SequenceRecord$.MODULE$.toSAMSequenceRecord(asASR);
                this.$outer.assert(sr.isSameSequence(asPSR));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Convert from SAM sequence dictionary file (with extra fields)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SequenceDictionarySuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String path = ClassLoader.getSystemClassLoader().getResource("dict_with_accession.dict").getFile();
                SAMSequenceDictionary ssd = SAMFileReader.getSequenceDictionary((File)new File(path));
                SAMSequenceRecord chr1 = ssd.getSequence("1");
                this.$outer.assert(chr1 != null);
                String refseq = chr1.getAttribute("REFSEQ");
                this.$outer.assert(this.$outer.convertToEqualizer(refseq).$eq$eq$eq((Object)"NC_000001.10"));
                SequenceDictionary asd = SequenceDictionary$.MODULE$.apply(ssd);
                this.$outer.assert(asd.containsRefName("1"));
                this.$outer.assert(!asd.containsRefName("2"));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("merge into existing dictionary", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SequenceDictionarySuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String path = ClassLoader.getSystemClassLoader().getResource("dict_with_accession.dict").getFile();
                SAMSequenceDictionary ssd = SAMFileReader.getSequenceDictionary((File)new File(path));
                SequenceDictionary asd = SequenceDictionary$.MODULE$.apply(ssd);
                this.$outer.assert(asd.containsRefName("1"));
                SequenceRecord chr1 = (SequenceRecord)asd.apply("1").get();
                SequenceRecord[] sequenceRecordArray = new SequenceRecord[1];
                String x$1 = chr1.name();
                long x$2 = chr1.length();
                Option x$3 = chr1.md5();
                Option<String> x$4 = this.$outer.record$default$3();
                sequenceRecordArray[0] = this.$outer.record(x$1, x$2, x$4, (Option<String>)x$3);
                SequenceDictionary myDict = SequenceDictionary$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])sequenceRecordArray));
                this.$outer.assert(asd.isCompatibleWith(myDict));
                this.$outer.assert(myDict.isCompatibleWith(asd));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Convert from SAM sequence dictionary and back", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String path = ClassLoader.getSystemClassLoader().getResource("dict_with_accession.dict").getFile();
                SAMSequenceDictionary ssd = SAMFileReader.getSequenceDictionary((File)new File(path));
                SequenceDictionary asd = SequenceDictionary$.MODULE$.apply(ssd);
                ssd.assertSameDictionary(SequenceDictionary$.MODULE$.toSAMSequenceDictionary(asd));
            }
        });
        this.test("Can retrieve sequence by name", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SequenceDictionarySuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SequenceRecord rec = this.$outer.record("chr1", this.$outer.record$default$2(), this.$outer.record$default$3(), this.$outer.record$default$4());
                SequenceDictionary asd = SequenceDictionary$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SequenceRecord[]{rec}));
                Option recFromName = asd.apply(rec.name());
                this.$outer.assert(this.$outer.convertToEqualizer(recFromName).$eq$eq$eq((Object)new Some((Object)rec)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("SequenceDictionary's with same single element are equal", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SequenceDictionarySuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SequenceDictionary asd1 = SequenceDictionary$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SequenceRecord[]{this.$outer.record("chr1", this.$outer.record$default$2(), this.$outer.record$default$3(), this.$outer.record$default$4())}));
                SequenceDictionary asd2 = SequenceDictionary$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SequenceRecord[]{this.$outer.record("chr1", this.$outer.record$default$2(), this.$outer.record$default$3(), this.$outer.record$default$4())}));
                this.$outer.assert(this.$outer.convertToEqualizer(asd1).$eq$eq$eq((Object)asd2));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("SequenceDictionary's with same two elements are equals", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SequenceDictionarySuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SequenceDictionary asd1 = SequenceDictionary$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SequenceRecord[]{this.$outer.record("chr1", this.$outer.record$default$2(), this.$outer.record$default$3(), this.$outer.record$default$4()), this.$outer.record("chr2", this.$outer.record$default$2(), this.$outer.record$default$3(), this.$outer.record$default$4())}));
                SequenceDictionary asd2 = SequenceDictionary$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SequenceRecord[]{this.$outer.record("chr1", this.$outer.record$default$2(), this.$outer.record$default$3(), this.$outer.record$default$4()), this.$outer.record("chr2", this.$outer.record$default$2(), this.$outer.record$default$3(), this.$outer.record$default$4())}));
                this.$outer.assert(this.$outer.convertToEqualizer(asd1).$eq$eq$eq((Object)asd2));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("SequenceDictionary's with different elements are unequal", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SequenceDictionarySuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SequenceDictionary asd1 = SequenceDictionary$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SequenceRecord[]{this.$outer.record("chr1", this.$outer.record$default$2(), this.$outer.record$default$3(), this.$outer.record$default$4()), this.$outer.record("chr2", this.$outer.record$default$2(), this.$outer.record$default$3(), this.$outer.record$default$4())}));
                SequenceDictionary asd2 = SequenceDictionary$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SequenceRecord[]{this.$outer.record("chr1", this.$outer.record$default$2(), this.$outer.record$default$3(), this.$outer.record$default$4()), this.$outer.record("chr3", this.$outer.record$default$2(), this.$outer.record$default$3(), this.$outer.record$default$4())}));
                SequenceDictionary sequenceDictionary = asd1;
                this.$outer.assert(sequenceDictionary != null ? !sequenceDictionary.equals(asd2) : asd2 != null);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("SequenceDictionaries with same elements in different order are compatible", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SequenceDictionarySuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SequenceDictionary asd1 = SequenceDictionary$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SequenceRecord[]{this.$outer.record("chr1", this.$outer.record$default$2(), this.$outer.record$default$3(), this.$outer.record$default$4()), this.$outer.record("chr2", this.$outer.record$default$2(), this.$outer.record$default$3(), this.$outer.record$default$4())}));
                SequenceDictionary asd2 = SequenceDictionary$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SequenceRecord[]{this.$outer.record("chr2", this.$outer.record$default$2(), this.$outer.record$default$3(), this.$outer.record$default$4()), this.$outer.record("chr1", this.$outer.record$default$2(), this.$outer.record$default$3(), this.$outer.record$default$4())}));
                this.$outer.assert(asd1.isCompatibleWith(asd2));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("isCompatible tests equality on overlap", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SequenceDictionarySuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SequenceDictionary s1 = SequenceDictionary$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SequenceRecord[]{this.$outer.record("foo", this.$outer.record$default$2(), this.$outer.record$default$3(), this.$outer.record$default$4()), this.$outer.record("bar", this.$outer.record$default$2(), this.$outer.record$default$3(), this.$outer.record$default$4())}));
                SequenceDictionary s2 = SequenceDictionary$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SequenceRecord[]{this.$outer.record("bar", this.$outer.record$default$2(), this.$outer.record$default$3(), this.$outer.record$default$4()), this.$outer.record("quux", this.$outer.record$default$2(), this.$outer.record$default$3(), this.$outer.record$default$4())}));
                SequenceDictionary s3 = SequenceDictionary$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SequenceRecord[]{this.$outer.record("foo", this.$outer.record$default$2(), this.$outer.record$default$3(), this.$outer.record$default$4()), this.$outer.record("bar", this.$outer.record$default$2(), this.$outer.record$default$3(), this.$outer.record$default$4())}));
                SequenceDictionary s4 = SequenceDictionary$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SequenceRecord[]{this.$outer.record("foo", 1001L, this.$outer.record$default$3(), this.$outer.record$default$4())}));
                this.$outer.assert(s1.isCompatibleWith(s2));
                this.$outer.assert(s1.isCompatibleWith(s3));
                this.$outer.assert(!s3.isCompatibleWith(s4));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("The addition + works correctly", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SequenceDictionarySuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SequenceDictionary s1 = SequenceDictionary$.MODULE$.apply();
                SequenceDictionary s2 = SequenceDictionary$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SequenceRecord[]{this.$outer.record("foo", this.$outer.record$default$2(), this.$outer.record$default$3(), this.$outer.record$default$4())}));
                SequenceDictionary s3 = SequenceDictionary$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SequenceRecord[]{this.$outer.record("foo", this.$outer.record$default$2(), this.$outer.record$default$3(), this.$outer.record$default$4()), this.$outer.record("bar", this.$outer.record$default$2(), this.$outer.record$default$3(), this.$outer.record$default$4())}));
                this.$outer.assert(this.$outer.convertToEqualizer(s1.$plus(this.$outer.record("foo", this.$outer.record$default$2(), this.$outer.record$default$3(), this.$outer.record$default$4()))).$eq$eq$eq((Object)s2));
                this.$outer.assert(this.$outer.convertToEqualizer(s2.$plus(this.$outer.record("foo", this.$outer.record$default$2(), this.$outer.record$default$3(), this.$outer.record$default$4()))).$eq$eq$eq((Object)s2));
                this.$outer.assert(this.$outer.convertToEqualizer(s2.$plus(this.$outer.record("bar", this.$outer.record$default$2(), this.$outer.record$default$3(), this.$outer.record$default$4()))).$eq$eq$eq((Object)s3));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("The append operation ++ works correctly", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SequenceDictionarySuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SequenceDictionary s1 = SequenceDictionary$.MODULE$.apply();
                SequenceDictionary s2a = SequenceDictionary$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SequenceRecord[]{this.$outer.record("foo", this.$outer.record$default$2(), this.$outer.record$default$3(), this.$outer.record$default$4())}));
                SequenceDictionary s2b = SequenceDictionary$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SequenceRecord[]{this.$outer.record("bar", this.$outer.record$default$2(), this.$outer.record$default$3(), this.$outer.record$default$4())}));
                SequenceDictionary s3 = SequenceDictionary$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SequenceRecord[]{this.$outer.record("foo", this.$outer.record$default$2(), this.$outer.record$default$3(), this.$outer.record$default$4()), this.$outer.record("bar", this.$outer.record$default$2(), this.$outer.record$default$3(), this.$outer.record$default$4())}));
                this.$outer.assert(this.$outer.convertToEqualizer(s1.$plus$plus(s1)).$eq$eq$eq((Object)s1));
                this.$outer.assert(this.$outer.convertToEqualizer(s1.$plus$plus(s2a)).$eq$eq$eq((Object)s2a));
                this.$outer.assert(this.$outer.convertToEqualizer(s1.$plus$plus(s2b)).$eq$eq$eq((Object)s2b));
                this.$outer.assert(this.$outer.convertToEqualizer(s2a.$plus$plus(s2b)).$eq$eq$eq((Object)s3));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("ContainsRefName works correctly for different string types", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SequenceDictionarySuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SequenceDictionary dict = SequenceDictionary$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SequenceRecord[]{this.$outer.record("chr0", this.$outer.record$default$2(), this.$outer.record$default$3(), this.$outer.record$default$4()), this.$outer.record("chr1", this.$outer.record$default$2(), this.$outer.record$default$3(), this.$outer.record$default$4()), this.$outer.record("chr2", this.$outer.record$default$2(), this.$outer.record$default$3(), this.$outer.record$default$4()), this.$outer.record("chr3", this.$outer.record$default$2(), this.$outer.record$default$3(), this.$outer.record$default$4())}));
                this.$outer.assert(dict.containsRefName("chr0"));
                this.$outer.assert(dict.containsRefName("chr1"));
                this.$outer.assert(dict.containsRefName(ADAMContext$.MODULE$.charSequenceToString((CharSequence)"chr2")));
                this.$outer.assert(dict.containsRefName(ADAMContext$.MODULE$.charSequenceToString((CharSequence)"chr3")));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Apply on name works correctly for different String types", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SequenceDictionarySuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SequenceDictionary dict = SequenceDictionary$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SequenceRecord[]{this.$outer.record("chr0", this.$outer.record$default$2(), this.$outer.record$default$3(), this.$outer.record$default$4()), this.$outer.record("chr1", this.$outer.record$default$2(), this.$outer.record$default$3(), this.$outer.record$default$4()), this.$outer.record("chr2", this.$outer.record$default$2(), this.$outer.record$default$3(), this.$outer.record$default$4()), this.$outer.record("chr3", this.$outer.record$default$2(), this.$outer.record$default$3(), this.$outer.record$default$4())}));
                this.$outer.assert(this.$outer.convertToEqualizer(((SequenceRecord)dict.apply("chr0").get()).name()).$eq$eq$eq((Object)"chr0"));
                this.$outer.assert(this.$outer.convertToEqualizer(((SequenceRecord)dict.apply("chr1").get()).name()).$eq$eq$eq((Object)"chr1"));
                this.$outer.assert(this.$outer.convertToEqualizer(((SequenceRecord)dict.apply(ADAMContext$.MODULE$.charSequenceToString((CharSequence)"chr2")).get()).name()).$eq$eq$eq((Object)"chr2"));
                this.$outer.assert(this.$outer.convertToEqualizer(((SequenceRecord)dict.apply(ADAMContext$.MODULE$.charSequenceToString((CharSequence)"chr3")).get()).name()).$eq$eq$eq((Object)"chr3"));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("convert from sam sequence record and back", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SequenceDictionarySuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SAMSequenceRecord sr = new SAMSequenceRecord("chr0", 1000);
                sr.setAttribute("UR", "http://bigdatagenomics.github.io/chr0");
                SequenceRecord conv = SequenceRecord$.MODULE$.fromSAMSequenceRecord(sr);
                this.$outer.assert(this.$outer.convertToEqualizer(conv.name()).$eq$eq$eq((Object)"chr0"));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)conv.length())).$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)1000L)));
                this.$outer.assert(this.$outer.convertToEqualizer(conv.url().get()).$eq$eq$eq((Object)"http://bigdatagenomics.github.io/chr0"));
                SAMSequenceRecord convSr = conv.toSAMSequenceRecord();
                this.$outer.assert(convSr.isSameSequence(sr));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("convert from sam sequence dictionary and back", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SAMSequenceRecord sr0 = new SAMSequenceRecord("chr0", 1000);
                List srs = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SAMSequenceRecord[]{sr0}));
                SAMSequenceDictionary ssd = new SAMSequenceDictionary(ADAMContext$.MODULE$.listToJavaList(srs));
                SequenceDictionary asd = SequenceDictionary$.MODULE$.fromSAMSequenceDictionary(ssd);
                SAMSequenceDictionary toSSD = asd.toSAMSequenceDictionary();
                toSSD.assertSameDictionary(ssd);
            }
        });
    }
}

