/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.rdd;

import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.log4j.Level;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.bdgenomics.adam.avro.ADAMContig;
import org.bdgenomics.adam.avro.ADAMGenotype;
import org.bdgenomics.adam.avro.ADAMNucleotideContigFragment;
import org.bdgenomics.adam.avro.ADAMPileup;
import org.bdgenomics.adam.avro.ADAMRecord;
import org.bdgenomics.adam.avro.ADAMVariant;
import org.bdgenomics.adam.avro.Base;
import org.bdgenomics.adam.models.ADAMRod;
import org.bdgenomics.adam.models.ADAMVariantContext;
import org.bdgenomics.adam.models.ADAMVariantContext$;
import org.bdgenomics.adam.models.ReferenceRegion;
import org.bdgenomics.adam.models.ReferenceRegion$;
import org.bdgenomics.adam.models.SequenceDictionary;
import org.bdgenomics.adam.models.SequenceRecord;
import org.bdgenomics.adam.rdd.ADAMContext;
import org.bdgenomics.adam.rdd.ADAMContext$;
import org.bdgenomics.adam.rdd.ADAMRDDFunctionsSuite$;
import org.bdgenomics.adam.rdd.ADAMRDDFunctionsSuite$$anonfun$8$;
import org.bdgenomics.adam.rdd.ADAMRecordRDDFunctions;
import org.bdgenomics.adam.rdd.variation.ADAMVariationContext$;
import org.bdgenomics.adam.util.SparkFunSuite;
import org.bdgenomics.adam.util.SparkFunSuite$class;
import org.scalatest.BeforeAndAfter;
import org.scalatest.Distributor;
import org.scalatest.Filter;
import org.scalatest.FunSuite;
import org.scalatest.FunSuiteLike;
import org.scalatest.Reporter;
import org.scalatest.Stopper;
import org.scalatest.Tracker;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Range;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0001u1A!\u0001\u0002\u0001\u0017\t)\u0012\tR!N%\u0012#e)\u001e8di&|gn]*vSR,'BA\u0002\u0005\u0003\r\u0011H\r\u001a\u0006\u0003\u000b\u0019\tA!\u00193b[*\u0011q\u0001C\u0001\u000bE\u0012<WM\\8nS\u000e\u001c(\"A\u0005\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001a!\u0003\u0005\u0002\u000e!5\taB\u0003\u0002\u0010\u0011\u0005I1oY1mCR,7\u000f^\u0005\u0003#9\u0011\u0001BR;o'VLG/\u001a\t\u0003'Yi\u0011\u0001\u0006\u0006\u0003+\u0011\tA!\u001e;jY&\u0011q\u0003\u0006\u0002\u000e'B\f'o\u001b$v]N+\u0018\u000e^3\t\u000be\u0001A\u0011\u0001\u000e\u0002\rqJg.\u001b;?)\u0005Y\u0002C\u0001\u000f\u0001\u001b\u0005\u0011\u0001")
public class ADAMRDDFunctionsSuite
extends FunSuite
implements SparkFunSuite {
    private SparkContext sc;
    private Option<Map<String, Level>> maybeLevels;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    private volatile boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked;

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public Option<Map<String, Level>> maybeLevels() {
        return this.maybeLevels;
    }

    @Override
    public void maybeLevels_$eq(Option<Map<String, Level>> x$1) {
        this.maybeLevels = x$1;
    }

    @Override
    public void setupSparkContext(String sparkName, boolean silenceSpark) {
        SparkFunSuite$class.setupSparkContext(this, sparkName, silenceSpark);
    }

    @Override
    public void teardownSparkContext() {
        SparkFunSuite$class.teardownSparkContext(this);
    }

    @Override
    public void sparkBefore(String beforeName, boolean silenceSpark, Function0<BoxedUnit> body) {
        SparkFunSuite$class.sparkBefore(this, beforeName, silenceSpark, body);
    }

    @Override
    public void sparkAfter(String beforeName, boolean silenceSpark, Function0<BoxedUnit> body) {
        SparkFunSuite$class.sparkAfter(this, beforeName, silenceSpark, body);
    }

    @Override
    public void sparkTest(String name, boolean silenceSpark, Function0<BoxedUnit> body) {
        SparkFunSuite$class.sparkTest(this, name, silenceSpark, body);
    }

    @Override
    public boolean sparkTest$default$2() {
        return SparkFunSuite$class.sparkTest$default$2(this);
    }

    @Override
    public boolean sparkBefore$default$2() {
        return SparkFunSuite$class.sparkBefore$default$2(this);
    }

    @Override
    public boolean setupSparkContext$default$2() {
        return SparkFunSuite$class.setupSparkContext$default$2(this);
    }

    @Override
    public boolean sparkAfter$default$2() {
        return SparkFunSuite$class.sparkAfter$default$2(this);
    }

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    }

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    }

    public boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked() {
        return this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked;
    }

    public void org$scalatest$BeforeAndAfter$$runHasBeenInvoked_$eq(boolean x$1) {
        this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked = x$1;
    }

    public void org$scalatest$BeforeAndAfter$$super$runTest(String testName, Reporter reporter, Stopper stopper, Map configMap, Tracker tracker) {
        FunSuiteLike.class.runTest((FunSuiteLike)this, (String)testName, (Reporter)reporter, (Stopper)stopper, (Map)configMap, (Tracker)tracker);
    }

    public void org$scalatest$BeforeAndAfter$$super$run(Option testName, Reporter reporter, Stopper stopper, Filter filter, Map configMap, Option distributor, Tracker tracker) {
        FunSuiteLike.class.run((FunSuiteLike)this, (Option)testName, (Reporter)reporter, (Stopper)stopper, (Filter)filter, (Map)configMap, (Option)distributor, (Tracker)tracker);
    }

    public void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$beforeFunctionAtomic_$eq(AtomicReference x$1) {
        this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic = x$1;
    }

    public void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$afterFunctionAtomic_$eq(AtomicReference x$1) {
        this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic = x$1;
    }

    public void before(Function0<Object> fun) {
        BeforeAndAfter.class.before((BeforeAndAfter)this, fun);
    }

    public void after(Function0<Object> fun) {
        BeforeAndAfter.class.after((BeforeAndAfter)this, fun);
    }

    public void runTest(String testName, Reporter reporter, Stopper stopper, Map<String, Object> configMap, Tracker tracker) {
        BeforeAndAfter.class.runTest((BeforeAndAfter)this, (String)testName, (Reporter)reporter, (Stopper)stopper, configMap, (Tracker)tracker);
    }

    public void run(Option<String> testName, Reporter reporter, Stopper stopper, Filter filter, Map<String, Object> configMap, Option<Distributor> distributor, Tracker tracker) {
        BeforeAndAfter.class.run((BeforeAndAfter)this, testName, (Reporter)reporter, (Stopper)stopper, (Filter)filter, configMap, distributor, (Tracker)tracker);
    }

    public ADAMRDDFunctionsSuite() {
        BeforeAndAfter.class.$init$((BeforeAndAfter)this);
        SparkFunSuite$class.$init$(this);
        this.sparkTest("can convert pileups to rods, bases at different pos, same reference", this.sparkTest$default$2(), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ADAMRDDFunctionsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ADAMContig contig = ADAMContig.newBuilder().setContigName((CharSequence)"chr0").build();
                ADAMPileup p0 = ADAMPileup.newBuilder().setPosition(Predef$.MODULE$.long2Long(0L)).setContig(contig).setReadBase(Base.A).build();
                ADAMPileup p1 = ADAMPileup.newBuilder().setPosition(Predef$.MODULE$.long2Long(1L)).setContig(contig).setReadBase(Base.C).build();
                SparkContext qual$1 = this.$outer.sc();
                List x$91 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ADAMPileup[]{p0, p1}));
                int x$92 = qual$1.parallelize$default$2();
                RDD pileups = qual$1.parallelize((Seq)x$91, x$92, ClassTag$.MODULE$.apply(ADAMPileup.class));
                RDD rods = ADAMContext$.MODULE$.rddToADAMPileupRDD(pileups).adamPileupsToRods(1);
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)rods.count())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)2)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)rods.filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(ADAMRod x$1) {
                        return x$1.position().pos() == 0L;
                    }
                }).count())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)rods.filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(ADAMRod x$2) {
                        return x$2.position().pos() == 0L;
                    }
                }).flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final List<ADAMPileup> apply(ADAMRod x$3) {
                        return x$3.pileups();
                    }
                }, ClassTag$.MODULE$.apply(ADAMPileup.class)).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(ADAMPileup x$4) {
                        Base base = x$4.getReadBase();
                        return !(base != null ? !base.equals(Base.A) : Base.A != null);
                    }
                }).count())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)rods.filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(ADAMRod x$5) {
                        return x$5.position().pos() == 1L;
                    }
                }).count())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)rods.filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(ADAMRod x$6) {
                        return x$6.position().pos() == 1L;
                    }
                }).flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final List<ADAMPileup> apply(ADAMRod x$7) {
                        return x$7.pileups();
                    }
                }, ClassTag$.MODULE$.apply(ADAMPileup.class)).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(ADAMPileup x$8) {
                        Base base = x$8.getReadBase();
                        return !(base != null ? !base.equals(Base.C) : Base.C != null);
                    }
                }).count())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.sparkTest("can convert pileups to rods, bases at same pos, different reference", this.sparkTest$default$2(), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ADAMRDDFunctionsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ADAMContig contig = ADAMContig.newBuilder().setContigName((CharSequence)"chr0").build();
                ADAMContig contig1 = ADAMContig.newBuilder().setContigName((CharSequence)"chr1").build();
                ADAMPileup p0 = ADAMPileup.newBuilder().setPosition(Predef$.MODULE$.long2Long(0L)).setContig(contig).setReadBase(Base.A).build();
                ADAMPileup p1 = ADAMPileup.newBuilder().setPosition(Predef$.MODULE$.long2Long(0L)).setContig(contig1).setReadBase(Base.C).build();
                SparkContext qual$2 = this.$outer.sc();
                List x$93 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ADAMPileup[]{p0, p1}));
                int x$94 = qual$2.parallelize$default$2();
                RDD pileups = qual$2.parallelize((Seq)x$93, x$94, ClassTag$.MODULE$.apply(ADAMPileup.class));
                RDD rods = ADAMContext$.MODULE$.rddToADAMPileupRDD(pileups).adamPileupsToRods(1);
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)rods.count())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)2)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)rods.filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(ADAMRod x$9) {
                        String string = x$9.position().referenceName();
                        return !(string != null ? !string.equals("chr0") : "chr0" != null);
                    }
                }).count())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)rods.filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(ADAMRod x$10) {
                        String string = x$10.position().referenceName();
                        return !(string != null ? !string.equals("chr0") : "chr0" != null);
                    }
                }).flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final List<ADAMPileup> apply(ADAMRod x$11) {
                        return x$11.pileups();
                    }
                }, ClassTag$.MODULE$.apply(ADAMPileup.class)).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(ADAMPileup x$12) {
                        Base base = x$12.getReadBase();
                        return !(base != null ? !base.equals(Base.A) : Base.A != null);
                    }
                }).count())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)rods.filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(ADAMRod x$13) {
                        String string = x$13.position().referenceName();
                        return !(string != null ? !string.equals("chr1") : "chr1" != null);
                    }
                }).count())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)rods.filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(ADAMRod x$14) {
                        String string = x$14.position().referenceName();
                        return !(string != null ? !string.equals("chr1") : "chr1" != null);
                    }
                }).flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final List<ADAMPileup> apply(ADAMRod x$15) {
                        return x$15.pileups();
                    }
                }, ClassTag$.MODULE$.apply(ADAMPileup.class)).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(ADAMPileup x$16) {
                        Base base = x$16.getReadBase();
                        return !(base != null ? !base.equals(Base.C) : Base.C != null);
                    }
                }).count())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.sparkTest("can convert pileups to rods, bases at same pos", this.sparkTest$default$2(), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ADAMRDDFunctionsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ADAMContig contig = ADAMContig.newBuilder().setContigName((CharSequence)"chr0").build();
                ADAMPileup p0 = ADAMPileup.newBuilder().setPosition(Predef$.MODULE$.long2Long(1L)).setContig(contig).setReadBase(Base.A).build();
                ADAMPileup p1 = ADAMPileup.newBuilder().setPosition(Predef$.MODULE$.long2Long(1L)).setContig(contig).setReadBase(Base.C).build();
                SparkContext qual$3 = this.$outer.sc();
                List x$95 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ADAMPileup[]{p0, p1}));
                int x$96 = qual$3.parallelize$default$2();
                RDD pileups = qual$3.parallelize((Seq)x$95, x$96, ClassTag$.MODULE$.apply(ADAMPileup.class));
                RDD rods = ADAMContext$.MODULE$.rddToADAMPileupRDD(pileups).adamPileupsToRods(1);
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)rods.count())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)rods.filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(ADAMRod x$17) {
                        return x$17.position().pos() == 1L;
                    }
                }).count())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)rods.filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(ADAMRod x$18) {
                        return x$18.position().pos() == 1L;
                    }
                }).flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final List<ADAMPileup> apply(ADAMRod x$19) {
                        return x$19.pileups();
                    }
                }, ClassTag$.MODULE$.apply(ADAMPileup.class)).count())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)2)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)rods.filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(ADAMRod x$20) {
                        return x$20.position().pos() == 1L;
                    }
                }).flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final List<ADAMPileup> apply(ADAMRod x$21) {
                        return x$21.pileups();
                    }
                }, ClassTag$.MODULE$.apply(ADAMPileup.class)).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(ADAMPileup x$22) {
                        Base base = x$22.getReadBase();
                        return !(base != null ? !base.equals(Base.A) : Base.A != null);
                    }
                }).count())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)rods.filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(ADAMRod x$23) {
                        return x$23.position().pos() == 1L;
                    }
                }).flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final List<ADAMPileup> apply(ADAMRod x$24) {
                        return x$24.pileups();
                    }
                }, ClassTag$.MODULE$.apply(ADAMPileup.class)).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(ADAMPileup x$25) {
                        Base base = x$25.getReadBase();
                        return !(base != null ? !base.equals(Base.C) : Base.C != null);
                    }
                }).count())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.sparkTest("can convert pileups to rods, bases at same pos, split by different sample", this.sparkTest$default$2(), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ADAMRDDFunctionsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ADAMContig contig = ADAMContig.newBuilder().setContigName((CharSequence)"chr0").build();
                ADAMPileup p0 = ADAMPileup.newBuilder().setPosition(Predef$.MODULE$.long2Long(1L)).setContig(contig).setReadBase(Base.A).setRecordGroupSample((CharSequence)"0").build();
                ADAMPileup p1 = ADAMPileup.newBuilder().setPosition(Predef$.MODULE$.long2Long(1L)).setContig(contig).setReadBase(Base.C).setRecordGroupSample((CharSequence)"1").build();
                SparkContext qual$4 = this.$outer.sc();
                List x$97 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ADAMPileup[]{p0, p1}));
                int x$98 = qual$4.parallelize$default$2();
                RDD pileups = qual$4.parallelize((Seq)x$97, x$98, ClassTag$.MODULE$.apply(ADAMPileup.class));
                RDD rods = ADAMContext$.MODULE$.rddToADAMPileupRDD(pileups).adamPileupsToRods(1);
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)rods.count())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)rods.filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(ADAMRod x$26) {
                        return x$26.position().pos() == 1L;
                    }
                }).count())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)rods.filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(ADAMRod x$27) {
                        return x$27.position().pos() == 1L;
                    }
                }).flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final List<ADAMPileup> apply(ADAMRod x$28) {
                        return x$28.pileups();
                    }
                }, ClassTag$.MODULE$.apply(ADAMPileup.class)).count())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)2)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)rods.filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(ADAMRod x$29) {
                        return x$29.position().pos() == 1L;
                    }
                }).flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final List<ADAMPileup> apply(ADAMRod x$30) {
                        return x$30.pileups();
                    }
                }, ClassTag$.MODULE$.apply(ADAMPileup.class)).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(ADAMPileup x$31) {
                        Base base = x$31.getReadBase();
                        return !(base != null ? !base.equals(Base.A) : Base.A != null);
                    }
                }).count())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)rods.filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(ADAMRod x$32) {
                        return x$32.position().pos() == 1L;
                    }
                }).flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final List<ADAMPileup> apply(ADAMRod x$33) {
                        return x$33.pileups();
                    }
                }, ClassTag$.MODULE$.apply(ADAMPileup.class)).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(ADAMPileup x$34) {
                        Base base = x$34.getReadBase();
                        return !(base != null ? !base.equals(Base.C) : Base.C != null);
                    }
                }).count())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)rods.filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(ADAMRod x$35) {
                        return x$35.isSingleSample();
                    }
                }).count())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)0)));
                RDD split = ADAMContext$.MODULE$.rddToADAMRodRDD(rods).adamSplitRodsBySamples();
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)split.count())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)2)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)split.filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(ADAMRod x$36) {
                        return x$36.position().pos() == 1L;
                    }
                }).count())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)2)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)split.filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(ADAMRod x$37) {
                        return x$37.isSingleSample();
                    }
                }).count())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)2)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.sparkTest("can convert pileups to rods, bases at same pos, split by same sample", this.sparkTest$default$2(), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ADAMRDDFunctionsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ADAMContig contig = ADAMContig.newBuilder().setContigName((CharSequence)"chr0").build();
                ADAMPileup p0 = ADAMPileup.newBuilder().setPosition(Predef$.MODULE$.long2Long(1L)).setContig(contig).setReadBase(Base.A).setRecordGroupSample((CharSequence)"1").build();
                ADAMPileup p1 = ADAMPileup.newBuilder().setPosition(Predef$.MODULE$.long2Long(1L)).setContig(contig).setReadBase(Base.C).setRecordGroupSample((CharSequence)"1").build();
                SparkContext qual$5 = this.$outer.sc();
                List x$99 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ADAMPileup[]{p0, p1}));
                int x$100 = qual$5.parallelize$default$2();
                RDD pileups = qual$5.parallelize((Seq)x$99, x$100, ClassTag$.MODULE$.apply(ADAMPileup.class));
                RDD rods = ADAMContext$.MODULE$.rddToADAMPileupRDD(pileups).adamPileupsToRods(1);
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)rods.count())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)rods.filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(ADAMRod x$38) {
                        return x$38.position().pos() == 1L;
                    }
                }).count())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)rods.filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(ADAMRod x$39) {
                        return x$39.position().pos() == 1L;
                    }
                }).flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final List<ADAMPileup> apply(ADAMRod x$40) {
                        return x$40.pileups();
                    }
                }, ClassTag$.MODULE$.apply(ADAMPileup.class)).count())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)2)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)rods.filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(ADAMRod x$41) {
                        return x$41.position().pos() == 1L;
                    }
                }).flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final List<ADAMPileup> apply(ADAMRod x$42) {
                        return x$42.pileups();
                    }
                }, ClassTag$.MODULE$.apply(ADAMPileup.class)).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(ADAMPileup x$43) {
                        Base base = x$43.getReadBase();
                        return !(base != null ? !base.equals(Base.A) : Base.A != null);
                    }
                }).count())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)rods.filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(ADAMRod x$44) {
                        return x$44.position().pos() == 1L;
                    }
                }).flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final List<ADAMPileup> apply(ADAMRod x$45) {
                        return x$45.pileups();
                    }
                }, ClassTag$.MODULE$.apply(ADAMPileup.class)).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(ADAMPileup x$46) {
                        Base base = x$46.getReadBase();
                        return !(base != null ? !base.equals(Base.C) : Base.C != null);
                    }
                }).count())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)rods.filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(ADAMRod x$47) {
                        return x$47.isSingleSample();
                    }
                }).count())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1)));
                RDD split = ADAMContext$.MODULE$.rddToADAMRodRDD(rods).adamSplitRodsBySamples();
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)split.count())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)split.filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(ADAMRod x$48) {
                        return x$48.isSingleSample();
                    }
                }).count())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.sparkTest("check coverage, bases at different pos", this.sparkTest$default$2(), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ADAMRDDFunctionsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                int x$102;
                ADAMContig contig = ADAMContig.newBuilder().setContigName((CharSequence)"chr0").build();
                ADAMPileup p0 = ADAMPileup.newBuilder().setPosition(Predef$.MODULE$.long2Long(0L)).setContig(contig).setReadBase(Base.A).build();
                ADAMPileup p1 = ADAMPileup.newBuilder().setPosition(Predef$.MODULE$.long2Long(1L)).setContig(contig).setReadBase(Base.C).build();
                SparkContext qual$6 = this.$outer.sc();
                List x$101 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ADAMPileup[]{p0, p1}));
                RDD pileups = qual$6.parallelize((Seq)x$101, x$102 = qual$6.parallelize$default$2(), ClassTag$.MODULE$.apply(ADAMPileup.class));
                double coverage = ADAMContext$.MODULE$.rddToADAMRodRDD(ADAMContext$.MODULE$.rddToADAMPileupRDD(pileups).adamPileupsToRods(1)).adamRodCoverage();
                this.$outer.assert(coverage > 0.99 && coverage < 1.01);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.sparkTest("check coverage, bases at same pos", this.sparkTest$default$2(), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ADAMRDDFunctionsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                int x$104;
                ADAMContig contig = ADAMContig.newBuilder().setContigName((CharSequence)"chr0").build();
                ADAMPileup p0 = ADAMPileup.newBuilder().setPosition(Predef$.MODULE$.long2Long(1L)).setContig(contig).setReadBase(Base.A).build();
                ADAMPileup p1 = ADAMPileup.newBuilder().setPosition(Predef$.MODULE$.long2Long(1L)).setContig(contig).setReadBase(Base.C).build();
                SparkContext qual$7 = this.$outer.sc();
                List x$103 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ADAMPileup[]{p0, p1}));
                RDD pileups = qual$7.parallelize((Seq)x$103, x$104 = qual$7.parallelize$default$2(), ClassTag$.MODULE$.apply(ADAMPileup.class));
                double coverage = ADAMContext$.MODULE$.rddToADAMRodRDD(ADAMContext$.MODULE$.rddToADAMPileupRDD(pileups).adamPileupsToRods(1)).adamRodCoverage();
                this.$outer.assert(coverage > 1.99 && coverage < 2.01);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.sparkTest("sorting reads", this.sparkTest$default$2(), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ADAMRDDFunctionsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                int x$106;
                Random random = new Random("sorting".hashCode());
                Predef$ predef$ = Predef$.MODULE$;
                IndexedSeq reads = (IndexedSeq)RichInt$.MODULE$.until$extension0(0, 1000).map((Function1)new Serializable(this, random, 1000){
                    public static final long serialVersionUID = 0L;
                    private final Random random$1;
                    private final int numReadsToCreate$1;

                    public final ADAMRecord apply(int i) {
                        BoxedUnit boxedUnit;
                        boolean mapped = this.random$1.nextBoolean();
                        ADAMRecord.Builder builder = ADAMRecord.newBuilder().setReadMapped(Predef$.MODULE$.boolean2Boolean(mapped));
                        if (mapped) {
                            ADAMContig contig = ADAMContig.newBuilder().setContigName((CharSequence)((Object)BoxesRunTime.boxToInteger((int)this.random$1.nextInt(this.numReadsToCreate$1 / 10))).toString()).build();
                            boxedUnit = builder.setContig(contig).setStart(Predef$.MODULE$.long2Long((long)this.random$1.nextInt(1000000)));
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        return builder.build();
                    }
                    {
                        this.random$1 = random$1;
                        this.numReadsToCreate$1 = numReadsToCreate$1;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
                SparkContext qual$8 = this.$outer.sc();
                RDD rdd = qual$8.parallelize((Seq)reads, x$106 = qual$8.parallelize$default$2(), ClassTag$.MODULE$.apply(ADAMRecord.class));
                Tuple2[] sortedReads = (Tuple2[])Predef$.MODULE$.refArrayOps((Object[])ADAMContext$.MODULE$.rddToADAMRecordRDD(rdd).adamSortReadsByReferencePosition().collect()).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
                Tuple2 tuple2 = Predef$.MODULE$.refArrayOps((Object[])sortedReads).partition((Function1)new $anonfun$8$$anonfun$25(this));
                if (tuple2 != null) {
                    Tuple2 tuple22 = new Tuple2(tuple2._1(), tuple2._2());
                    Tuple2[] mapped = (Tuple2[])tuple22._1();
                    Tuple2[] unmapped = (Tuple2[])tuple22._2();
                    this.$outer.assert(Predef$.MODULE$.refArrayOps((Object[])unmapped).forall((Function1)new Serializable(this, mapped){
                        public static final long serialVersionUID = 0L;
                        private final Tuple2[] mapped$1;

                        public final boolean apply(Tuple2<ADAMRecord, Object> p) {
                            return p._2$mcI$sp() > ((Tuple2[])Predef$.MODULE$.refArrayOps((Object[])this.mapped$1).takeRight(1))[0]._2$mcI$sp();
                        }
                        {
                            this.mapped$1 = mapped$1;
                        }
                    }));
                    Tuple2[] expectedSortedReads = (Tuple2[])Predef$.MODULE$.refArrayOps((Object[])mapped).sortWith((Function2)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(Tuple2<ADAMRecord, Object> a, Tuple2<ADAMRecord, Object> b) {
                            String string = ((Object)((ADAMRecord)a._1()).getContig().getContigName()).toString();
                            Predef$ predef$ = Predef$.MODULE$;
                            return new StringOps(string).$less((Object)((Object)((ADAMRecord)b._1()).getContig().getContigName()).toString()) && Predef$.MODULE$.Long2long(((ADAMRecord)a._1()).getStart()) < Predef$.MODULE$.Long2long(((ADAMRecord)b._1()).getStart());
                        }
                    });
                    this.$outer.assert(this.$outer.convertToEqualizer(expectedSortedReads).$eq$eq$eq((Object)mapped));
                    return;
                }
                throw new MatchError((Object)tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.sparkTest("convert an RDD of reads into rods", this.sparkTest$default$2(), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ADAMRDDFunctionsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ADAMContig contig = ADAMContig.newBuilder().setContigName((CharSequence)"chr0").build();
                ADAMRecord r0 = ADAMRecord.newBuilder().setStart(Predef$.MODULE$.long2Long(1L)).setContig(contig).setSequence((CharSequence)"ACG").setMapq(Predef$.MODULE$.int2Integer(30)).setCigar((CharSequence)"3M").setMismatchingPositions((CharSequence)"3").setReadNegativeStrand(Predef$.MODULE$.boolean2Boolean(false)).setReadMapped(Predef$.MODULE$.boolean2Boolean(true)).setPrimaryAlignment(Predef$.MODULE$.boolean2Boolean(true)).setQual((CharSequence)"!#$").build();
                ADAMRecord r1 = ADAMRecord.newBuilder().setStart(Predef$.MODULE$.long2Long(2L)).setContig(contig).setSequence((CharSequence)"CG").setMapq(Predef$.MODULE$.int2Integer(40)).setCigar((CharSequence)"2M").setMismatchingPositions((CharSequence)"2").setReadNegativeStrand(Predef$.MODULE$.boolean2Boolean(false)).setReadMapped(Predef$.MODULE$.boolean2Boolean(true)).setPrimaryAlignment(Predef$.MODULE$.boolean2Boolean(true)).setQual((CharSequence)"%&").build();
                ADAMRecord r2 = ADAMRecord.newBuilder().setStart(Predef$.MODULE$.long2Long(3L)).setContig(contig).setSequence((CharSequence)"G").setMapq(Predef$.MODULE$.int2Integer(50)).setCigar((CharSequence)"1M").setMismatchingPositions((CharSequence)"1").setReadNegativeStrand(Predef$.MODULE$.boolean2Boolean(false)).setReadMapped(Predef$.MODULE$.boolean2Boolean(true)).setPrimaryAlignment(Predef$.MODULE$.boolean2Boolean(true)).setQual((CharSequence)"%").build();
                SparkContext qual$9 = this.$outer.sc();
                List x$107 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ADAMRecord[]{r0, r1, r2}));
                int x$108 = qual$9.parallelize$default$2();
                RDD reads = qual$9.parallelize((Seq)x$107, x$108, ClassTag$.MODULE$.apply(ADAMRecord.class));
                ADAMRecordRDDFunctions qual$10 = ADAMContext$.MODULE$.rddToADAMRecordRDD(reads);
                int x$109 = qual$10.adamRecords2Rods$default$1();
                boolean x$110 = qual$10.adamRecords2Rods$default$2();
                RDD rods = qual$10.adamRecords2Rods(x$109, x$110);
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)rods.count())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)3)));
                this.$outer.assert(Predef$.MODULE$.refArrayOps((Object[])rods.collect()).forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(ADAMRod x$51) {
                        String string = x$51.position().referenceName();
                        return !(string != null ? !string.equals("chr0") : "chr0" != null);
                    }
                }));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)rods.filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(ADAMRod x$52) {
                        return x$52.position().pos() == 1L;
                    }
                }).count())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)((ADAMRod)rods.filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(ADAMRod x$53) {
                        return x$53.position().pos() == 1L;
                    }
                }).first()).pileups().length())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1)));
                this.$outer.assert(((ADAMRod)rods.filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(ADAMRod x$54) {
                        return x$54.position().pos() == 1L;
                    }
                }).first()).pileups().forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(ADAMPileup x$55) {
                        Base base = x$55.getReadBase();
                        return !(base != null ? !base.equals(Base.A) : Base.A != null);
                    }
                }));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)rods.filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(ADAMRod x$56) {
                        return x$56.position().pos() == 2L;
                    }
                }).count())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)((ADAMRod)rods.filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(ADAMRod x$57) {
                        return x$57.position().pos() == 2L;
                    }
                }).first()).pileups().length())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)2)));
                this.$outer.assert(((ADAMRod)rods.filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(ADAMRod x$58) {
                        return x$58.position().pos() == 2L;
                    }
                }).first()).pileups().forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(ADAMPileup x$59) {
                        Base base = x$59.getReadBase();
                        return !(base != null ? !base.equals(Base.C) : Base.C != null);
                    }
                }));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)rods.filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(ADAMRod x$60) {
                        return x$60.position().pos() == 3L;
                    }
                }).count())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)((ADAMRod)rods.filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(ADAMRod x$61) {
                        return x$61.position().pos() == 3L;
                    }
                }).first()).pileups().length())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)3)));
                this.$outer.assert(((ADAMRod)rods.filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(ADAMRod x$62) {
                        return x$62.position().pos() == 3L;
                    }
                }).first()).pileups().forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(ADAMPileup x$63) {
                        Base base = x$63.getReadBase();
                        return !(base != null ? !base.equals(Base.G) : Base.G != null);
                    }
                }));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.sparkTest("convert an RDD of reads into rods, different references", this.sparkTest$default$2(), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ADAMRDDFunctionsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ADAMContig contig0 = ADAMContig.newBuilder().setContigName((CharSequence)"chr0").build();
                ADAMContig contig1 = ADAMContig.newBuilder().setContigName((CharSequence)"chr1").build();
                ADAMRecord r0 = ADAMRecord.newBuilder().setStart(Predef$.MODULE$.long2Long(1L)).setContig(contig0).setSequence((CharSequence)"AC").setMapq(Predef$.MODULE$.int2Integer(30)).setCigar((CharSequence)"2M").setMismatchingPositions((CharSequence)"2").setReadNegativeStrand(Predef$.MODULE$.boolean2Boolean(false)).setReadMapped(Predef$.MODULE$.boolean2Boolean(true)).setPrimaryAlignment(Predef$.MODULE$.boolean2Boolean(true)).setQual((CharSequence)"!#$").build();
                ADAMRecord r1 = ADAMRecord.newBuilder().setStart(Predef$.MODULE$.long2Long(2L)).setContig(contig0).setSequence((CharSequence)"C").setMapq(Predef$.MODULE$.int2Integer(40)).setCigar((CharSequence)"1M").setMismatchingPositions((CharSequence)"1").setReadNegativeStrand(Predef$.MODULE$.boolean2Boolean(false)).setReadMapped(Predef$.MODULE$.boolean2Boolean(true)).setPrimaryAlignment(Predef$.MODULE$.boolean2Boolean(true)).setQual((CharSequence)"%&").build();
                ADAMRecord r2 = ADAMRecord.newBuilder().setStart(Predef$.MODULE$.long2Long(2L)).setContig(contig1).setSequence((CharSequence)"G").setMapq(Predef$.MODULE$.int2Integer(50)).setCigar((CharSequence)"1M").setMismatchingPositions((CharSequence)"1").setReadNegativeStrand(Predef$.MODULE$.boolean2Boolean(false)).setReadMapped(Predef$.MODULE$.boolean2Boolean(true)).setPrimaryAlignment(Predef$.MODULE$.boolean2Boolean(true)).setQual((CharSequence)"%").build();
                SparkContext qual$11 = this.$outer.sc();
                List x$111 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ADAMRecord[]{r0, r1, r2}));
                int x$112 = qual$11.parallelize$default$2();
                RDD reads = qual$11.parallelize((Seq)x$111, x$112, ClassTag$.MODULE$.apply(ADAMRecord.class));
                ADAMRecordRDDFunctions qual$12 = ADAMContext$.MODULE$.rddToADAMRecordRDD(reads);
                int x$113 = qual$12.adamRecords2Rods$default$1();
                boolean x$114 = qual$12.adamRecords2Rods$default$2();
                RDD rods = qual$12.adamRecords2Rods(x$113, x$114);
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)rods.count())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)3)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)rods.filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(ADAMRod x$64) {
                        String string = x$64.position().referenceName();
                        return !(string != null ? !string.equals("chr0") : "chr0" != null);
                    }
                }).count())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)2)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)rods.filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(ADAMRod x$65) {
                        String string = x$65.position().referenceName();
                        return !(string != null ? !string.equals("chr1") : "chr1" != null);
                    }
                }).count())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)rods.filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(ADAMRod x$66) {
                        return x$66.position().pos() == 1L;
                    }
                }).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(ADAMRod x$67) {
                        String string = x$67.position().referenceName();
                        return !(string != null ? !string.equals("chr0") : "chr0" != null);
                    }
                }).count())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)((ADAMRod)rods.filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(ADAMRod x$68) {
                        return x$68.position().pos() == 1L;
                    }
                }).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(ADAMRod x$69) {
                        String string = x$69.position().referenceName();
                        return !(string != null ? !string.equals("chr0") : "chr0" != null);
                    }
                }).first()).pileups().length())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1)));
                this.$outer.assert(((ADAMRod)rods.filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(ADAMRod x$70) {
                        return x$70.position().pos() == 1L;
                    }
                }).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(ADAMRod x$71) {
                        String string = x$71.position().referenceName();
                        return !(string != null ? !string.equals("chr0") : "chr0" != null);
                    }
                }).first()).pileups().forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(ADAMPileup x$72) {
                        Base base = x$72.getReadBase();
                        return !(base != null ? !base.equals(Base.A) : Base.A != null);
                    }
                }));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)rods.filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(ADAMRod x$73) {
                        return x$73.position().pos() == 2L;
                    }
                }).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(ADAMRod x$74) {
                        String string = x$74.position().referenceName();
                        return !(string != null ? !string.equals("chr0") : "chr0" != null);
                    }
                }).count())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)((ADAMRod)rods.filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(ADAMRod x$75) {
                        return x$75.position().pos() == 2L;
                    }
                }).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(ADAMRod x$76) {
                        String string = x$76.position().referenceName();
                        return !(string != null ? !string.equals("chr0") : "chr0" != null);
                    }
                }).first()).pileups().length())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)2)));
                this.$outer.assert(((ADAMRod)rods.filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(ADAMRod x$77) {
                        return x$77.position().pos() == 2L;
                    }
                }).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(ADAMRod x$78) {
                        String string = x$78.position().referenceName();
                        return !(string != null ? !string.equals("chr0") : "chr0" != null);
                    }
                }).first()).pileups().forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(ADAMPileup x$79) {
                        Base base = x$79.getReadBase();
                        return !(base != null ? !base.equals(Base.C) : Base.C != null);
                    }
                }));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)rods.filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(ADAMRod x$80) {
                        return x$80.position().pos() == 2L;
                    }
                }).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(ADAMRod x$81) {
                        String string = x$81.position().referenceName();
                        return !(string != null ? !string.equals("chr1") : "chr1" != null);
                    }
                }).count())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)((ADAMRod)rods.filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(ADAMRod x$82) {
                        return x$82.position().pos() == 2L;
                    }
                }).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(ADAMRod x$83) {
                        String string = x$83.position().referenceName();
                        return !(string != null ? !string.equals("chr1") : "chr1" != null);
                    }
                }).first()).pileups().length())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1)));
                this.$outer.assert(((ADAMRod)rods.filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(ADAMRod x$84) {
                        return x$84.position().pos() == 2L;
                    }
                }).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(ADAMRod x$85) {
                        String string = x$85.position().referenceName();
                        return !(string != null ? !string.equals("chr1") : "chr1" != null);
                    }
                }).first()).pileups().forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(ADAMPileup x$86) {
                        Base base = x$86.getReadBase();
                        return !(base != null ? !base.equals(Base.G) : Base.G != null);
                    }
                }));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.sparkTest("generate sequence dict from fasta", this.sparkTest$default$2(), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ADAMRDDFunctionsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ADAMContig contig0 = ADAMContig.newBuilder().setContigName((CharSequence)"chr0").setContigLength(Predef$.MODULE$.long2Long(1000L)).setReferenceURL((CharSequence)"http://bigdatagenomics.github.io/chr0.fa").build();
                ADAMContig contig1 = ADAMContig.newBuilder().setContigName((CharSequence)"chr1").setContigLength(Predef$.MODULE$.long2Long(900L)).build();
                ADAMNucleotideContigFragment ctg0 = ADAMNucleotideContigFragment.newBuilder().setContig(contig0).build();
                ADAMNucleotideContigFragment ctg1 = ADAMNucleotideContigFragment.newBuilder().setContig(contig1).build();
                SparkContext qual$13 = this.$outer.sc();
                List x$115 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ADAMNucleotideContigFragment[]{ctg0, ctg1}));
                int x$116 = qual$13.parallelize$default$2();
                RDD rdd = qual$13.parallelize((Seq)x$115, x$116, ClassTag$.MODULE$.apply(ADAMNucleotideContigFragment.class));
                SequenceDictionary dict = ADAMContext$.MODULE$.rddToADAMRDD(rdd).adamGetSequenceDictionary();
                this.$outer.assert(dict.containsRefName("chr0"));
                SequenceRecord chr0 = (SequenceRecord)dict.apply("chr0").get();
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)chr0.length())).$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)1000L)));
                Option option = chr0.url();
                Some some = new Some((Object)"http://bigdatagenomics.github.io/chr0.fa");
                this.$outer.assert(!(option != null ? !option.equals(some) : some != null));
                this.$outer.assert(dict.containsRefName("chr1"));
                SequenceRecord chr1 = (SequenceRecord)dict.apply("chr1").get();
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)chr1.length())).$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)900L)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.sparkTest("recover samples from variant context", this.sparkTest$default$2(), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ADAMRDDFunctionsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ADAMVariant variant0 = ADAMVariant.newBuilder().setPosition(Predef$.MODULE$.long2Long(0L)).setVariantAllele((CharSequence)"A").setReferenceAllele((CharSequence)"T").setContig(ADAMContig.newBuilder().setContigName((CharSequence)"chr0").build()).build();
                ADAMVariant variant1 = ADAMVariant.newBuilder().setPosition(Predef$.MODULE$.long2Long(0L)).setVariantAllele((CharSequence)"C").setReferenceAllele((CharSequence)"T").setContig(ADAMContig.newBuilder().setContigName((CharSequence)"chr0").build()).build();
                ADAMGenotype genotype0 = ADAMGenotype.newBuilder().setVariant(variant0).setSampleId((CharSequence)"me").build();
                ADAMGenotype genotype1 = ADAMGenotype.newBuilder().setVariant(variant1).setSampleId((CharSequence)"you").build();
                ADAMVariantContext vc = ADAMVariantContext$.MODULE$.buildFromGenotypes((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ADAMGenotype[]{genotype0, genotype1})));
                SparkContext qual$14 = this.$outer.sc();
                List x$117 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ADAMVariantContext[]{vc}));
                int x$118 = qual$14.parallelize$default$2();
                List samples = ADAMVariationContext$.MODULE$.rddToADAMVariantContextRDD(qual$14.parallelize((Seq)x$117, x$118, ClassTag$.MODULE$.apply(ADAMVariantContext.class))).adamGetCallsetSamples();
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)((LinearSeqOptimized)samples.filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(String x$87) {
                        String string = x$87;
                        return !(string != null ? !string.equals("you") : "you" != null);
                    }
                })).length())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)((LinearSeqOptimized)samples.filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(String x$88) {
                        String string = x$88;
                        return !(string != null ? !string.equals("me") : "me" != null);
                    }
                })).length())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.sparkTest("characterizeTags counts integer tag values correctly", this.sparkTest$default$2(), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ADAMRDDFunctionsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Tuple2[] tuple2Array = new Tuple2[3];
                Predef$ predef$ = Predef$.MODULE$;
                Long l = BoxesRunTime.boxToLong((long)10L);
                Predef.ArrowAssoc$ arrowAssoc$ = Predef.ArrowAssoc$.MODULE$;
                tuple2Array[0] = new Tuple2((Object)"XT", (Object)l);
                Predef$ predef$2 = Predef$.MODULE$;
                Long l2 = BoxesRunTime.boxToLong((long)9L);
                Predef.ArrowAssoc$ arrowAssoc$2 = Predef.ArrowAssoc$.MODULE$;
                tuple2Array[1] = new Tuple2((Object)"XU", (Object)l2);
                Predef$ predef$3 = Predef$.MODULE$;
                Long l3 = BoxesRunTime.boxToLong((long)8L);
                Predef.ArrowAssoc$ arrowAssoc$3 = Predef.ArrowAssoc$.MODULE$;
                tuple2Array[2] = new Tuple2((Object)"XV", (Object)l3);
                Map tagCounts = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array));
                Iterable readItr = (Iterable)tagCounts.withFilter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Tuple2<String, Object> check$ifrefutable$1) {
                        boolean bl = check$ifrefutable$1 != null;
                        return bl;
                    }
                }).flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final IndexedSeq<ADAMRecord> apply(Tuple2<String, Object> x$89) {
                        if (x$89 != null) {
                            Predef$ predef$ = Predef$.MODULE$;
                            return (IndexedSeq)RichInt$.MODULE$.until$extension0(0, (int)x$89._2$mcJ$sp()).map((Function1)new Serializable(this, x$89){
                                public static final long serialVersionUID = 0L;
                                private final Tuple2 x1$1;

                                public final ADAMRecord apply(int i) {
                                    Predef$ predef$ = Predef$.MODULE$;
                                    return ADAMRecord.newBuilder().setAttributes((CharSequence)new StringOps("%s:i:%d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.x1$1._1(), BoxesRunTime.boxToInteger((int)i)}))).build();
                                }
                                {
                                    this.x1$1 = x1$1;
                                }
                            }, IndexedSeq$.MODULE$.canBuildFrom());
                        }
                        throw new MatchError(x$89);
                    }
                }, Iterable$.MODULE$.canBuildFrom());
                SparkContext qual$15 = this.$outer.sc();
                Seq x$119 = readItr.toSeq();
                int x$120 = qual$15.parallelize$default$2();
                RDD reads = qual$15.parallelize(x$119, x$120, ClassTag$.MODULE$.apply(ADAMRecord.class));
                Map mapCounts = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])ADAMContext$.MODULE$.rddToADAMRecordRDD(reads).adamCharacterizeTags().collect()));
                this.$outer.assert(this.$outer.convertToEqualizer(mapCounts).$eq$eq$eq((Object)tagCounts));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.sparkTest("withTag returns only those records which have the appropriate tag", this.sparkTest$default$2(), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ADAMRDDFunctionsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ADAMRecord r1 = ADAMRecord.newBuilder().setAttributes((CharSequence)"XX:i:3").build();
                ADAMRecord r2 = ADAMRecord.newBuilder().setAttributes((CharSequence)"XX:i:4\tYY:i:10").build();
                ADAMRecord r3 = ADAMRecord.newBuilder().setAttributes((CharSequence)"YY:i:20").build();
                SparkContext qual$16 = this.$outer.sc();
                Seq x$121 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ADAMRecord[]{r1, r2, r3}));
                int x$122 = qual$16.parallelize$default$2();
                RDD rdd = qual$16.parallelize(x$121, x$122, ClassTag$.MODULE$.apply(ADAMRecord.class));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)rdd.count())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)3)));
                RDD rddXX = ADAMContext$.MODULE$.rddToADAMRecordRDD(rdd).adamFilterRecordsWithTag("XX");
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)rddXX.count())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)2)));
                ADAMRecord[] collected = (ADAMRecord[])rddXX.collect();
                this.$outer.assert(Predef$.MODULE$.refArrayOps((Object[])collected).contains((Object)r1));
                this.$outer.assert(Predef$.MODULE$.refArrayOps((Object[])collected).contains((Object)r2));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.sparkTest("withTag, when given a tag name that doesn't exist in the input, returns an empty RDD", this.sparkTest$default$2(), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ADAMRDDFunctionsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ADAMRecord r1 = ADAMRecord.newBuilder().setAttributes((CharSequence)"XX:i:3").build();
                ADAMRecord r2 = ADAMRecord.newBuilder().setAttributes((CharSequence)"XX:i:4\tYY:i:10").build();
                ADAMRecord r3 = ADAMRecord.newBuilder().setAttributes((CharSequence)"YY:i:20").build();
                SparkContext qual$17 = this.$outer.sc();
                Seq x$123 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ADAMRecord[]{r1, r2, r3}));
                int x$124 = qual$17.parallelize$default$2();
                RDD rdd = qual$17.parallelize(x$123, x$124, ClassTag$.MODULE$.apply(ADAMRecord.class));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)rdd.count())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)3)));
                RDD rddXX = ADAMContext$.MODULE$.rddToADAMRecordRDD(rdd).adamFilterRecordsWithTag("ZZ");
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)rddXX.count())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)0)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.sparkTest("characterizeTagValues counts distinct values of a tag", this.sparkTest$default$2(), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ADAMRDDFunctionsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ADAMRecord r1 = ADAMRecord.newBuilder().setAttributes((CharSequence)"XX:i:3").build();
                ADAMRecord r2 = ADAMRecord.newBuilder().setAttributes((CharSequence)"XX:i:4\tYY:i:10").build();
                ADAMRecord r3 = ADAMRecord.newBuilder().setAttributes((CharSequence)"YY:i:20").build();
                ADAMRecord r4 = ADAMRecord.newBuilder().setAttributes((CharSequence)"XX:i:4").build();
                SparkContext qual$18 = this.$outer.sc();
                Seq x$125 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ADAMRecord[]{r1, r2, r3, r4}));
                int x$126 = qual$18.parallelize$default$2();
                RDD rdd = qual$18.parallelize(x$125, x$126, ClassTag$.MODULE$.apply(ADAMRecord.class));
                Map tagValues = ADAMContext$.MODULE$.rddToADAMRecordRDD(rdd).adamCharacterizeTagValues("XX");
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)tagValues.keys().size())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)2)));
                this.$outer.assert(this.$outer.convertToEqualizer(tagValues.apply((Object)BoxesRunTime.boxToInteger((int)4))).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)2)));
                this.$outer.assert(this.$outer.convertToEqualizer(tagValues.apply((Object)BoxesRunTime.boxToInteger((int)3))).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.sparkTest("characterizeTags counts tags in a SAM file correctly", this.sparkTest$default$2(), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ADAMRDDFunctionsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String filePath = this.$outer.getClass().getClassLoader().getResource("reads12.sam").getFile();
                ADAMContext qual$19 = ADAMContext$.MODULE$.sparkContextToADAMContext(this.$outer.sc());
                None$ x$128 = qual$19.adamLoad$default$2();
                Option x$129 = qual$19.adamLoad$default$3();
                RDD sam = qual$19.adamLoad(filePath, (Option)x$128, x$129, (Function1)Predef$.MODULE$.conforms(), ManifestFactory$.MODULE$.classType(ADAMRecord.class));
                Map mapCounts = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])ADAMContext$.MODULE$.rddToADAMRecordRDD(sam).adamCharacterizeTags().collect()));
                this.$outer.assert(this.$outer.convertToEqualizer(mapCounts.apply((Object)"NM")).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)200)));
                this.$outer.assert(this.$outer.convertToEqualizer(mapCounts.apply((Object)"AS")).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)200)));
                this.$outer.assert(this.$outer.convertToEqualizer(mapCounts.apply((Object)"XS")).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)200)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.sparkTest("recover reference string from a single contig fragment", this.sparkTest$default$2(), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ADAMRDDFunctionsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ADAMContig contig = ADAMContig.newBuilder().setContigName((CharSequence)"chr1").setContigLength(Predef$.MODULE$.long2Long(7L)).build();
                ADAMNucleotideContigFragment fragment = ADAMNucleotideContigFragment.newBuilder().setContig(contig).setFragmentSequence((CharSequence)"ACTGTAC").setFragmentNumber(Predef$.MODULE$.int2Integer(0)).setFragmentStartPosition(Predef$.MODULE$.long2Long(0L)).setNumberOfFragmentsInContig(Predef$.MODULE$.int2Integer(1)).build();
                ReferenceRegion region = (ReferenceRegion)ReferenceRegion$.MODULE$.apply(fragment).get();
                SparkContext qual$20 = this.$outer.sc();
                List x$130 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ADAMNucleotideContigFragment[]{fragment}));
                int x$131 = qual$20.parallelize$default$2();
                RDD rdd = qual$20.parallelize((Seq)x$130, x$131, ClassTag$.MODULE$.apply(ADAMNucleotideContigFragment.class));
                this.$outer.assert(this.$outer.convertToEqualizer(ADAMContext$.MODULE$.rddToADAMRDD(rdd).adamGetReferenceString(region)).$eq$eq$eq((Object)"ACTGTAC"));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.sparkTest("recover trimmed reference string from a single contig fragment", this.sparkTest$default$2(), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ADAMRDDFunctionsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ADAMContig contig = ADAMContig.newBuilder().setContigName((CharSequence)"chr1").setContigLength(Predef$.MODULE$.long2Long(7L)).build();
                ADAMNucleotideContigFragment fragment = ADAMNucleotideContigFragment.newBuilder().setContig(contig).setFragmentSequence((CharSequence)"ACTGTAC").setFragmentNumber(Predef$.MODULE$.int2Integer(0)).setFragmentStartPosition(Predef$.MODULE$.long2Long(0L)).setNumberOfFragmentsInContig(Predef$.MODULE$.int2Integer(1)).build();
                ReferenceRegion region = new ReferenceRegion("chr1", 1L, 6L);
                SparkContext qual$21 = this.$outer.sc();
                List x$132 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ADAMNucleotideContigFragment[]{fragment}));
                int x$133 = qual$21.parallelize$default$2();
                RDD rdd = qual$21.parallelize((Seq)x$132, x$133, ClassTag$.MODULE$.apply(ADAMNucleotideContigFragment.class));
                this.$outer.assert(this.$outer.convertToEqualizer(ADAMContext$.MODULE$.rddToADAMRDD(rdd).adamGetReferenceString(region)).$eq$eq$eq((Object)"CTGTA"));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.sparkTest("recover reference string from multiple contig fragments", this.sparkTest$default$2(), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ADAMRDDFunctionsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ADAMContig contig1 = ADAMContig.newBuilder().setContigName((CharSequence)"chr1").setContigLength(Predef$.MODULE$.long2Long(7L)).build();
                ADAMContig contig2 = ADAMContig.newBuilder().setContigName((CharSequence)"chr2").setContigLength(Predef$.MODULE$.long2Long(11L)).build();
                Predef$ predef$ = Predef$.MODULE$;
                String sequence0 = (String)new StringOps("ACTGTACTC").take(7);
                Predef$ predef$2 = Predef$.MODULE$;
                String string = (String)new StringOps("ACTGTACTC").drop(3);
                Predef$ predef$3 = Predef$.MODULE$;
                String sequence1 = (String)new StringOps(string).take(5);
                Predef$ predef$4 = Predef$.MODULE$;
                String string2 = (String)new StringOps("ACTGTACTC").takeRight(6);
                Predef$ predef$5 = Predef$.MODULE$;
                String sequence2 = (String)new StringOps(string2).reverse();
                ADAMNucleotideContigFragment fragment0 = ADAMNucleotideContigFragment.newBuilder().setContig(contig1).setFragmentSequence((CharSequence)sequence0).setFragmentNumber(Predef$.MODULE$.int2Integer(0)).setFragmentStartPosition(Predef$.MODULE$.long2Long(0L)).setNumberOfFragmentsInContig(Predef$.MODULE$.int2Integer(1)).build();
                ADAMNucleotideContigFragment fragment1 = ADAMNucleotideContigFragment.newBuilder().setContig(contig2).setFragmentSequence((CharSequence)sequence1).setFragmentNumber(Predef$.MODULE$.int2Integer(0)).setFragmentStartPosition(Predef$.MODULE$.long2Long(0L)).setNumberOfFragmentsInContig(Predef$.MODULE$.int2Integer(2)).build();
                ADAMNucleotideContigFragment fragment2 = ADAMNucleotideContigFragment.newBuilder().setContig(contig2).setFragmentSequence((CharSequence)sequence2).setFragmentNumber(Predef$.MODULE$.int2Integer(1)).setFragmentStartPosition(Predef$.MODULE$.long2Long(5L)).setNumberOfFragmentsInContig(Predef$.MODULE$.int2Integer(2)).build();
                ReferenceRegion region0 = (ReferenceRegion)ReferenceRegion$.MODULE$.apply(fragment0).get();
                ReferenceRegion region1 = ((ReferenceRegion)ReferenceRegion$.MODULE$.apply(fragment1).get()).merge((ReferenceRegion)ReferenceRegion$.MODULE$.apply(fragment2).get());
                SparkContext qual$22 = this.$outer.sc();
                List x$134 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ADAMNucleotideContigFragment[]{fragment0, fragment1, fragment2}));
                int x$135 = qual$22.parallelize$default$2();
                RDD rdd = qual$22.parallelize((Seq)x$134, x$135, ClassTag$.MODULE$.apply(ADAMNucleotideContigFragment.class));
                this.$outer.assert(this.$outer.convertToEqualizer(ADAMContext$.MODULE$.rddToADAMRDD(rdd).adamGetReferenceString(region0)).$eq$eq$eq((Object)"ACTGTAC"));
                this.$outer.assert(this.$outer.convertToEqualizer(ADAMContext$.MODULE$.rddToADAMRDD(rdd).adamGetReferenceString(region1)).$eq$eq$eq((Object)"GTACTCTCATG"));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.sparkTest("recover trimmed reference string from multiple contig fragments", this.sparkTest$default$2(), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ADAMRDDFunctionsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ADAMContig contig1 = ADAMContig.newBuilder().setContigName((CharSequence)"chr1").setContigLength(Predef$.MODULE$.long2Long(7L)).build();
                ADAMContig contig2 = ADAMContig.newBuilder().setContigName((CharSequence)"chr2").setContigLength(Predef$.MODULE$.long2Long(11L)).build();
                Predef$ predef$ = Predef$.MODULE$;
                String sequence0 = (String)new StringOps("ACTGTACTC").take(7);
                Predef$ predef$2 = Predef$.MODULE$;
                String string = (String)new StringOps("ACTGTACTC").drop(3);
                Predef$ predef$3 = Predef$.MODULE$;
                String sequence1 = (String)new StringOps(string).take(5);
                Predef$ predef$4 = Predef$.MODULE$;
                String string2 = (String)new StringOps("ACTGTACTC").takeRight(6);
                Predef$ predef$5 = Predef$.MODULE$;
                String sequence2 = (String)new StringOps(string2).reverse();
                ADAMNucleotideContigFragment fragment0 = ADAMNucleotideContigFragment.newBuilder().setContig(contig1).setFragmentSequence((CharSequence)sequence0).setFragmentNumber(Predef$.MODULE$.int2Integer(0)).setFragmentStartPosition(Predef$.MODULE$.long2Long(0L)).setNumberOfFragmentsInContig(Predef$.MODULE$.int2Integer(1)).build();
                ADAMNucleotideContigFragment fragment1 = ADAMNucleotideContigFragment.newBuilder().setContig(contig2).setFragmentSequence((CharSequence)sequence1).setFragmentNumber(Predef$.MODULE$.int2Integer(0)).setFragmentStartPosition(Predef$.MODULE$.long2Long(0L)).setNumberOfFragmentsInContig(Predef$.MODULE$.int2Integer(2)).build();
                ADAMNucleotideContigFragment fragment2 = ADAMNucleotideContigFragment.newBuilder().setContig(contig2).setFragmentSequence((CharSequence)sequence2).setFragmentNumber(Predef$.MODULE$.int2Integer(1)).setFragmentStartPosition(Predef$.MODULE$.long2Long(5L)).setNumberOfFragmentsInContig(Predef$.MODULE$.int2Integer(2)).build();
                ReferenceRegion region0 = new ReferenceRegion("chr1", 1L, 6L);
                ReferenceRegion region1 = new ReferenceRegion("chr2", 3L, 9L);
                SparkContext qual$23 = this.$outer.sc();
                List x$136 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ADAMNucleotideContigFragment[]{fragment0, fragment1, fragment2}));
                int x$137 = qual$23.parallelize$default$2();
                RDD rdd = qual$23.parallelize((Seq)x$136, x$137, ClassTag$.MODULE$.apply(ADAMNucleotideContigFragment.class));
                this.$outer.assert(this.$outer.convertToEqualizer(ADAMContext$.MODULE$.rddToADAMRDD(rdd).adamGetReferenceString(region0)).$eq$eq$eq((Object)"CTGTA"));
                this.$outer.assert(this.$outer.convertToEqualizer(ADAMContext$.MODULE$.rddToADAMRDD(rdd).adamGetReferenceString(region1)).$eq$eq$eq((Object)"CTCTCA"));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.sparkTest("round trip from ADAM to SAM and back to ADAM produces equivalent ADAMRecord values", this.sparkTest$default$2(), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            public final /* synthetic */ ADAMRDDFunctionsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void apply$mcV$sp() {
                String reads12Path = Thread.currentThread().getContextClassLoader().getResource("reads12.sam").getFile();
                ADAMContext qual$24 = ADAMContext$.MODULE$.sparkContextToADAMContext(this.$outer.sc());
                None$ x$139 = qual$24.adamLoad$default$2();
                Option x$140 = qual$24.adamLoad$default$3();
                RDD rdd12A = qual$24.adamLoad(reads12Path, (Option)x$139, x$140, (Function1)Predef$.MODULE$.conforms(), ManifestFactory$.MODULE$.classType(ADAMRecord.class));
                Path tempFile = Files.createTempDirectory("reads12", new FileAttribute[0]);
                ADAMContext$.MODULE$.rddToADAMRecordRDD(rdd12A).adamSAMSave(new StringBuilder().append((Object)((Object)tempFile.toAbsolutePath()).toString()).append((Object)"/reads12.sam").toString(), true);
                RDD rdd12B = ADAMContext$.MODULE$.sparkContextToADAMContext(this.$outer.sc()).adamBamLoad(new StringBuilder().append((Object)((Object)tempFile.toAbsolutePath()).toString()).append((Object)"/reads12.sam/part-r-00000").toString());
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)rdd12B.count())).$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)rdd12A.count())));
                ADAMRecord[] reads12A = (ADAMRecord[])rdd12A.collect();
                ADAMRecord[] reads12B = (ADAMRecord[])rdd12B.collect();
                Predef$ predef$ = Predef$.MODULE$;
                Serializable serializable = new Serializable(this, reads12A, reads12B){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$22 $outer;
                    private final ADAMRecord[] reads12A$1;
                    private final ADAMRecord[] reads12B$1;

                    public final void apply(int x0$1) {
                        this.apply$mcVI$sp(x0$1);
                    }

                    public void apply$mcVI$sp(int x0$1) {
                        Tuple2 tuple2 = new Tuple2((Object)this.reads12A$1[x0$1], (Object)this.reads12B$1[x0$1]);
                        if (tuple2 != null) {
                            Tuple2 tuple22 = new Tuple2(tuple2._1(), tuple2._2());
                            ADAMRecord readA = (ADAMRecord)tuple22._1();
                            ADAMRecord readB = (ADAMRecord)tuple22._2();
                            this.$outer.$outer.assert(this.$outer.$outer.convertToEqualizer(readA.getSequence()).$eq$eq$eq((Object)readB.getSequence()));
                            this.$outer.$outer.assert(this.$outer.org$bdgenomics$adam$rdd$ADAMRDDFunctionsSuite$$anonfun$$$outer().convertToEqualizer(readA.getQual()).$eq$eq$eq((Object)readB.getQual()));
                            this.$outer.org$bdgenomics$adam$rdd$ADAMRDDFunctionsSuite$$anonfun$$$outer().assert(this.$outer.org$bdgenomics$adam$rdd$ADAMRDDFunctionsSuite$$anonfun$$$outer().convertToEqualizer(readA.getCigar()).$eq$eq$eq((Object)readB.getCigar()));
                            return;
                        }
                        throw new MatchError((Object)tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.reads12A$1 = reads12A$1;
                        this.reads12B$1 = reads12B$1;
                    }
                };
                Range range = RichInt$.MODULE$.until$extension0(0, reads12A.length);
                if (!range.validateRangeBoundaries((Function1)serializable)) return;
                int n = range.start();
                int n2 = range.terminalElement();
                int n3 = range.step();
                while (n != n2) {
                    serializable.apply$mcVI$sp(n);
                    n += n3;
                }
                return;
            }

            public /* synthetic */ ADAMRDDFunctionsSuite org$bdgenomics$adam$rdd$ADAMRDDFunctionsSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.sparkTest("SAM conversion sets read mapped flag properly", this.sparkTest$default$2(), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            public final /* synthetic */ ADAMRDDFunctionsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String filePath = this.$outer.getClass().getClassLoader().getResource("reads12.sam").getFile();
                ADAMContext qual$25 = ADAMContext$.MODULE$.sparkContextToADAMContext(this.$outer.sc());
                None$ x$142 = qual$25.adamLoad$default$2();
                Option x$143 = qual$25.adamLoad$default$3();
                RDD sam = qual$25.adamLoad(filePath, (Option)x$142, x$143, (Function1)Predef$.MODULE$.conforms(), ManifestFactory$.MODULE$.classType(ADAMRecord.class));
                Predef$.MODULE$.refArrayOps((Object[])sam.collect()).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$23 $outer;

                    public final void apply(ADAMRecord r) {
                        this.$outer.$outer.assert(Predef$.MODULE$.Boolean2boolean(r.getReadMapped()));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ ADAMRDDFunctionsSuite org$bdgenomics$adam$rdd$ADAMRDDFunctionsSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

