/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.rdd;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.avro.Schema;
import org.apache.log4j.Level;
import org.apache.spark.Partitioner;
import org.apache.spark.RangePartitioner;
import org.apache.spark.RangePartitioner$;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkContext$;
import org.apache.spark.rdd.OrderedRDDFunctions;
import org.apache.spark.rdd.RDD;
import org.bdgenomics.adam.avro.ADAMContig;
import org.bdgenomics.adam.avro.ADAMRecord;
import org.bdgenomics.adam.models.ReferencePosition;
import org.bdgenomics.adam.models.ReferencePosition$;
import org.bdgenomics.adam.models.SequenceDictionary;
import org.bdgenomics.adam.models.SequenceDictionary$;
import org.bdgenomics.adam.models.SequenceRecord;
import org.bdgenomics.adam.models.SequenceRecord$;
import org.bdgenomics.adam.projections.ADAMRecordField$;
import org.bdgenomics.adam.projections.FieldValue;
import org.bdgenomics.adam.projections.Projection$;
import org.bdgenomics.adam.rdd.ADAMContext;
import org.bdgenomics.adam.rdd.ADAMContext$;
import org.bdgenomics.adam.rdd.GenomicRegionPartitioner;
import org.bdgenomics.adam.rdd.GenomicRegionPartitionerSuite$;
import org.bdgenomics.adam.util.SparkFunSuite;
import org.bdgenomics.adam.util.SparkFunSuite$class;
import org.scalatest.BeforeAndAfter;
import org.scalatest.Distributor;
import org.scalatest.Filter;
import org.scalatest.FunSuite;
import org.scalatest.FunSuiteLike;
import org.scalatest.Reporter;
import org.scalatest.Stopper;
import org.scalatest.Tag;
import org.scalatest.Tracker;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.math.Ordering$;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0001M3A!\u0001\u0002\u0001\u0017\tir)\u001a8p[&\u001c'+Z4j_:\u0004\u0016M\u001d;ji&|g.\u001a:Tk&$XM\u0003\u0002\u0004\t\u0005\u0019!\u000f\u001a3\u000b\u0005\u00151\u0011\u0001B1eC6T!a\u0002\u0005\u0002\u0015\t$w-\u001a8p[&\u001c7OC\u0001\n\u0003\ry'oZ\u0002\u0001'\r\u0001AB\u0005\t\u0003\u001bAi\u0011A\u0004\u0006\u0003\u001f!\t\u0011b]2bY\u0006$Xm\u001d;\n\u0005Eq!\u0001\u0003$v]N+\u0018\u000e^3\u0011\u0005M1R\"\u0001\u000b\u000b\u0005U!\u0011\u0001B;uS2L!a\u0006\u000b\u0003\u001bM\u0003\u0018M]6Gk:\u001cV/\u001b;f\u0011\u0015I\u0002\u0001\"\u0001\u001b\u0003\u0019a\u0014N\\5u}Q\t1\u0004\u0005\u0002\u001d\u00015\t!\u0001C\u0003\u001f\u0001\u0011\u0005q$\u0001\u0006bI\u0006l'+Z2pe\u0012$R\u0001\t\u00143ie\u0002\"!\t\u0013\u000e\u0003\tR!a\t\u0003\u0002\t\u00054(o\\\u0005\u0003K\t\u0012!\"\u0011#B\u001bJ+7m\u001c:e\u0011\u00159S\u00041\u0001)\u00035\u0011XMZ3sK:\u001cWMT1nKB\u0011\u0011f\f\b\u0003U5j\u0011a\u000b\u0006\u0002Y\u0005)1oY1mC&\u0011afK\u0001\u0007!J,G-\u001a4\n\u0005A\n$AB*ue&twM\u0003\u0002/W!)1'\ba\u0001Q\u0005A!/Z1e\u001d\u0006lW\rC\u00036;\u0001\u0007a'A\u0003ti\u0006\u0014H\u000f\u0005\u0002+o%\u0011\u0001h\u000b\u0002\u0005\u0019>tw\rC\u0003;;\u0001\u00071(\u0001\u0006sK\u0006$W*\u00199qK\u0012\u0004\"A\u000b\u001f\n\u0005uZ#a\u0002\"p_2,\u0017M\u001c\u0005\u0006\u007f\u0001!\t\u0001Q\u0001\u0007e\u0016\u001cwN\u001d3\u0015\u0007\u0005;\u0015\u000b\u0005\u0002C\u000b6\t1I\u0003\u0002E\t\u00051Qn\u001c3fYNL!AR\"\u0003\u001dM+\u0017/^3oG\u0016\u0014VmY8sI\")\u0001J\u0010a\u0001\u0013\u0006!a.Y7f!\tQu*D\u0001L\u0015\taU*\u0001\u0003mC:<'\"\u0001(\u0002\t)\fg/Y\u0005\u0003!.\u0013Ab\u00115beN+\u0017/^3oG\u0016DQA\u0015 A\u0002Y\na\u0001\\3oORD\u0007")
public class GenomicRegionPartitionerSuite
extends FunSuite
implements SparkFunSuite {
    private SparkContext sc;
    private Option<Map<String, Level>> maybeLevels;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    private volatile boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked;

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public Option<Map<String, Level>> maybeLevels() {
        return this.maybeLevels;
    }

    @Override
    public void maybeLevels_$eq(Option<Map<String, Level>> x$1) {
        this.maybeLevels = x$1;
    }

    @Override
    public void setupSparkContext(String sparkName, boolean silenceSpark) {
        SparkFunSuite$class.setupSparkContext(this, sparkName, silenceSpark);
    }

    @Override
    public void teardownSparkContext() {
        SparkFunSuite$class.teardownSparkContext(this);
    }

    @Override
    public void sparkBefore(String beforeName, boolean silenceSpark, Function0<BoxedUnit> body) {
        SparkFunSuite$class.sparkBefore(this, beforeName, silenceSpark, body);
    }

    @Override
    public void sparkAfter(String beforeName, boolean silenceSpark, Function0<BoxedUnit> body) {
        SparkFunSuite$class.sparkAfter(this, beforeName, silenceSpark, body);
    }

    @Override
    public void sparkTest(String name, boolean silenceSpark, Function0<BoxedUnit> body) {
        SparkFunSuite$class.sparkTest(this, name, silenceSpark, body);
    }

    @Override
    public boolean sparkTest$default$2() {
        return SparkFunSuite$class.sparkTest$default$2(this);
    }

    @Override
    public boolean sparkBefore$default$2() {
        return SparkFunSuite$class.sparkBefore$default$2(this);
    }

    @Override
    public boolean setupSparkContext$default$2() {
        return SparkFunSuite$class.setupSparkContext$default$2(this);
    }

    @Override
    public boolean sparkAfter$default$2() {
        return SparkFunSuite$class.sparkAfter$default$2(this);
    }

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    }

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    }

    public boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked() {
        return this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked;
    }

    public void org$scalatest$BeforeAndAfter$$runHasBeenInvoked_$eq(boolean x$1) {
        this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked = x$1;
    }

    public void org$scalatest$BeforeAndAfter$$super$runTest(String testName, Reporter reporter, Stopper stopper, Map configMap, Tracker tracker) {
        FunSuiteLike.class.runTest((FunSuiteLike)this, (String)testName, (Reporter)reporter, (Stopper)stopper, (Map)configMap, (Tracker)tracker);
    }

    public void org$scalatest$BeforeAndAfter$$super$run(Option testName, Reporter reporter, Stopper stopper, Filter filter, Map configMap, Option distributor, Tracker tracker) {
        FunSuiteLike.class.run((FunSuiteLike)this, (Option)testName, (Reporter)reporter, (Stopper)stopper, (Filter)filter, (Map)configMap, (Option)distributor, (Tracker)tracker);
    }

    public void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$beforeFunctionAtomic_$eq(AtomicReference x$1) {
        this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic = x$1;
    }

    public void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$afterFunctionAtomic_$eq(AtomicReference x$1) {
        this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic = x$1;
    }

    public void before(Function0<Object> fun) {
        BeforeAndAfter.class.before((BeforeAndAfter)this, fun);
    }

    public void after(Function0<Object> fun) {
        BeforeAndAfter.class.after((BeforeAndAfter)this, fun);
    }

    public void runTest(String testName, Reporter reporter, Stopper stopper, Map<String, Object> configMap, Tracker tracker) {
        BeforeAndAfter.class.runTest((BeforeAndAfter)this, (String)testName, (Reporter)reporter, (Stopper)stopper, configMap, (Tracker)tracker);
    }

    public void run(Option<String> testName, Reporter reporter, Stopper stopper, Filter filter, Map<String, Object> configMap, Option<Distributor> distributor, Tracker tracker) {
        BeforeAndAfter.class.run((BeforeAndAfter)this, testName, (Reporter)reporter, (Stopper)stopper, (Filter)filter, configMap, distributor, (Tracker)tracker);
    }

    public ADAMRecord adamRecord(String referenceName, String readName, long start, boolean readMapped) {
        ADAMContig contig = ADAMContig.newBuilder().setContigName((CharSequence)referenceName).build();
        return ADAMRecord.newBuilder().setContig(contig).setReadName((CharSequence)readName).setReadMapped(Predef$.MODULE$.boolean2Boolean(readMapped)).setStart(Predef$.MODULE$.long2Long(start)).build();
    }

    public SequenceRecord record(CharSequence name, long length) {
        return SequenceRecord$.MODULE$.apply(((Object)name).toString(), (long)((int)length), SequenceRecord$.MODULE$.apply$default$3(), SequenceRecord$.MODULE$.apply$default$4(), SequenceRecord$.MODULE$.apply$default$5(), SequenceRecord$.MODULE$.apply$default$6(), SequenceRecord$.MODULE$.apply$default$7(), SequenceRecord$.MODULE$.apply$default$8());
    }

    public GenomicRegionPartitionerSuite() {
        BeforeAndAfter.class.$init$((BeforeAndAfter)this);
        SparkFunSuite$class.$init$(this);
        this.test("partitions the UNMAPPED ReferencePosition into the top partition", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GenomicRegionPartitionerSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                GenomicRegionPartitioner parter = new GenomicRegionPartitioner(10, SequenceDictionary$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SequenceRecord[]{this.$outer.record("foo", 1000L)})));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)parter.numPartitions())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)11)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)parter.getPartition((Object)ReferencePosition$.MODULE$.UNMAPPED()))).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)10)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("partitioning into N pieces on M total sequence length, where N > M, results in M partitions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GenomicRegionPartitionerSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                GenomicRegionPartitioner parter = new GenomicRegionPartitioner(10, SequenceDictionary$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SequenceRecord[]{this.$outer.record("foo", 9L)})));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)parter.numPartitions())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)10)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("correctly partitions a single dummy sequence into two pieces", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GenomicRegionPartitionerSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                GenomicRegionPartitioner parter = new GenomicRegionPartitioner(2, SequenceDictionary$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SequenceRecord[]{this.$outer.record("foo", 10L)})));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)parter.getPartition((Object)new ReferencePosition("foo", 3L)))).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)0)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)parter.getPartition((Object)new ReferencePosition("foo", 7L)))).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("correctly counts cumulative lengths", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GenomicRegionPartitionerSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                GenomicRegionPartitioner parter = new GenomicRegionPartitioner(3, SequenceDictionary$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SequenceRecord[]{this.$outer.record("foo", 20L), this.$outer.record("bar", 10L)})));
                this.$outer.assert(this.$outer.convertToEqualizer(parter.cumulativeLengths().apply((Object)"bar")).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)0)));
                this.$outer.assert(this.$outer.convertToEqualizer(parter.cumulativeLengths().apply((Object)"foo")).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)10)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("correctly partitions positions across two dummy sequences", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GenomicRegionPartitionerSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                GenomicRegionPartitioner parter = new GenomicRegionPartitioner(3, SequenceDictionary$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SequenceRecord[]{this.$outer.record("bar", 20L), this.$outer.record("foo", 10L)})));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)parter.getPartition((Object)new ReferencePosition("foo", 8L)))).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)2)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)parter.getPartition((Object)new ReferencePosition("foo", 18L)))).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)3)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)parter.getPartition((Object)new ReferencePosition("bar", 18L)))).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)parter.getPartition((Object)new ReferencePosition("bar", 8L)))).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)0)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)parter.getPartition((Object)new ReferencePosition("foo", 0L)))).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)2)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)parter.getPartition((Object)new ReferencePosition("foo", 10L)))).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)3)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)parter.getPartition((Object)new ReferencePosition("bar", 0L)))).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)0)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.sparkTest("test that we can range partition ADAMRecords", this.sparkTest$default$2(), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            public final /* synthetic */ GenomicRegionPartitionerSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Random rand = new Random(1000L);
                SparkContext qual$1 = this.$outer.sc();
                Predef$ predef$ = Predef$.MODULE$;
                IndexedSeq x$2 = (IndexedSeq)RichInt$.MODULE$.to$extension0(1, 1000).map((Function1)new Serializable(this, rand){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$6 $outer;
                    private final Random rand$1;

                    public final ADAMRecord apply(int i) {
                        Predef$ predef$ = Predef$.MODULE$;
                        return this.$outer.$outer.adamRecord("chr1", new StringOps("read_%d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})), this.rand$1.nextInt(100), true);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.rand$1 = rand$1;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
                int x$3 = qual$1.parallelize$default$2();
                RDD pos = qual$1.parallelize((Seq)x$2, x$3, ClassTag$.MODULE$.apply(ADAMRecord.class));
                RDD pairs = pos.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<ReferencePosition, ADAMRecord> apply(ADAMRecord p) {
                        return new Tuple2((Object)new ReferencePosition(ADAMContext$.MODULE$.charSequenceToString(p.contig.getContigName()), Predef$.MODULE$.Long2long(p.getStart())), (Object)p);
                    }
                }, ClassTag$.MODULE$.apply(Tuple2.class));
                RangePartitioner parter = new RangePartitioner(200, pairs, RangePartitioner$.MODULE$.$lessinit$greater$default$3(), Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.conforms()), ClassTag$.MODULE$.apply(ReferencePosition.class));
                OrderedRDDFunctions qual$2 = SparkContext$.MODULE$.rddToOrderedRDDFunctions(pairs, Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.conforms()), ClassTag$.MODULE$.apply(ReferencePosition.class), ClassTag$.MODULE$.apply(ADAMRecord.class));
                boolean x$4 = qual$2.sortByKey$default$1();
                int x$5 = qual$2.sortByKey$default$2();
                RDD partitioned = SparkContext$.MODULE$.rddToPairRDDFunctions(qual$2.sortByKey(x$4, x$5), ClassTag$.MODULE$.apply(ReferencePosition.class), ClassTag$.MODULE$.apply(ADAMRecord.class), Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.conforms())).partitionBy((Partitioner)parter);
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)partitioned.count())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1000)));
                RDD sizes = partitioned.mapPartitions((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Iterator<Object> apply(Iterator<Tuple2<ReferencePosition, ADAMRecord>> itr) {
                        return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{itr.size()})).iterator();
                    }
                }, partitioned.mapPartitions$default$2(), ClassTag$.MODULE$.Int());
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)Predef$.MODULE$.intArrayOps((int[])sizes.collect()).size())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)200)));
            }

            public /* synthetic */ GenomicRegionPartitionerSuite org$bdgenomics$adam$rdd$GenomicRegionPartitionerSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.sparkTest("test that simple partitioning works okay on a reasonable set of ADAMRecords", this.sparkTest$default$2(), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GenomicRegionPartitionerSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String filename = ClassLoader.getSystemClassLoader().getResource("reads12.sam").getFile();
                SequenceDictionary dict = ADAMContext$.MODULE$.sparkContextToADAMContext(this.$outer.sc()).adamDictionaryLoad(filename, (Function1)Predef$.MODULE$.conforms(), ManifestFactory$.MODULE$.classType(ADAMRecord.class));
                GenomicRegionPartitioner parter = new GenomicRegionPartitioner(1, dict);
                Schema p = Projection$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FieldValue[]{ADAMRecordField$.MODULE$.contig(), ADAMRecordField$.MODULE$.start(), ADAMRecordField$.MODULE$.readName(), ADAMRecordField$.MODULE$.readMapped()}));
                ADAMContext qual$3 = ADAMContext$.MODULE$.sparkContextToADAMContext(this.$outer.sc());
                Some x$7 = new Some((Object)p);
                None$ x$8 = qual$3.adamLoad$default$2();
                RDD rdd = qual$3.adamLoad(filename, (Option)x$8, (Option)x$7, (Function1)Predef$.MODULE$.conforms(), ManifestFactory$.MODULE$.classType(ADAMRecord.class));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)rdd.count())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)200)));
                OrderedRDDFunctions qual$4 = SparkContext$.MODULE$.rddToOrderedRDDFunctions(rdd.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<ReferencePosition, ADAMRecord> apply(ADAMRecord rec) {
                        return new Tuple2((Object)new ReferencePosition(ADAMContext$.MODULE$.charSequenceToString(rec.getContig().getContigName()), Predef$.MODULE$.Long2long(rec.getStart())), (Object)rec);
                    }
                }, ClassTag$.MODULE$.apply(Tuple2.class)), Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.conforms()), ClassTag$.MODULE$.apply(ReferencePosition.class), ClassTag$.MODULE$.apply(ADAMRecord.class));
                boolean x$9 = qual$4.sortByKey$default$1();
                int x$10 = qual$4.sortByKey$default$2();
                RDD keyed = qual$4.sortByKey(x$9, x$10);
                ReferencePosition[] keys = (ReferencePosition[])keyed.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final ReferencePosition apply(Tuple2<ReferencePosition, ADAMRecord> x$1) {
                        return (ReferencePosition)x$1._1();
                    }
                }, ClassTag$.MODULE$.apply(ReferencePosition.class)).collect();
                this.$outer.assert(!Predef$.MODULE$.refArrayOps((Object[])keys).exists((Function1)new Serializable(this, 1, parter){
                    public static final long serialVersionUID = 0L;
                    private final int parts$1;
                    private final GenomicRegionPartitioner parter$1;

                    public final boolean apply(ReferencePosition rp) {
                        return this.parter$1.getPartition((Object)rp) < 0 || this.parter$1.getPartition((Object)rp) >= this.parts$1;
                    }
                    {
                        this.parts$1 = parts$1;
                        this.parter$1 = parter$1;
                    }
                }));
                RDD partitioned = SparkContext$.MODULE$.rddToPairRDDFunctions(keyed, ClassTag$.MODULE$.apply(ReferencePosition.class), ClassTag$.MODULE$.apply(ADAMRecord.class), Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.conforms())).partitionBy((Partitioner)parter);
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)partitioned.count())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)200)));
                RDD partSizes = partitioned.mapPartitions((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Iterator<Object> apply(Iterator<Tuple2<ReferencePosition, ADAMRecord>> itr) {
                        return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{itr.size()})).iterator();
                    }
                }, partitioned.mapPartitions$default$2(), ClassTag$.MODULE$.Int());
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)partSizes.count())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)(1 + 1))));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

