/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.util;

import java.io.File;
import java.io.PrintWriter;
import org.bdgenomics.adam.util.ByteArrayByteAccess;
import org.bdgenomics.adam.util.LocalFileByteAccess;
import org.scalatest.FunSuite;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001]1A!\u0001\u0002\u0001\u0017\ty!)\u001f;f\u0003\u000e\u001cWm]:Tk&$XM\u0003\u0002\u0004\t\u0005!Q\u000f^5m\u0015\t)a!\u0001\u0003bI\u0006l'BA\u0004\t\u0003)\u0011GmZ3o_6L7m\u001d\u0006\u0002\u0013\u0005\u0019qN]4\u0004\u0001M\u0011\u0001\u0001\u0004\t\u0003\u001bAi\u0011A\u0004\u0006\u0003\u001f!\t\u0011b]2bY\u0006$Xm\u001d;\n\u0005Eq!\u0001\u0003$v]N+\u0018\u000e^3\t\u000bM\u0001A\u0011\u0001\u000b\u0002\rqJg.\u001b;?)\u0005)\u0002C\u0001\f\u0001\u001b\u0005\u0011\u0001")
public class ByteAccessSuite
extends FunSuite {
    public ByteAccessSuite() {
        this.test("ByteArrayByteAccess returns arbitrary subsets of bytes correctly", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ByteAccessSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                byte[] bytes = (byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9}), ClassTag$.MODULE$.Byte());
                ByteArrayByteAccess access = new ByteArrayByteAccess(bytes);
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)access.length())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)bytes.length)));
                this.$outer.assert(this.$outer.convertToEqualizer(access.readFully(5L, 5)).$eq$eq$eq(Predef$.MODULE$.byteArrayOps(bytes).slice(5, 10)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("ByteArrayByteAccess supports two successive calls with different offsets", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ByteAccessSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                byte[] bytes = (byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9}), ClassTag$.MODULE$.Byte());
                ByteArrayByteAccess access = new ByteArrayByteAccess(bytes);
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)access.length())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)bytes.length)));
                this.$outer.assert(this.$outer.convertToEqualizer(access.readFully(5L, 5)).$eq$eq$eq(Predef$.MODULE$.byteArrayOps(bytes).slice(5, 10)));
                this.$outer.assert(this.$outer.convertToEqualizer(access.readFully(3L, 5)).$eq$eq$eq(Predef$.MODULE$.byteArrayOps(bytes).slice(3, 8)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("LocalFileByteAccess returns arbitrary subsets of bytes correctly", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ByteAccessSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                File temp = File.createTempFile("byteaccesssuite", "test");
                PrintWriter writer = new PrintWriter(temp);
                writer.print("abcdefghij");
                writer.close();
                LocalFileByteAccess access = new LocalFileByteAccess(temp);
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)access.length())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)"abcdefghij".length())));
                this.$outer.assert(this.$outer.convertToEqualizer(access.readFully(3L, 5)).$eq$eq$eq((Object)"abcdefghij".substring(3, 8).getBytes("ASCII")));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

