/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.util;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import org.bdgenomics.adam.util.ByteAccess;
import org.bdgenomics.adam.util.FileLocator;
import org.bdgenomics.adam.util.LocalFileLocator;
import org.scalatest.FunSuite;
import org.scalatest.Tag;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001]1A!\u0001\u0002\u0001\u0017\t)Bj\\2bY\u001aKG.\u001a'pG\u0006$xN]*vSR,'BA\u0002\u0005\u0003\u0011)H/\u001b7\u000b\u0005\u00151\u0011\u0001B1eC6T!a\u0002\u0005\u0002\u0015\t$w-\u001a8p[&\u001c7OC\u0001\n\u0003\ry'oZ\u0002\u0001'\t\u0001A\u0002\u0005\u0002\u000e!5\taB\u0003\u0002\u0010\u0011\u0005I1oY1mCR,7\u000f^\u0005\u0003#9\u0011\u0001BR;o'VLG/\u001a\u0005\u0006'\u0001!\t\u0001F\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003U\u0001\"A\u0006\u0001\u000e\u0003\t\u0001")
public class LocalFileLocatorSuite
extends FunSuite {
    public LocalFileLocatorSuite() {
        this.test("parentLocator retrieves the parent directory", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LocalFileLocatorSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                File temp = File.createTempFile("LocalFileLocatorSuite", "test");
                LocalFileLocator loc = new LocalFileLocator(temp);
                Option parentLocOpt = loc.parentLocator();
                if (parentLocOpt instanceof Some) {
                    Some some = (Some)parentLocOpt;
                    this.$outer.assert(this.$outer.convertToEqualizer(some.x()).$eq$eq$eq((Object)new LocalFileLocator(temp.getParentFile())));
                    return;
                }
                None$ none$ = None$.MODULE$;
                if (!(none$ != null ? !none$.equals(parentLocOpt) : parentLocOpt != null)) {
                    throw this.$outer.fail("parentLoc wasn't defined");
                }
                throw new MatchError((Object)parentLocOpt);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("relativeLocator retrieves a subdirectory", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LocalFileLocatorSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                File temp1 = File.createTempFile("LocalFileLocatorSuite", "test");
                File tempDir = temp1.getParentFile();
                LocalFileLocator tempDirLoc = new LocalFileLocator(tempDir);
                FileLocator tempLoc = tempDirLoc.relativeLocator(temp1.getName());
                this.$outer.assert(this.$outer.convertToEqualizer(tempLoc).$eq$eq$eq((Object)new LocalFileLocator(temp1)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("bytes accesses the named underlying file", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LocalFileLocatorSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                File temp = File.createTempFile("LocalFileLocatorSuite", "test");
                PrintWriter pw = new PrintWriter(new FileWriter(temp));
                pw.println("abcdefghij");
                pw.close();
                LocalFileLocator loc = new LocalFileLocator(temp);
                ByteAccess io = loc.bytes();
                String str = new String(io.readFully(3L, 3), "UTF-8");
                this.$outer.assert(this.$outer.convertToEqualizer(str).$eq$eq$eq((Object)"def"));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

