/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.algorithms.realignmenttarget;

import org.apache.spark.Logging;
import org.bdgenomics.adam.algorithms.realignmenttarget.GenericRange;
import org.bdgenomics.adam.algorithms.realignmenttarget.IndelRange;
import org.bdgenomics.adam.algorithms.realignmenttarget.IndelRealignmentTarget$;
import org.bdgenomics.adam.algorithms.realignmenttarget.RangeAccumulator;
import org.bdgenomics.adam.algorithms.realignmenttarget.SNPRange;
import org.bdgenomics.adam.avro.ADAMPileup;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.NumericRange;
import scala.collection.immutable.Set;
import scala.math.Integral;
import scala.math.Numeric;
import scala.math.Ordering$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong;
import scala.util.Sorting$;

@ScalaSignature(bytes="\u0006\u0001\u0005er!B\u0001\u0003\u0011\u0003i\u0011AF%oI\u0016d'+Z1mS\u001etW.\u001a8u)\u0006\u0014x-\u001a;\u000b\u0005\r!\u0011!\u0005:fC2LwM\\7f]R$\u0018M]4fi*\u0011QAB\u0001\u000bC2<wN]5uQ6\u001c(BA\u0004\t\u0003\u0011\tG-Y7\u000b\u0005%Q\u0011A\u00032eO\u0016tw.\\5dg*\t1\"A\u0002pe\u001e\u001c\u0001\u0001\u0005\u0002\u000f\u001f5\t!AB\u0003\u0011\u0005!\u0005\u0011C\u0001\fJ]\u0012,GNU3bY&<g.\\3oiR\u000b'oZ3u'\ty!\u0003\u0005\u0002\u0014-5\tACC\u0001\u0016\u0003\u0015\u00198-\u00197b\u0013\t9BC\u0001\u0004B]f\u0014VM\u001a\u0005\u00063=!\tAG\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00035Aq\u0001H\bC\u0002\u0013\u0005Q$A\tnSNl\u0017\r^2i)\"\u0014Xm\u001d5pY\u0012,\u0012A\b\t\u0003'}I!\u0001\t\u000b\u0003\r\u0011{WO\u00197f\u0011\u0019\u0011s\u0002)A\u0005=\u0005\u0011R.[:nCR\u001c\u0007\u000e\u00165sKNDw\u000e\u001c3!\u0011\u0015!s\u0002\"\u0001&\u0003\u0015\t\u0007\u000f\u001d7z)\t1\u0013\u0010\u0005\u0002\u000fO\u0019!\u0001C\u0001\u0001)'\r9##\u000b\t\u0003U=j\u0011a\u000b\u0006\u0003Y5\nQa\u001d9be.T!A\f\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0013\t\u00014FA\u0004M_\u001e<\u0017N\\4\t\u0011I:#Q1A\u0005\u0002M\n\u0001\"\u001b8eK2\u001cV\r^\u000b\u0002iA\u0019Q\u0007O\u001e\u000f\u0005M1\u0014BA\u001c\u0015\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011H\u000f\u0002\u0004'\u0016$(BA\u001c\u0015!\tqA(\u0003\u0002>\u0005\tQ\u0011J\u001c3fYJ\u000bgnZ3\t\u0011}:#\u0011!Q\u0001\nQ\n\u0011\"\u001b8eK2\u001cV\r\u001e\u0011\t\u0011\u0005;#Q1A\u0005\u0002\t\u000baa\u001d8q'\u0016$X#A\"\u0011\u0007UBD\t\u0005\u0002\u000f\u000b&\u0011aI\u0001\u0002\t':\u0003&+\u00198hK\"A\u0001j\nB\u0001B\u0003%1)A\u0004t]B\u001cV\r\u001e\u0011\t\u000be9C\u0011\u0001&\u0015\u0007\u0019ZE\nC\u00033\u0013\u0002\u0007A\u0007C\u0003B\u0013\u0002\u00071\tC\u0003OO\u0011\u0005q*A\u0005sK\u0006$'+\u00198hKV\t\u0001\u000bE\u0002R3rs!AU,\u000e\u0003MS!\u0001V+\u0002\u0013%lW.\u001e;bE2,'B\u0001,\u0015\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u00031N\u000bABT;nKJL7MU1oO\u0016L!AW.\u0003\u0013%s7\r\\;tSZ,'B\u0001-T!\t\u0019R,\u0003\u0002_)\t!Aj\u001c8h\u0011\u0015\u0001w\u0005\"\u0001b\u0003\u0015iWM]4f)\t1#\rC\u0003d?\u0002\u0007a%\u0001\u0004uCJ<W\r\u001e\u0005\u0006K\u001e\"\tAZ\u0001\bSN,U\u000e\u001d;z)\u00059\u0007CA\ni\u0013\tIGCA\u0004C_>dW-\u00198\t\u000b-<C\u0011\u00017\u0002\u0019\u001d,GOU3bIJ\u000bgnZ3\u0015\u00035\u00042A\u00158]\u0013\ty7K\u0001\u0007Ok6,'/[2SC:<W\rC\u0003rO\u0011\u0005!/\u0001\u0006hKR\u001cvN\u001d;LKf$\u0012\u0001\u0018\u0005\u0007i\u001e\"\tBA;\u0002\u0013\u001d,Go\u0015(Q'\u0016$H#A\"\t\r]<C\u0011\u0003\u0002y\u0003-9W\r^%oI\u0016d7+\u001a;\u0015\u0003QBQA_\u0012A\u0002m\f1A]8e!\u0015a\u0018\u0011BA\b\u001d\ri\u0018Q\u0001\b\u0004}\u0006\rQ\"A@\u000b\u0007\u0005\u0005A\"\u0001\u0004=e>|GOP\u0005\u0002+%\u0019\u0011q\u0001\u000b\u0002\u000fA\f7m[1hK&!\u00111BA\u0007\u0005!IE/\u001a:bE2,'bAA\u0004)A!\u0011\u0011CA\f\u001b\t\t\u0019BC\u0002\u0002\u0016\u0019\tA!\u0019<s_&!\u0011\u0011DA\n\u0005)\tE)Q'QS2,W\u000f\u001d\u0005\b\u0003;yA\u0011AA\u0010\u0003E)\u0007\u0010\u001e:bGRl\u0015n]7bi\u000eDWm\u001d\u000b\u0004w\u0006\u0005\u0002B\u0002>\u0002\u001c\u0001\u00071\u0010C\u0004\u0002&=!\t!a\n\u0002\u001d\u0015DHO]1di6\u000bGo\u00195fgR\u001910!\u000b\t\ri\f\u0019\u00031\u0001|\u0011\u001d\tic\u0004C\u0001\u0003_\tQ\"\u001a=ue\u0006\u001cG/\u00138eK2\u001cHcA>\u00022!1!0a\u000bA\u0002mDq!!\u000e\u0010\t\u0003\t9$A\u0006f[B$\u0018\u0010V1sO\u0016$H#\u0001\u0014")
public class IndelRealignmentTarget
implements Logging {
    private final Set<IndelRange> indelSet;
    private final Set<SNPRange> snpSet;
    private transient Logger org$apache$spark$Logging$$log_;

    public static IndelRealignmentTarget emptyTarget() {
        return IndelRealignmentTarget$.MODULE$.emptyTarget();
    }

    public static Iterable<ADAMPileup> extractIndels(Iterable<ADAMPileup> iterable) {
        return IndelRealignmentTarget$.MODULE$.extractIndels(iterable);
    }

    public static Iterable<ADAMPileup> extractMatches(Iterable<ADAMPileup> iterable) {
        return IndelRealignmentTarget$.MODULE$.extractMatches(iterable);
    }

    public static Iterable<ADAMPileup> extractMismatches(Iterable<ADAMPileup> iterable) {
        return IndelRealignmentTarget$.MODULE$.extractMismatches(iterable);
    }

    public static IndelRealignmentTarget apply(Iterable<ADAMPileup> iterable) {
        return IndelRealignmentTarget$.MODULE$.apply(iterable);
    }

    public static double mismatchThreshold() {
        return IndelRealignmentTarget$.MODULE$.mismatchThreshold();
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public Set<IndelRange> indelSet() {
        return this.indelSet;
    }

    public Set<SNPRange> snpSet() {
        return this.snpSet;
    }

    public NumericRange.Inclusive<Object> readRange() {
        return (NumericRange.Inclusive)((TraversableOnce)((List)this.indelSet().toList().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final NumericRange.Inclusive<Object> apply(IndelRange x$9) {
                return (NumericRange.Inclusive)x$9.getReadRange();
            }
        }, List$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)this.snpSet().toList().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final NumericRange.Inclusive<Object> apply(SNPRange x$10) {
                return (NumericRange.Inclusive)x$10.getReadRange();
            }
        }, List$.MODULE$.canBuildFrom()), List$.MODULE$.canBuildFrom())).reduce((Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final NumericRange.Inclusive<Object> apply(NumericRange.Inclusive<Object> a, NumericRange.Inclusive<Object> b) {
                long l = BoxesRunTime.unboxToLong((Object)a.start());
                Predef$ predef$ = Predef$.MODULE$;
                long l2 = BoxesRunTime.unboxToLong((Object)a.end());
                Predef$ predef$2 = Predef$.MODULE$;
                return new NumericRange.Inclusive(new RichLong(l).min(b.start()), new RichLong(l2).max(b.end()), (Object)BoxesRunTime.boxToLong((long)1L), (Integral)Numeric.LongIsIntegral$.MODULE$);
            }
        });
    }

    public IndelRealignmentTarget merge(IndelRealignmentTarget target) {
        IndelRange[] currentIndelSet = (IndelRange[])this.indelSet().union(target.getIndelSet()).toArray(ClassTag$.MODULE$.apply(IndelRange.class));
        Sorting$.MODULE$.quickSort((Object)currentIndelSet, Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.conforms()));
        RangeAccumulator<Object> accumulator = new RangeAccumulator<Object>((List<Object>)Nil$.MODULE$, null);
        RangeAccumulator newIndelSetAccumulated = (RangeAccumulator)Predef$.MODULE$.refArrayOps((Object[])currentIndelSet).foldLeft(accumulator, (Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final RangeAccumulator<IndelRange> apply(RangeAccumulator<IndelRange> acc, IndelRange elem) {
                return acc.accumulate(elem);
            }
        });
        return newIndelSetAccumulated.previous() == null ? new IndelRealignmentTarget((Set<IndelRange>)newIndelSetAccumulated.data().toSet(), (Set<SNPRange>)((Set)this.snpSet().$plus$plus(target.getSNPSet()))) : new IndelRealignmentTarget((Set<IndelRange>)((Set)newIndelSetAccumulated.data().toSet().$plus(newIndelSetAccumulated.previous())), (Set<SNPRange>)((Set)this.snpSet().$plus$plus(target.getSNPSet())));
    }

    public boolean isEmpty() {
        return this.indelSet().isEmpty() && this.snpSet().isEmpty();
    }

    public NumericRange<Object> getReadRange() {
        if ((this.snpSet() != null || this.indelSet() != null) && this.readRange() == null) {
            this.log().warn("snpSet or indelSet non-empty but readRange empty!");
        }
        return this.readRange();
    }

    public long getSortKey() {
        long l;
        if (this.readRange() == null) {
            if (!this.getIndelSet().isEmpty() && this.getSNPSet().isEmpty()) {
                l = BoxesRunTime.unboxToLong((Object)((GenericRange)this.getIndelSet().head()).getReadRange().start());
            } else if (this.getIndelSet().isEmpty() && !this.getSNPSet().isEmpty()) {
                l = BoxesRunTime.unboxToLong((Object)((GenericRange)this.getSNPSet().head()).getReadRange().start());
            } else {
                this.log().error("unknown sort key for IndelRealignmentTarget");
                l = -1;
            }
        } else {
            l = BoxesRunTime.unboxToLong((Object)this.readRange().start());
        }
        return l;
    }

    public Set<SNPRange> getSNPSet() {
        return this.snpSet();
    }

    public Set<IndelRange> getIndelSet() {
        return this.indelSet();
    }

    public IndelRealignmentTarget(Set<IndelRange> indelSet, Set<SNPRange> snpSet) {
        this.indelSet = indelSet;
        this.snpSet = snpSet;
        Logging.class.$init$((Logging)this);
    }
}

