/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.metrics;

import org.bdgenomics.adam.avro.ADAMRecord;
import org.bdgenomics.adam.metrics.LongComparisons;
import org.bdgenomics.adam.models.ReadBucket;
import org.bdgenomics.adam.projections.ADAMRecordField$;
import org.bdgenomics.adam.projections.FieldEnumeration;
import org.bdgenomics.adam.projections.FieldValue;
import org.bdgenomics.adam.util.Util$;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;

public final class MappedPosition$
extends LongComparisons
implements Serializable {
    public static final MappedPosition$ MODULE$;
    private final String name;
    private final String description;

    static {
        new MappedPosition$();
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String description() {
        return this.description;
    }

    public long distance(Iterable<ADAMRecord> records1, Iterable<ADAMRecord> records2) {
        long l;
        if (records1.size() == records2.size()) {
            int n = records1.size();
            switch (n) {
                default: {
                    l = -1L;
                    break;
                }
                case 1: {
                    ADAMRecord r1 = (ADAMRecord)records1.head();
                    ADAMRecord r2 = (ADAMRecord)records2.head();
                    if (Util$.MODULE$.isSameContig(r1.getContig(), r2.getContig())) {
                        Long start1 = r1.getStart();
                        Long start2 = r2.getStart();
                        if (Predef$.MODULE$.Long2long(start1) > Predef$.MODULE$.Long2long(start2)) {
                            l = Predef$.MODULE$.Long2long(start1) - Predef$.MODULE$.Long2long(start2);
                            break;
                        }
                        l = Predef$.MODULE$.Long2long(start2) - Predef$.MODULE$.Long2long(start1);
                        break;
                    }
                    l = -1L;
                    break;
                }
                case 0: {
                    l = 0L;
                    break;
                }
            }
        } else {
            l = -1L;
        }
        return l;
    }

    @Override
    public Seq<Object> matchedByName(ReadBucket bucket1, ReadBucket bucket2) {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{this.distance(bucket1.unpairedPrimaryMappedReads(), bucket2.unpairedPrimaryMappedReads()) + this.distance(bucket1.pairedFirstPrimaryMappedReads(), bucket2.pairedFirstPrimaryMappedReads()) + this.distance(bucket1.pairedSecondPrimaryMappedReads(), bucket2.pairedSecondPrimaryMappedReads()) + this.distance(bucket1.pairedFirstSecondaryMappedReads(), bucket2.pairedFirstSecondaryMappedReads()) + this.distance(bucket1.pairedSecondSecondaryMappedReads(), bucket2.pairedSecondSecondaryMappedReads())}));
    }

    @Override
    public Seq<FieldValue> schemas() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FieldEnumeration.SchemaVal[]{ADAMRecordField$.MODULE$.start(), ADAMRecordField$.MODULE$.firstOfPair()}));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private MappedPosition$() {
        MODULE$ = this;
        this.name = "positions";
        this.description = "Counts how many reads align to the same genomic location";
    }
}

