/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.models;

import net.sf.samtools.SAMSequenceRecord;
import org.apache.avro.Schema;
import org.apache.avro.specific.SpecificRecord;
import org.bdgenomics.adam.avro.ADAMContig;
import org.bdgenomics.adam.avro.ADAMNucleotideContigFragment;
import org.bdgenomics.adam.avro.ADAMRecord;
import org.bdgenomics.adam.models.SequenceRecord;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

public final class SequenceRecord$
implements Serializable {
    public static final SequenceRecord$ MODULE$;
    private final String REFSEQ_TAG;
    private final String GENBANK_TAG;

    static {
        new SequenceRecord$();
    }

    public String REFSEQ_TAG() {
        return this.REFSEQ_TAG;
    }

    public String GENBANK_TAG() {
        return this.GENBANK_TAG;
    }

    public SequenceRecord apply(String name2, long length, CharSequence md5, CharSequence url, CharSequence refseq, CharSequence genbank, CharSequence assembly, CharSequence species) {
        Option option = Option$.MODULE$.apply((Object)url);
        Object object = !option.isEmpty() ? new Some((Object)((Object)((CharSequence)option.get())).toString()) : None$.MODULE$;
        Option option2 = Option$.MODULE$.apply((Object)md5);
        Option option3 = Option$.MODULE$.apply((Object)refseq);
        Option option4 = Option$.MODULE$.apply((Object)genbank);
        Option option5 = Option$.MODULE$.apply((Object)assembly);
        Option option6 = Option$.MODULE$.apply((Object)species);
        return new SequenceRecord(name2, length, (Option<String>)object, (Option<String>)(!option2.isEmpty() ? new Some((Object)((Object)((CharSequence)option2.get())).toString()) : None$.MODULE$), (Option<String>)(!option3.isEmpty() ? new Some((Object)((Object)((CharSequence)option3.get())).toString()) : None$.MODULE$), (Option<String>)(!option4.isEmpty() ? new Some((Object)((Object)((CharSequence)option4.get())).toString()) : None$.MODULE$), (Option<String>)(!option5.isEmpty() ? new Some((Object)((Object)((CharSequence)option5.get())).toString()) : None$.MODULE$), (Option<String>)(!option6.isEmpty() ? new Some((Object)((Object)((CharSequence)option6.get())).toString()) : None$.MODULE$));
    }

    public CharSequence apply$default$3() {
        return null;
    }

    public CharSequence apply$default$4() {
        return null;
    }

    public CharSequence apply$default$5() {
        return null;
    }

    public CharSequence apply$default$6() {
        return null;
    }

    public CharSequence apply$default$7() {
        return null;
    }

    public CharSequence apply$default$8() {
        return null;
    }

    public SequenceRecord fromSAMSequenceRecord(SAMSequenceRecord record) {
        return this.apply(record.getSequenceName(), record.getSequenceLength(), record.getAttribute("M5"), record.getAttribute("UR"), record.getAttribute(this.REFSEQ_TAG()), record.getAttribute(this.GENBANK_TAG()), record.getAssembly(), record.getAttribute("SP"));
    }

    public SAMSequenceRecord toSAMSequenceRecord(SequenceRecord record) {
        Option<String> option;
        SAMSequenceRecord sam = new SAMSequenceRecord(record.name(), (int)record.length());
        Option<String> option2 = record.md5();
        if (!option2.isEmpty()) {
            String string = (String)option2.get();
            sam.setAttribute("M5", string.toString());
        }
        if (!(option = record.url()).isEmpty()) {
            String string = (String)option.get();
            sam.setAttribute("UR", string.toString());
        }
        return sam;
    }

    public SequenceRecord fromADAMContig(ADAMContig contig) {
        String x$17 = ((Object)contig.getContigName()).toString();
        long x$18 = Predef$.MODULE$.Long2long(contig.getContigLength());
        CharSequence x$19 = contig.getContigName();
        CharSequence x$20 = contig.getReferenceURL();
        CharSequence x$21 = contig.getAssembly();
        CharSequence x$22 = contig.getSpecies();
        CharSequence x$23 = this.apply$default$5();
        CharSequence x$24 = this.apply$default$6();
        return this.apply(x$17, x$18, x$19, x$20, x$23, x$24, x$21, x$22);
    }

    public ADAMContig toADAMContig(SequenceRecord record) {
        Option<String> option;
        Option<String> option2;
        Option<String> option3;
        long l = record.length();
        Predef$ predef$ = Predef$.MODULE$;
        ADAMContig.Builder builder = ADAMContig.newBuilder().setContigName((CharSequence)record.name()).setContigLength(Long.valueOf(l));
        Option<String> option4 = record.md5();
        if (!option4.isEmpty()) {
            CharSequence charSequence = (CharSequence)option4.get();
            builder.setContigMD5(charSequence);
        }
        if (!(option3 = record.url()).isEmpty()) {
            CharSequence charSequence = (CharSequence)option3.get();
            builder.setReferenceURL(charSequence);
        }
        if (!(option2 = record.assembly()).isEmpty()) {
            CharSequence charSequence = (CharSequence)option2.get();
            builder.setAssembly(charSequence);
        }
        if (!(option = record.species()).isEmpty()) {
            CharSequence charSequence = (CharSequence)option.get();
            builder.setSpecies(charSequence);
        }
        return builder.build();
    }

    public SequenceRecord fromADAMContigFragment(ADAMNucleotideContigFragment fragment) {
        return this.fromADAMContig(fragment.getContig());
    }

    /*
     * Enabled aggressive block sorting
     */
    public Set<SequenceRecord> fromADAMRecord(ADAMRecord rec) {
        Set set;
        block6: {
            block5: {
                block4: {
                    boolean bl = rec != null;
                    Predef$ predef$ = Predef$.MODULE$;
                    if (!bl) {
                        throw new AssertionError((Object)new StringBuilder().append((Object)"assertion failed: ").append((Object)"ADAMRecord was null").toString());
                    }
                    Boolean bl2 = rec.getReadPaired();
                    Predef$ predef$2 = Predef$.MODULE$;
                    if (!bl2.booleanValue()) break block4;
                    Boolean bl3 = rec.getFirstOfPair();
                    Predef$ predef$3 = Predef$.MODULE$;
                    if (!bl3.booleanValue()) break block5;
                }
                if (rec.getContig() != null || rec.getMateContig() != null) break block6;
            }
            set = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
            return set;
        }
        set = ((TraversableOnce)((TraversableLike)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Option[]{Option$.MODULE$.apply((Object)rec.getContig()), Option$.MODULE$.apply((Object)rec.getMateContig())})).flatten((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Iterable<ADAMContig> apply(Option<ADAMContig> xo) {
                return Option$.MODULE$.option2Iterable(xo);
            }
        })).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final SequenceRecord apply(ADAMContig contig) {
                return SequenceRecord$.MODULE$.fromADAMContig(contig);
            }
        }, List$.MODULE$.canBuildFrom())).toSet();
        return set;
    }

    public SequenceRecord fromSpecificRecord(SpecificRecord rec) {
        SequenceRecord sequenceRecord;
        Schema schema = rec.getSchema();
        if (schema.getField("referenceId") == null) {
            if (schema.getField("contig") == null) {
                Predef$ predef$ = Predef$.MODULE$;
                if (!false) {
                    throw new AssertionError((Object)new StringBuilder().append((Object)"assertion failed: ").append((Object)"Missing information to generate SequenceRecord").toString());
                }
                sequenceRecord = null;
            } else {
                int pos = schema.getField("contig").pos();
                sequenceRecord = this.fromADAMContig((ADAMContig)rec.get(pos));
            }
        } else {
            String x$25 = rec.get(schema.getField("referenceName").pos()).toString();
            long x$26 = BoxesRunTime.unboxToLong((Object)rec.get(schema.getField("referenceLength").pos()));
            String x$27 = rec.get(schema.getField("referenceUrl").pos()).toString();
            SequenceRecord$ sequenceRecord$ = this;
            SequenceRecord$ sequenceRecord$2 = this;
            SequenceRecord$ sequenceRecord$3 = this;
            SequenceRecord$ sequenceRecord$4 = this;
            SequenceRecord$ sequenceRecord$5 = this;
            sequenceRecord = this.apply(x$25, x$26, null, x$27, null, null, null, null);
        }
        return sequenceRecord;
    }

    public Option<String> $lessinit$greater$default$3() {
        return None$.MODULE$;
    }

    public Option<String> $lessinit$greater$default$4() {
        return None$.MODULE$;
    }

    public Option<String> $lessinit$greater$default$5() {
        return None$.MODULE$;
    }

    public Option<String> $lessinit$greater$default$6() {
        return None$.MODULE$;
    }

    public Option<String> $lessinit$greater$default$7() {
        return None$.MODULE$;
    }

    public Option<String> $lessinit$greater$default$8() {
        return None$.MODULE$;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private SequenceRecord$() {
        MODULE$ = this;
        this.REFSEQ_TAG = "REFSEQ";
        this.GENBANK_TAG = "GENBANK";
    }
}

