/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.rdd;

import fi.tkk.ics.hadoop.bam.AnySAMInputFormat;
import fi.tkk.ics.hadoop.bam.SAMRecordWritable;
import fi.tkk.ics.hadoop.bam.util.SAMHeaderReader;
import java.util.Collection;
import java.util.regex.Pattern;
import net.sf.samtools.SAMFileHeader;
import org.apache.avro.Schema;
import org.apache.avro.specific.SpecificRecord;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.lib.input.TextInputFormat;
import org.apache.spark.Logging;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.bdgenomics.adam.avro.ADAMNucleotideContigFragment;
import org.bdgenomics.adam.avro.ADAMPileup;
import org.bdgenomics.adam.avro.ADAMRecord;
import org.bdgenomics.adam.converters.FastaConverter$;
import org.bdgenomics.adam.converters.SAMRecordConverter;
import org.bdgenomics.adam.models.ADAMRod;
import org.bdgenomics.adam.models.RecordGroupDictionary;
import org.bdgenomics.adam.models.RecordGroupDictionary$;
import org.bdgenomics.adam.models.SequenceDictionary;
import org.bdgenomics.adam.models.SequenceDictionary$;
import org.bdgenomics.adam.models.SequenceRecord;
import org.bdgenomics.adam.models.SequenceRecord$;
import org.bdgenomics.adam.predicates.ADAMPredicate;
import org.bdgenomics.adam.projections.ADAMNucleotideContigFragmentField$;
import org.bdgenomics.adam.projections.ADAMRecordField$;
import org.bdgenomics.adam.projections.FieldValue;
import org.bdgenomics.adam.projections.Projection$;
import org.bdgenomics.adam.rdd.ADAMContext$;
import org.bdgenomics.adam.rdd.ADAMNucleotideContigFragmentRDDFunctions;
import org.bdgenomics.adam.rdd.ADAMPileupRDDFunctions;
import org.bdgenomics.adam.rdd.ADAMRDDFunctions;
import org.bdgenomics.adam.rdd.ADAMRecordRDDFunctions;
import org.bdgenomics.adam.rdd.ADAMRodRDDFunctions;
import org.bdgenomics.adam.rich.RichADAMRecord;
import org.bdgenomics.adam.util.HadoopUtil$;
import org.slf4j.Logger;
import parquet.avro.AvroParquetInputFormat;
import parquet.avro.AvroReadSupport;
import parquet.filter.UnboundRecordFilter;
import parquet.hadoop.ParquetInputFormat;
import parquet.hadoop.util.ContextUtil;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0011Er!B\u0001\u0003\u0011\u0003Y\u0011aC!E\u00036\u001buN\u001c;fqRT!a\u0001\u0003\u0002\u0007I$GM\u0003\u0002\u0006\r\u0005!\u0011\rZ1n\u0015\t9\u0001\"\u0001\u0006cI\u001e,gn\\7jGNT\u0011!C\u0001\u0004_J<7\u0001\u0001\t\u0003\u00195i\u0011A\u0001\u0004\u0006\u001d\tA\ta\u0004\u0002\f\u0003\u0012\u000bUjQ8oi\u0016DHoE\u0002\u000e!Y\u0001\"!\u0005\u000b\u000e\u0003IQ\u0011aE\u0001\u0006g\u000e\fG.Y\u0005\u0003+I\u0011a!\u00118z%\u00164\u0007CA\t\u0018\u0013\tA\"C\u0001\u0007TKJL\u0017\r\\5{C\ndW\rC\u0003\u001b\u001b\u0011\u00051$\u0001\u0004=S:LGO\u0010\u000b\u0002\u0017!)Q$\u0004C\u0002=\u0005I2\u000f]1sW\u000e{g\u000e^3yiR{\u0017\tR!N\u0007>tG/\u001a=u)\ry\"q\n\t\u0003\u0019\u00012AA\u0004\u0002\u0001CM!\u0001\u0005\u0005\f#!\t\u0019\u0003&D\u0001%\u0015\t)c%A\u0003ta\u0006\u00148N\u0003\u0002(\u0011\u00051\u0011\r]1dQ\u0016L!!\u000b\u0013\u0003\u000f1{wmZ5oO\"A1\u0006\tB\u0001B\u0003%A&\u0001\u0002tGB\u00111%L\u0005\u0003]\u0011\u0012Ab\u00159be.\u001cuN\u001c;fqRDQA\u0007\u0011\u0005\u0002A\"\"aH\u0019\t\u000b-z\u0003\u0019\u0001\u0017\t\u000bM\u0002C\u0011\u0002\u001b\u0002+\u0005$\u0017-\u001c\"b[\u0012K7\r^5p]\u0006\u0014\u0018\u0010T8bIR\u0011Qg\u000f\t\u0003mej\u0011a\u000e\u0006\u0003q\u0011\ta!\\8eK2\u001c\u0018B\u0001\u001e8\u0005I\u0019V-];f]\u000e,G)[2uS>t\u0017M]=\t\u000bq\u0012\u0004\u0019A\u001f\u0002\u0011\u0019LG.\u001a)bi\"\u0004\"AP!\u000f\u0005Ey\u0014B\u0001!\u0013\u0003\u0019\u0001&/\u001a3fM&\u0011!i\u0011\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u0001\u0013\u0002\"B\u001a!\t\u0013)ECA\u001bG\u0011\u00159E\t1\u0001I\u0003%\u0019\u0018-\u001c%fC\u0012,'\u000f\u0005\u0002J!6\t!J\u0003\u0002L\u0019\u0006A1/Y7u_>d7O\u0003\u0002N\u001d\u0006\u00111O\u001a\u0006\u0002\u001f\u0006\u0019a.\u001a;\n\u0005ES%!D*B\u001b\u001aKG.\u001a%fC\u0012,'\u000fC\u0003TA\u0011%A+A\u000bbI\u0006l')Y7M_\u0006$'+Z1e\u000fJ|W\u000f]:\u0015\u0005UC\u0006C\u0001\u001cW\u0013\t9vGA\u000bSK\u000e|'\u000fZ$s_V\u0004H)[2uS>t\u0017M]=\t\u000b\u001d\u0013\u0006\u0019\u0001%\t\ri\u0003C\u0011\u0003\u0002\\\u0003-\tG-Y7CC6du.\u00193\u0015\u0005q;\u0007cA/`C6\taL\u0003\u0002\u0004I%\u0011\u0001M\u0018\u0002\u0004%\u0012#\u0005C\u00012f\u001b\u0005\u0019'B\u00013\u0005\u0003\u0011\tgO]8\n\u0005\u0019\u001c'AC!E\u00036\u0013VmY8sI\")A(\u0017a\u0001{!)\u0011\u000e\tC\u0005U\u0006y\u0011\rZ1n!\u0006\u0014\u0018/^3u\u0019>\fG-\u0006\u0003la\u0006%Bc\u00027\u0002\u0016\u0005]\u0011q\b\u000b\u0005[f\fY\u0001E\u0002^?:\u0004\"a\u001c9\r\u0001\u0011)\u0011\u000f\u001bb\u0001e\n\tA+\u0005\u0002tmB\u0011\u0011\u0003^\u0005\u0003kJ\u0011qAT8uQ&tw\r\u0005\u0002\u0012o&\u0011\u0001P\u0005\u0002\u0004\u0003:L\bb\u0002>i\u0003\u0003\u0005\u001da_\u0001\u000bKZLG-\u001a8dK\u0012\u001a\u0004\u0003B\t}]zL!! \n\u0003\u0013\u0019+hn\u0019;j_:\f\u0004cA@\u0002\b5\u0011\u0011\u0011\u0001\u0006\u0005\u0003\u0007\t)!\u0001\u0005ta\u0016\u001c\u0017NZ5d\u0015\t!g%\u0003\u0003\u0002\n\u0005\u0005!AD*qK\u000eLg-[2SK\u000e|'\u000f\u001a\u0005\n\u0003\u001bA\u0017\u0011!a\u0002\u0003\u001f\t!\"\u001a<jI\u0016t7-\u001a\u00135!\u0011q\u0014\u0011\u00038\n\u0007\u0005M1I\u0001\u0005NC:Lg-Z:u\u0011\u0015a\u0004\u000e1\u0001>\u0011%\tI\u0002\u001bI\u0001\u0002\u0004\tY\"A\u0005qe\u0016$\u0017nY1uKB)\u0011#!\b\u0002\"%\u0019\u0011q\u0004\n\u0003\r=\u0003H/[8o!\u0015q\u00141EA\u0014\u0013\r\t)c\u0011\u0002\u0006\u00072\f7o\u001d\t\u0004_\u0006%BaBA\u0016Q\n\u0007\u0011Q\u0006\u0002\u0002+F\u00191/a\f\u0011\t\u0005E\u00121H\u0007\u0003\u0003gQA!!\u000e\u00028\u00051a-\u001b7uKJT!!!\u000f\u0002\u000fA\f'/];fi&!\u0011QHA\u001a\u0005M)fNY8v]\u0012\u0014VmY8sI\u001aKG\u000e^3s\u0011%\t\t\u0005\u001bI\u0001\u0002\u0004\t\u0019%\u0001\u0006qe>TWm\u0019;j_:\u0004R!EA\u000f\u0003\u000b\u0002B!a\u0012\u0002J5\u0011\u0011QA\u0005\u0005\u0003\u0017\n)A\u0001\u0004TG\",W.\u0019\u0005\b\u0003\u001f\u0002C\u0011AA)\u0003I\tG-Y7ES\u000e$\u0018n\u001c8befdu.\u00193\u0016\t\u0005M\u0013q\f\u000b\u0005\u0003+\n9\u0007F\u00036\u0003/\n\t\u0007\u0003\u0006\u0002Z\u00055\u0013\u0011!a\u0002\u00037\n!\"\u001a<jI\u0016t7-\u001a\u00136!\u0015\tB0!\u0018\u007f!\ry\u0017q\f\u0003\u0007c\u00065#\u0019\u0001:\t\u0015\u0005\r\u0014QJA\u0001\u0002\b\t)'\u0001\u0006fm&$WM\\2fIY\u0002RAPA\t\u0003;Ba\u0001PA'\u0001\u0004i\u0004bBA6A\u0011\u0005\u0011QN\u0001\tC\u0012\fW\u000eT8bIV1\u0011qNA<\u0003\u001f#\u0002\"!\u001d\u0002\u0006\u0006\u001d\u0015q\u0014\u000b\u0007\u0003g\nI(a \u0011\tu{\u0016Q\u000f\t\u0004_\u0006]DAB9\u0002j\t\u0007!\u000f\u0003\u0006\u0002|\u0005%\u0014\u0011!a\u0002\u0003{\n!\"\u001a<jI\u0016t7-\u001a\u00138!\u0015\tB0!\u001e\u007f\u0011)\t\t)!\u001b\u0002\u0002\u0003\u000f\u00111Q\u0001\u000bKZLG-\u001a8dK\u0012B\u0004#\u0002 \u0002\u0012\u0005U\u0004B\u0002\u001f\u0002j\u0001\u0007Q\b\u0003\u0006\u0002\u001a\u0005%\u0004\u0013!a\u0001\u0003\u0013\u0003R!EA\u000f\u0003\u0017\u0003RAPA\u0012\u0003\u001b\u00032a\\AH\t!\tY#!\u001bC\u0002\u0005E\u0015cA:\u0002\u0014B1\u0011QSAN\u0003kj!!a&\u000b\u0007\u0005eE!\u0001\u0006qe\u0016$\u0017nY1uKNLA!!(\u0002\u0018\ni\u0011\tR!N!J,G-[2bi\u0016D!\"!\u0011\u0002jA\u0005\t\u0019AA\"\u0011\u001d\t\u0019\u000b\tC\u0001\u0003K\u000b\u0001#\u00193b[N+\u0017/^3oG\u0016du.\u00193\u0015\r\u0005\u001d\u0016qVAY!\u0011iv,!+\u0011\u0007\t\fY+C\u0002\u0002.\u000e\u0014A$\u0011#B\u001b:+8\r\\3pi&$WmQ8oi&<gI]1h[\u0016tG\u000f\u0003\u0004=\u0003C\u0003\r!\u0010\u0005\t\u0003g\u000b\t\u000b1\u0001\u00026\u0006qaM]1h[\u0016tG\u000fT3oORD\u0007cA\t\u00028&\u0019\u0011\u0011\u0018\n\u0003\t1{gn\u001a\u0005\b\u0003{\u0003C\u0011AA`\u0003%1\u0017N\u001c3GS2,7\u000f\u0006\u0004\u0002B\u0006%\u0018Q\u001e\t\u0007\u0003\u0007\f\u0019.!7\u000f\t\u0005\u0015\u0017q\u001a\b\u0005\u0003\u000f\fi-\u0004\u0002\u0002J*\u0019\u00111\u001a\u0006\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0019\u0012bAAi%\u00059\u0001/Y2lC\u001e,\u0017\u0002BAk\u0003/\u00141aU3r\u0015\r\t\tN\u0005\t\u0005\u00037\f)/\u0004\u0002\u0002^*!\u0011q\\Aq\u0003\t17OC\u0002\u0002d\u001a\na\u0001[1e_>\u0004\u0018\u0002BAt\u0003;\u0014A\u0001U1uQ\"A\u00111^A^\u0001\u0004\tI.\u0001\u0003qCRD\u0007bBAx\u0003w\u0003\r!P\u0001\u0006e\u0016<W\r\u001f\u0005\b\u0003g\u0004C\u0011AA{\u0003Eaw.\u00193B\t\u0006keI]8n!\u0006$\bn\u001d\u000b\u00049\u0006]\b\u0002CA}\u0003c\u0004\r!!1\u0002\u000bA\fG\u000f[:\t\u0013\u0005u\b%%A\u0005\n\u0005}\u0018!G1eC6\u0004\u0016M]9vKRdu.\u00193%I\u00164\u0017-\u001e7uII*bA!\u0001\u0003\u001e\t}QC\u0001B\u0002U\u0011\u0011)Aa\u0003\u000f\u0007E\u00119!C\u0002\u0003\nI\tAAT8oK.\u0012!Q\u0002\t\u0005\u0005\u001f\u0011I\"\u0004\u0002\u0003\u0012)!!1\u0003B\u000b\u0003%)hn\u00195fG.,GMC\u0002\u0003\u0018I\t!\"\u00198o_R\fG/[8o\u0013\u0011\u0011YB!\u0005\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r\u0002\u0004r\u0003w\u0014\rA\u001d\u0003\t\u0003W\tYP1\u0001\u0002.!I!1\u0005\u0011\u0012\u0002\u0013%!QE\u0001\u001aC\u0012\fW\u000eU1scV,G\u000fT8bI\u0012\"WMZ1vYR$3'\u0006\u0004\u0003(\t-\"QF\u000b\u0003\u0005SQC!a\u0011\u0003\f\u00111\u0011O!\tC\u0002I$\u0001\"a\u000b\u0003\"\t\u0007\u0011Q\u0006\u0005\n\u0005c\u0001\u0013\u0013!C\u0001\u0005g\t!#\u00193b[2{\u0017\r\u001a\u0013eK\u001a\fW\u000f\u001c;%eU1!\u0011\u0001B\u001b\u0005o!a!\u001dB\u0018\u0005\u0004\u0011H\u0001CA\u0016\u0005_\u0011\rA!\u000f\u0012\u0007M\u0014Y\u0004\u0005\u0004\u0002\u0016\u0006m%Q\b\t\u0004_\nU\u0002\"\u0003B!AE\u0005I\u0011\u0001B\"\u0003I\tG-Y7M_\u0006$G\u0005Z3gCVdG\u000fJ\u001a\u0016\r\t\u001d\"Q\tB$\t\u0019\t(q\bb\u0001e\u0012A\u00111\u0006B \u0005\u0004\u0011I%E\u0002t\u0005\u0017\u0002b!!&\u0002\u001c\n5\u0003cA8\u0003F!)1\u0006\ba\u0001Y!9!1K\u0007\u0005\u0004\tU\u0013A\u0005:eIR{\u0017\tR!N%\u0016\u001cwN\u001d3S\t\u0012#BAa\u0016\u0003^A\u0019AB!\u0017\n\u0007\tm#A\u0001\fB\t\u0006k%+Z2pe\u0012\u0014F\t\u0012$v]\u000e$\u0018n\u001c8t\u0011\u0019\u0019!\u0011\u000ba\u00019\"9!\u0011M\u0007\u0005\u0004\t\r\u0014A\u0005:eIR{\u0017\tR!N!&dW-\u001e9S\t\u0012#BA!\u001a\u0003lA\u0019ABa\u001a\n\u0007\t%$A\u0001\fB\t\u0006k\u0005+\u001b7fkB\u0014F\t\u0012$v]\u000e$\u0018n\u001c8t\u0011\u001d\u0019!q\fa\u0001\u0005[\u0002B!X0\u0003pA\u0019!M!\u001d\n\u0007\tM4M\u0001\u0006B\t\u0006k\u0005+\u001b7fkBDqAa\u001e\u000e\t\u0007\u0011I(A\bsI\u0012$v.\u0011#B\u001bJ{GM\u0015#E)\u0011\u0011YH!!\u0011\u00071\u0011i(C\u0002\u0003\u0000\t\u00111#\u0011#B\u001bJ{GM\u0015#E\rVt7\r^5p]NDqa\u0001B;\u0001\u0004\u0011\u0019\t\u0005\u0003^?\n\u0015\u0005c\u0001\u001c\u0003\b&\u0019!\u0011R\u001c\u0003\u000f\u0005#\u0015)\u0014*pI\"9!QR\u0007\u0005\u0004\t=\u0015\u0001\u0004:eIR{\u0017\tR!N%\u0012#U\u0003\u0002BI\u0005;#BAa%\u0003,R1!Q\u0013BP\u0005K\u0003R\u0001\u0004BL\u00057K1A!'\u0003\u0005A\tE)Q'S\t\u00123UO\\2uS>t7\u000fE\u0002p\u0005;#a!\u001dBF\u0005\u0004\u0011\bB\u0003BQ\u0005\u0017\u000b\t\u0011q\u0001\u0003$\u0006QQM^5eK:\u001cW\rJ\u0019\u0011\u000bEa(1\u0014@\t\u0015\t\u001d&1RA\u0001\u0002\b\u0011I+\u0001\u0006fm&$WM\\2fII\u0002RAPA\t\u00057Cqa\u0001BF\u0001\u0004\u0011i\u000b\u0005\u0003^?\nm\u0005b\u0002BG\u001b\u0011\r!\u0011\u0017\u000b\u0005\u0005g\u0013I\fE\u0002\r\u0005kK1Aa.\u0003\u0005!\nE)Q'Ok\u000edWm\u001c;jI\u0016\u001cuN\u001c;jO\u001a\u0013\u0018mZ7f]R\u0014F\t\u0012$v]\u000e$\u0018n\u001c8t\u0011\u001d\u0019!q\u0016a\u0001\u0003OCqA!0\u000e\t\u0007\u0011y,\u0001\nsK\u000e|'\u000f\u001a+p%&\u001c\u0007NU3d_J$G\u0003\u0002Ba\u0005\u001b\u0004BAa1\u0003J6\u0011!Q\u0019\u0006\u0004\u0005\u000f$\u0011\u0001\u0002:jG\"LAAa3\u0003F\nq!+[2i\u0003\u0012\u000bUJU3d_J$\u0007b\u0002Bh\u0005w\u0003\r!Y\u0001\u0007e\u0016\u001cwN\u001d3\t\u000f\tMW\u0002b\u0001\u0003V\u0006qA.[:u)>T\u0015M^1MSN$X\u0003\u0002Bl\u0005W$BA!7\u0003pB1!1\u001cBs\u0005Sl!A!8\u000b\t\t}'\u0011]\u0001\u0005kRLGN\u0003\u0002\u0003d\u0006!!.\u0019<b\u0013\u0011\u00119O!8\u0003\t1K7\u000f\u001e\t\u0004_\n-Ha\u0002Bw\u0005#\u0014\rA\u001d\u0002\u0002\u0003\"A!\u0011\u001fBi\u0001\u0004\u0011\u00190\u0001\u0003mSN$\bCBAb\u0005k\u0014I/\u0003\u0003\u0003h\u0006]\u0007b\u0002B}\u001b\u0011\r!1`\u0001\u000fU\u00064\u0018\rT5tiR{G*[:u+\u0011\u0011ipa\u0001\u0015\t\t}8Q\u0001\t\u0007\u0003\u0007\u0014)p!\u0001\u0011\u0007=\u001c\u0019\u0001B\u0004\u0003n\n](\u0019\u0001:\t\u0011\tE(q\u001fa\u0001\u0007\u000f\u0001bAa7\u0003f\u000e\u0005\u0001bBB\u0006\u001b\u0011\r1QB\u0001\rU\u00064\u0018mU3u)>\u001cV\r^\u000b\u0005\u0007\u001f\u0019I\u0002\u0006\u0003\u0004\u0012\rm\u0001#\u0002 \u0004\u0014\r]\u0011bAB\u000b\u0007\n\u00191+\u001a;\u0011\u0007=\u001cI\u0002B\u0004\u0003n\u000e%!\u0019\u0001:\t\u0011\ru1\u0011\u0002a\u0001\u0007?\t1a]3u!\u0019\u0011Yn!\t\u0004\u0018%!1Q\u0003Bo\u0011\u001d\u0019)#\u0004C\u0002\u0007O\t\u0001$\u001b8u\u0019&\u001cH\u000fV8KCZ\f\u0017J\u001c;fO\u0016\u0014H*[:u)\u0011\u0019Ica\u000e\u0011\r\tm'Q]B\u0016!\u0011\u0019ica\r\u000e\u0005\r=\"\u0002BB\u0019\u0005C\fA\u0001\\1oO&!1QGB\u0018\u0005\u001dIe\u000e^3hKJD\u0001B!=\u0004$\u0001\u00071\u0011\b\t\u0007\u0003\u0007\u0014)pa\u000f\u0011\u0007E\u0019i$C\u0002\u0004@I\u00111!\u00138u\u0011\u001d\u0019\u0019%\u0004C\u0002\u0007\u000b\nAc\u00195beN+\u0017/^3oG\u0016$vn\u0015;sS:<GcA\u001f\u0004H!A1\u0011JB!\u0001\u0004\u0019Y%\u0001\u0002dgB!1QFB'\u0013\u0011\u0019yea\f\u0003\u0019\rC\u0017M]*fcV,gnY3\t\u000f\rMS\u0002b\u0001\u0004V\u0005\u00112\r[1s'\u0016\fX/\u001a8dKR{G*[:u)\u0011\u00199fa\u0018\u0011\r\u0005\r'Q_B-!\r\t21L\u0005\u0004\u0007;\u0012\"\u0001B\"iCJD\u0001b!\u0013\u0004R\u0001\u000711\n\u0005\b\u0007GjA1AB3\u00031i\u0017\r\u001d+p\u0015\u00064\u0018-T1q+\u0019\u00199g!\u001d\u0004vQ!1\u0011NB=!!\u0011Yna\u001b\u0004p\rM\u0014\u0002BB7\u0005;\u00141!T1q!\ry7\u0011\u000f\u0003\b\u0005[\u001c\tG1\u0001s!\ry7Q\u000f\u0003\b\u0007o\u001a\tG1\u0001s\u0005\u0005\u0011\u0005\u0002CB>\u0007C\u0002\ra! \u0002\u00075\f\u0007\u000f\u0005\u0005\u0004\u0000\r\u00155qNB:\u001b\t\u0019\tIC\u0002\u0004\u0004J\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0019ig!!\t\u000f\r%U\u0002b\u0001\u0004\f\u0006A\u0012\u000e^3sC\ndW\rV8KCZ\f7i\u001c7mK\u000e$\u0018n\u001c8\u0016\t\r55q\u0013\u000b\u0005\u0007\u001f\u001bI\n\u0005\u0004\u0003\\\u000eE5QS\u0005\u0005\u0007'\u0013iN\u0001\u0006D_2dWm\u0019;j_:\u00042a\\BL\t\u001d\u0011ioa\"C\u0002ID\u0001ba'\u0004\b\u0002\u00071QT\u0001\u0002SB1\u00111YBP\u0007+KAa!)\u0002X\nA\u0011\n^3sC\ndW\rC\u0004\u0004&6!\u0019aa*\u0002\u0019M,G\u000fV8KCZ\f7+\u001a;\u0016\t\r%6q\u0016\u000b\u0005\u0007W\u001b\t\f\u0005\u0004\u0003\\\u000e\u00052Q\u0016\t\u0004_\u000e=Fa\u0002Bw\u0007G\u0013\rA\u001d\u0005\t\u0007;\u0019\u0019\u000b1\u0001\u00044B)aha\u0005\u0004.\"91qW\u0007\u0005\u0002\re\u0016AE2sK\u0006$Xm\u00159be.\u001cuN\u001c;fqR$2\u0003LB^\u0007\u007f\u001b\u0019ma2\u0004N\u000ee71]Bt\u0007WDqa!0\u00046\u0002\u0007Q(\u0001\u0003oC6,\u0007bBBa\u0007k\u0003\r!P\u0001\u0007[\u0006\u001cH/\u001a:\t\u0013\r\u00157Q\u0017I\u0001\u0002\u0004i\u0014!C:qCJ\\\u0007j\\7f\u0011)\u0019Im!.\u0011\u0002\u0003\u000711Z\u0001\ngB\f'o\u001b&beN\u0004R!a1\u0002TvB!ba4\u00046B\u0005\t\u0019ABi\u00031\u0019\b/\u0019:l\u000b:4h+\u0019:t!\u0019\t\u0019-a5\u0004TB)\u0011c!6>{%\u00191q\u001b\n\u0003\rQ+\b\u000f\\33\u0011)\u0019Yn!.\u0011\u0002\u0003\u00071Q\\\u0001\u0016gB\f'o[!eIN#\u0018\r^:MSN$XM\\3s!\r\t2q\\\u0005\u0004\u0007C\u0014\"a\u0002\"p_2,\u0017M\u001c\u0005\u000b\u0007K\u001c)\f%AA\u0002\rm\u0012aE:qCJ\\7J]=p\u0005V4g-\u001a:TSj,\u0007BCBu\u0007k\u0003\n\u00111\u0001\u0004^\u0006\u0001Bn\\1e'f\u001cH/Z7WC2,Xm\u001d\u0005\u000b\u0007[\u001c)\f%AA\u0002\r=\u0018aD:qCJ\\GI]5wKJ\u0004vN\u001d;\u0011\u000bE\tiba\u000f\t\u0013\rMX\"%A\u0005\u0002\rU\u0018\u0001H2sK\u0006$Xm\u00159be.\u001cuN\u001c;fqR$C-\u001a4bk2$HeM\u000b\u0003\u0007oT3!\u0010B\u0006\u0011%\u0019Y0DI\u0001\n\u0003\u0019i0\u0001\u000fde\u0016\fG/Z*qCJ\\7i\u001c8uKb$H\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\r}(\u0006BBf\u0005\u0017A\u0011\u0002b\u0001\u000e#\u0003%\t\u0001\"\u0002\u00029\r\u0014X-\u0019;f'B\f'o[\"p]R,\u0007\u0010\u001e\u0013eK\u001a\fW\u000f\u001c;%kU\u0011Aq\u0001\u0016\u0005\u0007#\u0014Y\u0001C\u0005\u0005\f5\t\n\u0011\"\u0001\u0005\u000e\u0005a2M]3bi\u0016\u001c\u0006/\u0019:l\u0007>tG/\u001a=uI\u0011,g-Y;mi\u00122TC\u0001C\bU\u0011\u0019iNa\u0003\t\u0013\u0011MQ\"%A\u0005\u0002\u0011U\u0011\u0001H2sK\u0006$Xm\u00159be.\u001cuN\u001c;fqR$C-\u001a4bk2$HeN\u000b\u0003\t/QCaa\u000f\u0003\f!IA1D\u0007\u0012\u0002\u0013\u0005AQB\u0001\u001dGJ,\u0017\r^3Ta\u0006\u00148nQ8oi\u0016DH\u000f\n3fM\u0006,H\u000e\u001e\u00139\u0011%!y\"DI\u0001\n\u0003!\t#\u0001\u000fde\u0016\fG/Z*qCJ\\7i\u001c8uKb$H\u0005Z3gCVdG\u000fJ\u001d\u0016\u0005\u0011\r\"\u0006BBx\u0005\u0017A\u0011\u0002b\n\u000e\u0003\u0003%I\u0001\"\u000b\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\tW\u0001Ba!\f\u0005.%!AqFB\u0018\u0005\u0019y%M[3di\u0002")
public class ADAMContext
implements Serializable,
Logging {
    private final SparkContext sc;
    private transient Logger org$apache$spark$Logging$$log_;

    public static Option<Object> createSparkContext$default$9() {
        return ADAMContext$.MODULE$.createSparkContext$default$9();
    }

    public static boolean createSparkContext$default$8() {
        return ADAMContext$.MODULE$.createSparkContext$default$8();
    }

    public static int createSparkContext$default$7() {
        return ADAMContext$.MODULE$.createSparkContext$default$7();
    }

    public static boolean createSparkContext$default$6() {
        return ADAMContext$.MODULE$.createSparkContext$default$6();
    }

    public static Seq<Tuple2<String, String>> createSparkContext$default$5() {
        return ADAMContext$.MODULE$.createSparkContext$default$5();
    }

    public static Seq<String> createSparkContext$default$4() {
        return ADAMContext$.MODULE$.createSparkContext$default$4();
    }

    public static String createSparkContext$default$3() {
        return ADAMContext$.MODULE$.createSparkContext$default$3();
    }

    public static SparkContext createSparkContext(String string, String string2, String string3, Seq<String> seq, Seq<Tuple2<String, String>> seq2, boolean bl, int n, boolean bl2, Option<Object> option) {
        return ADAMContext$.MODULE$.createSparkContext(string, string2, string3, seq, seq2, bl, n, bl2, option);
    }

    public static <A> java.util.Set<A> setToJavaSet(scala.collection.immutable.Set<A> set) {
        return ADAMContext$.MODULE$.setToJavaSet(set);
    }

    public static <A> Collection<A> iterableToJavaCollection(Iterable<A> iterable) {
        return ADAMContext$.MODULE$.iterableToJavaCollection(iterable);
    }

    public static <A, B> java.util.Map<A, B> mapToJavaMap(Map<A, B> map) {
        return ADAMContext$.MODULE$.mapToJavaMap(map);
    }

    public static List<Object> charSequenceToList(CharSequence charSequence) {
        return ADAMContext$.MODULE$.charSequenceToList(charSequence);
    }

    public static String charSequenceToString(CharSequence charSequence) {
        return ADAMContext$.MODULE$.charSequenceToString(charSequence);
    }

    public static java.util.List<Integer> intListToJavaIntegerList(List<Object> list) {
        return ADAMContext$.MODULE$.intListToJavaIntegerList(list);
    }

    public static <A> scala.collection.immutable.Set<A> javaSetToSet(java.util.Set<A> set) {
        return ADAMContext$.MODULE$.javaSetToSet(set);
    }

    public static <A> List<A> javaListToList(java.util.List<A> list) {
        return ADAMContext$.MODULE$.javaListToList(list);
    }

    public static <A> java.util.List<A> listToJavaList(List<A> list) {
        return ADAMContext$.MODULE$.listToJavaList(list);
    }

    public static RichADAMRecord recordToRichRecord(ADAMRecord aDAMRecord) {
        return ADAMContext$.MODULE$.recordToRichRecord(aDAMRecord);
    }

    public static ADAMNucleotideContigFragmentRDDFunctions rddToADAMRDD(RDD<ADAMNucleotideContigFragment> rDD) {
        return ADAMContext$.MODULE$.rddToADAMRDD(rDD);
    }

    public static <T> ADAMRDDFunctions<T> rddToADAMRDD(RDD<T> rDD, Function1<T, SpecificRecord> function1, Manifest<T> manifest) {
        return ADAMContext$.MODULE$.rddToADAMRDD(rDD, function1, manifest);
    }

    public static ADAMRodRDDFunctions rddToADAMRodRDD(RDD<ADAMRod> rDD) {
        return ADAMContext$.MODULE$.rddToADAMRodRDD(rDD);
    }

    public static ADAMPileupRDDFunctions rddToADAMPileupRDD(RDD<ADAMPileup> rDD) {
        return ADAMContext$.MODULE$.rddToADAMPileupRDD(rDD);
    }

    public static ADAMRecordRDDFunctions rddToADAMRecordRDD(RDD<ADAMRecord> rDD) {
        return ADAMContext$.MODULE$.rddToADAMRecordRDD(rDD);
    }

    public static ADAMContext sparkContextToADAMContext(SparkContext sparkContext) {
        return ADAMContext$.MODULE$.sparkContextToADAMContext(sparkContext);
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    private SequenceDictionary adamBamDictionaryLoad(String filePath) {
        SAMFileHeader samHeader = SAMHeaderReader.readSAMHeaderFrom((Path)new Path(filePath), (Configuration)this.sc.hadoopConfiguration());
        return this.adamBamDictionaryLoad(samHeader);
    }

    private SequenceDictionary adamBamDictionaryLoad(SAMFileHeader samHeader) {
        return SequenceDictionary$.MODULE$.apply(samHeader);
    }

    private RecordGroupDictionary adamBamLoadReadGroups(SAMFileHeader samHeader) {
        return RecordGroupDictionary$.MODULE$.fromSAMHeader(samHeader);
    }

    public RDD<ADAMRecord> adamBamLoad(String filePath) {
        Predef$ predef$ = Predef$.MODULE$;
        this.log().info(new StringOps("Reading legacy BAM file format %s to create RDD").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{filePath})));
        SAMFileHeader samHeader = SAMHeaderReader.readSAMHeaderFrom((Path)new Path(filePath), (Configuration)this.sc.hadoopConfiguration());
        SequenceDictionary seqDict = this.adamBamDictionaryLoad(samHeader);
        RecordGroupDictionary readGroups = this.adamBamLoadReadGroups(samHeader);
        Job job = HadoopUtil$.MODULE$.newJob(this.sc);
        RDD records = this.sc.newAPIHadoopFile(filePath, AnySAMInputFormat.class, LongWritable.class, SAMRecordWritable.class, ContextUtil.getConfiguration((JobContext)job));
        SAMRecordConverter samRecordConverter = new SAMRecordConverter();
        return records.map((Function1)new Serializable(this, seqDict, readGroups, samRecordConverter){
            public static final long serialVersionUID = 0L;
            private final SequenceDictionary seqDict$1;
            private final RecordGroupDictionary readGroups$1;
            private final SAMRecordConverter samRecordConverter$1;

            public final ADAMRecord apply(Tuple2<LongWritable, SAMRecordWritable> p) {
                return this.samRecordConverter$1.convert(((SAMRecordWritable)p._2()).get(), this.seqDict$1, this.readGroups$1);
            }
            {
                this.seqDict$1 = seqDict$1;
                this.readGroups$1 = readGroups$1;
                this.samRecordConverter$1 = samRecordConverter$1;
            }
        }, ClassTag$.MODULE$.apply(ADAMRecord.class));
    }

    private <T, U extends UnboundRecordFilter> RDD<T> adamParquetLoad(String filePath, Option<Class<U>> predicate, Option<Schema> projection, Function1<T, SpecificRecord> evidence$3, Manifest<T> evidence$4) {
        Predef$ predef$ = Predef$.MODULE$;
        this.log().info(new StringOps("Reading the ADAM file at %s to create RDD").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{filePath})));
        Job job = HadoopUtil$.MODULE$.newJob(this.sc);
        ParquetInputFormat.setReadSupportClass((Job)job, AvroReadSupport.class);
        if (predicate.isDefined()) {
            this.log().info("Using the specified push-down predicate");
            ParquetInputFormat.setUnboundRecordFilter((Job)job, (Class)((Class)predicate.get()));
        }
        if (projection.isDefined()) {
            this.log().info("Using the specified projection schema");
            AvroParquetInputFormat.setRequestedProjection((Job)job, (Schema)((Schema)projection.get()));
        }
        RDD records = this.sc.newAPIHadoopFile(filePath, ParquetInputFormat.class, Void.class, Predef$.MODULE$.manifest(evidence$4).runtimeClass(), ContextUtil.getConfiguration((JobContext)job)).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final T apply(Tuple2<Void, T> p) {
                return (T)p._2();
            }
        }, evidence$4);
        return predicate.isDefined() ? records.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(T p) {
                return p != null;
            }
        }) : records;
    }

    private <T, U extends UnboundRecordFilter> None$ adamParquetLoad$default$2() {
        return None$.MODULE$;
    }

    private <T, U extends UnboundRecordFilter> Option<Schema> adamParquetLoad$default$3() {
        return None$.MODULE$;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <T> SequenceDictionary adamDictionaryLoad(String filePath, Function1<T, SpecificRecord> evidence$5, Manifest<T> evidence$6) {
        SequenceDictionary sequenceDictionary;
        Schema projection;
        boolean isADAMRecord = ADAMRecord.class.isAssignableFrom(Predef$.MODULE$.manifest(evidence$6).runtimeClass());
        boolean isADAMContig = ADAMNucleotideContigFragment.class.isAssignableFrom(Predef$.MODULE$.manifest(evidence$6).runtimeClass());
        Schema schema = isADAMRecord ? Projection$.MODULE$.apply((Seq<FieldValue>)Predef$.MODULE$.wrapRefArray((Object[])new FieldValue[]{ADAMRecordField$.MODULE$.contig(), ADAMRecordField$.MODULE$.mateContig(), ADAMRecordField$.MODULE$.readPaired(), ADAMRecordField$.MODULE$.firstOfPair(), ADAMRecordField$.MODULE$.readMapped(), ADAMRecordField$.MODULE$.mateMapped()})) : (projection = isADAMContig ? Projection$.MODULE$.apply((Seq<FieldValue>)Predef$.MODULE$.wrapRefArray((Object[])new FieldValue[]{ADAMNucleotideContigFragmentField$.MODULE$.contig()})) : Projection$.MODULE$.apply((Seq<FieldValue>)Predef$.MODULE$.wrapRefArray((Object[])new FieldValue[]{ADAMRecordField$.MODULE$.contig()})));
        if (filePath.endsWith(".bam") || filePath.endsWith(".sam")) {
            if (!isADAMRecord) throw new IllegalArgumentException("If you're reading a BAM/SAM file, the record type must be ADAMRecord");
            sequenceDictionary = this.adamBamDictionaryLoad(filePath);
            return sequenceDictionary;
        } else {
            SequenceDictionary dict;
            RDD<T> projected = this.adamParquetLoad(filePath, (Option)None$.MODULE$, (Option<Schema>)new Some((Object)projection), evidence$5, evidence$6);
            RDD recs = isADAMRecord ? projected.distinct().flatMap((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Set<SequenceRecord> apply(ADAMRecord rec) {
                    return SequenceRecord$.MODULE$.fromADAMRecord(rec);
                }
            }, ClassTag$.MODULE$.apply(SequenceRecord.class)) : (isADAMContig ? projected.distinct().map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final SequenceRecord apply(ADAMNucleotideContigFragment ctg) {
                    return SequenceRecord$.MODULE$.fromADAMContigFragment(ctg);
                }
            }, ClassTag$.MODULE$.apply(SequenceRecord.class)) : projected.distinct().map((Function1)new Serializable(this, evidence$5){
                public static final long serialVersionUID = 0L;
                private final Function1 evidence$5$1;

                public final SequenceRecord apply(T x$1) {
                    return SequenceRecord$.MODULE$.fromSpecificRecord((SpecificRecord)this.evidence$5$1.apply(x$1));
                }
                {
                    this.evidence$5$1 = evidence$5$1;
                }
            }, ClassTag$.MODULE$.apply(SequenceRecord.class)));
            sequenceDictionary = dict = (SequenceDictionary)recs.aggregate((Object)SequenceDictionary$.MODULE$.apply(), (Function2)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final SequenceDictionary apply(SequenceDictionary dict, SequenceRecord rec) {
                    return dict.$plus(rec);
                }
            }, (Function2)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final SequenceDictionary apply(SequenceDictionary dict1, SequenceDictionary dict2) {
                    return dict1.$plus$plus(dict2);
                }
            }, ClassTag$.MODULE$.apply(SequenceDictionary.class));
        }
        return sequenceDictionary;
    }

    public <T, U extends ADAMPredicate<T>> RDD<T> adamLoad(String filePath, Option<Class<U>> predicate, Option<Schema> projection, Function1<T, SpecificRecord> evidence$7, Manifest<T> evidence$8) {
        Object object;
        if (filePath.endsWith(".bam") || filePath.endsWith(".sam") && ADAMRecord.class.isAssignableFrom(Predef$.MODULE$.manifest(evidence$8).runtimeClass())) {
            if (projection.isDefined()) {
                this.log().warn("Projection is ignored when loading a BAM file");
            }
            RDD<ADAMRecord> reads = this.adamBamLoad(filePath);
            if (predicate.isDefined()) {
                Class predicateClass = (Class)predicate.get();
                ADAMPredicate filter = (ADAMPredicate)predicateClass.newInstance();
                object = filter.apply(reads);
            } else {
                object = reads;
            }
        } else {
            object = this.adamParquetLoad(filePath, predicate, projection, evidence$7, evidence$8);
        }
        return object;
    }

    public <T, U extends ADAMPredicate<T>> None$ adamLoad$default$2() {
        return None$.MODULE$;
    }

    public <T, U extends ADAMPredicate<T>> Option<Schema> adamLoad$default$3() {
        return None$.MODULE$;
    }

    public RDD<ADAMNucleotideContigFragment> adamSequenceLoad(String filePath, long fragmentLength) {
        Object object;
        if (filePath.endsWith(".fasta") || filePath.endsWith(".fa")) {
            RDD fastaData = this.sc.newAPIHadoopFile(filePath, TextInputFormat.class, LongWritable.class, Text.class, this.sc.newAPIHadoopFile$default$5());
            RDD remapData = fastaData.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Tuple2<Object, String> apply(Tuple2<LongWritable, Text> kv) {
                    return new Tuple2((Object)BoxesRunTime.boxToLong((long)((LongWritable)kv._1()).get()), (Object)((Text)kv._2()).toString());
                }
            }, ClassTag$.MODULE$.apply(Tuple2.class));
            this.log().info("Converting FASTA to ADAM.");
            object = FastaConverter$.MODULE$.apply((RDD<Tuple2<Object, String>>)remapData, fragmentLength);
        } else {
            object = this.adamParquetLoad(filePath, (Option)this.adamParquetLoad$default$2(), this.adamParquetLoad$default$3(), (Function1)Predef$.MODULE$.conforms(), (Manifest)ManifestFactory$.MODULE$.classType(ADAMNucleotideContigFragment.class));
        }
        return object;
    }

    public Seq<Path> findFiles(Path path, String regex) {
        Tuple2 tuple2;
        block4: {
            Seq seq;
            block3: {
                block2: {
                    if (regex != null) break block2;
                    seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Path[]{path}));
                    break block3;
                }
                FileStatus[] statuses = FileSystem.get((Configuration)this.sc.hadoopConfiguration()).listStatus(path);
                Pattern r = Pattern.compile(regex);
                tuple2 = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])statuses).filter((Function1)new $anonfun$8(this))).map((Function1)new $anonfun$9(this), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Path.class)))).partition((Function1)new $anonfun$10(this, r));
                if (tuple2 == null) break block4;
                Tuple2 tuple22 = new Tuple2(tuple2._1(), tuple2._2());
                Path[] matches = (Path[])tuple22._1();
                Path[] recurse = (Path[])tuple22._2();
                seq = (Seq)Predef$.MODULE$.refArrayOps((Object[])matches).toSeq().$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])recurse).flatMap((Function1)new Serializable(this, regex){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ADAMContext $outer;
                    private final String regex$1;

                    public final Seq<Path> apply(Path p) {
                        return this.$outer.findFiles(p, this.regex$1);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.regex$1 = regex$1;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Path.class)))), Seq$.MODULE$.canBuildFrom());
            }
            return seq;
        }
        throw new MatchError((Object)tuple2);
    }

    public RDD<ADAMRecord> loadADAMFromPaths(Seq<Path> paths) {
        return this.sc.union((Seq)((TraversableLike)paths.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ADAMContext $outer;

            public final Tuple2<SequenceDictionary, RDD<ADAMRecord>> apply(Path path) {
                return this.$outer.org$bdgenomics$adam$rdd$ADAMContext$$loadADAMs$1(path);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final RDD<ADAMRecord> apply(Tuple2<SequenceDictionary, RDD<ADAMRecord>> v) {
                return (RDD)v._2();
            }
        }, Seq$.MODULE$.canBuildFrom()), ClassTag$.MODULE$.apply(ADAMRecord.class));
    }

    public final Tuple2 org$bdgenomics$adam$rdd$ADAMContext$$loadADAMs$1(Path path) {
        SequenceDictionary dict = this.adamDictionaryLoad(path.toString(), (Function1)Predef$.MODULE$.conforms(), (Manifest)ManifestFactory$.MODULE$.classType(ADAMRecord.class));
        RDD rdd = this.adamLoad(path.toString(), (Option)this.adamLoad$default$2(), this.adamLoad$default$3(), (Function1)Predef$.MODULE$.conforms(), (Manifest)ManifestFactory$.MODULE$.classType(ADAMRecord.class));
        return new Tuple2((Object)dict, rdd);
    }

    public ADAMContext(SparkContext sc) {
        this.sc = sc;
        Logging.class.$init$((Logging)this);
    }
}

