/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.rdd.recalibration;

import java.io.File;
import java.io.PrintWriter;
import org.apache.spark.Logging;
import org.apache.spark.SparkContext$;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.rdd.RDD;
import org.bdgenomics.adam.avro.ADAMRecord;
import org.bdgenomics.adam.models.SnpTable;
import org.bdgenomics.adam.rdd.recalibration.BaseQualityRecalibration$;
import org.bdgenomics.adam.rdd.recalibration.Covariate;
import org.bdgenomics.adam.rdd.recalibration.CovariateKey;
import org.bdgenomics.adam.rdd.recalibration.CovariateSpace;
import org.bdgenomics.adam.rdd.recalibration.CovariateSpace$;
import org.bdgenomics.adam.rdd.recalibration.CycleCovariate;
import org.bdgenomics.adam.rdd.recalibration.DinucCovariate;
import org.bdgenomics.adam.rdd.recalibration.ObservationAccumulator;
import org.bdgenomics.adam.rdd.recalibration.ObservationAccumulator$;
import org.bdgenomics.adam.rdd.recalibration.ObservationTable;
import org.bdgenomics.adam.rdd.recalibration.Recalibrator;
import org.bdgenomics.adam.rdd.recalibration.Recalibrator$;
import org.bdgenomics.adam.rich.DecadentRead;
import org.bdgenomics.adam.rich.RichADAMRecord$;
import org.bdgenomics.adam.util.QualityScore;
import org.bdgenomics.adam.util.QualityScore$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005ud\u0001B\u0001\u0003\u00015\u0011\u0001DQ1tKF+\u0018\r\\5usJ+7-\u00197jEJ\fG/[8o\u0015\t\u0019A!A\u0007sK\u000e\fG.\u001b2sCRLwN\u001c\u0006\u0003\u000b\u0019\t1A\u001d3e\u0015\t9\u0001\"\u0001\u0003bI\u0006l'BA\u0005\u000b\u0003)\u0011GmZ3o_6L7m\u001d\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M!\u0001A\u0004\u000b\u0018!\ty!#D\u0001\u0011\u0015\u0005\t\u0012!B:dC2\f\u0017BA\n\u0011\u0005\u0019\te.\u001f*fMB\u0011q\"F\u0005\u0003-A\u0011AbU3sS\u0006d\u0017N_1cY\u0016\u0004\"\u0001G\u000f\u000e\u0003eQ!AG\u000e\u0002\u000bM\u0004\u0018M]6\u000b\u0005qQ\u0011AB1qC\u000eDW-\u0003\u0002\u001f3\t9Aj\\4hS:<\u0007\u0002\u0003\u0011\u0001\u0005\u000b\u0007I\u0011A\u0011\u0002\u000b%t\u0007/\u001e;\u0016\u0003\t\u00022aI\u0013(\u001b\u0005!#BA\u0003\u001a\u0013\t1CEA\u0002S\t\u0012\u0003\"\u0001K\u0016\u000e\u0003%R!A\u000b\u0004\u0002\tIL7\r[\u0005\u0003Y%\u0012A\u0002R3dC\u0012,g\u000e\u001e*fC\u0012D\u0001B\f\u0001\u0003\u0002\u0003\u0006IAI\u0001\u0007S:\u0004X\u000f\u001e\u0011\t\u0011A\u0002!Q1A\u0005\u0002E\n\u0011b\u001b8po:\u001cf\u000e]:\u0016\u0003I\u00022a\r\u001c9\u001b\u0005!$BA\u001b\u001a\u0003%\u0011'o\\1eG\u0006\u001cH/\u0003\u00028i\tI!I]8bI\u000e\f7\u000f\u001e\t\u0003sqj\u0011A\u000f\u0006\u0003w\u0019\ta!\\8eK2\u001c\u0018BA\u001f;\u0005!\u0019f\u000e\u001d+bE2,\u0007\u0002C \u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001a\u0002\u0015-twn\u001e8T]B\u001c\b\u0005C\u0003B\u0001\u0011\u0005!)\u0001\u0004=S:LGO\u0010\u000b\u0004\u0007\u00163\u0005C\u0001#\u0001\u001b\u0005\u0011\u0001\"\u0002\u0011A\u0001\u0004\u0011\u0003\"\u0002\u0019A\u0001\u0004\u0011\u0004b\u0002%\u0001\u0005\u0004%\t!S\u0001\u000bG>4\u0018M]5bi\u0016\u001cX#\u0001&\u0011\u0005\u0011[\u0015B\u0001'\u0003\u00059\u0019uN^1sS\u0006$Xm\u00159bG\u0016DaA\u0014\u0001!\u0002\u0013Q\u0015aC2pm\u0006\u0014\u0018.\u0019;fg\u0002Bq\u0001\u0015\u0001C\u0002\u0013\u0005\u0011+\u0001\u000bnS:\f5mY3qi\u0006\u0014G.Z)vC2LG/_\u000b\u0002%B\u00111KV\u0007\u0002)*\u0011QKB\u0001\u0005kRLG.\u0003\u0002X)\na\u0011+^1mSRL8kY8sK\"1\u0011\f\u0001Q\u0001\nI\u000bQ#\\5o\u0003\u000e\u001cW\r\u001d;bE2,\u0017+^1mSRL\b\u0005C\u0004\\\u0001\t\u0007I\u0011\u0001/\u0002)\u0011,X\u000e](cg\u0016\u0014h/\u0019;j_:$\u0016M\u00197f+\u0005i\u0006CA\b_\u0013\ty\u0006CA\u0004C_>dW-\u00198\t\r\u0005\u0004\u0001\u0015!\u0003^\u0003U!W/\u001c9PEN,'O^1uS>tG+\u00192mK\u0002Bqa\u0019\u0001C\u0002\u0013\u0005A,\u0001\nf]\u0006\u0014G.\u001a,jg&$Hj\\4hS:<\u0007BB3\u0001A\u0003%Q,A\nf]\u0006\u0014G.\u001a,jg&$Hj\\4hS:<\u0007\u0005C\u0004h\u0001\t\u0007I\u0011\u00015\u0002\u000f\u0011\fG/Y:fiV\t\u0011\u000eE\u0002$K)\u0004BaD6na&\u0011A\u000e\u0005\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u0005\u0011s\u0017BA8\u0003\u00051\u0019uN^1sS\u0006$XmS3z!\t\txP\u0004\u0002s{:\u00111\u000f \b\u0003int!!\u001e>\u000f\u0005YLX\"A<\u000b\u0005ad\u0011A\u0002\u001fs_>$h(C\u0001\f\u0013\tI!\"\u0003\u0002\b\u0011%\u0011!FB\u0005\u0003}&\nA\u0002R3dC\u0012,g\u000e\u001e*fC\u0012LA!!\u0001\u0002\u0004\t9!+Z:jIV,'B\u0001@*\u0011\u001d\t9\u0001\u0001Q\u0001\n%\f\u0001\u0002Z1uCN,G\u000f\t\u0005\n\u0003\u0017\u0001!\u0019!C\u0001\u0003\u001b\t\u0001b\u001c2tKJ4X\rZ\u000b\u0003\u0003\u001f\u00012\u0001RA\t\u0013\r\t\u0019B\u0001\u0002\u0011\u001f\n\u001cXM\u001d<bi&|g\u000eV1cY\u0016D\u0001\"a\u0006\u0001A\u0003%\u0011qB\u0001\n_\n\u001cXM\u001d<fI\u0002B\u0011\"a\u0007\u0001\u0005\u0004%\t!!\b\u0002\rI,7/\u001e7u+\t\ty\u0002\u0005\u0003$K\u0005\u0005\u0002\u0003BA\u0012\u0003Si!!!\n\u000b\u0007\u0005\u001db!\u0001\u0003bmJ|\u0017\u0002BA\u0016\u0003K\u0011!\"\u0011#B\u001bJ+7m\u001c:e\u0011!\ty\u0003\u0001Q\u0001\n\u0005}\u0011a\u0002:fgVdG\u000f\t\u0005\b\u0003g\u0001A\u0011BA\u001b\u0003)!W/\u001c9WSNLGo\u001d\u000b\u0005\u0003o\ti\u0004E\u0002\u0010\u0003sI1!a\u000f\u0011\u0005\u0011)f.\u001b;\t\u0011\u0005}\u0012\u0011\u0007a\u0001\u0003\u0003\n\u0001BZ5mK:\fW.\u001a\t\u0005\u0003\u0007\nIED\u0002\u0010\u0003\u000bJ1!a\u0012\u0011\u0003\u0019\u0001&/\u001a3fM&!\u00111JA'\u0005\u0019\u0019FO]5oO*\u0019\u0011q\t\t\b\u000f\u0005E#\u0001#\u0001\u0002T\u0005A\")Y:f#V\fG.\u001b;z%\u0016\u001c\u0017\r\\5ce\u0006$\u0018n\u001c8\u0011\u0007\u0011\u000b)F\u0002\u0004\u0002\u0005!\u0005\u0011qK\n\u0005\u0003+rA\u0003C\u0004B\u0003+\"\t!a\u0017\u0015\u0005\u0005M\u0003\u0002CA0\u0003+\"\t!!\u0019\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\r\u0005}\u00111MA3\u0011\u001d)\u0011Q\fa\u0001\u0003?Aa\u0001MA/\u0001\u0004\u0011\u0004BCA5\u0003+\n\t\u0011\"\u0003\u0002l\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\ti\u0007\u0005\u0003\u0002p\u0005eTBAA9\u0015\u0011\t\u0019(!\u001e\u0002\t1\fgn\u001a\u0006\u0003\u0003o\nAA[1wC&!\u00111PA9\u0005\u0019y%M[3di\u0002")
public class BaseQualityRecalibration
implements Serializable,
Logging {
    private final RDD<DecadentRead> input;
    private final Broadcast<SnpTable> knownSnps;
    private final CovariateSpace covariates;
    private final QualityScore minAcceptableQuality;
    private final boolean dumpObservationTable;
    private final boolean enableVisitLogging;
    private final RDD<Tuple2<CovariateKey, DecadentRead.Residue>> dataset;
    private final ObservationTable observed;
    private final RDD<ADAMRecord> result;
    private transient Logger org$apache$spark$Logging$$log_;

    public static RDD<ADAMRecord> apply(RDD<ADAMRecord> rDD, Broadcast<SnpTable> broadcast) {
        return BaseQualityRecalibration$.MODULE$.apply(rDD, broadcast);
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public RDD<DecadentRead> input() {
        return this.input;
    }

    public Broadcast<SnpTable> knownSnps() {
        return this.knownSnps;
    }

    public CovariateSpace covariates() {
        return this.covariates;
    }

    public QualityScore minAcceptableQuality() {
        return this.minAcceptableQuality;
    }

    public boolean dumpObservationTable() {
        return this.dumpObservationTable;
    }

    public boolean enableVisitLogging() {
        return this.enableVisitLogging;
    }

    public RDD<Tuple2<CovariateKey, DecadentRead.Residue>> dataset() {
        return this.dataset;
    }

    public ObservationTable observed() {
        return this.observed;
    }

    public RDD<ADAMRecord> result() {
        return this.result;
    }

    private void dumpVisits(String filename) {
        Map readLengths = SparkContext$.MODULE$.rddToPairRDDFunctions(this.input().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BaseQualityRecalibration $outer;

            public final Tuple2<String, Object> apply(DecadentRead read) {
                return new Tuple2((Object)this.$outer.org$bdgenomics$adam$rdd$recalibration$BaseQualityRecalibration$$readId$1(read), (Object)BoxesRunTime.boxToInteger((int)read.residues().length()));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.Int(), (Ordering)Ordering.String$.MODULE$).collectAsMap();
        Map visited = SparkContext$.MODULE$.rddToPairRDDFunctions(this.dataset().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BaseQualityRecalibration $outer;

            public final Tuple2<String, Seq<Object>> apply(Tuple2<CovariateKey, DecadentRead.Residue> x0$2) {
                if (x0$2 != null) {
                    return new Tuple2((Object)this.$outer.org$bdgenomics$adam$rdd$recalibration$BaseQualityRecalibration$$readId$1(((DecadentRead.Residue)x0$2._2()).read()), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{((DecadentRead.Residue)x0$2._2()).offset()})));
                }
                throw new MatchError(x0$2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(Seq.class), (Ordering)Ordering.String$.MODULE$).reduceByKeyLocally((Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<Object> apply(Seq<Object> left, Seq<Object> right) {
                return (Seq)left.$plus$plus(right, Seq$.MODULE$.canBuildFrom());
            }
        });
        File outf = new File(filename);
        PrintWriter writer = new PrintWriter(outf);
        visited.foreach((Function1)new Serializable(this, readLengths, writer){
            public static final long serialVersionUID = 0L;
            private final Map readLengths$1;
            private final PrintWriter writer$1;

            public final void apply(Tuple2<String, Seq<Object>> x0$3) {
                if (x0$3 != null) {
                    int length = BoxesRunTime.unboxToInt((Object)this.readLengths$1.apply(x0$3._1()));
                    char[] buf = (char[])Array$.MODULE$.fill(length, (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final char apply() {
                            return 'O';
                        }

                        public char apply$mcC$sp() {
                            return 'O';
                        }
                    }, ClassTag$.MODULE$.Char());
                    ((IterableLike)x0$3._2()).foreach((Function1)new Serializable(this, buf){
                        public static final long serialVersionUID = 0L;
                        public final char[] buf$1;

                        public final void apply(int idx) {
                            this.buf$1[idx] = 88;
                        }

                        public void apply$mcVI$sp(int idx) {
                            this.buf$1[idx] = 88;
                        }
                        {
                            this.buf$1 = buf$1;
                        }
                    });
                    this.writer$1.println(new StringBuilder().append((Object)((String)x0$3._1())).append((Object)"\t").append((Object)String.valueOf(buf)).toString());
                    return;
                }
                throw new MatchError(x0$3);
            }
            {
                this.readLengths$1 = readLengths$1;
                this.writer$1 = writer$1;
            }
        });
        writer.close();
    }

    public final boolean org$bdgenomics$adam$rdd$recalibration$BaseQualityRecalibration$$shouldIncludeRead$1(DecadentRead read) {
        Option<QualityScore> option;
        return read.isCanonicalRecord() && !(option = read.alignmentQuality()).isEmpty() && ((QualityScore)option.get()).$greater(QualityScore$.MODULE$.zero()) && read.passedQualityChecks();
    }

    public final boolean org$bdgenomics$adam$rdd$recalibration$BaseQualityRecalibration$$shouldIncludeResidue$1(DecadentRead.Residue residue) {
        return residue.quality().$greater(QualityScore$.MODULE$.zero()) && residue.isRegularBase() && !residue.isInsertion() && !((SnpTable)this.knownSnps().value()).isMasked(residue);
    }

    public final Seq org$bdgenomics$adam$rdd$recalibration$BaseQualityRecalibration$$observe$1(DecadentRead read) {
        return (Seq)((TraversableLike)this.covariates().apply(read).zip(read.residues(), Seq$.MODULE$.canBuildFrom())).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BaseQualityRecalibration $outer;

            public final boolean apply(Tuple2<CovariateKey, DecadentRead.Residue> x0$1) {
                if (x0$1 != null) {
                    return this.$outer.org$bdgenomics$adam$rdd$recalibration$BaseQualityRecalibration$$shouldIncludeResidue$1((DecadentRead.Residue)x0$1._2());
                }
                throw new MatchError(x0$1);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public final String org$bdgenomics$adam$rdd$recalibration$BaseQualityRecalibration$$readId$1(DecadentRead read) {
        return new StringBuilder().append((Object)read.name()).append((Object)(read.isNegativeRead() ? "-" : "+")).append((Object)(Predef$.MODULE$.Boolean2boolean(RichADAMRecord$.MODULE$.richRecordToRecord(read.record()).getFirstOfPair()) ? "1" : "")).append((Object)(Predef$.MODULE$.Boolean2boolean(RichADAMRecord$.MODULE$.richRecordToRecord(read.record()).getSecondOfPair()) ? "2" : "")).toString();
    }

    public BaseQualityRecalibration(RDD<DecadentRead> input, Broadcast<SnpTable> knownSnps) {
        this.input = input;
        this.knownSnps = knownSnps;
        Logging.class.$init$((Logging)this);
        this.covariates = CovariateSpace$.MODULE$.apply((Seq<Covariate>)Predef$.MODULE$.wrapRefArray((Object[])new Covariate[]{new CycleCovariate(), new DinucCovariate()}));
        this.minAcceptableQuality = QualityScore$.MODULE$.apply(5);
        this.dumpObservationTable = false;
        this.enableVisitLogging = false;
        this.dataset = input.filter((Function1)new $anonfun$2(this)).flatMap((Function1)new $anonfun$3(this), ClassTag$.MODULE$.apply(Tuple2.class));
        if (this.enableVisitLogging()) {
            input.cache();
            this.dataset().cache();
            this.dumpVisits("bqsr-visits.dump");
        }
        this.observed = ((ObservationAccumulator)this.dataset().map((Function1)new $anonfun$4(this), ClassTag$.MODULE$.apply(Tuple2.class)).aggregate((Object)ObservationAccumulator$.MODULE$.apply(this.covariates()), (Function2)new $anonfun$5(this), (Function2)new $anonfun$6(this), ClassTag$.MODULE$.apply(ObservationAccumulator.class))).result();
        if (this.dumpObservationTable()) {
            Predef$.MODULE$.println((Object)this.observed().toCSV());
        }
        Recalibrator recalibrator = Recalibrator$.MODULE$.apply(this.observed(), this.minAcceptableQuality());
        this.result = input.map((Function1)recalibrator, ClassTag$.MODULE$.apply(ADAMRecord.class));
    }
}

