/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.algorithms.realignmenttarget;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.log4j.Level;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.bdgenomics.adam.algorithms.realignmenttarget.IndelRealignmentTarget;
import org.bdgenomics.adam.algorithms.realignmenttarget.IndelRealignmentTargetSuite$;
import org.bdgenomics.adam.algorithms.realignmenttarget.RealignmentTargetFinder$;
import org.bdgenomics.adam.algorithms.realignmenttarget.TargetOrdering$;
import org.bdgenomics.adam.models.ReferenceRegion;
import org.bdgenomics.adam.rdd.ADAMContext;
import org.bdgenomics.adam.rdd.ADAMContext$;
import org.bdgenomics.adam.rich.RichADAMRecord;
import org.bdgenomics.adam.rich.RichADAMRecord$;
import org.bdgenomics.adam.util.SparkFunSuite;
import org.bdgenomics.adam.util.SparkFunSuite$class;
import org.bdgenomics.formats.avro.ADAMContig;
import org.bdgenomics.formats.avro.ADAMRecord;
import org.scalatest.BeforeAndAfter;
import org.scalatest.Distributor;
import org.scalatest.Filter;
import org.scalatest.FunSuite;
import org.scalatest.FunSuiteLike;
import org.scalatest.Reporter;
import org.scalatest.Stopper;
import org.scalatest.Tag;
import org.scalatest.Tracker;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.TreeSet;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001y3A!\u0001\u0002\u0001\u001b\tY\u0012J\u001c3fYJ+\u0017\r\\5h]6,g\u000e\u001e+be\u001e,GoU;ji\u0016T!a\u0001\u0003\u0002#I,\u0017\r\\5h]6,g\u000e\u001e;be\u001e,GO\u0003\u0002\u0006\r\u0005Q\u0011\r\\4pe&$\b.\\:\u000b\u0005\u001dA\u0011\u0001B1eC6T!!\u0003\u0006\u0002\u0015\t$w-\u001a8p[&\u001c7OC\u0001\f\u0003\ry'oZ\u0002\u0001'\r\u0001a\u0002\u0006\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0003#)\t\u0011b]2bY\u0006$Xm\u001d;\n\u0005M\u0001\"\u0001\u0003$v]N+\u0018\u000e^3\u0011\u0005UAR\"\u0001\f\u000b\u0005]1\u0011\u0001B;uS2L!!\u0007\f\u0003\u001bM\u0003\u0018M]6Gk:\u001cV/\u001b;f\u0011\u0015Y\u0002\u0001\"\u0001\u001d\u0003\u0019a\u0014N\\5u}Q\tQ\u0004\u0005\u0002\u001f\u00015\t!\u0001C\u0003!\u0001\u0011\u0005\u0011%A\u0006nCN|gn\u0018:fC\u0012\u001cX#\u0001\u0012\u0011\u0007\rRC&D\u0001%\u0015\t)c%A\u0002sI\u0012T!a\n\u0015\u0002\u000bM\u0004\u0018M]6\u000b\u0005%R\u0011AB1qC\u000eDW-\u0003\u0002,I\t\u0019!\u000b\u0012#\u0011\u00055\u0002T\"\u0001\u0018\u000b\u0005=2\u0011\u0001\u0002:jG\"L!!\r\u0018\u0003\u001dIK7\r[!E\u00036\u0013VmY8sI\")1\u0007\u0001C\u0001C\u0005\u0001\u0012M\u001d;jM&\u001c\u0017.\u00197`e\u0016\fGm\u001d\u0005\u0006k\u0001!\tAN\u0001\n[\u0006\\Wm\u0018:fC\u0012$b\u0001L\u001c@\u0011*{\u0005\"\u0002\u001d5\u0001\u0004I\u0014!B:uCJ$\bC\u0001\u001e>\u001b\u0005Y$\"\u0001\u001f\u0002\u000bM\u001c\u0017\r\\1\n\u0005yZ$\u0001\u0002'p]\u001eDQ\u0001\u0011\u001bA\u0002\u0005\u000bQaY5hCJ\u0004\"AQ#\u000f\u0005i\u001a\u0015B\u0001#<\u0003\u0019\u0001&/\u001a3fM&\u0011ai\u0012\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u0011[\u0004\"B%5\u0001\u0004\t\u0015!B7ei\u0006<\u0007\"B&5\u0001\u0004a\u0015A\u00027f]\u001e$\b\u000e\u0005\u0002;\u001b&\u0011aj\u000f\u0002\u0004\u0013:$\bb\u0002)5!\u0003\u0005\r\u0001T\u0001\u0003S\u0012DqA\u0015\u0001\u0012\u0002\u0013\u00051+A\nnC.,wL]3bI\u0012\"WMZ1vYR$S'F\u0001UU\taUkK\u0001W!\t9F,D\u0001Y\u0015\tI&,A\u0005v]\u000eDWmY6fI*\u00111lO\u0001\u000bC:tw\u000e^1uS>t\u0017BA/Y\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a")
public class IndelRealignmentTargetSuite
extends FunSuite
implements SparkFunSuite {
    private SparkContext sc;
    private Option<Map<String, Level>> maybeLevels;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    private volatile boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked;

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public Option<Map<String, Level>> maybeLevels() {
        return this.maybeLevels;
    }

    @Override
    public void maybeLevels_$eq(Option<Map<String, Level>> x$1) {
        this.maybeLevels = x$1;
    }

    @Override
    public void setupSparkContext(String sparkName, boolean silenceSpark) {
        SparkFunSuite$class.setupSparkContext(this, sparkName, silenceSpark);
    }

    @Override
    public void teardownSparkContext() {
        SparkFunSuite$class.teardownSparkContext(this);
    }

    @Override
    public void sparkBefore(String beforeName, boolean silenceSpark, Function0<BoxedUnit> body) {
        SparkFunSuite$class.sparkBefore(this, beforeName, silenceSpark, body);
    }

    @Override
    public void sparkAfter(String beforeName, boolean silenceSpark, Function0<BoxedUnit> body) {
        SparkFunSuite$class.sparkAfter(this, beforeName, silenceSpark, body);
    }

    @Override
    public void sparkTest(String name, boolean silenceSpark, Seq<Tag> tags, Function0<BoxedUnit> body) {
        SparkFunSuite$class.sparkTest(this, name, silenceSpark, tags, body);
    }

    @Override
    public void sparkTest(String name, Function0<BoxedUnit> body) {
        SparkFunSuite$class.sparkTest(this, name, body);
    }

    @Override
    public boolean sparkBefore$default$2() {
        return SparkFunSuite$class.sparkBefore$default$2(this);
    }

    @Override
    public boolean setupSparkContext$default$2() {
        return SparkFunSuite$class.setupSparkContext$default$2(this);
    }

    @Override
    public boolean sparkAfter$default$2() {
        return SparkFunSuite$class.sparkAfter$default$2(this);
    }

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    }

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    }

    public boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked() {
        return this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked;
    }

    public void org$scalatest$BeforeAndAfter$$runHasBeenInvoked_$eq(boolean x$1) {
        this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked = x$1;
    }

    public void org$scalatest$BeforeAndAfter$$super$runTest(String testName, Reporter reporter, Stopper stopper, Map configMap, Tracker tracker) {
        FunSuiteLike.class.runTest((FunSuiteLike)this, (String)testName, (Reporter)reporter, (Stopper)stopper, (Map)configMap, (Tracker)tracker);
    }

    public void org$scalatest$BeforeAndAfter$$super$run(Option testName, Reporter reporter, Stopper stopper, Filter filter, Map configMap, Option distributor, Tracker tracker) {
        FunSuiteLike.class.run((FunSuiteLike)this, (Option)testName, (Reporter)reporter, (Stopper)stopper, (Filter)filter, (Map)configMap, (Option)distributor, (Tracker)tracker);
    }

    public void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$beforeFunctionAtomic_$eq(AtomicReference x$1) {
        this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic = x$1;
    }

    public void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$afterFunctionAtomic_$eq(AtomicReference x$1) {
        this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic = x$1;
    }

    public void before(Function0<Object> fun) {
        BeforeAndAfter.class.before((BeforeAndAfter)this, fun);
    }

    public void after(Function0<Object> fun) {
        BeforeAndAfter.class.after((BeforeAndAfter)this, fun);
    }

    public void runTest(String testName, Reporter reporter, Stopper stopper, Map<String, Object> configMap, Tracker tracker) {
        BeforeAndAfter.class.runTest((BeforeAndAfter)this, (String)testName, (Reporter)reporter, (Stopper)stopper, configMap, (Tracker)tracker);
    }

    public void run(Option<String> testName, Reporter reporter, Stopper stopper, Filter filter, Map<String, Object> configMap, Option<Distributor> distributor, Tracker tracker) {
        BeforeAndAfter.class.run((BeforeAndAfter)this, testName, (Reporter)reporter, (Stopper)stopper, (Filter)filter, configMap, distributor, (Tracker)tracker);
    }

    public RDD<RichADAMRecord> mason_reads() {
        String path = ClassLoader.getSystemClassLoader().getResource("small_realignment_targets.sam").getFile();
        ADAMContext qual$1 = ADAMContext$.MODULE$.sparkContextToADAMContext(this.sc());
        None$ x$4 = qual$1.adamLoad$default$2();
        Option x$5 = qual$1.adamLoad$default$3();
        return qual$1.adamLoad(path, (Option)x$4, x$5, (Function1)Predef$.MODULE$.conforms(), ManifestFactory$.MODULE$.classType(ADAMRecord.class)).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final RichADAMRecord apply(ADAMRecord x$1) {
                return RichADAMRecord$.MODULE$.apply(x$1);
            }
        }, ClassTag$.MODULE$.apply(RichADAMRecord.class));
    }

    public RDD<RichADAMRecord> artificial_reads() {
        String path = ClassLoader.getSystemClassLoader().getResource("artificial.sam").getFile();
        ADAMContext qual$2 = ADAMContext$.MODULE$.sparkContextToADAMContext(this.sc());
        None$ x$7 = qual$2.adamLoad$default$2();
        Option x$8 = qual$2.adamLoad$default$3();
        return qual$2.adamLoad(path, (Option)x$7, x$8, (Function1)Predef$.MODULE$.conforms(), ManifestFactory$.MODULE$.classType(ADAMRecord.class)).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final RichADAMRecord apply(ADAMRecord x$2) {
                return RichADAMRecord$.MODULE$.apply(x$2);
            }
        }, ClassTag$.MODULE$.apply(RichADAMRecord.class));
    }

    public RichADAMRecord make_read(long start, String cigar, String mdtag, int length, int id) {
        Predef$ predef$ = Predef$.MODULE$;
        String sequence = new StringOps("A").$times(length);
        return RichADAMRecord$.MODULE$.apply(ADAMRecord.newBuilder().setReadName((CharSequence)new StringBuilder().append((Object)"read").append((Object)((Object)BoxesRunTime.boxToInteger((int)id)).toString()).toString()).setStart(Predef$.MODULE$.long2Long(start)).setReadMapped(Predef$.MODULE$.boolean2Boolean(true)).setCigar((CharSequence)cigar).setSequence((CharSequence)sequence).setReadNegativeStrand(Predef$.MODULE$.boolean2Boolean(false)).setMapq(Predef$.MODULE$.int2Integer(60)).setQual((CharSequence)sequence).setContig(ADAMContig.newBuilder().setContigName((CharSequence)"1").build()).setMismatchingPositions((CharSequence)mdtag).build());
    }

    public int make_read$default$5() {
        return 0;
    }

    public IndelRealignmentTargetSuite() {
        BeforeAndAfter.class.$init$((BeforeAndAfter)this);
        SparkFunSuite$class.$init$(this);
        this.sparkTest("checking simple realignment target", (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IndelRealignmentTargetSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                IndelRealignmentTarget target1 = new IndelRealignmentTarget((Option)new Some((Object)new ReferenceRegion("1", 1L, 10L)), new ReferenceRegion("1", 1L, 51L));
                IndelRealignmentTarget target2 = new IndelRealignmentTarget((Option)None$.MODULE$, new ReferenceRegion("1", 60L, 91L));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)target1.readRange().start())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)target1.readRange().end())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)51)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)TargetOrdering$.MODULE$.overlap(target1, target1))).$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)true)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)TargetOrdering$.MODULE$.overlap(target1, target2))).$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)false)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)target2.readRange().start())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)60)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)target2.readRange().end())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)91)));
                this.$outer.assert(!target1.isEmpty());
                this.$outer.assert(target2.isEmpty());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.sparkTest("creating simple target from read with deletion", (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IndelRealignmentTargetSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                RichADAMRecord read = this.$outer.make_read(3L, "2M3D2M", "2^AAA2", 4, this.$outer.make_read$default$5());
                RDD read_rdd = this.$outer.sc().makeRDD((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RichADAMRecord[]{read})), 1, ClassTag$.MODULE$.apply(RichADAMRecord.class));
                TreeSet targets = RealignmentTargetFinder$.MODULE$.apply(read_rdd, RealignmentTargetFinder$.MODULE$.apply$default$2(), RealignmentTargetFinder$.MODULE$.apply$default$3());
                this.$outer.assert(targets != null);
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)targets.size())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)((ReferenceRegion)((IndelRealignmentTarget)targets.head()).variation().get()).start())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)5)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)((ReferenceRegion)((IndelRealignmentTarget)targets.head()).variation().get()).end())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)8)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)((IndelRealignmentTarget)targets.head()).readRange().start())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)3)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)((IndelRealignmentTarget)targets.head()).readRange().end())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)10)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.sparkTest("creating simple target from read with insertion", (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IndelRealignmentTargetSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                RichADAMRecord read = this.$outer.make_read(3L, "2M3I2M", "4", 7, this.$outer.make_read$default$5());
                RDD read_rdd = this.$outer.sc().makeRDD((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RichADAMRecord[]{read})), 1, ClassTag$.MODULE$.apply(RichADAMRecord.class));
                TreeSet targets = RealignmentTargetFinder$.MODULE$.apply(read_rdd, RealignmentTargetFinder$.MODULE$.apply$default$2(), RealignmentTargetFinder$.MODULE$.apply$default$3());
                this.$outer.assert(targets != null);
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)targets.size())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)((ReferenceRegion)((IndelRealignmentTarget)targets.head()).variation().get()).start())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)5)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)((ReferenceRegion)((IndelRealignmentTarget)targets.head()).variation().get()).end())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)6)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)((IndelRealignmentTarget)targets.head()).readRange().start())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)3)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)((IndelRealignmentTarget)targets.head()).readRange().end())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)7)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.sparkTest("joining simple realignment targets on same chr", (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IndelRealignmentTargetSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                IndelRealignmentTarget target1 = new IndelRealignmentTarget((Option)new Some((Object)new ReferenceRegion("1", 10L, 16L)), new ReferenceRegion("1", 1L, 21L));
                IndelRealignmentTarget target2 = new IndelRealignmentTarget((Option)new Some((Object)new ReferenceRegion("1", 10L, 16L)), new ReferenceRegion("1", 6L, 26L));
                IndelRealignmentTarget merged_target = target1.merge(target2);
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)merged_target.readRange().start())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)merged_target.readRange().end())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)26)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)((ReferenceRegion)merged_target.variation().get()).start())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)10)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)((ReferenceRegion)merged_target.variation().get()).end())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)16)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.sparkTest("joining simple realignment targets on different chr throws exception", (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IndelRealignmentTargetSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                IndelRealignmentTarget target1 = new IndelRealignmentTarget((Option)new Some((Object)new ReferenceRegion("1", 10L, 16L)), new ReferenceRegion("1", 1L, 21L));
                IndelRealignmentTarget target2 = new IndelRealignmentTarget((Option)new Some((Object)new ReferenceRegion("2", 10L, 16L)), new ReferenceRegion("2", 6L, 26L));
                this.$outer.intercept((Function0)new Serializable(this, target1, target2){
                    public static final long serialVersionUID = 0L;
                    public final IndelRealignmentTarget target1$1;
                    public final IndelRealignmentTarget target2$1;

                    public final void apply() {
                        this.target1$1.merge(this.target2$1);
                    }

                    public void apply$mcV$sp() {
                        this.target1$1.merge(this.target2$1);
                    }
                    {
                        this.target1$1 = target1$1;
                        this.target2$1 = target2$1;
                    }
                }, ManifestFactory$.MODULE$.classType(AssertionError.class));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.sparkTest("creating targets from three intersecting reads, same indel", (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IndelRealignmentTargetSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                RichADAMRecord read1 = this.$outer.make_read(1L, "4M3D2M", "4^AAA2", 6, this.$outer.make_read$default$5());
                RichADAMRecord read2 = this.$outer.make_read(2L, "3M3D2M", "3^AAA2", 5, this.$outer.make_read$default$5());
                RichADAMRecord read3 = this.$outer.make_read(3L, "2M3D2M", "2^AAA2", 4, this.$outer.make_read$default$5());
                RDD read_rdd = this.$outer.sc().makeRDD((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RichADAMRecord[]{read1, read2, read3})), 1, ClassTag$.MODULE$.apply(RichADAMRecord.class));
                TreeSet targets = RealignmentTargetFinder$.MODULE$.apply(read_rdd, RealignmentTargetFinder$.MODULE$.apply$default$2(), RealignmentTargetFinder$.MODULE$.apply$default$3());
                this.$outer.assert(targets != null);
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)targets.size())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)((ReferenceRegion)((IndelRealignmentTarget)targets.head()).variation().get()).start())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)5)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)((ReferenceRegion)((IndelRealignmentTarget)targets.head()).variation().get()).end())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)8)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)((IndelRealignmentTarget)targets.head()).readRange().start())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)((IndelRealignmentTarget)targets.head()).readRange().end())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)10)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.sparkTest("creating targets from three intersecting reads, two different indel", (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IndelRealignmentTargetSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                RichADAMRecord read1 = this.$outer.make_read(1L, "2M2D4M", "2^AA4", 6, 0);
                RichADAMRecord read2 = this.$outer.make_read(1L, "2M2D2M2D2M", "2^AA2^AA2", 6, 1);
                RichADAMRecord read3 = this.$outer.make_read(5L, "2M2D4M", "2^AA4", 6, 2);
                RDD read_rdd = this.$outer.sc().makeRDD((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RichADAMRecord[]{read1, read2, read3})), 1, ClassTag$.MODULE$.apply(RichADAMRecord.class));
                TreeSet targets = RealignmentTargetFinder$.MODULE$.apply(read_rdd, RealignmentTargetFinder$.MODULE$.apply$default$2(), RealignmentTargetFinder$.MODULE$.apply$default$3());
                this.$outer.assert(targets != null);
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)targets.size())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)((ReferenceRegion)((IndelRealignmentTarget)targets.head()).variation().get()).start())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)3)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)((ReferenceRegion)((IndelRealignmentTarget)targets.head()).variation().get()).end())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)9)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)((IndelRealignmentTarget)targets.head()).readRange().start())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)((IndelRealignmentTarget)targets.head()).readRange().end())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)13)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.sparkTest("creating targets from two disjoint reads", (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IndelRealignmentTargetSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                RichADAMRecord read1 = this.$outer.make_read(1L, "2M2D2M", "2^AA2", 4, this.$outer.make_read$default$5());
                RichADAMRecord read2 = this.$outer.make_read(7L, "2M2D2M", "2^AA2", 4, this.$outer.make_read$default$5());
                RDD read_rdd = this.$outer.sc().makeRDD((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RichADAMRecord[]{read1, read2})), 1, ClassTag$.MODULE$.apply(RichADAMRecord.class));
                IndelRealignmentTarget[] targets = (IndelRealignmentTarget[])RealignmentTargetFinder$.MODULE$.apply(read_rdd, RealignmentTargetFinder$.MODULE$.apply$default$2(), RealignmentTargetFinder$.MODULE$.apply$default$3()).toArray(ClassTag$.MODULE$.apply(IndelRealignmentTarget.class));
                this.$outer.assert(targets != null);
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)Predef$.MODULE$.refArrayOps((Object[])targets).size())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)2)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)((ReferenceRegion)targets[0].variation().get()).start())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)3)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)((ReferenceRegion)targets[0].variation().get()).end())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)5)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)targets[0].readRange().start())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)targets[0].readRange().end())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)7)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)((ReferenceRegion)targets[1].variation().get()).start())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)9)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)((ReferenceRegion)targets[1].variation().get()).end())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)11)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)targets[1].readRange().start())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)7)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)targets[1].readRange().end())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)13)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.sparkTest("creating targets for artificial reads: one-by-one", (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            public final /* synthetic */ IndelRealignmentTargetSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                RichADAMRecord[] reads = (RichADAMRecord[])this.$outer.artificial_reads().collect();
                Predef$.MODULE$.refArrayOps((Object[])reads).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$9 $outer;

                    public final void apply(RichADAMRecord read) {
                        RDD read_rdd = this.$outer.$outer.sc().makeRDD((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RichADAMRecord[]{read})), 1, ClassTag$.MODULE$.apply(RichADAMRecord.class));
                        TreeSet targets = RealignmentTargetFinder$.MODULE$.apply(read_rdd, RealignmentTargetFinder$.MODULE$.apply$default$2(), RealignmentTargetFinder$.MODULE$.apply$default$3());
                        if (Predef$.MODULE$.Long2long(RichADAMRecord$.MODULE$.richRecordToRecord(read).getStart()) < 105L) {
                            this.$outer.$outer.assert(targets != null);
                            this.$outer.$outer.assert(this.$outer.org$bdgenomics$adam$algorithms$realignmenttarget$IndelRealignmentTargetSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToInteger((int)targets.size())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1)));
                            this.$outer.org$bdgenomics$adam$algorithms$realignmenttarget$IndelRealignmentTargetSuite$$anonfun$$$outer().assert(this.$outer.org$bdgenomics$adam$algorithms$realignmenttarget$IndelRealignmentTargetSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToLong((long)((IndelRealignmentTarget)targets.head()).readRange().start())).$eq$eq$eq((Object)RichADAMRecord$.MODULE$.richRecordToRecord(read).getStart()));
                            this.$outer.org$bdgenomics$adam$algorithms$realignmenttarget$IndelRealignmentTargetSuite$$anonfun$$$outer().assert(this.$outer.org$bdgenomics$adam$algorithms$realignmenttarget$IndelRealignmentTargetSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToLong((long)((IndelRealignmentTarget)targets.head()).readRange().end())).$eq$eq$eq(read.end().get()));
                            this.$outer.org$bdgenomics$adam$algorithms$realignmenttarget$IndelRealignmentTargetSuite$$anonfun$$$outer().assert(this.$outer.org$bdgenomics$adam$algorithms$realignmenttarget$IndelRealignmentTargetSuite$$anonfun$$check_indel$1((IndelRealignmentTarget)targets.head(), RichADAMRecord$.MODULE$.richRecordToRecord(read)));
                        }
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ IndelRealignmentTargetSuite org$bdgenomics$adam$algorithms$realignmenttarget$IndelRealignmentTargetSuite$$anonfun$$$outer() {
                return this.$outer;
            }

            public final boolean org$bdgenomics$adam$algorithms$realignmenttarget$IndelRealignmentTargetSuite$$anonfun$$check_indel$1(IndelRealignmentTarget target, ADAMRecord read) {
                ReferenceRegion indelRange = (ReferenceRegion)target.variation().get();
                long l = Predef$.MODULE$.Long2long(read.getStart());
                boolean bl = 5L == l ? indelRange.start() == 34L && indelRange.end() == 44L : (10L == l ? indelRange.start() == 54L && indelRange.end() == 64L : (15L == l ? indelRange.start() == 34L && indelRange.end() == 44L : (20L == l ? indelRange.start() == 54L && indelRange.end() == 64L : (25L == l ? indelRange.start() == 34L && indelRange.end() == 44L : false))));
                return bl;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.sparkTest("creating targets for artificial reads: all-at-once (merged)", (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IndelRealignmentTargetSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                IndelRealignmentTarget[] targets_collected = (IndelRealignmentTarget[])RealignmentTargetFinder$.MODULE$.apply(this.$outer.artificial_reads(), RealignmentTargetFinder$.MODULE$.apply$default$2(), RealignmentTargetFinder$.MODULE$.apply$default$3()).toArray(ClassTag$.MODULE$.apply(IndelRealignmentTarget.class));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)Predef$.MODULE$.refArrayOps((Object[])targets_collected).size())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)((IndelRealignmentTarget)Predef$.MODULE$.refArrayOps((Object[])targets_collected).head()).readRange().start())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)5)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)((IndelRealignmentTarget)Predef$.MODULE$.refArrayOps((Object[])targets_collected).head()).readRange().end())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)95)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)((ReferenceRegion)((IndelRealignmentTarget)Predef$.MODULE$.refArrayOps((Object[])targets_collected).head()).variation().get()).start())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)34)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)((ReferenceRegion)((IndelRealignmentTarget)Predef$.MODULE$.refArrayOps((Object[])targets_collected).head()).variation().get()).end())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)64)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.sparkTest("creating indel targets for mason reads", (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IndelRealignmentTargetSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                IndelRealignmentTarget[] targets_collected = (IndelRealignmentTarget[])RealignmentTargetFinder$.MODULE$.apply(this.$outer.mason_reads(), RealignmentTargetFinder$.MODULE$.apply$default$2(), RealignmentTargetFinder$.MODULE$.apply$default$3()).toArray(ClassTag$.MODULE$.apply(IndelRealignmentTarget.class));
                this.$outer.assert(((ReferenceRegion)targets_collected[0].variation().get()).start() == 702289L && ((ReferenceRegion)targets_collected[0].variation().get()).end() == 702324L);
                this.$outer.assert(((ReferenceRegion)targets_collected[1].variation().get()).start() == 807755L && ((ReferenceRegion)targets_collected[1].variation().get()).end() == 807756L);
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)((ReferenceRegion)targets_collected[5].variation().get()).length())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)4)));
                this.$outer.assert(((ReferenceRegion)targets_collected[5].variation().get()).start() == 869644L && ((ReferenceRegion)targets_collected[5].variation().get()).end() == 869648L);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

