/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.algorithms.smithwaterman;

import org.bdgenomics.adam.algorithms.smithwaterman.SmithWatermanConstantGapScoring;
import org.bdgenomics.adam.algorithms.smithwaterman.SmithWatermanSuite$;
import org.bdgenomics.adam.algorithms.smithwaterman.SmithWatermanSuite$$anonfun$4$;
import org.bdgenomics.adam.algorithms.smithwaterman.SmithWatermanSuite$$anonfun$5$;
import org.bdgenomics.adam.algorithms.smithwaterman.SmithWatermanSuite$$anonfun$6$;
import org.scalatest.FunSuite;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Seq;
import scala.collection.immutable.Range;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001Y2A!\u0001\u0002\u0001\u001b\t\u00112+\\5uQ^\u000bG/\u001a:nC:\u001cV/\u001b;f\u0015\t\u0019A!A\u0007t[&$\bn^1uKJl\u0017M\u001c\u0006\u0003\u000b\u0019\t!\"\u00197h_JLG\u000f[7t\u0015\t9\u0001\"\u0001\u0003bI\u0006l'BA\u0005\u000b\u0003)\u0011GmZ3o_6L7m\u001d\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M\u0011\u0001A\u0004\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0003#)\t\u0011b]2bY\u0006$Xm\u001d;\n\u0005M\u0001\"\u0001\u0003$v]N+\u0018\u000e^3\t\u000bU\u0001A\u0011\u0001\f\u0002\rqJg.\u001b;?)\u00059\u0002C\u0001\r\u0001\u001b\u0005\u0011\u0001b\u0002\u000e\u0001\u0005\u0004%\taG\u0001\bKB\u001c\u0018\u000e\\8o+\u0005a\u0002CA\u000f!\u001b\u0005q\"\"A\u0010\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0005r\"A\u0002#pk\ndW\r\u0003\u0004$\u0001\u0001\u0006I\u0001H\u0001\tKB\u001c\u0018\u000e\\8oA!)Q\u0005\u0001C\u0001M\u0005Aa\r]#rk\u0006d7\u000fF\u0002(U1\u0002\"!\b\u0015\n\u0005%r\"a\u0002\"p_2,\u0017M\u001c\u0005\u0006W\u0011\u0002\r\u0001H\u0001\u0002C\")Q\u0006\na\u00019\u0005\t!\rC\u00040\u0001\t\u0007I\u0011\u0001\u0019\u0002\u0007M<\b.F\u00012!\tA\"'\u0003\u00024\u0005\ty2+\\5uQ^\u000bG/\u001a:nC:\u001cuN\\:uC:$x)\u00199TG>\u0014\u0018N\\4\t\rU\u0002\u0001\u0015!\u00032\u0003\u0011\u0019x\u000f\u001b\u0011")
public class SmithWatermanSuite
extends FunSuite {
    private final double epsilon;
    private final SmithWatermanConstantGapScoring swh;

    public double epsilon() {
        return this.epsilon;
    }

    public boolean fpEquals(double a, double b) {
        return package$.MODULE$.abs(a - b) < this.epsilon();
    }

    public SmithWatermanConstantGapScoring swh() {
        return this.swh;
    }

    public SmithWatermanSuite() {
        this.epsilon = 1.0E-6;
        this.test("gather max position from simple scoring matrix", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SmithWatermanSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                double[] c0 = new double[]{0.0, 0.0, 0.0, 0.0, 0.0};
                double[] c1 = new double[]{0.0, 1.0, 1.0, 1.0, 1.0};
                double[] c2 = new double[]{0.0, 1.0, 2.0, 2.0, 2.0};
                double[] c3 = new double[]{0.0, 1.0, 2.0, 3.0, 3.0};
                double[] c4 = new double[]{0.0, 1.0, 2.0, 3.0, 4.0};
                double[][] matrix = (double[][])((Object[])new double[][]{c0, c1, c2, c3, c4});
                SmithWatermanConstantGapScoring sw = new SmithWatermanConstantGapScoring("AAAA", "AAAA", 1.0, 0.0, -1.0, -1.0);
                Tuple2 max = sw.maxCoordinates(matrix);
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)max._1$mcI$sp())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)4)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)max._2$mcI$sp())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)4)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("gather max position from irregular scoring matrix", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SmithWatermanSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                double[] c0 = new double[]{0.0, 0.0, 0.0, 0.0, 0.0};
                double[] c1 = new double[]{0.0, 1.0, 1.0, 1.0, 1.0};
                double[] c2 = new double[]{0.0, 0.0, 2.0, 1.0, 1.0};
                double[] c3 = new double[]{0.0, 1.0, 1.0, 2.0, 1.0};
                double[] c4 = new double[]{0.0, 0.0, 1.0, 1.0, 3.0};
                double[] c5 = new double[]{0.0, 0.0, 0.0, 0.0, 2.0};
                double[] c6 = new double[]{0.0, 1.0, 0.0, 0.0, 1.0};
                double[][] matrix = (double[][])((Object[])new double[][]{c0, c1, c2, c3, c4, c5, c6});
                SmithWatermanConstantGapScoring sw = new SmithWatermanConstantGapScoring("ACGT", "ACATGA", 1.0, 0.0, -1.0, -1.0);
                Tuple2 max = sw.maxCoordinates(matrix);
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)max._1$mcI$sp())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)4)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)max._2$mcI$sp())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)4)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("gather max position from irregular scoring matrix with deletions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SmithWatermanSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                double[] c0 = new double[]{0.0, 0.0, 0.0, 0.0, 0.0};
                double[] c1 = new double[]{0.0, 1.0, 1.0, 1.0, 1.0};
                double[] c2 = new double[]{0.0, 0.5, 2.0, 1.0, 1.0};
                double[] c3 = new double[]{0.0, 1.0, 1.5, 2.0, 1.5};
                double[] c4 = new double[]{0.0, 0.5, 1.0, 1.5, 2.0};
                double[] c5 = new double[]{0.0, 0.5, 0.5, 2.0, 1.5};
                double[] c6 = new double[]{0.0, 1.0, 0.5, 1.5, 3.0};
                double[][] matrix = (double[][])((Object[])new double[][]{c0, c1, c2, c3, c4, c5, c6});
                SmithWatermanConstantGapScoring sw = new SmithWatermanConstantGapScoring("ACGA", "ACATGA", 1.0, 0.0, -0.5, -0.5);
                Tuple2 max = sw.maxCoordinates(matrix);
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)max._1$mcI$sp())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)4)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)max._2$mcI$sp())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)6)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("score simple alignment with constant gap", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            public final /* synthetic */ SmithWatermanSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void apply$mcV$sp() {
                double[] c0 = new double[]{0.0, 0.0, 0.0, 0.0, 0.0};
                double[] c1 = new double[]{0.0, 1.0, 1.0, 1.0, 1.0};
                double[] c2 = new double[]{0.0, 1.0, 2.0, 2.0, 2.0};
                double[] c3 = new double[]{0.0, 1.0, 2.0, 3.0, 3.0};
                double[] c4 = new double[]{0.0, 1.0, 2.0, 3.0, 4.0};
                double[][] matrix = (double[][])((Object[])new double[][]{c0, c1, c2, c3, c4});
                SmithWatermanConstantGapScoring sw = new SmithWatermanConstantGapScoring("AAAA", "AAAA", 1.0, 0.0, -1.0, -1.0);
                Tuple2 tuple2 = sw.buildScoringMatrix();
                if (tuple2 == null) throw new MatchError((Object)tuple2);
                double[][] dArray = (double[][])tuple2._1();
                Predef$ predef$ = Predef$.MODULE$;
                Serializable serializable = new Serializable(this, matrix, dArray){
                    public static final long serialVersionUID = 0L;
                    public final /* synthetic */ $anonfun$4 $outer;
                    public final double[][] matrix$1;
                    public final double[][] swMatrix$1;

                    public final void apply(int j) {
                        this.apply$mcVI$sp(j);
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public void apply$mcVI$sp(int j) {
                        Predef$ predef$ = Predef$.MODULE$;
                        Serializable serializable = new Serializable(this, j){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$4$$anonfun$apply$mcV$sp$1 $outer;
                            private final int j$1;

                            public final void apply(int i) {
                                this.apply$mcVI$sp(i);
                            }

                            public void apply$mcVI$sp(int i) {
                                this.$outer.$outer.$outer.assert(this.$outer.$outer.$outer.fpEquals(this.$outer.swMatrix$1[i][this.j$1], this.$outer.matrix$1[i][this.j$1]));
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.j$1 = j$1;
                            }
                        };
                        Range.Inclusive inclusive = RichInt$.MODULE$.to$extension0(0, 4);
                        if (!inclusive.validateRangeBoundaries((Function1)serializable)) return;
                        int n = inclusive.start();
                        int n2 = inclusive.terminalElement();
                        int n3 = inclusive.step();
                        while (n != n2) {
                            serializable.apply$mcVI$sp(n);
                            n += n3;
                        }
                        return;
                    }

                    public /* synthetic */ $anonfun$4 org$bdgenomics$adam$algorithms$smithwaterman$SmithWatermanSuite$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.matrix$1 = matrix$1;
                        this.swMatrix$1 = swMatrix$1;
                    }
                };
                Range.Inclusive inclusive = RichInt$.MODULE$.to$extension0(0, 4);
                if (!inclusive.validateRangeBoundaries((Function1)serializable)) return;
                int n = inclusive.start();
                int n2 = inclusive.terminalElement();
                int n3 = inclusive.step();
                while (n != n2) {
                    serializable.apply$mcVI$sp(n);
                    n += n3;
                }
                return;
            }

            public /* synthetic */ SmithWatermanSuite org$bdgenomics$adam$algorithms$smithwaterman$SmithWatermanSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("score irregular scoring matrix", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            public final /* synthetic */ SmithWatermanSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void apply$mcV$sp() {
                double[] c0 = new double[]{0.0, 0.0, 0.0, 0.0, 0.0};
                double[] c1 = new double[]{0.0, 1.0, 0.0, 0.0, 0.0};
                double[] c2 = new double[]{0.0, 0.0, 2.0, 1.0, 0.0};
                double[] c3 = new double[]{0.0, 1.0, 1.0, 2.0, 1.0};
                double[] c4 = new double[]{0.0, 0.0, 1.0, 1.0, 3.0};
                double[] c5 = new double[]{0.0, 0.0, 0.0, 2.0, 2.0};
                double[] c6 = new double[]{0.0, 1.0, 0.0, 1.0, 2.0};
                double[][] matrix = (double[][])((Object[])new double[][]{c0, c1, c2, c3, c4, c5, c6});
                SmithWatermanConstantGapScoring sw = new SmithWatermanConstantGapScoring("ACATGA", "ACGT", 1.0, 0.0, -1.0, -1.0);
                Tuple2 tuple2 = sw.buildScoringMatrix();
                if (tuple2 == null) throw new MatchError((Object)tuple2);
                double[][] dArray = (double[][])tuple2._1();
                Predef$ predef$ = Predef$.MODULE$;
                Serializable serializable = new Serializable(this, matrix, dArray){
                    public static final long serialVersionUID = 0L;
                    public final /* synthetic */ $anonfun$5 $outer;
                    public final double[][] matrix$2;
                    public final double[][] swMatrix$2;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public void apply$mcVI$sp(int i) {
                        Predef$ predef$ = Predef$.MODULE$;
                        Serializable serializable = new Serializable(this, i){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$5$$anonfun$apply$mcV$sp$2 $outer;
                            private final int i$1;

                            public final void apply(int j) {
                                this.apply$mcVI$sp(j);
                            }

                            public void apply$mcVI$sp(int j) {
                                this.$outer.$outer.$outer.assert(this.$outer.$outer.$outer.fpEquals(this.$outer.swMatrix$2[this.i$1][j], this.$outer.matrix$2[this.i$1][j]));
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.i$1 = i$1;
                            }
                        };
                        Range.Inclusive inclusive = RichInt$.MODULE$.to$extension0(0, 4);
                        if (!inclusive.validateRangeBoundaries((Function1)serializable)) return;
                        int n = inclusive.start();
                        int n2 = inclusive.terminalElement();
                        int n3 = inclusive.step();
                        while (n != n2) {
                            serializable.apply$mcVI$sp(n);
                            n += n3;
                        }
                        return;
                    }

                    public /* synthetic */ $anonfun$5 org$bdgenomics$adam$algorithms$smithwaterman$SmithWatermanSuite$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.matrix$2 = matrix$2;
                        this.swMatrix$2 = swMatrix$2;
                    }
                };
                Range.Inclusive inclusive = RichInt$.MODULE$.to$extension0(0, 6);
                if (!inclusive.validateRangeBoundaries((Function1)serializable)) return;
                int n = inclusive.start();
                int n2 = inclusive.terminalElement();
                int n3 = inclusive.step();
                while (n != n2) {
                    serializable.apply$mcVI$sp(n);
                    n += n3;
                }
                return;
            }

            public /* synthetic */ SmithWatermanSuite org$bdgenomics$adam$algorithms$smithwaterman$SmithWatermanSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("score irregular scoring matrix with indel", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            public final /* synthetic */ SmithWatermanSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void apply$mcV$sp() {
                double[] c0 = new double[]{0.0, 0.0, 0.0, 0.0, 0.0};
                double[] c1 = new double[]{0.0, 1.0, 0.5, 0.0, 1.0};
                double[] c2 = new double[]{0.0, 0.5, 2.0, 1.5, 1.0};
                double[] c3 = new double[]{0.0, 1.0, 1.5, 2.0, 2.5};
                double[] c4 = new double[]{0.0, 0.5, 1.0, 1.5, 2.0};
                double[] c5 = new double[]{0.0, 0.0, 0.5, 2.0, 1.5};
                double[] c6 = new double[]{0.0, 1.0, 0.5, 1.5, 3.0};
                double[][] matrix = (double[][])((Object[])new double[][]{c0, c1, c2, c3, c4, c5, c6});
                SmithWatermanConstantGapScoring sw = new SmithWatermanConstantGapScoring("ACATGA", "ACGA", 1.0, 0.0, -0.5, -0.5);
                Tuple2 tuple2 = sw.buildScoringMatrix();
                if (tuple2 == null) throw new MatchError((Object)tuple2);
                double[][] dArray = (double[][])tuple2._1();
                Predef$ predef$ = Predef$.MODULE$;
                Serializable serializable = new Serializable(this, matrix, dArray){
                    public static final long serialVersionUID = 0L;
                    public final /* synthetic */ $anonfun$6 $outer;
                    public final double[][] matrix$3;
                    public final double[][] swMatrix$3;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public void apply$mcVI$sp(int i) {
                        Predef$ predef$ = Predef$.MODULE$;
                        Serializable serializable = new Serializable(this, i){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$6$$anonfun$apply$mcV$sp$3 $outer;
                            private final int i$2;

                            public final void apply(int j) {
                                this.apply$mcVI$sp(j);
                            }

                            public void apply$mcVI$sp(int j) {
                                this.$outer.$outer.$outer.assert(this.$outer.$outer.$outer.fpEquals(this.$outer.swMatrix$3[this.i$2][j], this.$outer.matrix$3[this.i$2][j]));
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.i$2 = i$2;
                            }
                        };
                        Range.Inclusive inclusive = RichInt$.MODULE$.to$extension0(0, 4);
                        if (!inclusive.validateRangeBoundaries((Function1)serializable)) return;
                        int n = inclusive.start();
                        int n2 = inclusive.terminalElement();
                        int n3 = inclusive.step();
                        while (n != n2) {
                            serializable.apply$mcVI$sp(n);
                            n += n3;
                        }
                        return;
                    }

                    public /* synthetic */ $anonfun$6 org$bdgenomics$adam$algorithms$smithwaterman$SmithWatermanSuite$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.matrix$3 = matrix$3;
                        this.swMatrix$3 = swMatrix$3;
                    }
                };
                Range.Inclusive inclusive = RichInt$.MODULE$.to$extension0(0, 6);
                if (!inclusive.validateRangeBoundaries((Function1)serializable)) return;
                int n = inclusive.start();
                int n2 = inclusive.terminalElement();
                int n3 = inclusive.step();
                while (n != n2) {
                    serializable.apply$mcVI$sp(n);
                    n += n3;
                }
                return;
            }

            public /* synthetic */ SmithWatermanSuite org$bdgenomics$adam$algorithms$smithwaterman$SmithWatermanSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.swh = new SmithWatermanConstantGapScoring("", "", 0.0, 0.0, 0.0, 0.0);
        this.test("can unroll cigars correctly", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SmithWatermanSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assert(this.$outer.convertToEqualizer(this.$outer.swh().cigarFromRNNCigar("MDDMMMM")).$eq$eq$eq((Object)"4M2D1M"));
                this.$outer.assert(this.$outer.convertToEqualizer(this.$outer.swh().cigarFromRNNCigar("MMMIIMM")).$eq$eq$eq((Object)"2M2I3M"));
                this.$outer.assert(this.$outer.convertToEqualizer(this.$outer.swh().cigarFromRNNCigar("MMMMMMMM")).$eq$eq$eq((Object)"8M"));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("execute simple trackback", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SmithWatermanSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                char[] c0 = new char[]{'T', 'T', 'T', 'T', 'T'};
                char[] c1 = new char[]{'T', 'B', 'B', 'B', 'B'};
                char[] c2 = new char[]{'T', 'B', 'B', 'B', 'B'};
                char[] c3 = new char[]{'T', 'B', 'B', 'B', 'B'};
                char[] c4 = new char[]{'T', 'B', 'B', 'B', 'B'};
                char[][] matrix = (char[][])((Object[])new char[][]{c0, c1, c2, c3, c4});
                Tuple4 tuple4 = this.$outer.swh().move(matrix, 4, 4, "", "");
                if (tuple4 != null) {
                    Tuple2 tuple2 = new Tuple2(tuple4._1(), tuple4._2());
                    String cx = (String)tuple2._1();
                    String cy = (String)tuple2._2();
                    this.$outer.assert(this.$outer.convertToEqualizer(cx).$eq$eq$eq((Object)"4M"));
                    this.$outer.assert(this.$outer.convertToEqualizer(cy).$eq$eq$eq((Object)"4M"));
                    return;
                }
                throw new MatchError((Object)tuple4);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("execute trackback with indel", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SmithWatermanSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                char[] c0 = new char[]{'T', 'T', 'T', 'T', 'T'};
                char[] c1 = new char[]{'T', 'B', 'J', 'T', 'B'};
                char[] c2 = new char[]{'T', 'I', 'B', 'B', 'B'};
                char[] c3 = new char[]{'T', 'B', 'J', 'I', 'B'};
                char[] c4 = new char[]{'T', 'I', 'J', 'B', 'B'};
                char[] c5 = new char[]{'T', 'T', 'I', 'B', 'B'};
                char[] c6 = new char[]{'T', 'B', 'J', 'B', 'B'};
                char[][] matrix = (char[][])((Object[])new char[][]{c0, c1, c2, c3, c4, c5, c6});
                Tuple4 tuple4 = this.$outer.swh().move(matrix, 6, 4, "", "");
                if (tuple4 != null) {
                    Tuple2 tuple2 = new Tuple2(tuple4._1(), tuple4._2());
                    String cx = (String)tuple2._1();
                    String cy = (String)tuple2._2();
                    this.$outer.assert(this.$outer.convertToEqualizer(cx).$eq$eq$eq((Object)"2M2I2M"));
                    this.$outer.assert(this.$outer.convertToEqualizer(cy).$eq$eq$eq((Object)"2M2D2M"));
                    return;
                }
                throw new MatchError((Object)tuple4);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("run end to end smith waterman for simple reads", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SmithWatermanSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SmithWatermanConstantGapScoring sw = new SmithWatermanConstantGapScoring("AAAA", "AAAA", 1.0, 0.0, -1.0, -1.0);
                this.$outer.assert(this.$outer.convertToEqualizer(sw.cigarX().toString()).$eq$eq$eq((Object)"4M"));
                this.$outer.assert(this.$outer.convertToEqualizer(sw.cigarY().toString()).$eq$eq$eq((Object)"4M"));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("run end to end smith waterman for short sequences with indel", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SmithWatermanSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SmithWatermanConstantGapScoring sw = new SmithWatermanConstantGapScoring("ACATGA", "ACGA", 1.0, 0.0, -0.333, -0.333);
                this.$outer.assert(this.$outer.convertToEqualizer(sw.cigarX().toString()).$eq$eq$eq((Object)"2M2I2M"));
                this.$outer.assert(this.$outer.convertToEqualizer(sw.cigarY().toString()).$eq$eq$eq((Object)"2M2D2M"));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("run end to end smith waterman for longer sequences with snp", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SmithWatermanSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SmithWatermanConstantGapScoring sw = new SmithWatermanConstantGapScoring("ATTAGACTACTTAATATACAGATTTACCCCAATAGA", "ATTAGACTACTTAATATACAGAATTACCCCAATAGA", 1.0, 0.0, -0.333, -0.333);
                this.$outer.assert(this.$outer.convertToEqualizer(sw.cigarX().toString()).$eq$eq$eq((Object)"36M"));
                this.$outer.assert(this.$outer.convertToEqualizer(sw.cigarY().toString()).$eq$eq$eq((Object)"36M"));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("run end to end smith waterman for longer sequences with short indel", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SmithWatermanSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SmithWatermanConstantGapScoring sw = new SmithWatermanConstantGapScoring("ATTAGACTACTTAATATACAGATTTACCCCAATAGA", "ATTAGACTACTTAATATACAGATACCCCAATAGA", 1.0, 0.0, -0.333, -0.333);
                this.$outer.assert(this.$outer.convertToEqualizer(sw.cigarX().toString()).$eq$eq$eq((Object)"22M2I12M"));
                this.$outer.assert(this.$outer.convertToEqualizer(sw.cigarY().toString()).$eq$eq$eq((Object)"22M2D12M"));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("run end to end smith waterman for shorter sequence in longer sequence", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SmithWatermanSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SmithWatermanConstantGapScoring sw = new SmithWatermanConstantGapScoring("ATTAGACTACTTAATATACAGATTTACCCCAATAGA", "ACTTAATATACAGATTTACC", 1.0, 0.0, -0.333, -0.333);
                this.$outer.assert(this.$outer.convertToEqualizer(sw.cigarX().toString()).$eq$eq$eq((Object)"20M"));
                this.$outer.assert(this.$outer.convertToEqualizer(sw.cigarY().toString()).$eq$eq$eq((Object)"20M"));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)sw.xStart())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)8)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("run end to end smith waterman for shorter sequence in longer sequence, with indel", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SmithWatermanSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SmithWatermanConstantGapScoring sw = new SmithWatermanConstantGapScoring("ATTAGACTACTTAATATACAGATTTACCCCAATAGA", "ACTTAATATAGATTTACC", 1.0, 0.0, -0.333, -0.333);
                this.$outer.assert(this.$outer.convertToEqualizer(sw.cigarX().toString()).$eq$eq$eq((Object)"9M2I9M"));
                this.$outer.assert(this.$outer.convertToEqualizer(sw.cigarY().toString()).$eq$eq$eq((Object)"9M2D9M"));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)sw.xStart())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)8)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

