/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.converters;

import net.sf.samtools.SAMRecord;
import org.bdgenomics.adam.converters.ADAMRecordConverter;
import org.bdgenomics.adam.models.RecordGroupDictionary;
import org.bdgenomics.adam.models.SAMFileHeaderWritable;
import org.bdgenomics.adam.models.SequenceDictionary;
import org.bdgenomics.adam.models.SequenceDictionary$;
import org.bdgenomics.adam.models.SequenceRecord;
import org.bdgenomics.adam.models.SequenceRecord$;
import org.bdgenomics.formats.avro.ADAMContig;
import org.bdgenomics.formats.avro.ADAMRecord;
import org.scalatest.FunSuite;
import org.scalatest.Tag;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001%3A!\u0001\u0002\u0001\u0017\tA\u0012\tR!N%\u0016\u001cwN\u001d3D_:4XM\u001d;feN+\u0018\u000e^3\u000b\u0005\r!\u0011AC2p]Z,'\u000f^3sg*\u0011QAB\u0001\u0005C\u0012\fWN\u0003\u0002\b\u0011\u0005Q!\rZ4f]>l\u0017nY:\u000b\u0003%\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\u0007\u0011\u00055\u0001R\"\u0001\b\u000b\u0005=A\u0011!C:dC2\fG/Z:u\u0013\t\tbB\u0001\u0005Gk:\u001cV/\u001b;f\u0011\u0015\u0019\u0002\u0001\"\u0001\u0015\u0003\u0019a\u0014N\\5u}Q\tQ\u0003\u0005\u0002\u0017\u00015\t!\u0001C\u0003\u0019\u0001\u0011\u0005\u0011$A\u0005nC.,wL]3bIR1!D\t\u00164ki\u0002\"a\u0007\u0011\u000e\u0003qQ!!\b\u0010\u0002\t\u00054(o\u001c\u0006\u0003?\u0019\tqAZ8s[\u0006$8/\u0003\u0002\"9\tQ\u0011\tR!N%\u0016\u001cwN\u001d3\t\u000b\r:\u0002\u0019\u0001\u0013\u0002\u000bM$\u0018M\u001d;\u0011\u0005\u0015BS\"\u0001\u0014\u000b\u0003\u001d\nQa]2bY\u0006L!!\u000b\u0014\u0003\t1{gn\u001a\u0005\u0006W]\u0001\r\u0001L\u0001\u0006G&<\u0017M\u001d\t\u0003[Ar!!\n\u0018\n\u0005=2\u0013A\u0002)sK\u0012,g-\u0003\u00022e\t11\u000b\u001e:j]\u001eT!a\f\u0014\t\u000bQ:\u0002\u0019\u0001\u0017\u0002\u000b5$G/Y4\t\u000bY:\u0002\u0019A\u001c\u0002\r1,gn\u001a;i!\t)\u0003(\u0003\u0002:M\t\u0019\u0011J\u001c;\t\u000fm:\u0002\u0013!a\u0001o\u0005\u0011\u0011\u000e\u001a\u0005\b{\u0001\t\n\u0011\"\u0001?\u0003Mi\u0017m[3`e\u0016\fG\r\n3fM\u0006,H\u000e\u001e\u00136+\u0005y$FA\u001cAW\u0005\t\u0005C\u0001\"H\u001b\u0005\u0019%B\u0001#F\u0003%)hn\u00195fG.,GM\u0003\u0002GM\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005!\u001b%!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0002")
public class ADAMRecordConverterSuite
extends FunSuite {
    public ADAMRecord make_read(long start, String cigar, String mdtag, int length, int id) {
        Predef$ predef$ = Predef$.MODULE$;
        String sequence = new StringOps("A").$times(length);
        return ADAMRecord.newBuilder().setReadName((CharSequence)new StringBuilder().append((Object)"read").append((Object)((Object)BoxesRunTime.boxToInteger((int)id)).toString()).toString()).setStart(Predef$.MODULE$.long2Long(start)).setReadMapped(Predef$.MODULE$.boolean2Boolean(true)).setCigar((CharSequence)cigar).setSequence((CharSequence)sequence).setReadNegativeStrand(Predef$.MODULE$.boolean2Boolean(false)).setMapq(Predef$.MODULE$.int2Integer(60)).setQual((CharSequence)sequence).setMismatchingPositions((CharSequence)mdtag).build();
    }

    public int make_read$default$5() {
        return 0;
    }

    public ADAMRecordConverterSuite() {
        this.test("testing the fields in a converted ADAM Read", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ADAMRecordConverterSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ADAMRecord adamRead = this.$outer.make_read(3L, "2M3D2M", "2^AAA2", 4, this.$outer.make_read$default$5());
                adamRead.setRecordGroupName((CharSequence)"testname");
                adamRead.setContig(ADAMContig.newBuilder().setContigName((CharSequence)"referencetest").build());
                adamRead.setMateReference((CharSequence)"matereferencetest");
                adamRead.setMateContig(ADAMContig.newBuilder().setContigName((CharSequence)"matereferencetest").setContigLength(Predef$.MODULE$.long2Long(6L)).setReferenceURL((CharSequence)"test://chrom1").build());
                adamRead.setMateAlignmentStart(Predef$.MODULE$.long2Long(6L));
                SequenceRecord seqRecForDict = SequenceRecord$.MODULE$.apply("referencetest", 5L, (CharSequence)"test://chrom1", SequenceRecord$.MODULE$.apply$default$4(), SequenceRecord$.MODULE$.apply$default$5(), SequenceRecord$.MODULE$.apply$default$6(), SequenceRecord$.MODULE$.apply$default$7(), SequenceRecord$.MODULE$.apply$default$8());
                SequenceDictionary dict = SequenceDictionary$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SequenceRecord[]{seqRecForDict}));
                RecordGroupDictionary readGroups = new RecordGroupDictionary((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$));
                ADAMRecordConverter adamRecordConverter = new ADAMRecordConverter();
                SAMRecord toSAM = adamRecordConverter.convert(adamRead, new SAMFileHeaderWritable(adamRecordConverter.createSAMHeader(dict, readGroups)));
                Predef$ predef$ = Predef$.MODULE$;
                String sequence = new StringOps("A").$times(4);
                this.$outer.assert(this.$outer.convertToEqualizer(toSAM.getReadName()).$eq$eq$eq((Object)new StringBuilder().append((Object)"read").append((Object)((Object)BoxesRunTime.boxToInteger((int)0)).toString()).toString()));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)toSAM.getAlignmentStart())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)4)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)toSAM.getReadUnmappedFlag())).$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)false)));
                this.$outer.assert(this.$outer.convertToEqualizer(toSAM.getCigarString()).$eq$eq$eq((Object)"2M3D2M"));
                this.$outer.assert(this.$outer.convertToEqualizer(toSAM.getReadString()).$eq$eq$eq((Object)sequence));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)toSAM.getReadNegativeStrandFlag())).$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)false)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)toSAM.getMappingQuality())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)60)));
                this.$outer.assert(this.$outer.convertToEqualizer(toSAM.getBaseQualityString()).$eq$eq$eq((Object)sequence));
                this.$outer.assert(this.$outer.convertToEqualizer(toSAM.getAttribute("MD")).$eq$eq$eq((Object)"2^AAA2"));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

