/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.instrumentation;

import com.netflix.servo.monitor.LongGauge;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.StringReader;
import java.util.concurrent.TimeUnit;
import org.apache.spark.Logging;
import org.bdgenomics.adam.instrumentation.ServoTimer;
import org.bdgenomics.adam.instrumentation.SparkMetrics;
import org.bdgenomics.adam.instrumentation.TaskContext;
import org.bdgenomics.adam.instrumentation.TaskTimer;
import org.scalatest.FunSuite;
import org.scalatest.Tag;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.util.control.Breaks$;

@ScalaSignature(bytes="\u0006\u0001\u00055a\u0001B\u0001\u0003\u0001-\u0011\u0011c\u00159be.lU\r\u001e:jGN\u001cV/\u001b;f\u0015\t\u0019A!A\bj]N$(/^7f]R\fG/[8o\u0015\t)a!\u0001\u0003bI\u0006l'BA\u0004\t\u0003)\u0011GmZ3o_6L7m\u001d\u0006\u0002\u0013\u0005\u0019qN]4\u0004\u0001M\u0019\u0001\u0001\u0004\n\u0011\u00055\u0001R\"\u0001\b\u000b\u0005=A\u0011!C:dC2\fG/Z:u\u0013\t\tbB\u0001\u0005Gk:\u001cV/\u001b;f!\t\u0019\u0002$D\u0001\u0015\u0015\t)b#A\u0003ta\u0006\u00148N\u0003\u0002\u0018\u0011\u00051\u0011\r]1dQ\u0016L!!\u0007\u000b\u0003\u000f1{wmZ5oO\")1\u0004\u0001C\u00019\u00051A(\u001b8jiz\"\u0012!\b\t\u0003=\u0001i\u0011A\u0001\u0005\u0006A\u0001!I!I\u0001\u001aO\u0016$X\t\u001f9fGR,Gm\u0015;bO\u0016$UO]1uS>t7/F\u0001#!\r\u0019c\u0005K\u0007\u0002I)\tQ%A\u0003tG\u0006d\u0017-\u0003\u0002(I\t)\u0011I\u001d:bsB\u00191EJ\u0015\u0011\u0005)jcBA\u0012,\u0013\taC%\u0001\u0004Qe\u0016$WMZ\u0005\u0003]=\u0012aa\u0015;sS:<'B\u0001\u0017%\u0011\u0015\t\u0004\u0001\"\u0003\"\u0003a9W\r^#ya\u0016\u001cG/\u001a3Pm\u0016\u0014\u0018\r\u001c7WC2,Xm\u001d\u0005\u0006g\u0001!I!I\u0001\u0018O\u0016$X\t\u001f9fGR,GMV1mk\u0016\u001c()\u001f%pgRDQ!\u000e\u0001\u0005\n\u0005\n\u0001dZ3u\u000bb\u0004Xm\u0019;fIZ\u000bG.^3t\u0005f\u001cF/Y4f\u0011\u00159\u0004\u0001\"\u00039\u0003)\u0019\u0007.Z2l)\u0006\u0014G.\u001a\u000b\u0005sqr\u0004\t\u0005\u0002$u%\u00111\b\n\u0002\u0005+:LG\u000fC\u0003>m\u0001\u0007\u0011&\u0001\u0003oC6,\u0007\"B 7\u0001\u0004\u0011\u0013AD3ya\u0016\u001cG/\u001a3WC2,Xm\u001d\u0005\u0006\u0003Z\u0002\rAQ\u0001\u0007e\u0016\fG-\u001a:\u0011\u0005\rCU\"\u0001#\u000b\u0005\u00153\u0015AA5p\u0015\u00059\u0015\u0001\u00026bm\u0006L!!\u0013#\u0003\u001d\t+hMZ3sK\u0012\u0014V-\u00193fe\")1\n\u0001C\u0005\u0019\u0006\u0019\u0012\r\u001a<b]\u000e,'+Z1eKJ$vNT1nKR\u0019\u0011(\u0014(\t\u000buR\u0005\u0019A\u0015\t\u000b\u0005S\u0005\u0019\u0001\"\t\u000bA\u0003A\u0011B)\u0002\u0019\r|W\u000e]1sK2Kg.Z:\u0015\u0007e\u0012F\u000bC\u0003T\u001f\u0002\u0007\u0001&\u0001\u0004bGR,\u0018\r\u001c\u0005\u0006+>\u0003\r\u0001K\u0001\tKb\u0004Xm\u0019;fI\")q\u000b\u0001C\u00051\u0006A\u0011\r\u001a3WC2,X\rF\u0003:3z\u001bW\rC\u0003[-\u0002\u00071,A\u0003uS6,'\u000f\u0005\u0002\u001f9&\u0011QL\u0001\u0002\n)\u0006\u001c8\u000eV5nKJDQa\u0018,A\u0002\u0001\fQA^1mk\u0016\u0004\"aI1\n\u0005\t$#\u0001\u0002'p]\u001eDQ\u0001\u001a,A\u0002%\nA\u0001[8ti\")aM\u0016a\u0001O\u0006)1\u000f^1hKB\u00111\u0005[\u0005\u0003S\u0012\u00121!\u00138u\u0011\u0015Y\u0007\u0001\"\u0003m\u0003A9W\r\u001e*f]\u0012,'/\u001a3UC\ndW\r\u0006\u0002*[\")aN\u001ba\u0001_\u0006IQ._'fiJL7m\u001d\t\u0003aFl\u0011\u0001\u0001\u0004\u0005e\u0002!1OA\u0005Ns6+GO]5dgN\u0011\u0011\u000f\u001e\t\u0003=UL!A\u001e\u0002\u0003\u0019M\u0003\u0018M]6NKR\u0014\u0018nY:\t\u000bm\tH\u0011\u0001=\u0015\u0003=DqA_9C\u0002\u0013\u000510A\u0004nKR\u0014\u0018nY\u0019\u0016\u0003mCa!`9!\u0002\u0013Y\u0016\u0001C7fiJL7-\r\u0011\t\u000f}\f(\u0019!C\u0001w\u00069Q.\u001a;sS\u000e\u0014\u0004bBA\u0002c\u0002\u0006IaW\u0001\t[\u0016$(/[23A!9\u0011q\u0001\u0001\u0005\n\u0005%\u0011!\u00034s_6t\u0015M\\8t)\r\u0001\u00171\u0002\u0005\u0007?\u0006\u0015\u0001\u0019\u00011")
public class SparkMetricsSuite
extends FunSuite
implements Logging {
    private transient Logger org$apache$spark$Logging$$log_;

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public String[][] org$bdgenomics$adam$instrumentation$SparkMetricsSuite$$getExpectedStageDurations() {
        return (String[][])((Object[])new String[][]{(String[])((Object[])new String[]{"Stage ID & Name", "Duration"}), (String[])((Object[])new String[]{"2: stage2", "200 ms"}), (String[])((Object[])new String[]{"1: unknown", "100 ms"}), (String[])((Object[])new String[]{"TOTAL", "300 ms"})});
    }

    public String[][] org$bdgenomics$adam$instrumentation$SparkMetricsSuite$$getExpectedOverallValues() {
        return (String[][])((Object[])new String[][]{(String[])((Object[])new String[]{"Metric", "Total Time", "Count", "Mean", "Min", "Max"}), (String[])((Object[])new String[]{"Metric 2", "833 ms", "4", "208.25 ms", "200 ms", "212 ms"}), (String[])((Object[])new String[]{"Metric 1", "433 ms", "4", "108.25 ms", "100 ms", "112 ms"})});
    }

    public String[][] org$bdgenomics$adam$instrumentation$SparkMetricsSuite$$getExpectedValuesByHost() {
        return (String[][])((Object[])new String[][]{(String[])((Object[])new String[]{"Metric", "Host", "Total Time", "Count", "Mean", "Min", "Max"}), (String[])((Object[])new String[]{"Metric 2", "host2", "423 ms", "2", "211.5 ms", "211 ms", "212 ms"}), (String[])((Object[])new String[]{"Metric 2", "host1", "410 ms", "2", "205 ms", "200 ms", "210 ms"}), (String[])((Object[])new String[]{"Metric 1", "host2", "223 ms", "2", "111.5 ms", "111 ms", "112 ms"}), (String[])((Object[])new String[]{"Metric 1", "host1", "210 ms", "2", "105 ms", "100 ms", "110 ms"})});
    }

    public String[][] org$bdgenomics$adam$instrumentation$SparkMetricsSuite$$getExpectedValuesByStage() {
        return (String[][])((Object[])new String[][]{(String[])((Object[])new String[]{"Metric", "Stage ID & Name", "Total Time", "Count", "Mean", "Min", "Max"}), (String[])((Object[])new String[]{"Metric 2", "2: stage2", "421 ms", "2", "210.5 ms", "210 ms", "211 ms"}), (String[])((Object[])new String[]{"Metric 2", "1: unknown", "412 ms", "2", "206 ms", "200 ms", "212 ms"}), (String[])((Object[])new String[]{"Metric 1", "2: stage2", "221 ms", "2", "110.5 ms", "110 ms", "111 ms"}), (String[])((Object[])new String[]{"Metric 1", "1: unknown", "212 ms", "2", "106 ms", "100 ms", "112 ms"})});
    }

    public void org$bdgenomics$adam$instrumentation$SparkMetricsSuite$$checkTable(String name, String[][] expectedValues, BufferedReader reader) {
        this.advanceReaderToName(name, reader);
        IntRef index = new IntRef(0);
        Breaks$.MODULE$.breakable((Function0)new Serializable(this, expectedValues, reader, index){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SparkMetricsSuite $outer;
            private final String[][] expectedValues$1;
            private final BufferedReader reader$1;
            private final IntRef index$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                while (true) {
                    String line;
                    if ((line = this.reader$1.readLine()) == null) {
                        throw this.$outer.fail("Read past the end of the reader");
                    }
                    if (!line.startsWith("|")) continue;
                    String string = line.substring(1);
                    Predef$ predef$ = Predef$.MODULE$;
                    String[] splitLine = new StringOps(string).split('|');
                    this.$outer.org$bdgenomics$adam$instrumentation$SparkMetricsSuite$$compareLines(splitLine, this.expectedValues$1[this.index$1.elem]);
                    ++this.index$1.elem;
                    if (this.index$1.elem > this.expectedValues$1.length - 1) break;
                }
                throw Breaks$.MODULE$.break();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.expectedValues$1 = expectedValues$1;
                this.reader$1 = reader$1;
                this.index$1 = index$1;
            }
        });
    }

    private void advanceReaderToName(String name, BufferedReader reader) {
        Breaks$.MODULE$.breakable((Function0)new Serializable(this, name, reader){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SparkMetricsSuite $outer;
            private final String name$1;
            private final BufferedReader reader$2;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String line;
                do {
                    if ((line = this.reader$2.readLine()) != null) continue;
                    throw this.$outer.fail(new StringBuilder().append((Object)"Could not find name [").append((Object)this.name$1).append((Object)"]").toString());
                } while (!line.startsWith(this.name$1));
                throw Breaks$.MODULE$.break();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.name$1 = name$1;
                this.reader$2 = reader$2;
            }
        });
    }

    public void org$bdgenomics$adam$instrumentation$SparkMetricsSuite$$compareLines(String[] actual, String[] expected) {
        this.assert(this.convertToEqualizer(BoxesRunTime.boxToInteger((int)actual.length)).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)expected.length)));
        IntRef expectedIndex = new IntRef(0);
        Predef$.MODULE$.refArrayOps((Object[])actual).foreach((Function1)new Serializable(this, expected, expectedIndex){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SparkMetricsSuite $outer;
            private final String[] expected$1;
            private final IntRef expectedIndex$1;

            public final void apply(String actualCell) {
                this.$outer.assert(this.$outer.convertToEqualizer(actualCell.trim()).$eq$eq$eq((Object)this.expected$1[this.expectedIndex$1.elem]));
                ++this.expectedIndex$1.elem;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.expected$1 = expected$1;
                this.expectedIndex$1 = expectedIndex$1;
            }
        });
    }

    public void org$bdgenomics$adam$instrumentation$SparkMetricsSuite$$addValue(TaskTimer timer, long value, String host, int stage) {
        TaskContext taskContext = new TaskContext(host, stage);
        timer.$plus$eq(value, taskContext);
    }

    public String org$bdgenomics$adam$instrumentation$SparkMetricsSuite$$getRenderedTable(MyMetrics myMetrics) {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(bytes);
        myMetrics.print(out);
        return bytes.toString("UTF8");
    }

    public long org$bdgenomics$adam$instrumentation$SparkMetricsSuite$$fromNanos(long value) {
        return TimeUnit.MILLISECONDS.convert(value, TimeUnit.NANOSECONDS);
    }

    public SparkMetricsSuite() {
        Logging.class.$init$((Logging)this);
        this.test("Task metrics are captured correctly", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SparkMetricsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                MyMetrics myMetrics = this.$outer.new MyMetrics();
                this.$outer.org$bdgenomics$adam$instrumentation$SparkMetricsSuite$$addValue(myMetrics.metric1(), 100L, "host1", 1);
                this.$outer.org$bdgenomics$adam$instrumentation$SparkMetricsSuite$$addValue(myMetrics.metric1(), 110L, "host1", 2);
                this.$outer.org$bdgenomics$adam$instrumentation$SparkMetricsSuite$$addValue(myMetrics.metric1(), 111L, "host2", 2);
                this.$outer.org$bdgenomics$adam$instrumentation$SparkMetricsSuite$$addValue(myMetrics.metric1(), 112L, "host2", 1);
                this.$outer.org$bdgenomics$adam$instrumentation$SparkMetricsSuite$$addValue(myMetrics.metric1(), 113L, "host3", 3);
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)this.$outer.org$bdgenomics$adam$instrumentation$SparkMetricsSuite$$fromNanos(myMetrics.metric1().overallTimings().getTotalTime()))).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)546)));
                HashMap stageTimings = myMetrics.metric1().timingsByStageId();
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)this.$outer.org$bdgenomics$adam$instrumentation$SparkMetricsSuite$$fromNanos(((ServoTimer)stageTimings.get((Object)BoxesRunTime.boxToInteger((int)1)).get()).getTotalTime()))).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)212)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)this.$outer.org$bdgenomics$adam$instrumentation$SparkMetricsSuite$$fromNanos(((ServoTimer)stageTimings.get((Object)BoxesRunTime.boxToInteger((int)2)).get()).getTotalTime()))).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)221)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)this.$outer.org$bdgenomics$adam$instrumentation$SparkMetricsSuite$$fromNanos(((ServoTimer)stageTimings.get((Object)BoxesRunTime.boxToInteger((int)3)).get()).getTotalTime()))).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)113)));
                HashMap hostTimings = myMetrics.metric1().timingsByHost();
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)this.$outer.org$bdgenomics$adam$instrumentation$SparkMetricsSuite$$fromNanos(((ServoTimer)hostTimings.get((Object)"host1").get()).getTotalTime()))).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)210)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)this.$outer.org$bdgenomics$adam$instrumentation$SparkMetricsSuite$$fromNanos(((ServoTimer)hostTimings.get((Object)"host2").get()).getTotalTime()))).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)223)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)this.$outer.org$bdgenomics$adam$instrumentation$SparkMetricsSuite$$fromNanos(((ServoTimer)hostTimings.get((Object)"host3").get()).getTotalTime()))).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)113)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Stage metrics are captured correctly", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SparkMetricsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                MyMetrics myMetrics = this.$outer.new MyMetrics();
                myMetrics.recordStageDuration(1, (Option)new Some((Object)"stage1"), (Duration)Duration$.MODULE$.apply(100L, TimeUnit.MILLISECONDS));
                myMetrics.recordStageDuration(2, (Option)None$.MODULE$, (Duration)Duration$.MODULE$.apply(200L, TimeUnit.MILLISECONDS));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)this.$outer.org$bdgenomics$adam$instrumentation$SparkMetricsSuite$$fromNanos(((LongGauge)myMetrics.stageTimes().get((Object)"1: stage1").get()).getNumber().longValue()))).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)100)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)this.$outer.org$bdgenomics$adam$instrumentation$SparkMetricsSuite$$fromNanos(((LongGauge)myMetrics.stageTimes().get((Object)"2: unknown").get()).getNumber().longValue()))).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)200)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Metrics are rendered correctly", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SparkMetricsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                MyMetrics myMetrics = this.$outer.new MyMetrics();
                this.$outer.org$bdgenomics$adam$instrumentation$SparkMetricsSuite$$addValue(myMetrics.metric1(), 100L, "host1", 1);
                this.$outer.org$bdgenomics$adam$instrumentation$SparkMetricsSuite$$addValue(myMetrics.metric1(), 110L, "host1", 2);
                this.$outer.org$bdgenomics$adam$instrumentation$SparkMetricsSuite$$addValue(myMetrics.metric1(), 111L, "host2", 2);
                this.$outer.org$bdgenomics$adam$instrumentation$SparkMetricsSuite$$addValue(myMetrics.metric1(), 112L, "host2", 1);
                this.$outer.org$bdgenomics$adam$instrumentation$SparkMetricsSuite$$addValue(myMetrics.metric2(), 200L, "host1", 1);
                this.$outer.org$bdgenomics$adam$instrumentation$SparkMetricsSuite$$addValue(myMetrics.metric2(), 210L, "host1", 2);
                this.$outer.org$bdgenomics$adam$instrumentation$SparkMetricsSuite$$addValue(myMetrics.metric2(), 211L, "host2", 2);
                this.$outer.org$bdgenomics$adam$instrumentation$SparkMetricsSuite$$addValue(myMetrics.metric2(), 212L, "host2", 1);
                myMetrics.recordStageDuration(1, (Option)None$.MODULE$, (Duration)Duration$.MODULE$.apply(100L, TimeUnit.MILLISECONDS));
                myMetrics.recordStageDuration(2, (Option)new Some((Object)"stage2"), (Duration)Duration$.MODULE$.apply(200L, TimeUnit.MILLISECONDS));
                myMetrics.mapStageIdToName(2, "stage2");
                String renderedTable = this.$outer.org$bdgenomics$adam$instrumentation$SparkMetricsSuite$$getRenderedTable(myMetrics);
                BufferedReader reader = new BufferedReader(new StringReader(renderedTable));
                String[][] expectedStageDurations = this.$outer.org$bdgenomics$adam$instrumentation$SparkMetricsSuite$$getExpectedStageDurations();
                this.$outer.org$bdgenomics$adam$instrumentation$SparkMetricsSuite$$checkTable("Stage Durations", expectedStageDurations, reader);
                String[][] expectedOverallValues = this.$outer.org$bdgenomics$adam$instrumentation$SparkMetricsSuite$$getExpectedOverallValues();
                this.$outer.org$bdgenomics$adam$instrumentation$SparkMetricsSuite$$checkTable("Task Timings", expectedOverallValues, reader);
                String[][] expectedValuesByHost = this.$outer.org$bdgenomics$adam$instrumentation$SparkMetricsSuite$$getExpectedValuesByHost();
                this.$outer.org$bdgenomics$adam$instrumentation$SparkMetricsSuite$$checkTable("Task Timings By Host", expectedValuesByHost, reader);
                String[][] expectedValuesByStage = this.$outer.org$bdgenomics$adam$instrumentation$SparkMetricsSuite$$getExpectedValuesByStage();
                this.$outer.org$bdgenomics$adam$instrumentation$SparkMetricsSuite$$checkTable("Task Timings By Stage", expectedValuesByStage, reader);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public class MyMetrics
    extends SparkMetrics {
        private final TaskTimer metric1;
        private final TaskTimer metric2;

        public TaskTimer metric1() {
            return this.metric1;
        }

        public TaskTimer metric2() {
            return this.metric2;
        }

        public /* synthetic */ SparkMetricsSuite org$bdgenomics$adam$instrumentation$SparkMetricsSuite$MyMetrics$$$outer() {
            return SparkMetricsSuite.this;
        }

        public MyMetrics() {
            if (SparkMetricsSuite.this == null) {
                throw new NullPointerException();
            }
            this.metric1 = this.taskTimer("Metric 1");
            this.metric2 = this.taskTimer("Metric 2");
        }
    }
}

