/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.io;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import java.io.File;
import java.io.PrintWriter;
import java.net.URI;
import org.bdgenomics.adam.io.ByteArrayByteAccess;
import org.bdgenomics.adam.io.HTTPRangedByteAccess;
import org.bdgenomics.adam.io.LocalFileByteAccess;
import org.bdgenomics.adam.io.S3ByteAccess;
import org.bdgenomics.adam.util.CredentialsProperties;
import org.bdgenomics.adam.util.NetworkConnected$;
import org.bdgenomics.adam.util.S3Test$;
import org.scalatest.FunSuite;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001]2A!\u0001\u0002\u0001\u0017\ty!)\u001f;f\u0003\u000e\u001cWm]:Tk&$XM\u0003\u0002\u0004\t\u0005\u0011\u0011n\u001c\u0006\u0003\u000b\u0019\tA!\u00193b[*\u0011q\u0001C\u0001\u000bE\u0012<WM\\8nS\u000e\u001c(\"A\u0005\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001a\u0001CA\u0007\u0011\u001b\u0005q!BA\b\t\u0003%\u00198-\u00197bi\u0016\u001cH/\u0003\u0002\u0012\u001d\tAa)\u001e8Tk&$X\rC\u0003\u0014\u0001\u0011\u0005A#\u0001\u0004=S:LGO\u0010\u000b\u0002+A\u0011a\u0003A\u0007\u0002\u0005!A\u0001\u0004\u0001EC\u0002\u0013\u0005\u0011$A\u0006de\u0016$WM\u001c;jC2\u001cX#\u0001\u000e\u0011\u0005m\u0011S\"\u0001\u000f\u000b\u0005uq\u0012\u0001B1vi\"T!a\b\u0011\u0002\u0013\u0005l\u0017M_8oC^\u001c(\"A\u0011\u0002\u0007\r|W.\u0003\u0002$9\tq\u0011iV*De\u0016$WM\u001c;jC2\u001c\b\u0002C\u0013\u0001\u0011\u0003\u0005\u000b\u0015\u0002\u000e\u0002\u0019\r\u0014X\rZ3oi&\fGn\u001d\u0011\t\u0011\u001d\u0002\u0001R1A\u0005\u0002!\n!BY;dW\u0016$h*Y7f+\u0005I\u0003C\u0001\u00160\u001b\u0005Y#B\u0001\u0017.\u0003\u0011a\u0017M\\4\u000b\u00039\nAA[1wC&\u0011\u0001g\u000b\u0002\u0007'R\u0014\u0018N\\4\t\u0011I\u0002\u0001\u0012!Q!\n%\n1BY;dW\u0016$h*Y7fA!AA\u0007\u0001EC\u0002\u0013\u0005\u0001&A\bqCJ\fX/\u001a;M_\u000e\fG/[8o\u0011!1\u0004\u0001#A!B\u0013I\u0013\u0001\u00059beF,X\r\u001e'pG\u0006$\u0018n\u001c8!\u0001")
public class ByteAccessSuite
extends FunSuite {
    private AWSCredentials credentials;
    private String bucketName;
    private String parquetLocation;
    private volatile byte bitmap$0;

    private AWSCredentials credentials$lzycompute() {
        ByteAccessSuite byteAccessSuite = this;
        synchronized (byteAccessSuite) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.credentials = new CredentialsProperties((Option)new Some((Object)new File(new StringBuilder().append((Object)System.getProperty("user.home")).append((Object)"/spark.conf").toString()))).awsCredentials((Option)new Some((Object)"s3"));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            // ** MonitorExit[this] (shouldn't be in output)
            return this.credentials;
        }
    }

    private String bucketName$lzycompute() {
        ByteAccessSuite byteAccessSuite = this;
        synchronized (byteAccessSuite) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.bucketName = System.getenv("BUCKET_NAME");
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            // ** MonitorExit[this] (shouldn't be in output)
            return this.bucketName;
        }
    }

    private String parquetLocation$lzycompute() {
        ByteAccessSuite byteAccessSuite = this;
        synchronized (byteAccessSuite) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.parquetLocation = System.getenv("PARQUET_LOCATION");
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
            // ** MonitorExit[this] (shouldn't be in output)
            return this.parquetLocation;
        }
    }

    public AWSCredentials credentials() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.credentials$lzycompute() : this.credentials;
    }

    public String bucketName() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.bucketName$lzycompute() : this.bucketName;
    }

    public String parquetLocation() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.parquetLocation$lzycompute() : this.parquetLocation;
    }

    public ByteAccessSuite() {
        this.test("ByteArrayByteAccess returns arbitrary subsets of bytes correctly", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ByteAccessSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                byte[] bytes = (byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9}), ClassTag$.MODULE$.Byte());
                ByteArrayByteAccess access = new ByteArrayByteAccess(bytes);
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)access.length())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)bytes.length)));
                this.$outer.assert(this.$outer.convertToEqualizer(access.readFully(5L, 5)).$eq$eq$eq(Predef$.MODULE$.byteArrayOps(bytes).slice(5, 10)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("ByteArrayByteAccess supports two successive calls with different offsets", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ByteAccessSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                byte[] bytes = (byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9}), ClassTag$.MODULE$.Byte());
                ByteArrayByteAccess access = new ByteArrayByteAccess(bytes);
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)access.length())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)bytes.length)));
                this.$outer.assert(this.$outer.convertToEqualizer(access.readFully(5L, 5)).$eq$eq$eq(Predef$.MODULE$.byteArrayOps(bytes).slice(5, 10)));
                this.$outer.assert(this.$outer.convertToEqualizer(access.readFully(3L, 5)).$eq$eq$eq(Predef$.MODULE$.byteArrayOps(bytes).slice(3, 8)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("LocalFileByteAccess returns arbitrary subsets of bytes correctly", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ByteAccessSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                File temp = File.createTempFile("byteaccesssuite", "test");
                PrintWriter writer = new PrintWriter(temp);
                writer.print("abcdefghij");
                writer.close();
                LocalFileByteAccess access = new LocalFileByteAccess(temp);
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)access.length())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)"abcdefghij".length())));
                this.$outer.assert(this.$outer.convertToEqualizer(access.readFully(3L, 5)).$eq$eq$eq((Object)"abcdefghij".substring(3, 8).getBytes("ASCII")));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("HTTPRangedByteAccess supports range queries", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[]{NetworkConnected$.MODULE$}), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ByteAccessSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                URI uri = URI.create("http://www.cs.berkeley.edu/~massie/bams/mouse_chrM.bam");
                HTTPRangedByteAccess http = new HTTPRangedByteAccess(uri);
                byte[] bytes1 = http.readFully(100L, 10);
                byte[] bytes2 = http.readFully(100L, 100);
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)bytes1.length)).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)10)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)bytes2.length)).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)100)));
                this.$outer.assert(this.$outer.convertToEqualizer(bytes1).$eq$eq$eq(Predef$.MODULE$.byteArrayOps(bytes2).slice(0, 10)));
                this.$outer.assert(this.$outer.convertToEqualizer(bytes1).$eq$eq$eq(Predef$.MODULE$.intArrayOps(new int[]{188, 185, 119, 110, 102, 222, 76, 23, 189, 139}).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final byte apply(int x$1) {
                        return (byte)x$1;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Byte()))));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("HTTPRangedByteAccess can retrieve a full range", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[]{NetworkConnected$.MODULE$}), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ByteAccessSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                URI uri = URI.create("http://www.eecs.berkeley.edu/Includes/EECS-images/eecslogo.gif");
                HTTPRangedByteAccess http = new HTTPRangedByteAccess(uri);
                byte[] bytes = http.readFully(0L, (int)http.length());
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)bytes.length)).$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)http.length())));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Testing S3 byte access", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[]{NetworkConnected$.MODULE$, S3Test$.MODULE$}), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ByteAccessSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                S3ByteAccess byteAccess = new S3ByteAccess((AmazonS3)new AmazonS3Client(this.$outer.credentials()), this.$outer.bucketName(), this.$outer.parquetLocation());
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToByte((byte)byteAccess.readFully(0L, 1)[0])).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)80)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

