/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.models;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.log4j.Level;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.bdgenomics.adam.models.Consensus;
import org.bdgenomics.adam.models.IndelTable;
import org.bdgenomics.adam.models.IndelTable$;
import org.bdgenomics.adam.models.ReferenceRegion;
import org.bdgenomics.adam.util.SparkFunSuite;
import org.bdgenomics.adam.util.SparkFunSuite$class;
import org.bdgenomics.formats.avro.ADAMContig;
import org.bdgenomics.formats.avro.ADAMVariant;
import org.scalatest.BeforeAndAfter;
import org.scalatest.Distributor;
import org.scalatest.Filter;
import org.scalatest.FunSuite;
import org.scalatest.FunSuiteLike;
import org.scalatest.Reporter;
import org.scalatest.Stopper;
import org.scalatest.Tag;
import org.scalatest.Tracker;
import scala.Function0;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.GenTraversable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00152A!\u0001\u0002\u0001\u0017\ty\u0011J\u001c3fYR\u000b'\r\\3Tk&$XM\u0003\u0002\u0004\t\u00051Qn\u001c3fYNT!!\u0002\u0004\u0002\t\u0005$\u0017-\u001c\u0006\u0003\u000f!\t!B\u00193hK:|W.[2t\u0015\u0005I\u0011aA8sO\u000e\u00011c\u0001\u0001\r%A\u0011Q\u0002E\u0007\u0002\u001d)\u0011q\u0002C\u0001\ng\u000e\fG.\u0019;fgRL!!\u0005\b\u0003\u0011\u0019+hnU;ji\u0016\u0004\"a\u0005\f\u000e\u0003QQ!!\u0006\u0003\u0002\tU$\u0018\u000e\\\u0005\u0003/Q\u0011Qb\u00159be.4UO\\*vSR,\u0007\"B\r\u0001\t\u0003Q\u0012A\u0002\u001fj]&$h\bF\u0001\u001c!\ta\u0002!D\u0001\u0003\u0011\u001dq\u0002A1A\u0005\u0002}\t!\"\u001b8eK2$\u0016M\u00197f+\u0005\u0001\u0003C\u0001\u000f\"\u0013\t\u0011#A\u0001\u0006J]\u0012,G\u000eV1cY\u0016Da\u0001\n\u0001!\u0002\u0013\u0001\u0013aC5oI\u0016dG+\u00192mK\u0002\u0002")
public class IndelTableSuite
extends FunSuite
implements SparkFunSuite {
    private final IndelTable indelTable;
    private SparkContext sc;
    private Option<Map<String, Level>> maybeLevels;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    private volatile boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked;

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public Option<Map<String, Level>> maybeLevels() {
        return this.maybeLevels;
    }

    @Override
    public void maybeLevels_$eq(Option<Map<String, Level>> x$1) {
        this.maybeLevels = x$1;
    }

    @Override
    public void setupSparkContext(String sparkName, boolean silenceSpark) {
        SparkFunSuite$class.setupSparkContext(this, sparkName, silenceSpark);
    }

    @Override
    public void teardownSparkContext() {
        SparkFunSuite$class.teardownSparkContext(this);
    }

    @Override
    public void sparkBefore(String beforeName, boolean silenceSpark, Function0<BoxedUnit> body) {
        SparkFunSuite$class.sparkBefore(this, beforeName, silenceSpark, body);
    }

    @Override
    public void sparkAfter(String beforeName, boolean silenceSpark, Function0<BoxedUnit> body) {
        SparkFunSuite$class.sparkAfter(this, beforeName, silenceSpark, body);
    }

    @Override
    public void sparkTest(String name, boolean silenceSpark, Seq<Tag> tags, Function0<BoxedUnit> body) {
        SparkFunSuite$class.sparkTest(this, name, silenceSpark, tags, body);
    }

    @Override
    public void sparkTest(String name, Function0<BoxedUnit> body) {
        SparkFunSuite$class.sparkTest(this, name, body);
    }

    @Override
    public boolean sparkBefore$default$2() {
        return SparkFunSuite$class.sparkBefore$default$2(this);
    }

    @Override
    public boolean setupSparkContext$default$2() {
        return SparkFunSuite$class.setupSparkContext$default$2(this);
    }

    @Override
    public boolean sparkAfter$default$2() {
        return SparkFunSuite$class.sparkAfter$default$2(this);
    }

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    }

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    }

    public boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked() {
        return this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked;
    }

    public void org$scalatest$BeforeAndAfter$$runHasBeenInvoked_$eq(boolean x$1) {
        this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked = x$1;
    }

    public void org$scalatest$BeforeAndAfter$$super$runTest(String testName, Reporter reporter, Stopper stopper, Map configMap, Tracker tracker) {
        FunSuiteLike.class.runTest((FunSuiteLike)this, (String)testName, (Reporter)reporter, (Stopper)stopper, (Map)configMap, (Tracker)tracker);
    }

    public void org$scalatest$BeforeAndAfter$$super$run(Option testName, Reporter reporter, Stopper stopper, Filter filter, Map configMap, Option distributor, Tracker tracker) {
        FunSuiteLike.class.run((FunSuiteLike)this, (Option)testName, (Reporter)reporter, (Stopper)stopper, (Filter)filter, (Map)configMap, (Option)distributor, (Tracker)tracker);
    }

    public void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$beforeFunctionAtomic_$eq(AtomicReference x$1) {
        this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic = x$1;
    }

    public void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$afterFunctionAtomic_$eq(AtomicReference x$1) {
        this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic = x$1;
    }

    public void before(Function0<Object> fun) {
        BeforeAndAfter.class.before((BeforeAndAfter)this, fun);
    }

    public void after(Function0<Object> fun) {
        BeforeAndAfter.class.after((BeforeAndAfter)this, fun);
    }

    public void runTest(String testName, Reporter reporter, Stopper stopper, Map<String, Object> configMap, Tracker tracker) {
        BeforeAndAfter.class.runTest((BeforeAndAfter)this, (String)testName, (Reporter)reporter, (Stopper)stopper, configMap, (Tracker)tracker);
    }

    public void run(Option<String> testName, Reporter reporter, Stopper stopper, Filter filter, Map<String, Object> configMap, Option<Distributor> distributor, Tracker tracker) {
        BeforeAndAfter.class.run((BeforeAndAfter)this, testName, (Reporter)reporter, (Stopper)stopper, (Filter)filter, configMap, distributor, (Tracker)tracker);
    }

    public IndelTable indelTable() {
        return this.indelTable;
    }

    public IndelTableSuite() {
        BeforeAndAfter.class.$init$((BeforeAndAfter)this);
        SparkFunSuite$class.$init$(this);
        Tuple2[] tuple2Array = new Tuple2[1];
        Predef$ predef$ = Predef$.MODULE$;
        GenTraversable genTraversable = package$.MODULE$.Iterable().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Consensus[]{new Consensus("", new ReferenceRegion("1", 1000L, 1002L))}));
        Predef.ArrowAssoc$ arrowAssoc$ = Predef.ArrowAssoc$.MODULE$;
        tuple2Array[0] = new Tuple2((Object)"1", (Object)genTraversable);
        this.indelTable = new IndelTable((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array)));
        this.test("check for indels in a region with known indels", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IndelTableSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)this.$outer.indelTable().getIndelsInRegion(new ReferenceRegion("1", 0L, 2000L)).length())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("check for indels in a contig that doesn't exist", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IndelTableSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)this.$outer.indelTable().getIndelsInRegion(new ReferenceRegion("0", 0L, 0L)).length())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)0)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("check for indels in a region without known indels", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IndelTableSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)this.$outer.indelTable().getIndelsInRegion(new ReferenceRegion("1", 1002L, 1005L)).length())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)0)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.sparkTest("build indel table from rdd of variants", (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IndelTableSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ADAMContig ctg1 = ADAMContig.newBuilder().setContigName((CharSequence)"1").build();
                ADAMContig ctg2 = ADAMContig.newBuilder().setContigName((CharSequence)"2").build();
                ADAMVariant ins = ADAMVariant.newBuilder().setContig(ctg1).setPosition(Predef$.MODULE$.long2Long(1000L)).setReferenceAllele((CharSequence)"A").setVariantAllele((CharSequence)"ATT").build();
                ADAMVariant del = ADAMVariant.newBuilder().setContig(ctg2).setPosition(Predef$.MODULE$.long2Long(50L)).setReferenceAllele((CharSequence)"ACAT").setVariantAllele((CharSequence)"A").build();
                SparkContext qual$1 = this.$outer.sc();
                Seq x$1 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ADAMVariant[]{ins, del}));
                int x$2 = qual$1.parallelize$default$2();
                RDD rdd = qual$1.parallelize(x$1, x$2, ClassTag$.MODULE$.apply(ADAMVariant.class));
                IndelTable table = IndelTable$.MODULE$.apply(rdd);
                Seq insT = table.getIndelsInRegion(new ReferenceRegion("1", 1000L, 1010L));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)insT.length())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1)));
                this.$outer.assert(this.$outer.convertToEqualizer(((Consensus)insT.head()).consensus()).$eq$eq$eq((Object)"TT"));
                this.$outer.assert(this.$outer.convertToEqualizer(((Consensus)insT.head()).index().referenceName()).$eq$eq$eq((Object)"1"));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)((Consensus)insT.head()).index().start())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1001)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)((Consensus)insT.head()).index().end())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1002)));
                Seq delT = table.getIndelsInRegion(new ReferenceRegion("2", 40L, 60L));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)delT.length())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1)));
                this.$outer.assert(this.$outer.convertToEqualizer(((Consensus)delT.head()).consensus()).$eq$eq$eq((Object)""));
                this.$outer.assert(this.$outer.convertToEqualizer(((Consensus)delT.head()).index().referenceName()).$eq$eq$eq((Object)"2"));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)((Consensus)delT.head()).index().start())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)51)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)((Consensus)delT.head()).index().end())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)54)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

