/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.models;

import net.sf.samtools.SAMReadGroupRecord;
import org.bdgenomics.adam.models.RecordGroup;
import org.bdgenomics.adam.models.RecordGroup$;
import org.bdgenomics.formats.avro.ADAMRecord;
import org.scalatest.FunSuite;
import org.scalatest.Tag;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001]1A!\u0001\u0002\u0001\u0017\tQ\"+Z2pe\u0012<%o\\;q\t&\u001cG/[8oCJL8+^5uK*\u00111\u0001B\u0001\u0007[>$W\r\\:\u000b\u0005\u00151\u0011\u0001B1eC6T!a\u0002\u0005\u0002\u0015\t$w-\u001a8p[&\u001c7OC\u0001\n\u0003\ry'oZ\u0002\u0001'\t\u0001A\u0002\u0005\u0002\u000e!5\taB\u0003\u0002\u0010\u0011\u0005I1oY1mCR,7\u000f^\u0005\u0003#9\u0011\u0001BR;o'VLG/\u001a\u0005\u0006'\u0001!\t\u0001F\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003U\u0001\"A\u0006\u0001\u000e\u0003\t\u0001")
public class RecordGroupDictionarySuite
extends FunSuite {
    public RecordGroupDictionarySuite() {
        this.test("simple conversion to and from sam read group", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RecordGroupDictionarySuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SAMReadGroupRecord origSAMRGR = new SAMReadGroupRecord("myId");
                origSAMRGR.setSample("mySample");
                RecordGroup rg = RecordGroup$.MODULE$.apply(origSAMRGR);
                String string = rg.sample();
                this.$outer.assert(!(string != null ? !string.equals("mySample") : "mySample" != null));
                String string2 = rg.recordGroupName();
                this.$outer.assert(!(string2 != null ? !string2.equals("myId") : "myId" != null));
                SAMReadGroupRecord newSAMRGR = rg.toSAMReadGroupRecord();
                this.$outer.assert(origSAMRGR.equals((Object)newSAMRGR));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("sample name must be set", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RecordGroupDictionarySuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SAMReadGroupRecord samRGR = new SAMReadGroupRecord("myId");
                this.$outer.intercept((Function0)new Serializable(this, samRGR){
                    public static final long serialVersionUID = 0L;
                    private final SAMReadGroupRecord samRGR$1;

                    public final RecordGroup apply() {
                        return RecordGroup$.MODULE$.apply(this.samRGR$1);
                    }
                    {
                        this.samRGR$1 = samRGR$1;
                    }
                }, ManifestFactory$.MODULE$.classType(AssertionError.class));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("create a record group from a read", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RecordGroupDictionarySuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ADAMRecord ar = ADAMRecord.newBuilder().setRecordGroupSample((CharSequence)"mySample").setRecordGroupName((CharSequence)"myName").build();
                Option rg = RecordGroup$.MODULE$.apply(ar);
                this.$outer.assert(rg.isDefined());
                this.$outer.assert(this.$outer.convertToEqualizer(((RecordGroup)rg.get()).sample()).$eq$eq$eq((Object)"mySample"));
                this.$outer.assert(this.$outer.convertToEqualizer(((RecordGroup)rg.get()).recordGroupName()).$eq$eq$eq((Object)"myName"));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("don't create a record group from a read without record group info", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RecordGroupDictionarySuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ADAMRecord ar = ADAMRecord.newBuilder().build();
                Option rg = RecordGroup$.MODULE$.apply(ar);
                this.$outer.assert(rg.isEmpty());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("simple equality checks", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RecordGroupDictionarySuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                RecordGroup rg1a = new RecordGroup("me", "rg1", RecordGroup$.MODULE$.$lessinit$greater$default$3(), RecordGroup$.MODULE$.$lessinit$greater$default$4(), RecordGroup$.MODULE$.$lessinit$greater$default$5(), RecordGroup$.MODULE$.$lessinit$greater$default$6(), RecordGroup$.MODULE$.$lessinit$greater$default$7(), RecordGroup$.MODULE$.$lessinit$greater$default$8(), RecordGroup$.MODULE$.$lessinit$greater$default$9(), RecordGroup$.MODULE$.$lessinit$greater$default$10(), RecordGroup$.MODULE$.$lessinit$greater$default$11());
                Option rg1b = RecordGroup$.MODULE$.apply(ADAMRecord.newBuilder().setRecordGroupSample((CharSequence)"me").setRecordGroupName((CharSequence)"rg1").build());
                RecordGroup rg2 = new RecordGroup("me", "rg2", RecordGroup$.MODULE$.$lessinit$greater$default$3(), RecordGroup$.MODULE$.$lessinit$greater$default$4(), RecordGroup$.MODULE$.$lessinit$greater$default$5(), RecordGroup$.MODULE$.$lessinit$greater$default$6(), RecordGroup$.MODULE$.$lessinit$greater$default$7(), RecordGroup$.MODULE$.$lessinit$greater$default$8(), RecordGroup$.MODULE$.$lessinit$greater$default$9(), RecordGroup$.MODULE$.$lessinit$greater$default$10(), RecordGroup$.MODULE$.$lessinit$greater$default$11());
                RecordGroup rg3 = new RecordGroup("you", "rg1", RecordGroup$.MODULE$.$lessinit$greater$default$3(), RecordGroup$.MODULE$.$lessinit$greater$default$4(), RecordGroup$.MODULE$.$lessinit$greater$default$5(), RecordGroup$.MODULE$.$lessinit$greater$default$6(), RecordGroup$.MODULE$.$lessinit$greater$default$7(), RecordGroup$.MODULE$.$lessinit$greater$default$8(), RecordGroup$.MODULE$.$lessinit$greater$default$9(), RecordGroup$.MODULE$.$lessinit$greater$default$10(), RecordGroup$.MODULE$.$lessinit$greater$default$11());
                this.$outer.assert(rg1a.equals((Object)rg1a));
                this.$outer.assert(this.$outer.convertToEqualizer(rg1a.sample()).$eq$eq$eq((Object)((RecordGroup)rg1b.get()).sample()));
                this.$outer.assert(this.$outer.convertToEqualizer(rg1a.recordGroupName()).$eq$eq$eq((Object)((RecordGroup)rg1b.get()).recordGroupName()));
                this.$outer.assert(!rg1a.equals((Object)rg1b));
                this.$outer.assert(rg1a.equals(rg1b.get()));
                this.$outer.assert(!rg1a.equals((Object)rg2));
                this.$outer.assert(!rg1a.equals((Object)rg3));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

