/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.parquet_reimpl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.spark.Partition;
import org.bdgenomics.adam.io.ByteArrayLocator;
import org.bdgenomics.adam.io.FileLocator;
import org.bdgenomics.adam.io.LocalFileLocator;
import org.bdgenomics.adam.models.ReferenceRegion;
import org.bdgenomics.adam.parquet_reimpl.AvroIndexedParquetRDD;
import org.bdgenomics.adam.parquet_reimpl.AvroParquetRDD;
import org.bdgenomics.adam.parquet_reimpl.RDDFunSuite;
import org.bdgenomics.adam.parquet_reimpl.RDDFunSuite$;
import org.bdgenomics.adam.parquet_reimpl.filters.CombinedFilter;
import org.bdgenomics.adam.parquet_reimpl.filters.FilterTuple;
import org.bdgenomics.adam.parquet_reimpl.index.AvroParquetFileMetadata$;
import org.bdgenomics.adam.parquet_reimpl.index.IDRangeIndex;
import org.bdgenomics.adam.parquet_reimpl.index.IDRangeIndexEntry;
import org.bdgenomics.adam.parquet_reimpl.index.IDRangeIndexGenerator;
import org.bdgenomics.adam.parquet_reimpl.index.IDRangeIndexGenerator$;
import org.bdgenomics.adam.parquet_reimpl.index.IDRangeIndexPredicate;
import org.bdgenomics.adam.parquet_reimpl.index.IDRangeIndexPredicate$;
import org.bdgenomics.adam.parquet_reimpl.index.IDRangeIndexWriter;
import org.bdgenomics.adam.parquet_reimpl.index.IndexEntryPredicate;
import org.bdgenomics.adam.parquet_reimpl.index.ParquetFileMetadata;
import org.bdgenomics.adam.parquet_reimpl.index.ReferenceFolder;
import org.bdgenomics.adam.parquet_reimpl.index.ReferenceFoldingContext$;
import org.bdgenomics.formats.avro.ADAMFlatGenotype;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.io.Codec$;
import scala.io.Source$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u000192A!\u0001\u0002\u0001\u0017\tQ\u0012I\u001e:p\u0013:$W\r_3e!\u0006\u0014\u0018/^3u%\u0012#5+^5uK*\u00111\u0001B\u0001\u000fa\u0006\u0014\u0018/^3u?J,\u0017.\u001c9m\u0015\t)a!\u0001\u0003bI\u0006l'BA\u0004\t\u0003)\u0011GmZ3o_6L7m\u001d\u0006\u0002\u0013\u0005\u0019qN]4\u0004\u0001M\u0011\u0001\u0001\u0004\t\u0003\u001b9i\u0011AA\u0005\u0003\u001f\t\u00111B\u0015#E\rVt7+^5uK\")\u0011\u0003\u0001C\u0001%\u00051A(\u001b8jiz\"\u0012a\u0005\t\u0003\u001b\u0001AQ!\u0006\u0001\u0005\u0002Y\t\u0011c\u001e:ji\u0016Le\u000eZ3y\u0003N\u0014\u0015\u0010^3t)\r9Rd\b\t\u00031mi\u0011!\u0007\u0006\u00035\u0011\t!![8\n\u0005qI\"a\u0003$jY\u0016dunY1u_JDQA\b\u000bA\u0002]\t1B]8pi2{7-\u0019;pe\")\u0001\u0005\u0006a\u0001C\u0005A\u0001/\u0019:rk\u0016$8\u000fE\u0002#K\u001dj\u0011a\t\u0006\u0002I\u0005)1oY1mC&\u0011ae\t\u0002\u000byI,\u0007/Z1uK\u0012t\u0004C\u0001\u0015,\u001d\t\u0011\u0013&\u0003\u0002+G\u00051\u0001K]3eK\u001aL!\u0001L\u0017\u0003\rM#(/\u001b8h\u0015\tQ3\u0005")
public class AvroIndexedParquetRDDSuite
extends RDDFunSuite {
    public FileLocator writeIndexAsBytes(FileLocator rootLocator, Seq<String> parquets) {
        IDRangeIndexGenerator rangeIndexGenerator = new IDRangeIndexGenerator((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(ADAMFlatGenotype v) {
                return ((Object)v.getSampleId()).toString();
            }
        }, IDRangeIndexGenerator$.MODULE$.$lessinit$greater$default$2(), (ReferenceFolder)ReferenceFoldingContext$.MODULE$.adamFlatGenotypeReferenceFolder(), ClassTag$.MODULE$.apply(ADAMFlatGenotype.class));
        Seq entries = (Seq)parquets.flatMap((Function1)new Serializable(this, rootLocator, rangeIndexGenerator){
            public static final long serialVersionUID = 0L;
            private final FileLocator rootLocator$1;
            private final IDRangeIndexGenerator rangeIndexGenerator$1;

            public final Iterator<IDRangeIndexEntry> apply(String x0$1) {
                if (x0$1 != null) {
                    return this.rangeIndexGenerator$1.addParquetFile(this.rootLocator$1, x0$1);
                }
                throw new MatchError((Object)x0$1);
            }
            {
                this.rootLocator$1 = rootLocator$1;
                this.rangeIndexGenerator$1 = rangeIndexGenerator$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        IDRangeIndex rangeIndex = new IDRangeIndex((Iterable)entries);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        IDRangeIndexWriter indexWriter = new IDRangeIndexWriter((OutputStream)byteArrayOutputStream);
        if (false) {
            Predef$.MODULE$.println((Object)"Writing entries: ");
            Predef$.MODULE$.refArrayOps((Object[])rangeIndex.entries()).foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(IDRangeIndexEntry entry) {
                    Predef$.MODULE$.println((Object)entry.line());
                }
            });
        }
        Predef$.MODULE$.refArrayOps((Object[])rangeIndex.entries()).foreach((Function1)new Serializable(this, indexWriter){
            public static final long serialVersionUID = 0L;
            private final IDRangeIndexWriter indexWriter$1;

            public final void apply(IDRangeIndexEntry entry) {
                this.indexWriter$1.write(entry);
            }
            {
                this.indexWriter$1 = indexWriter$1;
            }
        });
        indexWriter.close();
        if (false) {
            Predef$.MODULE$.println((Object)"Wrote lines: ");
            ByteArrayInputStream is = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            Iterator lines = Source$.MODULE$.fromInputStream((InputStream)is, Codec$.MODULE$.fallbackSystemCodec()).getLines();
            lines.foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(Object x) {
                    Predef$.MODULE$.println(x);
                }
            });
        }
        return new ByteArrayLocator(byteArrayOutputStream.toByteArray());
    }

    public AvroIndexedParquetRDDSuite() {
        this.sparkTest("S3AvroIndexedParquetRDD can read a local index and produce the correct records", (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AvroIndexedParquetRDDSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                File inputDataFile = this.$outer.resourceFile("small_adam.fgenotype");
                LocalFileLocator inputDataRootLocator = new LocalFileLocator(inputDataFile.getParentFile());
                FileLocator indexFileLocator = this.$outer.writeIndexAsBytes((FileLocator)inputDataRootLocator, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"small_adam.fgenotype"}));
                ReferenceRegion queryRange = new ReferenceRegion("chr1", 5000L, 15000L);
                FilterTuple filter = new FilterTuple(null, null, (IndexEntryPredicate)new IDRangeIndexPredicate(queryRange));
                AvroIndexedParquetRDD indexedRDD = new AvroIndexedParquetRDD(this.$outer.sc(), (CombinedFilter)filter, indexFileLocator, (FileLocator)inputDataRootLocator, (Option)None$.MODULE$, ClassTag$.MODULE$.apply(ADAMFlatGenotype.class));
                ParquetFileMetadata fileMetadata = AvroParquetFileMetadata$.MODULE$.apply((FileLocator)new LocalFileLocator(inputDataFile), (Option)None$.MODULE$);
                Seq records = indexedRDD.compute((Partition)fileMetadata.partition(0), null).toSeq();
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)records.size())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)15)));
                this.$outer.assert(this.$outer.convertToEqualizer(((SeqLike)records.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final CharSequence apply(ADAMFlatGenotype x$1) {
                        return x$1.getReferenceName();
                    }
                }, Seq$.MODULE$.canBuildFrom())).distinct()).$eq$eq$eq((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"chr1"}))));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.sparkTest("S3AvroIndexedParquetRDD produces no partitions, if the query overlaps no read groups", (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AvroIndexedParquetRDDSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                File inputDataFile = this.$outer.resourceFile("small_adam.fgenotype");
                LocalFileLocator inputDataRootLocator = new LocalFileLocator(inputDataFile.getParentFile());
                FileLocator indexFileLocator = this.$outer.writeIndexAsBytes((FileLocator)inputDataRootLocator, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"small_adam.fgenotype"}));
                ReferenceRegion queryRange = new ReferenceRegion("chr10", 5000L, 15000L);
                FilterTuple filter = new FilterTuple(null, null, (IndexEntryPredicate)new IDRangeIndexPredicate((Option)new Some((Object)queryRange), IDRangeIndexPredicate$.MODULE$.$lessinit$greater$default$2()));
                AvroIndexedParquetRDD indexedRDD = new AvroIndexedParquetRDD(this.$outer.sc(), (CombinedFilter)filter, indexFileLocator, (FileLocator)inputDataRootLocator, (Option)None$.MODULE$, ClassTag$.MODULE$.apply(ADAMFlatGenotype.class));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)indexedRDD.partitions().length)).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)0)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.sparkTest("produces 1 partition when the filter only overlaps one partition", (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AvroIndexedParquetRDDSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                File inputDataFile = this.$outer.resourceFile("jc_adam.fgenotype");
                LocalFileLocator inputDataRootLocator = new LocalFileLocator(inputDataFile.getParentFile());
                FileLocator indexFileLocator = this.$outer.writeIndexAsBytes((FileLocator)inputDataRootLocator, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"jc_adam.fgenotype"}));
                ReferenceRegion queryRange = new ReferenceRegion("1", 60000L, 70000L);
                IDRangeIndexPredicate rangePredicate = new IDRangeIndexPredicate((Option)new Some((Object)queryRange), (Option)new Some((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1e54a67a-e285-4764-954f-83f23c049701"}))));
                FilterTuple filter = new FilterTuple(null, null, (IndexEntryPredicate)rangePredicate);
                IDRangeIndex rangeIndex = new IDRangeIndex(indexFileLocator);
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)rangeIndex.findIndexEntries((IndexEntryPredicate)rangePredicate).toSeq().length())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1)));
                AvroIndexedParquetRDD indexedRDD = new AvroIndexedParquetRDD(this.$outer.sc(), (CombinedFilter)filter, indexFileLocator, (FileLocator)inputDataRootLocator, (Option)None$.MODULE$, ClassTag$.MODULE$.apply(ADAMFlatGenotype.class));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)indexedRDD.partitions().length)).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1)));
                ADAMFlatGenotype[] records = (ADAMFlatGenotype[])indexedRDD.collect();
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)records.length)).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)390)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.sparkTest("indexing produces the same records as the non-indexed RDD", (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AvroIndexedParquetRDDSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                File inputDataFile = this.$outer.resourceFile("jc_adam.fgenotype");
                LocalFileLocator inputDataLocator = new LocalFileLocator(inputDataFile);
                LocalFileLocator inputDataRootLocator = new LocalFileLocator(inputDataFile.getParentFile());
                FileLocator indexFileLocator = this.$outer.writeIndexAsBytes((FileLocator)inputDataRootLocator, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"jc_adam.fgenotype"}));
                ReferenceRegion queryRange = new ReferenceRegion("1", 60000L, 70000L);
                IDRangeIndexPredicate rangePredicate = new IDRangeIndexPredicate((Option)new Some((Object)queryRange), (Option)new Some((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1e54a67a-e285-4764-954f-83f23c049701"}))));
                FilterTuple filter = new FilterTuple(RDDFunSuite$.MODULE$.createRangeFilter(queryRange), null, (IndexEntryPredicate)rangePredicate);
                IDRangeIndex rangeIndex = new IDRangeIndex(indexFileLocator);
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)rangeIndex.findIndexEntries((IndexEntryPredicate)rangePredicate).toSeq().length())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1)));
                AvroIndexedParquetRDD indexedRDD = new AvroIndexedParquetRDD(this.$outer.sc(), (CombinedFilter)filter, indexFileLocator, (FileLocator)inputDataRootLocator, (Option)None$.MODULE$, ClassTag$.MODULE$.apply(ADAMFlatGenotype.class));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)indexedRDD.partitions().length)).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1)));
                AvroParquetRDD nonIndexedRDD = new AvroParquetRDD(this.$outer.sc(), filter.recordFilter(), (FileLocator)inputDataLocator, (Option)None$.MODULE$, ClassTag$.MODULE$.apply(ADAMFlatGenotype.class));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)indexedRDD.count())).$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)nonIndexedRDD.count())));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

