/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.parquet_reimpl;

import com.amazonaws.auth.AWSCredentials;
import java.io.File;
import java.net.URI;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.avro.Schema;
import org.apache.log4j.Level;
import org.apache.spark.SparkContext;
import org.bdgenomics.adam.io.FileLocator;
import org.bdgenomics.adam.io.HTTPFileLocator;
import org.bdgenomics.adam.io.S3FileLocator;
import org.bdgenomics.adam.parquet_reimpl.AvroParquetRDD;
import org.bdgenomics.adam.parquet_reimpl.ReadNameFilter;
import org.bdgenomics.adam.projections.ADAMRecordField$;
import org.bdgenomics.adam.projections.FieldValue;
import org.bdgenomics.adam.projections.Projection$;
import org.bdgenomics.adam.util.CredentialsProperties;
import org.bdgenomics.adam.util.NetworkConnected$;
import org.bdgenomics.adam.util.S3Test$;
import org.bdgenomics.adam.util.SparkFunSuite;
import org.bdgenomics.adam.util.SparkFunSuite$class;
import org.bdgenomics.formats.avro.ADAMRecord;
import org.scalatest.BeforeAndAfter;
import org.scalatest.Distributor;
import org.scalatest.Filter;
import org.scalatest.FunSuite;
import org.scalatest.FunSuiteLike;
import org.scalatest.Reporter;
import org.scalatest.Stopper;
import org.scalatest.Tag;
import org.scalatest.Tracker;
import parquet.filter.UnboundRecordFilter;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001u2A!\u0001\u0002\u0001\u0017\t\u0019\u0012I\u001e:p!\u0006\u0014\u0018/^3u%\u0012#5+^5uK*\u00111\u0001B\u0001\u000fa\u0006\u0014\u0018/^3u?J,\u0017.\u001c9m\u0015\t)a!\u0001\u0003bI\u0006l'BA\u0004\t\u0003)\u0011GmZ3o_6L7m\u001d\u0006\u0002\u0013\u0005\u0019qN]4\u0004\u0001M\u0019\u0001\u0001\u0004\n\u0011\u00055\u0001R\"\u0001\b\u000b\u0005=A\u0011!C:dC2\fG/Z:u\u0013\t\tbB\u0001\u0005Gk:\u001cV/\u001b;f!\t\u0019b#D\u0001\u0015\u0015\t)B!\u0001\u0003vi&d\u0017BA\f\u0015\u00055\u0019\u0006/\u0019:l\rVt7+^5uK\")\u0011\u0004\u0001C\u00015\u00051A(\u001b8jiz\"\u0012a\u0007\t\u00039\u0001i\u0011A\u0001\u0005\t=\u0001A)\u0019!C\u0001?\u0005Y1M]3eK:$\u0018.\u00197t+\u0005\u0001\u0003CA\u0011)\u001b\u0005\u0011#BA\u0012%\u0003\u0011\tW\u000f\u001e5\u000b\u0005\u00152\u0013!C1nCj|g.Y<t\u0015\u00059\u0013aA2p[&\u0011\u0011F\t\u0002\u000f\u0003^\u001b6I]3eK:$\u0018.\u00197t\u0011!Y\u0003\u0001#A!B\u0013\u0001\u0013\u0001D2sK\u0012,g\u000e^5bYN\u0004\u0003\u0002C\u0017\u0001\u0011\u000b\u0007I\u0011\u0001\u0018\u0002\u0015\t,8m[3u\u001d\u0006lW-F\u00010!\t\u0001T'D\u00012\u0015\t\u00114'\u0001\u0003mC:<'\"\u0001\u001b\u0002\t)\fg/Y\u0005\u0003mE\u0012aa\u0015;sS:<\u0007\u0002\u0003\u001d\u0001\u0011\u0003\u0005\u000b\u0015B\u0018\u0002\u0017\t,8m[3u\u001d\u0006lW\r\t\u0005\tu\u0001A)\u0019!C\u0001]\u0005y\u0001/\u0019:rk\u0016$Hj\\2bi&|g\u000e\u0003\u0005=\u0001!\u0005\t\u0015)\u00030\u0003A\u0001\u0018M]9vKRdunY1uS>t\u0007\u0005")
public class AvroParquetRDDSuite
extends FunSuite
implements SparkFunSuite {
    private AWSCredentials credentials;
    private String bucketName;
    private String parquetLocation;
    private SparkContext sc;
    private Option<Map<String, Level>> maybeLevels;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    private volatile boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked;
    private volatile byte bitmap$0;

    private AWSCredentials credentials$lzycompute() {
        AvroParquetRDDSuite avroParquetRDDSuite = this;
        synchronized (avroParquetRDDSuite) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.credentials = new CredentialsProperties((Option)new Some((Object)new File(new StringBuilder().append((Object)System.getProperty("user.home")).append((Object)"/spark.conf").toString()))).awsCredentials((Option)new Some((Object)"s3"));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            // ** MonitorExit[this] (shouldn't be in output)
            return this.credentials;
        }
    }

    private String bucketName$lzycompute() {
        AvroParquetRDDSuite avroParquetRDDSuite = this;
        synchronized (avroParquetRDDSuite) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.bucketName = System.getenv("BUCKET_NAME");
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            // ** MonitorExit[this] (shouldn't be in output)
            return this.bucketName;
        }
    }

    private String parquetLocation$lzycompute() {
        AvroParquetRDDSuite avroParquetRDDSuite = this;
        synchronized (avroParquetRDDSuite) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.parquetLocation = System.getenv("PARQUET_LOCATION");
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
            // ** MonitorExit[this] (shouldn't be in output)
            return this.parquetLocation;
        }
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public Option<Map<String, Level>> maybeLevels() {
        return this.maybeLevels;
    }

    @Override
    public void maybeLevels_$eq(Option<Map<String, Level>> x$1) {
        this.maybeLevels = x$1;
    }

    @Override
    public void setupSparkContext(String sparkName, boolean silenceSpark) {
        SparkFunSuite$class.setupSparkContext(this, sparkName, silenceSpark);
    }

    @Override
    public void teardownSparkContext() {
        SparkFunSuite$class.teardownSparkContext(this);
    }

    @Override
    public void sparkBefore(String beforeName, boolean silenceSpark, Function0<BoxedUnit> body) {
        SparkFunSuite$class.sparkBefore(this, beforeName, silenceSpark, body);
    }

    @Override
    public void sparkAfter(String beforeName, boolean silenceSpark, Function0<BoxedUnit> body) {
        SparkFunSuite$class.sparkAfter(this, beforeName, silenceSpark, body);
    }

    @Override
    public void sparkTest(String name, boolean silenceSpark, Seq<Tag> tags, Function0<BoxedUnit> body) {
        SparkFunSuite$class.sparkTest(this, name, silenceSpark, tags, body);
    }

    @Override
    public void sparkTest(String name, Function0<BoxedUnit> body) {
        SparkFunSuite$class.sparkTest(this, name, body);
    }

    @Override
    public boolean sparkBefore$default$2() {
        return SparkFunSuite$class.sparkBefore$default$2(this);
    }

    @Override
    public boolean setupSparkContext$default$2() {
        return SparkFunSuite$class.setupSparkContext$default$2(this);
    }

    @Override
    public boolean sparkAfter$default$2() {
        return SparkFunSuite$class.sparkAfter$default$2(this);
    }

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    }

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    }

    public boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked() {
        return this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked;
    }

    public void org$scalatest$BeforeAndAfter$$runHasBeenInvoked_$eq(boolean x$1) {
        this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked = x$1;
    }

    public void org$scalatest$BeforeAndAfter$$super$runTest(String testName, Reporter reporter, Stopper stopper, Map configMap, Tracker tracker) {
        FunSuiteLike.class.runTest((FunSuiteLike)this, (String)testName, (Reporter)reporter, (Stopper)stopper, (Map)configMap, (Tracker)tracker);
    }

    public void org$scalatest$BeforeAndAfter$$super$run(Option testName, Reporter reporter, Stopper stopper, Filter filter, Map configMap, Option distributor, Tracker tracker) {
        FunSuiteLike.class.run((FunSuiteLike)this, (Option)testName, (Reporter)reporter, (Stopper)stopper, (Filter)filter, (Map)configMap, (Option)distributor, (Tracker)tracker);
    }

    public void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$beforeFunctionAtomic_$eq(AtomicReference x$1) {
        this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic = x$1;
    }

    public void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$afterFunctionAtomic_$eq(AtomicReference x$1) {
        this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic = x$1;
    }

    public void before(Function0<Object> fun) {
        BeforeAndAfter.class.before((BeforeAndAfter)this, fun);
    }

    public void after(Function0<Object> fun) {
        BeforeAndAfter.class.after((BeforeAndAfter)this, fun);
    }

    public void runTest(String testName, Reporter reporter, Stopper stopper, Map<String, Object> configMap, Tracker tracker) {
        BeforeAndAfter.class.runTest((BeforeAndAfter)this, (String)testName, (Reporter)reporter, (Stopper)stopper, configMap, (Tracker)tracker);
    }

    public void run(Option<String> testName, Reporter reporter, Stopper stopper, Filter filter, Map<String, Object> configMap, Option<Distributor> distributor, Tracker tracker) {
        BeforeAndAfter.class.run((BeforeAndAfter)this, testName, (Reporter)reporter, (Stopper)stopper, (Filter)filter, configMap, distributor, (Tracker)tracker);
    }

    public AWSCredentials credentials() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.credentials$lzycompute() : this.credentials;
    }

    public String bucketName() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.bucketName$lzycompute() : this.bucketName;
    }

    public String parquetLocation() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.parquetLocation$lzycompute() : this.parquetLocation;
    }

    public AvroParquetRDDSuite() {
        BeforeAndAfter.class.$init$((BeforeAndAfter)this);
        SparkFunSuite$class.$init$(this);
        this.sparkTest("Retrieve records from a Parquet file through HTTP", true, (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[]{NetworkConnected$.MODULE$}), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AvroParquetRDDSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                HTTPFileLocator locator = new HTTPFileLocator(URI.create("http://www.cs.berkeley.edu/~massie/adams/part1"));
                AvroParquetRDD rdd = new AvroParquetRDD(this.$outer.sc(), null, (FileLocator)locator, (Option)None$.MODULE$, ClassTag$.MODULE$.apply(ADAMRecord.class));
                ADAMRecord value = (ADAMRecord)rdd.first();
                this.$outer.assert(value != null);
                this.$outer.assert(this.$outer.convertToEqualizer(value.getReadName()).$eq$eq$eq((Object)"simread:1:189606653:true"));
                this.$outer.assert(this.$outer.convertToEqualizer(value.getStart()).$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)189606653L)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)rdd.count())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)49)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.sparkTest("Retrieve records from a Parquet file through S3", true, (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[]{NetworkConnected$.MODULE$, S3Test$.MODULE$}), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AvroParquetRDDSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                S3FileLocator locator = new S3FileLocator(this.$outer.credentials(), this.$outer.bucketName(), this.$outer.parquetLocation());
                AvroParquetRDD rdd = new AvroParquetRDD(this.$outer.sc(), null, (FileLocator)locator, (Option)None$.MODULE$, ClassTag$.MODULE$.apply(ADAMRecord.class));
                ADAMRecord value = (ADAMRecord)rdd.first();
                this.$outer.assert(value != null);
                this.$outer.assert(this.$outer.convertToEqualizer(value.getReadName()).$eq$eq$eq((Object)"simread:1:189606653:true"));
                this.$outer.assert(this.$outer.convertToEqualizer(value.getStart()).$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)189606653L)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)rdd.count())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)49)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.sparkTest("Using a projection works with HTTP", true, (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[]{NetworkConnected$.MODULE$}), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AvroParquetRDDSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Schema schema = Projection$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FieldValue[]{ADAMRecordField$.MODULE$.readName(), ADAMRecordField$.MODULE$.start(), ADAMRecordField$.MODULE$.contig()}));
                HTTPFileLocator locator = new HTTPFileLocator(URI.create("http://www.cs.berkeley.edu/~massie/adams/part1"));
                AvroParquetRDD rdd = new AvroParquetRDD(this.$outer.sc(), null, (FileLocator)locator, (Option)new Some((Object)schema), ClassTag$.MODULE$.apply(ADAMRecord.class));
                ADAMRecord value = (ADAMRecord)rdd.first();
                this.$outer.assert(value != null);
                this.$outer.assert(this.$outer.convertToEqualizer(value.getReadName()).$eq$eq$eq((Object)"simread:1:189606653:true"));
                this.$outer.assert(this.$outer.convertToEqualizer(value.getStart()).$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)189606653L)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)rdd.count())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)49)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.sparkTest("Using a projection works with S3", true, (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[]{NetworkConnected$.MODULE$, S3Test$.MODULE$}), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AvroParquetRDDSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Schema schema = Projection$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FieldValue[]{ADAMRecordField$.MODULE$.readName(), ADAMRecordField$.MODULE$.start(), ADAMRecordField$.MODULE$.contig()}));
                S3FileLocator locator = new S3FileLocator(this.$outer.credentials(), this.$outer.bucketName(), this.$outer.parquetLocation());
                AvroParquetRDD rdd = new AvroParquetRDD(this.$outer.sc(), null, (FileLocator)locator, (Option)new Some((Object)schema), ClassTag$.MODULE$.apply(ADAMRecord.class));
                ADAMRecord value = (ADAMRecord)rdd.first();
                this.$outer.assert(value != null);
                this.$outer.assert(this.$outer.convertToEqualizer(value.getReadName()).$eq$eq$eq((Object)"simread:1:189606653:true"));
                this.$outer.assert(this.$outer.convertToEqualizer(value.getStart()).$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)189606653L)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)rdd.count())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)49)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.sparkTest("Using a filter works with HTTP", true, (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[]{NetworkConnected$.MODULE$}), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AvroParquetRDDSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Schema schema = Projection$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FieldValue[]{ADAMRecordField$.MODULE$.readName(), ADAMRecordField$.MODULE$.start(), ADAMRecordField$.MODULE$.sequence()}));
                ReadNameFilter filter = new ReadNameFilter("simread:1:189606653:true");
                HTTPFileLocator locator = new HTTPFileLocator(URI.create("http://www.cs.berkeley.edu/~massie/adams/part1"));
                AvroParquetRDD rdd = new AvroParquetRDD(this.$outer.sc(), (UnboundRecordFilter)filter, (FileLocator)locator, (Option)new Some((Object)schema), ClassTag$.MODULE$.apply(ADAMRecord.class));
                ADAMRecord value = (ADAMRecord)rdd.first();
                this.$outer.assert(value != null);
                this.$outer.assert(this.$outer.convertToEqualizer(value.getReadName()).$eq$eq$eq((Object)"simread:1:189606653:true"));
                this.$outer.assert(this.$outer.convertToEqualizer(value.getStart()).$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)189606653L)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)((ADAMRecord[])rdd.collect()).length)).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)rdd.count())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.sparkTest("Using a filter works with S3", true, (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[]{NetworkConnected$.MODULE$, S3Test$.MODULE$}), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AvroParquetRDDSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Schema schema = Projection$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FieldValue[]{ADAMRecordField$.MODULE$.readName(), ADAMRecordField$.MODULE$.start(), ADAMRecordField$.MODULE$.sequence()}));
                ReadNameFilter filter = new ReadNameFilter("simread:1:189606653:true");
                S3FileLocator locator = new S3FileLocator(this.$outer.credentials(), this.$outer.bucketName(), this.$outer.parquetLocation());
                AvroParquetRDD rdd = new AvroParquetRDD(this.$outer.sc(), (UnboundRecordFilter)filter, (FileLocator)locator, (Option)new Some((Object)schema), ClassTag$.MODULE$.apply(ADAMRecord.class));
                ADAMRecord value = (ADAMRecord)rdd.first();
                this.$outer.assert(value != null);
                this.$outer.assert(this.$outer.convertToEqualizer(value.getReadName()).$eq$eq$eq((Object)"simread:1:189606653:true"));
                this.$outer.assert(this.$outer.convertToEqualizer(value.getStart()).$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)189606653L)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)((ADAMRecord[])rdd.collect()).length)).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)rdd.count())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

