/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.parquet_reimpl;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import java.io.File;
import java.net.URI;
import org.bdgenomics.adam.io.ByteAccess;
import org.bdgenomics.adam.io.HTTPRangedByteAccess;
import org.bdgenomics.adam.io.LocalFileByteAccess;
import org.bdgenomics.adam.io.S3ByteAccess;
import org.bdgenomics.adam.rdd.Footer;
import org.bdgenomics.adam.rdd.ParquetCommon$;
import org.bdgenomics.adam.util.CredentialsProperties;
import org.bdgenomics.adam.util.NetworkConnected$;
import org.bdgenomics.adam.util.S3Test$;
import org.scalatest.FunSuite;
import org.scalatest.Tag;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001}2A!\u0001\u0002\u0001\u0017\t\u0011\u0002+\u0019:rk\u0016$8i\\7n_:\u001cV/\u001b;f\u0015\t\u0019A!\u0001\bqCJ\fX/\u001a;`e\u0016LW\u000e\u001d7\u000b\u0005\u00151\u0011\u0001B1eC6T!a\u0002\u0005\u0002\u0015\t$w-\u001a8p[&\u001c7OC\u0001\n\u0003\ry'oZ\u0002\u0001'\t\u0001A\u0002\u0005\u0002\u000e!5\taB\u0003\u0002\u0010\u0011\u0005I1oY1mCR,7\u000f^\u0005\u0003#9\u0011\u0001BR;o'VLG/\u001a\u0005\u0006'\u0001!\t\u0001F\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003U\u0001\"A\u0006\u0001\u000e\u0003\tA\u0001\u0002\u0007\u0001\t\u0006\u0004%\t!G\u0001\fGJ,G-\u001a8uS\u0006d7/F\u0001\u001b!\tY\"%D\u0001\u001d\u0015\tib$\u0001\u0003bkRD'BA\u0010!\u0003%\tW.\u0019>p]\u0006<8OC\u0001\"\u0003\r\u0019w.\\\u0005\u0003Gq\u0011a\"Q,T\u0007J,G-\u001a8uS\u0006d7\u000f\u0003\u0005&\u0001!\u0005\t\u0015)\u0003\u001b\u00031\u0019'/\u001a3f]RL\u0017\r\\:!\u0011!9\u0003\u0001#b\u0001\n\u0003A\u0013A\u00032vG.,GOT1nKV\t\u0011\u0006\u0005\u0002+_5\t1F\u0003\u0002-[\u0005!A.\u00198h\u0015\u0005q\u0013\u0001\u00026bm\u0006L!\u0001M\u0016\u0003\rM#(/\u001b8h\u0011!\u0011\u0004\u0001#A!B\u0013I\u0013a\u00032vG.,GOT1nK\u0002B\u0001\u0002\u000e\u0001\t\u0006\u0004%\t\u0001K\u0001\u0010a\u0006\u0014\u0018/^3u\u0019>\u001c\u0017\r^5p]\"Aa\u0007\u0001E\u0001B\u0003&\u0011&\u0001\tqCJ\fX/\u001a;M_\u000e\fG/[8oA!9\u0001\b\u0001b\u0001\n\u0003A\u0013\u0001\u00034jY\u0016t\u0017-\\3\t\ri\u0002\u0001\u0015!\u0003*\u0003%1\u0017\u000e\\3oC6,\u0007\u0005C\u0004=\u0001\t\u0007I\u0011\u0001\u0015\u0002\u0015M\u001cd)\u001b7f]\u0006lW\r\u0003\u0004?\u0001\u0001\u0006I!K\u0001\fgN2\u0015\u000e\\3oC6,\u0007\u0005")
public class ParquetCommonSuite
extends FunSuite {
    private AWSCredentials credentials;
    private String bucketName;
    private String parquetLocation;
    private final String filename = Thread.currentThread().getContextClassLoader().getResource("small_adam.fgenotype").getFile();
    private final String s3Filename;
    private volatile byte bitmap$0;

    private AWSCredentials credentials$lzycompute() {
        ParquetCommonSuite parquetCommonSuite = this;
        synchronized (parquetCommonSuite) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.credentials = new CredentialsProperties((Option)new Some((Object)new File(new StringBuilder().append((Object)System.getProperty("user.home")).append((Object)"/spark.conf").toString()))).awsCredentials((Option)new Some((Object)"s3"));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            // ** MonitorExit[this] (shouldn't be in output)
            return this.credentials;
        }
    }

    private String bucketName$lzycompute() {
        ParquetCommonSuite parquetCommonSuite = this;
        synchronized (parquetCommonSuite) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.bucketName = System.getenv("bucket-name");
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            // ** MonitorExit[this] (shouldn't be in output)
            return this.bucketName;
        }
    }

    private String parquetLocation$lzycompute() {
        ParquetCommonSuite parquetCommonSuite = this;
        synchronized (parquetCommonSuite) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.parquetLocation = System.getenv("parquet-location");
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
            // ** MonitorExit[this] (shouldn't be in output)
            return this.parquetLocation;
        }
    }

    public AWSCredentials credentials() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.credentials$lzycompute() : this.credentials;
    }

    public String bucketName() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.bucketName$lzycompute() : this.bucketName;
    }

    public String parquetLocation() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.parquetLocation$lzycompute() : this.parquetLocation;
    }

    public String filename() {
        return this.filename;
    }

    public String s3Filename() {
        return this.s3Filename;
    }

    public ParquetCommonSuite() {
        this.s3Filename = "";
        this.test("Can load footer from small vcf", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ParquetCommonSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LocalFileByteAccess access = new LocalFileByteAccess(new File(this.$outer.filename()));
                Footer footer = ParquetCommon$.MODULE$.readFooter((ByteAccess)access);
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)footer.rowGroups().length())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Reading a footer from HTTP", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[]{NetworkConnected$.MODULE$}), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ParquetCommonSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                HTTPRangedByteAccess byteAccess = new HTTPRangedByteAccess(URI.create("http://www.cs.berkeley.edu/~massie/adams/part0"));
                Footer footer = ParquetCommon$.MODULE$.readFooter((ByteAccess)byteAccess);
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)footer.rowGroups().length())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Reading a footer from S3", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[]{NetworkConnected$.MODULE$, S3Test$.MODULE$}), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ParquetCommonSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                S3ByteAccess byteAccess = new S3ByteAccess((AmazonS3)new AmazonS3Client(this.$outer.credentials()), this.$outer.bucketName(), this.$outer.parquetLocation());
                Footer footer = ParquetCommon$.MODULE$.readFooter((ByteAccess)byteAccess);
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)footer.rowGroups().length())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

