/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.rdd;

import java.io.File;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.Level;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.bdgenomics.adam.predicates.HighQualityReadPredicate;
import org.bdgenomics.adam.rdd.ADAMContext;
import org.bdgenomics.adam.rdd.ADAMContext$;
import org.bdgenomics.adam.rdd.ADAMRDDFunctions;
import org.bdgenomics.adam.util.PhredUtils$;
import org.bdgenomics.adam.util.SparkFunSuite;
import org.bdgenomics.adam.util.SparkFunSuite$class;
import org.bdgenomics.formats.avro.ADAMContig;
import org.bdgenomics.formats.avro.ADAMRecord;
import org.scalatest.BeforeAndAfter;
import org.scalatest.Distributor;
import org.scalatest.Filter;
import org.scalatest.FunSuite;
import org.scalatest.FunSuiteLike;
import org.scalatest.Reporter;
import org.scalatest.Stopper;
import org.scalatest.Tag;
import org.scalatest.Tracker;
import parquet.hadoop.metadata.CompressionCodecName;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001e2A!\u0001\u0002\u0001\u0017\t\u0001\u0012\tR!N\u0007>tG/\u001a=u'VLG/\u001a\u0006\u0003\u0007\u0011\t1A\u001d3e\u0015\t)a!\u0001\u0003bI\u0006l'BA\u0004\t\u0003)\u0011GmZ3o_6L7m\u001d\u0006\u0002\u0013\u0005\u0019qN]4\u0004\u0001M\u0019\u0001\u0001\u0004\n\u0011\u00055\u0001R\"\u0001\b\u000b\u0005=A\u0011!C:dC2\fG/Z:u\u0013\t\tbB\u0001\u0005Gk:\u001cV/\u001b;f!\t\u0019b#D\u0001\u0015\u0015\t)B!\u0001\u0003vi&d\u0017BA\f\u0015\u00055\u0019\u0006/\u0019:l\rVt7+^5uK\")\u0011\u0004\u0001C\u00015\u00051A(\u001b8jiz\"\u0012a\u0007\t\u00039\u0001i\u0011A\u0001\u0005\u0006=\u0001!\taH\u0001\ri\u0016l\u0007\u000fT8dCRLwN\u001c\u000b\u0003A)\u0002\"!I\u0014\u000f\u0005\t*S\"A\u0012\u000b\u0003\u0011\nQa]2bY\u0006L!AJ\u0012\u0002\rA\u0013X\rZ3g\u0013\tA\u0013F\u0001\u0004TiJLgn\u001a\u0006\u0003M\rBqaK\u000f\u0011\u0002\u0003\u0007\u0001%\u0001\u0004tk\u001a4\u0017\u000e\u001f\u0005\b[\u0001\t\n\u0011\"\u0001/\u0003Y!X-\u001c9M_\u000e\fG/[8oI\u0011,g-Y;mi\u0012\nT#A\u0018+\u0005\u0001\u00024&A\u0019\u0011\u0005I:T\"A\u001a\u000b\u0005Q*\u0014!C;oG\",7m[3e\u0015\t14%\u0001\u0006b]:|G/\u0019;j_:L!\u0001O\u001a\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r")
public class ADAMContextSuite
extends FunSuite
implements SparkFunSuite {
    private SparkContext sc;
    private Option<Map<String, Level>> maybeLevels;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    private volatile boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked;

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public Option<Map<String, Level>> maybeLevels() {
        return this.maybeLevels;
    }

    @Override
    public void maybeLevels_$eq(Option<Map<String, Level>> x$1) {
        this.maybeLevels = x$1;
    }

    @Override
    public void setupSparkContext(String sparkName, boolean silenceSpark) {
        SparkFunSuite$class.setupSparkContext(this, sparkName, silenceSpark);
    }

    @Override
    public void teardownSparkContext() {
        SparkFunSuite$class.teardownSparkContext(this);
    }

    @Override
    public void sparkBefore(String beforeName, boolean silenceSpark, Function0<BoxedUnit> body) {
        SparkFunSuite$class.sparkBefore(this, beforeName, silenceSpark, body);
    }

    @Override
    public void sparkAfter(String beforeName, boolean silenceSpark, Function0<BoxedUnit> body) {
        SparkFunSuite$class.sparkAfter(this, beforeName, silenceSpark, body);
    }

    @Override
    public void sparkTest(String name, boolean silenceSpark, Seq<Tag> tags, Function0<BoxedUnit> body) {
        SparkFunSuite$class.sparkTest(this, name, silenceSpark, tags, body);
    }

    @Override
    public void sparkTest(String name, Function0<BoxedUnit> body) {
        SparkFunSuite$class.sparkTest(this, name, body);
    }

    @Override
    public boolean sparkBefore$default$2() {
        return SparkFunSuite$class.sparkBefore$default$2(this);
    }

    @Override
    public boolean setupSparkContext$default$2() {
        return SparkFunSuite$class.setupSparkContext$default$2(this);
    }

    @Override
    public boolean sparkAfter$default$2() {
        return SparkFunSuite$class.sparkAfter$default$2(this);
    }

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    }

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    }

    public boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked() {
        return this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked;
    }

    public void org$scalatest$BeforeAndAfter$$runHasBeenInvoked_$eq(boolean x$1) {
        this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked = x$1;
    }

    public void org$scalatest$BeforeAndAfter$$super$runTest(String testName, Reporter reporter, Stopper stopper, Map configMap, Tracker tracker) {
        FunSuiteLike.class.runTest((FunSuiteLike)this, (String)testName, (Reporter)reporter, (Stopper)stopper, (Map)configMap, (Tracker)tracker);
    }

    public void org$scalatest$BeforeAndAfter$$super$run(Option testName, Reporter reporter, Stopper stopper, Filter filter, Map configMap, Option distributor, Tracker tracker) {
        FunSuiteLike.class.run((FunSuiteLike)this, (Option)testName, (Reporter)reporter, (Stopper)stopper, (Filter)filter, (Map)configMap, (Option)distributor, (Tracker)tracker);
    }

    public void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$beforeFunctionAtomic_$eq(AtomicReference x$1) {
        this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic = x$1;
    }

    public void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$afterFunctionAtomic_$eq(AtomicReference x$1) {
        this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic = x$1;
    }

    public void before(Function0<Object> fun) {
        BeforeAndAfter.class.before((BeforeAndAfter)this, fun);
    }

    public void after(Function0<Object> fun) {
        BeforeAndAfter.class.after((BeforeAndAfter)this, fun);
    }

    public void runTest(String testName, Reporter reporter, Stopper stopper, Map<String, Object> configMap, Tracker tracker) {
        BeforeAndAfter.class.runTest((BeforeAndAfter)this, (String)testName, (Reporter)reporter, (Stopper)stopper, configMap, (Tracker)tracker);
    }

    public void run(Option<String> testName, Reporter reporter, Stopper stopper, Filter filter, Map<String, Object> configMap, Option<Distributor> distributor, Tracker tracker) {
        BeforeAndAfter.class.run((BeforeAndAfter)this, testName, (Reporter)reporter, (Stopper)stopper, (Filter)filter, configMap, distributor, (Tracker)tracker);
    }

    public String tempLocation(String suffix) {
        File tempFile = File.createTempFile("ADAMContextSuite", "");
        File tempDir = tempFile.getParentFile();
        return new File(tempDir, new StringBuilder().append((Object)tempFile.getName()).append((Object)suffix).toString()).getAbsolutePath();
    }

    public String tempLocation$default$1() {
        return "adam";
    }

    public ADAMContextSuite() {
        BeforeAndAfter.class.$init$((BeforeAndAfter)this);
        SparkFunSuite$class.$init$(this);
        this.sparkTest("sc.adamLoad should not fail on unmapped reads", (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ADAMContextSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String readsFilepath = ClassLoader.getSystemClassLoader().getResource("unmapped.sam").getFile();
                ADAMContext qual$1 = ADAMContext$.MODULE$.sparkContextToADAMContext(this.$outer.sc());
                None$ x$3 = qual$1.adamLoad$default$2();
                Option x$4 = qual$1.adamLoad$default$3();
                RDD bamReads = qual$1.adamLoad(readsFilepath, (Option)x$3, x$4, (Function1)Predef$.MODULE$.conforms(), ManifestFactory$.MODULE$.classType(ADAMRecord.class));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)bamReads.count())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)200)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.sparkTest("can read a small .SAM file", (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ADAMContextSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String path = ClassLoader.getSystemClassLoader().getResource("small.sam").getFile();
                ADAMContext qual$2 = ADAMContext$.MODULE$.sparkContextToADAMContext(this.$outer.sc());
                None$ x$6 = qual$2.adamLoad$default$2();
                Option x$7 = qual$2.adamLoad$default$3();
                RDD reads = qual$2.adamLoad(path, (Option)x$6, x$7, (Function1)Predef$.MODULE$.conforms(), ManifestFactory$.MODULE$.classType(ADAMRecord.class));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)reads.count())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)20)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.sparkTest("can filter a .SAM file based on quality", (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ADAMContextSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String path = ClassLoader.getSystemClassLoader().getResource("small.sam").getFile();
                ADAMContext qual$3 = ADAMContext$.MODULE$.sparkContextToADAMContext(this.$outer.sc());
                Some x$9 = new Some(HighQualityReadPredicate.class);
                Option x$10 = qual$3.adamLoad$default$3();
                RDD reads = qual$3.adamLoad(path, (Option)x$9, x$10, (Function1)Predef$.MODULE$.conforms(), ManifestFactory$.MODULE$.classType(ADAMRecord.class));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)reads.count())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)18)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Can convert to phred", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ADAMContextSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)PhredUtils$.MODULE$.successProbabilityToPhred(0.9))).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)10)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)PhredUtils$.MODULE$.successProbabilityToPhred(0.99999))).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)50)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Can convert from phred", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ADAMContextSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assert(PhredUtils$.MODULE$.phredToSuccessProbability(10) > 0.89 && PhredUtils$.MODULE$.phredToSuccessProbability(10) < 0.91);
                this.$outer.assert(PhredUtils$.MODULE$.phredToSuccessProbability(50) > 0.99998 && PhredUtils$.MODULE$.phredToSuccessProbability(50) < 0.999999);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.sparkTest("loadADAMFromPaths can load simple RDDs that have just been saved", (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ADAMContextSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ADAMContig contig = ADAMContig.newBuilder().setContigName((CharSequence)"abc").setContigLength(Predef$.MODULE$.long2Long(1000000L)).setReferenceURL((CharSequence)"http://abc").build();
                ADAMRecord a0 = ADAMRecord.newBuilder().setRecordGroupName((CharSequence)"group0").setReadName((CharSequence)"read0").setContig(contig).setStart(Predef$.MODULE$.long2Long(100L)).setPrimaryAlignment(Predef$.MODULE$.boolean2Boolean(true)).setReadPaired(Predef$.MODULE$.boolean2Boolean(false)).setReadMapped(Predef$.MODULE$.boolean2Boolean(true)).build();
                ADAMRecord a1 = ADAMRecord.newBuilder((ADAMRecord)a0).setReadName((CharSequence)"read1").setStart(Predef$.MODULE$.long2Long(200L)).build();
                SparkContext qual$4 = this.$outer.sc();
                Seq x$11 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ADAMRecord[]{a0, a1}));
                int x$12 = qual$4.parallelize$default$2();
                RDD saved = qual$4.parallelize(x$11, x$12, ClassTag$.MODULE$.apply(ADAMRecord.class));
                String loc = this.$outer.tempLocation(this.$outer.tempLocation$default$1());
                Path path = new Path(loc);
                ADAMRDDFunctions qual$5 = ADAMContext$.MODULE$.rddToADAMRDD(saved, (Function1)Predef$.MODULE$.conforms(), ManifestFactory$.MODULE$.classType(ADAMRecord.class));
                int x$14 = qual$5.adamSave$default$2();
                int x$15 = qual$5.adamSave$default$3();
                CompressionCodecName x$16 = qual$5.adamSave$default$4();
                boolean x$17 = qual$5.adamSave$default$5();
                qual$5.adamSave(loc, x$14, x$15, x$16, x$17);
                try {
                    RDD loaded = ADAMContext$.MODULE$.sparkContextToADAMContext(this.$outer.sc()).loadADAMFromPaths((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Path[]{path})));
                    this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)loaded.count())).$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)saved.count())));
                    return;
                }
                catch (Exception exception) {
                    Predef$.MODULE$.println((Object)exception);
                    throw exception;
                }
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.sparkTest("findFiles correctly finds a nested set of directories", (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ADAMContextSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                File tempDir = File.createTempFile("ADAMContextSuite", "").getParentFile();
                String parentName = new StringBuilder().append((Object)"parent-").append((Object)UUID.randomUUID().toString()).toString();
                File parentDir = this.createDir$1(tempDir, parentName);
                File subDir1 = this.createDir$1(parentDir, "subDir1");
                File subDir2 = this.createDir$1(parentDir, "subDir2");
                this.createDir$1(subDir1, "match1");
                this.createDir$1(subDir1, "match2");
                this.createDir$1(subDir2, "match3");
                this.createDir$1(subDir2, "nomatch4");
                this.createDir$1(parentDir, "match5");
                this.createDir$1(parentDir, "nomatch6");
                Seq paths = ADAMContext$.MODULE$.sparkContextToADAMContext(this.$outer.sc()).findFiles(new Path(parentDir.getAbsolutePath()), "^match.*");
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)paths.size())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)4)));
                Seq pathNames = (Seq)paths.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Path x$1) {
                        return x$1.getName();
                    }
                }, Seq$.MODULE$.canBuildFrom());
                this.$outer.assert(pathNames.contains((Object)"match1"));
                this.$outer.assert(pathNames.contains((Object)"match2"));
                this.$outer.assert(pathNames.contains((Object)"match3"));
                this.$outer.assert(pathNames.contains((Object)"match5"));
            }

            /*
             * WARNING - void declaration
             */
            private final File createDir$1(File dir, String name) {
                void var3_3;
                File dirFile = new File(dir, name);
                dirFile.mkdir();
                return var3_3;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

