/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.util;

import org.bdgenomics.adam.models.Attribute;
import org.bdgenomics.adam.models.TagType$;
import org.bdgenomics.adam.util.AttributeUtils$;
import org.bdgenomics.adam.util.AttributeUtilsSuite$;
import org.scalatest.FunSuite;
import org.scalatest.Tag;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001]1A!\u0001\u0002\u0001\u0017\t\u0019\u0012\t\u001e;sS\n,H/Z+uS2\u001c8+^5uK*\u00111\u0001B\u0001\u0005kRLGN\u0003\u0002\u0006\r\u0005!\u0011\rZ1n\u0015\t9\u0001\"\u0001\u0006cI\u001e,gn\\7jGNT\u0011!C\u0001\u0004_J<7\u0001A\n\u0003\u00011\u0001\"!\u0004\t\u000e\u00039Q!a\u0004\u0005\u0002\u0013M\u001c\u0017\r\\1uKN$\u0018BA\t\u000f\u0005!1UO\\*vSR,\u0007\"B\n\u0001\t\u0003!\u0012A\u0002\u001fj]&$h\bF\u0001\u0016!\t1\u0002!D\u0001\u0003\u0001")
public class AttributeUtilsSuite
extends FunSuite {
    public AttributeUtilsSuite() {
        this.test("parseTags returns a reasonable set of tagStrings", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AttributeUtilsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq tags = AttributeUtils$.MODULE$.parseAttributes("XT:i:3\tXU:Z:foo,bar");
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)tags.size())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)2)));
                this.$outer.assert(this.$outer.convertToEqualizer(((Attribute)tags.head()).tag()).$eq$eq$eq((Object)"XT"));
                this.$outer.assert(this.$outer.convertToEqualizer(((Attribute)tags.head()).tagType()).$eq$eq$eq((Object)TagType$.MODULE$.Integer()));
                this.$outer.assert(this.$outer.convertToEqualizer(((Attribute)tags.head()).value()).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)3)));
                this.$outer.assert(this.$outer.convertToEqualizer(((Attribute)tags.apply(1)).tag()).$eq$eq$eq((Object)"XU"));
                this.$outer.assert(this.$outer.convertToEqualizer(((Attribute)tags.apply(1)).tagType()).$eq$eq$eq((Object)TagType$.MODULE$.String()));
                this.$outer.assert(this.$outer.convertToEqualizer(((Attribute)tags.apply(1)).value()).$eq$eq$eq((Object)"foo,bar"));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("empty string is parsed as zero tagStrings", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AttributeUtilsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assert(this.$outer.convertToEqualizer(AttributeUtils$.MODULE$.parseAttributes("")).$eq$eq$eq((Object)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("incorrectly formatted tag throws an exception", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            public final /* synthetic */ AttributeUtilsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.intercept((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$3 $outer;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.$outer.$outer.assert(this.$outer.$outer.convertToEqualizer(AttributeUtils$.MODULE$.parseAttributes("XT:i")).$eq$eq$eq((Object)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
            }

            public /* synthetic */ AttributeUtilsSuite org$bdgenomics$adam$util$AttributeUtilsSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("string tag with a ':' in it is correctly parsed", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AttributeUtilsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Predef$ predef$ = Predef$.MODULE$;
                Seq tags = AttributeUtils$.MODULE$.parseAttributes(new StringOps("XX:Z:%s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"foo:bar"})));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)tags.size())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1)));
                this.$outer.assert(this.$outer.convertToEqualizer(((Attribute)tags.head()).value()).$eq$eq$eq((Object)"foo:bar"));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

