/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.util;

import java.io.File;
import org.bdgenomics.adam.util.ConfigurationFile;
import org.bdgenomics.adam.util.ConfigurationFile$;
import org.scalatest.FunSuite;
import org.scalatest.Tag;
import scala.Function0;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001]1A!\u0001\u0002\u0001\u0017\t12i\u001c8gS\u001e,(/\u0019;j_:4\u0015\u000e\\3Tk&$XM\u0003\u0002\u0004\t\u0005!Q\u000f^5m\u0015\t)a!\u0001\u0003bI\u0006l'BA\u0004\t\u0003)\u0011GmZ3o_6L7m\u001d\u0006\u0002\u0013\u0005\u0019qN]4\u0004\u0001M\u0011\u0001\u0001\u0004\t\u0003\u001bAi\u0011A\u0004\u0006\u0003\u001f!\t\u0011b]2bY\u0006$Xm\u001d;\n\u0005Eq!\u0001\u0003$v]N+\u0018\u000e^3\t\u000bM\u0001A\u0011\u0001\u000b\u0002\rqJg.\u001b;?)\u0005)\u0002C\u0001\f\u0001\u001b\u0005\u0011\u0001")
public class ConfigurationFileSuite
extends FunSuite {
    public ConfigurationFileSuite() {
        this.test("Can read values out of a file", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConfigurationFileSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String path = Thread.currentThread().getContextClassLoader().getResource("test.conf").getFile();
                File file = new File(path);
                ConfigurationFile config = new ConfigurationFile(file, ConfigurationFile$.MODULE$.$lessinit$greater$default$2());
                this.$outer.assert(config.properties().contains((Object)"accessKey"));
                this.$outer.assert(config.properties().contains((Object)"secretKey"));
                this.$outer.assert(config.properties().contains((Object)"accessKey_s3"));
                this.$outer.assert(config.properties().contains((Object)"secretKey_s3"));
                this.$outer.assert(this.$outer.convertToEqualizer(config.properties().apply((Object)"accessKey")).$eq$eq$eq((Object)"accessKey"));
                this.$outer.assert(this.$outer.convertToEqualizer(config.properties().apply((Object)"secretKey")).$eq$eq$eq((Object)"secretKey"));
                this.$outer.assert(this.$outer.convertToEqualizer(config.properties().apply((Object)"accessKey_s3")).$eq$eq$eq((Object)"accessKey_s3"));
                this.$outer.assert(this.$outer.convertToEqualizer(config.properties().apply((Object)"secretKey_s3")).$eq$eq$eq((Object)"secretKey_s3"));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Reads default values when the file does not exist.", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConfigurationFileSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                File file = new File("/foo/bar.conf");
                Tuple2[] tuple2Array = new Tuple2[2];
                Predef$ predef$ = Predef$.MODULE$;
                Predef.ArrowAssoc$ arrowAssoc$ = Predef.ArrowAssoc$.MODULE$;
                tuple2Array[0] = new Tuple2((Object)"accessKey", (Object)"foo");
                Predef$ predef$2 = Predef$.MODULE$;
                Predef.ArrowAssoc$ arrowAssoc$2 = Predef.ArrowAssoc$.MODULE$;
                tuple2Array[1] = new Tuple2((Object)"secretKey", (Object)"bar");
                Map defaultMap = ((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))).toMap(Predef$.MODULE$.conforms());
                ConfigurationFile config = new ConfigurationFile(file, (Option)new Some((Object)defaultMap));
                this.$outer.assert(config.properties().contains((Object)"accessKey"));
                this.$outer.assert(config.properties().contains((Object)"secretKey"));
                this.$outer.assert(this.$outer.convertToEqualizer(config.properties().apply((Object)"accessKey")).$eq$eq$eq((Object)"foo"));
                this.$outer.assert(this.$outer.convertToEqualizer(config.properties().apply((Object)"secretKey")).$eq$eq$eq((Object)"bar"));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Does not read the default values, when the file does exist.", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConfigurationFileSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String path = Thread.currentThread().getContextClassLoader().getResource("test.conf").getFile();
                File file = new File(path);
                Tuple2[] tuple2Array = new Tuple2[2];
                Predef$ predef$ = Predef$.MODULE$;
                Predef.ArrowAssoc$ arrowAssoc$ = Predef.ArrowAssoc$.MODULE$;
                tuple2Array[0] = new Tuple2((Object)"accessKey", (Object)"foo");
                Predef$ predef$2 = Predef$.MODULE$;
                Predef.ArrowAssoc$ arrowAssoc$2 = Predef.ArrowAssoc$.MODULE$;
                tuple2Array[1] = new Tuple2((Object)"secretKey", (Object)"bar");
                Map defaultMap = ((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))).toMap(Predef$.MODULE$.conforms());
                ConfigurationFile config = new ConfigurationFile(file, (Option)new Some((Object)defaultMap));
                this.$outer.assert(config.properties().contains((Object)"accessKey"));
                this.$outer.assert(config.properties().contains((Object)"secretKey"));
                this.$outer.assert(this.$outer.convertToEqualizer(config.properties().apply((Object)"accessKey")).$eq$eq$eq((Object)"accessKey"));
                this.$outer.assert(this.$outer.convertToEqualizer(config.properties().apply((Object)"secretKey")).$eq$eq$eq((Object)"secretKey"));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

