/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.converters;

import org.apache.spark.SparkContext$;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.rdd.RDD;
import org.bdgenomics.adam.converters.FastaConverter;
import org.bdgenomics.adam.converters.FastaConverter$FastaDescriptionLine$;
import org.bdgenomics.formats.avro.ADAMNucleotideContigFragment;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class FastaConverter$
implements Serializable {
    public static final FastaConverter$ MODULE$;

    static {
        new FastaConverter$();
    }

    public RDD<ADAMNucleotideContigFragment> apply(RDD<Tuple2<Object, String>> rdd, long maxFragmentLength) {
        RDD filtered = rdd.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, String> apply(Tuple2<Object, String> kv) {
                return new Tuple2((Object)BoxesRunTime.boxToLong((long)kv._1$mcJ$sp()), (Object)((String)kv._2()).trim());
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Object, String> kv) {
                return !((String)kv._2()).startsWith(";");
            }
        });
        Map<Object, FastaConverter.FastaDescriptionLine> descriptionLines = this.getDescriptionLines((RDD<Tuple2<Object, String>>)filtered);
        Broadcast indexToContigDescription = rdd.context().broadcast(descriptionLines, ClassTag$.MODULE$.apply(Map.class));
        RDD sequenceLines = filtered.filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Object, String> kv) {
                return !FastaConverter$.MODULE$.org$bdgenomics$adam$converters$FastaConverter$$isDescriptionLine((String)kv._2());
            }
        });
        RDD keyedSequences = ((TraversableOnce)indexToContigDescription.value()).size() == 0 ? sequenceLines.keyBy((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long apply(Tuple2<Object, String> kv) {
                return -1L;
            }
        }) : sequenceLines.keyBy((Function1)new Serializable(indexToContigDescription){
            public static final long serialVersionUID = 0L;
            private final Broadcast indexToContigDescription$1;

            public final long apply(Tuple2<Object, String> row) {
                return FastaConverter$.MODULE$.findContigIndex(row._1$mcJ$sp(), (List<Object>)((MapLike)this.indexToContigDescription$1.value()).keys().toList());
            }
            {
                this.indexToContigDescription$1 = indexToContigDescription$1;
            }
        });
        RDD groupedContigs = SparkContext$.MODULE$.rddToPairRDDFunctions(keyedSequences, ClassTag$.MODULE$.Long(), ClassTag$.MODULE$.apply(Tuple2.class), (Ordering)Ordering.Long$.MODULE$).groupByKey();
        FastaConverter converter = new FastaConverter(maxFragmentLength);
        return groupedContigs.flatMap((Function1)new Serializable(indexToContigDescription, converter){
            public static final long serialVersionUID = 0L;
            private final Broadcast indexToContigDescription$1;
            private final FastaConverter converter$1;

            public final TraversableOnce<ADAMNucleotideContigFragment> apply(Tuple2<Object, Iterable<Tuple2<Object, String>>> x0$1) {
                if (x0$1 != null) {
                    FastaConverter.FastaDescriptionLine descriptionLine = (FastaConverter.FastaDescriptionLine)((MapLike)this.indexToContigDescription$1.value()).getOrElse((Object)BoxesRunTime.boxToLong((long)x0$1._1$mcJ$sp()), (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final FastaConverter.FastaDescriptionLine apply() {
                            return new FastaConverter.FastaDescriptionLine(FastaConverter$FastaDescriptionLine$.MODULE$.apply$default$1(), FastaConverter$FastaDescriptionLine$.MODULE$.apply$default$2(), FastaConverter$FastaDescriptionLine$.MODULE$.apply$default$3());
                        }
                    });
                    Serializable serializable = new Serializable(this, descriptionLine){
                        public static final long serialVersionUID = 0L;
                        private final FastaConverter.FastaDescriptionLine descriptionLine$1;

                        public final String apply() {
                            return new StringBuilder().append((Object)"Sequence ").append((Object)BoxesRunTime.boxToInteger((int)this.descriptionLine$1.seqId())).append((Object)" has no sequence data.").toString();
                        }
                        {
                            this.descriptionLine$1 = descriptionLine$1;
                        }
                    };
                    boolean bl = ((TraversableOnce)x0$1._2()).size() != 0;
                    Predef$ predef$ = Predef$.MODULE$;
                    if (!bl) {
                        throw new AssertionError((Object)new StringBuilder().append((Object)"assertion failed: ").append((Object)serializable.apply()).toString());
                    }
                    Seq sequence = (Seq)((TraversableLike)((TraversableOnce)x0$1._2()).toSeq().sortBy((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final long apply(Tuple2<Object, String> x$2) {
                            return x$2._1$mcJ$sp();
                        }
                    }, (Ordering)Ordering.Long$.MODULE$)).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(Tuple2<Object, String> kv) {
                            return FastaConverter$.MODULE$.org$bdgenomics$adam$converters$FastaConverter$$cleanSequence((String)kv._2());
                        }
                    }, Seq$.MODULE$.canBuildFrom());
                    return this.converter$1.convert(descriptionLine.contigName(), descriptionLine.seqId(), (Seq<String>)sequence, descriptionLine.contigDescription());
                }
                throw new MatchError(x0$1);
            }
            {
                this.indexToContigDescription$1 = indexToContigDescription$1;
                this.converter$1 = converter$1;
            }
        }, ClassTag$.MODULE$.apply(ADAMNucleotideContigFragment.class));
    }

    public long apply$default$2() {
        return 10000L;
    }

    public String org$bdgenomics$adam$converters$FastaConverter$$cleanSequence(String sequence) {
        Predef$ predef$ = Predef$.MODULE$;
        return new StringOps(sequence).stripSuffix("*");
    }

    public boolean org$bdgenomics$adam$converters$FastaConverter$$isDescriptionLine(String line2) {
        return line2.startsWith(">");
    }

    public Map<Object, FastaConverter.FastaDescriptionLine> getDescriptionLines(RDD<Tuple2<Object, String>> rdd) {
        return Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])rdd.filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Object, String> kv) {
                return FastaConverter$.MODULE$.org$bdgenomics$adam$converters$FastaConverter$$isDescriptionLine((String)kv._2());
            }
        }).collect()).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, FastaConverter.FastaDescriptionLine> apply(Tuple2<Tuple2<Object, String>, Object> kv) {
                return new Tuple2((Object)BoxesRunTime.boxToLong((long)((Tuple2)kv._1())._1$mcJ$sp()), (Object)new FastaConverter.FastaDescriptionLine(((Tuple2)kv._1())._1$mcJ$sp(), kv._2$mcI$sp(), (Option<String>)new Some(((Tuple2)kv._1())._2())));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).toMap(Predef$.MODULE$.conforms());
    }

    public long findContigIndex(long rowIdx, List<Object> indices) {
        List idx = (List)indices.filter((Function1)new Serializable(rowIdx){
            public static final long serialVersionUID = 0L;
            private final long rowIdx$1;

            public final boolean apply(long x$3) {
                return this.apply$mcZJ$sp(x$3);
            }

            public boolean apply$mcZJ$sp(long x$3) {
                return x$3 <= this.rowIdx$1;
            }
            {
                this.rowIdx$1 = rowIdx$1;
            }
        });
        return BoxesRunTime.unboxToLong((Object)idx.max((Ordering)Ordering.Long$.MODULE$));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private FastaConverter$() {
        MODULE$ = this;
    }
}

