/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.converters;

import java.util.Date;
import net.sf.samtools.SAMReadGroupRecord;
import net.sf.samtools.SAMRecord;
import org.bdgenomics.adam.models.RecordGroupDictionary;
import org.bdgenomics.adam.models.SequenceDictionary;
import org.bdgenomics.adam.models.SequenceRecord;
import org.bdgenomics.adam.models.SequenceRecord$;
import org.bdgenomics.adam.util.AttributeUtils$;
import org.bdgenomics.formats.avro.ADAMRecord;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichChar$;

@ScalaSignature(bytes="\u0006\u0001y2A!\u0001\u0002\u0001\u0017\t\u00112+Q'SK\u000e|'\u000fZ\"p]Z,'\u000f^3s\u0015\t\u0019A!\u0001\u0006d_:4XM\u001d;feNT!!\u0002\u0004\u0002\t\u0005$\u0017-\u001c\u0006\u0003\u000f!\t!B\u00193hK:|W.[2t\u0015\u0005I\u0011aA8sO\u000e\u00011c\u0001\u0001\r%A\u0011Q\u0002E\u0007\u0002\u001d)\tq\"A\u0003tG\u0006d\u0017-\u0003\u0002\u0012\u001d\t1\u0011I\\=SK\u001a\u0004\"!D\n\n\u0005Qq!\u0001D*fe&\fG.\u001b>bE2,\u0007\"\u0002\f\u0001\t\u00039\u0012A\u0002\u001fj]&$h\bF\u0001\u0019!\tI\u0002!D\u0001\u0003\u0011\u0015Y\u0002\u0001\"\u0001\u001d\u0003\u001d\u0019wN\u001c<feR$B!H\u00132sA\u0011adI\u0007\u0002?)\u0011\u0001%I\u0001\u0005CZ\u0014xN\u0003\u0002#\r\u00059am\u001c:nCR\u001c\u0018B\u0001\u0013 \u0005)\tE)Q'SK\u000e|'\u000f\u001a\u0005\u0006Mi\u0001\raJ\u0001\ng\u0006l'+Z2pe\u0012\u0004\"\u0001K\u0018\u000e\u0003%R!AK\u0016\u0002\u0011M\fW\u000e^8pYNT!\u0001L\u0017\u0002\u0005M4'\"\u0001\u0018\u0002\u00079,G/\u0003\u00021S\tI1+Q'SK\u000e|'\u000f\u001a\u0005\u0006ei\u0001\raM\u0001\u0005I&\u001cG\u000f\u0005\u00025o5\tQG\u0003\u00027\t\u00051Qn\u001c3fYNL!\u0001O\u001b\u0003%M+\u0017/^3oG\u0016$\u0015n\u0019;j_:\f'/\u001f\u0005\u0006ui\u0001\raO\u0001\u000be\u0016\fGm\u0012:pkB\u001c\bC\u0001\u001b=\u0013\tiTGA\u000bSK\u000e|'\u000fZ$s_V\u0004H)[2uS>t\u0017M]=")
public class SAMRecordConverter
implements Serializable {
    public ADAMRecord convert(SAMRecord samRecord, SequenceDictionary dict, RecordGroupDictionary readGroups) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        Object object;
        BoxedUnit boxedUnit3;
        BoxedUnit boxedUnit4;
        int n;
        int startTrim;
        int n2;
        String cigar;
        String string = cigar = samRecord.getCigarString();
        if (!(string != null ? !string.equals("*") : "*" != null)) {
            n2 = 0;
        } else {
            Predef$ predef$ = Predef$.MODULE$;
            String string2 = (String)new StringOps(cigar).takeWhile((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(char x$1) {
                    Predef$ predef$ = Predef$.MODULE$;
                    return RichChar$.MODULE$.isDigit$extension(x$1);
                }
            });
            Predef$ predef$2 = Predef$.MODULE$;
            int count2 = new StringOps(string2).toInt();
            Predef$ predef$3 = Predef$.MODULE$;
            String string3 = (String)new StringOps(cigar).dropWhile((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(char x$2) {
                    Predef$ predef$ = Predef$.MODULE$;
                    return RichChar$.MODULE$.isDigit$extension(x$2);
                }
            });
            Predef$ predef$4 = Predef$.MODULE$;
            char operator = BoxesRunTime.unboxToChar((Object)new StringOps(string3).head());
            n2 = startTrim = operator == 'H' ? count2 : 0;
        }
        if (cigar.endsWith("H")) {
            Predef$ predef$ = Predef$.MODULE$;
            String string4 = (String)new StringOps(cigar).dropRight(1);
            Predef$ predef$5 = Predef$.MODULE$;
            String string5 = (String)new StringOps(string4).reverse();
            Predef$ predef$6 = Predef$.MODULE$;
            String string6 = (String)new StringOps(string5).takeWhile((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(char x$3) {
                    Predef$ predef$ = Predef$.MODULE$;
                    return RichChar$.MODULE$.isDigit$extension(x$3);
                }
            });
            Predef$ predef$7 = Predef$.MODULE$;
            n = new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(string6).reverse())).toInt();
        } else {
            n = 0;
        }
        int endTrim = n;
        Predef$ predef$ = Predef$.MODULE$;
        ADAMRecord.Builder builder = ADAMRecord.newBuilder().setReadName((CharSequence)samRecord.getReadName()).setSequence((CharSequence)samRecord.getReadString()).setCigar((CharSequence)cigar).setBasesTrimmedFromStart(Integer.valueOf(startTrim)).setBasesTrimmedFromEnd(Predef$.MODULE$.int2Integer(endTrim)).setQual((CharSequence)samRecord.getBaseQualityString());
        int readReference = Predef$.MODULE$.Integer2int(samRecord.getReferenceIndex());
        if (readReference != -1) {
            BoxedUnit boxedUnit5;
            builder.setContig(SequenceRecord$.MODULE$.toADAMContig((SequenceRecord)dict.apply(samRecord.getReferenceName()).get()));
            int start2 = samRecord.getAlignmentStart();
            boolean bl = start2 != 0;
            Predef$ predef$8 = Predef$.MODULE$;
            if (!bl) {
                throw new AssertionError((Object)new StringBuilder().append((Object)"assertion failed: ").append((Object)"Start cannot equal 0 if contig is set.").toString());
            }
            long l = start2 - 1;
            Predef$ predef$9 = Predef$.MODULE$;
            builder.setStart(Long.valueOf(l));
            int mapq = samRecord.getMappingQuality();
            if (mapq != 255) {
                Predef$ predef$10 = Predef$.MODULE$;
                boxedUnit5 = builder.setMapq(Integer.valueOf(mapq));
            } else {
                boxedUnit5 = BoxedUnit.UNIT;
            }
            if (samRecord.getReadUnmappedFlag()) {
                Predef$ predef$11 = Predef$.MODULE$;
                boxedUnit4 = builder.setReadMapped(Boolean.valueOf(false));
            } else {
                BoxedUnit boxedUnit6;
                Predef$ predef$12 = Predef$.MODULE$;
                builder.setReadMapped(Boolean.valueOf(true));
                if (samRecord.getReadNegativeStrandFlag()) {
                    Predef$ predef$13 = Predef$.MODULE$;
                    boxedUnit6 = builder.setReadNegativeStrand(Boolean.valueOf(true));
                } else {
                    boxedUnit6 = BoxedUnit.UNIT;
                }
                if (samRecord.getNotPrimaryAlignmentFlag()) {
                    builder.setSupplementaryAlignment(Predef$.MODULE$.boolean2Boolean(samRecord.getSupplementaryAlignmentFlag()));
                    boxedUnit4 = builder.setSecondaryAlignment(Predef$.MODULE$.boolean2Boolean(!samRecord.getSupplementaryAlignmentFlag()));
                } else {
                    boxedUnit4 = builder.setPrimaryAlignment(Predef$.MODULE$.boolean2Boolean(true));
                }
            }
        } else {
            boxedUnit4 = BoxedUnit.UNIT;
        }
        Integer n3 = samRecord.getMateReferenceIndex();
        Predef$ predef$14 = Predef$.MODULE$;
        int mateReference = n3;
        if (mateReference != -1) {
            builder.setMateContig(SequenceRecord$.MODULE$.toADAMContig((SequenceRecord)dict.apply(samRecord.getMateReferenceName()).get()));
            int mateStart = samRecord.getMateAlignmentStart();
            if (mateStart > 0) {
                long l = mateStart - 1;
                Predef$ predef$15 = Predef$.MODULE$;
                boxedUnit3 = builder.setMateAlignmentStart(Long.valueOf(l));
            } else {
                boxedUnit3 = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit3 = BoxedUnit.UNIT;
        }
        if (samRecord.getFlags() != 0) {
            Object object2;
            if (samRecord.getReadPairedFlag()) {
                builder.setReadPaired(Predef$.MODULE$.boolean2Boolean(true));
                Object object3 = samRecord.getMateNegativeStrandFlag() ? builder.setMateNegativeStrand(Predef$.MODULE$.boolean2Boolean(true)) : BoxedUnit.UNIT;
                Object object4 = samRecord.getMateUnmappedFlag() ? BoxedUnit.UNIT : builder.setMateMapped(Predef$.MODULE$.boolean2Boolean(true));
                Object object5 = samRecord.getProperPairFlag() ? builder.setProperPair(Predef$.MODULE$.boolean2Boolean(true)) : BoxedUnit.UNIT;
                Object object6 = samRecord.getFirstOfPairFlag() ? builder.setFirstOfPair(Predef$.MODULE$.boolean2Boolean(true)) : BoxedUnit.UNIT;
                object2 = samRecord.getSecondOfPairFlag() ? builder.setSecondOfPair(Predef$.MODULE$.boolean2Boolean(true)) : BoxedUnit.UNIT;
            } else {
                object2 = BoxedUnit.UNIT;
            }
            Object object7 = samRecord.getDuplicateReadFlag() ? builder.setDuplicateRead(Predef$.MODULE$.boolean2Boolean(true)) : BoxedUnit.UNIT;
            object = samRecord.getReadFailsVendorQualityCheckFlag() ? builder.setFailedVendorQualityChecks(Predef$.MODULE$.boolean2Boolean(true)) : BoxedUnit.UNIT;
        } else {
            object = BoxedUnit.UNIT;
        }
        if (samRecord.getAttributes() == null) {
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            ObjectRef tags = new ObjectRef((Object)Nil$.MODULE$);
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(samRecord.getAttributes()).asScala()).foreach((Function1)new Serializable(this, builder, tags){
                public static final long serialVersionUID = 0L;
                private final ADAMRecord.Builder builder$1;
                private final ObjectRef tags$1;

                public final Object apply(SAMRecord.SAMTagAndValue attr) {
                    ADAMRecord.Builder builder;
                    String string = attr.tag;
                    if (!(string != null ? !string.equals("MD") : "MD" != null)) {
                        builder = this.builder$1.setMismatchingPositions((CharSequence)attr.value.toString());
                    } else {
                        String string2 = attr.tag;
                        if (!(string2 != null ? !string2.equals("OQ") : "OQ" != null)) {
                            builder = this.builder$1.setOrigQual((CharSequence)attr.value.toString());
                        } else {
                            this.tags$1.elem = ((List)this.tags$1.elem).$colon$colon((Object)AttributeUtils$.MODULE$.convertSAMTagAndValue(attr));
                            builder = BoxedUnit.UNIT;
                        }
                    }
                    return builder;
                }
                {
                    this.builder$1 = builder$1;
                    this.tags$1 = tags$1;
                }
            });
            boxedUnit2 = builder.setAttributes((CharSequence)((List)tags.elem).mkString("\t"));
        }
        SAMReadGroupRecord recordGroup = samRecord.getReadGroup();
        if (recordGroup == null) {
            boxedUnit = BoxedUnit.UNIT;
        } else {
            Serializable serializable = new Serializable(this, builder){
                public static final long serialVersionUID = 0L;
                private final ADAMRecord.Builder builder$1;

                public final ADAMRecord.Builder apply(Date date) {
                    return this.builder$1.setRecordGroupRunDateEpoch(Predef$.MODULE$.long2Long(date.getTime()));
                }
                {
                    this.builder$1 = builder$1;
                }
            };
            Option option = Option$.MODULE$.apply((Object)recordGroup.getRunDate());
            if (!option.isEmpty()) {
                Object object8 = option.get();
                serializable.apply((Date)object8);
            }
            boxedUnit = builder.setRecordGroupName((CharSequence)recordGroup.getReadGroupId()).setRecordGroupSequencingCenter((CharSequence)recordGroup.getSequencingCenter()).setRecordGroupDescription((CharSequence)recordGroup.getDescription()).setRecordGroupFlowOrder((CharSequence)recordGroup.getFlowOrder()).setRecordGroupKeySequence((CharSequence)recordGroup.getKeySequence()).setRecordGroupLibrary((CharSequence)recordGroup.getLibrary()).setRecordGroupPredictedMedianInsertSize(recordGroup.getPredictedMedianInsertSize()).setRecordGroupPlatform((CharSequence)recordGroup.getPlatform()).setRecordGroupPlatformUnit((CharSequence)recordGroup.getPlatformUnit()).setRecordGroupSample((CharSequence)recordGroup.getSample());
        }
        return builder.build();
    }
}

