/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.instrumentation;

import java.text.DecimalFormat;
import java.util.concurrent.TimeUnit;
import scala.Function1;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.runtime.BoxedUnit;

public final class DurationFormatting$ {
    public static final DurationFormatting$ MODULE$;
    private final DecimalFormat TwoDigitNumberFormatter;

    static {
        new DurationFormatting$();
    }

    private DecimalFormat TwoDigitNumberFormatter() {
        return this.TwoDigitNumberFormatter;
    }

    public String formatMillisecondDuration(Number number) {
        long l = number.longValue();
        return this.formatDuration((Duration)Duration$.MODULE$.fromNanos(TimeUnit.MILLISECONDS.toNanos(l)));
    }

    public String formatNanosecondDuration(Number number) {
        long l = number.longValue();
        return this.formatDuration((Duration)Duration$.MODULE$.fromNanos(TimeUnit.NANOSECONDS.toNanos(l)));
    }

    public String formatDuration(Duration duration) {
        StringBuilder stringBuilder;
        BoxedUnit boxedUnit;
        long nanoDuration = duration.toNanos();
        if (nanoDuration < 0L) {
            throw new IllegalArgumentException("Duration must be greater or equal to zero!");
        }
        long hours = TimeUnit.NANOSECONDS.toHours(nanoDuration);
        long minutes = TimeUnit.NANOSECONDS.toMinutes(nanoDuration -= TimeUnit.HOURS.toNanos(hours));
        long seconds = TimeUnit.NANOSECONDS.toSeconds(nanoDuration -= TimeUnit.MINUTES.toNanos(minutes));
        long millis = TimeUnit.NANOSECONDS.toMillis(nanoDuration -= TimeUnit.SECONDS.toNanos(seconds));
        long micros = TimeUnit.NANOSECONDS.toMicros(nanoDuration -= TimeUnit.MILLISECONDS.toNanos(millis));
        nanoDuration -= TimeUnit.MICROSECONDS.toNanos(micros);
        StringBuilder builder = new StringBuilder();
        if (hours > 0L) {
            builder.append(hours);
            boxedUnit = builder.append(" hour").append(hours != 1L ? "s" : "");
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        if (minutes > 0L || hours > 0L) {
            Object object = hours > 0L ? builder.append(" ") : BoxedUnit.UNIT;
            builder.append(minutes);
            builder.append(" min").append(minutes != 1L ? "s" : "");
            builder.append(" ");
            builder.append(seconds);
            stringBuilder = builder.append(" sec").append(seconds != 1L ? "s" : "");
        } else if (seconds > 0L) {
            this.formatValue(seconds, millis, builder);
            stringBuilder = builder.append(" secs");
        } else if (millis > 0L) {
            this.formatValue(millis, micros, builder);
            stringBuilder = builder.append(" ms");
        } else if (micros > 0L) {
            this.formatValue(micros, nanoDuration, builder);
            stringBuilder = builder.append(" \u00b5s");
        } else if (nanoDuration > 0L) {
            builder.append(nanoDuration);
            stringBuilder = builder.append(" ns");
        } else {
            stringBuilder = builder.append("0");
        }
        return builder.toString();
    }

    private void formatValue(long largeValue, long smallValue, StringBuilder builder) {
        double totalValue = (double)largeValue + (double)smallValue / 1000.0;
        String stringValue = this.TwoDigitNumberFormatter().format(totalValue);
        if (stringValue.endsWith(".0")) {
            builder.append(stringValue.substring(0, stringValue.length() - ".0".length()));
        } else {
            builder.append(stringValue);
        }
    }

    private String formatNumber(Number number, Function1<Object, Object> conversionFunction) {
        return this.formatDuration((Duration)Duration$.MODULE$.fromNanos(conversionFunction.apply$mcJJ$sp(number.longValue())));
    }

    private DurationFormatting$() {
        MODULE$ = this;
        this.TwoDigitNumberFormatter = new DecimalFormat(".0#");
    }
}

