/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.rdd;

import fi.tkk.ics.hadoop.bam.AnySAMInputFormat;
import fi.tkk.ics.hadoop.bam.SAMRecordWritable;
import fi.tkk.ics.hadoop.bam.util.SAMHeaderReader;
import java.util.Collection;
import java.util.regex.Pattern;
import net.sf.samtools.SAMFileHeader;
import org.apache.avro.Schema;
import org.apache.avro.specific.SpecificRecord;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.lib.input.TextInputFormat;
import org.apache.spark.Logging;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.bdgenomics.adam.converters.FastaConverter$;
import org.bdgenomics.adam.converters.SAMRecordConverter;
import org.bdgenomics.adam.instrumentation.ADAMMetricsListener;
import org.bdgenomics.adam.models.ADAMRod;
import org.bdgenomics.adam.models.RecordGroupDictionary;
import org.bdgenomics.adam.models.RecordGroupDictionary$;
import org.bdgenomics.adam.models.SequenceDictionary;
import org.bdgenomics.adam.models.SequenceDictionary$;
import org.bdgenomics.adam.models.SequenceRecord;
import org.bdgenomics.adam.models.SequenceRecord$;
import org.bdgenomics.adam.predicates.ADAMPredicate;
import org.bdgenomics.adam.projections.ADAMNucleotideContigFragmentField$;
import org.bdgenomics.adam.projections.ADAMRecordField$;
import org.bdgenomics.adam.projections.FieldValue;
import org.bdgenomics.adam.projections.Projection$;
import org.bdgenomics.adam.rdd.ADAMContext$;
import org.bdgenomics.adam.rdd.ADAMNucleotideContigFragmentRDDFunctions;
import org.bdgenomics.adam.rdd.ADAMPileupRDDFunctions;
import org.bdgenomics.adam.rdd.ADAMRDDFunctions;
import org.bdgenomics.adam.rdd.ADAMRecordRDDFunctions;
import org.bdgenomics.adam.rdd.ADAMRodRDDFunctions;
import org.bdgenomics.adam.rich.RichADAMRecord;
import org.bdgenomics.adam.util.HadoopUtil$;
import org.bdgenomics.formats.avro.ADAMNucleotideContigFragment;
import org.bdgenomics.formats.avro.ADAMPileup;
import org.bdgenomics.formats.avro.ADAMRecord;
import org.slf4j.Logger;
import parquet.avro.AvroParquetInputFormat;
import parquet.avro.AvroReadSupport;
import parquet.filter.UnboundRecordFilter;
import parquet.hadoop.ParquetInputFormat;
import parquet.hadoop.util.ContextUtil;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0011=s!B\u0001\u0003\u0011\u0003Y\u0011aC!E\u00036\u001buN\u001c;fqRT!a\u0001\u0003\u0002\u0007I$GM\u0003\u0002\u0006\r\u0005!\u0011\rZ1n\u0015\t9\u0001\"\u0001\u0006cI\u001e,gn\\7jGNT\u0011!C\u0001\u0004_J<7\u0001\u0001\t\u0003\u00195i\u0011A\u0001\u0004\u0006\u001d\tA\ta\u0004\u0002\f\u0003\u0012\u000bUjQ8oi\u0016DHoE\u0002\u000e!Y\u0001\"!\u0005\u000b\u000e\u0003IQ\u0011aE\u0001\u0006g\u000e\fG.Y\u0005\u0003+I\u0011a!\u00118z%\u00164\u0007CA\t\u0018\u0013\tA\"C\u0001\u0007TKJL\u0017\r\\5{C\ndW\rC\u0003\u001b\u001b\u0011\u00051$\u0001\u0004=S:LGO\u0010\u000b\u0002\u0017!)Q$\u0004C\u0002=\u0005I2\u000f]1sW\u000e{g\u000e^3yiR{\u0017\tR!N\u0007>tG/\u001a=u)\ry\"1\u000b\t\u0003\u0019\u00012AA\u0004\u0002\u0001CM!\u0001\u0005\u0005\f#!\t\u0019\u0003&D\u0001%\u0015\t)c%A\u0003ta\u0006\u00148N\u0003\u0002(\u0011\u00051\u0011\r]1dQ\u0016L!!\u000b\u0013\u0003\u000f1{wmZ5oO\"A1\u0006\tB\u0001B\u0003%A&\u0001\u0002tGB\u00111%L\u0005\u0003]\u0011\u0012Ab\u00159be.\u001cuN\u001c;fqRDQA\u0007\u0011\u0005\u0002A\"\"aH\u0019\t\u000b-z\u0003\u0019\u0001\u0017\t\u000bM\u0002C\u0011\u0002\u001b\u0002+\u0005$\u0017-\u001c\"b[\u0012K7\r^5p]\u0006\u0014\u0018\u0010T8bIR\u0011Qg\u000f\t\u0003mej\u0011a\u000e\u0006\u0003q\u0011\ta!\\8eK2\u001c\u0018B\u0001\u001e8\u0005I\u0019V-];f]\u000e,G)[2uS>t\u0017M]=\t\u000bq\u0012\u0004\u0019A\u001f\u0002\u0011\u0019LG.\u001a)bi\"\u0004\"AP!\u000f\u0005Ey\u0014B\u0001!\u0013\u0003\u0019\u0001&/\u001a3fM&\u0011!i\u0011\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u0001\u0013\u0002\"B\u001a!\t\u0013)ECA\u001bG\u0011\u00159E\t1\u0001I\u0003%\u0019\u0018-\u001c%fC\u0012,'\u000f\u0005\u0002J!6\t!J\u0003\u0002L\u0019\u0006A1/Y7u_>d7O\u0003\u0002N\u001d\u0006\u00111O\u001a\u0006\u0002\u001f\u0006\u0019a.\u001a;\n\u0005ES%!D*B\u001b\u001aKG.\u001a%fC\u0012,'\u000fC\u0003TA\u0011%A+A\u000bbI\u0006l')Y7M_\u0006$'+Z1e\u000fJ|W\u000f]:\u0015\u0005UC\u0006C\u0001\u001cW\u0013\t9vGA\u000bSK\u000e|'\u000fZ$s_V\u0004H)[2uS>t\u0017M]=\t\u000b\u001d\u0013\u0006\u0019\u0001%\t\ri\u0003C\u0011\u0003\u0002\\\u0003-\tG-Y7CC6du.\u00193\u0015\u0005qK\u0007cA/`C6\taL\u0003\u0002\u0004I%\u0011\u0001M\u0018\u0002\u0004%\u0012#\u0005C\u00012h\u001b\u0005\u0019'B\u00013f\u0003\u0011\tgO]8\u000b\u0005\u00194\u0011a\u00024pe6\fGo]\u0005\u0003Q\u000e\u0014!\"\u0011#B\u001bJ+7m\u001c:e\u0011\u0015a\u0014\f1\u0001>\u0011\u0015Y\u0007\u0005\"\u0003m\u0003=\tG-Y7QCJ\fX/\u001a;M_\u0006$W\u0003B7s\u0003[!rA\\A\r\u00037\t\u0019\u0005\u0006\u0003pw\u0006=\u0001cA/`aB\u0011\u0011O\u001d\u0007\u0001\t\u0015\u0019(N1\u0001u\u0005\u0005!\u0016CA;y!\t\tb/\u0003\u0002x%\t9aj\u001c;iS:<\u0007CA\tz\u0013\tQ(CA\u0002B]fDq\u0001 6\u0002\u0002\u0003\u000fQ0\u0001\u0006fm&$WM\\2fIM\u0002R!\u0005@q\u0003\u0003I!a \n\u0003\u0013\u0019+hn\u0019;j_:\f\u0004\u0003BA\u0002\u0003\u0017i!!!\u0002\u000b\t\u0005\u001d\u0011\u0011B\u0001\tgB,7-\u001b4jG*\u0011AMJ\u0005\u0005\u0003\u001b\t)A\u0001\bTa\u0016\u001c\u0017NZ5d%\u0016\u001cwN\u001d3\t\u0013\u0005E!.!AA\u0004\u0005M\u0011AC3wS\u0012,gnY3%iA!a(!\u0006q\u0013\r\t9b\u0011\u0002\t\u001b\u0006t\u0017NZ3ti\")AH\u001ba\u0001{!I\u0011Q\u00046\u0011\u0002\u0003\u0007\u0011qD\u0001\naJ,G-[2bi\u0016\u0004R!EA\u0011\u0003KI1!a\t\u0013\u0005\u0019y\u0005\u000f^5p]B)a(a\n\u0002,%\u0019\u0011\u0011F\"\u0003\u000b\rc\u0017m]:\u0011\u0007E\fi\u0003B\u0004\u00020)\u0014\r!!\r\u0003\u0003U\u000b2!^A\u001a!\u0011\t)$a\u0010\u000e\u0005\u0005]\"\u0002BA\u001d\u0003w\taAZ5mi\u0016\u0014(BAA\u001f\u0003\u001d\u0001\u0018M]9vKRLA!!\u0011\u00028\t\u0019RK\u001c2pk:$'+Z2pe\u00124\u0015\u000e\u001c;fe\"I\u0011Q\t6\u0011\u0002\u0003\u0007\u0011qI\u0001\u000baJ|'.Z2uS>t\u0007#B\t\u0002\"\u0005%\u0003\u0003BA&\u0003\u001bj!!!\u0003\n\t\u0005=\u0013\u0011\u0002\u0002\u0007'\u000eDW-\\1\t\u000f\u0005M\u0003\u0005\"\u0001\u0002V\u0005\u0011\u0012\rZ1n\t&\u001cG/[8oCJLHj\\1e+\u0011\t9&a\u0019\u0015\t\u0005e\u00131\u000e\u000b\u0006k\u0005m\u0013Q\r\u0005\u000b\u0003;\n\t&!AA\u0004\u0005}\u0013AC3wS\u0012,gnY3%kA1\u0011C`A1\u0003\u0003\u00012!]A2\t\u0019\u0019\u0018\u0011\u000bb\u0001i\"Q\u0011qMA)\u0003\u0003\u0005\u001d!!\u001b\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$c\u0007E\u0003?\u0003+\t\t\u0007\u0003\u0004=\u0003#\u0002\r!\u0010\u0005\b\u0003_\u0002C\u0011AA9\u0003!\tG-Y7M_\u0006$WCBA:\u0003w\n\u0019\n\u0006\u0005\u0002v\u0005%\u00151RAR)\u0019\t9(! \u0002\u0004B!QlXA=!\r\t\u00181\u0010\u0003\u0007g\u00065$\u0019\u0001;\t\u0015\u0005}\u0014QNA\u0001\u0002\b\t\t)\u0001\u0006fm&$WM\\2fI]\u0002b!\u0005@\u0002z\u0005\u0005\u0001BCAC\u0003[\n\t\u0011q\u0001\u0002\b\u0006QQM^5eK:\u001cW\r\n\u001d\u0011\u000by\n)\"!\u001f\t\rq\ni\u00071\u0001>\u0011)\ti\"!\u001c\u0011\u0002\u0003\u0007\u0011Q\u0012\t\u0006#\u0005\u0005\u0012q\u0012\t\u0006}\u0005\u001d\u0012\u0011\u0013\t\u0004c\u0006ME\u0001CA\u0018\u0003[\u0012\r!!&\u0012\u0007U\f9\n\u0005\u0004\u0002\u001a\u0006}\u0015\u0011P\u0007\u0003\u00037S1!!(\u0005\u0003)\u0001(/\u001a3jG\u0006$Xm]\u0005\u0005\u0003C\u000bYJA\u0007B\t\u0006k\u0005K]3eS\u000e\fG/\u001a\u0005\u000b\u0003\u000b\ni\u0007%AA\u0002\u0005\u001d\u0003bBATA\u0011\u0005\u0011\u0011V\u0001\u0011C\u0012\fWnU3rk\u0016t7-\u001a'pC\u0012$b!a+\u00024\u0006U\u0006\u0003B/`\u0003[\u00032AYAX\u0013\r\t\tl\u0019\u0002\u001d\u0003\u0012\u000bUJT;dY\u0016|G/\u001b3f\u0007>tG/[4Ge\u0006<W.\u001a8u\u0011\u0019a\u0014Q\u0015a\u0001{!A\u0011qWAS\u0001\u0004\tI,\u0001\bge\u0006<W.\u001a8u\u0019\u0016tw\r\u001e5\u0011\u0007E\tY,C\u0002\u0002>J\u0011A\u0001T8oO\"9\u0011\u0011\u0019\u0011\u0005\u0002\u0005\r\u0017!\u00034j]\u00124\u0015\u000e\\3t)\u0019\t)-!<\u0002rB1\u0011qYAl\u0003;tA!!3\u0002T:!\u00111ZAi\u001b\t\tiMC\u0002\u0002P*\ta\u0001\u0010:p_Rt\u0014\"A\n\n\u0007\u0005U'#A\u0004qC\u000e\\\u0017mZ3\n\t\u0005e\u00171\u001c\u0002\u0004'\u0016\f(bAAk%A!\u0011q\\Au\u001b\t\t\tO\u0003\u0003\u0002d\u0006\u0015\u0018A\u00014t\u0015\r\t9OJ\u0001\u0007Q\u0006$wn\u001c9\n\t\u0005-\u0018\u0011\u001d\u0002\u0005!\u0006$\b\u000e\u0003\u0005\u0002p\u0006}\u0006\u0019AAo\u0003\u0011\u0001\u0018\r\u001e5\t\u000f\u0005M\u0018q\u0018a\u0001{\u0005)!/Z4fq\"9\u0011q\u001f\u0011\u0005\u0002\u0005e\u0018!\u00057pC\u0012\fE)Q'Ge>l\u0007+\u0019;igR\u0019A,a?\t\u0011\u0005u\u0018Q\u001fa\u0001\u0003\u000b\fQ\u0001]1uQND\u0011B!\u0001!#\u0003%IAa\u0001\u00023\u0005$\u0017-\u001c)beF,X\r\u001e'pC\u0012$C-\u001a4bk2$HEM\u000b\u0007\u0005\u000b\u0011\tCa\t\u0016\u0005\t\u001d!\u0006\u0002B\u0005\u0005\u001fq1!\u0005B\u0006\u0013\r\u0011iAE\u0001\u0005\u001d>tWm\u000b\u0002\u0003\u0012A!!1\u0003B\u000f\u001b\t\u0011)B\u0003\u0003\u0003\u0018\te\u0011!C;oG\",7m[3e\u0015\r\u0011YBE\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B\u0010\u0005+\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\t\u0019\u0019\u0018q b\u0001i\u0012A\u0011qFA\u0000\u0005\u0004\t\t\u0004C\u0005\u0003(\u0001\n\n\u0011\"\u0003\u0003*\u0005I\u0012\rZ1n!\u0006\u0014\u0018/^3u\u0019>\fG\r\n3fM\u0006,H\u000e\u001e\u00134+\u0019\u0011YCa\f\u00032U\u0011!Q\u0006\u0016\u0005\u0003\u000f\u0012y\u0001\u0002\u0004t\u0005K\u0011\r\u0001\u001e\u0003\t\u0003_\u0011)C1\u0001\u00022!I!Q\u0007\u0011\u0012\u0002\u0013\u0005!qG\u0001\u0013C\u0012\fW\u000eT8bI\u0012\"WMZ1vYR$#'\u0006\u0004\u0003\u0006\te\"1\b\u0003\u0007g\nM\"\u0019\u0001;\u0005\u0011\u0005=\"1\u0007b\u0001\u0005{\t2!\u001eB !\u0019\tI*a(\u0003BA\u0019\u0011O!\u000f\t\u0013\t\u0015\u0003%%A\u0005\u0002\t\u001d\u0013AE1eC6du.\u00193%I\u00164\u0017-\u001e7uIM*bAa\u000b\u0003J\t-CAB:\u0003D\t\u0007A\u000f\u0002\u0005\u00020\t\r#\u0019\u0001B'#\r)(q\n\t\u0007\u00033\u000byJ!\u0015\u0011\u0007E\u0014I\u0005C\u0003,9\u0001\u0007A\u0006C\u0004\u0003X5!\u0019A!\u0017\u0002%I$G\rV8B\t\u0006k%+Z2pe\u0012\u0014F\t\u0012\u000b\u0005\u00057\u0012\t\u0007E\u0002\r\u0005;J1Aa\u0018\u0003\u0005Y\tE)Q'SK\u000e|'\u000f\u001a*E\t\u001a+hn\u0019;j_:\u001c\bBB\u0002\u0003V\u0001\u0007A\fC\u0004\u0003f5!\u0019Aa\u001a\u0002%I$G\rV8B\t\u0006k\u0005+\u001b7fkB\u0014F\t\u0012\u000b\u0005\u0005S\u0012y\u0007E\u0002\r\u0005WJ1A!\u001c\u0003\u0005Y\tE)Q'QS2,W\u000f\u001d*E\t\u001a+hn\u0019;j_:\u001c\bbB\u0002\u0003d\u0001\u0007!\u0011\u000f\t\u0005;~\u0013\u0019\bE\u0002c\u0005kJ1Aa\u001ed\u0005)\tE)Q'QS2,W\u000f\u001d\u0005\b\u0005wjA1\u0001B?\u0003=\u0011H\r\u001a+p\u0003\u0012\u000bUJU8e%\u0012#E\u0003\u0002B@\u0005\u000b\u00032\u0001\u0004BA\u0013\r\u0011\u0019I\u0001\u0002\u0014\u0003\u0012\u000bUJU8e%\u0012#e)\u001e8di&|gn\u001d\u0005\b\u0007\te\u0004\u0019\u0001BD!\u0011ivL!#\u0011\u0007Y\u0012Y)C\u0002\u0003\u000e^\u0012q!\u0011#B\u001bJ{G\rC\u0004\u0003\u00126!\u0019Aa%\u0002\u0019I$G\rV8B\t\u0006k%\u000b\u0012#\u0016\t\tU%\u0011\u0015\u000b\u0005\u0005/\u0013y\u000b\u0006\u0004\u0003\u001a\n\r&\u0011\u0016\t\u0006\u0019\tm%qT\u0005\u0004\u0005;\u0013!\u0001E!E\u00036\u0013F\t\u0012$v]\u000e$\u0018n\u001c8t!\r\t(\u0011\u0015\u0003\u0007g\n=%\u0019\u0001;\t\u0015\t\u0015&qRA\u0001\u0002\b\u00119+\u0001\u0006fm&$WM\\2fIE\u0002b!\u0005@\u0003 \u0006\u0005\u0001B\u0003BV\u0005\u001f\u000b\t\u0011q\u0001\u0003.\u0006QQM^5eK:\u001cW\r\n\u001a\u0011\u000by\n)Ba(\t\u000f\r\u0011y\t1\u0001\u00032B!Ql\u0018BP\u0011\u001d\u0011\t*\u0004C\u0002\u0005k#BAa.\u0003>B\u0019AB!/\n\u0007\tm&A\u0001\u0015B\t\u0006ke*^2mK>$\u0018\u000eZ3D_:$\u0018n\u001a$sC\u001elWM\u001c;S\t\u00123UO\\2uS>t7\u000fC\u0004\u0004\u0005g\u0003\r!a+\t\u000f\t\u0005W\u0002b\u0001\u0003D\u0006\u0011\"/Z2pe\u0012$vNU5dQJ+7m\u001c:e)\u0011\u0011)M!5\u0011\t\t\u001d'QZ\u0007\u0003\u0005\u0013T1Aa3\u0005\u0003\u0011\u0011\u0018n\u00195\n\t\t='\u0011\u001a\u0002\u000f%&\u001c\u0007.\u0011#B\u001bJ+7m\u001c:e\u0011\u001d\u0011\u0019Na0A\u0002\u0005\faA]3d_J$\u0007b\u0002Bl\u001b\u0011\r!\u0011\\\u0001\u000fY&\u001cH\u000fV8KCZ\fG*[:u+\u0011\u0011YNa<\u0015\t\tu'1\u001f\t\u0007\u0005?\u0014IO!<\u000e\u0005\t\u0005(\u0002\u0002Br\u0005K\fA!\u001e;jY*\u0011!q]\u0001\u0005U\u00064\u0018-\u0003\u0003\u0003l\n\u0005(\u0001\u0002'jgR\u00042!\u001dBx\t\u001d\u0011\tP!6C\u0002Q\u0014\u0011!\u0011\u0005\t\u0005k\u0014)\u000e1\u0001\u0003x\u0006!A.[:u!\u0019\t9M!?\u0003n&!!1^An\u0011\u001d\u0011i0\u0004C\u0002\u0005\u007f\faB[1wC2K7\u000f\u001e+p\u0019&\u001cH/\u0006\u0003\u0004\u0002\r\u001dA\u0003BB\u0002\u0007\u0013\u0001b!a2\u0003z\u000e\u0015\u0001cA9\u0004\b\u00119!\u0011\u001fB~\u0005\u0004!\b\u0002\u0003B{\u0005w\u0004\raa\u0003\u0011\r\t}'\u0011^B\u0003\u0011\u001d\u0019y!\u0004C\u0002\u0007#\tAB[1wCN+G\u000fV8TKR,Baa\u0005\u0004\u001eQ!1QCB\u0010!\u0015q4qCB\u000e\u0013\r\u0019Ib\u0011\u0002\u0004'\u0016$\bcA9\u0004\u001e\u00119!\u0011_B\u0007\u0005\u0004!\b\u0002CB\u0011\u0007\u001b\u0001\raa\t\u0002\u0007M,G\u000f\u0005\u0004\u0003`\u000e\u001521D\u0005\u0005\u00073\u0011\t\u000fC\u0004\u0004*5!\u0019aa\u000b\u00021%tG\u000fT5tiR{'*\u0019<b\u0013:$XmZ3s\u0019&\u001cH\u000f\u0006\u0003\u0004.\rm\u0002C\u0002Bp\u0005S\u001cy\u0003\u0005\u0003\u00042\r]RBAB\u001a\u0015\u0011\u0019)D!:\u0002\t1\fgnZ\u0005\u0005\u0007s\u0019\u0019DA\u0004J]R,w-\u001a:\t\u0011\tU8q\u0005a\u0001\u0007{\u0001b!a2\u0003z\u000e}\u0002cA\t\u0004B%\u001911\t\n\u0003\u0007%sG\u000fC\u0004\u0004H5!\u0019a!\u0013\u0002)\rD\u0017M]*fcV,gnY3U_N#(/\u001b8h)\ri41\n\u0005\t\u0007\u001b\u001a)\u00051\u0001\u0004P\u0005\u00111m\u001d\t\u0005\u0007c\u0019\t&\u0003\u0003\u0004T\rM\"\u0001D\"iCJ\u001cV-];f]\u000e,\u0007bBB,\u001b\u0011\r1\u0011L\u0001\u0013G\"\f'oU3rk\u0016t7-\u001a+p\u0019&\u001cH\u000f\u0006\u0003\u0004\\\r\r\u0004CBAd\u0005s\u001ci\u0006E\u0002\u0012\u0007?J1a!\u0019\u0013\u0005\u0011\u0019\u0005.\u0019:\t\u0011\r53Q\u000ba\u0001\u0007\u001fBqaa\u001a\u000e\t\u0007\u0019I'\u0001\u0007nCB$vNS1wC6\u000b\u0007/\u0006\u0004\u0004l\rU4\u0011\u0010\u000b\u0005\u0007[\u001ai\b\u0005\u0005\u0003`\u000e=41OB<\u0013\u0011\u0019\tH!9\u0003\u00075\u000b\u0007\u000fE\u0002r\u0007k\"qA!=\u0004f\t\u0007A\u000fE\u0002r\u0007s\"qaa\u001f\u0004f\t\u0007AOA\u0001C\u0011!\u0019yh!\u001aA\u0002\r\u0005\u0015aA7baBA11QBE\u0007g\u001a9(\u0004\u0002\u0004\u0006*\u00191q\u0011\n\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0004r\r\u0015\u0005bBBG\u001b\u0011\r1qR\u0001\u0019SR,'/\u00192mKR{'*\u0019<b\u0007>dG.Z2uS>tW\u0003BBI\u00077#Baa%\u0004\u001eB1!q\\BK\u00073KAaa&\u0003b\nQ1i\u001c7mK\u000e$\u0018n\u001c8\u0011\u0007E\u001cY\nB\u0004\u0003r\u000e-%\u0019\u0001;\t\u0011\r}51\u0012a\u0001\u0007C\u000b\u0011!\u001b\t\u0007\u0003\u000f\u001c\u0019k!'\n\t\r\u0015\u00161\u001c\u0002\t\u0013R,'/\u00192mK\"91\u0011V\u0007\u0005\u0004\r-\u0016\u0001D:fiR{'*\u0019<b'\u0016$X\u0003BBW\u0007g#Baa,\u00046B1!q\\B\u0013\u0007c\u00032!]BZ\t\u001d\u0011\tpa*C\u0002QD\u0001b!\t\u0004(\u0002\u00071q\u0017\t\u0006}\r]1\u0011\u0017\u0005\b\u0007wkA\u0011AB_\u0003I\u0019'/Z1uKN\u0003\u0018M]6D_:$X\r\u001f;\u0015+1\u001ayla1\u0004H\u000e-7\u0011[Bo\u0007O\u001cYo!@\u0005\u0002!91\u0011YB]\u0001\u0004i\u0014\u0001\u00028b[\u0016Dqa!2\u0004:\u0002\u0007Q(\u0001\u0004nCN$XM\u001d\u0005\n\u0007\u0013\u001cI\f%AA\u0002u\n\u0011b\u001d9be.Du.\\3\t\u0015\r57\u0011\u0018I\u0001\u0002\u0004\u0019y-A\u0005ta\u0006\u00148NS1sgB)\u0011qYAl{!Q11[B]!\u0003\u0005\ra!6\u0002\u0019M\u0004\u0018M]6F]Z4\u0016M]:\u0011\r\u0005\u001d\u0017q[Bl!\u0015\t2\u0011\\\u001f>\u0013\r\u0019YN\u0005\u0002\u0007)V\u0004H.\u001a\u001a\t\u0015\r}7\u0011\u0018I\u0001\u0002\u0004\u0019\t/A\u000bta\u0006\u00148.\u00113e'R\fGo\u001d'jgR,g.\u001a:\u0011\u0007E\u0019\u0019/C\u0002\u0004fJ\u0011qAQ8pY\u0016\fg\u000e\u0003\u0006\u0004j\u000ee\u0006\u0013!a\u0001\u0007\u007f\t1c\u001d9be.\\%/_8Ck\u001a4WM]*ju\u0016D!b!<\u0004:B\u0005\t\u0019ABx\u0003Q\u0019\b/\u0019:l\u001b\u0016$(/[2t\u0019&\u001cH/\u001a8feB)\u0011#!\t\u0004rB!11_B}\u001b\t\u0019)PC\u0002\u0004x\u0012\tq\"\u001b8tiJ,X.\u001a8uCRLwN\\\u0005\u0005\u0007w\u001c)PA\nB\t\u0006kU*\u001a;sS\u000e\u001cH*[:uK:,'\u000f\u0003\u0006\u0004\u0000\u000ee\u0006\u0013!a\u0001\u0007C\f\u0001\u0003\\8bINK8\u000f^3n-\u0006dW/Z:\t\u0015\u0011\r1\u0011\u0018I\u0001\u0002\u0004!)!A\bta\u0006\u00148\u000e\u0012:jm\u0016\u0014\bk\u001c:u!\u0015\t\u0012\u0011EB \u0011%!I!DI\u0001\n\u0003!Y!\u0001\u000fde\u0016\fG/Z*qCJ\\7i\u001c8uKb$H\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u00115!fA\u001f\u0003\u0010!IA\u0011C\u0007\u0012\u0002\u0013\u0005A1C\u0001\u001dGJ,\u0017\r^3Ta\u0006\u00148nQ8oi\u0016DH\u000f\n3fM\u0006,H\u000e\u001e\u00135+\t!)B\u000b\u0003\u0004P\n=\u0001\"\u0003C\r\u001bE\u0005I\u0011\u0001C\u000e\u0003q\u0019'/Z1uKN\u0003\u0018M]6D_:$X\r\u001f;%I\u00164\u0017-\u001e7uIU*\"\u0001\"\b+\t\rU'q\u0002\u0005\n\tCi\u0011\u0013!C\u0001\tG\tAd\u0019:fCR,7\u000b]1sW\u000e{g\u000e^3yi\u0012\"WMZ1vYR$c'\u0006\u0002\u0005&)\"1\u0011\u001dB\b\u0011%!I#DI\u0001\n\u0003!Y#\u0001\u000fde\u0016\fG/Z*qCJ\\7i\u001c8uKb$H\u0005Z3gCVdG\u000fJ\u001c\u0016\u0005\u00115\"\u0006BB \u0005\u001fA\u0011\u0002\"\r\u000e#\u0003%\t\u0001b\r\u00029\r\u0014X-\u0019;f'B\f'o[\"p]R,\u0007\u0010\u001e\u0013eK\u001a\fW\u000f\u001c;%qU\u0011AQ\u0007\u0016\u0005\u0007_\u0014y\u0001C\u0005\u0005:5\t\n\u0011\"\u0001\u0005$\u0005a2M]3bi\u0016\u001c\u0006/\u0019:l\u0007>tG/\u001a=uI\u0011,g-Y;mi\u0012J\u0004\"\u0003C\u001f\u001bE\u0005I\u0011\u0001C \u0003u\u0019'/Z1uKN\u0003\u0018M]6D_:$X\r\u001f;%I\u00164\u0017-\u001e7uIE\u0002TC\u0001C!U\u0011!)Aa\u0004\t\u0013\u0011\u0015S\"!A\u0005\n\u0011\u001d\u0013a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"\u0001\"\u0013\u0011\t\rEB1J\u0005\u0005\t\u001b\u001a\u0019D\u0001\u0004PE*,7\r\u001e")
public class ADAMContext
implements Serializable,
Logging {
    private final SparkContext sc;
    private transient Logger org$apache$spark$Logging$$log_;

    public static Option<Object> createSparkContext$default$10() {
        return ADAMContext$.MODULE$.createSparkContext$default$10();
    }

    public static boolean createSparkContext$default$9() {
        return ADAMContext$.MODULE$.createSparkContext$default$9();
    }

    public static Option<ADAMMetricsListener> createSparkContext$default$8() {
        return ADAMContext$.MODULE$.createSparkContext$default$8();
    }

    public static int createSparkContext$default$7() {
        return ADAMContext$.MODULE$.createSparkContext$default$7();
    }

    public static boolean createSparkContext$default$6() {
        return ADAMContext$.MODULE$.createSparkContext$default$6();
    }

    public static Seq<Tuple2<String, String>> createSparkContext$default$5() {
        return ADAMContext$.MODULE$.createSparkContext$default$5();
    }

    public static Seq<String> createSparkContext$default$4() {
        return ADAMContext$.MODULE$.createSparkContext$default$4();
    }

    public static String createSparkContext$default$3() {
        return ADAMContext$.MODULE$.createSparkContext$default$3();
    }

    public static SparkContext createSparkContext(String string, String string2, String string3, Seq<String> seq, Seq<Tuple2<String, String>> seq2, boolean bl, int n, Option<ADAMMetricsListener> option, boolean bl2, Option<Object> option2) {
        return ADAMContext$.MODULE$.createSparkContext(string, string2, string3, seq, seq2, bl, n, option, bl2, option2);
    }

    public static <A> java.util.Set<A> setToJavaSet(scala.collection.immutable.Set<A> set) {
        return ADAMContext$.MODULE$.setToJavaSet(set);
    }

    public static <A> Collection<A> iterableToJavaCollection(Iterable<A> iterable) {
        return ADAMContext$.MODULE$.iterableToJavaCollection(iterable);
    }

    public static <A, B> java.util.Map<A, B> mapToJavaMap(Map<A, B> map) {
        return ADAMContext$.MODULE$.mapToJavaMap(map);
    }

    public static List<Object> charSequenceToList(CharSequence charSequence) {
        return ADAMContext$.MODULE$.charSequenceToList(charSequence);
    }

    public static String charSequenceToString(CharSequence charSequence) {
        return ADAMContext$.MODULE$.charSequenceToString(charSequence);
    }

    public static java.util.List<Integer> intListToJavaIntegerList(List<Object> list) {
        return ADAMContext$.MODULE$.intListToJavaIntegerList(list);
    }

    public static <A> scala.collection.immutable.Set<A> javaSetToSet(java.util.Set<A> set) {
        return ADAMContext$.MODULE$.javaSetToSet(set);
    }

    public static <A> List<A> javaListToList(java.util.List<A> list) {
        return ADAMContext$.MODULE$.javaListToList(list);
    }

    public static <A> java.util.List<A> listToJavaList(List<A> list) {
        return ADAMContext$.MODULE$.listToJavaList(list);
    }

    public static RichADAMRecord recordToRichRecord(ADAMRecord aDAMRecord) {
        return ADAMContext$.MODULE$.recordToRichRecord(aDAMRecord);
    }

    public static ADAMNucleotideContigFragmentRDDFunctions rddToADAMRDD(RDD<ADAMNucleotideContigFragment> rDD) {
        return ADAMContext$.MODULE$.rddToADAMRDD(rDD);
    }

    public static <T> ADAMRDDFunctions<T> rddToADAMRDD(RDD<T> rDD, Function1<T, SpecificRecord> function1, Manifest<T> manifest) {
        return ADAMContext$.MODULE$.rddToADAMRDD(rDD, function1, manifest);
    }

    public static ADAMRodRDDFunctions rddToADAMRodRDD(RDD<ADAMRod> rDD) {
        return ADAMContext$.MODULE$.rddToADAMRodRDD(rDD);
    }

    public static ADAMPileupRDDFunctions rddToADAMPileupRDD(RDD<ADAMPileup> rDD) {
        return ADAMContext$.MODULE$.rddToADAMPileupRDD(rDD);
    }

    public static ADAMRecordRDDFunctions rddToADAMRecordRDD(RDD<ADAMRecord> rDD) {
        return ADAMContext$.MODULE$.rddToADAMRecordRDD(rDD);
    }

    public static ADAMContext sparkContextToADAMContext(SparkContext sparkContext) {
        return ADAMContext$.MODULE$.sparkContextToADAMContext(sparkContext);
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    private SequenceDictionary adamBamDictionaryLoad(String filePath) {
        SAMFileHeader samHeader = SAMHeaderReader.readSAMHeaderFrom((Path)new Path(filePath), (Configuration)this.sc.hadoopConfiguration());
        return this.adamBamDictionaryLoad(samHeader);
    }

    private SequenceDictionary adamBamDictionaryLoad(SAMFileHeader samHeader) {
        return SequenceDictionary$.MODULE$.apply(samHeader);
    }

    private RecordGroupDictionary adamBamLoadReadGroups(SAMFileHeader samHeader) {
        return RecordGroupDictionary$.MODULE$.fromSAMHeader(samHeader);
    }

    public RDD<ADAMRecord> adamBamLoad(String filePath) {
        Predef$ predef$ = Predef$.MODULE$;
        this.log().info(new StringOps("Reading legacy BAM file format %s to create RDD").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{filePath})));
        SAMFileHeader samHeader = SAMHeaderReader.readSAMHeaderFrom((Path)new Path(filePath), (Configuration)this.sc.hadoopConfiguration());
        SequenceDictionary seqDict = this.adamBamDictionaryLoad(samHeader);
        RecordGroupDictionary readGroups = this.adamBamLoadReadGroups(samHeader);
        Job job = HadoopUtil$.MODULE$.newJob(this.sc);
        RDD records = this.sc.newAPIHadoopFile(filePath, AnySAMInputFormat.class, LongWritable.class, SAMRecordWritable.class, ContextUtil.getConfiguration((JobContext)job));
        SAMRecordConverter samRecordConverter = new SAMRecordConverter();
        return records.map((Function1)new Serializable(this, seqDict, readGroups, samRecordConverter){
            public static final long serialVersionUID = 0L;
            private final SequenceDictionary seqDict$1;
            private final RecordGroupDictionary readGroups$1;
            private final SAMRecordConverter samRecordConverter$1;

            public final ADAMRecord apply(Tuple2<LongWritable, SAMRecordWritable> p) {
                return this.samRecordConverter$1.convert(((SAMRecordWritable)p._2()).get(), this.seqDict$1, this.readGroups$1);
            }
            {
                this.seqDict$1 = seqDict$1;
                this.readGroups$1 = readGroups$1;
                this.samRecordConverter$1 = samRecordConverter$1;
            }
        }, ClassTag$.MODULE$.apply(ADAMRecord.class));
    }

    private <T, U extends UnboundRecordFilter> RDD<T> adamParquetLoad(String filePath, Option<Class<U>> predicate, Option<Schema> projection, Function1<T, SpecificRecord> evidence$3, Manifest<T> evidence$4) {
        Predef$ predef$ = Predef$.MODULE$;
        this.log().info(new StringOps("Reading the ADAM file at %s to create RDD").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{filePath})));
        Job job = HadoopUtil$.MODULE$.newJob(this.sc);
        ParquetInputFormat.setReadSupportClass((Job)job, AvroReadSupport.class);
        if (predicate.isDefined()) {
            this.log().info("Using the specified push-down predicate");
            ParquetInputFormat.setUnboundRecordFilter((Job)job, (Class)((Class)predicate.get()));
        }
        if (projection.isDefined()) {
            this.log().info("Using the specified projection schema");
            AvroParquetInputFormat.setRequestedProjection((Job)job, (Schema)((Schema)projection.get()));
        }
        RDD records = this.sc.newAPIHadoopFile(filePath, ParquetInputFormat.class, Void.class, Predef$.MODULE$.manifest(evidence$4).runtimeClass(), ContextUtil.getConfiguration((JobContext)job)).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final T apply(Tuple2<Void, T> p) {
                return (T)p._2();
            }
        }, evidence$4);
        return predicate.isDefined() ? records.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(T p) {
                return p != null;
            }
        }) : records;
    }

    private <T, U extends UnboundRecordFilter> None$ adamParquetLoad$default$2() {
        return None$.MODULE$;
    }

    private <T, U extends UnboundRecordFilter> Option<Schema> adamParquetLoad$default$3() {
        return None$.MODULE$;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <T> SequenceDictionary adamDictionaryLoad(String filePath, Function1<T, SpecificRecord> evidence$5, Manifest<T> evidence$6) {
        SequenceDictionary sequenceDictionary;
        Schema projection;
        boolean isADAMRecord = ADAMRecord.class.isAssignableFrom(Predef$.MODULE$.manifest(evidence$6).runtimeClass());
        boolean isADAMContig = ADAMNucleotideContigFragment.class.isAssignableFrom(Predef$.MODULE$.manifest(evidence$6).runtimeClass());
        Schema schema = isADAMRecord ? Projection$.MODULE$.apply((Seq<FieldValue>)Predef$.MODULE$.wrapRefArray((Object[])new FieldValue[]{ADAMRecordField$.MODULE$.contig(), ADAMRecordField$.MODULE$.mateContig(), ADAMRecordField$.MODULE$.readPaired(), ADAMRecordField$.MODULE$.firstOfPair(), ADAMRecordField$.MODULE$.readMapped(), ADAMRecordField$.MODULE$.mateMapped()})) : (projection = isADAMContig ? Projection$.MODULE$.apply((Seq<FieldValue>)Predef$.MODULE$.wrapRefArray((Object[])new FieldValue[]{ADAMNucleotideContigFragmentField$.MODULE$.contig()})) : Projection$.MODULE$.apply((Seq<FieldValue>)Predef$.MODULE$.wrapRefArray((Object[])new FieldValue[]{ADAMRecordField$.MODULE$.contig()})));
        if (filePath.endsWith(".bam") || filePath.endsWith(".sam")) {
            if (!isADAMRecord) throw new IllegalArgumentException("If you're reading a BAM/SAM file, the record type must be ADAMRecord");
            sequenceDictionary = this.adamBamDictionaryLoad(filePath);
            return sequenceDictionary;
        } else {
            SequenceDictionary dict;
            RDD<T> projected = this.adamParquetLoad(filePath, (Option)None$.MODULE$, (Option<Schema>)new Some((Object)projection), evidence$5, evidence$6);
            RDD recs = isADAMRecord ? projected.distinct().flatMap((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Set<SequenceRecord> apply(ADAMRecord rec) {
                    return SequenceRecord$.MODULE$.fromADAMRecord(rec);
                }
            }, ClassTag$.MODULE$.apply(SequenceRecord.class)) : (isADAMContig ? projected.distinct().map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final SequenceRecord apply(ADAMNucleotideContigFragment ctg) {
                    return SequenceRecord$.MODULE$.fromADAMContigFragment(ctg);
                }
            }, ClassTag$.MODULE$.apply(SequenceRecord.class)) : projected.distinct().map((Function1)new Serializable(this, evidence$5){
                public static final long serialVersionUID = 0L;
                private final Function1 evidence$5$1;

                public final SequenceRecord apply(T x$2) {
                    return SequenceRecord$.MODULE$.fromSpecificRecord((SpecificRecord)this.evidence$5$1.apply(x$2));
                }
                {
                    this.evidence$5$1 = evidence$5$1;
                }
            }, ClassTag$.MODULE$.apply(SequenceRecord.class)));
            sequenceDictionary = dict = (SequenceDictionary)recs.aggregate((Object)SequenceDictionary$.MODULE$.apply(), (Function2)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final SequenceDictionary apply(SequenceDictionary dict, SequenceRecord rec) {
                    return dict.$plus(rec);
                }
            }, (Function2)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final SequenceDictionary apply(SequenceDictionary dict1, SequenceDictionary dict2) {
                    return dict1.$plus$plus(dict2);
                }
            }, ClassTag$.MODULE$.apply(SequenceDictionary.class));
        }
        return sequenceDictionary;
    }

    public <T, U extends ADAMPredicate<T>> RDD<T> adamLoad(String filePath, Option<Class<U>> predicate, Option<Schema> projection, Function1<T, SpecificRecord> evidence$7, Manifest<T> evidence$8) {
        Object object;
        if (filePath.endsWith(".bam") || filePath.endsWith(".sam") && ADAMRecord.class.isAssignableFrom(Predef$.MODULE$.manifest(evidence$8).runtimeClass())) {
            if (projection.isDefined()) {
                this.log().warn("Projection is ignored when loading a BAM file");
            }
            RDD<ADAMRecord> reads = this.adamBamLoad(filePath);
            if (predicate.isDefined()) {
                Class predicateClass = (Class)predicate.get();
                ADAMPredicate filter = (ADAMPredicate)predicateClass.newInstance();
                object = filter.apply(reads);
            } else {
                object = reads;
            }
        } else {
            object = this.adamParquetLoad(filePath, predicate, projection, evidence$7, evidence$8);
        }
        return object;
    }

    public <T, U extends ADAMPredicate<T>> None$ adamLoad$default$2() {
        return None$.MODULE$;
    }

    public <T, U extends ADAMPredicate<T>> Option<Schema> adamLoad$default$3() {
        return None$.MODULE$;
    }

    public RDD<ADAMNucleotideContigFragment> adamSequenceLoad(String filePath, long fragmentLength) {
        Object object;
        if (filePath.endsWith(".fasta") || filePath.endsWith(".fa")) {
            RDD fastaData = this.sc.newAPIHadoopFile(filePath, TextInputFormat.class, LongWritable.class, Text.class, this.sc.newAPIHadoopFile$default$5());
            RDD remapData = fastaData.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Tuple2<Object, String> apply(Tuple2<LongWritable, Text> kv) {
                    return new Tuple2((Object)BoxesRunTime.boxToLong((long)((LongWritable)kv._1()).get()), (Object)((Text)kv._2()).toString());
                }
            }, ClassTag$.MODULE$.apply(Tuple2.class));
            this.log().info("Converting FASTA to ADAM.");
            object = FastaConverter$.MODULE$.apply((RDD<Tuple2<Object, String>>)remapData, fragmentLength);
        } else {
            object = this.adamParquetLoad(filePath, (Option)this.adamParquetLoad$default$2(), this.adamParquetLoad$default$3(), (Function1)Predef$.MODULE$.conforms(), (Manifest)ManifestFactory$.MODULE$.classType(ADAMNucleotideContigFragment.class));
        }
        return object;
    }

    public Seq<Path> findFiles(Path path, String regex) {
        Tuple2 tuple2;
        block4: {
            Seq seq;
            block3: {
                block2: {
                    if (regex != null) break block2;
                    seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Path[]{path}));
                    break block3;
                }
                FileStatus[] statuses = FileSystem.get((Configuration)this.sc.hadoopConfiguration()).listStatus(path);
                Pattern r = Pattern.compile(regex);
                tuple2 = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])statuses).filter((Function1)new $anonfun$8(this))).map((Function1)new $anonfun$9(this), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Path.class)))).partition((Function1)new $anonfun$10(this, r));
                if (tuple2 == null) break block4;
                Tuple2 tuple22 = new Tuple2(tuple2._1(), tuple2._2());
                Path[] matches = (Path[])tuple22._1();
                Path[] recurse = (Path[])tuple22._2();
                seq = (Seq)Predef$.MODULE$.refArrayOps((Object[])matches).toSeq().$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])recurse).flatMap((Function1)new Serializable(this, regex){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ADAMContext $outer;
                    private final String regex$1;

                    public final Seq<Path> apply(Path p) {
                        return this.$outer.findFiles(p, this.regex$1);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.regex$1 = regex$1;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Path.class)))), Seq$.MODULE$.canBuildFrom());
            }
            return seq;
        }
        throw new MatchError((Object)tuple2);
    }

    public RDD<ADAMRecord> loadADAMFromPaths(Seq<Path> paths2) {
        return this.sc.union((Seq)((TraversableLike)paths2.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ADAMContext $outer;

            public final Tuple2<SequenceDictionary, RDD<ADAMRecord>> apply(Path path) {
                return this.$outer.org$bdgenomics$adam$rdd$ADAMContext$$loadADAMs$1(path);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final RDD<ADAMRecord> apply(Tuple2<SequenceDictionary, RDD<ADAMRecord>> v) {
                return (RDD)v._2();
            }
        }, Seq$.MODULE$.canBuildFrom()), ClassTag$.MODULE$.apply(ADAMRecord.class));
    }

    public final Tuple2 org$bdgenomics$adam$rdd$ADAMContext$$loadADAMs$1(Path path) {
        SequenceDictionary dict = this.adamDictionaryLoad(path.toString(), (Function1)Predef$.MODULE$.conforms(), (Manifest)ManifestFactory$.MODULE$.classType(ADAMRecord.class));
        RDD rdd = this.adamLoad(path.toString(), (Option)this.adamLoad$default$2(), this.adamLoad$default$3(), (Function1)Predef$.MODULE$.conforms(), (Manifest)ManifestFactory$.MODULE$.classType(ADAMRecord.class));
        return new Tuple2((Object)dict, rdd);
    }

    public ADAMContext(SparkContext sc) {
        this.sc = sc;
        Logging.class.$init$((Logging)this);
    }
}

