/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.rdd;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.bdgenomics.adam.io.ByteAccess;
import org.bdgenomics.adam.rdd.Footer;
import parquet.format.FileMetaData;
import parquet.format.converter.MyConverter;
import parquet.org.apache.thrift.protocol.TCompactProtocol;
import parquet.org.apache.thrift.protocol.TProtocol;
import parquet.org.apache.thrift.transport.TIOStreamTransport;
import parquet.org.apache.thrift.transport.TTransport;
import parquet.schema.MessageType;
import scala.Predef$;
import scala.collection.GenIterable;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

public final class ParquetCommon$ {
    public static final ParquetCommon$ MODULE$;
    private final byte[] MAGIC;
    private final MyConverter converter;

    static {
        new ParquetCommon$();
    }

    public byte[] MAGIC() {
        return this.MAGIC;
    }

    public MyConverter converter() {
        return this.converter;
    }

    public MessageType parseMessageType(FileMetaData metadata) {
        return this.converter().convert(metadata);
    }

    public int readInt(byte[] buffer, int offset) {
        return ByteBuffer.wrap((byte[])Predef$.MODULE$.byteArrayOps((byte[])Predef$.MODULE$.byteArrayOps(buffer).slice(offset, offset + 4)).reverse()).getInt();
    }

    public FileMetaData readFileMetadata(ByteAccess io) {
        byte[] magicAndLength = io.readFully(io.length() - (long)this.MAGIC().length - 4L, this.MAGIC().length + 4);
        Predef$ predef$ = Predef$.MODULE$;
        byte[] byArray = (byte[])new ArrayOps.ofByte(magicAndLength).slice(4, magicAndLength.length);
        Predef$ predef$2 = Predef$.MODULE$;
        boolean bl = new ArrayOps.ofByte(byArray).sameElements((GenIterable)Predef$.MODULE$.wrapByteArray(this.MAGIC()));
        Predef$ predef$3 = Predef$.MODULE$;
        if (!bl) {
            throw new IllegalArgumentException(new StringBuilder().append((Object)"requirement failed: ").append((Object)"File does not appear to be a Parquet file").toString());
        }
        int footerLength = this.readInt(magicAndLength, 0);
        Predef$.MODULE$.assert(io.length() >= 0L);
        boolean bl2 = footerLength >= 0;
        Predef$ predef$4 = Predef$.MODULE$;
        if (!bl2) {
            Predef$ predef$5 = Predef$.MODULE$;
            throw new AssertionError((Object)new StringBuilder().append((Object)"assertion failed: ").append((Object)new StringOps("footerLength %d should be non-negative").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)footerLength)}))).toString());
        }
        Predef$.MODULE$.assert(io.length() - (long)this.MAGIC().length - 4L - (long)footerLength >= 0L);
        byte[] footerBytes = io.readFully(io.length() - (long)this.MAGIC().length - 4L - (long)footerLength, footerLength);
        ByteArrayInputStream footerInputStream = new ByteArrayInputStream(footerBytes);
        TCompactProtocol protocol = new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)footerInputStream));
        FileMetaData fileMetadata = new FileMetaData();
        fileMetadata.read((TProtocol)protocol);
        return fileMetadata;
    }

    public Footer readFooter(ByteAccess io) {
        return new Footer(this.readFileMetadata(io));
    }

    private ParquetCommon$() {
        MODULE$ = this;
        this.MAGIC = "PAR1".getBytes(Charset.forName("ASCII"));
        this.converter = new MyConverter();
    }
}

