/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.rdd;

import net.sf.samtools.Cigar;
import net.sf.samtools.CigarElement;
import net.sf.samtools.CigarOperator;
import org.apache.spark.Logging;
import org.apache.spark.SparkContext$;
import org.apache.spark.rdd.OrderedRDDFunctions;
import org.apache.spark.rdd.RDD;
import org.bdgenomics.adam.algorithms.consensus.ConsensusGenerator;
import org.bdgenomics.adam.algorithms.realignmenttarget.IndelRealignmentTarget;
import org.bdgenomics.adam.algorithms.realignmenttarget.RealignmentTargetFinder$;
import org.bdgenomics.adam.algorithms.realignmenttarget.ZippedTargetSet;
import org.bdgenomics.adam.models.Consensus;
import org.bdgenomics.adam.models.ReferencePosition;
import org.bdgenomics.adam.models.ReferencePosition$;
import org.bdgenomics.adam.models.ReferenceRegion;
import org.bdgenomics.adam.rdd.RealignIndels$;
import org.bdgenomics.adam.rich.RichADAMRecord;
import org.bdgenomics.adam.rich.RichADAMRecord$;
import org.bdgenomics.adam.util.ImplicitJavaConversions$;
import org.bdgenomics.adam.util.MdTag;
import org.bdgenomics.adam.util.MdTag$;
import org.bdgenomics.formats.avro.ADAMRecord;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Range$;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.TreeSet;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.math.Ordering$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0001\t-sAB\u0001\u0003\u0011\u0003\u0011!\"A\u0007SK\u0006d\u0017n\u001a8J]\u0012,Gn\u001d\u0006\u0003\u0007\u0011\t1A\u001d3e\u0015\t)a!\u0001\u0003bI\u0006l'BA\u0004\t\u0003)\u0011GmZ3o_6L7m\u001d\u0006\u0002\u0013\u0005\u0019qN]4\u0011\u0005-aQ\"\u0001\u0002\u0007\r5\u0011\u0001\u0012\u0001\u0002\u000f\u00055\u0011V-\u00197jO:Le\u000eZ3mgN\u0019AbD\u000b\u0011\u0005A\u0019R\"A\t\u000b\u0003I\tQa]2bY\u0006L!\u0001F\t\u0003\r\u0005s\u0017PU3g!\t\u0001b#\u0003\u0002\u0018#\ta1+\u001a:jC2L'0\u00192mK\")\u0011\u0004\u0004C\u00017\u00051A(\u001b8jiz\u001a\u0001\u0001F\u0001\u000b\u0011\u0015iB\u0002\"\u0001\u001f\u0003\u0015\t\u0007\u000f\u001d7z)!y\u0002'M\u001eA\u000b\u001ec\u0005c\u0001\u0011'Q5\t\u0011E\u0003\u0002\u0004E)\u00111\u0005J\u0001\u0006gB\f'o\u001b\u0006\u0003K!\ta!\u00199bG\",\u0017BA\u0014\"\u0005\r\u0011F\t\u0012\t\u0003S9j\u0011A\u000b\u0006\u0003W1\nA!\u0019<s_*\u0011QFB\u0001\bM>\u0014X.\u0019;t\u0013\ty#F\u0001\u0006B\t\u0006k%+Z2pe\u0012DQa\u0001\u000fA\u0002}AqA\r\u000f\u0011\u0002\u0003\u00071'\u0001\bd_:\u001cXM\\:vg6{G-\u001a7\u0011\u0005QJT\"A\u001b\u000b\u0005Y:\u0014!C2p]N,gn];t\u0015\tAD!\u0001\u0006bY\u001e|'/\u001b;i[NL!AO\u001b\u0003%\r{gn]3ogV\u001cx)\u001a8fe\u0006$xN\u001d\u0005\byq\u0001\n\u00111\u0001>\u00031!\u0017\r^1JgN{'\u000f^3e!\t\u0001b(\u0003\u0002@#\t9!i\\8mK\u0006t\u0007bB!\u001d!\u0003\u0005\rAQ\u0001\r[\u0006D\u0018J\u001c3fYNK'0\u001a\t\u0003!\rK!\u0001R\t\u0003\u0007%sG\u000fC\u0004G9A\u0005\t\u0019\u0001\"\u0002%5\f\u0007pQ8og\u0016t7/^:Ok6\u0014WM\u001d\u0005\b\u0011r\u0001\n\u00111\u0001J\u00031aw\u000e\u001a+ie\u0016\u001c\bn\u001c7e!\t\u0001\"*\u0003\u0002L#\t1Ai\\;cY\u0016Dq!\u0014\u000f\u0011\u0002\u0003\u0007!)A\u0007nCb$\u0016M]4fiNK'0\u001a\u0005\u0006\u001f2!)\u0001U\u0001\f[\u0006\u0004Hk\u001c+be\u001e,G\u000fF\u0002C#fCQA\u0015(A\u0002M\u000bAA]3bIB\u0011AkV\u0007\u0002+*\u0011a\u000bB\u0001\u0005e&\u001c\u0007.\u0003\u0002Y+\nq!+[2i\u0003\u0012\u000bUJU3d_J$\u0007\"\u0002.O\u0001\u0004Y\u0016a\u0002;be\u001e,Go\u001d\t\u00049\u0006\u001cW\"A/\u000b\u0005y{\u0016!C5n[V$\u0018M\u00197f\u0015\t\u0001\u0017#\u0001\u0006d_2dWm\u0019;j_:L!AY/\u0003\u000fQ\u0013X-Z*fiB!\u0001\u0003\u001a4C\u0013\t)\u0017C\u0001\u0004UkBdWM\r\t\u0003O*l\u0011\u0001\u001b\u0006\u0003S^\n\u0011C]3bY&<g.\\3oiR\f'oZ3u\u0013\tY\u0007N\u0001\fJ]\u0012,GNU3bY&<g.\\3oiR\u000b'oZ3uQ\tqU\u000e\u0005\u0002oc6\tqN\u0003\u0002q#\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005I|'a\u0002;bS2\u0014Xm\u0019\u0005\u0006\u001f2!\t\u0001\u001e\u000b\u0004\u0005V4\b\"\u0002*t\u0001\u0004\u0019\u0006\"\u0002.t\u0001\u00049\bCA4y\u0013\tI\bNA\b[SB\u0004X\r\u001a+be\u001e,GoU3u\u0011\u0015YH\u0002\"\u0001}\u0003Mi\u0017\r\u001d+p)\u0006\u0014x-\u001a;V]B\f7m[3e)\u0015i\u0018\u0011AA\u0003!\r\u0001bPZ\u0005\u0003\u007fF\u0011aa\u00149uS>t\u0007BBA\u0002u\u0002\u0007!)A\u0006uCJ<W\r^%oI\u0016D\b\"\u0002.{\u0001\u0004Y\u0006BB(\r\t\u0003\tI\u0001F\u0003~\u0003\u0017\ti\u0001C\u0004\u0002\u0004\u0005\u001d\u0001\u0019\u0001\"\t\ri\u000b9\u00011\u0001x\u0011\u001d\t\t\u0002\u0004C\u0001\u0003'\t!\"\\1q)\u0006\u0014x-\u001a;t)\u0019\t)\"!\r\u00028A!\u0001EJA\f!\u0015\u0001B-`A\r!\u0015\tY\"a\u000bT\u001d\u0011\ti\"a\n\u000f\t\u0005}\u0011QE\u0007\u0003\u0003CQ1!a\t\u001b\u0003\u0019a$o\\8u}%\t!#C\u0002\u0002*E\tq\u0001]1dW\u0006<W-\u0003\u0003\u0002.\u0005=\"\u0001C%uKJ\f'\r\\3\u000b\u0007\u0005%\u0012\u0003\u0003\u0005\u00024\u0005=\u0001\u0019AA\u001b\u0003!\u0011\u0018n\u00195`e\u0012$\u0007c\u0001\u0011''\"9!,a\u0004A\u0002\u0005e\u0002c\u0001/bM\"9\u0011Q\b\u0007\u0005\u0002\u0005}\u0012!F4fiJ+g-\u001a:f]\u000e,gI]8n%\u0016\fGm\u001d\u000b\u0005\u0003\u0003\nY\u0006E\u0005\u0011\u0003\u0007\n9%!\u0016\u0002V%\u0019\u0011QI\t\u0003\rQ+\b\u000f\\34!\u0011\tI%a\u0014\u000f\u0007A\tY%C\u0002\u0002NE\ta\u0001\u0015:fI\u00164\u0017\u0002BA)\u0003'\u0012aa\u0015;sS:<'bAA'#A\u0019\u0001#a\u0016\n\u0007\u0005e\u0013C\u0001\u0003M_:<\u0007\u0002CA/\u0003w\u0001\r!!\u0007\u0002\u000bI,\u0017\rZ:\t\u0013\u0005\u0005D\"%A\u0005\u0002\u0005\r\u0014aD1qa2LH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005\u0015$fA\u001a\u0002h-\u0012\u0011\u0011\u000e\t\u0005\u0003W\n\t(\u0004\u0002\u0002n)\u0019\u0011qN8\u0002\u0013Ut7\r[3dW\u0016$\u0017\u0002BA:\u0003[\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011%\t9\bDI\u0001\n\u0003\tI(A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00134+\t\tYHK\u0002>\u0003OB\u0011\"a \r#\u0003%\t!!!\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uIQ*\"!a!+\u0007\t\u000b9\u0007C\u0005\u0002\b2\t\n\u0011\"\u0001\u0002\u0002\u0006y\u0011\r\u001d9ms\u0012\"WMZ1vYR$S\u0007C\u0005\u0002\f2\t\n\u0011\"\u0001\u0002\u000e\u0006y\u0011\r\u001d9ms\u0012\"WMZ1vYR$c'\u0006\u0002\u0002\u0010*\u001a\u0011*a\u001a\t\u0013\u0005ME\"%A\u0005\u0002\u0005\u0005\u0015aD1qa2LH\u0005Z3gCVdG\u000fJ\u001c\t\u0013\u0005]E\"%A\u0005\u0002\u0005\r\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$\u0013\u0007C\u0005\u0002\u001c2\t\n\u0011\"\u0001\u0002z\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIIB\u0011\"a(\r#\u0003%\t!!!\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00134\u0011%\t\u0019\u000bDI\u0001\n\u0003\t\t)A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H\u0005\u000e\u0005\n\u0003Oc\u0011\u0013!C\u0001\u0003\u001b\u000b1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012*\u0004\"CAV\u0019E\u0005I\u0011AAA\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%m!I\u0011q\u0016\u0007\u0002\u0002\u0013%\u0011\u0011W\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u00024B!\u0011QWA`\u001b\t\t9L\u0003\u0003\u0002:\u0006m\u0016\u0001\u00027b]\u001eT!!!0\u0002\t)\fg/Y\u0005\u0005\u0003\u0003\f9L\u0001\u0004PE*,7\r\u001e\u0004\u0007\u001b\t\u0001!!!2\u0014\r\u0005\rw\"FAd!\u0011\tI-a3\u000e\u0003\tJ1!!4#\u0005\u001daunZ4j]\u001eD!BMAb\u0005\u000b\u0007I\u0011AAi+\u0005\u0019\u0004BCAk\u0003\u0007\u0014\t\u0011)A\u0005g\u0005y1m\u001c8tK:\u001cXo]'pI\u0016d\u0007\u0005\u0003\u0006=\u0003\u0007\u0014)\u0019!C\u0001\u00033,\u0012!\u0010\u0005\u000b\u0003;\f\u0019M!A!\u0002\u0013i\u0014!\u00043bi\u0006L5oU8si\u0016$\u0007\u0005\u0003\u0006B\u0003\u0007\u0014)\u0019!C\u0001\u0003C,\u0012A\u0011\u0005\u000b\u0003K\f\u0019M!A!\u0002\u0013\u0011\u0015!D7bq&sG-\u001a7TSj,\u0007\u0005\u0003\u0006G\u0003\u0007\u0014)\u0019!C\u0001\u0003CD!\"a;\u0002D\n\u0005\t\u0015!\u0003C\u0003Mi\u0017\r_\"p]N,gn];t\u001dVl'-\u001a:!\u0011)A\u00151\u0019BC\u0002\u0013\u0005\u0011q^\u000b\u0002\u0013\"Q\u00111_Ab\u0005\u0003\u0005\u000b\u0011B%\u0002\u001b1|G\r\u00165sKNDw\u000e\u001c3!\u0011)i\u00151\u0019BC\u0002\u0013\u0005\u0011\u0011\u001d\u0005\u000b\u0003s\f\u0019M!A!\u0002\u0013\u0011\u0015AD7bqR\u000b'oZ3u'&TX\r\t\u0005\b3\u0005\rG\u0011AA\u007f)9\tyP!\u0001\u0003\u0004\t\u0015!q\u0001B\u0005\u0005\u0017\u00012aCAb\u0011!\u0011\u00141 I\u0001\u0002\u0004\u0019\u0004\u0002\u0003\u001f\u0002|B\u0005\t\u0019A\u001f\t\u0011\u0005\u000bY\u0010%AA\u0002\tC\u0001BRA~!\u0003\u0005\rA\u0011\u0005\t\u0011\u0006m\b\u0013!a\u0001\u0013\"AQ*a?\u0011\u0002\u0003\u0007!\t\u0003\u0005\u0003\u0010\u0005\rG\u0011\u0001B\t\u0003I\u0011X-\u00197jO:$\u0016M]4fi\u001e\u0013x.\u001e9\u0015\t\u0005e!1\u0003\u0005\t\u0005+\u0011i\u00011\u0001\u0002\u0018\u0005YA/\u0019:hKR<%o\\;q\u0011!\u0011I\"a1\u0005\u0002\tm\u0011\u0001I:xK\u0016\u0004(+Z1e\u001fZ,'OU3gKJ,gnY3G_J\fV/\u00197jif$\u0002B!\b\u0003 \t\u0005\"Q\u0005\t\u0005!\u0011\u0014%\tC\u0004S\u0005/\u0001\r!a\u0012\t\u0011\t\r\"q\u0003a\u0001\u0003\u000f\n\u0011B]3gKJ,gnY3\t\u0011\t\u001d\"q\u0003a\u0001\u0005S\t\u0011\"];bY&$\u0018.Z:\u0011\u000b\u0005m!1\u0006\"\n\t\t5\u0012q\u0006\u0002\u0004'\u0016\f\b\u0002\u0003B\u0019\u0003\u0007$\tAa\r\u0002;M,X.T5t[\u0006$8\r[)vC2LG/_%h]>\u0014XmQ5hCJ$rA\u0011B\u001b\u0005o\u0011I\u0004C\u0004S\u0005_\u0001\r!a\u0012\t\u0011\t\r\"q\u0006a\u0001\u0003\u000fB\u0001Ba\n\u00030\u0001\u0007!\u0011\u0006\u0005\t\u0005{\t\u0019\r\"\u0001\u0003@\u0005\u00112/^7NSNl\u0017\r^2i#V\fG.\u001b;z)\r\u0011%\u0011\t\u0005\u0007%\nm\u0002\u0019\u0001\u0015\t\u0011\t\u0015\u00131\u0019C\u0001\u0005\u000f\nQB]3bY&<g.\u00138eK2\u001cHcA\u0010\u0003J!11Aa\u0011A\u0002}\u0001")
public class RealignIndels
implements Serializable,
Logging {
    private final ConsensusGenerator consensusModel;
    private final boolean dataIsSorted;
    private final int maxIndelSize;
    private final int maxConsensusNumber;
    private final double lodThreshold;
    private final int maxTargetSize;
    private transient Logger org$apache$spark$Logging$$log_;

    public static int $lessinit$greater$default$6() {
        return RealignIndels$.MODULE$.$lessinit$greater$default$6();
    }

    public static double $lessinit$greater$default$5() {
        return RealignIndels$.MODULE$.$lessinit$greater$default$5();
    }

    public static int $lessinit$greater$default$4() {
        return RealignIndels$.MODULE$.$lessinit$greater$default$4();
    }

    public static int $lessinit$greater$default$3() {
        return RealignIndels$.MODULE$.$lessinit$greater$default$3();
    }

    public static boolean $lessinit$greater$default$2() {
        return RealignIndels$.MODULE$.$lessinit$greater$default$2();
    }

    public static ConsensusGenerator $lessinit$greater$default$1() {
        return RealignIndels$.MODULE$.$lessinit$greater$default$1();
    }

    public static int apply$default$7() {
        return RealignIndels$.MODULE$.apply$default$7();
    }

    public static double apply$default$6() {
        return RealignIndels$.MODULE$.apply$default$6();
    }

    public static int apply$default$5() {
        return RealignIndels$.MODULE$.apply$default$5();
    }

    public static int apply$default$4() {
        return RealignIndels$.MODULE$.apply$default$4();
    }

    public static boolean apply$default$3() {
        return RealignIndels$.MODULE$.apply$default$3();
    }

    public static ConsensusGenerator apply$default$2() {
        return RealignIndels$.MODULE$.apply$default$2();
    }

    public static Tuple3<String, Object, Object> getReferenceFromReads(Iterable<RichADAMRecord> iterable) {
        return RealignIndels$.MODULE$.getReferenceFromReads(iterable);
    }

    public static RDD<Tuple2<Option<IndelRealignmentTarget>, Iterable<RichADAMRecord>>> mapTargets(RDD<RichADAMRecord> rDD, TreeSet<IndelRealignmentTarget> treeSet) {
        return RealignIndels$.MODULE$.mapTargets(rDD, treeSet);
    }

    public static Option<IndelRealignmentTarget> mapToTarget(int n, ZippedTargetSet zippedTargetSet) {
        return RealignIndels$.MODULE$.mapToTarget(n, zippedTargetSet);
    }

    public static Option<IndelRealignmentTarget> mapToTargetUnpacked(int n, TreeSet<Tuple2<IndelRealignmentTarget, Object>> treeSet) {
        return RealignIndels$.MODULE$.mapToTargetUnpacked(n, treeSet);
    }

    public static int mapToTarget(RichADAMRecord richADAMRecord, ZippedTargetSet zippedTargetSet) {
        return RealignIndels$.MODULE$.mapToTarget(richADAMRecord, zippedTargetSet);
    }

    public static int mapToTarget(RichADAMRecord richADAMRecord, TreeSet<Tuple2<IndelRealignmentTarget, Object>> treeSet) {
        return RealignIndels$.MODULE$.mapToTarget(richADAMRecord, treeSet);
    }

    public static RDD<ADAMRecord> apply(RDD<ADAMRecord> rDD, ConsensusGenerator consensusGenerator, boolean bl, int n, int n2, double d, int n3) {
        return RealignIndels$.MODULE$.apply(rDD, consensusGenerator, bl, n, n2, d, n3);
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public ConsensusGenerator consensusModel() {
        return this.consensusModel;
    }

    public boolean dataIsSorted() {
        return this.dataIsSorted;
    }

    public int maxIndelSize() {
        return this.maxIndelSize;
    }

    public int maxConsensusNumber() {
        return this.maxConsensusNumber;
    }

    public double lodThreshold() {
        return this.lodThreshold;
    }

    public int maxTargetSize() {
        return this.maxTargetSize;
    }

    public Iterable<RichADAMRecord> realignTargetGroup(Tuple2<Option<IndelRealignmentTarget>, Iterable<RichADAMRecord>> targetGroup) {
        if (targetGroup != null) {
            Tuple2 tuple2 = new Tuple2(targetGroup._1(), targetGroup._2());
            Option target = (Option)tuple2._1();
            Iterable reads = (Iterable)tuple2._2();
            Iterable realignedReads = (Iterable)reads.filter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(RichADAMRecord r) {
                    return r.mdTag().isDefined() && !((MdTag)r.mdTag().get()).hasMismatches();
                }
            });
            Tuple3<String, Object, Object> tuple3 = RealignIndels$.MODULE$.getReferenceFromReads((Iterable<RichADAMRecord>)((Iterable)reads.map((Function1)new $anonfun$10(this), Iterable$.MODULE$.canBuildFrom())));
            if (tuple3 != null) {
                Iterable iterable;
                Tuple3 tuple32 = new Tuple3(tuple3._1(), tuple3._2(), tuple3._3());
                String reference = (String)tuple32._1();
                long refStart = BoxesRunTime.unboxToLong((Object)tuple32._2());
                long refEnd = BoxesRunTime.unboxToLong((Object)tuple32._3());
                ReferenceRegion refRegion = new ReferenceRegion(ImplicitJavaConversions$.MODULE$.charSequenceToString(((RichADAMRecord)reads.head()).record().getContig().getContigName()), refStart, refEnd);
                Iterable<RichADAMRecord> readsToClean = this.consensusModel().preprocessReadsForRealignment((Iterable<RichADAMRecord>)((Iterable)reads.filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(RichADAMRecord r) {
                        return !r.mdTag().isDefined() || ((MdTag)r.mdTag().get()).hasMismatches();
                    }
                })), reference, refRegion);
                Iterable consensus = this.consensusModel().findConsensus(readsToClean);
                if (consensus.size() > this.maxConsensusNumber()) {
                    Random r = new Random();
                    consensus = (Iterable)((IterableLike)r.shuffle(consensus, Iterable$.MODULE$.canBuildFrom())).take(this.maxConsensusNumber());
                }
                if (target.isEmpty()) {
                    iterable = reads;
                } else {
                    if (readsToClean.size() > 0 && consensus.size() > 0) {
                        int totalMismatchSumPreCleaning = BoxesRunTime.unboxToInt((Object)((TraversableOnce)readsToClean.map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ RealignIndels $outer;

                            public final int apply(RichADAMRecord x$7) {
                                return this.$outer.sumMismatchQuality(RichADAMRecord$.MODULE$.richRecordToRecord(x$7));
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        }, Iterable$.MODULE$.canBuildFrom())).reduce((Function2)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final int apply(int x$8, int x$9) {
                                return x$8 + x$9;
                            }

                            public int apply$mcIII$sp(int x$8, int x$9) {
                                return x$8 + x$9;
                            }
                        }));
                        ObjectRef consensusOutcomes = new ObjectRef((Object)Nil$.MODULE$);
                        consensus.foreach((Function1)new Serializable(this, reference, refStart, refEnd, readsToClean, consensusOutcomes){
                            public static final long serialVersionUID = 0L;
                            public final /* synthetic */ RealignIndels $outer;
                            private final String reference$1;
                            private final long refStart$1;
                            private final long refEnd$1;
                            private final Iterable readsToClean$1;
                            private final ObjectRef consensusOutcomes$1;

                            public final void apply(Consensus c) {
                                String consensusSequence = c.insertIntoReference(this.reference$1, this.refStart$1, this.refEnd$1);
                                Iterable sweptValues = (Iterable)this.readsToClean$1.map((Function1)new Serializable(this, consensusSequence){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ $anonfun$realignTargetGroup$1 $outer;
                                    private final String consensusSequence$1;

                                    public final Tuple2<RichADAMRecord, Tuple2<Object, Object>> apply(RichADAMRecord r) {
                                        Tuple2<Object, Object> tuple2 = this.$outer.$outer.sweepReadOverReferenceForQuality(ImplicitJavaConversions$.MODULE$.charSequenceToString(RichADAMRecord$.MODULE$.richRecordToRecord(r).getSequence()), this.consensusSequence$1, (Seq<Object>)Predef$.MODULE$.wrapIntArray(r.qualityScores()));
                                        if (tuple2 != null) {
                                            Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(tuple2._1$mcI$sp(), tuple2._2$mcI$sp());
                                            int qual = sp2._1$mcI$sp();
                                            int pos = sp2._2$mcI$sp();
                                            int originalQual = this.$outer.$outer.sumMismatchQuality(RichADAMRecord$.MODULE$.richRecordToRecord(r));
                                            return qual < originalQual ? new Tuple2((Object)r, (Object)new Tuple2.mcII.sp(qual, pos)) : new Tuple2((Object)r, (Object)new Tuple2.mcII.sp(originalQual, -1));
                                        }
                                        throw new MatchError(tuple2);
                                    }
                                    {
                                        if ($outer == null) {
                                            throw new NullPointerException();
                                        }
                                        this.$outer = $outer;
                                        this.consensusSequence$1 = consensusSequence$1;
                                    }
                                }, Iterable$.MODULE$.canBuildFrom());
                                int totalQuality = BoxesRunTime.unboxToInt((Object)((TraversableOnce)sweptValues.map((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final int apply(Tuple2<RichADAMRecord, Tuple2<Object, Object>> x$11) {
                                        return ((Tuple2)x$11._2())._1$mcI$sp();
                                    }
                                }, Iterable$.MODULE$.canBuildFrom())).reduce((Function2)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final int apply(int x$12, int x$13) {
                                        return x$12 + x$13;
                                    }

                                    public int apply$mcIII$sp(int x$12, int x$13) {
                                        return x$12 + x$13;
                                    }
                                }));
                                ObjectRef readMappings = new ObjectRef((Object)((Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$)));
                                ((IterableLike)sweptValues.map((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final Tuple2<RichADAMRecord, Object> apply(Tuple2<RichADAMRecord, Tuple2<Object, Object>> kv) {
                                        return new Tuple2(kv._1(), (Object)BoxesRunTime.boxToInteger((int)((Tuple2)kv._2())._2$mcI$sp()));
                                    }
                                }, Iterable$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this, readMappings){
                                    public static final long serialVersionUID = 0L;
                                    private final ObjectRef readMappings$1;

                                    public final Map<RichADAMRecord, Object> apply(Tuple2<RichADAMRecord, Object> m) {
                                        Object object = m._1();
                                        Predef$ predef$ = Predef$.MODULE$;
                                        Integer n = BoxesRunTime.boxToInteger((int)m._2$mcI$sp());
                                        Predef.ArrowAssoc$ arrowAssoc$ = Predef.ArrowAssoc$.MODULE$;
                                        return (Map)((Map)this.readMappings$1.elem).$plus$eq(new Tuple2(object, (Object)n));
                                    }
                                    {
                                        this.readMappings$1 = readMappings$1;
                                    }
                                });
                                Tuple3 tuple3 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)totalQuality), (Object)c, (Object)((Map)readMappings.elem));
                                this.consensusOutcomes$1.elem = ((List)this.consensusOutcomes$1.elem).$colon$colon((Object)tuple3);
                            }

                            public /* synthetic */ RealignIndels org$bdgenomics$adam$rdd$RealignIndels$$anonfun$$$outer() {
                                return this.$outer;
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.reference$1 = reference$1;
                                this.refStart$1 = refStart$1;
                                this.refEnd$1 = refEnd$1;
                                this.readsToClean$1 = readsToClean$1;
                                this.consensusOutcomes$1 = consensusOutcomes$1;
                            }
                        });
                        Tuple3 bestConsensusTuple = (Tuple3)((List)consensusOutcomes.elem).reduce((Function2)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Tuple3<Object, Consensus, Map<RichADAMRecord, Object>> apply(Tuple3<Object, Consensus, Map<RichADAMRecord, Object>> c1, Tuple3<Object, Consensus, Map<RichADAMRecord, Object>> c2) {
                                return BoxesRunTime.unboxToInt((Object)c1._1()) <= BoxesRunTime.unboxToInt((Object)c2._1()) ? c1 : c2;
                            }
                        });
                        if (bestConsensusTuple != null) {
                            Tuple3 tuple33 = new Tuple3(bestConsensusTuple._1(), bestConsensusTuple._2(), bestConsensusTuple._3());
                            int bestConsensusMismatchSum = BoxesRunTime.unboxToInt((Object)tuple33._1());
                            Consensus bestConsensus = (Consensus)tuple33._2();
                            Map bestMappings = (Map)tuple33._3();
                            if ((double)(totalMismatchSumPreCleaning - bestConsensusMismatchSum) / 10.0 > this.lodThreshold()) {
                                Iterable cleanedReads = (Iterable)readsToClean.map((Function1)new Serializable(this, reference, refStart, bestConsensus, bestMappings){
                                    public static final long serialVersionUID = 0L;
                                    private final String reference$1;
                                    private final long refStart$1;
                                    private final Consensus bestConsensus$1;
                                    private final Map bestMappings$1;

                                    /*
                                     * Enabled force condition propagation
                                     * Lifted jumps to return sites
                                     */
                                    public final RichADAMRecord apply(RichADAMRecord r) {
                                        RichADAMRecord richADAMRecord;
                                        ADAMRecord.Builder builder = ADAMRecord.newBuilder((ADAMRecord)RichADAMRecord$.MODULE$.richRecordToRecord(r));
                                        int remapping = BoxesRunTime.unboxToInt((Object)this.bestMappings$1.apply((Object)r));
                                        if (remapping != -1) {
                                            Cigar cigar;
                                            builder.setMapq(Predef$.MODULE$.int2Integer(Predef$.MODULE$.Integer2int(RichADAMRecord$.MODULE$.richRecordToRecord(r).getMapq()) + 10));
                                            builder.setStart(Predef$.MODULE$.long2Long(this.refStart$1 + (long)remapping));
                                            if (this.refStart$1 + (long)remapping >= this.bestConsensus$1.index().start() && this.refStart$1 + (long)remapping <= this.bestConsensus$1.index().end() - 1L) {
                                                Tuple2 tuple2;
                                                Tuple2 tuple22 = tuple2 = this.bestConsensus$1.index().start() == this.bestConsensus$1.index().end() - 1L ? new Tuple2((Object)new CigarElement(this.bestConsensus$1.consensus().length(), CigarOperator.I), (Object)BoxesRunTime.boxToLong((long)((long)(RichADAMRecord$.MODULE$.richRecordToRecord(r).getSequence().length() - this.bestConsensus$1.consensus().length()) - (this.bestConsensus$1.index().start() - (this.refStart$1 + (long)remapping))))) : new Tuple2((Object)new CigarElement((int)(this.bestConsensus$1.index().end() - 1L - this.bestConsensus$1.index().start()), CigarOperator.D), (Object)BoxesRunTime.boxToLong((long)((long)RichADAMRecord$.MODULE$.richRecordToRecord(r).getSequence().length() - (this.bestConsensus$1.index().start() - (this.refStart$1 + (long)remapping)))));
                                                if (tuple2 == null) throw new MatchError((Object)tuple2);
                                                Tuple2 tuple23 = new Tuple2(tuple2._1(), (Object)BoxesRunTime.boxToLong((long)tuple2._2$mcJ$sp()));
                                                CigarElement idElement = (CigarElement)tuple23._1();
                                                long endLength = tuple23._2$mcJ$sp();
                                                List cigarElements = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CigarElement[]{new CigarElement((int)(this.refStart$1 + (long)remapping - this.bestConsensus$1.index().start()), CigarOperator.M), idElement, new CigarElement((int)endLength, CigarOperator.M)}));
                                                cigar = new Cigar(ImplicitJavaConversions$.MODULE$.listToJavaList(cigarElements));
                                            } else {
                                                cigar = new Cigar(ImplicitJavaConversions$.MODULE$.listToJavaList(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CigarElement[]{new CigarElement(RichADAMRecord$.MODULE$.richRecordToRecord(r).getSequence().length(), CigarOperator.M)}))));
                                            }
                                            Cigar newCigar = cigar;
                                            String string = this.reference$1;
                                            Predef$ predef$ = Predef$.MODULE$;
                                            builder.setMismatchingPositions((CharSequence)MdTag$.MODULE$.moveAlignment(r, newCigar, (String)new StringOps(string).drop(remapping), this.refStart$1 + (long)remapping).toString());
                                            builder.setCigar((CharSequence)newCigar.toString());
                                            richADAMRecord = new RichADAMRecord(builder.build());
                                            return richADAMRecord;
                                        } else {
                                            richADAMRecord = new RichADAMRecord(builder.build());
                                        }
                                        return richADAMRecord;
                                    }
                                    {
                                        this.reference$1 = reference$1;
                                        this.refStart$1 = refStart$1;
                                        this.bestConsensus$1 = bestConsensus$1;
                                        this.bestMappings$1 = bestMappings$1;
                                    }
                                }, Iterable$.MODULE$.canBuildFrom());
                                realignedReads = (Iterable)cleanedReads.$plus$plus((GenTraversableOnce)realignedReads, Iterable$.MODULE$.canBuildFrom());
                            } else {
                                realignedReads = (Iterable)readsToClean.$plus$plus((GenTraversableOnce)realignedReads, Iterable$.MODULE$.canBuildFrom());
                            }
                        } else {
                            throw new MatchError((Object)bestConsensusTuple);
                        }
                    }
                    iterable = realignedReads;
                }
                return iterable;
            }
            throw new MatchError(tuple3);
        }
        throw new MatchError(targetGroup);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Tuple2<Object, Object> sweepReadOverReferenceForQuality(String read, String reference, Seq<Object> qualities) {
        ObjectRef qualityScores2 = new ObjectRef((Object)Nil$.MODULE$);
        Predef$ predef$ = Predef$.MODULE$;
        int n = reference.length() - read.length();
        Serializable serializable = new Serializable(this, read, reference, qualities, qualityScores2){
            public static final long serialVersionUID = 0L;
            public final /* synthetic */ RealignIndels $outer;
            public final String read$1;
            public final String reference$2;
            public final Seq qualities$1;
            public final ObjectRef qualityScores$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                int qualityScore = this.$outer.sumMismatchQualityIgnoreCigar(this.read$1, this.reference$2.substring(i, i + this.read$1.length()), (Seq<Object>)this.qualities$1);
                Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(qualityScore, i);
                this.qualityScores$1.elem = ((List)this.qualityScores$1.elem).$colon$colon((Object)sp2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.read$1 = read$1;
                this.reference$2 = reference$2;
                this.qualities$1 = qualities$1;
                this.qualityScores$1 = qualityScores$1;
            }
        };
        Range range = Range$.MODULE$.apply(0, n);
        if (!range.validateRangeBoundaries((Function1)serializable)) return (Tuple2)((List)qualityScores2.elem).reduce((Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Object> apply(Tuple2<Object, Object> p1, Tuple2<Object, Object> p2) {
                return p1._1$mcI$sp() < p2._1$mcI$sp() ? p1 : p2;
            }
        });
        int n2 = range.start();
        int n3 = range.terminalElement();
        int n4 = range.step();
        while (n2 != n3) {
            void var10_4;
            int qualityScore1 = this.sumMismatchQualityIgnoreCigar(read, reference.substring(n2, n2 + read.length()), qualities);
            Tuple2.mcII.sp x$171 = new Tuple2.mcII.sp(qualityScore1, n2);
            var10_4.elem = ((List)var10_4.elem).$colon$colon((Object)x$171);
            n2 += n4;
        }
        return (Tuple2)((List)qualityScores2.elem).reduce((Function2)new /* invalid duplicate definition of identical inner class */);
    }

    public int sumMismatchQualityIgnoreCigar(String read, String reference, Seq<Object> qualities) {
        Predef$ predef$ = Predef$.MODULE$;
        IndexedSeq mismatchQualities = (IndexedSeq)((TraversableLike)((TraversableLike)((IterableLike)new StringOps(read).zip((GenIterable)Predef$.MODULE$.wrapString(reference), Predef$.MODULE$.fallbackStringCanBuildFrom())).zip(qualities, IndexedSeq$.MODULE$.canBuildFrom())).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Tuple2<Object, Object>, Object> r) {
                return ((Tuple2)r._1())._1$mcC$sp() != ((Tuple2)r._1())._2$mcC$sp();
            }
        })).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Tuple2<Tuple2<Object, Object>, Object> x$18) {
                return x$18._2$mcI$sp();
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        return mismatchQualities.length() > 0 ? BoxesRunTime.unboxToInt((Object)mismatchQualities.reduce((Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(int x$19, int x$20) {
                return x$19 + x$20;
            }

            public int apply$mcIII$sp(int x$19, int x$20) {
                return x$19 + x$20;
            }
        })) : 0;
    }

    public int sumMismatchQuality(ADAMRecord read) {
        return this.sumMismatchQualityIgnoreCigar(ImplicitJavaConversions$.MODULE$.charSequenceToString(read.getSequence()), ((MdTag)RichADAMRecord$.MODULE$.recordToRichRecord(read).mdTag().get()).getReference(RichADAMRecord$.MODULE$.recordToRichRecord(read)), (Seq<Object>)Predef$.MODULE$.wrapIntArray(RichADAMRecord$.MODULE$.recordToRichRecord(read).qualityScores()));
    }

    public RDD<ADAMRecord> realignIndels(RDD<ADAMRecord> rdd) {
        RDD rDD;
        if (this.dataIsSorted()) {
            rDD = rdd.filter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(ADAMRecord r) {
                    return Predef$.MODULE$.Boolean2boolean(r.getReadMapped());
                }
            });
        } else {
            OrderedRDDFunctions qual$1 = SparkContext$.MODULE$.rddToOrderedRDDFunctions(rdd.filter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(ADAMRecord r) {
                    return Predef$.MODULE$.Boolean2boolean(r.getReadMapped());
                }
            }).keyBy((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final ReferencePosition apply(ADAMRecord r) {
                    return (ReferencePosition)ReferencePosition$.MODULE$.apply(r).get();
                }
            }), Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.conforms()), ClassTag$.MODULE$.apply(ReferencePosition.class), ClassTag$.MODULE$.apply(ADAMRecord.class));
            boolean x$22 = qual$1.sortByKey$default$1();
            int x$23 = qual$1.sortByKey$default$2();
            RDD sr = qual$1.sortByKey(x$22, x$23);
            rDD = sr.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final ADAMRecord apply(Tuple2<ReferencePosition, ADAMRecord> kv) {
                    return (ADAMRecord)kv._2();
                }
            }, ClassTag$.MODULE$.apply(ADAMRecord.class));
        }
        RDD sortedRdd = rDD;
        RDD rich_rdd = sortedRdd.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final RichADAMRecord apply(ADAMRecord x$21) {
                return new RichADAMRecord(x$21);
            }
        }, ClassTag$.MODULE$.apply(RichADAMRecord.class));
        this.log().info("Generating realignment targets...");
        TreeSet<IndelRealignmentTarget> targets = RealignmentTargetFinder$.MODULE$.apply((RDD<RichADAMRecord>)rich_rdd, this.maxIndelSize(), this.maxTargetSize());
        this.log().info("Grouping reads by target...");
        RDD<Tuple2<Option<IndelRealignmentTarget>, Iterable<RichADAMRecord>>> readsMappedToTarget = RealignIndels$.MODULE$.mapTargets((RDD<RichADAMRecord>)rich_rdd, targets);
        this.log().info("Sorting reads by reference in ADAM RDD");
        return readsMappedToTarget.flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RealignIndels $outer;

            public final Iterable<RichADAMRecord> apply(Tuple2<Option<IndelRealignmentTarget>, Iterable<RichADAMRecord>> targetGroup) {
                return this.$outer.realignTargetGroup(targetGroup);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, ClassTag$.MODULE$.apply(RichADAMRecord.class)).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final ADAMRecord apply(RichADAMRecord r) {
                return r.record();
            }
        }, ClassTag$.MODULE$.apply(ADAMRecord.class));
    }

    public RealignIndels(ConsensusGenerator consensusModel, boolean dataIsSorted, int maxIndelSize, int maxConsensusNumber, double lodThreshold, int maxTargetSize) {
        this.consensusModel = consensusModel;
        this.dataIsSorted = dataIsSorted;
        this.maxIndelSize = maxIndelSize;
        this.maxConsensusNumber = maxConsensusNumber;
        this.lodThreshold = lodThreshold;
        this.maxTargetSize = maxTargetSize;
        Logging.class.$init$((Logging)this);
    }
}

