/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.rich;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.samtools.TextCigarCodec;
import org.bdgenomics.adam.rich.RichADAMRecord;
import org.bdgenomics.formats.avro.ADAMRecord;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.util.matching.Regex;

public final class RichADAMRecord$ {
    public static final RichADAMRecord$ MODULE$;
    private final TextCigarCodec CIGAR_CODEC;
    private final Regex ILLUMINA_READNAME_REGEX;
    private final Pattern cigarPattern;

    static {
        new RichADAMRecord$();
    }

    public TextCigarCodec CIGAR_CODEC() {
        return this.CIGAR_CODEC;
    }

    public Regex ILLUMINA_READNAME_REGEX() {
        return this.ILLUMINA_READNAME_REGEX;
    }

    public Pattern cigarPattern() {
        return this.cigarPattern;
    }

    public int referenceLengthFromCigar(String cigar) {
        Matcher m = this.cigarPattern().matcher(cigar);
        int i = 0;
        int len = 0;
        while (i < cigar.length()) {
            if (m.find(i)) {
                String op = m.group(2);
                if ("MDNX=".indexOf(op) != -1) {
                    String string = m.group(1);
                    Predef$ predef$ = Predef$.MODULE$;
                    len += new StringOps(string).toInt();
                }
                i = m.end();
                continue;
            }
            return len;
        }
        return len;
    }

    public RichADAMRecord apply(ADAMRecord record) {
        return new RichADAMRecord(record);
    }

    public RichADAMRecord recordToRichRecord(ADAMRecord record) {
        return new RichADAMRecord(record);
    }

    public ADAMRecord richRecordToRecord(RichADAMRecord record) {
        return record.record();
    }

    private RichADAMRecord$() {
        MODULE$ = this;
        this.CIGAR_CODEC = TextCigarCodec.getSingleton();
        Predef$ predef$ = Predef$.MODULE$;
        this.ILLUMINA_READNAME_REGEX = new StringOps("[a-zA-Z0-9]+:[0-9]:([0-9]+):([0-9]+):([0-9]+).*").r();
        this.cigarPattern = Pattern.compile("([0-9]+)([MIDNSHPX=])");
    }
}

