/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.instrumentation;

import com.netflix.servo.monitor.Monitor;
import com.netflix.servo.monitor.MonitorConfig;
import com.netflix.servo.tag.Tags;
import java.util.concurrent.TimeUnit;
import org.bdgenomics.adam.instrumentation.ServoTimer;
import org.bdgenomics.adam.instrumentation.ServoTimer$;
import org.bdgenomics.adam.instrumentation.ServoTimerSuite$;
import org.scalatest.FunSuite;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;

@ScalaSignature(bytes="\u0006\u0001\t3A!\u0001\u0002\u0001\u0017\ty1+\u001a:w_RKW.\u001a:Tk&$XM\u0003\u0002\u0004\t\u0005y\u0011N\\:ueVlWM\u001c;bi&|gN\u0003\u0002\u0006\r\u0005!\u0011\rZ1n\u0015\t9\u0001\"\u0001\u0006cI\u001e,gn\\7jGNT\u0011!C\u0001\u0004_J<7\u0001A\n\u0003\u00011\u0001\"!\u0004\t\u000e\u00039Q!a\u0004\u0005\u0002\u0013M\u001c\u0017\r\\1uKN$\u0018BA\t\u000f\u0005!1UO\\*vSR,\u0007\"B\n\u0001\t\u0003!\u0012A\u0002\u001fj]&$h\bF\u0001\u0016!\t1\u0002!D\u0001\u0003\u0011\u0015A\u0002\u0001\"\u0001\u001a\u0003%1'o\\7OC:|7\u000f\u0006\u0002\u001bAA\u00111DH\u0007\u00029)\tQ$A\u0003tG\u0006d\u0017-\u0003\u0002 9\t!Aj\u001c8h\u0011\u0015\ts\u00031\u0001\u001b\u0003\u00151\u0018\r\\;f\u0011\u0015\u0019\u0003\u0001\"\u0001%\u000399W\r\u001e+bO\u001e,GMV1mk\u0016$2!J\u00173!\t13&D\u0001(\u0015\tA\u0013&\u0001\u0003mC:<'\"\u0001\u0016\u0002\t)\fg/Y\u0005\u0003Y\u001d\u0012aAT;nE\u0016\u0014\b\"\u0002\u0018#\u0001\u0004y\u0013!\u0002;j[\u0016\u0014\bC\u0001\f1\u0013\t\t$A\u0001\u0006TKJ4x\u000eV5nKJDQa\r\u0012A\u0002Q\n1\u0001^1h!\t)T(D\u00017\u0015\t\u0019tG\u0003\u00029s\u0005)1/\u001a:w_*\u0011!hO\u0001\b]\u0016$h\r\\5y\u0015\u0005a\u0014aA2p[&\u0011aH\u000e\u0002\u0004)\u0006<\u0007\"\u0002!\u0001\t\u0003\t\u0015aC2sK\u0006$X\rV5nKJ$\u0012a\f")
public class ServoTimerSuite
extends FunSuite {
    public long fromNanos(long value) {
        return TimeUnit.MILLISECONDS.convert(value, TimeUnit.NANOSECONDS);
    }

    public Number getTaggedValue(ServoTimer timer, com.netflix.servo.tag.Tag tag) {
        Object object = new Object();
        try {
            JavaConversions$.MODULE$.asScalaBuffer(timer.getMonitors()).foreach((Function1)new Serializable(this, tag, object){
                public static final long serialVersionUID = 0L;
                private final com.netflix.servo.tag.Tag tag$1;
                private final Object nonLocalReturnKey1$1;

                public final void apply(Monitor<?> monitor) {
                    String tagValue = monitor.getConfig().getTags().getValue(this.tag$1.getKey());
                    if (tagValue != null && tagValue.equals(this.tag$1.getValue())) {
                        Object object = monitor.getValue();
                        if (object instanceof Number) {
                            Number number = (Number)object;
                            throw new NonLocalReturnControl(this.nonLocalReturnKey1$1, (Object)number);
                        }
                        throw new MatchError(object);
                    }
                }
                {
                    this.tag$1 = tag$1;
                    this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                }
            });
            throw this.fail(new StringBuilder().append((Object)"Could not find monitor with tag [").append((Object)tag).append((Object)"] and numeric value").toString());
        }
        catch (NonLocalReturnControl nonLocalReturnControl) {
            NonLocalReturnControl nonLocalReturnControl2 = nonLocalReturnControl;
            if (nonLocalReturnControl.key() == object) {
                return (Number)nonLocalReturnControl2.value();
            }
            throw nonLocalReturnControl2;
        }
    }

    public ServoTimer createTimer() {
        return new ServoTimer(MonitorConfig.builder((String)"testTimer").build());
    }

    public ServoTimerSuite() {
        this.test("Total time computed correctly", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ServoTimerSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ServoTimer timer = this.$outer.createTimer();
                timer.recordMillis(100L);
                timer.recordMillis(200L);
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)this.$outer.fromNanos(timer.getTotalTime()))).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)300)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)this.$outer.fromNanos(((Number)timer.getValue()).longValue()))).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)300)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)this.$outer.fromNanos(this.$outer.getTaggedValue(timer, ServoTimer$.MODULE$.TotalTimeTag()).longValue()))).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)300)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Count computed correctly", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ServoTimerSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ServoTimer timer = this.$outer.createTimer();
                timer.recordMillis(100L);
                timer.recordMillis(200L);
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)timer.getCount())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)2)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)this.$outer.getTaggedValue(timer, ServoTimer$.MODULE$.CountTag()).longValue())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)2)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Mean computed correctly", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ServoTimerSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ServoTimer timer = this.$outer.createTimer();
                timer.recordMillis(100L);
                timer.recordMillis(200L);
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)this.$outer.fromNanos(timer.getMean()))).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)150)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)this.$outer.fromNanos(this.$outer.getTaggedValue(timer, ServoTimer$.MODULE$.MeanTag()).longValue()))).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)150)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Max computed correctly", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ServoTimerSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ServoTimer timer = this.$outer.createTimer();
                timer.recordMillis(100L);
                timer.recordMillis(201L);
                timer.recordMillis(200L);
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)this.$outer.fromNanos(timer.getMax()))).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)201)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)this.$outer.fromNanos(this.$outer.getTaggedValue(timer, ServoTimer$.MODULE$.MaxTag()).longValue()))).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)201)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Min computed correctly", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ServoTimerSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ServoTimer timer = this.$outer.createTimer();
                timer.recordMillis(100L);
                timer.recordMillis(201L);
                timer.recordMillis(200L);
                timer.recordMillis(99L);
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)this.$outer.fromNanos(timer.getMin()))).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)99)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)this.$outer.fromNanos(this.$outer.getTaggedValue(timer, ServoTimer$.MODULE$.MinTag()).longValue()))).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)99)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Timer and sub-monitors tagged correctly", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            public final /* synthetic */ ServoTimerSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ServoTimer timer = this.$outer.createTimer();
                this.$outer.assert(this.$outer.convertToEqualizer(timer.getConfig().getTags().getValue("myTag")).$eq$eq$eq(null));
                this.$outer.assert(this.$outer.convertToEqualizer(((Monitor)timer.getMonitors().get(0)).getConfig().getTags().getValue("myTag")).$eq$eq$eq(null));
                timer.addTag(Tags.newTag((String)"myTag", (String)"tagValue"));
                this.$outer.assert(this.$outer.convertToEqualizer(timer.getConfig().getTags().getValue("myTag")).$eq$eq$eq((Object)"tagValue"));
                JavaConversions$.MODULE$.asScalaBuffer(timer.getMonitors()).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$6 $outer;

                    public final void apply(Monitor<?> subMonitor) {
                        this.$outer.$outer.assert(this.$outer.$outer.convertToEqualizer(subMonitor.getConfig().getTags().getValue("myTag")).$eq$eq$eq((Object)"tagValue"));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ ServoTimerSuite org$bdgenomics$adam$instrumentation$ServoTimerSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Nanosecond timings recorded correctly", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ServoTimerSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ServoTimer timer = this.$outer.createTimer();
                timer.recordNanos(10000L);
                timer.recordNanos(20000L);
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)timer.getTotalTime())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)30000)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)((Number)timer.getValue()).longValue())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)30000)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)this.$outer.getTaggedValue(timer, ServoTimer$.MODULE$.TotalTimeTag()).longValue())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)30000)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

