/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.models;

import org.bdgenomics.adam.models.ReferencePosition;
import org.bdgenomics.adam.models.ReferencePosition$;
import org.bdgenomics.adam.models.ReferencePositionWithOrientation;
import org.bdgenomics.adam.models.ReferencePositionWithOrientation$;
import org.bdgenomics.adam.models.ReferenceRegionWithOrientation;
import org.bdgenomics.formats.avro.AlignmentRecord;
import org.bdgenomics.formats.avro.Contig;
import org.bdgenomics.formats.avro.Genotype;
import org.bdgenomics.formats.avro.Pileup;
import org.bdgenomics.formats.avro.Variant;
import org.scalatest.FunSuite;
import org.scalatest.Tag;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001]1A!\u0001\u0002\u0001\u0017\t1\"+\u001a4fe\u0016t7-\u001a)pg&$\u0018n\u001c8Tk&$XM\u0003\u0002\u0004\t\u00051Qn\u001c3fYNT!!\u0002\u0004\u0002\t\u0005$\u0017-\u001c\u0006\u0003\u000f!\t!B\u00193hK:|W.[2t\u0015\u0005I\u0011aA8sO\u000e\u00011C\u0001\u0001\r!\ti\u0001#D\u0001\u000f\u0015\ty\u0001\"A\u0005tG\u0006d\u0017\r^3ti&\u0011\u0011C\u0004\u0002\t\rVt7+^5uK\")1\u0003\u0001C\u0001)\u00051A(\u001b8jiz\"\u0012!\u0006\t\u0003-\u0001i\u0011A\u0001")
public class ReferencePositionSuite
extends FunSuite {
    public ReferencePositionSuite() {
        this.test("create reference position from mapped read", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReferencePositionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Contig contig = Contig.newBuilder().setContigName((CharSequence)"chr1").build();
                AlignmentRecord read = AlignmentRecord.newBuilder().setContig(contig).setStart(Predef$.MODULE$.long2Long(1L)).setReadMapped(Predef$.MODULE$.boolean2Boolean(true)).build();
                Option refPosOpt = ReferencePosition$.MODULE$.apply(read);
                this.$outer.assert(refPosOpt.isDefined());
                ReferencePosition refPos = (ReferencePosition)refPosOpt.get();
                this.$outer.assert(this.$outer.convertToEqualizer(refPos.referenceName()).$eq$eq$eq((Object)"chr1"));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)refPos.pos())).$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)1L)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("create reference position from unmapped read", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReferencePositionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                AlignmentRecord read = AlignmentRecord.newBuilder().setReadMapped(Predef$.MODULE$.boolean2Boolean(false)).build();
                Option refPosOpt = ReferencePosition$.MODULE$.apply(read);
                this.$outer.assert(refPosOpt.isEmpty());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("create reference position from mapped read but contig not specified", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReferencePositionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                AlignmentRecord read = AlignmentRecord.newBuilder().setReadMapped(Predef$.MODULE$.boolean2Boolean(true)).setStart(Predef$.MODULE$.long2Long(1L)).build();
                Option refPosOpt = ReferencePosition$.MODULE$.apply(read);
                this.$outer.assert(refPosOpt.isEmpty());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("create reference position from mapped read but contig is underspecified", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReferencePositionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Contig contig = Contig.newBuilder().build();
                AlignmentRecord read = AlignmentRecord.newBuilder().setReadMapped(Predef$.MODULE$.boolean2Boolean(true)).setStart(Predef$.MODULE$.long2Long(1L)).setContig(contig).build();
                Option refPosOpt = ReferencePosition$.MODULE$.apply(read);
                this.$outer.assert(refPosOpt.isEmpty());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("create reference position from mapped read but start not specified", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReferencePositionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Contig contig = Contig.newBuilder().setContigName((CharSequence)"chr1").build();
                AlignmentRecord read = AlignmentRecord.newBuilder().setReadMapped(Predef$.MODULE$.boolean2Boolean(true)).setContig(contig).build();
                Option refPosOpt = ReferencePosition$.MODULE$.apply(read);
                this.$outer.assert(refPosOpt.isEmpty());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("create reference position from pileup", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReferencePositionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Contig contig = Contig.newBuilder().setContigName((CharSequence)"chr2").build();
                Pileup pileup = Pileup.newBuilder().setPosition(Predef$.MODULE$.long2Long(2L)).setContig(contig).build();
                ReferencePosition refPos = ReferencePosition$.MODULE$.apply(pileup);
                this.$outer.assert(this.$outer.convertToEqualizer(refPos.referenceName()).$eq$eq$eq((Object)"chr2"));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)refPos.pos())).$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)2L)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("create reference position from variant", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReferencePositionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Variant variant = Variant.newBuilder().setContig(Contig.newBuilder().setContigName((CharSequence)"chr10").build()).setReferenceAllele((CharSequence)"A").setAlternateAllele((CharSequence)"T").setStart(Predef$.MODULE$.long2Long(10L)).build();
                ReferencePosition refPos = ReferencePosition$.MODULE$.apply(variant);
                this.$outer.assert(this.$outer.convertToEqualizer(refPos.referenceName()).$eq$eq$eq((Object)"chr10"));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)refPos.pos())).$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)10L)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("create reference position from genotype", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReferencePositionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Variant variant = Variant.newBuilder().setStart(Predef$.MODULE$.long2Long(100L)).setContig(Contig.newBuilder().setContigName((CharSequence)"chr10").build()).setReferenceAllele((CharSequence)"A").setAlternateAllele((CharSequence)"T").build();
                Genotype genotype = Genotype.newBuilder().setVariant(variant).setSampleId((CharSequence)"NA12878").build();
                ReferencePosition refPos = ReferencePosition$.MODULE$.apply(genotype);
                this.$outer.assert(this.$outer.convertToEqualizer(refPos.referenceName()).$eq$eq$eq((Object)"chr10"));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)refPos.pos())).$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)100L)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("liftOverToReference works with a multi-block alignment on the forward strand", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReferencePositionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq exons = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReferenceRegionWithOrientation[]{new ReferenceRegionWithOrientation("1", 100L, 201L, false), new ReferenceRegionWithOrientation("1", 300L, 401L, false), new ReferenceRegionWithOrientation("1", 500L, 601L, false)}));
                ReferencePositionWithOrientation p0 = ReferencePositionWithOrientation$.MODULE$.liftOverToReference(0L, exons);
                this.$outer.assert(p0.refPos().isDefined());
                this.$outer.assert(this.$outer.convertToEqualizer(((ReferencePosition)p0.refPos().get()).referenceName()).$eq$eq$eq((Object)"1"));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)((ReferencePosition)p0.refPos().get()).pos())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)100)));
                ReferencePositionWithOrientation p1 = ReferencePositionWithOrientation$.MODULE$.liftOverToReference(50L, exons);
                this.$outer.assert(p1.refPos().isDefined());
                this.$outer.assert(this.$outer.convertToEqualizer(((ReferencePosition)p1.refPos().get()).referenceName()).$eq$eq$eq((Object)"1"));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)((ReferencePosition)p1.refPos().get()).pos())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)150)));
                ReferencePositionWithOrientation p2 = ReferencePositionWithOrientation$.MODULE$.liftOverToReference(150L, exons);
                this.$outer.assert(p2.refPos().isDefined());
                this.$outer.assert(this.$outer.convertToEqualizer(((ReferencePosition)p2.refPos().get()).referenceName()).$eq$eq$eq((Object)"1"));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)((ReferencePosition)p2.refPos().get()).pos())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)350)));
                ReferencePositionWithOrientation p3 = ReferencePositionWithOrientation$.MODULE$.liftOverToReference(250L, exons);
                this.$outer.assert(p3.refPos().isDefined());
                this.$outer.assert(this.$outer.convertToEqualizer(((ReferencePosition)p3.refPos().get()).referenceName()).$eq$eq$eq((Object)"1"));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)((ReferencePosition)p3.refPos().get()).pos())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)550)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("liftOverToReference works with a multi-block alignment on the reverse strand", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReferencePositionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq exons = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReferenceRegionWithOrientation[]{new ReferenceRegionWithOrientation("1", 500L, 601L, true), new ReferenceRegionWithOrientation("1", 300L, 401L, true), new ReferenceRegionWithOrientation("1", 100L, 201L, true)}));
                ReferencePositionWithOrientation p1 = ReferencePositionWithOrientation$.MODULE$.liftOverToReference(50L, exons);
                this.$outer.assert(p1.refPos().isDefined());
                this.$outer.assert(this.$outer.convertToEqualizer(((ReferencePosition)p1.refPos().get()).referenceName()).$eq$eq$eq((Object)"1"));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)((ReferencePosition)p1.refPos().get()).pos())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)550)));
                ReferencePositionWithOrientation p2 = ReferencePositionWithOrientation$.MODULE$.liftOverToReference(150L, exons);
                this.$outer.assert(p2.refPos().isDefined());
                this.$outer.assert(this.$outer.convertToEqualizer(((ReferencePosition)p2.refPos().get()).referenceName()).$eq$eq$eq((Object)"1"));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)((ReferencePosition)p2.refPos().get()).pos())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)350)));
                ReferencePositionWithOrientation p3 = ReferencePositionWithOrientation$.MODULE$.liftOverToReference(250L, exons);
                this.$outer.assert(p3.refPos().isDefined());
                this.$outer.assert(this.$outer.convertToEqualizer(((ReferencePosition)p3.refPos().get()).referenceName()).$eq$eq$eq((Object)"1"));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)((ReferencePosition)p3.refPos().get()).pos())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)150)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("lift over between two transcripts on the forward strand", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReferencePositionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq t1 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReferenceRegionWithOrientation[]{new ReferenceRegionWithOrientation("chr0", 0L, 201L, false)}));
                Seq t2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReferenceRegionWithOrientation[]{new ReferenceRegionWithOrientation("chr0", 50L, 101L, false), new ReferenceRegionWithOrientation("chr0", 175L, 201L, false)}));
                ReferencePositionWithOrientation pos = ReferencePositionWithOrientation$.MODULE$.liftOverToReference(60L, t1);
                this.$outer.assert(pos.refPos().isDefined());
                this.$outer.assert(this.$outer.convertToEqualizer(((ReferencePosition)pos.refPos().get()).referenceName()).$eq$eq$eq((Object)"chr0"));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)((ReferencePosition)pos.refPos().get()).pos())).$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)60L)));
                this.$outer.assert(!pos.negativeStrand());
                long idx = pos.liftOverFromReference(t2);
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)idx)).$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)10L)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("lift over between two transcripts on the reverse strand", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReferencePositionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq t1 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReferenceRegionWithOrientation[]{new ReferenceRegionWithOrientation("chr0", 0L, 201L, true)}));
                Seq t2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReferenceRegionWithOrientation[]{new ReferenceRegionWithOrientation("chr0", 175L, 201L, true), new ReferenceRegionWithOrientation("chr0", 50L, 101L, true)}));
                long idx = new ReferencePositionWithOrientation((Option)new Some((Object)new ReferencePosition("chr0", 190L)), true).liftOverFromReference(t2);
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)idx)).$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)11L)));
                ReferencePositionWithOrientation pos = ReferencePositionWithOrientation$.MODULE$.liftOverToReference(idx, t1);
                this.$outer.assert(pos.refPos().isDefined());
                this.$outer.assert(this.$outer.convertToEqualizer(((ReferencePosition)pos.refPos().get()).referenceName()).$eq$eq$eq((Object)"chr0"));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)((ReferencePosition)pos.refPos().get()).pos())).$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)189L)));
                this.$outer.assert(pos.negativeStrand());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

