/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.models;

import org.bdgenomics.adam.models.ReferencePosition;
import org.bdgenomics.adam.models.ReferencePositionWithOrientation;
import org.bdgenomics.adam.models.ReferenceRegion;
import org.bdgenomics.adam.models.ReferenceRegion$;
import org.bdgenomics.adam.models.ReferenceRegionSuite$;
import org.bdgenomics.adam.models.ReferenceRegionWithOrientation;
import org.bdgenomics.adam.models.ReferenceRegionWithOrientation$;
import org.bdgenomics.formats.avro.AlignmentRecord;
import org.bdgenomics.formats.avro.Contig;
import org.scalatest.FunSuite;
import org.scalatest.Tag;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001e2A!\u0001\u0002\u0001\u0017\t!\"+\u001a4fe\u0016t7-\u001a*fO&|gnU;ji\u0016T!a\u0001\u0003\u0002\r5|G-\u001a7t\u0015\t)a!\u0001\u0003bI\u0006l'BA\u0004\t\u0003)\u0011GmZ3o_6L7m\u001d\u0006\u0002\u0013\u0005\u0019qN]4\u0004\u0001M\u0011\u0001\u0001\u0004\t\u0003\u001bAi\u0011A\u0004\u0006\u0003\u001f!\t\u0011b]2bY\u0006$Xm\u001d;\n\u0005Eq!\u0001\u0003$v]N+\u0018\u000e^3\t\u000bM\u0001A\u0011\u0001\u000b\u0002\rqJg.\u001b;?)\u0005)\u0002C\u0001\f\u0001\u001b\u0005\u0011\u0001\"\u0002\r\u0001\t\u0003I\u0012A\u0002:fO&|g\u000e\u0006\u0003\u001b;%r\u0003C\u0001\f\u001c\u0013\ta\"AA\bSK\u001a,'/\u001a8dKJ+w-[8o\u0011\u0015qr\u00031\u0001 \u0003\u001d\u0011XM\u001a(b[\u0016\u0004\"\u0001\t\u0014\u000f\u0005\u0005\"S\"\u0001\u0012\u000b\u0003\r\nQa]2bY\u0006L!!\n\u0012\u0002\rA\u0013X\rZ3g\u0013\t9\u0003F\u0001\u0004TiJLgn\u001a\u0006\u0003K\tBQAK\fA\u0002-\nQa\u001d;beR\u0004\"!\t\u0017\n\u00055\u0012#\u0001\u0002'p]\u001eDQaL\fA\u0002-\n1!\u001a8e\u0011\u0015\t\u0004\u0001\"\u00013\u0003\u0015\u0001x.\u001b8u)\r\u0019dg\u000e\t\u0003-QJ!!\u000e\u0002\u0003#I+g-\u001a:f]\u000e,\u0007k\\:ji&|g\u000eC\u0003\u001fa\u0001\u0007q\u0004C\u00039a\u0001\u00071&A\u0002q_N\u0004")
public class ReferenceRegionSuite
extends FunSuite {
    public ReferenceRegion region(String refName, long start, long end) {
        return new ReferenceRegion(refName, start, end);
    }

    public ReferencePosition point(String refName, long pos) {
        return new ReferencePosition(refName, pos);
    }

    public ReferenceRegionSuite() {
        this.test("contains(: ReferenceRegion)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReferenceRegionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assert(this.$outer.region("chr0", 10L, 100L).contains(this.$outer.region("chr0", 50L, 70L)));
                this.$outer.assert(this.$outer.region("chr0", 10L, 100L).contains(this.$outer.region("chr0", 10L, 100L)));
                this.$outer.assert(!this.$outer.region("chr0", 10L, 100L).contains(this.$outer.region("chr1", 50L, 70L)));
                this.$outer.assert(this.$outer.region("chr0", 10L, 100L).contains(this.$outer.region("chr0", 50L, 100L)));
                this.$outer.assert(!this.$outer.region("chr0", 10L, 100L).contains(this.$outer.region("chr0", 50L, 101L)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("contains(: ReferencePosition)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReferenceRegionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assert(this.$outer.region("chr0", 10L, 100L).contains(this.$outer.point("chr0", 50L)));
                this.$outer.assert(this.$outer.region("chr0", 10L, 100L).contains(this.$outer.point("chr0", 10L)));
                this.$outer.assert(this.$outer.region("chr0", 10L, 100L).contains(this.$outer.point("chr0", 99L)));
                this.$outer.assert(!this.$outer.region("chr0", 10L, 100L).contains(this.$outer.point("chr0", 100L)));
                this.$outer.assert(!this.$outer.region("chr0", 10L, 100L).contains(this.$outer.point("chr1", 50L)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("merge", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            public final /* synthetic */ ReferenceRegionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.intercept((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$3 $outer;

                    public final ReferenceRegion apply() {
                        return this.$outer.$outer.region("chr0", 10L, 100L).merge(this.$outer.$outer.region("chr1", 10L, 100L));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, ManifestFactory$.MODULE$.classType(AssertionError.class));
                ReferenceRegion r1 = this.$outer.region("chr0", 10L, 100L);
                ReferenceRegion r2 = this.$outer.region("chr0", 0L, 15L);
                ReferenceRegion r3 = this.$outer.region("chr0", 50L, 150L);
                ReferenceRegion r12 = this.$outer.region("chr0", 0L, 100L);
                ReferenceRegion r13 = this.$outer.region("chr0", 10L, 150L);
                this.$outer.assert(this.$outer.convertToEqualizer(r1.merge(r1)).$eq$eq$eq((Object)r1));
                this.$outer.assert(this.$outer.convertToEqualizer(r1.merge(r2)).$eq$eq$eq((Object)r12));
                this.$outer.assert(this.$outer.convertToEqualizer(r1.merge(r3)).$eq$eq$eq((Object)r13));
            }

            public /* synthetic */ ReferenceRegionSuite org$bdgenomics$adam$models$ReferenceRegionSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("overlaps", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReferenceRegionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assert(this.$outer.region("chr0", 10L, 100L).overlaps(this.$outer.region("chr0", 20L, 50L)));
                this.$outer.assert(this.$outer.region("chr0", 10L, 100L).overlaps(this.$outer.region("chr0", 50L, 250L)));
                this.$outer.assert(this.$outer.region("chr0", 10L, 100L).overlaps(this.$outer.region("chr0", 5L, 15L)));
                this.$outer.assert(this.$outer.region("chr0", 10L, 100L).overlaps(this.$outer.region("chr0", 5L, 11L)));
                this.$outer.assert(!this.$outer.region("chr0", 10L, 100L).overlaps(this.$outer.region("chr0", 5L, 10L)));
                this.$outer.assert(this.$outer.region("chr0", 10L, 100L).overlaps(this.$outer.region("chr0", 99L, 200L)));
                this.$outer.assert(!this.$outer.region("chr0", 10L, 100L).overlaps(this.$outer.region("chr0", 100L, 200L)));
                this.$outer.assert(!this.$outer.region("chr0", 10L, 100L).overlaps(this.$outer.region("chr1", 50L, 200L)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("distance(: ReferenceRegion)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReferenceRegionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assert(this.$outer.convertToEqualizer(this.$outer.region("chr0", 10L, 100L).distance(this.$outer.region("chr0", 200L, 300L))).$eq$eq$eq((Object)new Some((Object)BoxesRunTime.boxToInteger((int)101))));
                this.$outer.assert(this.$outer.convertToEqualizer(this.$outer.region("chr0", 100L, 200L).distance(this.$outer.region("chr0", 10L, 50L))).$eq$eq$eq((Object)new Some((Object)BoxesRunTime.boxToInteger((int)51))));
                this.$outer.assert(this.$outer.convertToEqualizer(this.$outer.region("chr0", 100L, 200L).distance(this.$outer.region("chr1", 10L, 50L))).$eq$eq$eq((Object)None$.MODULE$));
                this.$outer.assert(this.$outer.convertToEqualizer(this.$outer.region("chr0", 10L, 100L).distance(this.$outer.region("chr0", 100L, 200L))).$eq$eq$eq((Object)new Some((Object)BoxesRunTime.boxToInteger((int)1))));
                this.$outer.assert(this.$outer.convertToEqualizer(this.$outer.region("chr0", 10L, 100L).distance(this.$outer.region("chr0", 50L, 150L))).$eq$eq$eq((Object)new Some((Object)BoxesRunTime.boxToInteger((int)0))));
                this.$outer.assert(this.$outer.convertToEqualizer(this.$outer.region("chr0", 10L, 100L).distance(this.$outer.region("chr0", 0L, 10L))).$eq$eq$eq((Object)new Some((Object)BoxesRunTime.boxToInteger((int)1))));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("distance(: ReferencePosition)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReferenceRegionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assert(this.$outer.convertToEqualizer(this.$outer.region("chr0", 10L, 100L).distance(this.$outer.point("chr0", 50L))).$eq$eq$eq((Object)new Some((Object)BoxesRunTime.boxToInteger((int)0))));
                this.$outer.assert(this.$outer.convertToEqualizer(this.$outer.region("chr0", 10L, 100L).distance(this.$outer.point("chr0", 10L))).$eq$eq$eq((Object)new Some((Object)BoxesRunTime.boxToInteger((int)0))));
                this.$outer.assert(this.$outer.convertToEqualizer(this.$outer.region("chr0", 10L, 100L).distance(this.$outer.point("chr0", 100L))).$eq$eq$eq((Object)new Some((Object)BoxesRunTime.boxToInteger((int)1))));
                this.$outer.assert(this.$outer.convertToEqualizer(this.$outer.region("chr0", 10L, 100L).distance(this.$outer.point("chr0", 150L))).$eq$eq$eq((Object)new Some((Object)BoxesRunTime.boxToInteger((int)51))));
                this.$outer.assert(this.$outer.convertToEqualizer(this.$outer.region("chr0", 100L, 200L).distance(this.$outer.point("chr0", 50L))).$eq$eq$eq((Object)new Some((Object)BoxesRunTime.boxToInteger((int)50))));
                this.$outer.assert(this.$outer.convertToEqualizer(this.$outer.region("chr0", 100L, 200L).distance(this.$outer.point("chr1", 50L))).$eq$eq$eq((Object)None$.MODULE$));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("create region from unmapped read fails", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReferenceRegionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                AlignmentRecord read = AlignmentRecord.newBuilder().setReadMapped(Predef$.MODULE$.boolean2Boolean(false)).build();
                this.$outer.assert(ReferenceRegion$.MODULE$.apply(read).isEmpty());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("create region from mapped read contains read start and end", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReferenceRegionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                AlignmentRecord read = AlignmentRecord.newBuilder().setReadMapped(Predef$.MODULE$.boolean2Boolean(true)).setSequence((CharSequence)"AAAAA").setStart(Predef$.MODULE$.long2Long(1L)).setCigar((CharSequence)"5M").setEnd(Predef$.MODULE$.long2Long(6L)).setContig(Contig.newBuilder().setContigName((CharSequence)"chr1").setContigLength(Predef$.MODULE$.long2Long(10L)).build()).build();
                this.$outer.assert(ReferenceRegion$.MODULE$.apply(read).isDefined());
                this.$outer.assert(((ReferenceRegion)ReferenceRegion$.MODULE$.apply(read).get()).contains(this.$outer.point("chr1", 1L)));
                this.$outer.assert(((ReferenceRegion)ReferenceRegion$.MODULE$.apply(read).get()).contains(this.$outer.point("chr1", 5L)));
                this.$outer.assert(!((ReferenceRegion)ReferenceRegion$.MODULE$.apply(read).get()).contains(this.$outer.point("chr1", 6L)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("validate that adjacent regions can be merged", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReferenceRegionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ReferenceRegion r1 = this.$outer.region("chr1", 0L, 6L);
                ReferenceRegion r2 = this.$outer.region("chr1", 6L, 10L);
                this.$outer.assert(this.$outer.convertToEqualizer(r1.distance(r2).get()).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1)));
                this.$outer.assert(r1.isAdjacent(r2));
                ReferenceRegion referenceRegion = r1.merge(r2);
                ReferenceRegion referenceRegion2 = this.$outer.region("chr1", 0L, 10L);
                this.$outer.assert(!(referenceRegion != null ? !referenceRegion.equals(referenceRegion2) : referenceRegion2 != null));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("validate that non-adjacent regions cannot be merged", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReferenceRegionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ReferenceRegion r2;
                ReferenceRegion r1 = this.$outer.region("chr1", 0L, 5L);
                this.$outer.assert(!r1.isAdjacent(r2 = this.$outer.region("chr1", 7L, 10L)));
                this.$outer.intercept((Function0)new Serializable(this, r1, r2){
                    public static final long serialVersionUID = 0L;
                    private final ReferenceRegion r1$1;
                    private final ReferenceRegion r2$1;

                    public final ReferenceRegion apply() {
                        return this.r1$1.merge(this.r2$1);
                    }
                    {
                        this.r1$1 = r1$1;
                        this.r2$1 = r2$1;
                    }
                }, ManifestFactory$.MODULE$.classType(AssertionError.class));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("compute convex hull of two sets", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReferenceRegionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ReferenceRegion r2;
                ReferenceRegion r1 = this.$outer.region("chr1", 0L, 5L);
                this.$outer.assert(!r1.isAdjacent(r2 = this.$outer.region("chr1", 7L, 10L)));
                ReferenceRegion hull1 = r1.hull(r2);
                ReferenceRegion hull2 = r2.hull(r1);
                this.$outer.assert(this.$outer.convertToEqualizer(hull1).$eq$eq$eq((Object)hull2));
                this.$outer.assert(hull1.overlaps(r1));
                this.$outer.assert(hull1.overlaps(r2));
                this.$outer.assert(hull1.start() == 0L);
                this.$outer.assert(hull1.end() == 10L);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("region name is sanitized when creating region from read", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReferenceRegionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Contig contig = Contig.newBuilder().setContigName((CharSequence)"chrM").build();
                AlignmentRecord read = AlignmentRecord.newBuilder().setStart(Predef$.MODULE$.long2Long(5L)).setSequence((CharSequence)"ACGT").setContig(contig).setReadMapped(Predef$.MODULE$.boolean2Boolean(true)).setCigar((CharSequence)"5M").setEnd(Predef$.MODULE$.long2Long(10L)).setMismatchingPositions((CharSequence)"5").build();
                Option region = ReferenceRegion$.MODULE$.apply(read);
                this.$outer.assert(region.isDefined());
                ReferenceRegion r = (ReferenceRegion)region.get();
                this.$outer.assert(this.$outer.convertToEqualizer(r.referenceName()).$eq$eq$eq((Object)"chrM"));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)r.start())).$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)5L)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)r.end())).$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)10L)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("intersection fails on non-overlapping regions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReferenceRegionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.intercept((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final ReferenceRegion apply() {
                        return new ReferenceRegion("chr1", 1L, 10L).intersection(new ReferenceRegion("chr1", 11L, 20L));
                    }
                }, ManifestFactory$.MODULE$.classType(AssertionError.class));
                this.$outer.intercept((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final ReferenceRegion apply() {
                        return new ReferenceRegion("chr1", 1L, 10L).intersection(new ReferenceRegion("chr2", 1L, 10L));
                    }
                }, ManifestFactory$.MODULE$.classType(AssertionError.class));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("compute intersection", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReferenceRegionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ReferenceRegion overlapRegion = new ReferenceRegion("chr1", 1L, 10L).intersection(new ReferenceRegion("chr1", 5L, 15L));
                this.$outer.assert(this.$outer.convertToEqualizer(overlapRegion.referenceName()).$eq$eq$eq((Object)"chr1"));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)overlapRegion.start())).$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)5L)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)overlapRegion.end())).$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)10L)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("build oriented reference region from non-oriented", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReferenceRegionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ReferenceRegionWithOrientation rrf = ReferenceRegionWithOrientation$.MODULE$.apply(new ReferenceRegion("chr1", 10L, 20L), false);
                this.$outer.assert(this.$outer.convertToEqualizer(rrf.referenceName()).$eq$eq$eq((Object)"chr1"));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)rrf.start())).$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)10L)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)rrf.end())).$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)20L)));
                this.$outer.assert(!rrf.negativeStrand());
                ReferenceRegionWithOrientation rrr = ReferenceRegionWithOrientation$.MODULE$.apply(new ReferenceRegion("chr1", 10L, 20L), true);
                this.$outer.assert(this.$outer.convertToEqualizer(rrr.referenceName()).$eq$eq$eq((Object)"chr1"));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)rrr.start())).$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)10L)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)rrr.end())).$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)20L)));
                this.$outer.assert(rrr.negativeStrand());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("comparison tests for oriented reference region", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReferenceRegionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assert(new ReferenceRegionWithOrientation("chr1", 10L, 20L, false).contains(new ReferenceRegionWithOrientation("chr1", 10L, 20L, false)));
                this.$outer.assert(new ReferenceRegionWithOrientation("chr1", 10L, 20L, true).contains(new ReferenceRegionWithOrientation("chr1", 15L, 17L, true)));
                ReferenceRegionWithOrientation rrf = ReferenceRegionWithOrientation$.MODULE$.apply(new ReferenceRegion("chr1", 10L, 20L), false);
                ReferenceRegionWithOrientation rrr = ReferenceRegionWithOrientation$.MODULE$.apply(new ReferenceRegion("chr1", 10L, 20L), true);
                this.$outer.assert(!rrf.contains(rrr));
                this.$outer.assert(!new ReferenceRegionWithOrientation("chr1", 10L, 20L, false).contains(new ReferenceRegionWithOrientation("chr2", 10L, 20L, false)));
                this.$outer.assert(!new ReferenceRegionWithOrientation("chr1", 20L, 50L, true).contains(new ReferenceRegionWithOrientation("chr1", 50L, 100L, true)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("comparison tests for oriented reference region vs position", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReferenceRegionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assert(new ReferenceRegionWithOrientation("chr1", 10L, 20L, false).contains(new ReferencePositionWithOrientation((Option)new Some((Object)new ReferencePosition("chr1", 10L)), false)));
                this.$outer.assert(new ReferenceRegionWithOrientation("chr1", 10L, 20L, true).contains(new ReferencePositionWithOrientation((Option)new Some((Object)new ReferencePosition("chr1", 17L)), true)));
                this.$outer.assert(!ReferenceRegionWithOrientation$.MODULE$.apply(new ReferenceRegion("chr1", 10L, 20L), false).contains(new ReferencePositionWithOrientation((Option)new Some((Object)new ReferencePosition("chr1", 17L)), true)));
                this.$outer.assert(!ReferenceRegionWithOrientation$.MODULE$.apply(new ReferenceRegion("chr1", 10L, 20L), true).contains(new ReferencePositionWithOrientation((Option)new Some((Object)new ReferencePosition("chr1", 10L)), false)));
                this.$outer.assert(!ReferenceRegionWithOrientation$.MODULE$.apply(new ReferenceRegion("chr1", 10L, 20L), false).contains(new ReferencePositionWithOrientation((Option)None$.MODULE$, true)));
                this.$outer.assert(!ReferenceRegionWithOrientation$.MODULE$.apply(new ReferenceRegion("chr1", 10L, 20L), true).contains(new ReferencePositionWithOrientation((Option)None$.MODULE$, false)));
                this.$outer.assert(!new ReferenceRegionWithOrientation("chr1", 10L, 20L, false).contains(new ReferencePositionWithOrientation((Option)new Some((Object)new ReferencePosition("chr2", 10L)), false)));
                this.$outer.assert(!new ReferenceRegionWithOrientation("chr1", 20L, 50L, true).contains(new ReferencePositionWithOrientation((Option)new Some((Object)new ReferencePosition("chr1", 100L)), true)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("overlap tests for oriented reference region", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReferenceRegionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assert(new ReferenceRegionWithOrientation("chr1", 10L, 20L, false).overlaps(new ReferenceRegionWithOrientation("chr1", 15L, 25L, false)));
                this.$outer.assert(new ReferenceRegionWithOrientation("chr1", 10L, 20L, true).overlaps(new ReferenceRegionWithOrientation("chr1", 5L, 15L, true)));
                ReferenceRegionWithOrientation rrf = ReferenceRegionWithOrientation$.MODULE$.apply(new ReferenceRegion("chr1", 12L, 22L), false);
                ReferenceRegionWithOrientation rrr = ReferenceRegionWithOrientation$.MODULE$.apply(new ReferenceRegion("chr1", 8L, 8L), true);
                this.$outer.assert(!rrf.overlaps(rrr));
                this.$outer.assert(!new ReferenceRegionWithOrientation("chr1", 10L, 20L, false).overlaps(new ReferenceRegionWithOrientation("chr2", 10L, 20L, false)));
                this.$outer.assert(!new ReferenceRegionWithOrientation("chr1", 20L, 50L, true).overlaps(new ReferenceRegionWithOrientation("chr1", 51L, 100L, true)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("check the width of a reference region", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReferenceRegionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)new ReferenceRegion("chr1", 100L, 201L).width())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)100)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)new ReferenceRegionWithOrientation("chr2", 200L, 401L, false).width())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)200)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)new ReferenceRegionWithOrientation("chr3", 399L, 1000L, true).width())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)600)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

