/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.rdd;

import org.bdgenomics.adam.rdd.PileupAggregator;
import org.bdgenomics.adam.rdd.PileupAggregator$;
import org.bdgenomics.formats.avro.Base;
import org.bdgenomics.formats.avro.Contig;
import org.bdgenomics.formats.avro.Pileup;
import org.scalatest.FunSuite;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001]1A!\u0001\u0002\u0001\u0017\t1\u0002+\u001b7fkB\fum\u001a:fO\u0006$\u0018n\u001c8Tk&$XM\u0003\u0002\u0004\t\u0005\u0019!\u000f\u001a3\u000b\u0005\u00151\u0011\u0001B1eC6T!a\u0002\u0005\u0002\u0015\t$w-\u001a8p[&\u001c7OC\u0001\n\u0003\ry'oZ\u0002\u0001'\t\u0001A\u0002\u0005\u0002\u000e!5\taB\u0003\u0002\u0010\u0011\u0005I1oY1mCR,7\u000f^\u0005\u0003#9\u0011\u0001BR;o'VLG/\u001a\u0005\u0006'\u0001!\t\u0001F\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003U\u0001\"A\u0006\u0001\u000e\u0003\t\u0001")
public class PileupAggregationSuite
extends FunSuite {
    public PileupAggregationSuite() {
        this.test("aggregating a pileup with two different bases does not change values", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PileupAggregationSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Pileup p0 = Pileup.newBuilder().setPosition(Predef$.MODULE$.long2Long(1L)).setReadBase(Base.A).setMapQuality(Predef$.MODULE$.int2Integer(10)).setSangerQuality(Predef$.MODULE$.int2Integer(30)).setCountAtPosition(Predef$.MODULE$.int2Integer(1)).setNumSoftClipped(Predef$.MODULE$.int2Integer(0)).setNumReverseStrand(Predef$.MODULE$.int2Integer(0)).build();
                Pileup p1 = Pileup.newBuilder().setPosition(Predef$.MODULE$.long2Long(1L)).setReadBase(Base.C).setMapQuality(Predef$.MODULE$.int2Integer(20)).setSangerQuality(Predef$.MODULE$.int2Integer(40)).setCountAtPosition(Predef$.MODULE$.int2Integer(1)).setNumSoftClipped(Predef$.MODULE$.int2Integer(1)).setNumReverseStrand(Predef$.MODULE$.int2Integer(1)).build();
                List pileups = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pileup[]{p0, p1}));
                PileupAggregator aggregator = new PileupAggregator(PileupAggregator$.MODULE$.$lessinit$greater$default$1());
                List aggregated = aggregator.flatten((Iterable)pileups);
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)aggregated.length())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)2)));
                this.$outer.assert(this.$outer.convertToEqualizer(((IterableLike)aggregated.filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Pileup x$1) {
                        Base base = x$1.getReadBase();
                        return !(base != null ? !base.equals(Base.C) : Base.C != null);
                    }
                })).head()).$eq$eq$eq(((IterableLike)pileups.filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Pileup x$2) {
                        Base base = x$2.getReadBase();
                        return !(base != null ? !base.equals(Base.C) : Base.C != null);
                    }
                })).head()));
                this.$outer.assert(this.$outer.convertToEqualizer(((IterableLike)aggregated.filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Pileup x$3) {
                        Base base = x$3.getReadBase();
                        return !(base != null ? !base.equals(Base.A) : Base.A != null);
                    }
                })).head()).$eq$eq$eq(((IterableLike)pileups.filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Pileup x$4) {
                        Base base = x$4.getReadBase();
                        return !(base != null ? !base.equals(Base.A) : Base.A != null);
                    }
                })).head()));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("aggregating a pileup with a single base type", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PileupAggregationSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Contig c0 = Contig.newBuilder().setContigName((CharSequence)"chr1").setContigLength(Predef$.MODULE$.long2Long(1000L)).build();
                Pileup p0 = Pileup.newBuilder().setContig(c0).setPosition(Predef$.MODULE$.long2Long(1L)).setReadBase(Base.A).setMapQuality(Predef$.MODULE$.int2Integer(9)).setSangerQuality(Predef$.MODULE$.int2Integer(31)).setCountAtPosition(Predef$.MODULE$.int2Integer(1)).setNumSoftClipped(Predef$.MODULE$.int2Integer(0)).setNumReverseStrand(Predef$.MODULE$.int2Integer(0)).setReadName((CharSequence)"read0").setReadStart(Predef$.MODULE$.long2Long(0L)).setReadEnd(Predef$.MODULE$.long2Long(1L)).build();
                Pileup p1 = Pileup.newBuilder().setContig(c0).setPosition(Predef$.MODULE$.long2Long(1L)).setReadBase(Base.A).setMapQuality(Predef$.MODULE$.int2Integer(11)).setSangerQuality(Predef$.MODULE$.int2Integer(29)).setCountAtPosition(Predef$.MODULE$.int2Integer(1)).setNumSoftClipped(Predef$.MODULE$.int2Integer(1)).setNumReverseStrand(Predef$.MODULE$.int2Integer(1)).setReadName((CharSequence)"read1").setReadStart(Predef$.MODULE$.long2Long(1L)).setReadEnd(Predef$.MODULE$.long2Long(2L)).build();
                List pileups = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pileup[]{p0, p1}));
                PileupAggregator aggregator = new PileupAggregator(PileupAggregator$.MODULE$.$lessinit$greater$default$1());
                List aggregated = aggregator.flatten((Iterable)pileups);
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)aggregated.length())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1)));
                this.$outer.assert(this.$outer.convertToEqualizer(((Pileup)aggregated.head()).getPosition()).$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)1L)));
                this.$outer.assert(this.$outer.convertToEqualizer(((Pileup)aggregated.head()).getReadBase()).$eq$eq$eq((Object)Base.A));
                this.$outer.assert(this.$outer.convertToEqualizer(((Pileup)aggregated.head()).getSangerQuality()).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)30)));
                this.$outer.assert(this.$outer.convertToEqualizer(((Pileup)aggregated.head()).getMapQuality()).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)10)));
                this.$outer.assert(this.$outer.convertToEqualizer(((Pileup)aggregated.head()).getCountAtPosition()).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)2)));
                this.$outer.assert(this.$outer.convertToEqualizer(((Pileup)aggregated.head()).getNumSoftClipped()).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1)));
                this.$outer.assert(this.$outer.convertToEqualizer(((Pileup)aggregated.head()).getNumReverseStrand()).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1)));
                this.$outer.assert(this.$outer.convertToEqualizer(((Pileup)aggregated.head()).getReadName()).$eq$eq$eq((Object)"read0,read1"));
                this.$outer.assert(this.$outer.convertToEqualizer(((Pileup)aggregated.head()).getReadStart()).$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)0L)));
                this.$outer.assert(this.$outer.convertToEqualizer(((Pileup)aggregated.head()).getReadEnd()).$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)2L)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("aggregating a pileup with a single base type, multiple bases at a position", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PileupAggregationSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Contig contig = Contig.newBuilder().setContigName((CharSequence)"chr0").build();
                Pileup p0 = Pileup.newBuilder().setContig(contig).setPosition(Predef$.MODULE$.long2Long(1L)).setReadBase(Base.A).setMapQuality(Predef$.MODULE$.int2Integer(8)).setSangerQuality(Predef$.MODULE$.int2Integer(32)).setCountAtPosition(Predef$.MODULE$.int2Integer(1)).setNumSoftClipped(Predef$.MODULE$.int2Integer(0)).setNumReverseStrand(Predef$.MODULE$.int2Integer(0)).setReadName((CharSequence)"read0").setReadStart(Predef$.MODULE$.long2Long(0L)).setReadEnd(Predef$.MODULE$.long2Long(1L)).build();
                Pileup p1 = Pileup.newBuilder().setContig(contig).setPosition(Predef$.MODULE$.long2Long(1L)).setReadBase(Base.A).setMapQuality(Predef$.MODULE$.int2Integer(11)).setSangerQuality(Predef$.MODULE$.int2Integer(29)).setCountAtPosition(Predef$.MODULE$.int2Integer(2)).setNumSoftClipped(Predef$.MODULE$.int2Integer(2)).setNumReverseStrand(Predef$.MODULE$.int2Integer(2)).setReadName((CharSequence)"read1").setReadStart(Predef$.MODULE$.long2Long(1L)).setReadEnd(Predef$.MODULE$.long2Long(2L)).build();
                List pileups = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pileup[]{p0, p1}));
                PileupAggregator aggregator = new PileupAggregator(PileupAggregator$.MODULE$.$lessinit$greater$default$1());
                List aggregated = aggregator.flatten((Iterable)pileups);
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)aggregated.length())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1)));
                this.$outer.assert(this.$outer.convertToEqualizer(((Pileup)aggregated.head()).getPosition()).$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)1L)));
                this.$outer.assert(this.$outer.convertToEqualizer(((Pileup)aggregated.head()).getReadBase()).$eq$eq$eq((Object)Base.A));
                this.$outer.assert(this.$outer.convertToEqualizer(((Pileup)aggregated.head()).getSangerQuality()).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)30)));
                this.$outer.assert(this.$outer.convertToEqualizer(((Pileup)aggregated.head()).getMapQuality()).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)10)));
                this.$outer.assert(this.$outer.convertToEqualizer(((Pileup)aggregated.head()).getCountAtPosition()).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)3)));
                this.$outer.assert(this.$outer.convertToEqualizer(((Pileup)aggregated.head()).getNumSoftClipped()).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)2)));
                this.$outer.assert(this.$outer.convertToEqualizer(((Pileup)aggregated.head()).getNumReverseStrand()).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)2)));
                this.$outer.assert(this.$outer.convertToEqualizer(((Pileup)aggregated.head()).getReadName()).$eq$eq$eq((Object)"read0,read1"));
                this.$outer.assert(this.$outer.convertToEqualizer(((Pileup)aggregated.head()).getReadStart()).$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)0L)));
                this.$outer.assert(this.$outer.convertToEqualizer(((Pileup)aggregated.head()).getReadEnd()).$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)2L)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

