/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.rdd.correction;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.log4j.Level;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.bdgenomics.adam.rdd.ADAMContext;
import org.bdgenomics.adam.rdd.ADAMContext$;
import org.bdgenomics.adam.rdd.correction.TrimReads;
import org.bdgenomics.adam.rdd.correction.TrimReads$;
import org.bdgenomics.adam.rdd.correction.TrimReadsSuite$;
import org.bdgenomics.adam.util.SparkFunSuite;
import org.bdgenomics.adam.util.SparkFunSuite$class;
import org.bdgenomics.formats.avro.AlignmentRecord;
import org.scalatest.BeforeAndAfter;
import org.scalatest.Distributor;
import org.scalatest.Filter;
import org.scalatest.FunSuite;
import org.scalatest.FunSuiteLike;
import org.scalatest.Reporter;
import org.scalatest.Stopper;
import org.scalatest.Tag;
import org.scalatest.Tracker;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00013A!\u0001\u0002\u0001\u001b\tqAK]5n%\u0016\fGm]*vSR,'BA\u0002\u0005\u0003)\u0019wN\u001d:fGRLwN\u001c\u0006\u0003\u000b\u0019\t1A\u001d3e\u0015\t9\u0001\"\u0001\u0003bI\u0006l'BA\u0005\u000b\u0003)\u0011GmZ3o_6L7m\u001d\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M\u0019\u0001A\u0004\u000b\u0011\u0005=\u0011R\"\u0001\t\u000b\u0005EQ\u0011!C:dC2\fG/Z:u\u0013\t\u0019\u0002C\u0001\u0005Gk:\u001cV/\u001b;f!\t)\u0002$D\u0001\u0017\u0015\t9b!\u0001\u0003vi&d\u0017BA\r\u0017\u00055\u0019\u0006/\u0019:l\rVt7+^5uK\")1\u0004\u0001C\u00019\u00051A(\u001b8jiz\"\u0012!\b\t\u0003=\u0001i\u0011A\u0001\u0005\bA\u0001\u0011\r\u0011\"\u0001\"\u0003\t)7-F\u0001#!\tq2%\u0003\u0002%\u0005\tIAK]5n%\u0016\fGm\u001d\u0005\u0007M\u0001\u0001\u000b\u0011\u0002\u0012\u0002\u0007\u0015\u001c\u0007\u0005C\u0003)\u0001\u0011\u0005\u0011&\u0001\u0005nC.,'+Z1e)\rQ#G\u0010\t\u0003WAj\u0011\u0001\f\u0006\u0003[9\nA!\u0019<s_*\u0011q\u0006C\u0001\bM>\u0014X.\u0019;t\u0013\t\tDFA\bBY&<g.\\3oiJ+7m\u001c:e\u0011\u0015\u0019t\u00051\u00015\u0003!\u0019X-];f]\u000e,\u0007CA\u001b<\u001d\t1\u0014(D\u00018\u0015\u0005A\u0014!B:dC2\f\u0017B\u0001\u001e8\u0003\u0019\u0001&/\u001a3fM&\u0011A(\u0010\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005i:\u0004\"B (\u0001\u0004!\u0014\u0001B9vC2\u0004")
public class TrimReadsSuite
extends FunSuite
implements SparkFunSuite {
    private final TrimReads ec;
    private SparkContext sc;
    private Option<Map<String, Level>> maybeLevels;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    private volatile boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked;

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public Option<Map<String, Level>> maybeLevels() {
        return this.maybeLevels;
    }

    @Override
    public void maybeLevels_$eq(Option<Map<String, Level>> x$1) {
        this.maybeLevels = x$1;
    }

    @Override
    public void setupSparkContext(String sparkName, boolean silenceSpark) {
        SparkFunSuite$class.setupSparkContext(this, sparkName, silenceSpark);
    }

    @Override
    public void teardownSparkContext() {
        SparkFunSuite$class.teardownSparkContext(this);
    }

    @Override
    public void sparkBefore(String beforeName, boolean silenceSpark, Function0<BoxedUnit> body) {
        SparkFunSuite$class.sparkBefore(this, beforeName, silenceSpark, body);
    }

    @Override
    public void sparkAfter(String beforeName, boolean silenceSpark, Function0<BoxedUnit> body) {
        SparkFunSuite$class.sparkAfter(this, beforeName, silenceSpark, body);
    }

    @Override
    public void sparkTest(String name, boolean silenceSpark, Seq<Tag> tags, Function0<BoxedUnit> body) {
        SparkFunSuite$class.sparkTest(this, name, silenceSpark, tags, body);
    }

    @Override
    public void sparkTest(String name, Function0<BoxedUnit> body) {
        SparkFunSuite$class.sparkTest(this, name, body);
    }

    @Override
    public boolean sparkBefore$default$2() {
        return SparkFunSuite$class.sparkBefore$default$2(this);
    }

    @Override
    public boolean setupSparkContext$default$2() {
        return SparkFunSuite$class.setupSparkContext$default$2(this);
    }

    @Override
    public boolean sparkAfter$default$2() {
        return SparkFunSuite$class.sparkAfter$default$2(this);
    }

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    }

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    }

    public boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked() {
        return this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked;
    }

    public void org$scalatest$BeforeAndAfter$$runHasBeenInvoked_$eq(boolean x$1) {
        this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked = x$1;
    }

    public void org$scalatest$BeforeAndAfter$$super$runTest(String testName, Reporter reporter, Stopper stopper, Map configMap, Tracker tracker) {
        FunSuiteLike.class.runTest((FunSuiteLike)this, (String)testName, (Reporter)reporter, (Stopper)stopper, (Map)configMap, (Tracker)tracker);
    }

    public void org$scalatest$BeforeAndAfter$$super$run(Option testName, Reporter reporter, Stopper stopper, Filter filter, Map configMap, Option distributor, Tracker tracker) {
        FunSuiteLike.class.run((FunSuiteLike)this, (Option)testName, (Reporter)reporter, (Stopper)stopper, (Filter)filter, (Map)configMap, (Option)distributor, (Tracker)tracker);
    }

    public void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$beforeFunctionAtomic_$eq(AtomicReference x$1) {
        this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic = x$1;
    }

    public void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$afterFunctionAtomic_$eq(AtomicReference x$1) {
        this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic = x$1;
    }

    public void before(Function0<Object> fun) {
        BeforeAndAfter.class.before((BeforeAndAfter)this, fun);
    }

    public void after(Function0<Object> fun) {
        BeforeAndAfter.class.after((BeforeAndAfter)this, fun);
    }

    public void runTest(String testName, Reporter reporter, Stopper stopper, Map<String, Object> configMap, Tracker tracker) {
        BeforeAndAfter.class.runTest((BeforeAndAfter)this, (String)testName, (Reporter)reporter, (Stopper)stopper, configMap, (Tracker)tracker);
    }

    public void run(Option<String> testName, Reporter reporter, Stopper stopper, Filter filter, Map<String, Object> configMap, Option<Distributor> distributor, Tracker tracker) {
        BeforeAndAfter.class.run((BeforeAndAfter)this, testName, (Reporter)reporter, (Stopper)stopper, (Filter)filter, configMap, distributor, (Tracker)tracker);
    }

    public TrimReads ec() {
        return this.ec;
    }

    public AlignmentRecord makeRead(String sequence, String qual) {
        return AlignmentRecord.newBuilder().setSequence((CharSequence)sequence).setQual((CharSequence)qual).build();
    }

    public TrimReadsSuite() {
        BeforeAndAfter.class.$init$((BeforeAndAfter)this);
        SparkFunSuite$class.$init$(this);
        this.ec = new TrimReads();
        this.test("trim a few md tags", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TrimReadsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assert(this.$outer.convertToEqualizer(this.$outer.ec().trimMdTag("10", 2, 0)).$eq$eq$eq((Object)"8"));
                this.$outer.assert(this.$outer.convertToEqualizer(this.$outer.ec().trimMdTag("2A10", 4, 0)).$eq$eq$eq((Object)"9"));
                this.$outer.assert(this.$outer.convertToEqualizer(this.$outer.ec().trimMdTag("0C10C1", 1, 2)).$eq$eq$eq((Object)"10"));
                this.$outer.assert(this.$outer.convertToEqualizer(this.$outer.ec().trimMdTag("1^AC3", 2, 0)).$eq$eq$eq((Object)"2"));
                this.$outer.assert(this.$outer.convertToEqualizer(this.$outer.ec().trimMdTag("3^AC1", 0, 2)).$eq$eq$eq((Object)"2"));
                this.$outer.assert(this.$outer.convertToEqualizer(this.$outer.ec().trimMdTag("2A0C0", 3, 0)).$eq$eq$eq((Object)"0C0"));
                this.$outer.assert(this.$outer.convertToEqualizer(this.$outer.ec().trimMdTag("2A0C0", 0, 1)).$eq$eq$eq((Object)"2A0"));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("trim a few cigars that just have clipping and matches", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TrimReadsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assert(this.$outer.convertToEqualizer(this.$outer.ec().trimCigar("2S10M", 1, 0, 0L)).$eq$eq$eq((Object)new Tuple2((Object)"1H1S10M", (Object)BoxesRunTime.boxToLong((long)0L))));
                this.$outer.assert(this.$outer.convertToEqualizer(this.$outer.ec().trimCigar("10M3S", 0, 2, 0L)).$eq$eq$eq((Object)new Tuple2((Object)"10M1S2H", (Object)BoxesRunTime.boxToLong((long)0L))));
                this.$outer.assert(this.$outer.convertToEqualizer(this.$outer.ec().trimCigar("2S10M3S", 1, 2, 0L)).$eq$eq$eq((Object)new Tuple2((Object)"1H1S10M1S2H", (Object)BoxesRunTime.boxToLong((long)0L))));
                this.$outer.assert(this.$outer.convertToEqualizer(this.$outer.ec().trimCigar("2S10M", 2, 0, 0L)).$eq$eq$eq((Object)new Tuple2((Object)"2H10M", (Object)BoxesRunTime.boxToLong((long)0L))));
                this.$outer.assert(this.$outer.convertToEqualizer(this.$outer.ec().trimCigar("10M3S", 0, 3, 0L)).$eq$eq$eq((Object)new Tuple2((Object)"10M3H", (Object)BoxesRunTime.boxToLong((long)0L))));
                this.$outer.assert(this.$outer.convertToEqualizer(this.$outer.ec().trimCigar("2S10M3S", 2, 3, 0L)).$eq$eq$eq((Object)new Tuple2((Object)"2H10M3H", (Object)BoxesRunTime.boxToLong((long)0L))));
                this.$outer.assert(this.$outer.convertToEqualizer(this.$outer.ec().trimCigar("2S10M", 3, 0, 0L)).$eq$eq$eq((Object)new Tuple2((Object)"3H9M", (Object)BoxesRunTime.boxToLong((long)1L))));
                this.$outer.assert(this.$outer.convertToEqualizer(this.$outer.ec().trimCigar("10M3S", 0, 4, 0L)).$eq$eq$eq((Object)new Tuple2((Object)"9M4H", (Object)BoxesRunTime.boxToLong((long)0L))));
                this.$outer.assert(this.$outer.convertToEqualizer(this.$outer.ec().trimCigar("2S10M3S", 3, 4, 0L)).$eq$eq$eq((Object)new Tuple2((Object)"3H8M4H", (Object)BoxesRunTime.boxToLong((long)1L))));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("trim cigars with indels", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TrimReadsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assert(this.$outer.convertToEqualizer(this.$outer.ec().trimCigar("2S2M2D4M", 5, 0, 0L)).$eq$eq$eq((Object)new Tuple2((Object)"5H3M", (Object)BoxesRunTime.boxToLong((long)5L))));
                this.$outer.assert(this.$outer.convertToEqualizer(this.$outer.ec().trimCigar("4M1D1M", 0, 3, 0L)).$eq$eq$eq((Object)new Tuple2((Object)"2M3H", (Object)BoxesRunTime.boxToLong((long)0L))));
                this.$outer.assert(this.$outer.convertToEqualizer(this.$outer.ec().trimCigar("2S2M2N4M", 5, 0, 0L)).$eq$eq$eq((Object)new Tuple2((Object)"5H3M", (Object)BoxesRunTime.boxToLong((long)5L))));
                this.$outer.assert(this.$outer.convertToEqualizer(this.$outer.ec().trimCigar("4M1N1M", 0, 3, 0L)).$eq$eq$eq((Object)new Tuple2((Object)"2M3H", (Object)BoxesRunTime.boxToLong((long)0L))));
                this.$outer.assert(this.$outer.convertToEqualizer(this.$outer.ec().trimCigar("2M2I10M", 3, 0, 0L)).$eq$eq$eq((Object)new Tuple2((Object)"3H1I10M", (Object)BoxesRunTime.boxToLong((long)2L))));
                this.$outer.assert(this.$outer.convertToEqualizer(this.$outer.ec().trimCigar("10M3I1M", 0, 3, 0L)).$eq$eq$eq((Object)new Tuple2((Object)"10M1I3H", (Object)BoxesRunTime.boxToLong((long)0L))));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("trim a few reads", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TrimReadsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                AlignmentRecord read1 = AlignmentRecord.newBuilder().setSequence((CharSequence)"ACTCGCCCACTCA").setQual((CharSequence)"##/9:::::::::").build();
                AlignmentRecord trimmedRead1 = this.$outer.ec().trimRead(read1, 2, 0);
                this.$outer.assert(this.$outer.convertToEqualizer(((Object)trimmedRead1.getSequence()).toString()).$eq$eq$eq((Object)"TCGCCCACTCA"));
                this.$outer.assert(this.$outer.convertToEqualizer(((Object)trimmedRead1.getQual()).toString()).$eq$eq$eq((Object)"/9:::::::::"));
                AlignmentRecord read2 = AlignmentRecord.newBuilder().setSequence((CharSequence)"ACTCGCCCACTCAAA").setQual((CharSequence)"##/9:::::::::##").setCigar((CharSequence)"2S11M2S").setStart(Predef$.MODULE$.long2Long(5L)).build();
                AlignmentRecord trimmedRead2 = this.$outer.ec().trimRead(read2, 2, 2);
                this.$outer.assert(this.$outer.convertToEqualizer(((Object)trimmedRead2.getSequence()).toString()).$eq$eq$eq((Object)"TCGCCCACTCA"));
                this.$outer.assert(this.$outer.convertToEqualizer(((Object)trimmedRead2.getQual()).toString()).$eq$eq$eq((Object)"/9:::::::::"));
                this.$outer.assert(this.$outer.convertToEqualizer(trimmedRead2.getStart()).$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)5L)));
                this.$outer.assert(this.$outer.convertToEqualizer(((Object)trimmedRead2.getCigar()).toString()).$eq$eq$eq((Object)"2H11M2H"));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.sparkTest("correctly trim an RDD of reads", (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            public final /* synthetic */ TrimReadsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq reads = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AlignmentRecord[]{this.$outer.makeRead("AACTCGACGCTTT", "##::::::::$$$"), this.$outer.makeRead("AACTCCCTGCTTT", "##::::::::$$$"), this.$outer.makeRead("AACTCATAGCTTT", "##::::::::$$$"), this.$outer.makeRead("AACTCCCAGCTTT", "##::::::::$$$"), this.$outer.makeRead("AACTCGGAGCTTT", "##::::::::$$$")}));
                SparkContext qual$1 = this.$outer.sc();
                int x$2 = qual$1.parallelize$default$2();
                RDD rdd = qual$1.parallelize(reads, x$2, ClassTag$.MODULE$.apply(AlignmentRecord.class));
                RDD trimFront = TrimReads$.MODULE$.apply(rdd, 2, 0, TrimReads$.MODULE$.apply$default$4());
                Predef$.MODULE$.refArrayOps((Object[])trimFront.collect()).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$5 $outer;

                    public final void apply(AlignmentRecord r) {
                        this.$outer.$outer.assert(this.$outer.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)r.getSequence().length())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)11)));
                        this.$outer.$outer.assert(this.$outer.org$bdgenomics$adam$rdd$correction$TrimReadsSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToInteger((int)r.getQual().length())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)11)));
                        this.$outer.org$bdgenomics$adam$rdd$correction$TrimReadsSuite$$anonfun$$$outer().assert(((Object)r.getSequence()).toString().startsWith("CT"));
                        this.$outer.org$bdgenomics$adam$rdd$correction$TrimReadsSuite$$anonfun$$$outer().assert(((Object)r.getSequence()).toString().endsWith("TTT"));
                        this.$outer.org$bdgenomics$adam$rdd$correction$TrimReadsSuite$$anonfun$$$outer().assert(((Object)r.getQual()).toString().startsWith("::"));
                        this.$outer.org$bdgenomics$adam$rdd$correction$TrimReadsSuite$$anonfun$$$outer().assert(((Object)r.getQual()).toString().endsWith("$$$"));
                        this.$outer.org$bdgenomics$adam$rdd$correction$TrimReadsSuite$$anonfun$$$outer().assert(this.$outer.org$bdgenomics$adam$rdd$correction$TrimReadsSuite$$anonfun$$$outer().convertToEqualizer(r.getBasesTrimmedFromStart()).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)2)));
                        this.$outer.org$bdgenomics$adam$rdd$correction$TrimReadsSuite$$anonfun$$$outer().assert(this.$outer.org$bdgenomics$adam$rdd$correction$TrimReadsSuite$$anonfun$$$outer().convertToEqualizer(r.getBasesTrimmedFromEnd()).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)0)));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                RDD trimEnd = TrimReads$.MODULE$.apply(trimFront, 0, 3, TrimReads$.MODULE$.apply$default$4());
                Predef$.MODULE$.refArrayOps((Object[])trimEnd.collect()).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$5 $outer;

                    public final void apply(AlignmentRecord r) {
                        this.$outer.$outer.assert(this.$outer.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)r.getSequence().length())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)8)), r.getSequence());
                        this.$outer.$outer.assert(this.$outer.org$bdgenomics$adam$rdd$correction$TrimReadsSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToInteger((int)r.getQual().length())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)8)));
                        this.$outer.org$bdgenomics$adam$rdd$correction$TrimReadsSuite$$anonfun$$$outer().assert(((Object)r.getSequence()).toString().startsWith("CT"));
                        this.$outer.org$bdgenomics$adam$rdd$correction$TrimReadsSuite$$anonfun$$$outer().assert(((Object)r.getSequence()).toString().endsWith("GC"));
                        this.$outer.org$bdgenomics$adam$rdd$correction$TrimReadsSuite$$anonfun$$$outer().assert(this.$outer.org$bdgenomics$adam$rdd$correction$TrimReadsSuite$$anonfun$$$outer().convertToEqualizer(((Object)r.getQual()).toString()).$eq$eq$eq((Object)"::::::::"));
                        this.$outer.org$bdgenomics$adam$rdd$correction$TrimReadsSuite$$anonfun$$$outer().assert(this.$outer.org$bdgenomics$adam$rdd$correction$TrimReadsSuite$$anonfun$$$outer().convertToEqualizer(r.getBasesTrimmedFromStart()).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)2)));
                        this.$outer.org$bdgenomics$adam$rdd$correction$TrimReadsSuite$$anonfun$$$outer().assert(this.$outer.org$bdgenomics$adam$rdd$correction$TrimReadsSuite$$anonfun$$$outer().convertToEqualizer(r.getBasesTrimmedFromEnd()).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)3)));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ TrimReadsSuite org$bdgenomics$adam$rdd$correction$TrimReadsSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.sparkTest("adaptively trim reads", (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            public final /* synthetic */ TrimReadsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String readsFilepath = ClassLoader.getSystemClassLoader().getResource("bqsr1.sam").getFile();
                ADAMContext qual$2 = ADAMContext$.MODULE$.sparkContextToADAMContext(this.$outer.sc());
                None$ x$4 = qual$2.adamLoad$default$2();
                Option x$5 = qual$2.adamLoad$default$3();
                RDD reads = qual$2.adamLoad(readsFilepath, (Option)x$4, x$5, (Function1)Predef$.MODULE$.conforms(), ManifestFactory$.MODULE$.classType(AlignmentRecord.class));
                RDD readsSingleRG = reads.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final AlignmentRecord apply(AlignmentRecord read) {
                        return AlignmentRecord.newBuilder((AlignmentRecord)read).setRecordGroupName((CharSequence)"group0").build();
                    }
                }, ClassTag$.MODULE$.apply(AlignmentRecord.class));
                RDD trimmed = TrimReads$.MODULE$.apply(readsSingleRG, 10);
                Predef$.MODULE$.refArrayOps((Object[])trimmed.collect()).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$6 $outer;

                    public final void apply(AlignmentRecord r) {
                        this.$outer.$outer.assert(this.$outer.$outer.convertToEqualizer(r.getBasesTrimmedFromStart()).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)5)));
                        this.$outer.$outer.assert(this.$outer.org$bdgenomics$adam$rdd$correction$TrimReadsSuite$$anonfun$$$outer().convertToEqualizer(r.getBasesTrimmedFromEnd()).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)5)));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ TrimReadsSuite org$bdgenomics$adam$rdd$correction$TrimReadsSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

