/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.rich;

import org.bdgenomics.adam.models.Attribute;
import org.bdgenomics.adam.models.ReferencePosition;
import org.bdgenomics.adam.models.TagType$;
import org.bdgenomics.adam.rich.IlluminaOptics;
import org.bdgenomics.adam.rich.RichAlignmentRecord;
import org.bdgenomics.adam.rich.RichAlignmentRecord$;
import org.bdgenomics.adam.rich.RichAlignmentRecordSuite$;
import org.bdgenomics.formats.avro.AlignmentRecord;
import org.bdgenomics.formats.avro.Contig;
import org.scalatest.FunSuite;
import org.scalatest.Tag;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.Range;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001]1A!\u0001\u0002\u0001\u0017\tA\"+[2i\u00032LwM\\7f]R\u0014VmY8sIN+\u0018\u000e^3\u000b\u0005\r!\u0011\u0001\u0002:jG\"T!!\u0002\u0004\u0002\t\u0005$\u0017-\u001c\u0006\u0003\u000f!\t!B\u00193hK:|W.[2t\u0015\u0005I\u0011aA8sO\u000e\u00011C\u0001\u0001\r!\ti\u0001#D\u0001\u000f\u0015\ty\u0001\"A\u0005tG\u0006d\u0017\r^3ti&\u0011\u0011C\u0004\u0002\t\rVt7+^5uK\")1\u0003\u0001C\u0001)\u00051A(\u001b8jiz\"\u0012!\u0006\t\u0003-\u0001i\u0011A\u0001")
public class RichAlignmentRecordSuite
extends FunSuite {
    public RichAlignmentRecordSuite() {
        this.test("referenceLengthFromCigar", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RichAlignmentRecordSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)RichAlignmentRecord$.MODULE$.referenceLengthFromCigar("3M"))).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)3)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)RichAlignmentRecord$.MODULE$.referenceLengthFromCigar("30M"))).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)30)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)RichAlignmentRecord$.MODULE$.referenceLengthFromCigar("10Y"))).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)0)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)RichAlignmentRecord$.MODULE$.referenceLengthFromCigar("10M1Y"))).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)10)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)RichAlignmentRecord$.MODULE$.referenceLengthFromCigar("10M1I10M"))).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)20)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)RichAlignmentRecord$.MODULE$.referenceLengthFromCigar("10M1D10M"))).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)21)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)RichAlignmentRecord$.MODULE$.referenceLengthFromCigar("1S10M1S"))).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)10)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Unclipped Start", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RichAlignmentRecordSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                AlignmentRecord recordWithoutClipping = AlignmentRecord.newBuilder().setReadMapped(Predef$.MODULE$.boolean2Boolean(true)).setCigar((CharSequence)"10M").setStart(Predef$.MODULE$.long2Long(42L)).setEnd(Predef$.MODULE$.long2Long(52L)).build();
                AlignmentRecord recordWithClipping = AlignmentRecord.newBuilder().setReadMapped(Predef$.MODULE$.boolean2Boolean(true)).setCigar((CharSequence)"2S8M").setStart(Predef$.MODULE$.long2Long(42L)).setEnd(Predef$.MODULE$.long2Long(50L)).build();
                AlignmentRecord recordWithHardClipping = AlignmentRecord.newBuilder().setReadMapped(Predef$.MODULE$.boolean2Boolean(true)).setCigar((CharSequence)"3H2S5M4S").setStart(Predef$.MODULE$.long2Long(42L)).setEnd(Predef$.MODULE$.long2Long(47L)).build();
                Option option = RichAlignmentRecord$.MODULE$.recordToRichRecord(recordWithoutClipping).unclippedStart();
                Some some = new Some((Object)BoxesRunTime.boxToLong((long)42L));
                this.$outer.assert(!(option != null ? !option.equals(some) : some != null));
                Option option2 = RichAlignmentRecord$.MODULE$.recordToRichRecord(recordWithClipping).unclippedStart();
                Some some2 = new Some((Object)BoxesRunTime.boxToLong((long)40L));
                this.$outer.assert(!(option2 != null ? !option2.equals(some2) : some2 != null));
                Option option3 = RichAlignmentRecord$.MODULE$.recordToRichRecord(recordWithHardClipping).unclippedStart();
                Some some3 = new Some((Object)BoxesRunTime.boxToLong((long)37L));
                this.$outer.assert(!(option3 != null ? !option3.equals(some3) : some3 != null));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Unclipped End", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RichAlignmentRecordSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                AlignmentRecord unmappedRead = AlignmentRecord.newBuilder().setReadMapped(Predef$.MODULE$.boolean2Boolean(false)).setStart(Predef$.MODULE$.long2Long(0L)).setCigar((CharSequence)"10M").setEnd(Predef$.MODULE$.long2Long(10L)).build();
                AlignmentRecord recordWithoutClipping = AlignmentRecord.newBuilder().setReadMapped(Predef$.MODULE$.boolean2Boolean(true)).setCigar((CharSequence)"10M").setStart(Predef$.MODULE$.long2Long(10L)).setEnd(Predef$.MODULE$.long2Long(20L)).build();
                AlignmentRecord recordWithClipping = AlignmentRecord.newBuilder().setReadMapped(Predef$.MODULE$.boolean2Boolean(true)).setCigar((CharSequence)"8M2S").setStart(Predef$.MODULE$.long2Long(10L)).setEnd(Predef$.MODULE$.long2Long(18L)).build();
                AlignmentRecord recordWithHardClipping = AlignmentRecord.newBuilder().setReadMapped(Predef$.MODULE$.boolean2Boolean(true)).setCigar((CharSequence)"6M2S2H").setStart(Predef$.MODULE$.long2Long(10L)).setEnd(Predef$.MODULE$.long2Long(16L)).build();
                Option option = RichAlignmentRecord$.MODULE$.recordToRichRecord(unmappedRead).unclippedEnd();
                None$ none$ = None$.MODULE$;
                this.$outer.assert(!(option != null ? !option.equals(none$) : none$ != null));
                Option option2 = RichAlignmentRecord$.MODULE$.recordToRichRecord(recordWithoutClipping).unclippedEnd();
                Some some = new Some((Object)BoxesRunTime.boxToLong((long)20L));
                this.$outer.assert(!(option2 != null ? !option2.equals(some) : some != null));
                Option option3 = RichAlignmentRecord$.MODULE$.recordToRichRecord(recordWithClipping).unclippedEnd();
                Some some2 = new Some((Object)BoxesRunTime.boxToLong((long)20L));
                this.$outer.assert(!(option3 != null ? !option3.equals(some2) : some2 != null));
                Option option4 = RichAlignmentRecord$.MODULE$.recordToRichRecord(recordWithHardClipping).unclippedEnd();
                Some some3 = new Some((Object)BoxesRunTime.boxToLong((long)20L));
                this.$outer.assert(!(option4 != null ? !option4.equals(some3) : some3 != null));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Illumina Optics", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RichAlignmentRecordSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Option option;
                block4: {
                    block3: {
                        block2: {
                            AlignmentRecord nonIlluminaRecord = AlignmentRecord.newBuilder().setReadName((CharSequence)"THISISNOTILLUMINA").build();
                            Option option2 = RichAlignmentRecord$.MODULE$.recordToRichRecord(nonIlluminaRecord).illuminaOptics();
                            None$ none$ = None$.MODULE$;
                            this.$outer.assert(!(option2 != null ? !option2.equals(none$) : none$ != null));
                            AlignmentRecord illuminaRecord = AlignmentRecord.newBuilder().setReadName((CharSequence)"613F0AAXX100423:4:86:16767:3088").build();
                            option = RichAlignmentRecord$.MODULE$.recordToRichRecord(illuminaRecord).illuminaOptics();
                            if (!(option instanceof Some)) break block2;
                            Some some = (Some)option;
                            this.$outer.assert(((IlluminaOptics)some.x()).tile() == 86L);
                            this.$outer.assert(((IlluminaOptics)some.x()).x() == 16767L);
                            this.$outer.assert(((IlluminaOptics)some.x()).y() == 3088L);
                            break block3;
                        }
                        None$ none$ = None$.MODULE$;
                        if (none$ != null ? !none$.equals(option) : option != null) break block4;
                        this.$outer.assert((Option)new Some((Object)"Failed to parse valid Illumina read name"));
                    }
                    return;
                }
                throw new MatchError((Object)option);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Cigar Clipping Sequence", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RichAlignmentRecordSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Contig contig = Contig.newBuilder().setContigName((CharSequence)"chr1").build();
                AlignmentRecord softClippedRead = AlignmentRecord.newBuilder().setReadMapped(Predef$.MODULE$.boolean2Boolean(true)).setStart(Predef$.MODULE$.long2Long(100L)).setCigar((CharSequence)"10S90M").setContig(contig).build();
                Option option = (Option)RichAlignmentRecord$.MODULE$.recordToRichRecord(softClippedRead).referencePositions().apply(0);
                Object object = !option.isEmpty() ? new Some((Object)BoxesRunTime.boxToLong((long)((ReferencePosition)option.get()).pos())) : None$.MODULE$;
                Some some = new Some((Object)BoxesRunTime.boxToLong((long)90L));
                this.$outer.assert(!(object != null ? !object.equals(some) : some != null));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("tags contains optional fields", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RichAlignmentRecordSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Contig contig = Contig.newBuilder().setContigName((CharSequence)"chr1").build();
                AlignmentRecord rec = AlignmentRecord.newBuilder().setAttributes((CharSequence)"XX:i:3\tYY:Z:foo").setContig(contig).build();
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)RichAlignmentRecord$.MODULE$.recordToRichRecord(rec).tags().size())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)2)));
                this.$outer.assert(this.$outer.convertToEqualizer(RichAlignmentRecord$.MODULE$.recordToRichRecord(rec).tags().apply(0)).$eq$eq$eq((Object)new Attribute("XX", (Enumeration.Value)TagType$.MODULE$.Integer(), (Object)BoxesRunTime.boxToInteger((int)3))));
                this.$outer.assert(this.$outer.convertToEqualizer(RichAlignmentRecord$.MODULE$.recordToRichRecord(rec).tags().apply(1)).$eq$eq$eq((Object)new Attribute("YY", (Enumeration.Value)TagType$.MODULE$.String(), (Object)"foo")));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Reference Positions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            public final /* synthetic */ RichAlignmentRecordSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            /*
             * Handled impossible loop by adding 'first' condition
             * Enabled aggressive block sorting
             */
            public void apply$mcV$sp() {
                Contig contig = Contig.newBuilder().setContigName((CharSequence)"chr1").build();
                AlignmentRecord hardClippedRead = AlignmentRecord.newBuilder().setReadMapped(Predef$.MODULE$.boolean2Boolean(true)).setStart(Predef$.MODULE$.long2Long(1000L)).setCigar((CharSequence)"90M10H").setContig(contig).build();
                this.$outer.assert(RichAlignmentRecord$.MODULE$.recordToRichRecord(hardClippedRead).referencePositions().length() == 90);
                Option option = (Option)RichAlignmentRecord$.MODULE$.recordToRichRecord(hardClippedRead).referencePositions().apply(0);
                Object object = !option.isEmpty() ? new Some((Object)BoxesRunTime.boxToLong((long)((ReferencePosition)option.get()).pos())) : None$.MODULE$;
                Some some = new Some((Object)BoxesRunTime.boxToLong((long)1000L));
                this.$outer.assert(!(object != null ? !object.equals(some) : some != null));
                AlignmentRecord softClippedRead = AlignmentRecord.newBuilder().setReadMapped(Predef$.MODULE$.boolean2Boolean(true)).setStart(Predef$.MODULE$.long2Long(1000L)).setCigar((CharSequence)"10S90M").setContig(contig).build();
                this.$outer.assert(RichAlignmentRecord$.MODULE$.recordToRichRecord(softClippedRead).referencePositions().length() == 100);
                Option option2 = (Option)RichAlignmentRecord$.MODULE$.recordToRichRecord(softClippedRead).referencePositions().apply(0);
                Object object2 = !option2.isEmpty() ? new Some((Object)BoxesRunTime.boxToLong((long)((ReferencePosition)option2.get()).pos())) : None$.MODULE$;
                Some some2 = new Some((Object)BoxesRunTime.boxToLong((long)990L));
                this.$outer.assert(!(object2 != null ? !object2.equals(some2) : some2 != null));
                Option option3 = (Option)RichAlignmentRecord$.MODULE$.recordToRichRecord(softClippedRead).referencePositions().apply(10);
                Object object3 = !option3.isEmpty() ? new Some((Object)BoxesRunTime.boxToLong((long)((ReferencePosition)option3.get()).pos())) : None$.MODULE$;
                Some some3 = new Some((Object)BoxesRunTime.boxToLong((long)1000L));
                this.$outer.assert(!(object3 != null ? !object3.equals(some3) : some3 != null));
                AlignmentRecord doubleMatchNonsenseRead = AlignmentRecord.newBuilder().setReadMapped(Predef$.MODULE$.boolean2Boolean(true)).setStart(Predef$.MODULE$.long2Long(1000L)).setCigar((CharSequence)"10M10M").setContig(contig).build();
                Serializable serializable = new Serializable(this, doubleMatchNonsenseRead){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$7 $outer;
                    private final AlignmentRecord doubleMatchNonsenseRead$1;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        Option option = (Option)RichAlignmentRecord$.MODULE$.recordToRichRecord(this.doubleMatchNonsenseRead$1).referencePositions().apply(i);
                        Object object = !option.isEmpty() ? new Some((Object)BoxesRunTime.boxToLong((long)((ReferencePosition)option.get()).pos())) : None$.MODULE$;
                        Some some = new Some((Object)BoxesRunTime.boxToInteger((int)(1000 + i)));
                        this.$outer.$outer.assert(!(object != null ? !object.equals(some) : some != null));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.doubleMatchNonsenseRead$1 = doubleMatchNonsenseRead$1;
                    }
                };
                Range range = package$.MODULE$.Range().apply(0, 20);
                boolean bl = true;
                while (true) {
                    int n;
                    int n2;
                    block5: {
                        AlignmentRecord deletionRead;
                        block4: {
                            int n3;
                            block3: {
                                if (!bl || (bl = false)) break block3;
                                if (!range.validateRangeBoundaries((Function1)serializable)) break block4;
                                n2 = range.start();
                                n3 = range.terminalElement();
                                n = range.step();
                            }
                            if (n2 != n3) break block5;
                        }
                        this.$outer.assert(RichAlignmentRecord$.MODULE$.recordToRichRecord(deletionRead = AlignmentRecord.newBuilder().setReadMapped(Predef$.MODULE$.boolean2Boolean(true)).setStart(Predef$.MODULE$.long2Long(1000L)).setCigar((CharSequence)"5M5D10M").setContig(contig).build()).referencePositions().length() == 15);
                        Option option4 = (Option)RichAlignmentRecord$.MODULE$.recordToRichRecord(deletionRead).referencePositions().apply(0);
                        Object object4 = !option4.isEmpty() ? new Some((Object)BoxesRunTime.boxToLong((long)((ReferencePosition)option4.get()).pos())) : None$.MODULE$;
                        Some some4 = new Some((Object)BoxesRunTime.boxToLong((long)1000L));
                        this.$outer.assert(!(object4 != null ? !object4.equals(some4) : some4 != null));
                        Option option5 = (Option)RichAlignmentRecord$.MODULE$.recordToRichRecord(deletionRead).referencePositions().apply(5);
                        Object object5 = !option5.isEmpty() ? new Some((Object)BoxesRunTime.boxToLong((long)((ReferencePosition)option5.get()).pos())) : None$.MODULE$;
                        Some some5 = new Some((Object)BoxesRunTime.boxToLong((long)1010L));
                        this.$outer.assert(!(object5 != null ? !object5.equals(some5) : some5 != null));
                        AlignmentRecord insertionRead = AlignmentRecord.newBuilder().setReadMapped(Predef$.MODULE$.boolean2Boolean(true)).setStart(Predef$.MODULE$.long2Long(1000L)).setCigar((CharSequence)"10M2I10M").setContig(contig).build();
                        this.$outer.assert(RichAlignmentRecord$.MODULE$.recordToRichRecord(insertionRead).referencePositions().length() == 22);
                        Option option6 = (Option)RichAlignmentRecord$.MODULE$.recordToRichRecord(insertionRead).referencePositions().apply(0);
                        Object object6 = !option6.isEmpty() ? new Some((Object)BoxesRunTime.boxToLong((long)((ReferencePosition)option6.get()).pos())) : None$.MODULE$;
                        Some some6 = new Some((Object)BoxesRunTime.boxToLong((long)1000L));
                        this.$outer.assert(!(object6 != null ? !object6.equals(some6) : some6 != null));
                        Option option7 = (Option)RichAlignmentRecord$.MODULE$.recordToRichRecord(insertionRead).referencePositions().apply(10);
                        Object object7 = !option7.isEmpty() ? new Some((Object)BoxesRunTime.boxToLong((long)((ReferencePosition)option7.get()).pos())) : None$.MODULE$;
                        None$ none$ = None$.MODULE$;
                        this.$outer.assert(!(object7 != null ? !object7.equals(none$) : none$ != null));
                        Option option8 = (Option)RichAlignmentRecord$.MODULE$.recordToRichRecord(insertionRead).referencePositions().apply(12);
                        Object object8 = !option8.isEmpty() ? new Some((Object)BoxesRunTime.boxToLong((long)((ReferencePosition)option8.get()).pos())) : None$.MODULE$;
                        Some some7 = new Some((Object)BoxesRunTime.boxToLong((long)1010L));
                        this.$outer.assert(!(object8 != null ? !object8.equals(some7) : some7 != null));
                        AlignmentRecord indelRead = AlignmentRecord.newBuilder().setReadMapped(Predef$.MODULE$.boolean2Boolean(true)).setStart(Predef$.MODULE$.long2Long(1000L)).setCigar((CharSequence)"10M3D10M2I").setContig(contig).build();
                        this.$outer.assert(RichAlignmentRecord$.MODULE$.recordToRichRecord(indelRead).referencePositions().length() == 22);
                        Option option9 = (Option)RichAlignmentRecord$.MODULE$.recordToRichRecord(indelRead).referencePositions().apply(0);
                        Object object9 = !option9.isEmpty() ? new Some((Object)BoxesRunTime.boxToLong((long)((ReferencePosition)option9.get()).pos())) : None$.MODULE$;
                        Some some8 = new Some((Object)BoxesRunTime.boxToLong((long)1000L));
                        this.$outer.assert(!(object9 != null ? !object9.equals(some8) : some8 != null));
                        Option option10 = (Option)RichAlignmentRecord$.MODULE$.recordToRichRecord(indelRead).referencePositions().apply(10);
                        Object object10 = !option10.isEmpty() ? new Some((Object)BoxesRunTime.boxToLong((long)((ReferencePosition)option10.get()).pos())) : None$.MODULE$;
                        Some some9 = new Some((Object)BoxesRunTime.boxToLong((long)1013L));
                        this.$outer.assert(!(object10 != null ? !object10.equals(some9) : some9 != null));
                        Option option11 = (Option)RichAlignmentRecord$.MODULE$.recordToRichRecord(indelRead).referencePositions().apply(20);
                        Object object11 = !option11.isEmpty() ? new Some((Object)BoxesRunTime.boxToLong((long)((ReferencePosition)option11.get()).pos())) : None$.MODULE$;
                        None$ none$2 = None$.MODULE$;
                        this.$outer.assert(!(object11 != null ? !object11.equals(none$2) : none$2 != null));
                        AlignmentRecord hg00096read = AlignmentRecord.newBuilder().setReadMapped(Predef$.MODULE$.boolean2Boolean(true)).setStart(Predef$.MODULE$.long2Long(1000L)).setCigar((CharSequence)"1S28M1D32M1I15M1D23M").setContig(contig).build();
                        this.$outer.assert(RichAlignmentRecord$.MODULE$.recordToRichRecord(hg00096read).referencePositions().length() == 100);
                        Option option12 = (Option)RichAlignmentRecord$.MODULE$.recordToRichRecord(hg00096read).referencePositions().apply(0);
                        Object object12 = !option12.isEmpty() ? new Some((Object)BoxesRunTime.boxToLong((long)((ReferencePosition)option12.get()).pos())) : None$.MODULE$;
                        Some some10 = new Some((Object)BoxesRunTime.boxToLong((long)999L));
                        this.$outer.assert(!(object12 != null ? !object12.equals(some10) : some10 != null));
                        Option option13 = (Option)RichAlignmentRecord$.MODULE$.recordToRichRecord(hg00096read).referencePositions().apply(1);
                        Object object13 = !option13.isEmpty() ? new Some((Object)BoxesRunTime.boxToLong((long)((ReferencePosition)option13.get()).pos())) : None$.MODULE$;
                        Some some11 = new Some((Object)BoxesRunTime.boxToLong((long)1000L));
                        this.$outer.assert(!(object13 != null ? !object13.equals(some11) : some11 != null));
                        Option option14 = (Option)RichAlignmentRecord$.MODULE$.recordToRichRecord(hg00096read).referencePositions().apply(29);
                        Object object14 = !option14.isEmpty() ? new Some((Object)BoxesRunTime.boxToLong((long)((ReferencePosition)option14.get()).pos())) : None$.MODULE$;
                        Some some12 = new Some((Object)BoxesRunTime.boxToLong((long)1029L));
                        this.$outer.assert(!(object14 != null ? !object14.equals(some12) : some12 != null));
                        Option option15 = (Option)RichAlignmentRecord$.MODULE$.recordToRichRecord(hg00096read).referencePositions().apply(61);
                        Object object15 = !option15.isEmpty() ? new Some((Object)BoxesRunTime.boxToLong((long)((ReferencePosition)option15.get()).pos())) : None$.MODULE$;
                        None$ none$3 = None$.MODULE$;
                        this.$outer.assert(!(object15 != null ? !object15.equals(none$3) : none$3 != null));
                        Option option16 = (Option)RichAlignmentRecord$.MODULE$.recordToRichRecord(hg00096read).referencePositions().apply(62);
                        Object object16 = !option16.isEmpty() ? new Some((Object)BoxesRunTime.boxToLong((long)((ReferencePosition)option16.get()).pos())) : None$.MODULE$;
                        Some some13 = new Some((Object)BoxesRunTime.boxToLong((long)1061L));
                        this.$outer.assert(!(object16 != null ? !object16.equals(some13) : some13 != null));
                        Option option17 = (Option)RichAlignmentRecord$.MODULE$.recordToRichRecord(hg00096read).referencePositions().apply(78);
                        Object object17 = !option17.isEmpty() ? new Some((Object)BoxesRunTime.boxToLong((long)((ReferencePosition)option17.get()).pos())) : None$.MODULE$;
                        Some some14 = new Some((Object)BoxesRunTime.boxToLong((long)1078L));
                        this.$outer.assert(!(object17 != null ? !object17.equals(some14) : some14 != null));
                        Option option18 = (Option)RichAlignmentRecord$.MODULE$.recordToRichRecord(hg00096read).referencePositions().apply(99);
                        Object object18 = !option18.isEmpty() ? new Some((Object)BoxesRunTime.boxToLong((long)((ReferencePosition)option18.get()).pos())) : None$.MODULE$;
                        Some some15 = new Some((Object)BoxesRunTime.boxToLong((long)1099L));
                        this.$outer.assert(!(object18 != null ? !object18.equals(some15) : some15 != null));
                        return;
                    }
                    serializable.apply$mcVI$sp(n2);
                    n2 += n;
                }
            }

            public /* synthetic */ RichAlignmentRecordSuite org$bdgenomics$adam$rich$RichAlignmentRecordSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("read overlap unmapped read", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RichAlignmentRecordSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Option overlaps;
                AlignmentRecord unmappedRead = AlignmentRecord.newBuilder().setReadMapped(Predef$.MODULE$.boolean2Boolean(false)).setStart(Predef$.MODULE$.long2Long(0L)).setCigar((CharSequence)"10M").setEnd(Predef$.MODULE$.long2Long(10L)).build();
                Option option = overlaps = RichAlignmentRecord$.MODULE$.recordToRichRecord(unmappedRead).overlapsReferencePosition(new ReferencePosition("chr1", 10L));
                None$ none$ = None$.MODULE$;
                this.$outer.assert(!(option != null ? !option.equals(none$) : none$ != null));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("read overlap reference position", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RichAlignmentRecordSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Contig contig = Contig.newBuilder().setContigName((CharSequence)"chr1").build();
                RichAlignmentRecord record = RichAlignmentRecord$.MODULE$.apply(AlignmentRecord.newBuilder().setReadMapped(Predef$.MODULE$.boolean2Boolean(true)).setCigar((CharSequence)"10M").setStart(Predef$.MODULE$.long2Long(10L)).setEnd(Predef$.MODULE$.long2Long(20L)).setContig(contig).build());
                Option option = record.overlapsReferencePosition(new ReferencePosition("chr1", 10L));
                Some some = new Some((Object)BoxesRunTime.boxToBoolean((boolean)true));
                this.$outer.assert(!(option != null ? !option.equals(some) : some != null));
                Option option2 = record.overlapsReferencePosition(new ReferencePosition("chr1", 14L));
                Some some2 = new Some((Object)BoxesRunTime.boxToBoolean((boolean)true));
                this.$outer.assert(!(option2 != null ? !option2.equals(some2) : some2 != null));
                Option option3 = record.overlapsReferencePosition(new ReferencePosition("chr1", 19L));
                Some some3 = new Some((Object)BoxesRunTime.boxToBoolean((boolean)true));
                this.$outer.assert(!(option3 != null ? !option3.equals(some3) : some3 != null));
                Option option4 = record.overlapsReferencePosition(new ReferencePosition("chr1", 20L));
                Some some4 = new Some((Object)BoxesRunTime.boxToBoolean((boolean)false));
                this.$outer.assert(!(option4 != null ? !option4.equals(some4) : some4 != null));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("read overlap same position different contig", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RichAlignmentRecordSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Contig contig = Contig.newBuilder().setContigName((CharSequence)"chr1").build();
                RichAlignmentRecord record = RichAlignmentRecord$.MODULE$.apply(AlignmentRecord.newBuilder().setReadMapped(Predef$.MODULE$.boolean2Boolean(true)).setCigar((CharSequence)"10M").setStart(Predef$.MODULE$.long2Long(10L)).setEnd(Predef$.MODULE$.long2Long(20L)).setContig(contig).build());
                Option option = record.overlapsReferencePosition(new ReferencePosition("chr2", 10L));
                Some some = new Some((Object)BoxesRunTime.boxToBoolean((boolean)false));
                this.$outer.assert(!(option != null ? !option.equals(some) : some != null));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

