/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.algorithms.consensus;

import org.apache.spark.SparkContext;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.rdd.RDD;
import org.bdgenomics.adam.algorithms.consensus.ConsensusGenerator;
import org.bdgenomics.adam.algorithms.realignmenttarget.IndelRealignmentTarget;
import org.bdgenomics.adam.models.Consensus;
import org.bdgenomics.adam.models.IndelTable;
import org.bdgenomics.adam.models.IndelTable$;
import org.bdgenomics.adam.models.ReferenceRegion;
import org.bdgenomics.adam.models.SequenceDictionary;
import org.bdgenomics.adam.models.VariantContext;
import org.bdgenomics.adam.rdd.ADAMContext$;
import org.bdgenomics.adam.rdd.variation.ADAMVariationContext;
import org.bdgenomics.adam.rdd.variation.ADAMVariationContext$;
import org.bdgenomics.adam.rich.RichAlignmentRecord;
import org.bdgenomics.adam.rich.RichAlignmentRecord$;
import org.bdgenomics.formats.avro.Variant;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.TraversableOnce;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong;

@ScalaSignature(bytes="\u0006\u0001]4A!\u0001\u0002\u0001\u001b\ta2i\u001c8tK:\u001cXo]$f]\u0016\u0014\u0018\r^8s\rJ|Wn\u00138po:\u001c(BA\u0002\u0005\u0003%\u0019wN\\:f]N,8O\u0003\u0002\u0006\r\u0005Q\u0011\r\\4pe&$\b.\\:\u000b\u0005\u001dA\u0011\u0001B1eC6T!!\u0003\u0006\u0002\u0015\t$w-\u001a8p[&\u001c7OC\u0001\f\u0003\ry'oZ\u0002\u0001'\t\u0001a\u0002\u0005\u0002\u0010!5\t!!\u0003\u0002\u0012\u0005\t\u00112i\u001c8tK:\u001cXo]$f]\u0016\u0014\u0018\r^8s\u0011!\u0019\u0002A!A!\u0002\u0013!\u0012\u0001\u00024jY\u0016\u0004\"!F\u000e\u000f\u0005YIR\"A\f\u000b\u0003a\tQa]2bY\u0006L!AG\f\u0002\rA\u0013X\rZ3g\u0013\taRD\u0001\u0004TiJLgn\u001a\u0006\u00035]A\u0001b\b\u0001\u0003\u0002\u0003\u0006I\u0001I\u0001\u0003g\u000e\u0004\"!\t\u0014\u000e\u0003\tR!a\t\u0013\u0002\u000bM\u0004\u0018M]6\u000b\u0005\u0015R\u0011AB1qC\u000eDW-\u0003\u0002(E\ta1\u000b]1sW\u000e{g\u000e^3yi\")\u0011\u0006\u0001C\u0001U\u00051A(\u001b8jiz\"2a\u000b\u0017.!\ty\u0001\u0001C\u0003\u0014Q\u0001\u0007A\u0003C\u0003 Q\u0001\u0007\u0001\u0005C\u00040\u0001\t\u0007I\u0011\u0001\u0019\u0002\u0015%tG-\u001a7UC\ndW-F\u00012!\r\u0011TgN\u0007\u0002g)\u0011AGI\u0001\nEJ|\u0017\rZ2bgRL!AN\u001a\u0003\u0013\t\u0013x.\u00193dCN$\bC\u0001\u001d<\u001b\u0005I$B\u0001\u001e\u0007\u0003\u0019iw\u000eZ3mg&\u0011A(\u000f\u0002\u000b\u0013:$W\r\u001c+bE2,\u0007B\u0002 \u0001A\u0003%\u0011'A\u0006j]\u0012,G\u000eV1cY\u0016\u0004\u0003\"\u0002!\u0001\t\u0003\t\u0015\u0001\u0004;be\u001e,Go\u001d+p\u0003\u0012$G#\u0001\"\u0011\u0007Y\u0019U)\u0003\u0002E/\t1q\n\u001d;j_:\u00042AR%L\u001b\u00059%B\u0001%#\u0003\r\u0011H\rZ\u0005\u0003\u0015\u001e\u00131A\u0015#E!\tau*D\u0001N\u0015\tqE!A\tsK\u0006d\u0017n\u001a8nK:$H/\u0019:hKRL!\u0001U'\u0003-%sG-\u001a7SK\u0006d\u0017n\u001a8nK:$H+\u0019:hKRDQA\u0015\u0001\u0005\u0002M\u000bQ\u0004\u001d:faJ|7-Z:t%\u0016\fGm\u001d$peJ+\u0017\r\\5h]6,g\u000e\u001e\u000b\u0005)\u001aD'\u000eE\u0002V;\u0002t!AV.\u000f\u0005]SV\"\u0001-\u000b\u0005ec\u0011A\u0002\u001fs_>$h(C\u0001\u0019\u0013\tav#A\u0004qC\u000e\\\u0017mZ3\n\u0005y{&\u0001C%uKJ\f'\r\\3\u000b\u0005q;\u0002CA1e\u001b\u0005\u0011'BA2\u0007\u0003\u0011\u0011\u0018n\u00195\n\u0005\u0015\u0014'a\u0005*jG\"\fE.[4o[\u0016tGOU3d_J$\u0007\"B4R\u0001\u0004!\u0016!\u0002:fC\u0012\u001c\b\"B5R\u0001\u0004!\u0012!\u0003:fM\u0016\u0014XM\\2f\u0011\u0015Y\u0017\u000b1\u0001m\u0003\u0019\u0011XmZ5p]B\u0011\u0001(\\\u0005\u0003]f\u0012qBU3gKJ,gnY3SK\u001eLwN\u001c\u0005\u0006a\u0002!\t!]\u0001\u000eM&tGmQ8og\u0016t7/^:\u0015\u0005I4\bcA+^gB\u0011\u0001\b^\u0005\u0003kf\u0012\u0011bQ8og\u0016t7/^:\t\u000b\u001d|\u0007\u0019\u0001+")
public class ConsensusGeneratorFromKnowns
extends ConsensusGenerator {
    private final String file;
    private final SparkContext sc;
    private final Broadcast<IndelTable> indelTable;

    public Broadcast<IndelTable> indelTable() {
        return this.indelTable;
    }

    @Override
    public Option<RDD<IndelRealignmentTarget>> targetsToAdd() {
        ADAMVariationContext qual$1 = ADAMVariationContext$.MODULE$.sparkContextToADAMVariationContext(this.sc);
        String x$8 = this.file;
        Option<SequenceDictionary> x$9 = qual$1.adamVCFLoad$default$2();
        RDD<VariantContext> rdd = qual$1.adamVCFLoad(x$8, x$9);
        return new Some((Object)rdd.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Variant apply(VariantContext x$1) {
                return x$1.variant().variant();
            }
        }, ClassTag$.MODULE$.apply(Variant.class)).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Variant v) {
                return v.getReferenceAllele().length() != v.getAlternateAllele().length();
            }
        }).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final ReferenceRegion apply(Variant v) {
                return new ReferenceRegion(ADAMContext$.MODULE$.charSequenceToString(v.getContig().getContigName()), Predef$.MODULE$.Long2long(v.getStart()), Predef$.MODULE$.Long2long(v.getStart()) + (long)v.getReferenceAllele().length());
            }
        }, ClassTag$.MODULE$.apply(ReferenceRegion.class)).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final IndelRealignmentTarget apply(ReferenceRegion r) {
                return new IndelRealignmentTarget((Option<ReferenceRegion>)new Some((Object)r), r);
            }
        }, ClassTag$.MODULE$.apply(IndelRealignmentTarget.class)));
    }

    @Override
    public Iterable<RichAlignmentRecord> preprocessReadsForRealignment(Iterable<RichAlignmentRecord> reads, String reference, ReferenceRegion region) {
        return reads;
    }

    @Override
    public Iterable<Consensus> findConsensus(Iterable<RichAlignmentRecord> reads) {
        IndelTable table = (IndelTable)this.indelTable().value();
        long start2 = BoxesRunTime.unboxToLong((Object)((TraversableOnce)reads.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(RichAlignmentRecord x$2) {
                return Predef$.MODULE$.Long2long(x$2.record().getStart());
            }
        }, Iterable$.MODULE$.canBuildFrom())).reduce((Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(long x$3, long x$4) {
                return this.apply$mcJJJ$sp(x$3, x$4);
            }

            public long apply$mcJJJ$sp(long x$3, long x$4) {
                return BoxesRunTime.unboxToLong((Object)new RichLong(Predef$.MODULE$.longWrapper(x$3)).min((Object)BoxesRunTime.boxToLong((long)x$4)));
            }
        }));
        long end2 = BoxesRunTime.unboxToLong((Object)((TraversableOnce)reads.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(RichAlignmentRecord x$5) {
                return Predef$.MODULE$.Long2long(RichAlignmentRecord$.MODULE$.richRecordToRecord(x$5).getEnd());
            }
        }, Iterable$.MODULE$.canBuildFrom())).reduce((Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(long x$6, long x$7) {
                return this.apply$mcJJJ$sp(x$6, x$7);
            }

            public long apply$mcJJJ$sp(long x$6, long x$7) {
                return BoxesRunTime.unboxToLong((Object)new RichLong(Predef$.MODULE$.longWrapper(x$6)).max((Object)BoxesRunTime.boxToLong((long)x$7)));
            }
        }));
        CharSequence refId = ((RichAlignmentRecord)reads.head()).record().getContig().getContigName();
        ReferenceRegion region = new ReferenceRegion(ADAMContext$.MODULE$.charSequenceToString(refId), start2, end2 + 1L);
        return table.getIndelsInRegion(region);
    }

    public ConsensusGeneratorFromKnowns(String file, SparkContext sc) {
        this.file = file;
        this.sc = sc;
        this.indelTable = sc.broadcast((Object)IndelTable$.MODULE$.apply(file, sc), ClassTag$.MODULE$.apply(IndelTable.class));
    }
}

