/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.instrumentation;

import com.netflix.servo.monitor.LongGauge;
import com.netflix.servo.monitor.Monitor;
import com.netflix.servo.monitor.MonitorConfig;
import com.netflix.servo.tag.Tag;
import com.netflix.servo.tag.Tags;
import java.io.PrintStream;
import java.util.concurrent.TimeUnit;
import org.bdgenomics.adam.instrumentation.Alignment$;
import org.bdgenomics.adam.instrumentation.DurationFormatting$;
import org.bdgenomics.adam.instrumentation.MonitorTable;
import org.bdgenomics.adam.instrumentation.ServoTimer;
import org.bdgenomics.adam.instrumentation.ServoTimer$;
import org.bdgenomics.adam.instrumentation.SparkMetrics$;
import org.bdgenomics.adam.instrumentation.SparkMetrics$TimerOrdering$2$;
import org.bdgenomics.adam.instrumentation.TableHeader;
import org.bdgenomics.adam.instrumentation.TableHeader$;
import org.bdgenomics.adam.instrumentation.TaskTimer;
import org.bdgenomics.adam.instrumentation.ValueExtractor;
import org.bdgenomics.adam.instrumentation.ValueExtractor$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.VolatileObjectRef;

@ScalaSignature(bytes="\u0006\u0001\u00055h!B\u0001\u0003\u0003\u0003Y!\u0001D*qCJ\\W*\u001a;sS\u000e\u001c(BA\u0002\u0005\u0003=Ign\u001d;sk6,g\u000e^1uS>t'BA\u0003\u0007\u0003\u0011\tG-Y7\u000b\u0005\u001dA\u0011A\u00032eO\u0016tw.\\5dg*\t\u0011\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001\u0019A\u0011Q\u0002E\u0007\u0002\u001d)\tq\"A\u0003tG\u0006d\u0017-\u0003\u0002\u0012\u001d\t1\u0011I\\=SK\u001aDQa\u0005\u0001\u0005\u0002Q\ta\u0001P5oSRtD#A\u000b\u0011\u0005Y\u0001Q\"\u0001\u0002\t\u000fa\u0001!\u0019!C\u00053\u0005QA/Y:l)&lWM]:\u0016\u0003i\u00012a\u0007\u0011#\u001b\u0005a\"BA\u000f\u001f\u0003\u001diW\u000f^1cY\u0016T!a\b\b\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002\"9\tY\u0011I\u001d:bs\n+hMZ3s!\t12%\u0003\u0002%\u0005\tIA+Y:l)&lWM\u001d\u0005\u0007M\u0001\u0001\u000b\u0011\u0002\u000e\u0002\u0017Q\f7o\u001b+j[\u0016\u00148\u000f\t\u0005\bQ\u0001\u0011\r\u0011\"\u0003*\u00035\u0019H/Y4f\u0013\u0012$vNT1nKV\t!\u0006\u0005\u0003\u001cW5\u0002\u0014B\u0001\u0017\u001d\u0005\u001dA\u0015m\u001d5NCB\u0004\"!\u0004\u0018\n\u0005=r!aA%oiB\u0011\u0011\u0007\u000e\b\u0003\u001bIJ!a\r\b\u0002\rA\u0013X\rZ3g\u0013\t)dG\u0001\u0004TiJLgn\u001a\u0006\u0003g9Aa\u0001\u000f\u0001!\u0002\u0013Q\u0013AD:uC\u001e,\u0017\n\u001a+p\u001d\u0006lW\r\t\u0005\tu\u0001\u0011\r\u0011\"\u0001\u0003w\u0005Q1\u000f^1hKRKW.Z:\u0016\u0003q\u0002BaG\u00161{A\u0011ahR\u0007\u0002\u007f)\u0011\u0001)Q\u0001\b[>t\u0017\u000e^8s\u0015\t\u00115)A\u0003tKJ4xN\u0003\u0002E\u000b\u00069a.\u001a;gY&D(\"\u0001$\u0002\u0007\r|W.\u0003\u0002I\u007f\tIAj\u001c8h\u000f\u0006,x-\u001a\u0005\u0007\u0015\u0002\u0001\u000b\u0011\u0002\u001f\u0002\u0017M$\u0018mZ3US6,7\u000f\t\u0005\u0006\u0019\u0002!\t!T\u0001\u0006aJLg\u000e\u001e\u000b\u0003\u001dF\u0003\"!D(\n\u0005As!\u0001B+oSRDQAU&A\u0002M\u000b1a\\;u!\t!\u0016,D\u0001V\u0015\t1v+\u0001\u0002j_*\t\u0001,\u0001\u0003kCZ\f\u0017B\u0001.V\u0005-\u0001&/\u001b8u'R\u0014X-Y7\t\u000bq\u0003A\u0011A/\u0002!5\f\u0007o\u0015;bO\u0016LE\rV8OC6,Gc\u0001(_A\")ql\u0017a\u0001[\u000591\u000f^1hK&#\u0007\"B1\\\u0001\u0004\u0001\u0014!C:uC\u001e,g*Y7f\u0011\u0015\u0019\u0007\u0001\"\u0001e\u0003M\u0011XmY8sIN#\u0018mZ3EkJ\fG/[8o)\u0011)\u0007.[6\u0011\u000751W(\u0003\u0002h\u001d\t1q\n\u001d;j_:DQa\u00182A\u00025BQ!\u00192A\u0002)\u00042!\u000441\u0011\u0015a'\r1\u0001n\u0003!!WO]1uS>t\u0007C\u00018s\u001b\u0005y'B\u00017q\u0015\t\th\"\u0001\u0006d_:\u001cWO\u001d:f]RL!a]8\u0003\u0011\u0011+(/\u0019;j_:DQ!\u001e\u0001\u0005\u0012Y\f\u0011\u0002^1tWRKW.\u001a:\u0015\u0005\t:\b\"\u0002=u\u0001\u0004\u0001\u0014\u0001\u00028b[\u0016DQA\u001f\u0001\u0005\nm\f1bZ3u\u001fJ$WM]5oOR\u0019A0a\u0006\u0011\u000bu\fY!!\u0005\u000f\u0007y\f9AD\u0002\u0000\u0003\u000bi!!!\u0001\u000b\u0007\u0005\r!\"\u0001\u0004=e>|GOP\u0005\u0002\u001f%\u0019\u0011\u0011\u0002\b\u0002\u000fA\f7m[1hK&!\u0011QBA\b\u0005!y%\u000fZ3sS:<'bAA\u0005\u001dA\u0019a#a\u0005\n\u0007\u0005U!A\u0001\u0006TKJ4x\u000eV5nKJDq!!\u0007z\u0001\u0004\tY\"\u0001\u0004uS6,'o\u001d\t\u0006{\u0006u\u0011\u0011C\u0005\u0005\u0003?\tyAA\u0002TKFDq!a\t\u0001\t\u0013\t)#\u0001\u0007hKR\u001cvN\u001d;Pe\u0012,'\u000f\u0006\u0003\u0002(\u00055\u0002#B\u0019\u0002*Aj\u0013bAA\u0016m\t\u0019Q*\u00199\t\u0011\u0005e\u0011\u0011\u0005a\u0001\u00037Aq!!\r\u0001\t\u0013\t\u0019$A\fde\u0016\fG/Z*uC\u001e,G)\u001e:bi&|gNU8xgR\u0011\u0011Q\u0007\t\u0005{\u0006uQ\bC\u0004\u0002:\u0001!I!a\u000f\u00025\r\u0014X-\u0019;f'R\fw-\u001a#ve\u0006$\u0018n\u001c8N_:LGo\u001c:\u0015\u000bu\ni$a\u0010\t\ra\f9\u00041\u00011\u0011\u0019a\u0017q\u0007a\u0001[\"9\u00111\t\u0001\u0005\n\u0005\u0015\u0013\u0001D1eIN#\u0018mZ3OC6,G\u0003BA\t\u0003\u000fB\u0001\"!\u0013\u0002B\u0001\u0007\u00111J\u0001\u0010gR\fw-Z%e\u0003:$G+[7feB1Q\"!\u0014.\u0003#I1!a\u0014\u000f\u0005\u0019!V\u000f\u001d7fe!9\u00111\u000b\u0001\u0005\n\u0005U\u0013\u0001\u00064pe6\fGo\u0015;bO\u0016LE-\u00118e\u001d\u0006lW\rF\u00031\u0003/\nI\u0006\u0003\u0004`\u0003#\u0002\r!\f\u0005\u0007C\u0006E\u0003\u0019\u00016\t\u000f\u0005u\u0003\u0001\"\u0003\u0002`\u0005Y!/\u001a8eKJ$\u0016M\u00197f)%q\u0015\u0011MA2\u0003K\n9\t\u0003\u0004S\u00037\u0002\ra\u0015\u0005\u0007q\u0006m\u0003\u0019\u0001\u0019\t\u0011\u0005e\u00111\fa\u0001\u0003O\u0002R!`A\u000f\u0003S\u0002D!a\u001b\u0002vA)a(!\u001c\u0002r%\u0019\u0011qN \u0003\u000f5{g.\u001b;peB!\u00111OA;\u0019\u0001!A\"a\u001e\u0002f\u0005\u0005\t\u0011!B\u0001\u0003s\u00121a\u0018\u00132#\u0011\tY(!!\u0011\u00075\ti(C\u0002\u0002\u00009\u0011qAT8uQ&tw\rE\u0002\u000e\u0003\u0007K1!!\"\u000f\u0005\r\te.\u001f\u0005\t\u0003\u0013\u000bY\u00061\u0001\u0002\f\u00061\u0001.Z1eKJ\u0004Ba\u0007\u0011\u0002\u000eB\u0019a#a$\n\u0007\u0005E%AA\u0006UC\ndW\rS3bI\u0016\u0014\bbBAK\u0001\u0011%\u0011qS\u0001\u0011GJ,\u0017\r^3IK\u0006$WM],ji\"$b!a#\u0002\u001a\u0006m\u0005\u0002CAE\u0003'\u0003\r!!$\t\u000f\u0005u\u00151\u0013a\u0001[\u0005A\u0001o\\:ji&|g\u000eC\u0004\u0002\"\u0002!I!a)\u0002#\r\u0014X-\u0019;f'R\fw-\u001a%fC\u0012,'\u000f\u0006\u0002\u0002\f\"9\u0011q\u0015\u0001\u0005\n\u0005\r\u0016\u0001E2sK\u0006$X\rV1tW\"+\u0017\rZ3s\u0011\u001d\tY\u000b\u0001C\u0005\u0003[\u000b1BZ8s[\u0006$h*\u00198pgR\u0019\u0001'a,\t\u0011\u0005E\u0016\u0011\u0016a\u0001\u0003\u0003\u000baA\\;nE\u0016\u0014xaBA[\u0005!E\u0011qW\u0001\r'B\f'o['fiJL7m\u001d\t\u0004-\u0005efAB\u0001\u0003\u0011#\tYlE\u0002\u0002:2AqaEA]\t\u0003\ty\f\u0006\u0002\u00028\"Q\u00111YA]\u0005\u0004%)!!2\u0002\u0015!{7\u000f\u001e+bO.+\u00170\u0006\u0002\u0002H>\u0011\u0011\u0011Z\u0011\u0003\u0003\u0017\fA\u0001[8ti\"I\u0011qZA]A\u00035\u0011qY\u0001\f\u0011>\u001cH\u000fV1h\u0017\u0016L\b\u0005\u0003\u0006\u0002T\u0006e&\u0019!C\u0003\u0003+\fqb\u0015;bO\u0016t\u0015-\\3UC\u001e\\U-_\u000b\u0003\u0003/|!!!7\"\u0003\u0005D\u0011\"!8\u0002:\u0002\u0006i!a6\u0002!M#\u0018mZ3OC6,G+Y4LKf\u0004\u0003BCAq\u0003s\u0013\r\u0011\"\u0002\u0002d\u0006i1\u000b^1hK&#G+Y4LKf,\"!!:\u0010\u0005\u0005\u001d\u0018%A0\t\u0013\u0005-\u0018\u0011\u0018Q\u0001\u000e\u0005\u0015\u0018AD*uC\u001e,\u0017\n\u001a+bO.+\u0017\u0010\t")
public abstract class SparkMetrics {
    private final ArrayBuffer<TaskTimer> taskTimers = new ArrayBuffer();
    private final HashMap<Object, String> stageIdToName = new HashMap();
    private final HashMap<String, LongGauge> stageTimes = new HashMap();

    public static String StageIdTagKey() {
        return SparkMetrics$.MODULE$.StageIdTagKey();
    }

    public static String StageNameTagKey() {
        return SparkMetrics$.MODULE$.StageNameTagKey();
    }

    public static String HostTagKey() {
        return SparkMetrics$.MODULE$.HostTagKey();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SparkMetrics$TimerOrdering$2$ org$bdgenomics$adam$instrumentation$SparkMetrics$$TimerOrdering$1$lzycompute(Map x$1, VolatileObjectRef x$2) {
        SparkMetrics sparkMetrics = this;
        synchronized (sparkMetrics) {
            if (x$2.elem != null) return (SparkMetrics$TimerOrdering$2$)x$2.elem;
            x$2.elem = new SparkMetrics$TimerOrdering$2$(this, x$1, x$2);
            return (SparkMetrics$TimerOrdering$2$)x$2.elem;
        }
    }

    private ArrayBuffer<TaskTimer> taskTimers() {
        return this.taskTimers;
    }

    private HashMap<Object, String> stageIdToName() {
        return this.stageIdToName;
    }

    public HashMap<String, LongGauge> stageTimes() {
        return this.stageTimes;
    }

    public void print(PrintStream out) {
        Seq<LongGauge> stageMonitors = this.createStageDurationRows();
        ArrayBuffer overallMonitors = (ArrayBuffer)((SeqLike)this.taskTimers().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final ServoTimer apply(TaskTimer x$1) {
                return x$1.getOverallTimings();
            }
        }, ArrayBuffer$.MODULE$.canBuildFrom())).sortBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(ServoTimer x$2) {
                return -x$2.getTotalTime();
            }
        }, (Ordering)Ordering.Long$.MODULE$);
        Ordering<ServoTimer> ordering = this.getOrdering((Seq<ServoTimer>)overallMonitors);
        ArrayBuffer monitorsByHost = (ArrayBuffer)((SeqLike)this.taskTimers().flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Iterable<ServoTimer> apply(TaskTimer x$3) {
                return x$3.getHostTimings();
            }
        }, ArrayBuffer$.MODULE$.canBuildFrom())).sorted(ordering);
        ArrayBuffer monitorsByStageName = (ArrayBuffer)((SeqLike)((TraversableLike)this.taskTimers().flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<Tuple2<Object, ServoTimer>> apply(TaskTimer x$4) {
                return x$4.getStageTimings();
            }
        }, ArrayBuffer$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SparkMetrics $outer;

            public final ServoTimer apply(Tuple2<Object, ServoTimer> stageIdAndTimer) {
                return this.$outer.org$bdgenomics$adam$instrumentation$SparkMetrics$$addStageName(stageIdAndTimer);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, ArrayBuffer$.MODULE$.canBuildFrom())).sorted(ordering);
        this.renderTable(out, "Stage Durations", stageMonitors, this.createStageHeader());
        out.println();
        this.renderTable(out, "Task Timings", (Seq<Monitor<?>>)overallMonitors, this.createTaskHeader());
        out.println();
        String x$7 = "Host";
        ValueExtractor x$8 = ValueExtractor$.MODULE$.forTagValueWithKey("host");
        Enumeration.Value x$9 = Alignment$.MODULE$.Left();
        Option<Function1<Object, String>> x$10 = TableHeader$.MODULE$.apply$default$3();
        this.renderTable(out, "Task Timings By Host", (Seq<Monitor<?>>)monitorsByHost, this.createHeaderWith(new TableHeader(x$7, x$8, x$10, x$9), 1));
        out.println();
        String x$11 = "Stage ID & Name";
        ValueExtractor x$12 = ValueExtractor$.MODULE$.forTagValueWithKey("stageName");
        Enumeration.Value x$13 = Alignment$.MODULE$.Left();
        Option<Function1<Object, String>> x$14 = TableHeader$.MODULE$.apply$default$3();
        this.renderTable(out, "Task Timings By Stage", (Seq<Monitor<?>>)monitorsByStageName, this.createHeaderWith(new TableHeader(x$11, x$12, x$14, x$13), 1));
    }

    public void mapStageIdToName(int stageId, String stageName) {
        this.stageIdToName().put((Object)BoxesRunTime.boxToInteger((int)stageId), (Object)stageName);
    }

    public Option<LongGauge> recordStageDuration(int stageId, Option<String> stageName, Duration duration) {
        String stageIdAndName = this.formatStageIdAndName(stageId, stageName);
        LongGauge gauge = this.createStageDurationMonitor(stageIdAndName, duration);
        return this.stageTimes().put((Object)stageIdAndName, (Object)gauge);
    }

    /*
     * WARNING - void declaration
     */
    public TaskTimer taskTimer(String name2) {
        void var2_2;
        TaskTimer timer = new TaskTimer(name2);
        this.taskTimers().$plus$eq((Object)timer);
        return var2_2;
    }

    private Ordering<ServoTimer> getOrdering(Seq<ServoTimer> timers) {
        VolatileObjectRef TimerOrdering$module = new VolatileObjectRef(null);
        Map<String, Object> sortOrderMap = this.getSortOrder(timers);
        return this.org$bdgenomics$adam$instrumentation$SparkMetrics$$TimerOrdering$1(sortOrderMap, TimerOrdering$module);
    }

    private Map<String, Object> getSortOrder(Seq<ServoTimer> timers) {
        IntRef sortOrder = new IntRef(0);
        return ((TraversableOnce)timers.map((Function1)new Serializable(this, sortOrder){
            public static final long serialVersionUID = 0L;
            private final IntRef sortOrder$1;

            public final Tuple2<String, Object> apply(ServoTimer timer) {
                ++this.sortOrder$1.elem;
                return new Tuple2((Object)timer.getName(), (Object)BoxesRunTime.boxToInteger((int)this.sortOrder$1.elem));
            }
            {
                this.sortOrder$1 = sortOrder$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
    }

    /*
     * WARNING - void declaration
     */
    private Seq<LongGauge> createStageDurationRows() {
        void var2_2;
        Buffer unsortedStageMonitors = this.stageTimes().values().toBuffer();
        Buffer stageMonitors = (Buffer)unsortedStageMonitors.sortBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(LongGauge x$5) {
                return -x$5.getNumber().longValue();
            }
        }, (Ordering)Ordering.Long$.MODULE$);
        long stagesTotal = BoxesRunTime.unboxToLong((Object)((TraversableOnce)stageMonitors.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(LongGauge x$6) {
                return x$6.getNumber().longValue();
            }
        }, Buffer$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        stageMonitors.$plus$eq((Object)this.createStageDurationMonitor("TOTAL", (Duration)Duration$.MODULE$.apply(stagesTotal, TimeUnit.NANOSECONDS)));
        return var2_2;
    }

    private LongGauge createStageDurationMonitor(String name2, Duration duration) {
        Tag tag = Tags.newTag((String)"stageName", (String)name2);
        LongGauge gauge = new LongGauge(MonitorConfig.builder((String)name2).withTag(tag).build());
        gauge.set(Predef$.MODULE$.long2Long(duration.toNanos()));
        return gauge;
    }

    public ServoTimer org$bdgenomics$adam$instrumentation$SparkMetrics$$addStageName(Tuple2<Object, ServoTimer> stageIdAndTimer) {
        String stageIdAndName = this.formatStageIdAndName(stageIdAndTimer._1$mcI$sp(), (Option<String>)this.stageIdToName().get((Object)BoxesRunTime.boxToInteger((int)stageIdAndTimer._1$mcI$sp())));
        ((ServoTimer)stageIdAndTimer._2()).addTag(Tags.newTag((String)"stageName", (String)stageIdAndName));
        return (ServoTimer)stageIdAndTimer._2();
    }

    private String formatStageIdAndName(int stageId, Option<String> stageName) {
        return new StringBuilder().append(stageId).append((Object)": ").append(stageName.getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "unknown";
            }
        })).toString();
    }

    private void renderTable(PrintStream out, String name2, Seq<Monitor<?>> timers, ArrayBuffer<TableHeader> header) {
        MonitorTable monitorTable = new MonitorTable((TableHeader[])header.toArray(ClassTag$.MODULE$.apply(TableHeader.class)), (Monitor[])timers.toArray(ClassTag$.MODULE$.apply(Monitor.class)));
        out.println(name2);
        monitorTable.print(out);
    }

    /*
     * WARNING - void declaration
     */
    private ArrayBuffer<TableHeader> createHeaderWith(TableHeader header, int position) {
        void var3_3;
        ArrayBuffer<TableHeader> baseHeader = this.createTaskHeader();
        baseHeader.insert(position, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new TableHeader[]{header}));
        return var3_3;
    }

    private ArrayBuffer<TableHeader> createStageHeader() {
        TableHeader[] tableHeaderArray = new TableHeader[2];
        String x$15 = "Stage ID & Name";
        ValueExtractor x$16 = ValueExtractor$.MODULE$.forTagValueWithKey("stageName");
        Enumeration.Value x$17 = Alignment$.MODULE$.Left();
        Option<Function1<Object, String>> x$18 = TableHeader$.MODULE$.apply$default$3();
        tableHeaderArray[0] = new TableHeader(x$15, x$16, x$18, x$17);
        tableHeaderArray[1] = new TableHeader("Duration", ValueExtractor$.MODULE$.forMonitorValue(), (Option<Function1<Object, String>>)new Some((Object)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SparkMetrics $outer;

            public final String apply(Object number) {
                return this.$outer.org$bdgenomics$adam$instrumentation$SparkMetrics$$formatNanos(number);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }), TableHeader$.MODULE$.apply$default$4());
        return (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tableHeaderArray));
    }

    private ArrayBuffer<TableHeader> createTaskHeader() {
        TableHeader[] tableHeaderArray = new TableHeader[6];
        String x$19 = "Metric";
        ValueExtractor x$20 = ValueExtractor$.MODULE$.forTagValueWithKey("name");
        Enumeration.Value x$21 = Alignment$.MODULE$.Left();
        Option<Function1<Object, String>> x$22 = TableHeader$.MODULE$.apply$default$3();
        tableHeaderArray[0] = new TableHeader(x$19, x$20, x$22, x$21);
        tableHeaderArray[1] = new TableHeader("Total Time", ValueExtractor$.MODULE$.forMonitorMatchingTag(ServoTimer$.MODULE$.TotalTimeTag()), (Option<Function1<Object, String>>)new Some((Object)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SparkMetrics $outer;

            public final String apply(Object number) {
                return this.$outer.org$bdgenomics$adam$instrumentation$SparkMetrics$$formatNanos(number);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }), TableHeader$.MODULE$.apply$default$4());
        tableHeaderArray[2] = new TableHeader("Count", ValueExtractor$.MODULE$.forMonitorMatchingTag(ServoTimer$.MODULE$.CountTag()), TableHeader$.MODULE$.apply$default$3(), TableHeader$.MODULE$.apply$default$4());
        tableHeaderArray[3] = new TableHeader("Mean", ValueExtractor$.MODULE$.forMonitorMatchingTag(ServoTimer$.MODULE$.MeanTag()), (Option<Function1<Object, String>>)new Some((Object)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SparkMetrics $outer;

            public final String apply(Object number) {
                return this.$outer.org$bdgenomics$adam$instrumentation$SparkMetrics$$formatNanos(number);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }), TableHeader$.MODULE$.apply$default$4());
        tableHeaderArray[4] = new TableHeader("Min", ValueExtractor$.MODULE$.forMonitorMatchingTag(ServoTimer$.MODULE$.MinTag()), (Option<Function1<Object, String>>)new Some((Object)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SparkMetrics $outer;

            public final String apply(Object number) {
                return this.$outer.org$bdgenomics$adam$instrumentation$SparkMetrics$$formatNanos(number);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }), TableHeader$.MODULE$.apply$default$4());
        tableHeaderArray[5] = new TableHeader("Max", ValueExtractor$.MODULE$.forMonitorMatchingTag(ServoTimer$.MODULE$.MaxTag()), (Option<Function1<Object, String>>)new Some((Object)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SparkMetrics $outer;

            public final String apply(Object number) {
                return this.$outer.org$bdgenomics$adam$instrumentation$SparkMetrics$$formatNanos(number);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }), TableHeader$.MODULE$.apply$default$4());
        return (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tableHeaderArray));
    }

    public String org$bdgenomics$adam$instrumentation$SparkMetrics$$formatNanos(Object number) {
        Object object = number;
        if (object instanceof Number) {
            Number number2 = (Number)object;
            String string = DurationFormatting$.MODULE$.formatNanosecondDuration(number2);
            return string;
        }
        throw new IllegalArgumentException(new StringBuilder().append((Object)"Cannot format non-numeric value [").append(number).append((Object)"]").toString());
    }

    public final SparkMetrics$TimerOrdering$2$ org$bdgenomics$adam$instrumentation$SparkMetrics$$TimerOrdering$1(Map sortOrderMap$1, VolatileObjectRef TimerOrdering$module$1) {
        return TimerOrdering$module$1.elem == null ? this.org$bdgenomics$adam$instrumentation$SparkMetrics$$TimerOrdering$1$lzycompute(sortOrderMap$1, TimerOrdering$module$1) : (SparkMetrics$TimerOrdering$2$)TimerOrdering$module$1.elem;
    }
}

